# Copyright 2024-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
"

RUST_MIN_VER="1.88.0"
inherit cargo

DESCRIPTION="Stalwart Mail Server command line utility"
HOMEPAGE="https://stalw.art"
SRC_URI="https://github.com/stalwartlabs/stalwart/archive/refs/tags/v${PV}.tar.gz -> stalwart-mail-${PV}.tar.gz
	${CARGO_CRATE_URIS}
"
if [[ ${PKGBUMPING} != ${PVR} ]]; then
	SRC_URI+="
		https://dev.gentoo.org/~lordvan/stalwart-0.15.5-crates.tar.xz
	"
fi

S="${WORKDIR}/stalwart-${PV}"

LICENSE="|| ( AGPL-3 )"
# Dependent crate licenses
LICENSE+="
	AGPL-3 Apache-2.0 BSD-2 BSD Boost-1.0 CC0-1.0 CDLA-Permissive-2.0
	ISC LGPL-2+ MIT MPL-2.0 Unicode-3.0 ZLIB BZIP2
"

# 0.14.x has breaking changes so avoid installing new cli with old server
DEPEND+="
	!!<net-mail/stalwart-mail-0.15.0
"

SLOT="0"
KEYWORDS="~amd64"

src_compile() {
	cargo_src_compile --bin stalwart-cli
}

src_install() {
	cargo_src_install --path crates/cli
}

pkg_postinst() {
	ewarn "If you are upgrading from v0.14.1 and below, this version includes"
	ewarn "breaking changes to the internal directory, calendar and contacts."
	ewarn "Please read the upgrading documentation for more information on "
	ewarn "how to upgrade from previous versions."
	ewarn "It can be found here: https://stalw.art/docs/install/upgrade/"
	ewarn "0.15 upgrade instructions are here:"
	ewarn "https://github.com/stalwartlabs/stalwart/blob/main/UPGRADING/v0_15.md"
}
