/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yue_Hans extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "阿拉伯文";
        final String metaValue_hy = "亚美尼亚文";
        final String metaValue_ban = "峇里文";
        final String metaValue_bax = "巴姆穆文";
        final String metaValue_bas = "巴萨文";
        final String metaValue_bn = "孟加拉文";
        final String metaValue_bug = "布吉斯文";
        final String metaValue_ccp = "查克马文";
        final String metaValue_chr = "柴罗基文";
        final String metaValue_cop = "科普特文";
        final String metaValue_ka = "乔治亚文";
        final String metaValue_el = "希腊文";
        final String metaValue_gu = "古吉拉特文";
        final String metaValue_he = "希伯来文";
        final String metaValue_jv = "爪哇文";
        final String metaValue_ja = "日文";
        final String metaValue_km = "高棉文";
        final String metaValue_kn = "坎那达文";
        final String metaValue_ko = "韩文";
        final String metaValue_la = "拉丁文";
        final String metaValue_men = "门德文";
        final String metaValue_ml = "马来亚拉姆文";
        final String metaValue_mn = "蒙古文";
        final String metaValue_my = "缅甸文";
        final String metaValue_or = "欧利亚文";
        final String metaValue_phn = "腓尼基文";
        final String metaValue_saz = "索拉什特拉文";
        final String metaValue_sd = "信德文";
        final String metaValue_su = "巽他文";
        final String metaValue_ta = "坦米尔文";
        final String metaValue_te = "泰卢固文";
        final String metaValue_th = "泰文";
        final String metaValue_mai = "迈蒂利文";
        final String metaValue_uga = "乌加列文";
        final String metaValue_peo = "古波斯文";
        final String metaValue_ssy = "萨霍文";
        final String metaValue_type_nu_taml = "坦米尔数字";
        final Object[][] data = new Object[][] {
            { "001", "世界" },
            { "002", "非洲" },
            { "003", "北美洲" },
            { "005", "南美洲" },
            { "009", "大洋洲" },
            { "011", "西非" },
            { "013", "中美" },
            { "014", "东非" },
            { "015", "北非" },
            { "017", "中非" },
            { "018", "非洲南部" },
            { "019", "美洲" },
            { "021", "北美" },
            { "029", "加勒比海" },
            { "030", "东亚" },
            { "034", "南亚" },
            { "035", "东南亚" },
            { "039", "南欧" },
            { "053", "澳洲同纽西兰" },
            { "054", "美拉尼西亚" },
            { "057", "密克罗尼西亚" },
            { "061", "玻里尼西亚" },
            { "142", "亚洲" },
            { "143", "中亚" },
            { "145", "西亚" },
            { "150", "欧洲" },
            { "151", "东欧" },
            { "154", "北欧" },
            { "155", "西欧" },
            { "202", "撒哈拉以南非洲" },
            { "419", "拉丁美洲" },
            { "AC", "阿森松岛" },
            { "AD", "安道尔" },
            { "AE", "阿拉伯联合大公国" },
            { "AF", "阿富汗" },
            { "AG", "安提瓜同巴布达" },
            { "AI", "安圭拉" },
            { "AL", "阿尔巴尼亚" },
            { "AM", "亚美尼亚" },
            { "AO", "安哥拉" },
            { "AQ", "南极洲" },
            { "AR", "阿根廷" },
            { "AS", "美属萨摩亚" },
            { "AT", "奥地利" },
            { "AU", "澳洲" },
            { "AW", "荷属阿鲁巴" },
            { "AX", "奥兰群岛" },
            { "AZ", "阿塞拜疆" },
            { "BA", "波斯尼亚同黑塞哥维那" },
            { "BB", "巴贝多" },
            { "BD", "孟加拉" },
            { "BE", "比利时" },
            { "BF", "布吉纳法索" },
            { "BG", "保加利亚" },
            { "BH", "巴林" },
            { "BI", "蒲隆地" },
            { "BJ", "贝南" },
            { "BL", "圣巴瑟米" },
            { "BM", "百慕达" },
            { "BN", "汶莱" },
            { "BO", "玻利维亚" },
            { "BQ", "荷兰加勒比区" },
            { "BR", "巴西" },
            { "BS", "巴哈马" },
            { "BT", "不丹" },
            { "BV", "布威岛" },
            { "BW", "波札那" },
            { "BY", "白俄罗斯" },
            { "BZ", "贝里斯" },
            { "CA", "加拿大" },
            { "CC", "科科斯（基林）群岛" },
            { "CD", "刚果（金夏沙）" },
            { "CF", "中非共和国" },
            { "CG", "刚果（布拉萨）" },
            { "CH", "瑞士" },
            { "CI", "象牙海岸" },
            { "CK", "库克群岛" },
            { "CL", "智利" },
            { "CM", "喀麦隆" },
            { "CN", "中国" },
            { "CO", "哥伦比亚" },
            { "CP", "克里派顿岛" },
            { "CQ", "萨克" },
            { "CR", "哥斯大黎加" },
            { "CU", "古巴" },
            { "CV", "维德角" },
            { "CW", "库拉索" },
            { "CX", "圣诞岛" },
            { "CY", "赛普勒斯" },
            { "CZ", "捷克" },
            { "DE", "德国" },
            { "DG", "迪亚哥加西亚岛" },
            { "DJ", "吉布地" },
            { "DK", "丹麦" },
            { "DM", "多米尼克" },
            { "DO", "多明尼加共和国" },
            { "DZ", "阿尔及利亚" },
            { "EA", "休达与梅利利亚" },
            { "EC", "厄瓜多" },
            { "EE", "爱沙尼亚" },
            { "EG", "埃及" },
            { "EH", "西撒哈拉" },
            { "ER", "厄利垂亚" },
            { "ES", "西班牙" },
            { "ET", "衣索比亚" },
            { "EU", "欧盟" },
            { "EZ", "欧元区" },
            { "FI", "芬兰" },
            { "FJ", "斐济" },
            { "FK", "福克兰群岛" },
            { "FM", "密克罗尼西亚群岛" },
            { "FO", "法罗群岛" },
            { "FR", "法国" },
            { "GA", "加彭" },
            { "GB", "英国" },
            { "GD", "格瑞那达" },
            { "GE", "格鲁吉亚" },
            { "GF", "法属圭亚那" },
            { "GG", "根西岛" },
            { "GH", "迦纳" },
            { "GI", "直布罗陀" },
            { "GL", "格陵兰" },
            { "GM", "甘比亚" },
            { "GN", "几内亚" },
            { "GP", "瓜地洛普" },
            { "GQ", "赤道几内亚" },
            { "GR", "希腊" },
            { "GS", "南佐治亚岛同南桑威奇群岛" },
            { "GT", "瓜地马拉" },
            { "GU", "关岛" },
            { "GW", "几内亚比索" },
            { "GY", "盖亚那" },
            { "HK", "中国香港特别行政区" },
            { "HM", "赫德岛同麦克唐纳群岛" },
            { "HN", "宏都拉斯" },
            { "HR", "克罗埃西亚" },
            { "HT", "海地" },
            { "HU", "匈牙利" },
            { "IC", "加那利群岛" },
            { "ID", "印尼" },
            { "IE", "爱尔兰" },
            { "IL", "以色列" },
            { "IM", "曼岛" },
            { "IN", "印度" },
            { "IO", "英属印度洋领地" },
            { "IQ", "伊拉克" },
            { "IR", "伊朗" },
            { "IS", "冰岛" },
            { "IT", "意大利" },
            { "JE", "泽西岛" },
            { "JM", "牙买加" },
            { "JO", "约旦" },
            { "JP", "日本" },
            { "KE", "肯亚" },
            { "KG", "吉尔吉斯" },
            { "KH", "柬埔寨" },
            { "KI", "吉里巴斯" },
            { "KM", "葛摩" },
            { "KN", "圣基茨同尼维斯" },
            { "KP", "北韩" },
            { "KR", "南韩" },
            { "KW", "科威特" },
            { "KY", "开曼群岛" },
            { "KZ", "哈萨克" },
            { "LA", "老挝" },
            { "LB", "黎巴嫩" },
            { "LC", "圣露西亚" },
            { "LI", "列支敦斯登" },
            { "LK", "斯里兰卡" },
            { "LR", "赖比瑞亚" },
            { "LS", "赖索托" },
            { "LT", "立陶宛" },
            { "LU", "卢森堡" },
            { "LV", "拉脱维亚" },
            { "LY", "利比亚" },
            { "MA", "摩洛哥" },
            { "MC", "摩纳哥" },
            { "MD", "摩尔多瓦" },
            { "ME", "蒙特内哥罗" },
            { "MF", "法属圣马丁" },
            { "MG", "马达加斯加" },
            { "MH", "马绍尔群岛" },
            { "MK", "北马其顿" },
            { "ML", "马利" },
            { "MM", "缅甸" },
            { "MN", "蒙古" },
            { "MO", "中国澳门特别行政区" },
            { "MP", "北马里亚纳群岛" },
            { "MQ", "马丁尼克岛" },
            { "MR", "茅利塔尼亚" },
            { "MS", "蒙哲腊" },
            { "MT", "马尔他" },
            { "MU", "模里西斯" },
            { "MV", "马尔地夫" },
            { "MW", "马拉威" },
            { "MX", "墨西哥" },
            { "MY", "马来西亚" },
            { "MZ", "莫三比克" },
            { "NA", "纳米比亚" },
            { "NC", "新喀里多尼亚" },
            { "NE", "尼日" },
            { "NF", "诺福克岛" },
            { "NG", "奈及利亚" },
            { "NI", "尼加拉瓜" },
            { "NL", "荷兰" },
            { "NO", "挪威" },
            { "NP", "尼泊尔" },
            { "NR", "诺鲁" },
            { "NU", "纽埃岛" },
            { "NZ", "新西兰" },
            { "OM", "阿曼王国" },
            { "PA", "巴拿马" },
            { "PE", "秘鲁" },
            { "PF", "法属玻里尼西亚" },
            { "PG", "巴布亚纽几内亚" },
            { "PH", "菲律宾" },
            { "PK", "巴基斯坦" },
            { "PL", "波兰" },
            { "PM", "圣皮埃尔同密克隆群岛" },
            { "PN", "皮特肯群岛" },
            { "PR", "波多黎各" },
            { "PS", "巴勒斯坦自治区" },
            { "PT", "葡萄牙" },
            { "PW", "帛琉" },
            { "PY", "巴拉圭" },
            { "QA", "卡达" },
            { "QO", "大洋洲边疆群岛" },
            { "RE", "留尼旺" },
            { "RO", "罗马尼亚" },
            { "RS", "塞尔维亚" },
            { "RU", "俄罗斯" },
            { "RW", "卢安达" },
            { "SA", "沙特阿拉伯" },
            { "SB", "索罗门群岛" },
            { "SC", "塞席尔" },
            { "SD", "苏丹" },
            { "SE", "瑞典" },
            { "SG", "新加坡" },
            { "SH", "圣赫勒拿岛" },
            { "SI", "斯洛维尼亚" },
            { "SJ", "斯瓦尔巴特群岛同扬马延岛" },
            { "SK", "斯洛伐克" },
            { "SL", "狮子山" },
            { "SM", "圣马利诺" },
            { "SN", "塞内加尔" },
            { "SO", "索马利亚" },
            { "SR", "苏利南" },
            { "SS", "南苏丹" },
            { "ST", "圣多美同普林西比" },
            { "SV", "萨尔瓦多" },
            { "SX", "荷属圣马丁" },
            { "SY", "叙利亚" },
            { "SZ", "史瓦济兰" },
            { "TA", "特里斯坦达库尼亚群岛" },
            { "TC", "土克斯及开科斯群岛" },
            { "TD", "查德" },
            { "TF", "法属南方属地" },
            { "TG", "多哥" },
            { "TH", "泰国" },
            { "TJ", "塔吉克" },
            { "TK", "托克劳群岛" },
            { "TL", "东帝汶" },
            { "TM", "土库曼" },
            { "TN", "突尼西亚" },
            { "TO", "东加" },
            { "TR", "土耳其" },
            { "TT", "千里达同多巴哥" },
            { "TV", "吐瓦鲁" },
            { "TW", "台湾" },
            { "TZ", "坦尚尼亚" },
            { "UA", "乌克兰" },
            { "UG", "乌干达" },
            { "UM", "美国本土外小岛屿" },
            { "UN", "联合国" },
            { "US", "美国" },
            { "UY", "乌拉圭" },
            { "UZ", "乌兹别克" },
            { "VA", "梵蒂冈" },
            { "VC", "圣文森特同格林纳丁斯" },
            { "VE", "委内瑞拉" },
            { "VG", "英属维京群岛" },
            { "VI", "美属维京群岛" },
            { "VN", "越南" },
            { "VU", "万那杜" },
            { "WF", "瓦利斯同富图纳群岛" },
            { "WS", "萨摩亚" },
            { "XA", "伪口音" },
            { "XB", "伪 Bidi" },
            { "XK", "科索沃" },
            { "YE", "也门" },
            { "YT", "马约特" },
            { "ZA", "南非" },
            { "ZM", "尚比亚" },
            { "ZW", "辛巴威" },
            { "ZZ", "未知区域" },
            { "aa", "阿法文" },
            { "ab", "阿布哈兹文" },
            { "ae", "阿纬斯陀文" },
            { "af", "南非荷兰文" },
            { "ak", "阿坎文" },
            { "am", "阿姆哈拉文" },
            { "an", "阿拉贡文" },
            { "ar", metaValue_ar },
            { "as", "阿萨姆文" },
            { "av", "阿瓦尔文" },
            { "ay", "艾马拉文" },
            { "az", "亚塞拜然文" },
            { "ba", "巴什客尔文" },
            { "be", "白俄罗斯文" },
            { "bg", "保加利亚文" },
            { "bi", "比斯拉马文" },
            { "bm", "班巴拉文" },
            { "bn", metaValue_bn },
            { "bo", "藏文" },
            { "br", "布列塔尼文" },
            { "bs", "波士尼亚文" },
            { "ca", "加泰罗尼亚文" },
            { "ce", "车臣文" },
            { "ch", "查莫洛文" },
            { "co", "科西嘉文" },
            { "cr", "克里文" },
            { "cs", "捷克文" },
            { "cu", "宗教斯拉夫文" },
            { "cv", "楚瓦什文" },
            { "cy", "威尔斯文" },
            { "da", "丹麦文" },
            { "de", "德文" },
            { "dv", "迪维西文" },
            { "dz", "宗卡文" },
            { "ee", "埃维文" },
            { "el", metaValue_el },
            { "en", "英文" },
            { "eo", "世界文" },
            { "es", "西班牙文" },
            { "et", "爱沙尼亚文" },
            { "eu", "巴斯克文" },
            { "fa", "波斯文" },
            { "ff", "富拉文" },
            { "fi", "芬兰文" },
            { "fj", "斐济文" },
            { "fo", "法罗文" },
            { "fr", "法文" },
            { "fy", "西弗里西亚文" },
            { "ga", "爱尔兰文" },
            { "gd", "苏格兰盖尔文" },
            { "gl", "加里西亚文" },
            { "gn", "瓜拉尼文" },
            { "gu", metaValue_gu },
            { "gv", "曼岛文" },
            { "ha", "豪撒文" },
            { "he", metaValue_he },
            { "hi", "北印度文" },
            { "ho", "西里莫图土文" },
            { "hr", "克罗埃西亚文" },
            { "ht", "海地文" },
            { "hu", "匈牙利文" },
            { "hy", metaValue_hy },
            { "hz", "赫雷罗文" },
            { "ia", "国际文" },
            { "id", "印尼文" },
            { "ie", "国际文（E）" },
            { "ig", "伊布文" },
            { "ii", "四川彝文" },
            { "ik", "依奴皮维克文" },
            { "io", "伊多文" },
            { "is", "冰岛文" },
            { "it", "义大利文" },
            { "iu", "因纽特文" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "刚果文" },
            { "ki", "吉库尤文" },
            { "kj", "广亚马文" },
            { "kk", "哈萨克文" },
            { "kl", "格陵兰文" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "卡努里文" },
            { "ks", "喀什米尔文" },
            { "ku", "北库德文" },
            { "kv", "科米文" },
            { "kw", "康瓦耳文" },
            { "ky", "吉尔吉斯文" },
            { "la", metaValue_la },
            { "lb", "卢森堡文" },
            { "lg", "干达文" },
            { "li", "林堡文" },
            { "ln", "林加拉文" },
            { "lo", "寮文" },
            { "lt", "立陶宛文" },
            { "lu", "鲁巴加丹加文" },
            { "lv", "拉脱维亚文" },
            { "mg", "马拉加什文" },
            { "mh", "马绍尔文" },
            { "mi", "毛利文" },
            { "mk", "马其顿文" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "马拉地文" },
            { "ms", "马来文" },
            { "mt", "马尔他文" },
            { "my", metaValue_my },
            { "na", "诺鲁文" },
            { "nb", "巴克摩挪威文" },
            { "nd", "北地毕列文" },
            { "ne", "尼泊尔文" },
            { "ng", "恩东加文" },
            { "nl", "荷兰文" },
            { "nn", "耐诺斯克挪威文" },
            { "no", "挪威文" },
            { "nr", "南地毕列文" },
            { "nv", "纳瓦霍文" },
            { "ny", "尼扬贾文" },
            { "oc", "奥克西坦文" },
            { "oj", "奥杰布瓦文" },
            { "om", "奥罗莫文" },
            { "or", metaValue_or },
            { "os", "奥塞提文" },
            { "pa", "旁遮普文" },
            { "pi", "巴利文" },
            { "pl", "波兰文" },
            { "ps", "普什图文" },
            { "pt", "葡萄牙文" },
            { "qu", "盖楚瓦文" },
            { "rm", "罗曼斯文" },
            { "rn", "隆迪文" },
            { "ro", "罗马尼亚文" },
            { "ru", "俄文" },
            { "rw", "卢安达文" },
            { "sa", "梵文" },
            { "sc", "撒丁文" },
            { "sd", metaValue_sd },
            { "se", "北方萨米文" },
            { "sg", "桑戈文" },
            { "sh", "塞尔维亚克罗埃西亚文" },
            { "si", "僧伽罗文" },
            { "sk", "斯洛伐克文" },
            { "sl", "斯洛维尼亚文" },
            { "sm", "萨摩亚文" },
            { "sn", "塞内加尔文" },
            { "so", "索马利文" },
            { "sq", "阿尔巴尼亚文" },
            { "sr", "塞尔维亚文" },
            { "ss", "斯瓦特文" },
            { "st", "塞索托文" },
            { "su", metaValue_su },
            { "sv", "瑞典文" },
            { "sw", "史瓦希里文" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "塔吉克文" },
            { "th", metaValue_th },
            { "ti", "提格利尼亚文" },
            { "tk", "土库曼文" },
            { "tl", "塔加路族文" },
            { "tn", "突尼西亚文" },
            { "to", "东加文" },
            { "tr", "土耳其文" },
            { "ts", "特松加文" },
            { "tt", "鞑靼文" },
            { "tw", "特威文" },
            { "ty", "大溪地文" },
            { "ug", "维吾尔文" },
            { "uk", "乌克兰文" },
            { "ur", "乌都文" },
            { "uz", "乌兹别克文" },
            { "ve", "温达文" },
            { "vi", "越南文" },
            { "vo", "沃拉普克文" },
            { "wa", "瓦隆文" },
            { "wo", "沃洛夫文" },
            { "xh", "科萨文" },
            { "yi", "意第绪文" },
            { "yo", "约鲁巴文" },
            { "za", "壮文" },
            { "zh", "中文" },
            { "zu", "祖鲁文" },
            { "ace", "亚齐文" },
            { "ach", "阿侨利文" },
            { "ada", "阿当莫文" },
            { "ady", "阿迪各文" },
            { "aeb", "突尼斯阿拉伯文" },
            { "afh", "阿弗里希利文" },
            { "agq", "亚罕文" },
            { "ain", "阿伊努文" },
            { "akk", "阿卡德文" },
            { "akz", "阿拉巴马文" },
            { "ale", "阿留申文" },
            { "aln", "盖格阿尔巴尼亚文" },
            { "alt", "南阿尔泰文" },
            { "ang", "古英文" },
            { "ann", "奥博洛文" },
            { "anp", "昂加文" },
            { "arc", "阿拉米文" },
            { "arn", "马普切文" },
            { "aro", "阿拉奥纳文" },
            { "arp", "阿拉帕霍文" },
            { "arq", "阿尔及利亚阿拉伯文" },
            { "ars", "纳吉迪阿拉伯文" },
            { "arw", "阿拉瓦克文" },
            { "ary", "摩洛哥阿拉伯文" },
            { "arz", "埃及阿拉伯文" },
            { "asa", "阿苏文" },
            { "ase", "美国手语" },
            { "ast", "阿斯图里亚文" },
            { "atj", "阿提卡米克文" },
            { "avk", "科塔瓦文" },
            { "awa", "阿瓦文" },
            { "bal", "俾路支文" },
            { "ban", metaValue_ban },
            { "bar", "巴伐利亚文" },
            { "bas", metaValue_bas },
            { "bax", metaValue_bax },
            { "bbc", "巴塔克托巴文" },
            { "bbj", "戈马拉文" },
            { "bej", "贝扎文" },
            { "bem", "别姆巴文" },
            { "bew", "贝塔维文" },
            { "bez", "贝纳文" },
            { "bfd", "富特文" },
            { "bfq", "巴达加文" },
            { "bgc", "哈里亚纳文" },
            { "bgn", "西俾路支文" },
            { "bho", "博杰普尔文" },
            { "bik", "比科尔文" },
            { "bin", "比尼文" },
            { "bjn", "班亚尔文" },
            { "bkm", "康姆文" },
            { "bla", "锡克锡卡文" },
            { "blo", "阿尼文" },
            { "bpy", "比什奴普莱利亚文" },
            { "bqi", "巴赫蒂亚里文" },
            { "bra", "布拉杰文" },
            { "brh", "布拉维文" },
            { "brx", "博多文" },
            { "bss", "阿库色文" },
            { "bua", "布里阿特文" },
            { "bug", metaValue_bug },
            { "bum", "布鲁文" },
            { "byn", "比林文" },
            { "byv", "梅敦巴文" },
            { "cad", "卡多文" },
            { "car", "加勒比文" },
            { "cay", "卡尤加文" },
            { "cch", "阿灿文" },
            { "ccp", metaValue_ccp },
            { "ceb", "宿雾文" },
            { "cgg", "奇加文" },
            { "chb", "奇布查文" },
            { "chg", "查加文" },
            { "chk", "处奇斯文" },
            { "chm", "马里文" },
            { "chn", "契奴克文" },
            { "cho", "乔克托文" },
            { "chp", "奇佩瓦扬文" },
            { "chr", metaValue_chr },
            { "chy", "沙伊安文" },
            { "ckb", "索拉尼库尔德文" },
            { "clc", "奇尔科延文" },
            { "cop", metaValue_cop },
            { "cps", "卡皮兹文" },
            { "crg", "米奇夫文" },
            { "crh", "克里米亚半岛的土耳其文；克里米亚半岛的塔塔尔文" },
            { "crj", "东南克里文" },
            { "crk", "平原克里文" },
            { "crl", "东北克里文" },
            { "crm", "驼鹿克里文" },
            { "crr", "卡罗来纳州阿尔冈昆语" },
            { "crs", "法语克里奥尔混合语" },
            { "csb", "卡舒布文" },
            { "csw", "沼泽克里文" },
            { "dak", "达科他文" },
            { "dar", "达尔格瓦文" },
            { "dav", "台塔文" },
            { "del", "德拉瓦文" },
            { "den", "斯拉夫" },
            { "dgr", "多格里布文" },
            { "din", "丁卡文" },
            { "dje", "扎尔马文" },
            { "doi", "多格来文" },
            { "dsb", "下索布文" },
            { "dtp", "中部杜顺文" },
            { "dua", "杜亚拉文" },
            { "dum", "中古荷兰文" },
            { "dyo", "朱拉文" },
            { "dyu", "迪尤拉文" },
            { "dzg", "达萨文" },
            { "ebu", "恩布文" },
            { "efi", "埃菲克文" },
            { "egl", "埃米利安文" },
            { "egy", "古埃及文" },
            { "eka", "艾卡朱克文" },
            { "elx", "埃兰文" },
            { "enm", "中古英文" },
            { "esu", "中尤皮克文" },
            { "ewo", "依汪都文" },
            { "ext", "埃斯特雷马杜拉文" },
            { "fan", "芳族文" },
            { "fat", "芳蒂文" },
            { "fil", "菲律宾文" },
            { "fit", "托尔讷芬兰文" },
            { "fon", "丰文" },
            { "frc", "卡真法文" },
            { "frm", "中古法文" },
            { "fro", "古法文" },
            { "frp", "法兰克-普罗旺斯文" },
            { "frr", "北弗里西亚文" },
            { "frs", "东弗里西亚文" },
            { "fur", "弗留利文" },
            { "gaa", "加族文" },
            { "gag", "加告兹文" },
            { "gan", "赣语" },
            { "gay", "加约文" },
            { "gba", "葛巴亚文" },
            { "gbz", "索罗亚斯德教达里文" },
            { "gez", "吉兹文" },
            { "gil", "吉尔伯特群岛文" },
            { "glk", "吉拉基文" },
            { "gmh", "中古高地德文" },
            { "goh", "古高地日耳曼文" },
            { "gon", "冈德文" },
            { "gor", "科隆达罗文" },
            { "got", "哥德文" },
            { "grb", "格列博文" },
            { "grc", "古希腊文" },
            { "gsw", "德文（瑞士）" },
            { "guc", "瓦尤文" },
            { "gur", "弗拉弗拉文" },
            { "guz", "古西文" },
            { "gwi", "圭契文" },
            { "hai", "海达文" },
            { "hak", "客家话" },
            { "haw", "夏威夷文" },
            { "hax", "南海达文" },
            { "hif", "斐济印地文" },
            { "hil", "希利盖农文" },
            { "hit", "赫梯文" },
            { "hmn", "孟文" },
            { "hsb", "上索布文" },
            { "hsn", "湘语" },
            { "hup", "胡帕文" },
            { "hur", "哈尔魁梅林语" },
            { "iba", "伊班文" },
            { "ibb", "伊比比奥文" },
            { "ikt", "加拿大西部因纽特文" },
            { "ilo", "伊洛阔文" },
            { "inh", "印古什文" },
            { "izh", "英格里亚文" },
            { "jam", "牙买加克里奥尔英文" },
            { "jbo", "逻辑文" },
            { "jgo", "恩格姆巴文" },
            { "jmc", "马恰美文" },
            { "jpr", "犹太教-波斯文" },
            { "jrb", "犹太阿拉伯文" },
            { "jut", "日德兰文" },
            { "kaa", "卡拉卡尔帕克文" },
            { "kab", "卡比尔文" },
            { "kac", "卡琴文" },
            { "kaj", "卡捷文" },
            { "kam", "卡姆巴文" },
            { "kaw", "卡威文" },
            { "kbd", "卡巴尔达文" },
            { "kbl", "卡念布文" },
            { "kcg", "卡塔布文" },
            { "kde", "马孔德文" },
            { "kea", "卡布威尔第文" },
            { "ken", "肯扬文" },
            { "kfo", "科罗文" },
            { "kgp", "坎刚文" },
            { "kha", "卡西文" },
            { "kho", "和阗文" },
            { "khq", "西桑海文" },
            { "khw", "科瓦文" },
            { "kiu", "北扎扎其文" },
            { "kkj", "卡库文" },
            { "kln", "卡伦金文" },
            { "kmb", "金邦杜文" },
            { "koi", "科米-彼尔米亚克文" },
            { "kok", "贡根文" },
            { "kos", "科斯雷恩文" },
            { "kpe", "克佩列文" },
            { "krc", "卡拉柴-包尔卡尔文" },
            { "kri", "塞拉利昂克里奥尔文" },
            { "krj", "基那来阿文" },
            { "krl", "卡累利阿文" },
            { "kru", "库鲁科文" },
            { "ksb", "尚巴拉文" },
            { "ksf", "巴菲亚文" },
            { "ksh", "科隆文" },
            { "kum", "库密克文" },
            { "kut", "库特奈文" },
            { "kwk", "夸夸瓦拉文" },
            { "kxv", "库维文" },
            { "lad", "拉迪诺文" },
            { "lag", "朗吉文" },
            { "lah", "拉亨达文" },
            { "lam", "兰巴文" },
            { "lez", "列兹干文" },
            { "lfn", "新共同语言" },
            { "lij", "利古里亚文" },
            { "lil", "利卢埃特文" },
            { "liv", "利伏尼亚文" },
            { "lkt", "拉科塔文" },
            { "lmo", "伦巴底文" },
            { "lol", "芒戈文" },
            { "lou", "路易斯安那克里奥尔文" },
            { "loz", "洛齐文" },
            { "lrc", "北卢尔文" },
            { "lsm", "萨米亚文" },
            { "ltg", "拉特加莱文" },
            { "lua", "鲁巴鲁鲁亚文" },
            { "lui", "路易塞诺文" },
            { "lun", "卢恩达文" },
            { "luo", "卢奥文" },
            { "lus", "卢晒文" },
            { "luy", "卢雅文" },
            { "lzh", "文言文" },
            { "lzz", "拉兹文" },
            { "mad", "马都拉文" },
            { "maf", "马法文" },
            { "mag", "马加伊文" },
            { "mai", metaValue_mai },
            { "mak", "望加锡文" },
            { "man", "曼丁哥文" },
            { "mas", "马赛文" },
            { "mde", "马巴文" },
            { "mdf", "莫克沙文" },
            { "mdr", "曼达文" },
            { "men", metaValue_men },
            { "mer", "梅鲁文" },
            { "mfe", "克里奥文（模里西斯）" },
            { "mga", "中古爱尔兰文" },
            { "mgh", "马夸文" },
            { "mgo", "美塔文" },
            { "mic", "米克马克文" },
            { "min", "米南卡堡文" },
            { "mnc", "满族文" },
            { "mni", "曼尼普里文" },
            { "moe", "因努埃蒙文" },
            { "moh", "莫霍克文" },
            { "mos", "莫西文" },
            { "mrj", "西马里文" },
            { "mua", "蒙当文" },
            { "mul", "多种语言" },
            { "mus", "克里克文" },
            { "mwl", "米兰德斯文" },
            { "mwr", "马尔尼里文" },
            { "mwv", "明打威文" },
            { "mye", "姆耶内文" },
            { "myv", "厄尔兹亚文" },
            { "mzn", "马赞德兰文" },
            { "nan", "闽南语" },
            { "nap", "拿波里文" },
            { "naq", "纳马文" },
            { "nds", "低地德文" },
            { "new", "尼瓦尔文" },
            { "nia", "尼亚斯文" },
            { "niu", "纽埃文" },
            { "njo", "阿沃那加文" },
            { "nmg", "夸西奥文" },
            { "nnh", "恩甘澎文" },
            { "nog", "诺盖文" },
            { "non", "古诺尔斯文" },
            { "nov", "诺维亚文" },
            { "nqo", "曼德文字 (N’Ko)" },
            { "nso", "北索托文" },
            { "nus", "努埃尔文" },
            { "nwc", "古尼瓦尔文" },
            { "nym", "尼扬韦齐文" },
            { "nyn", "尼扬科莱文" },
            { "nyo", "尼奥啰文" },
            { "nzi", "尼兹马文" },
            { "ojb", "西北奥吉布瓦文" },
            { "ojc", "中奥吉布瓦文" },
            { "ojs", "王子克里文" },
            { "ojw", "西奥吉布瓦文" },
            { "oka", "奥卡纳根文" },
            { "osa", "欧塞奇文" },
            { "ota", "鄂图曼土耳其文" },
            { "pag", "潘加辛文" },
            { "pal", "巴列维文" },
            { "pam", "潘帕嘉文" },
            { "pap", "帕皮阿门托文" },
            { "pau", "帛琉文" },
            { "pcd", "庇卡底文" },
            { "pcm", "尼日利亚皮钦语" },
            { "pdc", "宾夕法尼亚德文" },
            { "pdt", "门诺低地德文" },
            { "peo", metaValue_peo },
            { "pfl", "普法尔茨德文" },
            { "phn", metaValue_phn },
            { "pis", "皮京文" },
            { "pms", "皮埃蒙特文" },
            { "pnt", "旁狄希腊文" },
            { "pon", "波那贝文" },
            { "pqm", "马里塞-帕萨马夸迪文" },
            { "prg", "普鲁士文" },
            { "pro", "古普罗旺斯文" },
            { "quc", "基切文" },
            { "qug", "钦博拉索海兰盖丘亚文" },
            { "raj", "拉贾斯坦诸文" },
            { "rap", "复活岛文" },
            { "rar", "拉罗通加文" },
            { "rgn", "罗马格诺里文" },
            { "rhg", "罗兴亚文" },
            { "rif", "里菲亚诺文" },
            { "rof", "兰博文" },
            { "rom", "吉普赛文" },
            { "rtm", "罗图马岛文" },
            { "rue", "卢森尼亚文" },
            { "rug", "罗维阿纳文" },
            { "rup", "罗马尼亚语系" },
            { "rwk", "罗瓦文" },
            { "sad", "桑达韦文" },
            { "sah", "雅库特文" },
            { "sam", "萨玛利亚阿拉姆文" },
            { "saq", "萨布鲁文" },
            { "sas", "撒撒克文" },
            { "sat", "散塔利文" },
            { "saz", metaValue_saz },
            { "sba", "甘拜文" },
            { "sbp", "桑古文" },
            { "scn", "西西里文" },
            { "sco", "苏格兰文" },
            { "sdc", "萨丁尼亚-萨萨里文" },
            { "sdh", "南库尔德文" },
            { "see", "塞讷卡文" },
            { "seh", "赛纳文" },
            { "sei", "瑟里文" },
            { "sel", "瑟尔卡普文" },
            { "ses", "东桑海文" },
            { "sga", "古爱尔兰文" },
            { "sgs", "萨莫吉希亚文" },
            { "shi", "希尔哈文" },
            { "shn", "掸文" },
            { "shu", "阿拉伯文（查德）" },
            { "sid", "希达摩文" },
            { "slh", "南卢绍锡德文" },
            { "sli", "下西利西亚文" },
            { "sly", "塞拉亚文" },
            { "sma", "南萨米文" },
            { "smj", "鲁勒萨米文" },
            { "smn", "伊纳里萨米文" },
            { "sms", "斯科特萨米文" },
            { "snk", "索尼基文" },
            { "sog", "索格底亚纳文" },
            { "srn", "苏拉南东墎文" },
            { "srr", "塞雷尔文" },
            { "ssy", metaValue_ssy },
            { "stq", "沙特菲士兰文" },
            { "str", "海峡萨利希文" },
            { "suk", "苏库马文" },
            { "sus", "苏苏文" },
            { "sux", "苏美文" },
            { "swb", "葛摩文" },
            { "syc", "古叙利亚文" },
            { "syr", "叙利亚文" },
            { "szl", "西利西亚文" },
            { "tce", "南塔穹文" },
            { "tcy", "图卢文" },
            { "tem", "提姆文" },
            { "teo", "特索文" },
            { "ter", "泰雷诺文" },
            { "tet", "泰顿文" },
            { "tgx", "塔吉什文" },
            { "tht", "塔尔坦文" },
            { "tig", "蒂格雷文" },
            { "tiv", "提夫文" },
            { "tkl", "托克劳文" },
            { "tkr", "查库尔文" },
            { "tlh", "克林贡文" },
            { "tli", "特林基特文" },
            { "tly", "塔里什文" },
            { "tmh", "塔马奇克文" },
            { "tog", "东加文（尼亚萨）" },
            { "tok", "托基波纳文" },
            { "tpi", "托比辛文" },
            { "tru", "图罗尤文" },
            { "trv", "太鲁阁文" },
            { "tsd", "特萨克尼恩文" },
            { "tsi", "钦西安文" },
            { "ttm", "北塔奇讷文" },
            { "ttt", "穆斯林塔特文" },
            { "tum", "图姆布卡文" },
            { "tvl", "吐瓦鲁文" },
            { "twq", "北桑海文" },
            { "tyv", "土凡文" },
            { "tzm", "塔马齐格特文" },
            { "udm", "沃蒂艾克文" },
            { "uga", metaValue_uga },
            { "umb", "姆本杜文" },
            { "und", "未知语言" },
            { "vai", "瓦伊文" },
            { "vec", "威尼斯文" },
            { "vep", "维普森文" },
            { "vls", "西佛兰德文" },
            { "vmf", "美茵-法兰克尼亚文" },
            { "vmw", "马库瓦文" },
            { "vot", "沃提克文" },
            { "vro", "佛罗文" },
            { "vun", "温旧文" },
            { "wae", "瓦瑟文" },
            { "wal", "瓦拉莫文" },
            { "war", "瓦瑞文" },
            { "was", "瓦绍文" },
            { "wbp", "沃皮瑞文" },
            { "wuu", "吴语" },
            { "xal", "卡尔梅克文" },
            { "xmf", "明格列尔文" },
            { "xnr", "康格里文" },
            { "xog", "索加文" },
            { "yao", "瑶文" },
            { "yap", "雅浦文" },
            { "yav", "洋卞文" },
            { "ybb", "耶姆巴文" },
            { "yrl", "奈恩加图文" },
            { "yue", "粤语" },
            { "zap", "萨波特克文" },
            { "zbl", "布列斯符号" },
            { "zea", "西兰文" },
            { "zen", "泽纳加文" },
            { "zgh", "标准摩洛哥塔马塞特文" },
            { "zun", "祖尼文" },
            { "zxx", "无语言内容" },
            { "zza", "扎扎文" },
            { "Adlm", "阿德拉姆文" },
            { "Afak", "阿法卡文字" },
            { "Aghb", "高加索阿尔巴尼亚文" },
            { "Arab", metaValue_ar },
            { "Aran", "纳斯塔利克文" },
            { "Armi", "皇室亚美尼亚文" },
            { "Armn", metaValue_hy },
            { "Avst", "阿维斯陀文" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", metaValue_bas },
            { "Batk", "巴塔克文" },
            { "Beng", metaValue_bn },
            { "Blis", "布列斯文" },
            { "Bopo", "注音符号" },
            { "Brah", "婆罗米文" },
            { "Brai", "盲人用点字" },
            { "Bugi", metaValue_bug },
            { "Buhd", "布希德文" },
            { "Cakm", metaValue_ccp },
            { "Cans", "加拿大原住民通用字符" },
            { "Cari", "卡里亚文" },
            { "Cham", "占文" },
            { "Cher", metaValue_chr },
            { "Cirt", "色斯文" },
            { "Copt", metaValue_cop },
            { "Cprt", "塞浦路斯文" },
            { "Cyrl", "斯拉夫文" },
            { "Cyrs", "西里尔文（古教会斯拉夫文变体）" },
            { "Deva", "天城文" },
            { "Dsrt", "德瑟雷特文" },
            { "Dupl", "杜普洛伊速记" },
            { "Egyd", "古埃及世俗体" },
            { "Egyh", "古埃及僧侣体" },
            { "Egyp", "古埃及象形文字" },
            { "Elba", "爱尔巴桑文" },
            { "Ethi", "衣索比亚文" },
            { "Geok", "乔治亚语系（阿索他路里和努斯克胡里文）" },
            { "Geor", metaValue_ka },
            { "Glag", "格拉哥里文" },
            { "Goth", "歌德文" },
            { "Gran", "格兰他文字" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "古鲁穆奇文" },
            { "Hanb", "汉语注音" },
            { "Hang", "韩文字" },
            { "Hani", "汉语" },
            { "Hano", "哈努诺文" },
            { "Hans", "简体" },
            { "Hant", "繁体" },
            { "Hebr", metaValue_he },
            { "Hira", "平假名" },
            { "Hluw", "安那托利亚象形文字" },
            { "Hmng", "杨松录苗文" },
            { "Hrkt", "片假名或平假名" },
            { "Hung", "古匈牙利文" },
            { "Inds", "印度河流域（哈拉帕文）" },
            { "Ital", "古意大利文" },
            { "Jamo", "韩文字母" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "女真文字" },
            { "Kali", "克耶李文" },
            { "Kana", "片假名" },
            { "Khar", "卡罗须提文" },
            { "Khmr", metaValue_km },
            { "Khoj", "克吉奇文字" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", "克培列文" },
            { "Kthi", "凯提文" },
            { "Lana", "蓝拿文" },
            { "Laoo", "寮国文" },
            { "Latf", "拉丁文（尖角体活字变体）" },
            { "Latg", "拉丁文（盖尔语变体）" },
            { "Latn", metaValue_la },
            { "Lepc", "雷布查文" },
            { "Limb", "林布文" },
            { "Lina", "线性文字（A）" },
            { "Linb", "线性文字（B）" },
            { "Lisu", "栗僳文" },
            { "Loma", "洛马文" },
            { "Lyci", "吕西亚语" },
            { "Lydi", "里底亚语" },
            { "Mand", "曼底安文" },
            { "Mani", "摩尼教文" },
            { "Maya", "玛雅象形文字" },
            { "Mend", metaValue_men },
            { "Merc", "麦罗埃文（曲线字体）" },
            { "Mero", "麦罗埃文" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "蒙氏点字" },
            { "Mroo", "谬文" },
            { "Mtei", "曼尼普尔文" },
            { "Mymr", metaValue_my },
            { "Narb", "古北阿拉伯文" },
            { "Nbat", "纳巴泰文字" },
            { "Nkgb", "纳西格巴文" },
            { "Nkoo", "西非书面语言 (N’Ko)" },
            { "Nshu", "女书文字" },
            { "Ogam", "欧甘文" },
            { "Olck", "桑塔利文" },
            { "Orkh", "鄂尔浑文" },
            { "Orya", metaValue_or },
            { "Osma", "欧斯曼亚文" },
            { "Palm", "帕米瑞拉文字" },
            { "Perm", "古彼尔姆诸文" },
            { "Phag", "八思巴文" },
            { "Phli", "巴列维文（碑铭体）" },
            { "Phlp", "巴列维文（圣诗体）" },
            { "Phlv", "巴列维文（书体）" },
            { "Phnx", metaValue_phn },
            { "Plrd", "柏格理拼音符" },
            { "Prti", "帕提亚文（碑铭体）" },
            { "Rjng", "拉让文" },
            { "Rohg", "哈尼菲文" },
            { "Roro", "朗格朗格象形文" },
            { "Runr", "古北欧文字" },
            { "Samr", "撒马利亚文" },
            { "Sara", "沙拉堤文" },
            { "Sarb", "古南阿拉伯文" },
            { "Saur", metaValue_saz },
            { "Sgnw", "手语书写符号" },
            { "Shaw", "箫柏纳字符" },
            { "Shrd", "夏拉达文" },
            { "Sidd", "悉昙文字" },
            { "Sind", metaValue_sd },
            { "Sinh", "锡兰文" },
            { "Sora", "索朗桑朋文字" },
            { "Sund", metaValue_su },
            { "Sylo", "希洛弟纳格里文" },
            { "Syrc", "敍利亚文" },
            { "Syre", "叙利亚文（福音体文字变体）" },
            { "Syrj", "叙利亚文（西方文字变体）" },
            { "Syrn", "叙利亚文（东方文字变体）" },
            { "Tagb", "南岛文" },
            { "Takr", "塔卡里文字" },
            { "Tale", "傣哪文" },
            { "Talu", "西双版纳新傣文" },
            { "Taml", metaValue_ta },
            { "Tang", "西夏文" },
            { "Tavt", "傣担文" },
            { "Telu", metaValue_te },
            { "Teng", "谈格瓦文" },
            { "Tfng", "提非纳文" },
            { "Tglg", "塔加拉文" },
            { "Thaa", "塔安那文" },
            { "Thai", metaValue_th },
            { "Tibt", "西藏文" },
            { "Tirh", metaValue_mai },
            { "Ugar", metaValue_uga },
            { "Vaii", "瓦依文" },
            { "Visp", "视觉语音文字" },
            { "Wara", "瓦郎奇蒂文字" },
            { "Wole", "沃雷艾文" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "苏米鲁亚甲文楔形文字" },
            { "Yiii", "彝文" },
            { "Zinh", "继承文字（Unicode）" },
            { "Zmth", "数学符号" },
            { "Zsye", "表情符号" },
            { "Zsym", "符号" },
            { "Zxxx", "非书写语言" },
            { "Zyyy", "一般文字" },
            { "Zzzz", "未知文字" },
            { "de_CH", "高地德文 (瑞士)" },
            { "fa_AF", "达里文" },
            { "nl_BE", "佛兰芒文" },
            { "ro_MD", "摩尔多瓦文" },
            { "sw_CD", "史瓦希里文（刚果）" },
            { "%%1901", "传统德语拼字学" },
            { "%%1994", "标准雷西亚拼字" },
            { "%%1996", "1996 年的德语拼字学" },
            { "ar_001", "现代标准阿拉伯文" },
            { "key.ca", "历法" },
            { "key.cf", "货币格式" },
            { "key.co", "排序" },
            { "key.cu", "货币" },
            { "key.em", "Emoji 显示方式" },
            { "key.hc", "时间周期（12 小时制与 24 小时制）" },
            { "key.lb", "换行样式" },
            { "key.lw", "单字强制换行" },
            { "key.ms", "度量单位系统" },
            { "key.nu", "数字" },
            { "key.ss", "缩写后断句" },
            { "key.tz", "时区" },
            { "key.va", "区域变异" },
            { "nds_NL", "低地萨克逊文" },
            { "%%ALUKU", "阿鲁库方言" },
            { "%%BISKE", "San Giorgio/Bila 方言" },
            { "%%BOONT", "布恩特林方言" },
            { "%%JAUER", "米兹泰尔方言" },
            { "%%KKCOR", "通用康沃尔文拼字" },
            { "%%LIPAW", "雷西亚利波瓦方言" },
            { "%%NEDIS", "那提松尼方言" },
            { "%%NJIVA", "雷西亚尼瓦方言" },
            { "%%OSOJS", "雷西亚欧西亚柯方言" },
            { "%%POSIX", "电脑" },
            { "%%PUTER", "瑞士普特尔方言" },
            { "%%ROZAJ", "雷西亚方言" },
            { "%%RUMGR", "罗曼什文" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "雷西亚史托维萨方言" },
            { "%%UCCOR", "统一康沃尔文拼字" },
            { "zh_Hans", "简体中文" },
            { "zh_Hant", "繁体中文" },
            { "%%FONIPA", "IPA 拼音" },
            { "%%FONUPA", "UPA 拼音" },
            { "%%NDYUKA", "苏利南恩都卡方言" },
            { "%%PAMAKA", "苏利南帕马卡方言" },
            { "%%PINYIN", "汉语拼音" },
            { "%%SCOUSE", "利物浦方言" },
            { "%%TARASK", "白俄罗斯文传统拼字" },
            { "%%UCRCOR", "统一康沃尔文修订拼字" },
            { "%%ULSTER", "爱尔兰阿尔斯特方言" },
            { "%%ALALC97", "美国国会图书馆标准方案罗马化（1997年版）" },
            { "%%AREVELA", "亚美尼亚东部" },
            { "%%AREVMDA", "亚美尼亚西部" },
            { "%%BAUDDHA", "佛教混合梵文" },
            { "%%EMODENG", "早期现代英语" },
            { "%%HEPBURN", "平文式罗马字" },
            { "%%ITIHASA", "史诗梵文" },
            { "%%LAUKIKA", "传统梵文" },
            { "%%MONOTON", "希腊文单调正字法" },
            { "%%POLYTON", "希腊文多调正字法" },
            { "%%REVISED", "已修订的拼字学" },
            { "%%SURSILV", "瑞士苏瑟瓦方言" },
            { "%%SUTSILV", "瑞士苏希瓦方言" },
            { "%%VAIDIKA", "吠陀梵文" },
            { "%%1606NICT", "中世纪晚期法文（至1606年）" },
            { "%%1694ACAD", "早期现代法文" },
            { "%%1959ACAD", "白俄罗斯文（学术）" },
            { "%%BAKU1926", "统一土耳其拉丁字母" },
            { "%%BISCAYAN", "比斯开方言" },
            { "%%FONXSAMP", "X-SAMPA 音标" },
            { "%%HOGNORSK", "高地挪威文" },
            { "%%JYUTPING", "香港语言学学会粤语拼音" },
            { "%%LUNA1918", "俄罗斯文拼字（1917年后）" },
            { "%%PETR1708", "俄罗斯文拼字（1708 年）" },
            { "%%SCOTLAND", "苏格兰标准英语" },
            { "%%SURMIRAN", "瑞士苏迈拉方言" },
            { "%%VALENCIA", "瓦伦西亚文" },
            { "%%VALLADER", "瑞士瓦勒德方言" },
            { "%%WADEGILE", "威妥玛式拼音" },
            { "type.ca.roc", "民国历" },
            { "type.co.eor", "欧洲排序规则" },
            { "type.hc.h11", "12 小时制 (0–11)" },
            { "type.hc.h12", "12 小时制 (1–12)" },
            { "type.hc.h23", "24 小时制 (0–23)" },
            { "type.hc.h24", "24 小时制 (1–24)" },
            { "type.m0.bgn", "美国地名委员会" },
            { "type.nu.arab", "阿拉伯-印度数字" },
            { "type.nu.armn", "亚美尼亚数字" },
            { "type.nu.bali", "峇里文数字" },
            { "type.nu.beng", "孟加拉数字" },
            { "type.nu.brah", "婆罗米数字" },
            { "type.nu.cakm", "查克马数字" },
            { "type.nu.cham", "占文数字" },
            { "type.nu.deva", "梵文数字" },
            { "type.nu.ethi", "衣索比亚数字" },
            { "type.nu.geor", "乔治亚数字" },
            { "type.nu.grek", "希腊数字" },
            { "type.nu.gujr", "古吉拉特数字" },
            { "type.nu.guru", "古尔穆奇数字" },
            { "type.nu.hans", "小写简体中文数字" },
            { "type.nu.hant", "小写繁体中文数字" },
            { "type.nu.hebr", "希伯来数字" },
            { "type.nu.java", "爪哇文数字" },
            { "type.nu.jpan", "小写日文数字" },
            { "type.nu.kali", "克耶数字" },
            { "type.nu.khmr", "高棉数字" },
            { "type.nu.knda", "坎那达数字" },
            { "type.nu.lana", "老傣文数字" },
            { "type.nu.laoo", "寮国数字" },
            { "type.nu.latn", "阿拉伯数字" },
            { "type.nu.lepc", "西纳文数字" },
            { "type.nu.limb", "林布文数字" },
            { "type.nu.mlym", "马来亚拉姆数字" },
            { "type.nu.mong", "蒙古数字" },
            { "type.nu.mtei", "曼尼普尔数字" },
            { "type.nu.mymr", "缅甸数字" },
            { "type.nu.nkoo", "曼德数字" },
            { "type.nu.olck", "桑塔利文数字" },
            { "type.nu.orya", "欧利亚数字" },
            { "type.nu.osma", "奥斯曼亚数字" },
            { "type.nu.saur", "索拉什特拉文数字" },
            { "type.nu.shrd", "夏拉达数字" },
            { "type.nu.sora", "索朗桑朋数字" },
            { "type.nu.sund", "巽他数字" },
            { "type.nu.takr", "塔卡里数字" },
            { "type.nu.talu", "新傣仂文数字" },
            { "type.nu.taml", metaValue_type_nu_taml },
            { "type.nu.telu", "泰卢固数字" },
            { "type.nu.thai", "泰文数字" },
            { "type.nu.tibt", "西藏数字" },
            { "type.nu.vaii", "瓦伊文数字" },
            { "type.ca.dangi", "檀纪历" },
            { "type.co.ducet", "预设 Unicode 排序" },
            { "type.lb.loose", "宽松换行样式" },
            { "type.nu.roman", "罗马数字" },
            { "type.ca.coptic", "科普特历" },
            { "type.ca.hebrew", "希伯来历" },
            { "type.ca.indian", "印度国历" },
            { "type.co.pinyin", "拼音排序" },
            { "type.co.search", "一般用途搜寻" },
            { "type.co.stroke", "笔画排序" },
            { "type.co.unihan", "部首笔画排序" },
            { "type.co.zhuyin", "注音排序" },
            { "type.d0.fwidth", "全形" },
            { "type.d0.hwidth", "半形" },
            { "type.lb.normal", "一般换行样式" },
            { "type.lb.strict", "强制换行样式" },
            { "type.m0.ungegn", "联合国地名专家组" },
            { "type.ms.metric", "公制" },
            { "type.nu.native", "原始数字" },
            { "type.ca.chinese", "农历" },
            { "type.ca.islamic", "伊斯兰历" },
            { "type.ca.iso8601", "公历 (元年)" },
            { "type.ca.persian", "波斯历" },
            { "type.cf.account", "会计货币格式" },
            { "type.d0.npinyin", "数值" },
            { "type.nu.arabext", "阿拉伯-印度扩充数字" },
            { "type.nu.armnlow", "小写亚美尼亚数字" },
            { "type.nu.finance", "金融数字" },
            { "type.nu.greklow", "小写希腊数字" },
            { "type.nu.hanidec", "中文十进位数字" },
            { "type.nu.hansfin", "大写简体中文数字" },
            { "type.nu.hantfin", "大写繁体中文数字" },
            { "type.nu.jpanfin", "大写日文数字" },
            { "type.nu.tamldec", metaValue_type_nu_taml },
            { "type.ca.buddhist", "佛历" },
            { "type.ca.ethiopic", "埃塞俄比亚历" },
            { "type.ca.japanese", "日本历" },
            { "type.cf.standard", "标准货币格式" },
            { "type.co.phonetic", "发音排序" },
            { "type.co.searchjl", "韩文子音排序" },
            { "type.co.standard", "标准排序" },
            { "type.ms.uksystem", "英制度量单位系统" },
            { "type.ms.ussystem", "美制度量单位系统" },
            { "type.nu.fullwide", "全形数字" },
            { "type.nu.lanatham", "兰纳文数字" },
            { "type.nu.mymrshan", "缅甸掸文数字" },
            { "type.nu.romanlow", "小写罗马数字" },
            { "type.ca.gregorian", "公历" },
            { "type.co.phonebook", "电话簿排序" },
            { "ListKeyTypePattern", "{0}：{1}" },
            { "type.co.dictionary", "字典排序" },
            { "type.co.traditional", "传统排序" },
            { "type.nu.traditional", "传统数字" },
            { "type.ca.islamic-civil", "伊斯兰民用历 (表格式)" },
            { "ListCompositionPattern", "{0}，{1}" },
            { "type.ca.islamic-umalqura", "伊斯兰历 (乌姆库拉)" },
            { "type.ca.ethiopic-amete-alem", "埃塞俄比亚阿美德阿莱姆历" },
        };
        return data;
    }
}
