// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::create_o_auth2_token::_create_o_auth2_token_output::CreateOAuth2TokenOutputBuilder;

pub use crate::operation::create_o_auth2_token::_create_o_auth2_token_input::CreateOAuth2TokenInputBuilder;

impl crate::operation::create_o_auth2_token::builders::CreateOAuth2TokenInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::create_o_auth2_token::CreateOAuth2TokenOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_o_auth2_token::CreateOAuth2TokenError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.create_o_auth2_token();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `CreateOAuth2Token`.
///
/// CreateOAuth2Token API Path: /v1/token Request Method: POST Content-Type: application/json or application/x-www-form-urlencoded This API implements OAuth 2.0 flows for AWS Sign-In CLI clients, supporting both: 1. Authorization code redemption (grant_type=authorization_code) - NOT idempotent 2. Token refresh (grant_type=refresh_token) - Idempotent within token validity window The operation behavior is determined by the grant_type parameter in the request body: **Authorization Code Flow (NOT Idempotent):** - JSON or form-encoded body with client_id, grant_type=authorization_code, code, redirect_uri, code_verifier - Returns access_token, token_type, expires_in, refresh_token, and id_token - Each authorization code can only be used ONCE for security (prevents replay attacks) **Token Refresh Flow (Idempotent):** - JSON or form-encoded body with client_id, grant_type=refresh_token, refresh_token - Returns access_token, token_type, expires_in, and refresh_token (no id_token) - Multiple calls with same refresh_token return consistent results within validity window Authentication and authorization: - Confidential clients: sigv4 signing required with signin:ExchangeToken permissions - CLI clients (public): authn/authz skipped based on client_id &amp; grant_type Note: This operation cannot be marked as @idempotent because it handles both idempotent (token refresh) and non-idempotent (auth code redemption) flows in a single endpoint.
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct CreateOAuth2TokenFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::create_o_auth2_token::builders::CreateOAuth2TokenInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::create_o_auth2_token::CreateOAuth2TokenOutput,
        crate::operation::create_o_auth2_token::CreateOAuth2TokenError,
    > for CreateOAuth2TokenFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::create_o_auth2_token::CreateOAuth2TokenOutput,
            crate::operation::create_o_auth2_token::CreateOAuth2TokenError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl CreateOAuth2TokenFluentBuilder {
    /// Creates a new `CreateOAuth2TokenFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the CreateOAuth2Token as a reference.
    pub fn as_input(&self) -> &crate::operation::create_o_auth2_token::builders::CreateOAuth2TokenInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_o_auth2_token::CreateOAuth2TokenOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::create_o_auth2_token::CreateOAuth2TokenError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::create_o_auth2_token::CreateOAuth2Token::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::create_o_auth2_token::CreateOAuth2Token::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::create_o_auth2_token::CreateOAuth2TokenOutput,
        crate::operation::create_o_auth2_token::CreateOAuth2TokenError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Flattened token operation inputs The specific operation is determined by grant_type in the request body
    pub fn token_input(mut self, input: crate::types::CreateOAuth2TokenRequestBody) -> Self {
        self.inner = self.inner.token_input(input);
        self
    }
    /// Flattened token operation inputs The specific operation is determined by grant_type in the request body
    pub fn set_token_input(mut self, input: ::std::option::Option<crate::types::CreateOAuth2TokenRequestBody>) -> Self {
        self.inner = self.inner.set_token_input(input);
        self
    }
    /// Flattened token operation inputs The specific operation is determined by grant_type in the request body
    pub fn get_token_input(&self) -> &::std::option::Option<crate::types::CreateOAuth2TokenRequestBody> {
        self.inner.get_token_input()
    }
}
