# -*- ruby -*-
# encoding: utf-8
$LOAD_PATH.push File.expand_path('../src/ruby/lib', __FILE__)
require 'grpc/version'

Gem::Specification.new do |s|
  s.name          = 'grpc'
  s.version       = GRPC::VERSION
  s.authors       = ['gRPC Authors']
  s.email         = 'grpc-io@googlegroups.com'
  s.homepage      = 'https://github.com/google/grpc/tree/master/src/ruby'
  s.summary       = 'GRPC system in Ruby'
  s.description   = 'Send RPCs from Ruby using GRPC'
  s.license       = 'Apache-2.0'

  s.required_ruby_version = '>= 3.1'

  s.files = %w( Makefile .yardopts )
  s.files += %w( etc/roots.pem )
  s.files += Dir.glob('src/ruby/bin/**/*')
  s.files += Dir.glob('src/ruby/ext/**/*')
  s.files += Dir.glob('src/ruby/lib/**/*')
  s.files += Dir.glob('src/ruby/pb/**/*').reject do |f|
    f.match(%r{^src/ruby/pb/test})
  end
  s.files += Dir.glob('include/grpc/**/*')
  s.test_files = Dir.glob('src/ruby/spec/**/*')
  s.test_files += Dir.glob('src/ruby/pb/test/**/*')
  s.bindir = 'src/ruby/bin'
  s.require_paths = %w( src/ruby/lib src/ruby/bin src/ruby/pb )
  s.platform      = Gem::Platform::RUBY

  s.add_dependency 'google-protobuf', '>= 3.25', '< 5.0'
  s.add_dependency 'googleapis-common-protos-types', '~> 1.0'

  s.add_development_dependency 'bundler',            '>= 1.9'
  s.add_development_dependency 'facter',             '~> 2.4'
  s.add_development_dependency 'logging',            '~> 2.0'
  s.add_development_dependency 'simplecov',          '~> 0.22'
  s.add_development_dependency 'rake',               '~> 13.0'
  s.add_development_dependency 'rake-compiler',      '~> 1.2.1'
  s.add_development_dependency 'rake-compiler-dock', '= 1.9.1'
  s.add_development_dependency 'rspec',              '~> 3.6'
  s.add_development_dependency 'rubocop',            '~> 1.41.0'
  s.add_development_dependency 'signet',             '~> 0.7'
  s.add_development_dependency 'googleauth',         '~> 1.0'

  s.extensions = %w(src/ruby/ext/grpc/extconf.rb)

  s.files += %w( include/grpc/byte_buffer.h )
  s.files += %w( include/grpc/byte_buffer_reader.h )
  s.files += %w( include/grpc/census.h )
  s.files += %w( include/grpc/compression.h )
  s.files += %w( include/grpc/create_channel_from_endpoint.h )
  s.files += %w( include/grpc/credentials.h )
  s.files += %w( include/grpc/event_engine/endpoint_config.h )
  s.files += %w( include/grpc/event_engine/event_engine.h )
  s.files += %w( include/grpc/event_engine/extensible.h )
  s.files += %w( include/grpc/event_engine/internal/memory_allocator_impl.h )
  s.files += %w( include/grpc/event_engine/internal/slice_cast.h )
  s.files += %w( include/grpc/event_engine/internal/write_event.h )
  s.files += %w( include/grpc/event_engine/memory_allocator.h )
  s.files += %w( include/grpc/event_engine/memory_request.h )
  s.files += %w( include/grpc/event_engine/port.h )
  s.files += %w( include/grpc/event_engine/slice.h )
  s.files += %w( include/grpc/event_engine/slice_buffer.h )
  s.files += %w( include/grpc/fork.h )
  s.files += %w( include/grpc/grpc.h )
  s.files += %w( include/grpc/grpc_audit_logging.h )
  s.files += %w( include/grpc/grpc_crl_provider.h )
  s.files += %w( include/grpc/grpc_posix.h )
  s.files += %w( include/grpc/grpc_security.h )
  s.files += %w( include/grpc/grpc_security_constants.h )
  s.files += %w( include/grpc/impl/call.h )
  s.files += %w( include/grpc/impl/channel_arg_names.h )
  s.files += %w( include/grpc/impl/codegen/atm.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_atomic.h )
  s.files += %w( include/grpc/impl/codegen/atm_gcc_sync.h )
  s.files += %w( include/grpc/impl/codegen/atm_windows.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer.h )
  s.files += %w( include/grpc/impl/codegen/byte_buffer_reader.h )
  s.files += %w( include/grpc/impl/codegen/compression_types.h )
  s.files += %w( include/grpc/impl/codegen/connectivity_state.h )
  s.files += %w( include/grpc/impl/codegen/fork.h )
  s.files += %w( include/grpc/impl/codegen/gpr_types.h )
  s.files += %w( include/grpc/impl/codegen/grpc_types.h )
  s.files += %w( include/grpc/impl/codegen/log.h )
  s.files += %w( include/grpc/impl/codegen/port_platform.h )
  s.files += %w( include/grpc/impl/codegen/propagation_bits.h )
  s.files += %w( include/grpc/impl/codegen/slice.h )
  s.files += %w( include/grpc/impl/codegen/status.h )
  s.files += %w( include/grpc/impl/codegen/sync.h )
  s.files += %w( include/grpc/impl/codegen/sync_abseil.h )
  s.files += %w( include/grpc/impl/codegen/sync_custom.h )
  s.files += %w( include/grpc/impl/codegen/sync_generic.h )
  s.files += %w( include/grpc/impl/codegen/sync_posix.h )
  s.files += %w( include/grpc/impl/codegen/sync_windows.h )
  s.files += %w( include/grpc/impl/compression_types.h )
  s.files += %w( include/grpc/impl/connectivity_state.h )
  s.files += %w( include/grpc/impl/grpc_types.h )
  s.files += %w( include/grpc/impl/propagation_bits.h )
  s.files += %w( include/grpc/impl/slice_type.h )
  s.files += %w( include/grpc/load_reporting.h )
  s.files += %w( include/grpc/passive_listener.h )
  s.files += %w( include/grpc/slice.h )
  s.files += %w( include/grpc/slice_buffer.h )
  s.files += %w( include/grpc/status.h )
  s.files += %w( include/grpc/support/alloc.h )
  s.files += %w( include/grpc/support/atm.h )
  s.files += %w( include/grpc/support/atm_gcc_atomic.h )
  s.files += %w( include/grpc/support/atm_gcc_sync.h )
  s.files += %w( include/grpc/support/atm_windows.h )
  s.files += %w( include/grpc/support/cpu.h )
  s.files += %w( include/grpc/support/json.h )
  s.files += %w( include/grpc/support/log.h )
  s.files += %w( include/grpc/support/log_windows.h )
  s.files += %w( include/grpc/support/metrics.h )
  s.files += %w( include/grpc/support/port_platform.h )
  s.files += %w( include/grpc/support/string_util.h )
  s.files += %w( include/grpc/support/sync.h )
  s.files += %w( include/grpc/support/sync_abseil.h )
  s.files += %w( include/grpc/support/sync_custom.h )
  s.files += %w( include/grpc/support/sync_generic.h )
  s.files += %w( include/grpc/support/sync_posix.h )
  s.files += %w( include/grpc/support/sync_windows.h )
  s.files += %w( include/grpc/support/thd_id.h )
  s.files += %w( include/grpc/support/time.h )
  s.files += %w( include/grpc/support/workaround_list.h )
  s.files += %w( src/core/call/call_arena_allocator.cc )
  s.files += %w( src/core/call/call_arena_allocator.h )
  s.files += %w( src/core/call/call_destination.h )
  s.files += %w( src/core/call/call_filters.cc )
  s.files += %w( src/core/call/call_filters.h )
  s.files += %w( src/core/call/call_finalization.h )
  s.files += %w( src/core/call/call_spine.cc )
  s.files += %w( src/core/call/call_spine.h )
  s.files += %w( src/core/call/call_state.cc )
  s.files += %w( src/core/call/call_state.h )
  s.files += %w( src/core/call/channelz_context.h )
  s.files += %w( src/core/call/client_call.cc )
  s.files += %w( src/core/call/client_call.h )
  s.files += %w( src/core/call/custom_metadata.h )
  s.files += %w( src/core/call/filter_fusion.h )
  s.files += %w( src/core/call/interception_chain.cc )
  s.files += %w( src/core/call/interception_chain.h )
  s.files += %w( src/core/call/message.cc )
  s.files += %w( src/core/call/message.h )
  s.files += %w( src/core/call/metadata.cc )
  s.files += %w( src/core/call/metadata.h )
  s.files += %w( src/core/call/metadata_batch.cc )
  s.files += %w( src/core/call/metadata_batch.h )
  s.files += %w( src/core/call/metadata_compression_traits.h )
  s.files += %w( src/core/call/metadata_info.cc )
  s.files += %w( src/core/call/metadata_info.h )
  s.files += %w( src/core/call/parsed_metadata.cc )
  s.files += %w( src/core/call/parsed_metadata.h )
  s.files += %w( src/core/call/request_buffer.cc )
  s.files += %w( src/core/call/request_buffer.h )
  s.files += %w( src/core/call/security_context.cc )
  s.files += %w( src/core/call/security_context.h )
  s.files += %w( src/core/call/server_call.cc )
  s.files += %w( src/core/call/server_call.h )
  s.files += %w( src/core/call/simple_slice_based_metadata.h )
  s.files += %w( src/core/call/status_util.cc )
  s.files += %w( src/core/call/status_util.h )
  s.files += %w( src/core/channelz/channel_trace.cc )
  s.files += %w( src/core/channelz/channel_trace.h )
  s.files += %w( src/core/channelz/channelz.cc )
  s.files += %w( src/core/channelz/channelz.h )
  s.files += %w( src/core/channelz/channelz_registry.cc )
  s.files += %w( src/core/channelz/channelz_registry.h )
  s.files += %w( src/core/channelz/property_list.cc )
  s.files += %w( src/core/channelz/property_list.h )
  s.files += %w( src/core/channelz/text_encode.cc )
  s.files += %w( src/core/channelz/text_encode.h )
  s.files += %w( src/core/channelz/v2tov1/convert.cc )
  s.files += %w( src/core/channelz/v2tov1/convert.h )
  s.files += %w( src/core/channelz/v2tov1/legacy_api.cc )
  s.files += %w( src/core/channelz/v2tov1/legacy_api.h )
  s.files += %w( src/core/channelz/v2tov1/property_list.cc )
  s.files += %w( src/core/channelz/v2tov1/property_list.h )
  s.files += %w( src/core/channelz/ztrace_collector.h )
  s.files += %w( src/core/client_channel/backup_poller.cc )
  s.files += %w( src/core/client_channel/backup_poller.h )
  s.files += %w( src/core/client_channel/buffered_call.cc )
  s.files += %w( src/core/client_channel/buffered_call.h )
  s.files += %w( src/core/client_channel/client_channel.cc )
  s.files += %w( src/core/client_channel/client_channel.h )
  s.files += %w( src/core/client_channel/client_channel_args.h )
  s.files += %w( src/core/client_channel/client_channel_factory.cc )
  s.files += %w( src/core/client_channel/client_channel_factory.h )
  s.files += %w( src/core/client_channel/client_channel_filter.cc )
  s.files += %w( src/core/client_channel/client_channel_filter.h )
  s.files += %w( src/core/client_channel/client_channel_internal.h )
  s.files += %w( src/core/client_channel/client_channel_plugin.cc )
  s.files += %w( src/core/client_channel/client_channel_service_config.cc )
  s.files += %w( src/core/client_channel/client_channel_service_config.h )
  s.files += %w( src/core/client_channel/config_selector.h )
  s.files += %w( src/core/client_channel/connector.h )
  s.files += %w( src/core/client_channel/direct_channel.cc )
  s.files += %w( src/core/client_channel/direct_channel.h )
  s.files += %w( src/core/client_channel/dynamic_filters.cc )
  s.files += %w( src/core/client_channel/dynamic_filters.h )
  s.files += %w( src/core/client_channel/global_subchannel_pool.cc )
  s.files += %w( src/core/client_channel/global_subchannel_pool.h )
  s.files += %w( src/core/client_channel/lb_metadata.cc )
  s.files += %w( src/core/client_channel/lb_metadata.h )
  s.files += %w( src/core/client_channel/load_balanced_call_destination.cc )
  s.files += %w( src/core/client_channel/load_balanced_call_destination.h )
  s.files += %w( src/core/client_channel/local_subchannel_pool.cc )
  s.files += %w( src/core/client_channel/local_subchannel_pool.h )
  s.files += %w( src/core/client_channel/retry_filter.cc )
  s.files += %w( src/core/client_channel/retry_filter.h )
  s.files += %w( src/core/client_channel/retry_filter_legacy_call_data.cc )
  s.files += %w( src/core/client_channel/retry_filter_legacy_call_data.h )
  s.files += %w( src/core/client_channel/retry_interceptor.cc )
  s.files += %w( src/core/client_channel/retry_interceptor.h )
  s.files += %w( src/core/client_channel/retry_service_config.cc )
  s.files += %w( src/core/client_channel/retry_service_config.h )
  s.files += %w( src/core/client_channel/retry_throttle.cc )
  s.files += %w( src/core/client_channel/retry_throttle.h )
  s.files += %w( src/core/client_channel/subchannel.cc )
  s.files += %w( src/core/client_channel/subchannel.h )
  s.files += %w( src/core/client_channel/subchannel_interface_internal.h )
  s.files += %w( src/core/client_channel/subchannel_pool_interface.cc )
  s.files += %w( src/core/client_channel/subchannel_pool_interface.h )
  s.files += %w( src/core/client_channel/subchannel_stream_client.cc )
  s.files += %w( src/core/client_channel/subchannel_stream_client.h )
  s.files += %w( src/core/config/config_vars.cc )
  s.files += %w( src/core/config/config_vars.h )
  s.files += %w( src/core/config/config_vars_non_generated.cc )
  s.files += %w( src/core/config/core_configuration.cc )
  s.files += %w( src/core/config/core_configuration.h )
  s.files += %w( src/core/config/load_config.cc )
  s.files += %w( src/core/config/load_config.h )
  s.files += %w( src/core/credentials/call/call_credentials.h )
  s.files += %w( src/core/credentials/call/call_creds_registry.h )
  s.files += %w( src/core/credentials/call/call_creds_registry_init.cc )
  s.files += %w( src/core/credentials/call/call_creds_util.cc )
  s.files += %w( src/core/credentials/call/call_creds_util.h )
  s.files += %w( src/core/credentials/call/composite/composite_call_credentials.cc )
  s.files += %w( src/core/credentials/call/composite/composite_call_credentials.h )
  s.files += %w( src/core/credentials/call/external/aws_external_account_credentials.cc )
  s.files += %w( src/core/credentials/call/external/aws_external_account_credentials.h )
  s.files += %w( src/core/credentials/call/external/aws_request_signer.cc )
  s.files += %w( src/core/credentials/call/external/aws_request_signer.h )
  s.files += %w( src/core/credentials/call/external/external_account_credentials.cc )
  s.files += %w( src/core/credentials/call/external/external_account_credentials.h )
  s.files += %w( src/core/credentials/call/external/file_external_account_credentials.cc )
  s.files += %w( src/core/credentials/call/external/file_external_account_credentials.h )
  s.files += %w( src/core/credentials/call/external/url_external_account_credentials.cc )
  s.files += %w( src/core/credentials/call/external/url_external_account_credentials.h )
  s.files += %w( src/core/credentials/call/gcp_service_account_identity/gcp_service_account_identity_credentials.cc )
  s.files += %w( src/core/credentials/call/gcp_service_account_identity/gcp_service_account_identity_credentials.h )
  s.files += %w( src/core/credentials/call/iam/iam_credentials.cc )
  s.files += %w( src/core/credentials/call/iam/iam_credentials.h )
  s.files += %w( src/core/credentials/call/json_util.cc )
  s.files += %w( src/core/credentials/call/json_util.h )
  s.files += %w( src/core/credentials/call/jwt/json_token.cc )
  s.files += %w( src/core/credentials/call/jwt/json_token.h )
  s.files += %w( src/core/credentials/call/jwt/jwt_credentials.cc )
  s.files += %w( src/core/credentials/call/jwt/jwt_credentials.h )
  s.files += %w( src/core/credentials/call/jwt/jwt_verifier.cc )
  s.files += %w( src/core/credentials/call/jwt/jwt_verifier.h )
  s.files += %w( src/core/credentials/call/jwt_token_file/jwt_token_file_call_credentials.cc )
  s.files += %w( src/core/credentials/call/jwt_token_file/jwt_token_file_call_credentials.h )
  s.files += %w( src/core/credentials/call/jwt_util.cc )
  s.files += %w( src/core/credentials/call/jwt_util.h )
  s.files += %w( src/core/credentials/call/oauth2/oauth2_credentials.cc )
  s.files += %w( src/core/credentials/call/oauth2/oauth2_credentials.h )
  s.files += %w( src/core/credentials/call/plugin/plugin_credentials.cc )
  s.files += %w( src/core/credentials/call/plugin/plugin_credentials.h )
  s.files += %w( src/core/credentials/call/token_fetcher/token_fetcher_credentials.cc )
  s.files += %w( src/core/credentials/call/token_fetcher/token_fetcher_credentials.h )
  s.files += %w( src/core/credentials/transport/alts/alts_credentials.cc )
  s.files += %w( src/core/credentials/transport/alts/alts_credentials.h )
  s.files += %w( src/core/credentials/transport/alts/alts_security_connector.cc )
  s.files += %w( src/core/credentials/transport/alts/alts_security_connector.h )
  s.files += %w( src/core/credentials/transport/alts/check_gcp_environment.cc )
  s.files += %w( src/core/credentials/transport/alts/check_gcp_environment.h )
  s.files += %w( src/core/credentials/transport/alts/check_gcp_environment_linux.cc )
  s.files += %w( src/core/credentials/transport/alts/check_gcp_environment_no_op.cc )
  s.files += %w( src/core/credentials/transport/alts/check_gcp_environment_windows.cc )
  s.files += %w( src/core/credentials/transport/alts/grpc_alts_credentials_client_options.cc )
  s.files += %w( src/core/credentials/transport/alts/grpc_alts_credentials_options.cc )
  s.files += %w( src/core/credentials/transport/alts/grpc_alts_credentials_options.h )
  s.files += %w( src/core/credentials/transport/alts/grpc_alts_credentials_server_options.cc )
  s.files += %w( src/core/credentials/transport/channel_creds_registry.h )
  s.files += %w( src/core/credentials/transport/channel_creds_registry_init.cc )
  s.files += %w( src/core/credentials/transport/composite/composite_channel_credentials.cc )
  s.files += %w( src/core/credentials/transport/composite/composite_channel_credentials.h )
  s.files += %w( src/core/credentials/transport/fake/fake_credentials.cc )
  s.files += %w( src/core/credentials/transport/fake/fake_credentials.h )
  s.files += %w( src/core/credentials/transport/fake/fake_security_connector.cc )
  s.files += %w( src/core/credentials/transport/fake/fake_security_connector.h )
  s.files += %w( src/core/credentials/transport/google_default/credentials_generic.cc )
  s.files += %w( src/core/credentials/transport/google_default/google_default_credentials.cc )
  s.files += %w( src/core/credentials/transport/google_default/google_default_credentials.h )
  s.files += %w( src/core/credentials/transport/insecure/insecure_credentials.cc )
  s.files += %w( src/core/credentials/transport/insecure/insecure_credentials.h )
  s.files += %w( src/core/credentials/transport/insecure/insecure_security_connector.cc )
  s.files += %w( src/core/credentials/transport/insecure/insecure_security_connector.h )
  s.files += %w( src/core/credentials/transport/local/local_credentials.cc )
  s.files += %w( src/core/credentials/transport/local/local_credentials.h )
  s.files += %w( src/core/credentials/transport/local/local_security_connector.cc )
  s.files += %w( src/core/credentials/transport/local/local_security_connector.h )
  s.files += %w( src/core/credentials/transport/security_connector.cc )
  s.files += %w( src/core/credentials/transport/security_connector.h )
  s.files += %w( src/core/credentials/transport/ssl/ssl_credentials.cc )
  s.files += %w( src/core/credentials/transport/ssl/ssl_credentials.h )
  s.files += %w( src/core/credentials/transport/ssl/ssl_security_connector.cc )
  s.files += %w( src/core/credentials/transport/ssl/ssl_security_connector.h )
  s.files += %w( src/core/credentials/transport/tls/certificate_provider_factory.h )
  s.files += %w( src/core/credentials/transport/tls/certificate_provider_registry.cc )
  s.files += %w( src/core/credentials/transport/tls/certificate_provider_registry.h )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_distributor.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_distributor.h )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_match.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_provider.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_provider.h )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_verifier.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_certificate_verifier.h )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_credentials_options.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_credentials_options.h )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_crl_provider.cc )
  s.files += %w( src/core/credentials/transport/tls/grpc_tls_crl_provider.h )
  s.files += %w( src/core/credentials/transport/tls/load_system_roots.h )
  s.files += %w( src/core/credentials/transport/tls/load_system_roots_fallback.cc )
  s.files += %w( src/core/credentials/transport/tls/load_system_roots_supported.cc )
  s.files += %w( src/core/credentials/transport/tls/load_system_roots_supported.h )
  s.files += %w( src/core/credentials/transport/tls/load_system_roots_windows.cc )
  s.files += %w( src/core/credentials/transport/tls/spiffe_utils.cc )
  s.files += %w( src/core/credentials/transport/tls/spiffe_utils.h )
  s.files += %w( src/core/credentials/transport/tls/ssl_utils.cc )
  s.files += %w( src/core/credentials/transport/tls/ssl_utils.h )
  s.files += %w( src/core/credentials/transport/tls/tls_credentials.cc )
  s.files += %w( src/core/credentials/transport/tls/tls_credentials.h )
  s.files += %w( src/core/credentials/transport/tls/tls_security_connector.cc )
  s.files += %w( src/core/credentials/transport/tls/tls_security_connector.h )
  s.files += %w( src/core/credentials/transport/tls/tls_utils.cc )
  s.files += %w( src/core/credentials/transport/tls/tls_utils.h )
  s.files += %w( src/core/credentials/transport/transport_credentials.cc )
  s.files += %w( src/core/credentials/transport/transport_credentials.h )
  s.files += %w( src/core/credentials/transport/xds/xds_credentials.cc )
  s.files += %w( src/core/credentials/transport/xds/xds_credentials.h )
  s.files += %w( src/core/ext/filters/backend_metrics/backend_metric_filter.cc )
  s.files += %w( src/core/ext/filters/backend_metrics/backend_metric_filter.h )
  s.files += %w( src/core/ext/filters/backend_metrics/backend_metric_provider.h )
  s.files += %w( src/core/ext/filters/census/grpc_context.cc )
  s.files += %w( src/core/ext/filters/channel_idle/idle_filter_state.cc )
  s.files += %w( src/core/ext/filters/channel_idle/idle_filter_state.h )
  s.files += %w( src/core/ext/filters/channel_idle/legacy_channel_idle_filter.cc )
  s.files += %w( src/core/ext/filters/channel_idle/legacy_channel_idle_filter.h )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_filter.cc )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_filter.h )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/fault_injection/fault_injection_service_config_parser.h )
  s.files += %w( src/core/ext/filters/gcp_authentication/gcp_authentication_filter.cc )
  s.files += %w( src/core/ext/filters/gcp_authentication/gcp_authentication_filter.h )
  s.files += %w( src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/gcp_authentication/gcp_authentication_service_config_parser.h )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.cc )
  s.files += %w( src/core/ext/filters/http/client/http_client_filter.h )
  s.files += %w( src/core/ext/filters/http/client_authority_filter.cc )
  s.files += %w( src/core/ext/filters/http/client_authority_filter.h )
  s.files += %w( src/core/ext/filters/http/http_filters_plugin.cc )
  s.files += %w( src/core/ext/filters/http/message_compress/compression_filter.cc )
  s.files += %w( src/core/ext/filters/http/message_compress/compression_filter.h )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.cc )
  s.files += %w( src/core/ext/filters/http/server/http_server_filter.h )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.cc )
  s.files += %w( src/core/ext/filters/message_size/message_size_filter.h )
  s.files += %w( src/core/ext/filters/rbac/rbac_filter.cc )
  s.files += %w( src/core/ext/filters/rbac/rbac_filter.h )
  s.files += %w( src/core/ext/filters/rbac/rbac_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/rbac/rbac_service_config_parser.h )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_filter.cc )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_filter.h )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_service_config_parser.cc )
  s.files += %w( src/core/ext/filters/stateful_session/stateful_session_service_config_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.cc )
  s.files += %w( src/core/ext/transport/chttp2/alpn/alpn.h )
  s.files += %w( src/core/ext/transport/chttp2/chttp2_plugin.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.cc )
  s.files += %w( src/core/ext/transport/chttp2/client/chttp2_connector.h )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.cc )
  s.files += %w( src/core/ext/transport/chttp2/server/chttp2_server.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_decoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/bin_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/call_tracer_wrapper.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/call_tracer_wrapper.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/chttp2_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/decode_huff.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/decode_huff.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/flow_control_manager.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_data.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_goaway.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_ping.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_rst_stream.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_security.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_security.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/frame_window_update.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/goaway.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/goaway.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/header_assembler.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_constants.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder_table.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_encoder_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parse_result.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parse_result.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser_table.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/hpack_parser_table.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_client_transport.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_client_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings_manager.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings_manager.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_settings_promises.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_stats_collector.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_stats_collector.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_status.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_transport.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_transport.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/http2_ztrace_collector.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/huffsyms.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/incoming_metadata_tracker.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/internal.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/internal_channel_arg_names.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/keepalive.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/keepalive.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/legacy_frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/message_assembler.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/parsing.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_abuse_policy.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_abuse_policy.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_callbacks.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_callbacks.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_promise.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_promise.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_rate_policy.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/ping_rate_policy.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/security_frame.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/security_frame.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_data_queue.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_lists.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/stream_lists.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/transport_common.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/transport_common.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/varint.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/writable_streams.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/write_size_policy.cc )
  s.files += %w( src/core/ext/transport/chttp2/transport/write_size_policy.h )
  s.files += %w( src/core/ext/transport/chttp2/transport/writing.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.cc )
  s.files += %w( src/core/ext/transport/inproc/inproc_transport.h )
  s.files += %w( src/core/ext/transport/inproc/legacy_inproc_transport.cc )
  s.files += %w( src/core/ext/transport/inproc/legacy_inproc_transport.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/certs.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/certs.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/clusters.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/clusters.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/config_dump_shared.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/init_dump.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/listeners.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/listeners.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/memory.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/memory.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/metrics.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/metrics.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/mutex_stats.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/server_info.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/server_info.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/tap.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/admin/v3/tap.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/deprecation.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/deprecation.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/resource.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/annotations/resource.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/accesslog/v3/accesslog.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/bootstrap/v3/bootstrap.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/circuit_breaker.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/cluster.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/filter.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/cluster/v3/outlier_detection.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/common/matcher/v3/matcher.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/address.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/address.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/backoff.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/base.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/base.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/config_source.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/event_service_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/extension.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/extension.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_method_list.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/grpc_service.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/health_check.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_service.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/http_uri.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/protocol.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/proxy_protocol.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/resolver.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_cmsg_headers.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/socket_option.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/substitution_format_string.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/core/v3/udp_socket_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/endpoint_components.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/endpoint/v3/load_report.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/api_listener.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/listener_components.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/quic_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/listener/v3/udp_listener_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/metrics_service.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/metrics/v3/stats.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/overload/v3/overload.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/rbac/v3/rbac.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/route_components.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/route/v3/scoped_route.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/tap/v3/common.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/tap/v3/common.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/datadog.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/dynamic_ot.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/http_tracer.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/lightstep.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/opentelemetry.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/service.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/service.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/skywalking.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/trace.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/xray.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/config/trace/v3/zipkin.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/data/accesslog/v3/accesslog.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/clusters/aggregate/v3/cluster.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/common/fault/v3/fault.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/fault/v3/fault.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/rbac/v3/rbac.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/router/v3/router.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/client_side_weighted_round_robin/v3/client_side_weighted_round_robin.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/common/v3/common.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/pick_first/v3/pick_first.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/ring_hash/v3/ring_hash.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/load_balancing_policies/wrr_locality/v3/wrr_locality.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/cert.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/common.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/secret.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/ads.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/service/discovery/v3/discovery.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/service/load_stats/v3/lrs.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/status/v3/csds.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/service/status/v3/csds.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/cookie.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/http/v3/path_transformation.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/address.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/filter_state.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/http_inputs.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/metadata.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/node.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/number.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/path.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/regex.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/status_code_input.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/string.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/struct.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/matcher/v3/value.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/metadata/v3/metadata.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/tracing/v3/custom_tag.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/hash_policy.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http_status.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/http_status.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/percent.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/percent.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/range.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_strategy.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/ratelimit_unit.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/semantic_version.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb.h )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/envoy/type/v3/token_bucket.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/api/annotations.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/api/annotations.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/api/annotations.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/checked.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/api/expr/v1alpha1/syntax.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/api/http.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/api/http.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/api/http.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/api/httpbody.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/api/httpbody.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/api/httpbody.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/any.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/any.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/any.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/descriptor.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/descriptor.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/duration.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/duration.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/empty.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/empty.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/struct.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/struct.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/timestamp.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/timestamp.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/wrappers.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/protobuf/wrappers.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/google/rpc/status.upb.h )
  s.files += %w( src/core/ext/upb-gen/google/rpc/status.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/google/rpc/status.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/channelz.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/channelz.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/promise.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/property_list.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/channelz/v2/service.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/altscontext.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/handshaker.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/gcp/transport_security_common.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/health/v1/health.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lb/v1/load_balancer.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb.h )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/src/proto/grpc/lookup/v1/rls_config.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/migrate.upb.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/migrate.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/security.upb.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/security.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/sensitive.upb.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/sensitive.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/status.upb.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/status.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/versioning.upb.h )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/udpa/annotations/versioning.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/validate/validate.upb.h )
  s.files += %w( src/core/ext/upb-gen/validate/validate.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/validate/validate.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/migrate.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/migrate.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/security.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/security.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/sensitive.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/status.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/status.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/versioning.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/annotations/v3/versioning.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/authority.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/authority.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/cidr.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/cidr.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/collection_entry.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/collection_entry.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/context_params.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/context_params.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/extension.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/extension.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_locator.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_locator.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_name.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/core/v3/resource_name.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/data/orca/v3/orca_load_report.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/service/orca/v3/orca.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/service/orca/v3/orca.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/cel.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/domain.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/http_inputs.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/ip.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/matcher.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/range.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/regex.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/string.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/matcher/v3/string.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/cel.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/cel.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/range.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/range.upb_minitable.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/typed_struct.upb.h )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.c )
  s.files += %w( src/core/ext/upb-gen/xds/type/v3/typed_struct.upb_minitable.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/certs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/clusters.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/config_dump_shared.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/init_dump.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/listeners.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/memory.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/metrics.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/mutex_stats.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/server_info.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/admin/v3/tap.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/annotations/deprecation.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/annotations/resource.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/accesslog/v3/accesslog.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/bootstrap/v3/bootstrap.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/circuit_breaker.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/cluster.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/filter.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/cluster/v3/outlier_detection.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/common/matcher/v3/matcher.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/address.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/backoff.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/base.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/config_source.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/event_service_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/extension.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_method_list.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/grpc_service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/health_check.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/http_service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/http_uri.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/protocol.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/proxy_protocol.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/resolver.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_cmsg_headers.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_cmsg_headers.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/socket_option.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/substitution_format_string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/core/v3/udp_socket_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/endpoint_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/endpoint/v3/load_report.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/api_listener.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/listener_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/quic_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/listener/v3/udp_listener_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/metrics/v3/metrics_service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/metrics/v3/stats.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/overload/v3/overload.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/rbac/v3/rbac.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/route.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/route_components.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/route/v3/scoped_route.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/tap/v3/common.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/datadog.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/dynamic_ot.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/http_tracer.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/lightstep.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/opentelemetry.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/skywalking.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/trace.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/xray.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/config/trace/v3/zipkin.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/data/accesslog/v3/accesslog.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/clusters/aggregate/v3/cluster.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/common/fault/v3/fault.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/fault/v3/fault.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/gcp_authn/v3/gcp_authn.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/rbac/v3/rbac.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/router/v3/router.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/http/stateful_session/v3/stateful_session.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/filters/network/http_connection_manager/v3/http_connection_manager.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/http/stateful_session/cookie/v3/cookie.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/http_11_proxy/v3/upstream_http_11_connect.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/cert.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/common.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/secret.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/transport_sockets/tls/v3/tls_spiffe_validator_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/extensions/upstreams/http/v3/http_protocol_options.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/discovery/v3/ads.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/discovery/v3/discovery.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/load_stats/v3/lrs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/service/status/v3/csds.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/http/v3/cookie.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/http/v3/path_transformation.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/address.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/address.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/filter_state.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/http_inputs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/metadata.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/node.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/number.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/path.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/regex.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/status_code_input.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/struct.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/matcher/v3/value.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/metadata/v3/metadata.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/tracing/v3/custom_tag.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/hash_policy.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/http.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/http_status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/percent.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_strategy.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/ratelimit_unit.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/semantic_version.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/envoy/type/v3/token_bucket.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/annotations.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/checked.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/expr/v1alpha1/syntax.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/http.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/http.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/api/httpbody.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/any.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/descriptor.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/duration.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/empty.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/struct.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/timestamp.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/protobuf/wrappers.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/google/rpc/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/channelz.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/channelz.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/channelz.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/channelz.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/promise.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/promise.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/property_list.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/property_list.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/service.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/channelz/v2/service.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/src/proto/grpc/lookup/v1/rls_config.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/migrate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/security.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/sensitive.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/udpa/annotations/versioning.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/validate/validate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/validate/validate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/migrate.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/security.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/sensitive.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/status.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/annotations/v3/versioning.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/authority.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/cidr.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/collection_entry.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/context_params.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/extension.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource_locator.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/core/v3/resource_name.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/cel.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/domain.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/http_inputs.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/ip.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/matcher.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/regex.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/matcher/v3/string.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/cel.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/range.upbdefs.h )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.c )
  s.files += %w( src/core/ext/upbdefs-gen/xds/type/v3/typed_struct.upbdefs.h )
  s.files += %w( src/core/filter/auth/auth_filters.h )
  s.files += %w( src/core/filter/auth/client_auth_filter.cc )
  s.files += %w( src/core/filter/auth/server_auth_filter.cc )
  s.files += %w( src/core/filter/blackboard.cc )
  s.files += %w( src/core/filter/blackboard.h )
  s.files += %w( src/core/filter/filter_args.h )
  s.files += %w( src/core/filter/fused_filters.cc )
  s.files += %w( src/core/handshaker/endpoint_info/endpoint_info_handshaker.cc )
  s.files += %w( src/core/handshaker/endpoint_info/endpoint_info_handshaker.h )
  s.files += %w( src/core/handshaker/handshaker.cc )
  s.files += %w( src/core/handshaker/handshaker.h )
  s.files += %w( src/core/handshaker/handshaker_factory.h )
  s.files += %w( src/core/handshaker/handshaker_registry.cc )
  s.files += %w( src/core/handshaker/handshaker_registry.h )
  s.files += %w( src/core/handshaker/http_connect/http_connect_handshaker.cc )
  s.files += %w( src/core/handshaker/http_connect/http_connect_handshaker.h )
  s.files += %w( src/core/handshaker/http_connect/http_proxy_mapper.cc )
  s.files += %w( src/core/handshaker/http_connect/http_proxy_mapper.h )
  s.files += %w( src/core/handshaker/http_connect/xds_http_proxy_mapper.cc )
  s.files += %w( src/core/handshaker/http_connect/xds_http_proxy_mapper.h )
  s.files += %w( src/core/handshaker/proxy_mapper.h )
  s.files += %w( src/core/handshaker/proxy_mapper_registry.cc )
  s.files += %w( src/core/handshaker/proxy_mapper_registry.h )
  s.files += %w( src/core/handshaker/security/legacy_secure_endpoint.cc )
  s.files += %w( src/core/handshaker/security/pipelined_secure_endpoint.cc )
  s.files += %w( src/core/handshaker/security/secure_endpoint.cc )
  s.files += %w( src/core/handshaker/security/secure_endpoint.h )
  s.files += %w( src/core/handshaker/security/security_handshaker.cc )
  s.files += %w( src/core/handshaker/security/security_handshaker.h )
  s.files += %w( src/core/handshaker/tcp_connect/tcp_connect_handshaker.cc )
  s.files += %w( src/core/handshaker/tcp_connect/tcp_connect_handshaker.h )
  s.files += %w( src/core/lib/address_utils/parse_address.cc )
  s.files += %w( src/core/lib/address_utils/parse_address.h )
  s.files += %w( src/core/lib/address_utils/sockaddr_utils.cc )
  s.files += %w( src/core/lib/address_utils/sockaddr_utils.h )
  s.files += %w( src/core/lib/channel/channel_args.cc )
  s.files += %w( src/core/lib/channel/channel_args.h )
  s.files += %w( src/core/lib/channel/channel_args_preconditioning.cc )
  s.files += %w( src/core/lib/channel/channel_args_preconditioning.h )
  s.files += %w( src/core/lib/channel/channel_fwd.h )
  s.files += %w( src/core/lib/channel/channel_stack.cc )
  s.files += %w( src/core/lib/channel/channel_stack.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder.cc )
  s.files += %w( src/core/lib/channel/channel_stack_builder.h )
  s.files += %w( src/core/lib/channel/channel_stack_builder_impl.cc )
  s.files += %w( src/core/lib/channel/channel_stack_builder_impl.h )
  s.files += %w( src/core/lib/channel/connected_channel.cc )
  s.files += %w( src/core/lib/channel/connected_channel.h )
  s.files += %w( src/core/lib/channel/promise_based_filter.cc )
  s.files += %w( src/core/lib/channel/promise_based_filter.h )
  s.files += %w( src/core/lib/compression/compression.cc )
  s.files += %w( src/core/lib/compression/compression_internal.cc )
  s.files += %w( src/core/lib/compression/compression_internal.h )
  s.files += %w( src/core/lib/compression/message_compress.cc )
  s.files += %w( src/core/lib/compression/message_compress.h )
  s.files += %w( src/core/lib/debug/trace.cc )
  s.files += %w( src/core/lib/debug/trace.h )
  s.files += %w( src/core/lib/debug/trace_flags.cc )
  s.files += %w( src/core/lib/debug/trace_flags.h )
  s.files += %w( src/core/lib/debug/trace_impl.h )
  s.files += %w( src/core/lib/event_engine/ares_resolver.cc )
  s.files += %w( src/core/lib/event_engine/ares_resolver.h )
  s.files += %w( src/core/lib/event_engine/cf_engine/cf_engine.cc )
  s.files += %w( src/core/lib/event_engine/cf_engine/cf_engine.h )
  s.files += %w( src/core/lib/event_engine/cf_engine/cfsocket_listener.cc )
  s.files += %w( src/core/lib/event_engine/cf_engine/cfsocket_listener.h )
  s.files += %w( src/core/lib/event_engine/cf_engine/cfstream_endpoint.cc )
  s.files += %w( src/core/lib/event_engine/cf_engine/cfstream_endpoint.h )
  s.files += %w( src/core/lib/event_engine/cf_engine/cftype_unique_ref.h )
  s.files += %w( src/core/lib/event_engine/cf_engine/dns_service_resolver.cc )
  s.files += %w( src/core/lib/event_engine/cf_engine/dns_service_resolver.h )
  s.files += %w( src/core/lib/event_engine/channel_args_endpoint_config.cc )
  s.files += %w( src/core/lib/event_engine/channel_args_endpoint_config.h )
  s.files += %w( src/core/lib/event_engine/common_closures.h )
  s.files += %w( src/core/lib/event_engine/default_event_engine.cc )
  s.files += %w( src/core/lib/event_engine/default_event_engine.h )
  s.files += %w( src/core/lib/event_engine/default_event_engine_factory.cc )
  s.files += %w( src/core/lib/event_engine/default_event_engine_factory.h )
  s.files += %w( src/core/lib/event_engine/endpoint_channel_arg_wrapper.cc )
  s.files += %w( src/core/lib/event_engine/endpoint_channel_arg_wrapper.h )
  s.files += %w( src/core/lib/event_engine/event_engine.cc )
  s.files += %w( src/core/lib/event_engine/event_engine_context.h )
  s.files += %w( src/core/lib/event_engine/extensions/blocking_dns.h )
  s.files += %w( src/core/lib/event_engine/extensions/can_track_errors.h )
  s.files += %w( src/core/lib/event_engine/extensions/channelz.h )
  s.files += %w( src/core/lib/event_engine/extensions/chaotic_good_extension.h )
  s.files += %w( src/core/lib/event_engine/extensions/iomgr_compatible.h )
  s.files += %w( src/core/lib/event_engine/extensions/supports_fd.h )
  s.files += %w( src/core/lib/event_engine/extensions/supports_win_sockets.h )
  s.files += %w( src/core/lib/event_engine/extensions/tcp_trace.h )
  s.files += %w( src/core/lib/event_engine/grpc_polled_fd.h )
  s.files += %w( src/core/lib/event_engine/handle_containers.h )
  s.files += %w( src/core/lib/event_engine/memory_allocator_factory.h )
  s.files += %w( src/core/lib/event_engine/nameser.h )
  s.files += %w( src/core/lib/event_engine/poller.h )
  s.files += %w( src/core/lib/event_engine/posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_epoll1_linux.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_epoll1_linux.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_poll_posix.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/ev_poll_posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller_posix_default.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/event_poller_posix_default.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/file_descriptor_collection.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/file_descriptor_collection.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/grpc_polled_fd_posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/internal_errqueue.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/internal_errqueue.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/lockfree_event.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/lockfree_event.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/native_posix_dns_resolver.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_endpoint.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_endpoint.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_closure.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_engine_listener_utils.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_interface.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_interface_posix.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_interface_windows.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_write_event_sink.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/posix_write_event_sink.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/set_socket_dualstack.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/tcp_socket_utils.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/tcp_socket_utils.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_heap.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_heap.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_manager.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/timer_manager.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/traced_buffer_list.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/traced_buffer_list.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_eventfd.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.cc )
  s.files += %w( src/core/lib/event_engine/posix_engine/wakeup_fd_posix_default.h )
  s.files += %w( src/core/lib/event_engine/query_extensions.h )
  s.files += %w( src/core/lib/event_engine/ref_counted_dns_resolver_interface.h )
  s.files += %w( src/core/lib/event_engine/resolved_address.cc )
  s.files += %w( src/core/lib/event_engine/resolved_address_internal.h )
  s.files += %w( src/core/lib/event_engine/shim.cc )
  s.files += %w( src/core/lib/event_engine/shim.h )
  s.files += %w( src/core/lib/event_engine/slice.cc )
  s.files += %w( src/core/lib/event_engine/slice_buffer.cc )
  s.files += %w( src/core/lib/event_engine/tcp_socket_utils.cc )
  s.files += %w( src/core/lib/event_engine/tcp_socket_utils.h )
  s.files += %w( src/core/lib/event_engine/thread_local.cc )
  s.files += %w( src/core/lib/event_engine/thread_local.h )
  s.files += %w( src/core/lib/event_engine/thread_pool/thread_count.cc )
  s.files += %w( src/core/lib/event_engine/thread_pool/thread_count.h )
  s.files += %w( src/core/lib/event_engine/thread_pool/thread_pool.h )
  s.files += %w( src/core/lib/event_engine/thread_pool/thread_pool_factory.cc )
  s.files += %w( src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.cc )
  s.files += %w( src/core/lib/event_engine/thread_pool/work_stealing_thread_pool.h )
  s.files += %w( src/core/lib/event_engine/thready_event_engine/thready_event_engine.cc )
  s.files += %w( src/core/lib/event_engine/thready_event_engine/thready_event_engine.h )
  s.files += %w( src/core/lib/event_engine/time_util.cc )
  s.files += %w( src/core/lib/event_engine/time_util.h )
  s.files += %w( src/core/lib/event_engine/utils.cc )
  s.files += %w( src/core/lib/event_engine/utils.h )
  s.files += %w( src/core/lib/event_engine/windows/grpc_polled_fd_windows.cc )
  s.files += %w( src/core/lib/event_engine/windows/grpc_polled_fd_windows.h )
  s.files += %w( src/core/lib/event_engine/windows/iocp.cc )
  s.files += %w( src/core/lib/event_engine/windows/iocp.h )
  s.files += %w( src/core/lib/event_engine/windows/native_windows_dns_resolver.cc )
  s.files += %w( src/core/lib/event_engine/windows/native_windows_dns_resolver.h )
  s.files += %w( src/core/lib/event_engine/windows/win_socket.cc )
  s.files += %w( src/core/lib/event_engine/windows/win_socket.h )
  s.files += %w( src/core/lib/event_engine/windows/windows_endpoint.cc )
  s.files += %w( src/core/lib/event_engine/windows/windows_endpoint.h )
  s.files += %w( src/core/lib/event_engine/windows/windows_engine.cc )
  s.files += %w( src/core/lib/event_engine/windows/windows_engine.h )
  s.files += %w( src/core/lib/event_engine/windows/windows_listener.cc )
  s.files += %w( src/core/lib/event_engine/windows/windows_listener.h )
  s.files += %w( src/core/lib/event_engine/work_queue/basic_work_queue.cc )
  s.files += %w( src/core/lib/event_engine/work_queue/basic_work_queue.h )
  s.files += %w( src/core/lib/event_engine/work_queue/work_queue.h )
  s.files += %w( src/core/lib/experiments/config.cc )
  s.files += %w( src/core/lib/experiments/config.h )
  s.files += %w( src/core/lib/experiments/experiments.cc )
  s.files += %w( src/core/lib/experiments/experiments.h )
  s.files += %w( src/core/lib/iomgr/block_annotate.h )
  s.files += %w( src/core/lib/iomgr/buffer_list.cc )
  s.files += %w( src/core/lib/iomgr/buffer_list.h )
  s.files += %w( src/core/lib/iomgr/call_combiner.cc )
  s.files += %w( src/core/lib/iomgr/call_combiner.h )
  s.files += %w( src/core/lib/iomgr/cfstream_handle.cc )
  s.files += %w( src/core/lib/iomgr/cfstream_handle.h )
  s.files += %w( src/core/lib/iomgr/closure.cc )
  s.files += %w( src/core/lib/iomgr/closure.h )
  s.files += %w( src/core/lib/iomgr/combiner.cc )
  s.files += %w( src/core/lib/iomgr/combiner.h )
  s.files += %w( src/core/lib/iomgr/dualstack_socket_posix.cc )
  s.files += %w( src/core/lib/iomgr/dynamic_annotations.h )
  s.files += %w( src/core/lib/iomgr/endpoint.cc )
  s.files += %w( src/core/lib/iomgr/endpoint.h )
  s.files += %w( src/core/lib/iomgr/endpoint_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_cfstream.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair.h )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_posix.cc )
  s.files += %w( src/core/lib/iomgr/endpoint_pair_windows.cc )
  s.files += %w( src/core/lib/iomgr/error.cc )
  s.files += %w( src/core/lib/iomgr/error.h )
  s.files += %w( src/core/lib/iomgr/error_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/error_cfstream.h )
  s.files += %w( src/core/lib/iomgr/ev_apple.cc )
  s.files += %w( src/core/lib/iomgr/ev_apple.h )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.cc )
  s.files += %w( src/core/lib/iomgr/ev_epoll1_linux.h )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_poll_posix.h )
  s.files += %w( src/core/lib/iomgr/ev_posix.cc )
  s.files += %w( src/core/lib/iomgr/ev_posix.h )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/closure.cc )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/closure.h )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/endpoint.cc )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/endpoint.h )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/tcp_client.cc )
  s.files += %w( src/core/lib/iomgr/event_engine_shims/tcp_client.h )
  s.files += %w( src/core/lib/iomgr/exec_ctx.cc )
  s.files += %w( src/core/lib/iomgr/exec_ctx.h )
  s.files += %w( src/core/lib/iomgr/fork_posix.cc )
  s.files += %w( src/core/lib/iomgr/fork_windows.cc )
  s.files += %w( src/core/lib/iomgr/internal_errqueue.cc )
  s.files += %w( src/core/lib/iomgr/internal_errqueue.h )
  s.files += %w( src/core/lib/iomgr/iocp_windows.cc )
  s.files += %w( src/core/lib/iomgr/iocp_windows.h )
  s.files += %w( src/core/lib/iomgr/iomgr.cc )
  s.files += %w( src/core/lib/iomgr/iomgr.h )
  s.files += %w( src/core/lib/iomgr/iomgr_fwd.h )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_internal.h )
  s.files += %w( src/core/lib/iomgr/iomgr_posix.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_posix_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/iomgr_windows.cc )
  s.files += %w( src/core/lib/iomgr/lockfree_event.cc )
  s.files += %w( src/core/lib/iomgr/lockfree_event.h )
  s.files += %w( src/core/lib/iomgr/nameser.h )
  s.files += %w( src/core/lib/iomgr/polling_entity.cc )
  s.files += %w( src/core/lib/iomgr/polling_entity.h )
  s.files += %w( src/core/lib/iomgr/pollset.cc )
  s.files += %w( src/core/lib/iomgr/pollset.h )
  s.files += %w( src/core/lib/iomgr/pollset_set.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set.h )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.cc )
  s.files += %w( src/core/lib/iomgr/pollset_set_windows.h )
  s.files += %w( src/core/lib/iomgr/pollset_windows.cc )
  s.files += %w( src/core/lib/iomgr/pollset_windows.h )
  s.files += %w( src/core/lib/iomgr/port.h )
  s.files += %w( src/core/lib/iomgr/resolve_address.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_impl.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_posix.h )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.cc )
  s.files += %w( src/core/lib/iomgr/resolve_address_windows.h )
  s.files += %w( src/core/lib/iomgr/resolved_address.h )
  s.files += %w( src/core/lib/iomgr/sockaddr.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_posix.h )
  s.files += %w( src/core/lib/iomgr/sockaddr_utils_posix.cc )
  s.files += %w( src/core/lib/iomgr/sockaddr_windows.h )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_factory_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_mutator.cc )
  s.files += %w( src/core/lib/iomgr/socket_mutator.h )
  s.files += %w( src/core/lib/iomgr/socket_utils.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_common_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_linux.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.cc )
  s.files += %w( src/core/lib/iomgr/socket_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/socket_utils_windows.cc )
  s.files += %w( src/core/lib/iomgr/socket_windows.cc )
  s.files += %w( src/core/lib/iomgr/socket_windows.h )
  s.files += %w( src/core/lib/iomgr/systemd_utils.cc )
  s.files += %w( src/core/lib/iomgr/systemd_utils.h )
  s.files += %w( src/core/lib/iomgr/tcp_client.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client.h )
  s.files += %w( src/core/lib/iomgr/tcp_client_cfstream.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_client_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_client_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server.h )
  s.files += %w( src/core/lib/iomgr/tcp_server_posix.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix.h )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_common.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_ifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_utils_posix_noifaddrs.cc )
  s.files += %w( src/core/lib/iomgr/tcp_server_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_windows.cc )
  s.files += %w( src/core/lib/iomgr/tcp_windows.h )
  s.files += %w( src/core/lib/iomgr/timer.cc )
  s.files += %w( src/core/lib/iomgr/timer.h )
  s.files += %w( src/core/lib/iomgr/timer_generic.cc )
  s.files += %w( src/core/lib/iomgr/timer_generic.h )
  s.files += %w( src/core/lib/iomgr/timer_heap.cc )
  s.files += %w( src/core/lib/iomgr/timer_heap.h )
  s.files += %w( src/core/lib/iomgr/timer_manager.cc )
  s.files += %w( src/core/lib/iomgr/timer_manager.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.cc )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix.h )
  s.files += %w( src/core/lib/iomgr/unix_sockets_posix_noop.cc )
  s.files += %w( src/core/lib/iomgr/vsock.cc )
  s.files += %w( src/core/lib/iomgr/vsock.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_eventfd.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_nospecial.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_pipe.h )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.cc )
  s.files += %w( src/core/lib/iomgr/wakeup_fd_posix.h )
  s.files += %w( src/core/lib/promise/activity.cc )
  s.files += %w( src/core/lib/promise/activity.h )
  s.files += %w( src/core/lib/promise/all_ok.h )
  s.files += %w( src/core/lib/promise/arena_promise.h )
  s.files += %w( src/core/lib/promise/cancel_callback.h )
  s.files += %w( src/core/lib/promise/context.h )
  s.files += %w( src/core/lib/promise/detail/basic_seq.h )
  s.files += %w( src/core/lib/promise/detail/join_state.h )
  s.files += %w( src/core/lib/promise/detail/promise_factory.h )
  s.files += %w( src/core/lib/promise/detail/promise_like.h )
  s.files += %w( src/core/lib/promise/detail/promise_variant.h )
  s.files += %w( src/core/lib/promise/detail/seq_state.h )
  s.files += %w( src/core/lib/promise/detail/status.h )
  s.files += %w( src/core/lib/promise/exec_ctx_wakeup_scheduler.h )
  s.files += %w( src/core/lib/promise/for_each.h )
  s.files += %w( src/core/lib/promise/if.h )
  s.files += %w( src/core/lib/promise/inter_activity_latch.h )
  s.files += %w( src/core/lib/promise/inter_activity_mutex.h )
  s.files += %w( src/core/lib/promise/interceptor_list.h )
  s.files += %w( src/core/lib/promise/latch.h )
  s.files += %w( src/core/lib/promise/loop.h )
  s.files += %w( src/core/lib/promise/map.h )
  s.files += %w( src/core/lib/promise/match_promise.h )
  s.files += %w( src/core/lib/promise/mpsc.cc )
  s.files += %w( src/core/lib/promise/mpsc.h )
  s.files += %w( src/core/lib/promise/observable.h )
  s.files += %w( src/core/lib/promise/party.cc )
  s.files += %w( src/core/lib/promise/party.h )
  s.files += %w( src/core/lib/promise/pipe.h )
  s.files += %w( src/core/lib/promise/poll.h )
  s.files += %w( src/core/lib/promise/prioritized_race.h )
  s.files += %w( src/core/lib/promise/promise.h )
  s.files += %w( src/core/lib/promise/race.h )
  s.files += %w( src/core/lib/promise/seq.h )
  s.files += %w( src/core/lib/promise/sleep.cc )
  s.files += %w( src/core/lib/promise/sleep.h )
  s.files += %w( src/core/lib/promise/status_flag.h )
  s.files += %w( src/core/lib/promise/try_join.h )
  s.files += %w( src/core/lib/promise/try_seq.h )
  s.files += %w( src/core/lib/promise/wait_set.cc )
  s.files += %w( src/core/lib/promise/wait_set.h )
  s.files += %w( src/core/lib/resource_quota/api.cc )
  s.files += %w( src/core/lib/resource_quota/api.h )
  s.files += %w( src/core/lib/resource_quota/arena.cc )
  s.files += %w( src/core/lib/resource_quota/arena.h )
  s.files += %w( src/core/lib/resource_quota/connection_quota.cc )
  s.files += %w( src/core/lib/resource_quota/connection_quota.h )
  s.files += %w( src/core/lib/resource_quota/memory_quota.cc )
  s.files += %w( src/core/lib/resource_quota/memory_quota.h )
  s.files += %w( src/core/lib/resource_quota/periodic_update.cc )
  s.files += %w( src/core/lib/resource_quota/periodic_update.h )
  s.files += %w( src/core/lib/resource_quota/resource_quota.cc )
  s.files += %w( src/core/lib/resource_quota/resource_quota.h )
  s.files += %w( src/core/lib/resource_quota/stream_quota.cc )
  s.files += %w( src/core/lib/resource_quota/stream_quota.h )
  s.files += %w( src/core/lib/resource_quota/telemetry.h )
  s.files += %w( src/core/lib/resource_quota/thread_quota.cc )
  s.files += %w( src/core/lib/resource_quota/thread_quota.h )
  s.files += %w( src/core/lib/resource_tracker/resource_tracker.cc )
  s.files += %w( src/core/lib/resource_tracker/resource_tracker.h )
  s.files += %w( src/core/lib/security/authorization/audit_logging.cc )
  s.files += %w( src/core/lib/security/authorization/audit_logging.h )
  s.files += %w( src/core/lib/security/authorization/authorization_engine.h )
  s.files += %w( src/core/lib/security/authorization/authorization_policy_provider.h )
  s.files += %w( src/core/lib/security/authorization/authorization_policy_provider_vtable.cc )
  s.files += %w( src/core/lib/security/authorization/evaluate_args.cc )
  s.files += %w( src/core/lib/security/authorization/evaluate_args.h )
  s.files += %w( src/core/lib/security/authorization/grpc_authorization_engine.cc )
  s.files += %w( src/core/lib/security/authorization/grpc_authorization_engine.h )
  s.files += %w( src/core/lib/security/authorization/grpc_server_authz_filter.cc )
  s.files += %w( src/core/lib/security/authorization/grpc_server_authz_filter.h )
  s.files += %w( src/core/lib/security/authorization/matchers.cc )
  s.files += %w( src/core/lib/security/authorization/matchers.h )
  s.files += %w( src/core/lib/security/authorization/rbac_policy.cc )
  s.files += %w( src/core/lib/security/authorization/rbac_policy.h )
  s.files += %w( src/core/lib/security/authorization/stdout_logger.cc )
  s.files += %w( src/core/lib/security/authorization/stdout_logger.h )
  s.files += %w( src/core/lib/slice/percent_encoding.cc )
  s.files += %w( src/core/lib/slice/percent_encoding.h )
  s.files += %w( src/core/lib/slice/slice.cc )
  s.files += %w( src/core/lib/slice/slice.h )
  s.files += %w( src/core/lib/slice/slice_buffer.cc )
  s.files += %w( src/core/lib/slice/slice_buffer.h )
  s.files += %w( src/core/lib/slice/slice_internal.h )
  s.files += %w( src/core/lib/slice/slice_refcount.h )
  s.files += %w( src/core/lib/slice/slice_string_helpers.cc )
  s.files += %w( src/core/lib/slice/slice_string_helpers.h )
  s.files += %w( src/core/lib/surface/byte_buffer.cc )
  s.files += %w( src/core/lib/surface/byte_buffer_reader.cc )
  s.files += %w( src/core/lib/surface/call.cc )
  s.files += %w( src/core/lib/surface/call.h )
  s.files += %w( src/core/lib/surface/call_details.cc )
  s.files += %w( src/core/lib/surface/call_log_batch.cc )
  s.files += %w( src/core/lib/surface/call_test_only.h )
  s.files += %w( src/core/lib/surface/call_utils.cc )
  s.files += %w( src/core/lib/surface/call_utils.h )
  s.files += %w( src/core/lib/surface/channel.cc )
  s.files += %w( src/core/lib/surface/channel.h )
  s.files += %w( src/core/lib/surface/channel_create.cc )
  s.files += %w( src/core/lib/surface/channel_create.h )
  s.files += %w( src/core/lib/surface/channel_init.cc )
  s.files += %w( src/core/lib/surface/channel_init.h )
  s.files += %w( src/core/lib/surface/channel_stack_type.cc )
  s.files += %w( src/core/lib/surface/channel_stack_type.h )
  s.files += %w( src/core/lib/surface/completion_queue.cc )
  s.files += %w( src/core/lib/surface/completion_queue.h )
  s.files += %w( src/core/lib/surface/completion_queue_factory.cc )
  s.files += %w( src/core/lib/surface/completion_queue_factory.h )
  s.files += %w( src/core/lib/surface/connection_context.cc )
  s.files += %w( src/core/lib/surface/connection_context.h )
  s.files += %w( src/core/lib/surface/event_string.cc )
  s.files += %w( src/core/lib/surface/event_string.h )
  s.files += %w( src/core/lib/surface/filter_stack_call.cc )
  s.files += %w( src/core/lib/surface/filter_stack_call.h )
  s.files += %w( src/core/lib/surface/init.cc )
  s.files += %w( src/core/lib/surface/init.h )
  s.files += %w( src/core/lib/surface/init_internally.cc )
  s.files += %w( src/core/lib/surface/init_internally.h )
  s.files += %w( src/core/lib/surface/lame_client.cc )
  s.files += %w( src/core/lib/surface/lame_client.h )
  s.files += %w( src/core/lib/surface/legacy_channel.cc )
  s.files += %w( src/core/lib/surface/legacy_channel.h )
  s.files += %w( src/core/lib/surface/metadata_array.cc )
  s.files += %w( src/core/lib/surface/validate_metadata.cc )
  s.files += %w( src/core/lib/surface/validate_metadata.h )
  s.files += %w( src/core/lib/surface/version.cc )
  s.files += %w( src/core/lib/transport/bdp_estimator.cc )
  s.files += %w( src/core/lib/transport/bdp_estimator.h )
  s.files += %w( src/core/lib/transport/call_final_info.cc )
  s.files += %w( src/core/lib/transport/call_final_info.h )
  s.files += %w( src/core/lib/transport/connectivity_state.cc )
  s.files += %w( src/core/lib/transport/connectivity_state.h )
  s.files += %w( src/core/lib/transport/error_utils.cc )
  s.files += %w( src/core/lib/transport/error_utils.h )
  s.files += %w( src/core/lib/transport/promise_endpoint.cc )
  s.files += %w( src/core/lib/transport/promise_endpoint.h )
  s.files += %w( src/core/lib/transport/status_conversion.cc )
  s.files += %w( src/core/lib/transport/status_conversion.h )
  s.files += %w( src/core/lib/transport/timeout_encoding.cc )
  s.files += %w( src/core/lib/transport/timeout_encoding.h )
  s.files += %w( src/core/lib/transport/transport.cc )
  s.files += %w( src/core/lib/transport/transport.h )
  s.files += %w( src/core/lib/transport/transport_framing_endpoint_extension.h )
  s.files += %w( src/core/lib/transport/transport_fwd.h )
  s.files += %w( src/core/lib/transport/transport_op_string.cc )
  s.files += %w( src/core/load_balancing/address_filtering.cc )
  s.files += %w( src/core/load_balancing/address_filtering.h )
  s.files += %w( src/core/load_balancing/backend_metric_data.h )
  s.files += %w( src/core/load_balancing/backend_metric_parser.cc )
  s.files += %w( src/core/load_balancing/backend_metric_parser.h )
  s.files += %w( src/core/load_balancing/child_policy_handler.cc )
  s.files += %w( src/core/load_balancing/child_policy_handler.h )
  s.files += %w( src/core/load_balancing/delegating_helper.h )
  s.files += %w( src/core/load_balancing/endpoint_list.cc )
  s.files += %w( src/core/load_balancing/endpoint_list.h )
  s.files += %w( src/core/load_balancing/grpclb/client_load_reporting_filter.cc )
  s.files += %w( src/core/load_balancing/grpclb/client_load_reporting_filter.h )
  s.files += %w( src/core/load_balancing/grpclb/grpclb.cc )
  s.files += %w( src/core/load_balancing/grpclb/grpclb.h )
  s.files += %w( src/core/load_balancing/grpclb/grpclb_balancer_addresses.cc )
  s.files += %w( src/core/load_balancing/grpclb/grpclb_balancer_addresses.h )
  s.files += %w( src/core/load_balancing/grpclb/grpclb_client_stats.cc )
  s.files += %w( src/core/load_balancing/grpclb/grpclb_client_stats.h )
  s.files += %w( src/core/load_balancing/grpclb/load_balancer_api.cc )
  s.files += %w( src/core/load_balancing/grpclb/load_balancer_api.h )
  s.files += %w( src/core/load_balancing/health_check_client.cc )
  s.files += %w( src/core/load_balancing/health_check_client.h )
  s.files += %w( src/core/load_balancing/health_check_client_internal.h )
  s.files += %w( src/core/load_balancing/lb_policy.cc )
  s.files += %w( src/core/load_balancing/lb_policy.h )
  s.files += %w( src/core/load_balancing/lb_policy_factory.h )
  s.files += %w( src/core/load_balancing/lb_policy_registry.cc )
  s.files += %w( src/core/load_balancing/lb_policy_registry.h )
  s.files += %w( src/core/load_balancing/oob_backend_metric.cc )
  s.files += %w( src/core/load_balancing/oob_backend_metric.h )
  s.files += %w( src/core/load_balancing/oob_backend_metric_internal.h )
  s.files += %w( src/core/load_balancing/outlier_detection/outlier_detection.cc )
  s.files += %w( src/core/load_balancing/outlier_detection/outlier_detection.h )
  s.files += %w( src/core/load_balancing/pick_first/pick_first.cc )
  s.files += %w( src/core/load_balancing/pick_first/pick_first.h )
  s.files += %w( src/core/load_balancing/priority/priority.cc )
  s.files += %w( src/core/load_balancing/ring_hash/ring_hash.cc )
  s.files += %w( src/core/load_balancing/ring_hash/ring_hash.h )
  s.files += %w( src/core/load_balancing/rls/rls.cc )
  s.files += %w( src/core/load_balancing/rls/rls.h )
  s.files += %w( src/core/load_balancing/round_robin/round_robin.cc )
  s.files += %w( src/core/load_balancing/subchannel_interface.h )
  s.files += %w( src/core/load_balancing/weighted_round_robin/static_stride_scheduler.cc )
  s.files += %w( src/core/load_balancing/weighted_round_robin/static_stride_scheduler.h )
  s.files += %w( src/core/load_balancing/weighted_round_robin/weighted_round_robin.cc )
  s.files += %w( src/core/load_balancing/weighted_target/weighted_target.cc )
  s.files += %w( src/core/load_balancing/weighted_target/weighted_target.h )
  s.files += %w( src/core/load_balancing/xds/cds.cc )
  s.files += %w( src/core/load_balancing/xds/xds_channel_args.h )
  s.files += %w( src/core/load_balancing/xds/xds_cluster_impl.cc )
  s.files += %w( src/core/load_balancing/xds/xds_cluster_manager.cc )
  s.files += %w( src/core/load_balancing/xds/xds_override_host.cc )
  s.files += %w( src/core/load_balancing/xds/xds_override_host.h )
  s.files += %w( src/core/load_balancing/xds/xds_wrr_locality.cc )
  s.files += %w( src/core/net/socket_mutator.cc )
  s.files += %w( src/core/net/socket_mutator.h )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry.cc )
  s.files += %w( src/core/plugin_registry/grpc_plugin_registry_extra.cc )
  s.files += %w( src/core/resolver/dns/c_ares/dns_resolver_ares.cc )
  s.files += %w( src/core/resolver/dns/c_ares/dns_resolver_ares.h )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_ev_driver.h )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_ev_driver_posix.cc )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_ev_driver_windows.cc )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_wrapper.cc )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_wrapper.h )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_wrapper_posix.cc )
  s.files += %w( src/core/resolver/dns/c_ares/grpc_ares_wrapper_windows.cc )
  s.files += %w( src/core/resolver/dns/dns_resolver_plugin.cc )
  s.files += %w( src/core/resolver/dns/dns_resolver_plugin.h )
  s.files += %w( src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.cc )
  s.files += %w( src/core/resolver/dns/event_engine/event_engine_client_channel_resolver.h )
  s.files += %w( src/core/resolver/dns/event_engine/service_config_helper.cc )
  s.files += %w( src/core/resolver/dns/event_engine/service_config_helper.h )
  s.files += %w( src/core/resolver/dns/native/dns_resolver.cc )
  s.files += %w( src/core/resolver/dns/native/dns_resolver.h )
  s.files += %w( src/core/resolver/endpoint_addresses.cc )
  s.files += %w( src/core/resolver/endpoint_addresses.h )
  s.files += %w( src/core/resolver/fake/fake_resolver.cc )
  s.files += %w( src/core/resolver/fake/fake_resolver.h )
  s.files += %w( src/core/resolver/google_c2p/google_c2p_resolver.cc )
  s.files += %w( src/core/resolver/polling_resolver.cc )
  s.files += %w( src/core/resolver/polling_resolver.h )
  s.files += %w( src/core/resolver/resolver.cc )
  s.files += %w( src/core/resolver/resolver.h )
  s.files += %w( src/core/resolver/resolver_factory.h )
  s.files += %w( src/core/resolver/resolver_registry.cc )
  s.files += %w( src/core/resolver/resolver_registry.h )
  s.files += %w( src/core/resolver/server_address.h )
  s.files += %w( src/core/resolver/sockaddr/sockaddr_resolver.cc )
  s.files += %w( src/core/resolver/xds/xds_config.cc )
  s.files += %w( src/core/resolver/xds/xds_config.h )
  s.files += %w( src/core/resolver/xds/xds_dependency_manager.cc )
  s.files += %w( src/core/resolver/xds/xds_dependency_manager.h )
  s.files += %w( src/core/resolver/xds/xds_resolver.cc )
  s.files += %w( src/core/resolver/xds/xds_resolver_attributes.h )
  s.files += %w( src/core/server/add_port.cc )
  s.files += %w( src/core/server/server.cc )
  s.files += %w( src/core/server/server.h )
  s.files += %w( src/core/server/server_call_tracer_filter.cc )
  s.files += %w( src/core/server/server_call_tracer_filter.h )
  s.files += %w( src/core/server/server_config_selector.h )
  s.files += %w( src/core/server/server_config_selector_filter.cc )
  s.files += %w( src/core/server/server_config_selector_filter.h )
  s.files += %w( src/core/server/server_interface.h )
  s.files += %w( src/core/server/xds_channel_stack_modifier.cc )
  s.files += %w( src/core/server/xds_channel_stack_modifier.h )
  s.files += %w( src/core/server/xds_server_config_fetcher.cc )
  s.files += %w( src/core/service_config/service_config.h )
  s.files += %w( src/core/service_config/service_config_call_data.h )
  s.files += %w( src/core/service_config/service_config_channel_arg_filter.cc )
  s.files += %w( src/core/service_config/service_config_channel_arg_filter.h )
  s.files += %w( src/core/service_config/service_config_impl.cc )
  s.files += %w( src/core/service_config/service_config_impl.h )
  s.files += %w( src/core/service_config/service_config_parser.cc )
  s.files += %w( src/core/service_config/service_config_parser.h )
  s.files += %w( src/core/telemetry/call_tracer.cc )
  s.files += %w( src/core/telemetry/call_tracer.h )
  s.files += %w( src/core/telemetry/context_list_entry.cc )
  s.files += %w( src/core/telemetry/context_list_entry.h )
  s.files += %w( src/core/telemetry/default_tcp_tracer.cc )
  s.files += %w( src/core/telemetry/default_tcp_tracer.h )
  s.files += %w( src/core/telemetry/histogram.h )
  s.files += %w( src/core/telemetry/histogram_view.cc )
  s.files += %w( src/core/telemetry/histogram_view.h )
  s.files += %w( src/core/telemetry/instrument.cc )
  s.files += %w( src/core/telemetry/instrument.h )
  s.files += %w( src/core/telemetry/metrics.cc )
  s.files += %w( src/core/telemetry/metrics.h )
  s.files += %w( src/core/telemetry/stats.cc )
  s.files += %w( src/core/telemetry/stats.h )
  s.files += %w( src/core/telemetry/stats_data.cc )
  s.files += %w( src/core/telemetry/stats_data.h )
  s.files += %w( src/core/telemetry/tcp_tracer.cc )
  s.files += %w( src/core/telemetry/tcp_tracer.h )
  s.files += %w( src/core/transport/auth_context.cc )
  s.files += %w( src/core/transport/auth_context.h )
  s.files += %w( src/core/transport/auth_context_comparator_registry.h )
  s.files += %w( src/core/transport/endpoint_transport.h )
  s.files += %w( src/core/transport/endpoint_transport_client_channel_factory.cc )
  s.files += %w( src/core/transport/endpoint_transport_client_channel_factory.h )
  s.files += %w( src/core/tsi/alts/crypt/aes_gcm.cc )
  s.files += %w( src/core/tsi/alts/crypt/gsec.cc )
  s.files += %w( src/core/tsi/alts/crypt/gsec.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_counter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_counter.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_crypter.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_frame_protector.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_frame_protector.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_record_protocol_crypter_common.h )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_seal_privacy_integrity_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/alts_unseal_privacy_integrity_crypter.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/frame_handler.cc )
  s.files += %w( src/core/tsi/alts/frame_protector/frame_handler.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_handshaker_client.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_handshaker_client.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_shared_resource.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_shared_resource.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_handshaker_private.h )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_utils.cc )
  s.files += %w( src/core/tsi/alts/handshaker/alts_tsi_utils.h )
  s.files += %w( src/core/tsi/alts/handshaker/transport_security_common_api.cc )
  s.files += %w( src/core/tsi/alts/handshaker/transport_security_common_api.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_integrity_only_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_privacy_integrity_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_grpc_record_protocol_common.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_iovec_record_protocol.h )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.cc )
  s.files += %w( src/core/tsi/alts/zero_copy_frame_protector/alts_zero_copy_grpc_protector.h )
  s.files += %w( src/core/tsi/fake_transport_security.cc )
  s.files += %w( src/core/tsi/fake_transport_security.h )
  s.files += %w( src/core/tsi/local_transport_security.cc )
  s.files += %w( src/core/tsi/local_transport_security.h )
  s.files += %w( src/core/tsi/ssl/key_logging/ssl_key_logging.cc )
  s.files += %w( src/core/tsi/ssl/key_logging/ssl_key_logging.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_boringssl.cc )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_cache.cc )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_cache.h )
  s.files += %w( src/core/tsi/ssl/session_cache/ssl_session_openssl.cc )
  s.files += %w( src/core/tsi/ssl_transport_security.cc )
  s.files += %w( src/core/tsi/ssl_transport_security.h )
  s.files += %w( src/core/tsi/ssl_transport_security_utils.cc )
  s.files += %w( src/core/tsi/ssl_transport_security_utils.h )
  s.files += %w( src/core/tsi/ssl_types.h )
  s.files += %w( src/core/tsi/transport_security.cc )
  s.files += %w( src/core/tsi/transport_security.h )
  s.files += %w( src/core/tsi/transport_security_grpc.cc )
  s.files += %w( src/core/tsi/transport_security_grpc.h )
  s.files += %w( src/core/tsi/transport_security_interface.h )
  s.files += %w( src/core/util/alloc.cc )
  s.files += %w( src/core/util/alloc.h )
  s.files += %w( src/core/util/atomic_utils.h )
  s.files += %w( src/core/util/avl.h )
  s.files += %w( src/core/util/backoff.cc )
  s.files += %w( src/core/util/backoff.h )
  s.files += %w( src/core/util/bitset.h )
  s.files += %w( src/core/util/check_class_size.h )
  s.files += %w( src/core/util/chunked_vector.h )
  s.files += %w( src/core/util/construct_destruct.h )
  s.files += %w( src/core/util/cpp_impl_of.h )
  s.files += %w( src/core/util/crash.cc )
  s.files += %w( src/core/util/crash.h )
  s.files += %w( src/core/util/debug_location.h )
  s.files += %w( src/core/util/directory_reader.h )
  s.files += %w( src/core/util/down_cast.h )
  s.files += %w( src/core/util/dual_ref_counted.h )
  s.files += %w( src/core/util/dump_args.cc )
  s.files += %w( src/core/util/dump_args.h )
  s.files += %w( src/core/util/env.h )
  s.files += %w( src/core/util/event_log.cc )
  s.files += %w( src/core/util/event_log.h )
  s.files += %w( src/core/util/examine_stack.cc )
  s.files += %w( src/core/util/examine_stack.h )
  s.files += %w( src/core/util/fork.cc )
  s.files += %w( src/core/util/fork.h )
  s.files += %w( src/core/util/function_signature.h )
  s.files += %w( src/core/util/gcp_metadata_query.cc )
  s.files += %w( src/core/util/gcp_metadata_query.h )
  s.files += %w( src/core/util/gethostname.h )
  s.files += %w( src/core/util/gethostname_fallback.cc )
  s.files += %w( src/core/util/gethostname_host_name_max.cc )
  s.files += %w( src/core/util/gethostname_sysconf.cc )
  s.files += %w( src/core/util/glob.cc )
  s.files += %w( src/core/util/glob.h )
  s.files += %w( src/core/util/gpr_time.cc )
  s.files += %w( src/core/util/grpc_check.cc )
  s.files += %w( src/core/util/grpc_check.h )
  s.files += %w( src/core/util/grpc_if_nametoindex.h )
  s.files += %w( src/core/util/grpc_if_nametoindex_posix.cc )
  s.files += %w( src/core/util/grpc_if_nametoindex_unsupported.cc )
  s.files += %w( src/core/util/host_port.cc )
  s.files += %w( src/core/util/host_port.h )
  s.files += %w( src/core/util/http_client/format_request.cc )
  s.files += %w( src/core/util/http_client/format_request.h )
  s.files += %w( src/core/util/http_client/httpcli.cc )
  s.files += %w( src/core/util/http_client/httpcli.h )
  s.files += %w( src/core/util/http_client/httpcli_security_connector.cc )
  s.files += %w( src/core/util/http_client/httpcli_ssl_credentials.h )
  s.files += %w( src/core/util/http_client/parser.cc )
  s.files += %w( src/core/util/http_client/parser.h )
  s.files += %w( src/core/util/if_list.h )
  s.files += %w( src/core/util/iphone/cpu.cc )
  s.files += %w( src/core/util/json/json.h )
  s.files += %w( src/core/util/json/json_args.h )
  s.files += %w( src/core/util/json/json_channel_args.h )
  s.files += %w( src/core/util/json/json_object_loader.cc )
  s.files += %w( src/core/util/json/json_object_loader.h )
  s.files += %w( src/core/util/json/json_reader.cc )
  s.files += %w( src/core/util/json/json_reader.h )
  s.files += %w( src/core/util/json/json_util.cc )
  s.files += %w( src/core/util/json/json_util.h )
  s.files += %w( src/core/util/json/json_writer.cc )
  s.files += %w( src/core/util/json/json_writer.h )
  s.files += %w( src/core/util/latent_see.cc )
  s.files += %w( src/core/util/latent_see.h )
  s.files += %w( src/core/util/linux/cpu.cc )
  s.files += %w( src/core/util/linux/env.cc )
  s.files += %w( src/core/util/load_file.cc )
  s.files += %w( src/core/util/load_file.h )
  s.files += %w( src/core/util/log.cc )
  s.files += %w( src/core/util/lru_cache.h )
  s.files += %w( src/core/util/manual_constructor.h )
  s.files += %w( src/core/util/match.h )
  s.files += %w( src/core/util/matchers.cc )
  s.files += %w( src/core/util/matchers.h )
  s.files += %w( src/core/util/memory.h )
  s.files += %w( src/core/util/memory_usage.h )
  s.files += %w( src/core/util/mpscq.cc )
  s.files += %w( src/core/util/mpscq.h )
  s.files += %w( src/core/util/msys/tmpfile.cc )
  s.files += %w( src/core/util/no_destruct.h )
  s.files += %w( src/core/util/notification.h )
  s.files += %w( src/core/util/orphanable.h )
  s.files += %w( src/core/util/overload.h )
  s.files += %w( src/core/util/packed_table.h )
  s.files += %w( src/core/util/per_cpu.cc )
  s.files += %w( src/core/util/per_cpu.h )
  s.files += %w( src/core/util/posix/cpu.cc )
  s.files += %w( src/core/util/posix/directory_reader.cc )
  s.files += %w( src/core/util/posix/env.cc )
  s.files += %w( src/core/util/posix/stat.cc )
  s.files += %w( src/core/util/posix/string.cc )
  s.files += %w( src/core/util/posix/sync.cc )
  s.files += %w( src/core/util/posix/thd.cc )
  s.files += %w( src/core/util/posix/time.cc )
  s.files += %w( src/core/util/posix/tmpfile.cc )
  s.files += %w( src/core/util/postmortem_emit.cc )
  s.files += %w( src/core/util/postmortem_emit.h )
  s.files += %w( src/core/util/random_early_detection.cc )
  s.files += %w( src/core/util/random_early_detection.h )
  s.files += %w( src/core/util/ref_counted.h )
  s.files += %w( src/core/util/ref_counted_ptr.h )
  s.files += %w( src/core/util/ref_counted_string.cc )
  s.files += %w( src/core/util/ref_counted_string.h )
  s.files += %w( src/core/util/shared_bit_gen.cc )
  s.files += %w( src/core/util/shared_bit_gen.h )
  s.files += %w( src/core/util/single_set_ptr.h )
  s.files += %w( src/core/util/sorted_pack.h )
  s.files += %w( src/core/util/spinlock.h )
  s.files += %w( src/core/util/stat.h )
  s.files += %w( src/core/util/status_helper.cc )
  s.files += %w( src/core/util/status_helper.h )
  s.files += %w( src/core/util/strerror.cc )
  s.files += %w( src/core/util/strerror.h )
  s.files += %w( src/core/util/string.cc )
  s.files += %w( src/core/util/string.h )
  s.files += %w( src/core/util/sync.cc )
  s.files += %w( src/core/util/sync.h )
  s.files += %w( src/core/util/sync_abseil.cc )
  s.files += %w( src/core/util/table.h )
  s.files += %w( src/core/util/tchar.cc )
  s.files += %w( src/core/util/tchar.h )
  s.files += %w( src/core/util/thd.h )
  s.files += %w( src/core/util/time.cc )
  s.files += %w( src/core/util/time.h )
  s.files += %w( src/core/util/time_averaged_stats.cc )
  s.files += %w( src/core/util/time_averaged_stats.h )
  s.files += %w( src/core/util/time_precise.cc )
  s.files += %w( src/core/util/time_precise.h )
  s.files += %w( src/core/util/time_util.cc )
  s.files += %w( src/core/util/time_util.h )
  s.files += %w( src/core/util/tmpfile.h )
  s.files += %w( src/core/util/trie_lookup.h )
  s.files += %w( src/core/util/type_list.h )
  s.files += %w( src/core/util/unique_ptr_with_bitset.h )
  s.files += %w( src/core/util/unique_type_name.h )
  s.files += %w( src/core/util/upb_utils.h )
  s.files += %w( src/core/util/uri.cc )
  s.files += %w( src/core/util/uri.h )
  s.files += %w( src/core/util/useful.h )
  s.files += %w( src/core/util/uuid_v4.cc )
  s.files += %w( src/core/util/uuid_v4.h )
  s.files += %w( src/core/util/validation_errors.cc )
  s.files += %w( src/core/util/validation_errors.h )
  s.files += %w( src/core/util/wait_for_single_owner.cc )
  s.files += %w( src/core/util/wait_for_single_owner.h )
  s.files += %w( src/core/util/windows/cpu.cc )
  s.files += %w( src/core/util/windows/directory_reader.cc )
  s.files += %w( src/core/util/windows/env.cc )
  s.files += %w( src/core/util/windows/stat.cc )
  s.files += %w( src/core/util/windows/string.cc )
  s.files += %w( src/core/util/windows/string_util.cc )
  s.files += %w( src/core/util/windows/sync.cc )
  s.files += %w( src/core/util/windows/thd.cc )
  s.files += %w( src/core/util/windows/time.cc )
  s.files += %w( src/core/util/windows/tmpfile.cc )
  s.files += %w( src/core/util/work_serializer.cc )
  s.files += %w( src/core/util/work_serializer.h )
  s.files += %w( src/core/util/xxhash_inline.h )
  s.files += %w( src/core/xds/grpc/certificate_provider_store.cc )
  s.files += %w( src/core/xds/grpc/certificate_provider_store.h )
  s.files += %w( src/core/xds/grpc/file_watcher_certificate_provider_factory.cc )
  s.files += %w( src/core/xds/grpc/file_watcher_certificate_provider_factory.h )
  s.files += %w( src/core/xds/grpc/xds_audit_logger_registry.cc )
  s.files += %w( src/core/xds/grpc/xds_audit_logger_registry.h )
  s.files += %w( src/core/xds/grpc/xds_bootstrap_grpc.cc )
  s.files += %w( src/core/xds/grpc/xds_bootstrap_grpc.h )
  s.files += %w( src/core/xds/grpc/xds_certificate_provider.cc )
  s.files += %w( src/core/xds/grpc/xds_certificate_provider.h )
  s.files += %w( src/core/xds/grpc/xds_client_grpc.cc )
  s.files += %w( src/core/xds/grpc/xds_client_grpc.h )
  s.files += %w( src/core/xds/grpc/xds_cluster.cc )
  s.files += %w( src/core/xds/grpc/xds_cluster.h )
  s.files += %w( src/core/xds/grpc/xds_cluster_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_cluster_parser.h )
  s.files += %w( src/core/xds/grpc/xds_cluster_specifier_plugin.cc )
  s.files += %w( src/core/xds/grpc/xds_cluster_specifier_plugin.h )
  s.files += %w( src/core/xds/grpc/xds_common_types.cc )
  s.files += %w( src/core/xds/grpc/xds_common_types.h )
  s.files += %w( src/core/xds/grpc/xds_common_types_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_common_types_parser.h )
  s.files += %w( src/core/xds/grpc/xds_endpoint.cc )
  s.files += %w( src/core/xds/grpc/xds_endpoint.h )
  s.files += %w( src/core/xds/grpc/xds_endpoint_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_endpoint_parser.h )
  s.files += %w( src/core/xds/grpc/xds_health_status.cc )
  s.files += %w( src/core/xds/grpc/xds_health_status.h )
  s.files += %w( src/core/xds/grpc/xds_http_fault_filter.cc )
  s.files += %w( src/core/xds/grpc/xds_http_fault_filter.h )
  s.files += %w( src/core/xds/grpc/xds_http_filter.h )
  s.files += %w( src/core/xds/grpc/xds_http_filter_registry.cc )
  s.files += %w( src/core/xds/grpc/xds_http_filter_registry.h )
  s.files += %w( src/core/xds/grpc/xds_http_gcp_authn_filter.cc )
  s.files += %w( src/core/xds/grpc/xds_http_gcp_authn_filter.h )
  s.files += %w( src/core/xds/grpc/xds_http_rbac_filter.cc )
  s.files += %w( src/core/xds/grpc/xds_http_rbac_filter.h )
  s.files += %w( src/core/xds/grpc/xds_http_stateful_session_filter.cc )
  s.files += %w( src/core/xds/grpc/xds_http_stateful_session_filter.h )
  s.files += %w( src/core/xds/grpc/xds_lb_policy_registry.cc )
  s.files += %w( src/core/xds/grpc/xds_lb_policy_registry.h )
  s.files += %w( src/core/xds/grpc/xds_listener.cc )
  s.files += %w( src/core/xds/grpc/xds_listener.h )
  s.files += %w( src/core/xds/grpc/xds_listener_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_listener_parser.h )
  s.files += %w( src/core/xds/grpc/xds_matcher.cc )
  s.files += %w( src/core/xds/grpc/xds_matcher.h )
  s.files += %w( src/core/xds/grpc/xds_matcher_action.cc )
  s.files += %w( src/core/xds/grpc/xds_matcher_action.h )
  s.files += %w( src/core/xds/grpc/xds_matcher_context.cc )
  s.files += %w( src/core/xds/grpc/xds_matcher_context.h )
  s.files += %w( src/core/xds/grpc/xds_matcher_input.cc )
  s.files += %w( src/core/xds/grpc/xds_matcher_input.h )
  s.files += %w( src/core/xds/grpc/xds_matcher_parse.cc )
  s.files += %w( src/core/xds/grpc/xds_matcher_parse.h )
  s.files += %w( src/core/xds/grpc/xds_metadata.cc )
  s.files += %w( src/core/xds/grpc/xds_metadata.h )
  s.files += %w( src/core/xds/grpc/xds_metadata_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_metadata_parser.h )
  s.files += %w( src/core/xds/grpc/xds_route_config.cc )
  s.files += %w( src/core/xds/grpc/xds_route_config.h )
  s.files += %w( src/core/xds/grpc/xds_route_config_parser.cc )
  s.files += %w( src/core/xds/grpc/xds_route_config_parser.h )
  s.files += %w( src/core/xds/grpc/xds_routing.cc )
  s.files += %w( src/core/xds/grpc/xds_routing.h )
  s.files += %w( src/core/xds/grpc/xds_server_grpc.cc )
  s.files += %w( src/core/xds/grpc/xds_server_grpc.h )
  s.files += %w( src/core/xds/grpc/xds_server_grpc_interface.h )
  s.files += %w( src/core/xds/grpc/xds_transport_grpc.cc )
  s.files += %w( src/core/xds/grpc/xds_transport_grpc.h )
  s.files += %w( src/core/xds/xds_client/lrs_client.cc )
  s.files += %w( src/core/xds/xds_client/lrs_client.h )
  s.files += %w( src/core/xds/xds_client/xds_api.cc )
  s.files += %w( src/core/xds/xds_client/xds_api.h )
  s.files += %w( src/core/xds/xds_client/xds_backend_metric_propagation.cc )
  s.files += %w( src/core/xds/xds_client/xds_backend_metric_propagation.h )
  s.files += %w( src/core/xds/xds_client/xds_bootstrap.cc )
  s.files += %w( src/core/xds/xds_client/xds_bootstrap.h )
  s.files += %w( src/core/xds/xds_client/xds_channel_args.h )
  s.files += %w( src/core/xds/xds_client/xds_client.cc )
  s.files += %w( src/core/xds/xds_client/xds_client.h )
  s.files += %w( src/core/xds/xds_client/xds_locality.h )
  s.files += %w( src/core/xds/xds_client/xds_metrics.h )
  s.files += %w( src/core/xds/xds_client/xds_resource_type.h )
  s.files += %w( src/core/xds/xds_client/xds_resource_type_impl.h )
  s.files += %w( src/core/xds/xds_client/xds_transport.h )
  s.files += %w( third_party/abseil-cpp/absl/algorithm/algorithm.h )
  s.files += %w( third_party/abseil-cpp/absl/algorithm/container.h )
  s.files += %w( third_party/abseil-cpp/absl/base/attributes.h )
  s.files += %w( third_party/abseil-cpp/absl/base/call_once.h )
  s.files += %w( third_party/abseil-cpp/absl/base/casts.h )
  s.files += %w( third_party/abseil-cpp/absl/base/config.h )
  s.files += %w( third_party/abseil-cpp/absl/base/const_init.h )
  s.files += %w( third_party/abseil-cpp/absl/base/dynamic_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/base/fast_type_id.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/atomic_hook.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/cycleclock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/cycleclock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/cycleclock_config.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/direct_mmap.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/dynamic_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/endian.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/errno_saver.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/hide_ptr.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/identity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/iterator_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_alloc.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_alloc.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/low_level_scheduling.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/nullability_deprecated.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/per_thread_tls.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/raw_logging.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/raw_logging.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/scheduling_mode.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_akaros.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_linux.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_posix.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_wait.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_wait.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/spinlock_win32.inc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/strerror.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/strerror.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/sysinfo.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/sysinfo.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/thread_identity.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/thread_identity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/throw_delegate.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/throw_delegate.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/tracing.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/tracing.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/tsan_mutex_interface.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unaligned_access.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unscaledcycleclock.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unscaledcycleclock.h )
  s.files += %w( third_party/abseil-cpp/absl/base/internal/unscaledcycleclock_config.h )
  s.files += %w( third_party/abseil-cpp/absl/base/log_severity.cc )
  s.files += %w( third_party/abseil-cpp/absl/base/log_severity.h )
  s.files += %w( third_party/abseil-cpp/absl/base/macros.h )
  s.files += %w( third_party/abseil-cpp/absl/base/no_destructor.h )
  s.files += %w( third_party/abseil-cpp/absl/base/nullability.h )
  s.files += %w( third_party/abseil-cpp/absl/base/optimization.h )
  s.files += %w( third_party/abseil-cpp/absl/base/options.h )
  s.files += %w( third_party/abseil-cpp/absl/base/policy_checks.h )
  s.files += %w( third_party/abseil-cpp/absl/base/port.h )
  s.files += %w( third_party/abseil-cpp/absl/base/prefetch.h )
  s.files += %w( third_party/abseil-cpp/absl/base/thread_annotations.h )
  s.files += %w( third_party/abseil-cpp/absl/cleanup/cleanup.h )
  s.files += %w( third_party/abseil-cpp/absl/cleanup/internal/cleanup.h )
  s.files += %w( third_party/abseil-cpp/absl/container/btree_map.h )
  s.files += %w( third_party/abseil-cpp/absl/container/btree_set.h )
  s.files += %w( third_party/abseil-cpp/absl/container/fixed_array.h )
  s.files += %w( third_party/abseil-cpp/absl/container/flat_hash_map.h )
  s.files += %w( third_party/abseil-cpp/absl/container/flat_hash_set.h )
  s.files += %w( third_party/abseil-cpp/absl/container/hash_container_defaults.h )
  s.files += %w( third_party/abseil-cpp/absl/container/inlined_vector.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/btree.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/btree_container.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/common.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/common_policy_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/compressed_tuple.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/container_memory.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hash_function_defaults.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hash_policy_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtable_control_bytes.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtable_debug_hooks.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/hashtablez_sampler_force_weak_definition.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/inlined_vector.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/layout.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/node_slot_policy.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_map.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_set.cc )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_set.h )
  s.files += %w( third_party/abseil-cpp/absl/container/internal/raw_hash_set_resize_impl.h )
  s.files += %w( third_party/abseil-cpp/absl/container/node_hash_map.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/crc32c.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/crc32c.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/cpu_detect.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/cpu_detect.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc32_x86_arm_combined_simd.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc32c.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc32c_inline.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_cord_state.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_cord_state.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_memcpy.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_memcpy_fallback.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_memcpy_x86_arm_combined.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_non_temporal_memcpy.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/crc_x86_arm_combined.cc )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/non_temporal_arm_intrinsics.h )
  s.files += %w( third_party/abseil-cpp/absl/crc/internal/non_temporal_memcpy.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/address_is_readable.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/address_is_readable.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/addresses.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/bounded_utf8_length_sequence.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/decode_rust_punycode.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/decode_rust_punycode.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle_rust.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/demangle_rust.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/elf_mem_image.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/elf_mem_image.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/examine_stack.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/examine_stack.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_aarch64-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_arm-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_config.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_emscripten-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_generic-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_powerpc-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_riscv-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_unimplemented-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_win32-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/stacktrace_x86-inl.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/symbolize.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/utf8_for_code_point.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/utf8_for_code_point.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/vdso_support.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/internal/vdso_support.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/leak_check.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/leak_check.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/stacktrace.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/stacktrace.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize.cc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize.h )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_darwin.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_elf.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_emscripten.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_unimplemented.inc )
  s.files += %w( third_party/abseil-cpp/absl/debugging/symbolize_win32.inc )
  s.files += %w( third_party/abseil-cpp/absl/flags/commandlineflag.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/commandlineflag.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/config.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/declare.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/flag.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/commandlineflag.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/commandlineflag.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/flag.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/flag.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/path_util.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/private_handle_accessor.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/private_handle_accessor.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/program_name.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/program_name.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/registry.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/internal/sequence_lock.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/marshalling.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/marshalling.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/reflection.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/reflection.h )
  s.files += %w( third_party/abseil-cpp/absl/flags/usage_config.cc )
  s.files += %w( third_party/abseil-cpp/absl/flags/usage_config.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/any_invocable.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/bind_front.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/function_ref.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/any_invocable.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/front_binder.h )
  s.files += %w( third_party/abseil-cpp/absl/functional/internal/function_ref.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/hash.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/city.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/city.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/hash.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/hash.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/low_level_hash.cc )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/low_level_hash.h )
  s.files += %w( third_party/abseil-cpp/absl/hash/internal/weakly_mixed_integer.h )
  s.files += %w( third_party/abseil-cpp/absl/log/absl_vlog_is_on.h )
  s.files += %w( third_party/abseil-cpp/absl/log/check.h )
  s.files += %w( third_party/abseil-cpp/absl/log/globals.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/globals.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/append_truncated.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/check_impl.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/check_op.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/check_op.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/conditions.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/conditions.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/config.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/fnmatch.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/fnmatch.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/globals.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/globals.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_format.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_format.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_impl.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_message.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_message.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_sink_set.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/log_sink_set.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/nullguard.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/nullguard.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/nullstream.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/proto.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/proto.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/strip.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/structured_proto.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/structured_proto.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/vlog_config.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/vlog_config.h )
  s.files += %w( third_party/abseil-cpp/absl/log/internal/voidify.h )
  s.files += %w( third_party/abseil-cpp/absl/log/log.h )
  s.files += %w( third_party/abseil-cpp/absl/log/log_entry.h )
  s.files += %w( third_party/abseil-cpp/absl/log/log_sink.cc )
  s.files += %w( third_party/abseil-cpp/absl/log/log_sink.h )
  s.files += %w( third_party/abseil-cpp/absl/log/log_sink_registry.h )
  s.files += %w( third_party/abseil-cpp/absl/log/vlog_is_on.h )
  s.files += %w( third_party/abseil-cpp/absl/memory/memory.h )
  s.files += %w( third_party/abseil-cpp/absl/meta/type_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/bits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128.cc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128_have_intrinsic.inc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/int128_no_intrinsic.inc )
  s.files += %w( third_party/abseil-cpp/absl/numeric/internal/bits.h )
  s.files += %w( third_party/abseil-cpp/absl/numeric/internal/representation.h )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/exponential_biased.cc )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/exponential_biased.h )
  s.files += %w( third_party/abseil-cpp/absl/profiling/internal/sample_recorder.h )
  s.files += %w( third_party/abseil-cpp/absl/random/bernoulli_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/beta_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/bit_gen_ref.h )
  s.files += %w( third_party/abseil-cpp/absl/random/discrete_distribution.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/discrete_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/distributions.h )
  s.files += %w( third_party/abseil-cpp/absl/random/exponential_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/gaussian_distribution.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/gaussian_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/distribution_caller.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/entropy_pool.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/entropy_pool.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/fast_uniform_bits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/fastmath.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/generate_real.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/iostream_state_saver.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/nonsecure_base.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/pcg_engine.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/platform.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_detect.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_detect.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_engine.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_hwaes.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_hwaes.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_round_keys.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_slow.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_slow.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/randen_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/salted_seed_seq.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/seed_material.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/seed_material.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/traits.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/uniform_helper.h )
  s.files += %w( third_party/abseil-cpp/absl/random/internal/wide_multiply.h )
  s.files += %w( third_party/abseil-cpp/absl/random/log_uniform_int_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/poisson_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/random.h )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_gen_exception.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_gen_exception.h )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_sequences.cc )
  s.files += %w( third_party/abseil-cpp/absl/random/seed_sequences.h )
  s.files += %w( third_party/abseil-cpp/absl/random/uniform_int_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/uniform_real_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/random/zipf_distribution.h )
  s.files += %w( third_party/abseil-cpp/absl/status/internal/status_internal.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/internal/status_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/status/internal/statusor_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/status/status.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/status.h )
  s.files += %w( third_party/abseil-cpp/absl/status/status_payload_printer.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/status_payload_printer.h )
  s.files += %w( third_party/abseil-cpp/absl/status/statusor.cc )
  s.files += %w( third_party/abseil-cpp/absl/status/statusor.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/ascii.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/ascii.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/charconv.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/charconv.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/charset.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_analysis.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_analysis.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/cord_buffer.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/escaping.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/escaping.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/has_absl_stringify.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/has_ostream_operator.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_bigint.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_bigint.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_parse.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/charconv_parse.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_data_edge.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_internal.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_navigator.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_navigator.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_reader.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_btree_reader.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_consume.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_consume.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_crc.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_crc.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cord_rep_flat.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_functions.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_functions.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_handle.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_handle.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_info.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_info.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_statistics.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_update_scope.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/cordz_update_tracker.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/damerau_levenshtein_distance.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/damerau_levenshtein_distance.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/escaping.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/escaping.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/memutil.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/memutil.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/ostringstream.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/ostringstream.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/resize_uninitialized.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/stl_type_traits.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/arg.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/arg.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/bind.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/bind.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/checker.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/constexpr_parser.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/extension.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/extension.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/float_conversion.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/float_conversion.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/output.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/output.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/parser.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_format/parser.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_join_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/str_split_internal.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/string_constant.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/stringify_sink.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/stringify_sink.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/utf8.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/internal/utf8.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/match.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/match.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/numbers.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/numbers.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_cat.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_cat.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_format.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_join.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_replace.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_replace.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_split.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/str_split.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/string_view.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/string_view.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/strip.h )
  s.files += %w( third_party/abseil-cpp/absl/strings/substitute.cc )
  s.files += %w( third_party/abseil-cpp/absl/strings/substitute.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/barrier.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/barrier.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/blocking_counter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/blocking_counter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/create_thread_identity.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/create_thread_identity.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/futex.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/futex_waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/futex_waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/graphcycles.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/graphcycles.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/kernel_timeout.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/kernel_timeout.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/per_thread_sem.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/per_thread_sem.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/pthread_waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/pthread_waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/sem_waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/sem_waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/stdcpp_waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/stdcpp_waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/waiter_base.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/waiter_base.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/win32_waiter.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/internal/win32_waiter.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/mutex.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/mutex.h )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/notification.cc )
  s.files += %w( third_party/abseil-cpp/absl/synchronization/notification.h )
  s.files += %w( third_party/abseil-cpp/absl/time/civil_time.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/civil_time.h )
  s.files += %w( third_party/abseil-cpp/absl/time/clock.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/clock.h )
  s.files += %w( third_party/abseil-cpp/absl/time/duration.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/format.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/civil_time_detail.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/time_zone.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/include/cctz/zone_info_source.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/civil_time_detail.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_fixed.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_format.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_if.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_if.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_impl.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_info.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_info.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_libc.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_lookup.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/time_zone_posix.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/tzfile.h )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/cctz/src/zone_info_source.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/get_current_time_chrono.inc )
  s.files += %w( third_party/abseil-cpp/absl/time/internal/get_current_time_posix.inc )
  s.files += %w( third_party/abseil-cpp/absl/time/time.cc )
  s.files += %w( third_party/abseil-cpp/absl/time/time.h )
  s.files += %w( third_party/abseil-cpp/absl/types/compare.h )
  s.files += %w( third_party/abseil-cpp/absl/types/internal/span.h )
  s.files += %w( third_party/abseil-cpp/absl/types/optional.h )
  s.files += %w( third_party/abseil-cpp/absl/types/span.h )
  s.files += %w( third_party/abseil-cpp/absl/types/variant.h )
  s.files += %w( third_party/abseil-cpp/absl/utility/utility.h )
  s.files += %w( third_party/address_sorting/address_sorting.c )
  s.files += %w( third_party/address_sorting/address_sorting_internal.h )
  s.files += %w( third_party/address_sorting/address_sorting_posix.c )
  s.files += %w( third_party/address_sorting/address_sorting_windows.c )
  s.files += %w( third_party/address_sorting/include/address_sorting/address_sorting.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/aes/aes.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_bitstr.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_bool.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_d2i_fp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_dup.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_gentm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_i2d_fp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_int.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_mbstr.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_object.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_octet.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_strex.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_strnid.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_time.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_type.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/a_utctm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn1_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn1_par.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/asn_pack.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/f_int.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/f_string.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/posix_time.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_dec.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_enc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_fre.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_new.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_typ.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/asn1/tasn_utl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/base64/base64.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bcm_support.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/bio.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/bio_mem.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/connect.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/errno.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/fd.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/file.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/hexdump.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/pair.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/printf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/socket.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bio/socket_helper.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/blake2/blake2.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn/bn_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn/convert.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn/div.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn/exponentiation.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bn/sqrt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/buf/buf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/asn1_compat.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/ber.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/cbb.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/cbs.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/bytestring/unicode.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/chacha/chacha.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/chacha/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/derive_key.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_aesctrhmac.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_aeseax.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_aesgcmsiv.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_chacha20poly1305.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_des.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_null.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_rc2.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_rc4.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/e_tls.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/get_cipher.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cipher/tls_cbc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cms/cms.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/conf/conf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/conf/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_apple.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_fuchsia.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_linux.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_openbsd.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_sysreg.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_aarch64_win.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_arm_freebsd.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_arm_linux.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_arm_linux.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/cpu_intel.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/crypto.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519_64_adx.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/curve25519_tables.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/curve25519/spake25519.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/des/des.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/des/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dh/dh_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dh/params.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/digest/digest_extra.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/dsa.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/dsa_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/dsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec/ec_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec/ec_derive.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec/hash_to_curve.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ec/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ecdh/ecdh.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ecdsa/ecdsa_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/engine/engine.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/err/err.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/err/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/evp_ctx.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_dh.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_dh_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_dsa_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ec.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ec_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_ed25519_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_hkdf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_rsa.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_rsa_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_x25519.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/p_x25519_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/pbkdf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/print.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/scrypt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/evp/sign.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/ex_data.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/aes.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/aes_nohw.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/cbc.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/cfb.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/ctr.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/gcm.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/gcm_nohw.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/key_wrap.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/mode_wrappers.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/aes/ofb.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bcm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bcm_interface.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/add.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/asm/x86_64-gcc.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/bn.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/bytes.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/cmp.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/ctx.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/div.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/div_extra.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/exponentiation.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/gcd.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/gcd_extra.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/generic.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/jacobi.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/montgomery.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/montgomery_inv.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/mul.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/prime.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/random.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/rsaz_exp.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/rsaz_exp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/shift.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/bn/sqrt.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/aead.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/cipher.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/e_aes.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/e_aesccm.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cipher/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/cmac/cmac.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/delocate.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/dh/check.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/dh/dh.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/dh/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/digest.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/digests.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digest/md32_common.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/digestsign/digestsign.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/builtin_curves.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec_key.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/ec_montgomery.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/felem.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/oct.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p224-64.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-nistz-table.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-nistz.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256-nistz.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/p256_table.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/scalar.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/simple.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/simple_mul.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/util.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ec/wnaf.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdh/ecdh.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdsa/ecdsa.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/ecdsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/fips_shared_support.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/hkdf/hkdf.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/hmac/hmac.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/keccak/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/keccak/keccak.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/mldsa/fips_known_values.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/mldsa/mldsa.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/mlkem/fips_known_values.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/mlkem/mlkem.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/ctrdrbg.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rand/rand.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/blinding.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/padding.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/rsa.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/rsa/rsa_impl.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/self_check/fips.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/self_check/self_check.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/service_indicator/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/service_indicator/service_indicator.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha1.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha256.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/sha/sha512.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/address.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/fips_known_values.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/fors.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/fors.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/merkle.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/merkle.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/params.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/slhdsa.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/thash.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/thash.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/wots.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/slhdsa/wots.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/tls/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fipsmodule/tls/kdf.cc.inc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/fuzzer_mode.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hpke/hpke.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hrss/hrss.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/hrss/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/kyber/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/kyber/kyber.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/lhash/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/lhash/lhash.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/md4/md4.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/md5/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/md5/md5.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/mem.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/mldsa/mldsa.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/mlkem/mlkem.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj_dat.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/obj/obj_xref.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_all.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_info.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_oth.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_pk8.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_pkey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pem/pem_xaux.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs7/pkcs7_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/p5_pbev2.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pkcs8/pkcs8_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_arm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/poly1305/poly1305_vec.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pool/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/pool/pool.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/deterministic.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/fork_detect.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/forkunsafe.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/getentropy.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/getrandom_fillin.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/ios.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/passive.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/rand.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/trusty.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/urandom.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rand/windows.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rc4/rc4.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/refcount.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa/rsa_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa/rsa_crypt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa/rsa_extra.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/rsa/rsa_print.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/sha/sha1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/sha/sha256.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/sha/sha512.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/siphash/siphash.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/slhdsa/slhdsa.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/spake2plus/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/spake2plus/spake2plus.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/stack/stack.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_none.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_pthread.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/thread_win.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/pmbtoken.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/trust_token.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/trust_token/voprf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_digest.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_sign.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/a_verify.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/algorithm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/asn1_gen.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/by_dir.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/by_file.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/ext_dat.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/i2d_pr.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/name_print.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/policy.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/rsa_pss.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_crl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_req.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/t_x509a.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_akey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_akeya.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_alt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_bcons.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_bitst.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_conf.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_cpols.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_crld.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_enum.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_extku.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_genn.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_ia5.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_info.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_int.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_ncons.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_ocsp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_pcons.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_pmaps.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_prn.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_purp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_skey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/v3_utl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_att.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_cmp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_d2.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_def.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_ext.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_lu.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_obj.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_req.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_set.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_trs.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_txt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_v3.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_vfy.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509_vpm.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509cset.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509name.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509rset.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x509spki.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_algor.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_all.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_attrib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_crl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_exten.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_name.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_pubkey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_req.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_sig.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_spki.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_val.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/crypto/x509/x_x509a.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/gen/crypto/err_data.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/aead.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/aes.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/arm_arch.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asm_base.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1_mac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/asn1t.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/base.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/base64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bcm_public.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bio.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/blake2.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/blowfish.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bn.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/buf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/buffer.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/bytestring.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cast.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/chacha.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cipher.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cmac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cms.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/conf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/cpu.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/crypto.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ctrdrbg.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/curve25519.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/des.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dh.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/digest.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/dtls1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/e_os2.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ec.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ec_key.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ecdh.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ecdsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/engine.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/err.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/evp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/evp_errors.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ex_data.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/experimental/kyber.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hkdf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hmac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hpke.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/hrss.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/is_boringssl.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/kdf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/lhash.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/md4.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/md5.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/mem.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/mldsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/mlkem.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/nid.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/obj.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/obj_mac.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/objects.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/opensslconf.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/opensslv.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ossl_typ.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pem.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs12.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs7.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pkcs8.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/poly1305.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/pool.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/posix_time.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rand.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rc4.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ripemd.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/rsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/safestack.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/service_indicator.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/sha.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/siphash.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/slhdsa.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/span.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/srtp.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ssl.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/ssl3.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/stack.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/target.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/thread.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/time.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/tls1.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/trust_token.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/type_check.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509_vfy.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509v3.h )
  s.files += %w( third_party/boringssl-with-bazel/src/include/openssl/x509v3_errors.h )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/bio_ssl.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_pkt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/d1_srtp.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/dtls_method.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/dtls_record.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/encrypted_client_hello.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/extensions.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handoff.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake_client.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/handshake_server.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/internal.h )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/s3_pkt.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_aead_ctx.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_asn1.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_buffer.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_cert.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_cipher.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_credential.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_file.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_key_share.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_lib.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_privkey.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_session.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_stat.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_transcript.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_versions.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/ssl_x509.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/t1_enc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_both.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_client.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_enc.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls13_server.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls_method.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/ssl/tls_record.cc )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_32.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_64_adx.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/curve25519_64_msvc.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/p256_32.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/p256_64.h )
  s.files += %w( third_party/boringssl-with-bazel/src/third_party/fiat/p256_64_msvc.h )
  s.files += %w( third_party/cares/ares_build.h )
  s.files += %w( third_party/cares/cares/include/ares.h )
  s.files += %w( third_party/cares/cares/include/ares_dns.h )
  s.files += %w( third_party/cares/cares/include/ares_dns_record.h )
  s.files += %w( third_party/cares/cares/include/ares_nameser.h )
  s.files += %w( third_party/cares/cares/include/ares_version.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_addrinfo2hostent.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_addrinfo_localhost.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_android.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_android.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_cancel.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_close_sockets.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_conn.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_conn.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_cookie.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_data.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_data.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_destroy.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_free_hostent.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_free_string.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_freeaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getenv.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getenv.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_gethostbyaddr.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_gethostbyname.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_getnameinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_hosts_file.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_inet_net_pton.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_init.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_ipv6.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_library_init.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_metrics.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_options.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_parse_into_addrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_private.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_process.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_qcache.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_query.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_search.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_send.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_set_socket_functions.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_setup.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_socket.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_socket.h )
  s.files += %w( third_party/cares/cares/src/lib/ares_sortaddrinfo.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_strerror.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_sysconfig.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_sysconfig_files.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_sysconfig_mac.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_sysconfig_win.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_timeout.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_update_servers.c )
  s.files += %w( third_party/cares/cares/src/lib/ares_version.c )
  s.files += %w( third_party/cares/cares/src/lib/config-dos.h )
  s.files += %w( third_party/cares/cares/src/lib/config-win32.h )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_array.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable.h )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_asvp.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_dict.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_strvp.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_szvp.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_vpstr.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_htable_vpvp.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_llist.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_slist.c )
  s.files += %w( third_party/cares/cares/src/lib/dsa/ares_slist.h )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event.h )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_configchg.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_epoll.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_kqueue.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_poll.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_select.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_thread.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_wake_pipe.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_win32.c )
  s.files += %w( third_party/cares/cares/src/lib/event/ares_event_win32.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_array.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_buf.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_asvp.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_dict.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_strvp.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_szvp.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_vpstr.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_htable_vpvp.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_llist.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_mem.h )
  s.files += %w( third_party/cares/cares/src/lib/include/ares_str.h )
  s.files += %w( third_party/cares/cares/src/lib/inet_net_pton.c )
  s.files += %w( third_party/cares/cares/src/lib/inet_ntop.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_create_query.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_expand_name.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_expand_string.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_fds.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_getsock.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_a_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_aaaa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_caa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_mx_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_naptr_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_ns_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_ptr_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_soa_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_srv_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_txt_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/legacy/ares_parse_uri_reply.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_mapping.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_multistring.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_multistring.h )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_name.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_parse.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_private.h )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_record.c )
  s.files += %w( third_party/cares/cares/src/lib/record/ares_dns_write.c )
  s.files += %w( third_party/cares/cares/src/lib/str/ares_buf.c )
  s.files += %w( third_party/cares/cares/src/lib/str/ares_str.c )
  s.files += %w( third_party/cares/cares/src/lib/str/ares_strsplit.c )
  s.files += %w( third_party/cares/cares/src/lib/str/ares_strsplit.h )
  s.files += %w( third_party/cares/cares/src/lib/thirdparty/apple/dnsinfo.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_iface_ips.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_iface_ips.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_math.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_math.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_rand.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_rand.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_threads.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_threads.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_time.h )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_timeval.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_uri.c )
  s.files += %w( third_party/cares/cares/src/lib/util/ares_uri.h )
  s.files += %w( third_party/cares/cares/src/lib/windows_port.c )
  s.files += %w( third_party/cares/config_darwin/ares_config.h )
  s.files += %w( third_party/cares/config_freebsd/ares_config.h )
  s.files += %w( third_party/cares/config_linux/ares_config.h )
  s.files += %w( third_party/cares/config_openbsd/ares_config.h )
  s.files += %w( third_party/re2/re2/bitmap256.h )
  s.files += %w( third_party/re2/re2/bitstate.cc )
  s.files += %w( third_party/re2/re2/compile.cc )
  s.files += %w( third_party/re2/re2/dfa.cc )
  s.files += %w( third_party/re2/re2/filtered_re2.cc )
  s.files += %w( third_party/re2/re2/filtered_re2.h )
  s.files += %w( third_party/re2/re2/mimics_pcre.cc )
  s.files += %w( third_party/re2/re2/nfa.cc )
  s.files += %w( third_party/re2/re2/onepass.cc )
  s.files += %w( third_party/re2/re2/parse.cc )
  s.files += %w( third_party/re2/re2/perl_groups.cc )
  s.files += %w( third_party/re2/re2/pod_array.h )
  s.files += %w( third_party/re2/re2/prefilter.cc )
  s.files += %w( third_party/re2/re2/prefilter.h )
  s.files += %w( third_party/re2/re2/prefilter_tree.cc )
  s.files += %w( third_party/re2/re2/prefilter_tree.h )
  s.files += %w( third_party/re2/re2/prog.cc )
  s.files += %w( third_party/re2/re2/prog.h )
  s.files += %w( third_party/re2/re2/re2.cc )
  s.files += %w( third_party/re2/re2/re2.h )
  s.files += %w( third_party/re2/re2/regexp.cc )
  s.files += %w( third_party/re2/re2/regexp.h )
  s.files += %w( third_party/re2/re2/set.cc )
  s.files += %w( third_party/re2/re2/set.h )
  s.files += %w( third_party/re2/re2/simplify.cc )
  s.files += %w( third_party/re2/re2/sparse_array.h )
  s.files += %w( third_party/re2/re2/sparse_set.h )
  s.files += %w( third_party/re2/re2/stringpiece.cc )
  s.files += %w( third_party/re2/re2/stringpiece.h )
  s.files += %w( third_party/re2/re2/tostring.cc )
  s.files += %w( third_party/re2/re2/unicode_casefold.cc )
  s.files += %w( third_party/re2/re2/unicode_casefold.h )
  s.files += %w( third_party/re2/re2/unicode_groups.cc )
  s.files += %w( third_party/re2/re2/unicode_groups.h )
  s.files += %w( third_party/re2/re2/walker-inl.h )
  s.files += %w( third_party/re2/util/logging.h )
  s.files += %w( third_party/re2/util/mix.h )
  s.files += %w( third_party/re2/util/mutex.h )
  s.files += %w( third_party/re2/util/rune.cc )
  s.files += %w( third_party/re2/util/strutil.cc )
  s.files += %w( third_party/re2/util/strutil.h )
  s.files += %w( third_party/re2/util/utf.h )
  s.files += %w( third_party/re2/util/util.h )
  s.files += %w( third_party/upb/upb/base/descriptor_constants.h )
  s.files += %w( third_party/upb/upb/base/internal/endian.h )
  s.files += %w( third_party/upb/upb/base/internal/log2.h )
  s.files += %w( third_party/upb/upb/base/status.c )
  s.files += %w( third_party/upb/upb/base/status.h )
  s.files += %w( third_party/upb/upb/base/status.hpp )
  s.files += %w( third_party/upb/upb/base/string_view.h )
  s.files += %w( third_party/upb/upb/base/upcast.h )
  s.files += %w( third_party/upb/upb/generated_code_support.h )
  s.files += %w( third_party/upb/upb/hash/common.c )
  s.files += %w( third_party/upb/upb/hash/common.h )
  s.files += %w( third_party/upb/upb/hash/int_table.h )
  s.files += %w( third_party/upb/upb/hash/str_table.h )
  s.files += %w( third_party/upb/upb/json/decode.c )
  s.files += %w( third_party/upb/upb/json/decode.h )
  s.files += %w( third_party/upb/upb/json/encode.c )
  s.files += %w( third_party/upb/upb/json/encode.h )
  s.files += %w( third_party/upb/upb/lex/atoi.c )
  s.files += %w( third_party/upb/upb/lex/atoi.h )
  s.files += %w( third_party/upb/upb/lex/round_trip.c )
  s.files += %w( third_party/upb/upb/lex/round_trip.h )
  s.files += %w( third_party/upb/upb/lex/strtod.c )
  s.files += %w( third_party/upb/upb/lex/strtod.h )
  s.files += %w( third_party/upb/upb/lex/unicode.c )
  s.files += %w( third_party/upb/upb/lex/unicode.h )
  s.files += %w( third_party/upb/upb/mem/alloc.c )
  s.files += %w( third_party/upb/upb/mem/alloc.h )
  s.files += %w( third_party/upb/upb/mem/arena.c )
  s.files += %w( third_party/upb/upb/mem/arena.h )
  s.files += %w( third_party/upb/upb/mem/arena.hpp )
  s.files += %w( third_party/upb/upb/mem/internal/arena.h )
  s.files += %w( third_party/upb/upb/message/accessors.c )
  s.files += %w( third_party/upb/upb/message/accessors.h )
  s.files += %w( third_party/upb/upb/message/array.c )
  s.files += %w( third_party/upb/upb/message/array.h )
  s.files += %w( third_party/upb/upb/message/compat.c )
  s.files += %w( third_party/upb/upb/message/compat.h )
  s.files += %w( third_party/upb/upb/message/copy.c )
  s.files += %w( third_party/upb/upb/message/copy.h )
  s.files += %w( third_party/upb/upb/message/internal/accessors.h )
  s.files += %w( third_party/upb/upb/message/internal/array.h )
  s.files += %w( third_party/upb/upb/message/internal/extension.c )
  s.files += %w( third_party/upb/upb/message/internal/extension.h )
  s.files += %w( third_party/upb/upb/message/internal/iterator.c )
  s.files += %w( third_party/upb/upb/message/internal/iterator.h )
  s.files += %w( third_party/upb/upb/message/internal/map.h )
  s.files += %w( third_party/upb/upb/message/internal/map_entry.h )
  s.files += %w( third_party/upb/upb/message/internal/map_sorter.h )
  s.files += %w( third_party/upb/upb/message/internal/message.c )
  s.files += %w( third_party/upb/upb/message/internal/message.h )
  s.files += %w( third_party/upb/upb/message/internal/tagged_ptr.h )
  s.files += %w( third_party/upb/upb/message/internal/types.h )
  s.files += %w( third_party/upb/upb/message/map.c )
  s.files += %w( third_party/upb/upb/message/map.h )
  s.files += %w( third_party/upb/upb/message/map_gencode_util.h )
  s.files += %w( third_party/upb/upb/message/map_sorter.c )
  s.files += %w( third_party/upb/upb/message/merge.c )
  s.files += %w( third_party/upb/upb/message/merge.h )
  s.files += %w( third_party/upb/upb/message/message.c )
  s.files += %w( third_party/upb/upb/message/message.h )
  s.files += %w( third_party/upb/upb/message/tagged_ptr.h )
  s.files += %w( third_party/upb/upb/message/value.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/build_enum.c )
  s.files += %w( third_party/upb/upb/mini_descriptor/build_enum.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/decode.c )
  s.files += %w( third_party/upb/upb/mini_descriptor/decode.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/base92.c )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/base92.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/decoder.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/encode.c )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/encode.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/encode.hpp )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/modifiers.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/internal/wire_constants.h )
  s.files += %w( third_party/upb/upb/mini_descriptor/link.c )
  s.files += %w( third_party/upb/upb/mini_descriptor/link.h )
  s.files += %w( third_party/upb/upb/mini_table/enum.h )
  s.files += %w( third_party/upb/upb/mini_table/extension.h )
  s.files += %w( third_party/upb/upb/mini_table/extension_registry.c )
  s.files += %w( third_party/upb/upb/mini_table/extension_registry.h )
  s.files += %w( third_party/upb/upb/mini_table/field.h )
  s.files += %w( third_party/upb/upb/mini_table/file.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/enum.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/extension.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/field.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/file.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/message.c )
  s.files += %w( third_party/upb/upb/mini_table/internal/message.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/size_log2.h )
  s.files += %w( third_party/upb/upb/mini_table/internal/sub.h )
  s.files += %w( third_party/upb/upb/mini_table/message.c )
  s.files += %w( third_party/upb/upb/mini_table/message.h )
  s.files += %w( third_party/upb/upb/mini_table/sub.h )
  s.files += %w( third_party/upb/upb/port/atomic.h )
  s.files += %w( third_party/upb/upb/port/def.inc )
  s.files += %w( third_party/upb/upb/port/undef.inc )
  s.files += %w( third_party/upb/upb/port/vsnprintf_compat.h )
  s.files += %w( third_party/upb/upb/reflection/common.h )
  s.files += %w( third_party/upb/upb/reflection/def.h )
  s.files += %w( third_party/upb/upb/reflection/def.hpp )
  s.files += %w( third_party/upb/upb/reflection/def_pool.c )
  s.files += %w( third_party/upb/upb/reflection/def_pool.h )
  s.files += %w( third_party/upb/upb/reflection/def_type.c )
  s.files += %w( third_party/upb/upb/reflection/def_type.h )
  s.files += %w( third_party/upb/upb/reflection/desc_state.c )
  s.files += %w( third_party/upb/upb/reflection/descriptor_bootstrap.h )
  s.files += %w( third_party/upb/upb/reflection/enum_def.c )
  s.files += %w( third_party/upb/upb/reflection/enum_def.h )
  s.files += %w( third_party/upb/upb/reflection/enum_reserved_range.c )
  s.files += %w( third_party/upb/upb/reflection/enum_reserved_range.h )
  s.files += %w( third_party/upb/upb/reflection/enum_value_def.c )
  s.files += %w( third_party/upb/upb/reflection/enum_value_def.h )
  s.files += %w( third_party/upb/upb/reflection/extension_range.c )
  s.files += %w( third_party/upb/upb/reflection/extension_range.h )
  s.files += %w( third_party/upb/upb/reflection/field_def.c )
  s.files += %w( third_party/upb/upb/reflection/field_def.h )
  s.files += %w( third_party/upb/upb/reflection/file_def.c )
  s.files += %w( third_party/upb/upb/reflection/file_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/def_builder.c )
  s.files += %w( third_party/upb/upb/reflection/internal/def_builder.h )
  s.files += %w( third_party/upb/upb/reflection/internal/def_pool.h )
  s.files += %w( third_party/upb/upb/reflection/internal/desc_state.h )
  s.files += %w( third_party/upb/upb/reflection/internal/enum_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/enum_reserved_range.h )
  s.files += %w( third_party/upb/upb/reflection/internal/enum_value_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/extension_range.h )
  s.files += %w( third_party/upb/upb/reflection/internal/field_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/file_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/message_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/message_reserved_range.h )
  s.files += %w( third_party/upb/upb/reflection/internal/method_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/oneof_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/service_def.h )
  s.files += %w( third_party/upb/upb/reflection/internal/strdup2.c )
  s.files += %w( third_party/upb/upb/reflection/internal/strdup2.h )
  s.files += %w( third_party/upb/upb/reflection/internal/upb_edition_defaults.h )
  s.files += %w( third_party/upb/upb/reflection/message.c )
  s.files += %w( third_party/upb/upb/reflection/message.h )
  s.files += %w( third_party/upb/upb/reflection/message.hpp )
  s.files += %w( third_party/upb/upb/reflection/message_def.c )
  s.files += %w( third_party/upb/upb/reflection/message_def.h )
  s.files += %w( third_party/upb/upb/reflection/message_reserved_range.c )
  s.files += %w( third_party/upb/upb/reflection/message_reserved_range.h )
  s.files += %w( third_party/upb/upb/reflection/method_def.c )
  s.files += %w( third_party/upb/upb/reflection/method_def.h )
  s.files += %w( third_party/upb/upb/reflection/oneof_def.c )
  s.files += %w( third_party/upb/upb/reflection/oneof_def.h )
  s.files += %w( third_party/upb/upb/reflection/service_def.c )
  s.files += %w( third_party/upb/upb/reflection/service_def.h )
  s.files += %w( third_party/upb/upb/text/encode.c )
  s.files += %w( third_party/upb/upb/text/encode.h )
  s.files += %w( third_party/upb/upb/text/internal/encode.c )
  s.files += %w( third_party/upb/upb/text/internal/encode.h )
  s.files += %w( third_party/upb/upb/text/options.h )
  s.files += %w( third_party/upb/upb/wire/decode.c )
  s.files += %w( third_party/upb/upb/wire/decode.h )
  s.files += %w( third_party/upb/upb/wire/encode.c )
  s.files += %w( third_party/upb/upb/wire/encode.h )
  s.files += %w( third_party/upb/upb/wire/eps_copy_input_stream.c )
  s.files += %w( third_party/upb/upb/wire/eps_copy_input_stream.h )
  s.files += %w( third_party/upb/upb/wire/internal/constants.h )
  s.files += %w( third_party/upb/upb/wire/internal/decode_fast.c )
  s.files += %w( third_party/upb/upb/wire/internal/decode_fast.h )
  s.files += %w( third_party/upb/upb/wire/internal/decoder.h )
  s.files += %w( third_party/upb/upb/wire/internal/reader.h )
  s.files += %w( third_party/upb/upb/wire/reader.c )
  s.files += %w( third_party/upb/upb/wire/reader.h )
  s.files += %w( third_party/upb/upb/wire/types.h )
  s.files += %w( third_party/utf8_range/utf8_range.c )
  s.files += %w( third_party/utf8_range/utf8_range.h )
  s.files += %w( third_party/utf8_range/utf8_range_neon.inc )
  s.files += %w( third_party/utf8_range/utf8_range_sse.inc )
  s.files += %w( third_party/xxhash/xxhash.h )
  s.files += %w( third_party/zlib/adler32.c )
  s.files += %w( third_party/zlib/compress.c )
  s.files += %w( third_party/zlib/crc32.c )
  s.files += %w( third_party/zlib/crc32.h )
  s.files += %w( third_party/zlib/deflate.c )
  s.files += %w( third_party/zlib/deflate.h )
  s.files += %w( third_party/zlib/gzguts.h )
  s.files += %w( third_party/zlib/infback.c )
  s.files += %w( third_party/zlib/inffast.c )
  s.files += %w( third_party/zlib/inffast.h )
  s.files += %w( third_party/zlib/inffixed.h )
  s.files += %w( third_party/zlib/inflate.c )
  s.files += %w( third_party/zlib/inflate.h )
  s.files += %w( third_party/zlib/inftrees.c )
  s.files += %w( third_party/zlib/inftrees.h )
  s.files += %w( third_party/zlib/trees.c )
  s.files += %w( third_party/zlib/trees.h )
  s.files += %w( third_party/zlib/uncompr.c )
  s.files += %w( third_party/zlib/zconf.h )
  s.files += %w( third_party/zlib/zlib.h )
  s.files += %w( third_party/zlib/zutil.c )
  s.files += %w( third_party/zlib/zutil.h )
end
