#!/bin/sh
# Generated from niminst
# Template is in tools/niminst/buildsh.nimf
# To regenerate run ``niminst csource`` or ``koch csource``

set -e

while :
do
  case "$1" in
    --os)
      optos=$2
      shift 2
      ;;
    --cpu)
      optcpu=$2
      shift 2
      ;;
    --osname)
      optosname=$2
      shift 2
      ;;
    --parallel)
      parallel=$2
      shift 2
      ;;
    --extraBuildArgs)
      extraBuildArgs=" $2"
      shift 2
      ;;
    -h | --help)
      echo "Options:"
      echo "  --os <OS>"
      echo "  --cpu <CPU architecture>"
      echo "  --osname <name>           Additional OS specification (used for Android)"
      echo "  --extraBuildArgs <args>   Additional arguments passed to the compiler"
      echo "  --parallel <number>       Multiprocess build. Requires GNU parallel"
      exit 0
      ;;
    --) # End of all options
      shift
      break;
      ;;
    -*)
      echo 2>&1 "Error: Unknown option: $1" >&2
      exit 1
      ;;
    *)  # No more options
      break
      ;;
  esac
done

parallel="${parallel:-0}"
CC="${CC:-gcc}"
if [ "$parallel" -gt 1 ]; then
  if ! command -v sem > /dev/null; then
    echo "Error: GNU parallel is required to use --parallel"
    exit 1
  fi
  CC="sem -j $parallel --id $$ ${CC}"
fi
COMP_FLAGS="${CPPFLAGS:-} ${CFLAGS:-} -w -fmax-errors=3 -fno-strict-aliasing -O3 -fno-ident -fno-math-errno $extraBuildArgs"
LINK_FLAGS="${LDFLAGS:-} "
PS4=""
# platform detection
ucpu=`uname -m`
uos=`uname`
uosname=
# bin dir detection
binDir=bin

if [ -s ../koch.nim ]; then
  binDir="../bin"
fi

if [ ! -d $binDir ]; then
  mkdir $binDir
fi

# override OS, CPU and OS Name with command-line arguments
if [ -n "$optos" ]; then
  uos="$optos"
fi
if [ -n "$optcpu" ]; then
  ucpu="$optcpu"
fi
if [ -n "$optcpu" ]; then
  uosname="$optosname"
fi

# convert to lower case:
ucpu=`echo $ucpu | tr "[:upper:]" "[:lower:]"`
uos=`echo $uos | tr "[:upper:]" "[:lower:]"`
uosname=`echo $uosname | tr "[:upper:]" "[:lower:]"`

case $uos in
  *linux* )
    myos="linux"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    ;;
  *dragonfly* )
    myos="dragonfly"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *freebsd* )
    myos="freebsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *crossos* )
    myos="crossos"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *openbsd* )
    myos="openbsd"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ;;
  *netbsd* )
    myos="netbsd"
    LINK_FLAGS="$LINK_FLAGS -lm"
    ucpu=`uname -p`
    ;;
  *darwin* )
    myos="macosx"
    CC="clang"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    if [ "$HOSTTYPE" = "x86_64" ] ; then
      ucpu="amd64"
    fi
    ;;
  *aix* )
    myos="aix"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm"
    ;;
  *solaris* | *sun* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    ;;
  *SunOS* )
    myos="solaris"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lsocket -lnsl"
    isOpenIndiana="yes"
    ;;
  *haiku* )
    myos="haiku"
    LINK_FLAGS="$LINK_FLAGS -lroot -lnetwork"
    ;;
  *mingw* | *msys* )
    myos="windows"
    ;;
  *android* )
    myos="android"
    LINK_FLAGS="$LINK_FLAGS -ldl -lm -lrt"
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    ;;
  *)
    echo 2>&1 "Error: unknown operating system: $uos"
    exit 1
    ;;
esac

case $ucpu in
  *i386* | *i486* | *i586* | *i686* | *bepc* | *i86pc* )
    if [ "$isOpenIndiana" = "yes" ] || [ `uname -o` == "illumos" ] ; then
      mycpu="amd64"
    else
      mycpu="i386"
    fi
    ;;
  *amd*64* | *x86-64* | *x86_64* )
    mycpu="amd64" ;;
  *sparc*|*sun* )
    mycpu="sparc"
    if [ "$myos" = "linux" ] ; then
      if [ "$(getconf LONG_BIT)" = "64" ]; then
        mycpu="sparc64"
      elif [ "$(isainfo -b)" = "64" ]; then
        mycpu="sparc64"
      fi
    fi
    ;;
  *s390x* )
    mycpu="s390x" ;;
  *ppc64le* )
    mycpu="powerpc64el" ;;
  *ppc64* )
    if [ "$myos" = "linux" ] ; then
      COMP_FLAGS="$COMP_FLAGS -m64"
      LINK_FLAGS="$LINK_FLAGS -m64"
    fi
    mycpu="powerpc64" ;;
  *power*|*ppc* )
    if [ "$myos" = "freebsd" ] ; then
      if [ "$ucpu" != "powerpc" ] ; then
        COMP_FLAGS="$COMP_FLAGS -m64"
        LINK_FLAGS="$LINK_FLAGS -m64"
      fi
      mycpu=`uname -p`
      case $mycpu in
        powerpc64le)
        mycpu="powerpc64el"
      esac
    else
      mycpu="powerpc"
    fi
    ;;
  *hppa*)
    mycpu="hppa" ;;
  *ia64*)
    mycpu="ia64" ;;
  *m68k*)
    mycpu="m68k" ;;
  *mips* )
    mycpu="$("$CC" -dumpmachine | sed 's/-.*//')"
    case $mycpu in
      mips|mipsel|mips64|mips64el)
        ;;
      *)
        echo 2>&1 "Error: unknown MIPS target: $mycpu"
        exit 1
    esac
    ;;
  *alpha* )
    mycpu="alpha" ;;
  *aarch64*|*arm64* )
    mycpu="arm64" ;;
  *arm*|*armv6l*|*armv7l*|*armv8l* )
    mycpu="arm" ;;
  *riscv64|riscv* )
    mycpu="riscv64" ;;
  *e2k* )
    mycpu="e2k" ;;
  *loongarch64* )
    mycpu="loongarch64" ;;
  *)
    echo 2>&1 "Error: unknown processor: $ucpu"
    exit 1
    ;;
esac

case $uosname in
  *android* )
    LINK_FLAGS="$LINK_FLAGS -landroid-glob"
    myosname="android"
    myos="android"
    ;;
esac

# call the compiler:
echo \# OS:  $myos
echo \# CPU: $mycpu

case $myos in
windows)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@sexceptions.nim.c -o c_code/1_1/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@sdollars.nim.c -o c_code/1_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem.nim.c -o c_code/1_1/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pparseutils.nim.c -o c_code/1_1/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pmath.nim.c -o c_code/1_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@palgorithm.nim.c -o c_code/1_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@punicode.nim.c -o c_code/1_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstrutils.nim.c -o c_code/1_1/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sntpath.nim.c -o c_code/1_1/@pstd@sprivate@sntpath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppathnorm.nim.c -o c_code/1_1/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pdynlib.nim.c -o c_code/1_1/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@swidestrs.nim.c -o c_code/1_1/@pstd@swidestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sexitprocs.nim.c -o c_code/1_1/@pstd@sexitprocs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@ssyncio.nim.c -o c_code/1_1/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pwinlean.nim.c -o c_code/1_1/@pwinlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@soserrors.nim.c -o c_code/1_1/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ptimes.nim.c -o c_code/1_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@soscommon.nim.c -o c_code/1_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sospaths2.nim.c -o c_code/1_1/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sosfiles.nim.c -o c_code/1_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sosdirs.nim.c -o c_code/1_1/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@swin_setenv.nim.c -o c_code/1_1/@pstd@sprivate@swin_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senvvars.nim.c -o c_code/1_1/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/1_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@scmdline.nim.c -o c_code/1_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pos.nim.c -o c_code/1_1/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pparseopt.nim.c -o c_code/1_1/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@phashes.nim.c -o c_code/1_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstrtabs.nim.c -o c_code/1_1/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ptables.nim.c -o c_code/1_1/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pterminal.nim.c -o c_code/1_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpathutils.nim.c -o c_code/1_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mropes.nim.c -o c_code/1_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlineinfos.nim.c -o c_code/1_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplatform.nim.c -o c_code/1_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimpaths.nim.c -o c_code/1_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psets.nim.c -o c_code/1_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sglobs.nim.c -o c_code/1_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptions.nim.c -o c_code/1_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmsgs.nim.c -o c_code/1_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@midents.nim.c -o c_code/1_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mint128.nim.c -o c_code/1_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mast.nim.c -o c_code/1_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mllstream.nim.c -o c_code/1_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimlexbase.nim.c -o c_code/1_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlexer.nim.c -o c_code/1_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderer.nim.c -o c_code/1_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulepaths.nim.c -o c_code/1_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstreams.nim.c -o c_code/1_1/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@swin_getsysteminfo.nim.c -o c_code/1_1/@pstd@sprivate@swin_getsysteminfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pcpuinfo.nim.c -o c_code/1_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@posproc.nim.c -o c_code/1_1/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pparsejson.nim.c -o c_code/1_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pjson.nim.c -o c_code/1_1/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mextccomp.nim.c -o c_code/1_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimblecmd.nim.c -o c_code/1_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcommands.nim.c -o c_code/1_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparser.nim.c -o c_code/1_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilters.nim.c -o c_code/1_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mfilter_tmpl.nim.c -o c_code/1_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msyntaxes.nim.c -o c_code/1_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrodutils.nim.c -o c_code/1_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@spackedsets.nim.c -o c_code/1_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastyaml.nim.c -o c_code/1_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastalgo.nim.c -o c_code/1_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbtrees.nim.c -o c_code/1_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpackages.nim.c -o c_code/1_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msuggestsymdb.nim.c -o c_code/1_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@srodfiles.nim.c -o c_code/1_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sic.nim.c -o c_code/1_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodulegraphs.nim.c -o c_code/1_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmagicsys.nim.c -o c_code/1_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mastmsgs.nim.c -o c_code/1_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypes.nim.c -o c_code/1_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimsets.nim.c -o c_code/1_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgendata.nim.c -o c_code/1_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmangleutils.nim.c -o c_code/1_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mccgutils.nim.c -o c_code/1_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msaturate.nim.c -o c_code/1_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mguards.nim.c -o c_code/1_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemfold.nim.c -o c_code/1_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdef.nim.c -o c_code/1_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlayeredtable.nim.c -o c_code/1_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlowerings.nim.c -o c_code/1_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mparampatterns.nim.c -o c_code/1_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemdata.nim.c -o c_code/1_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypeallowed.nim.c -o c_code/1_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@misolation_check.nim.c -o c_code/1_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvarpartitions.nim.c -o c_code/1_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnilcheck.nim.c -o c_code/1_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@seditdistance.nim.c -o c_code/1_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pheapqueue.nim.c -o c_code/1_1/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlookups.nim.c -o c_code/1_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlinter.nim.c -o c_code/1_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemtypinst.nim.c -o c_code/1_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mconcepts.nim.c -o c_code/1_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msigmatch.nim.c -o c_code/1_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpragmas.nim.c -o c_code/1_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msighashes.nim.c -o c_code/1_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftdestructors.nim.c -o c_code/1_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msempass2.nim.c -o c_code/1_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgmeth.nim.c -o c_code/1_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliases.nim.c -o c_code/1_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mliftlocals.nim.c -o c_code/1_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mlambdalifting.nim.c -o c_code/1_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mclosureiters.nim.c -o c_code/1_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtransf.nim.c -o c_code/1_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@moptimizer.nim.c -o c_code/1_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdfa.nim.c -o c_code/1_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@minjectdestructors.nim.c -o c_code/1_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpipelineutils.nim.c -o c_code/1_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mspawn.nim.c -o c_code/1_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemparallel.nim.c -o c_code/1_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcgen.nim.c -o c_code/1_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmodules.nim.c -o c_code/1_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemmacrosanity.nim.c -o c_code/1_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmgen.nim.c -o c_code/1_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmdeps.nim.c -o c_code/1_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mgorgeimpl.nim.c -o c_code/1_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmprofiler.nim.c -o c_code/1_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mevaltempl.nim.c -o c_code/1_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmmarshal.nim.c -o c_code/1_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvm.nim.c -o c_code/1_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mimporter.nim.c -o c_code/1_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprocfind.nim.c -o c_code/1_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpatterns.nim.c -o c_code/1_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sitersgen.nim.c -o c_code/1_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvtables.nim.c -o c_code/1_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msem.nim.c -o c_code/1_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mreorder.nim.c -o c_code/1_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdepends.nim.c -o c_code/1_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msourcemap.nim.c -o c_code/1_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mjsgen.nim.c -o c_code/1_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plists.nim.c -o c_code/1_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@srstast.nim.c -o c_code/1_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/1_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/1_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@srst.nim.c -o c_code/1_1/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@srstgen.nim.c -o c_code/1_1/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtypesrenderer.nim.c -o c_code/1_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mrenderverbatim.nim.c -o c_code/1_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@puri.nim.c -o c_code/1_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen.nim.c -o c_code/1_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mdocgen2.nim.c -o c_code/1_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sreplayer.nim.c -o c_code/1_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpipelines.nim.c -o c_code/1_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mscriptconfig.nim.c -o c_code/1_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnimconf.nim.c -o c_code/1_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sdce.nim.c -o c_code/1_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@scbackend.nim.c -o c_code/1_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sintegrity.nim.c -o c_code/1_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@snavigator.nim.c -o c_code/1_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmain.nim.c -o c_code/1_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcmdlinehelper.nim.c -o c_code/1_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pbrowsers.nim.c -o c_code/1_1/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnim.nim.c -o c_code/1_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_1/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/1_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/1_1/@psystem.nim.o \
c_code/1_1/@pparseutils.nim.o \
c_code/1_1/@pmath.nim.o \
c_code/1_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/1_1/@punicode.nim.o \
c_code/1_1/@pstrutils.nim.o \
c_code/1_1/@pstd@sprivate@sntpath.nim.o \
c_code/1_1/@ppathnorm.nim.o \
c_code/1_1/@pdynlib.nim.o \
c_code/1_1/@pstd@swidestrs.nim.o \
c_code/1_1/@pstd@sexitprocs.nim.o \
c_code/1_1/@pstd@ssyncio.nim.o \
c_code/1_1/@pwinlean.nim.o \
c_code/1_1/@pstd@soserrors.nim.o \
c_code/1_1/@ptimes.nim.o \
c_code/1_1/@pstd@sprivate@soscommon.nim.o \
c_code/1_1/@pstd@sprivate@sospaths2.nim.o \
c_code/1_1/@pstd@sprivate@sosfiles.nim.o \
c_code/1_1/@pstd@sprivate@sosdirs.nim.o \
c_code/1_1/@pstd@sprivate@swin_setenv.nim.o \
c_code/1_1/@pstd@senvvars.nim.o \
c_code/1_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/1_1/@pstd@scmdline.nim.o \
c_code/1_1/@pos.nim.o \
c_code/1_1/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/1_1/@phashes.nim.o \
c_code/1_1/@pstrtabs.nim.o \
c_code/1_1/@ptables.nim.o \
c_code/1_1/@pterminal.nim.o \
c_code/1_1/@mpathutils.nim.o \
c_code/1_1/@mropes.nim.o \
c_code/1_1/@mlineinfos.nim.o \
c_code/1_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/1_1/@mnimpaths.nim.o \
c_code/1_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/1_1/@pstd@sprivate@sglobs.nim.o \
c_code/1_1/@moptions.nim.o \
c_code/1_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/1_1/@midents.nim.o \
c_code/1_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/1_1/@mast.nim.o \
c_code/1_1/@mllstream.nim.o \
c_code/1_1/@mnimlexbase.nim.o \
c_code/1_1/@mlexer.nim.o \
c_code/1_1/@mrenderer.nim.o \
c_code/1_1/@mmodulepaths.nim.o \
c_code/1_1/@pstreams.nim.o \
c_code/1_1/@pstd@sprivate@swin_getsysteminfo.nim.o \
c_code/1_1/@pcpuinfo.nim.o \
c_code/1_1/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/1_1/@pparsejson.nim.o \
c_code/1_1/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/1_1/@mextccomp.nim.o \
c_code/1_1/@mnimblecmd.nim.o \
c_code/1_1/@mcommands.nim.o \
c_code/1_1/@mparser.nim.o \
c_code/1_1/@mfilters.nim.o \
c_code/1_1/@mfilter_tmpl.nim.o \
c_code/1_1/@msyntaxes.nim.o \
c_code/1_1/@mrodutils.nim.o \
c_code/1_1/@pstd@spackedsets.nim.o \
c_code/1_1/@mastyaml.nim.o \
c_code/1_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/1_1/@mbtrees.nim.o \
c_code/1_1/@mpackages.nim.o \
c_code/1_1/@msuggestsymdb.nim.o \
c_code/1_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/1_1/@mic@sic.nim.o \
c_code/1_1/@mmodulegraphs.nim.o \
c_code/1_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/1_1/@mastmsgs.nim.o \
c_code/1_1/@mtypes.nim.o \
c_code/1_1/@mnimsets.nim.o \
c_code/1_1/@mcgendata.nim.o \
c_code/1_1/@mmangleutils.nim.o \
c_code/1_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/1_1/@msaturate.nim.o \
c_code/1_1/@mguards.nim.o \
c_code/1_1/@msemfold.nim.o \
c_code/1_1/@mvmdef.nim.o \
c_code/1_1/@mlayeredtable.nim.o \
c_code/1_1/@mlowerings.nim.o \
c_code/1_1/@mparampatterns.nim.o \
c_code/1_1/@msemdata.nim.o \
c_code/1_1/@mtypeallowed.nim.o \
c_code/1_1/@misolation_check.nim.o \
c_code/1_1/@mvarpartitions.nim.o \
c_code/1_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/1_1/@pstd@seditdistance.nim.o \
c_code/1_1/@pheapqueue.nim.o \
c_code/1_1/@mlookups.nim.o \
c_code/1_1/@mlinter.nim.o \
c_code/1_1/@msemtypinst.nim.o \
c_code/1_1/@mconcepts.nim.o \
c_code/1_1/@msigmatch.nim.o \
c_code/1_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/1_1/@msighashes.nim.o \
c_code/1_1/@mliftdestructors.nim.o \
c_code/1_1/@msempass2.nim.o \
c_code/1_1/@mcgmeth.nim.o \
c_code/1_1/@maliases.nim.o \
c_code/1_1/@mliftlocals.nim.o \
c_code/1_1/@mlambdalifting.nim.o \
c_code/1_1/@mclosureiters.nim.o \
c_code/1_1/@mtransf.nim.o \
c_code/1_1/@moptimizer.nim.o \
c_code/1_1/@mdfa.nim.o \
c_code/1_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/1_1/@mpipelineutils.nim.o \
c_code/1_1/@mspawn.nim.o \
c_code/1_1/@msemparallel.nim.o \
c_code/1_1/@mcgen.nim.o \
c_code/1_1/@mmodules.nim.o \
c_code/1_1/@msemmacrosanity.nim.o \
c_code/1_1/@mvmgen.nim.o \
c_code/1_1/@mvmdeps.nim.o \
c_code/1_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/1_1/@mvmprofiler.nim.o \
c_code/1_1/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/1_1/@mvmmarshal.nim.o \
c_code/1_1/@mvm.nim.o \
c_code/1_1/@mimporter.nim.o \
c_code/1_1/@mprocfind.nim.o \
c_code/1_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/1_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/1_1/@mvtables.nim.o \
c_code/1_1/@msem.nim.o \
c_code/1_1/@mreorder.nim.o \
c_code/1_1/@mdepends.nim.o \
c_code/1_1/@msourcemap.nim.o \
c_code/1_1/@mjsgen.nim.o \
c_code/1_1/@plists.nim.o \
c_code/1_1/@ppackages@sdocutils@srstast.nim.o \
c_code/1_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/1_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/1_1/@ppackages@sdocutils@srst.nim.o \
c_code/1_1/@ppackages@sdocutils@srstgen.nim.o \
c_code/1_1/@mtypesrenderer.nim.o \
c_code/1_1/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/1_1/@puri.nim.o \
c_code/1_1/@mdocgen.nim.o \
c_code/1_1/@mdocgen2.nim.o \
c_code/1_1/@mic@sreplayer.nim.o \
c_code/1_1/@mpipelines.nim.o \
c_code/1_1/@mscriptconfig.nim.o \
c_code/1_1/@mnimconf.nim.o \
c_code/1_1/@mic@sdce.nim.o \
c_code/1_1/@mic@scbackend.nim.o \
c_code/1_1/@mic@sintegrity.nim.o \
c_code/1_1/@mic@snavigator.nim.o \
c_code/1_1/@mmain.nim.o \
c_code/1_1/@mcmdlinehelper.nim.o \
c_code/1_1/@pbrowsers.nim.o \
c_code/1_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@sexceptions.nim.c -o c_code/1_2/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@sdollars.nim.c -o c_code/1_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem.nim.c -o c_code/1_2/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pparseutils.nim.c -o c_code/1_2/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pmath.nim.c -o c_code/1_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@palgorithm.nim.c -o c_code/1_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@punicode.nim.c -o c_code/1_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstrutils.nim.c -o c_code/1_2/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sntpath.nim.c -o c_code/1_2/@pstd@sprivate@sntpath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppathnorm.nim.c -o c_code/1_2/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pdynlib.nim.c -o c_code/1_2/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@swidestrs.nim.c -o c_code/1_2/@pstd@swidestrs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sexitprocs.nim.c -o c_code/1_2/@pstd@sexitprocs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@ssyncio.nim.c -o c_code/1_2/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pwinlean.nim.c -o c_code/1_2/@pwinlean.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@soserrors.nim.c -o c_code/1_2/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ptimes.nim.c -o c_code/1_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@soscommon.nim.c -o c_code/1_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sospaths2.nim.c -o c_code/1_2/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sosfiles.nim.c -o c_code/1_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sosdirs.nim.c -o c_code/1_2/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@swin_setenv.nim.c -o c_code/1_2/@pstd@sprivate@swin_setenv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senvvars.nim.c -o c_code/1_2/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/1_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@scmdline.nim.c -o c_code/1_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pos.nim.c -o c_code/1_2/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pparseopt.nim.c -o c_code/1_2/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@phashes.nim.c -o c_code/1_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstrtabs.nim.c -o c_code/1_2/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ptables.nim.c -o c_code/1_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pterminal.nim.c -o c_code/1_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpathutils.nim.c -o c_code/1_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mropes.nim.c -o c_code/1_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlineinfos.nim.c -o c_code/1_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplatform.nim.c -o c_code/1_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimpaths.nim.c -o c_code/1_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psets.nim.c -o c_code/1_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sglobs.nim.c -o c_code/1_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptions.nim.c -o c_code/1_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmsgs.nim.c -o c_code/1_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@midents.nim.c -o c_code/1_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mint128.nim.c -o c_code/1_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mast.nim.c -o c_code/1_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mllstream.nim.c -o c_code/1_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimlexbase.nim.c -o c_code/1_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlexer.nim.c -o c_code/1_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderer.nim.c -o c_code/1_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulepaths.nim.c -o c_code/1_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstreams.nim.c -o c_code/1_2/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@swin_getsysteminfo.nim.c -o c_code/1_2/@pstd@sprivate@swin_getsysteminfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pcpuinfo.nim.c -o c_code/1_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@posproc.nim.c -o c_code/1_2/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pparsejson.nim.c -o c_code/1_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pjson.nim.c -o c_code/1_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mextccomp.nim.c -o c_code/1_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimblecmd.nim.c -o c_code/1_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcommands.nim.c -o c_code/1_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparser.nim.c -o c_code/1_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilters.nim.c -o c_code/1_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mfilter_tmpl.nim.c -o c_code/1_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msyntaxes.nim.c -o c_code/1_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrodutils.nim.c -o c_code/1_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@spackedsets.nim.c -o c_code/1_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastyaml.nim.c -o c_code/1_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastalgo.nim.c -o c_code/1_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbtrees.nim.c -o c_code/1_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpackages.nim.c -o c_code/1_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msuggestsymdb.nim.c -o c_code/1_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@srodfiles.nim.c -o c_code/1_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sic.nim.c -o c_code/1_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodulegraphs.nim.c -o c_code/1_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmagicsys.nim.c -o c_code/1_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mastmsgs.nim.c -o c_code/1_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypes.nim.c -o c_code/1_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimsets.nim.c -o c_code/1_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgendata.nim.c -o c_code/1_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmangleutils.nim.c -o c_code/1_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mccgutils.nim.c -o c_code/1_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msaturate.nim.c -o c_code/1_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mguards.nim.c -o c_code/1_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemfold.nim.c -o c_code/1_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdef.nim.c -o c_code/1_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlayeredtable.nim.c -o c_code/1_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlowerings.nim.c -o c_code/1_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mparampatterns.nim.c -o c_code/1_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemdata.nim.c -o c_code/1_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypeallowed.nim.c -o c_code/1_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@misolation_check.nim.c -o c_code/1_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvarpartitions.nim.c -o c_code/1_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnilcheck.nim.c -o c_code/1_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@seditdistance.nim.c -o c_code/1_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pheapqueue.nim.c -o c_code/1_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlookups.nim.c -o c_code/1_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlinter.nim.c -o c_code/1_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemtypinst.nim.c -o c_code/1_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mconcepts.nim.c -o c_code/1_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msigmatch.nim.c -o c_code/1_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpragmas.nim.c -o c_code/1_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msighashes.nim.c -o c_code/1_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftdestructors.nim.c -o c_code/1_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msempass2.nim.c -o c_code/1_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgmeth.nim.c -o c_code/1_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliases.nim.c -o c_code/1_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mliftlocals.nim.c -o c_code/1_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mlambdalifting.nim.c -o c_code/1_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mclosureiters.nim.c -o c_code/1_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtransf.nim.c -o c_code/1_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@moptimizer.nim.c -o c_code/1_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdfa.nim.c -o c_code/1_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@minjectdestructors.nim.c -o c_code/1_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpipelineutils.nim.c -o c_code/1_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mspawn.nim.c -o c_code/1_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemparallel.nim.c -o c_code/1_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcgen.nim.c -o c_code/1_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmodules.nim.c -o c_code/1_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemmacrosanity.nim.c -o c_code/1_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmgen.nim.c -o c_code/1_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmdeps.nim.c -o c_code/1_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mgorgeimpl.nim.c -o c_code/1_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmprofiler.nim.c -o c_code/1_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mevaltempl.nim.c -o c_code/1_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmmarshal.nim.c -o c_code/1_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvm.nim.c -o c_code/1_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mimporter.nim.c -o c_code/1_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprocfind.nim.c -o c_code/1_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpatterns.nim.c -o c_code/1_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sitersgen.nim.c -o c_code/1_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvtables.nim.c -o c_code/1_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msem.nim.c -o c_code/1_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mreorder.nim.c -o c_code/1_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdepends.nim.c -o c_code/1_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msourcemap.nim.c -o c_code/1_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mjsgen.nim.c -o c_code/1_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plists.nim.c -o c_code/1_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@srstast.nim.c -o c_code/1_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/1_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/1_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@srst.nim.c -o c_code/1_2/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@srstgen.nim.c -o c_code/1_2/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtypesrenderer.nim.c -o c_code/1_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mrenderverbatim.nim.c -o c_code/1_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@puri.nim.c -o c_code/1_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen.nim.c -o c_code/1_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mdocgen2.nim.c -o c_code/1_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sreplayer.nim.c -o c_code/1_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpipelines.nim.c -o c_code/1_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mscriptconfig.nim.c -o c_code/1_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnimconf.nim.c -o c_code/1_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sdce.nim.c -o c_code/1_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@scbackend.nim.c -o c_code/1_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sintegrity.nim.c -o c_code/1_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@snavigator.nim.c -o c_code/1_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmain.nim.c -o c_code/1_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcmdlinehelper.nim.c -o c_code/1_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pbrowsers.nim.c -o c_code/1_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnim.nim.c -o c_code/1_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/1_2/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/1_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/1_2/@psystem.nim.o \
c_code/1_2/@pparseutils.nim.o \
c_code/1_2/@pmath.nim.o \
c_code/1_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/1_2/@punicode.nim.o \
c_code/1_2/@pstrutils.nim.o \
c_code/1_2/@pstd@sprivate@sntpath.nim.o \
c_code/1_2/@ppathnorm.nim.o \
c_code/1_2/@pdynlib.nim.o \
c_code/1_2/@pstd@swidestrs.nim.o \
c_code/1_2/@pstd@sexitprocs.nim.o \
c_code/1_2/@pstd@ssyncio.nim.o \
c_code/1_2/@pwinlean.nim.o \
c_code/1_2/@pstd@soserrors.nim.o \
c_code/1_2/@ptimes.nim.o \
c_code/1_2/@pstd@sprivate@soscommon.nim.o \
c_code/1_2/@pstd@sprivate@sospaths2.nim.o \
c_code/1_2/@pstd@sprivate@sosfiles.nim.o \
c_code/1_2/@pstd@sprivate@sosdirs.nim.o \
c_code/1_2/@pstd@sprivate@swin_setenv.nim.o \
c_code/1_2/@pstd@senvvars.nim.o \
c_code/1_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/1_2/@pstd@scmdline.nim.o \
c_code/1_2/@pos.nim.o \
c_code/1_2/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/1_2/@phashes.nim.o \
c_code/1_2/@pstrtabs.nim.o \
c_code/1_2/@ptables.nim.o \
c_code/1_2/@pterminal.nim.o \
c_code/1_2/@mpathutils.nim.o \
c_code/1_2/@mropes.nim.o \
c_code/1_2/@mlineinfos.nim.o \
c_code/1_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/1_2/@mnimpaths.nim.o \
c_code/1_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/1_2/@pstd@sprivate@sglobs.nim.o \
c_code/1_2/@moptions.nim.o \
c_code/1_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/1_2/@midents.nim.o \
c_code/1_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/1_2/@mast.nim.o \
c_code/1_2/@mllstream.nim.o \
c_code/1_2/@mnimlexbase.nim.o \
c_code/1_2/@mlexer.nim.o \
c_code/1_2/@mrenderer.nim.o \
c_code/1_2/@mmodulepaths.nim.o \
c_code/1_2/@pstreams.nim.o \
c_code/1_2/@pstd@sprivate@swin_getsysteminfo.nim.o \
c_code/1_2/@pcpuinfo.nim.o \
c_code/1_2/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/1_2/@pparsejson.nim.o \
c_code/1_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/1_2/@mextccomp.nim.o \
c_code/1_2/@mnimblecmd.nim.o \
c_code/1_2/@mcommands.nim.o \
c_code/1_2/@mparser.nim.o \
c_code/1_2/@mfilters.nim.o \
c_code/1_2/@mfilter_tmpl.nim.o \
c_code/1_2/@msyntaxes.nim.o \
c_code/1_2/@mrodutils.nim.o \
c_code/1_2/@pstd@spackedsets.nim.o \
c_code/1_2/@mastyaml.nim.o \
c_code/1_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/1_2/@mbtrees.nim.o \
c_code/1_2/@mpackages.nim.o \
c_code/1_2/@msuggestsymdb.nim.o \
c_code/1_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/1_2/@mic@sic.nim.o \
c_code/1_2/@mmodulegraphs.nim.o \
c_code/1_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/1_2/@mastmsgs.nim.o \
c_code/1_2/@mtypes.nim.o \
c_code/1_2/@mnimsets.nim.o \
c_code/1_2/@mcgendata.nim.o \
c_code/1_2/@mmangleutils.nim.o \
c_code/1_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/1_2/@msaturate.nim.o \
c_code/1_2/@mguards.nim.o \
c_code/1_2/@msemfold.nim.o \
c_code/1_2/@mvmdef.nim.o \
c_code/1_2/@mlayeredtable.nim.o \
c_code/1_2/@mlowerings.nim.o \
c_code/1_2/@mparampatterns.nim.o \
c_code/1_2/@msemdata.nim.o \
c_code/1_2/@mtypeallowed.nim.o \
c_code/1_2/@misolation_check.nim.o \
c_code/1_2/@mvarpartitions.nim.o \
c_code/1_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/1_2/@pstd@seditdistance.nim.o \
c_code/1_2/@pheapqueue.nim.o \
c_code/1_2/@mlookups.nim.o \
c_code/1_2/@mlinter.nim.o \
c_code/1_2/@msemtypinst.nim.o \
c_code/1_2/@mconcepts.nim.o \
c_code/1_2/@msigmatch.nim.o \
c_code/1_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/1_2/@msighashes.nim.o \
c_code/1_2/@mliftdestructors.nim.o \
c_code/1_2/@msempass2.nim.o \
c_code/1_2/@mcgmeth.nim.o \
c_code/1_2/@maliases.nim.o \
c_code/1_2/@mliftlocals.nim.o \
c_code/1_2/@mlambdalifting.nim.o \
c_code/1_2/@mclosureiters.nim.o \
c_code/1_2/@mtransf.nim.o \
c_code/1_2/@moptimizer.nim.o \
c_code/1_2/@mdfa.nim.o \
c_code/1_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/1_2/@mpipelineutils.nim.o \
c_code/1_2/@mspawn.nim.o \
c_code/1_2/@msemparallel.nim.o \
c_code/1_2/@mcgen.nim.o \
c_code/1_2/@mmodules.nim.o \
c_code/1_2/@msemmacrosanity.nim.o \
c_code/1_2/@mvmgen.nim.o \
c_code/1_2/@mvmdeps.nim.o \
c_code/1_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/1_2/@mvmprofiler.nim.o \
c_code/1_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/1_2/@mvmmarshal.nim.o \
c_code/1_2/@mvm.nim.o \
c_code/1_2/@mimporter.nim.o \
c_code/1_2/@mprocfind.nim.o \
c_code/1_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/1_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/1_2/@mvtables.nim.o \
c_code/1_2/@msem.nim.o \
c_code/1_2/@mreorder.nim.o \
c_code/1_2/@mdepends.nim.o \
c_code/1_2/@msourcemap.nim.o \
c_code/1_2/@mjsgen.nim.o \
c_code/1_2/@plists.nim.o \
c_code/1_2/@ppackages@sdocutils@srstast.nim.o \
c_code/1_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/1_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/1_2/@ppackages@sdocutils@srst.nim.o \
c_code/1_2/@ppackages@sdocutils@srstgen.nim.o \
c_code/1_2/@mtypesrenderer.nim.o \
c_code/1_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/1_2/@puri.nim.o \
c_code/1_2/@mdocgen.nim.o \
c_code/1_2/@mdocgen2.nim.o \
c_code/1_2/@mic@sreplayer.nim.o \
c_code/1_2/@mpipelines.nim.o \
c_code/1_2/@mscriptconfig.nim.o \
c_code/1_2/@mnimconf.nim.o \
c_code/1_2/@mic@sdce.nim.o \
c_code/1_2/@mic@scbackend.nim.o \
c_code/1_2/@mic@sintegrity.nim.o \
c_code/1_2/@mic@snavigator.nim.o \
c_code/1_2/@mmain.nim.o \
c_code/1_2/@mcmdlinehelper.nim.o \
c_code/1_2/@pbrowsers.nim.o \
c_code/1_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  s390x)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
linux)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sexceptions.nim.c -o c_code/2_1/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem.nim.c -o c_code/2_1/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparseutils.nim.c -o c_code/2_1/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrutils.nim.c -o c_code/2_1/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppathnorm.nim.c -o c_code/2_1/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@soserrors.nim.c -o c_code/2_1/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@ssyncio.nim.c -o c_code/2_1/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sospaths2.nim.c -o c_code/2_1/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@senvvars.nim.c -o c_code/2_1/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pos.nim.c -o c_code/2_1/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparseopt.nim.c -o c_code/2_1/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@phashes.nim.c -o c_code/2_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrtabs.nim.c -o c_code/2_1/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptables.nim.c -o c_code/2_1/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplatform.nim.c -o c_code/2_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptions.nim.c -o c_code/2_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmsgs.nim.c -o c_code/2_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mllstream.nim.c -o c_code/2_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlexer.nim.c -o c_code/2_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderer.nim.c -o c_code/2_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstreams.nim.c -o c_code/2_1/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@posproc.nim.c -o c_code/2_1/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pjson.nim.c -o c_code/2_1/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mextccomp.nim.c -o c_code/2_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimblecmd.nim.c -o c_code/2_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcommands.nim.c -o c_code/2_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msyntaxes.nim.c -o c_code/2_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mbtrees.nim.c -o c_code/2_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@srodfiles.nim.c -o c_code/2_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdef.nim.c -o c_code/2_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pheapqueue.nim.c -o c_code/2_1/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msigmatch.nim.c -o c_code/2_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpragmas.nim.c -o c_code/2_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdynlib.nim.c -o c_code/2_1/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgen.nim.c -o c_code/2_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mgorgeimpl.nim.c -o c_code/2_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvm.nim.c -o c_code/2_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msem.nim.c -o c_code/2_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdepends.nim.c -o c_code/2_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mjsgen.nim.c -o c_code/2_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srst.nim.c -o c_code/2_1/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_1/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen.nim.c -o c_code/2_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen2.nim.c -o c_code/2_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mscriptconfig.nim.c -o c_code/2_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimconf.nim.c -o c_code/2_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmain.nim.c -o c_code/2_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pbrowsers.nim.c -o c_code/2_1/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnim.nim.c -o c_code/2_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_1/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_1/@psystem.nim.o \
c_code/2_1/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_1/@pstrutils.nim.o \
c_code/2_1/@ppathnorm.nim.o \
c_code/2_1/@pstd@soserrors.nim.o \
c_code/2_1/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_1/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_1/@pstd@sprivate@sosdirs.nim.o \
c_code/2_1/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_1/@pos.nim.o \
c_code/2_1/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_1/@phashes.nim.o \
c_code/2_1/@pstrtabs.nim.o \
c_code/2_1/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_1/@moptions.nim.o \
c_code/2_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_1/@mast.nim.o \
c_code/2_1/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_1/@mlexer.nim.o \
c_code/2_1/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_1/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_1/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_1/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_1/@mextccomp.nim.o \
c_code/2_1/@mnimblecmd.nim.o \
c_code/2_1/@mcommands.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/2_1/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_1/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_1/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_1/@pheapqueue.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/2_1/@msigmatch.nim.o \
c_code/2_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/@pdynlib.nim.o \
c_code/2_1/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_1/@mvm.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_1/@msem.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/2_1/@mdepends.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/2_1/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_1/@ppackages@sdocutils@srst.nim.o \
c_code/2_1/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_1/@mdocgen.nim.o \
c_code/2_1/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_1/@mscriptconfig.nim.o \
c_code/2_1/@mnimconf.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/2_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_1/@pbrowsers.nim.o \
c_code/2_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sexceptions.nim.c -o c_code/2_2/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem.nim.c -o c_code/2_2/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparseutils.nim.c -o c_code/2_2/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@palgorithm.nim.c -o c_code/2_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrutils.nim.c -o c_code/2_2/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppathnorm.nim.c -o c_code/2_2/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@soserrors.nim.c -o c_code/2_2/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@ssyncio.nim.c -o c_code/2_2/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pposix.nim.c -o c_code/2_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@soscommon.nim.c -o c_code/2_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sospaths2.nim.c -o c_code/2_2/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ptimes.nim.c -o c_code/2_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosfiles.nim.c -o c_code/2_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@senvvars.nim.c -o c_code/2_2/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pos.nim.c -o c_code/2_2/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparseopt.nim.c -o c_code/2_2/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrtabs.nim.c -o c_code/2_2/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ptables.nim.c -o c_code/2_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mropes.nim.c -o c_code/2_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplatform.nim.c -o c_code/2_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptions.nim.c -o c_code/2_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmsgs.nim.c -o c_code/2_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mllstream.nim.c -o c_code/2_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlexer.nim.c -o c_code/2_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderer.nim.c -o c_code/2_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstreams.nim.c -o c_code/2_2/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pcpuinfo.nim.c -o c_code/2_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@smonotimes.nim.c -o c_code/2_2/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@posproc.nim.c -o c_code/2_2/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mextccomp.nim.c -o c_code/2_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimblecmd.nim.c -o c_code/2_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcommands.nim.c -o c_code/2_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msyntaxes.nim.c -o c_code/2_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@srodfiles.nim.c -o c_code/2_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sic.nim.c -o c_code/2_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdef.nim.c -o c_code/2_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msigmatch.nim.c -o c_code/2_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpragmas.nim.c -o c_code/2_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdynlib.nim.c -o c_code/2_2/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgen.nim.c -o c_code/2_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmdeps.nim.c -o c_code/2_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mgorgeimpl.nim.c -o c_code/2_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvm.nim.c -o c_code/2_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msem.nim.c -o c_code/2_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdepends.nim.c -o c_code/2_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mjsgen.nim.c -o c_code/2_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srst.nim.c -o c_code/2_2/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_2/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen.nim.c -o c_code/2_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mscriptconfig.nim.c -o c_code/2_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimconf.nim.c -o c_code/2_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmain.nim.c -o c_code/2_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pbrowsers.nim.c -o c_code/2_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnim.nim.c -o c_code/2_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_2/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_2/@psystem.nim.o \
c_code/2_2/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_2/@pstrutils.nim.o \
c_code/2_2/@ppathnorm.nim.o \
c_code/2_2/@pstd@soserrors.nim.o \
c_code/2_2/@pstd@ssyncio.nim.o \
c_code/2_2/@pposix.nim.o \
c_code/2_2/@pstd@sprivate@soscommon.nim.o \
c_code/2_2/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_2/@ptimes.nim.o \
c_code/2_2/@pstd@sprivate@sosfiles.nim.o \
c_code/2_2/@pstd@sprivate@sosdirs.nim.o \
c_code/2_2/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_2/@pos.nim.o \
c_code/2_2/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_2/@pstrtabs.nim.o \
c_code/2_2/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_2/@moptions.nim.o \
c_code/2_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_2/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_2/@mlexer.nim.o \
c_code/2_2/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_2/@pstreams.nim.o \
c_code/2_2/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_2/@pstd@smonotimes.nim.o \
c_code/2_2/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_2/@mextccomp.nim.o \
c_code/2_2/@mnimblecmd.nim.o \
c_code/2_2/@mcommands.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/2_2/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_2/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_2/@msigmatch.nim.o \
c_code/2_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/@pdynlib.nim.o \
c_code/2_2/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_2/@mvmdeps.nim.o \
c_code/2_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_2/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_2/@msem.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/2_2/@mdepends.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/2_2/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_2/@ppackages@sdocutils@srst.nim.o \
c_code/2_2/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_2/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_2/@mscriptconfig.nim.o \
c_code/2_2/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_2/@pbrowsers.nim.o \
c_code/2_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@phashes.nim.c -o c_code/2_3/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mplatform.nim.c -o c_code/2_3/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_3/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_3/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  ia64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mplatform.nim.c -o c_code/2_4/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_4/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  alpha)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_5/@mplatform.nim.c -o c_code/2_5/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_5/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@phashes.nim.c -o c_code/2_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mplatform.nim.c -o c_code/2_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_6/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psystem@sexceptions.nim.c -o c_code/2_7/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sdigitsutils.nim.c -o c_code/2_7/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sassertions.nim.c -o c_code/2_7/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psystem@siterators.nim.c -o c_code/2_7/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psystem@sdollars.nim.c -o c_code/2_7/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sdragonbox.nim.c -o c_code/2_7/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sschubfach.nim.c -o c_code/2_7/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sformatfloat.nim.c -o c_code/2_7/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psystem.nim.c -o c_code/2_7/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pparseutils.nim.c -o c_code/2_7/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pmath.nim.c -o c_code/2_7/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@palgorithm.nim.c -o c_code/2_7/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@senumutils.nim.c -o c_code/2_7/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@punicode.nim.c -o c_code/2_7/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstrutils.nim.c -o c_code/2_7/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppathnorm.nim.c -o c_code/2_7/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@soserrors.nim.c -o c_code/2_7/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@ssyncio.nim.c -o c_code/2_7/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@soscommon.nim.c -o c_code/2_7/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sospaths2.nim.c -o c_code/2_7/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_7/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ptimes.nim.c -o c_code/2_7/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sosfiles.nim.c -o c_code/2_7/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sosdirs.nim.c -o c_code/2_7/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@senvvars.nim.c -o c_code/2_7/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_7/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@scmdline.nim.c -o c_code/2_7/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pos.nim.c -o c_code/2_7/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pparseopt.nim.c -o c_code/2_7/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psequtils.nim.c -o c_code/2_7/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@phashes.nim.c -o c_code/2_7/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstrtabs.nim.c -o c_code/2_7/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ptables.nim.c -o c_code/2_7/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstrformat.nim.c -o c_code/2_7/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pterminal.nim.c -o c_code/2_7/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpathutils.nim.c -o c_code/2_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mropes.nim.c -o c_code/2_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlineinfos.nim.c -o c_code/2_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplatform.nim.c -o c_code/2_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprefixmatches.nim.c -o c_code/2_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimpaths.nim.c -o c_code/2_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psets.nim.c -o c_code/2_7/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sobjectdollar.nim.c -o c_code/2_7/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sglobs.nim.c -o c_code/2_7/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptions.nim.c -o c_code/2_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmsgs.nim.c -o c_code/2_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcondsyms.nim.c -o c_code/2_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mwordrecg.nim.c -o c_code/2_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@midents.nim.c -o c_code/2_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mint128.nim.c -o c_code/2_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnodekinds.nim.c -o c_code/2_7/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mast.nim.c -o c_code/2_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mllstream.nim.c -o c_code/2_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimlexbase.nim.c -o c_code/2_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlexer.nim.c -o c_code/2_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderer.nim.c -o c_code/2_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulepaths.nim.c -o c_code/2_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstreams.nim.c -o c_code/2_7/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pcpuinfo.nim.c -o c_code/2_7/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pdeques.nim.c -o c_code/2_7/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@smonotimes.nim.c -o c_code/2_7/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@posproc.nim.c -o c_code/2_7/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@plexbase.nim.c -o c_code/2_7/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pparsejson.nim.c -o c_code/2_7/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pjson.nim.c -o c_code/2_7/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sjsonutils.nim.c -o c_code/2_7/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mextccomp.nim.c -o c_code/2_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimblecmd.nim.c -o c_code/2_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcommands.nim.c -o c_code/2_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparser.nim.c -o c_code/2_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilters.nim.c -o c_code/2_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mfilter_tmpl.nim.c -o c_code/2_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msyntaxes.nim.c -o c_code/2_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrodutils.nim.c -o c_code/2_7/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@spackedsets.nim.c -o c_code/2_7/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastyaml.nim.c -o c_code/2_7/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastalgo.nim.c -o c_code/2_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtrees.nim.c -o c_code/2_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbtrees.nim.c -o c_code/2_7/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpackages.nim.c -o c_code/2_7/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msuggestsymdb.nim.c -o c_code/2_7/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@srodfiles.nim.c -o c_code/2_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sbitabs.nim.c -o c_code/2_7/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@siclineinfos.nim.c -o c_code/2_7/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@spacked_ast.nim.c -o c_code/2_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sic.nim.c -o c_code/2_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodulegraphs.nim.c -o c_code/2_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmagicsys.nim.c -o c_code/2_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mastmsgs.nim.c -o c_code/2_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypes.nim.c -o c_code/2_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimsets.nim.c -o c_code/2_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgendata.nim.c -o c_code/2_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmangleutils.nim.c -o c_code/2_7/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mccgutils.nim.c -o c_code/2_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtreetab.nim.c -o c_code/2_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msaturate.nim.c -o c_code/2_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mguards.nim.c -o c_code/2_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemfold.nim.c -o c_code/2_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdef.nim.c -o c_code/2_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlayeredtable.nim.c -o c_code/2_7/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlowerings.nim.c -o c_code/2_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mparampatterns.nim.c -o c_code/2_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemdata.nim.c -o c_code/2_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypeallowed.nim.c -o c_code/2_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@misolation_check.nim.c -o c_code/2_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvarpartitions.nim.c -o c_code/2_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnilcheck.nim.c -o c_code/2_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@merrorhandling.nim.c -o c_code/2_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliasanalysis.nim.c -o c_code/2_7/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemstrictfuncs.nim.c -o c_code/2_7/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@seditdistance.nim.c -o c_code/2_7/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pheapqueue.nim.c -o c_code/2_7/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlookups.nim.c -o c_code/2_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlinter.nim.c -o c_code/2_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemtypinst.nim.c -o c_code/2_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mconcepts.nim.c -o c_code/2_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msigmatch.nim.c -o c_code/2_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpragmas.nim.c -o c_code/2_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpushpoppragmas.nim.c -o c_code/2_7/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msighashes.nim.c -o c_code/2_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftdestructors.nim.c -o c_code/2_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msempass2.nim.c -o c_code/2_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgmeth.nim.c -o c_code/2_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@maliases.nim.c -o c_code/2_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mliftlocals.nim.c -o c_code/2_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mlambdalifting.nim.c -o c_code/2_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mclosureiters.nim.c -o c_code/2_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtransf.nim.c -o c_code/2_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@moptimizer.nim.c -o c_code/2_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdfa.nim.c -o c_code/2_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@minjectdestructors.nim.c -o c_code/2_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mexpanddefaults.nim.c -o c_code/2_7/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpipelineutils.nim.c -o c_code/2_7/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mspawn.nim.c -o c_code/2_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemparallel.nim.c -o c_code/2_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pdynlib.nim.c -o c_code/2_7/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcgen.nim.c -o c_code/2_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmodules.nim.c -o c_code/2_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msemmacrosanity.nim.c -o c_code/2_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmgen.nim.c -o c_code/2_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmdeps.nim.c -o c_code/2_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mgorgeimpl.nim.c -o c_code/2_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmacrocacheimpl.nim.c -o c_code/2_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmprofiler.nim.c -o c_code/2_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mevaltempl.nim.c -o c_code/2_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmconv.nim.c -o c_code/2_7/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvmmarshal.nim.c -o c_code/2_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvm.nim.c -o c_code/2_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mimporter.nim.c -o c_code/2_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mprocfind.nim.c -o c_code/2_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpatterns.nim.c -o c_code/2_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpluginsupport.nim.c -o c_code/2_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@slocals.nim.c -o c_code/2_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sitersgen.nim.c -o c_code/2_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mplugins@sactive.nim.c -o c_code/2_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@menumtostr.nim.c -o c_code/2_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mvtables.nim.c -o c_code/2_7/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msem.nim.c -o c_code/2_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mreorder.nim.c -o c_code/2_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdepends.nim.c -o c_code/2_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@msourcemap.nim.c -o c_code/2_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mjsgen.nim.c -o c_code/2_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@plists.nim.c -o c_code/2_7/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@srstast.nim.c -o c_code/2_7/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_7/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_7/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@shighlite.nim.c -o c_code/2_7/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@srst.nim.c -o c_code/2_7/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_7/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mtypesrenderer.nim.c -o c_code/2_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mrenderverbatim.nim.c -o c_code/2_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pxmltree.nim.c -o c_code/2_7/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@puri.nim.c -o c_code/2_7/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen.nim.c -o c_code/2_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mdocgen2.nim.c -o c_code/2_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sreplayer.nim.c -o c_code/2_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mpipelines.nim.c -o c_code/2_7/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mscriptconfig.nim.c -o c_code/2_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnimconf.nim.c -o c_code/2_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sdce.nim.c -o c_code/2_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@scbackend.nim.c -o c_code/2_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@sintegrity.nim.c -o c_code/2_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mic@snavigator.nim.c -o c_code/2_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mmain.nim.c -o c_code/2_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mcmdlinehelper.nim.c -o c_code/2_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pbrowsers.nim.c -o c_code/2_7/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnim.nim.c -o c_code/2_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_7/@psystem@sexceptions.nim.o \
c_code/2_7/@pstd@sprivate@sdigitsutils.nim.o \
c_code/2_7/@pstd@sassertions.nim.o \
c_code/2_7/@psystem@siterators.nim.o \
c_code/2_7/@psystem@sdollars.nim.o \
c_code/2_7/@pstd@sprivate@sdragonbox.nim.o \
c_code/2_7/@pstd@sprivate@sschubfach.nim.o \
c_code/2_7/@pstd@sformatfloat.nim.o \
c_code/2_7/@psystem.nim.o \
c_code/2_7/@pparseutils.nim.o \
c_code/2_7/@pmath.nim.o \
c_code/2_7/@palgorithm.nim.o \
c_code/2_7/@pstd@senumutils.nim.o \
c_code/2_7/@punicode.nim.o \
c_code/2_7/@pstrutils.nim.o \
c_code/2_7/@ppathnorm.nim.o \
c_code/2_7/@pstd@soserrors.nim.o \
c_code/2_7/@pstd@ssyncio.nim.o \
c_code/2_7/@pstd@sprivate@soscommon.nim.o \
c_code/2_7/@pstd@sprivate@sospaths2.nim.o \
c_code/2_7/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_7/@ptimes.nim.o \
c_code/2_7/@pstd@sprivate@sosfiles.nim.o \
c_code/2_7/@pstd@sprivate@sosdirs.nim.o \
c_code/2_7/@pstd@senvvars.nim.o \
c_code/2_7/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_7/@pstd@scmdline.nim.o \
c_code/2_7/@pos.nim.o \
c_code/2_7/@pparseopt.nim.o \
c_code/2_7/@psequtils.nim.o \
c_code/2_7/@phashes.nim.o \
c_code/2_7/@pstrtabs.nim.o \
c_code/2_7/@ptables.nim.o \
c_code/2_7/@pstrformat.nim.o \
c_code/2_7/@pterminal.nim.o \
c_code/2_7/@mpathutils.nim.o \
c_code/2_7/@mropes.nim.o \
c_code/2_7/@mlineinfos.nim.o \
c_code/2_7/@mplatform.nim.o \
c_code/2_7/@mprefixmatches.nim.o \
c_code/2_7/@mnimpaths.nim.o \
c_code/2_7/@psets.nim.o \
c_code/2_7/@pstd@sobjectdollar.nim.o \
c_code/2_7/@pstd@sprivate@sglobs.nim.o \
c_code/2_7/@moptions.nim.o \
c_code/2_7/@mmsgs.nim.o \
c_code/2_7/@mcondsyms.nim.o \
c_code/2_7/@mwordrecg.nim.o \
c_code/2_7/@midents.nim.o \
c_code/2_7/@mint128.nim.o \
c_code/2_7/@mnodekinds.nim.o \
c_code/2_7/@mast.nim.o \
c_code/2_7/@mllstream.nim.o \
c_code/2_7/@mnimlexbase.nim.o \
c_code/2_7/@mlexer.nim.o \
c_code/2_7/@mrenderer.nim.o \
c_code/2_7/@mmodulepaths.nim.o \
c_code/2_7/@pstreams.nim.o \
c_code/2_7/@pcpuinfo.nim.o \
c_code/2_7/@pdeques.nim.o \
c_code/2_7/@pstd@smonotimes.nim.o \
c_code/2_7/@posproc.nim.o \
c_code/2_7/@plexbase.nim.o \
c_code/2_7/@pparsejson.nim.o \
c_code/2_7/@pjson.nim.o \
c_code/2_7/@pstd@sjsonutils.nim.o \
c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_7/@mextccomp.nim.o \
c_code/2_7/@mnimblecmd.nim.o \
c_code/2_7/@mcommands.nim.o \
c_code/2_7/@mparser.nim.o \
c_code/2_7/@mfilters.nim.o \
c_code/2_7/@mfilter_tmpl.nim.o \
c_code/2_7/@msyntaxes.nim.o \
c_code/2_7/@mrodutils.nim.o \
c_code/2_7/@pstd@spackedsets.nim.o \
c_code/2_7/@mastyaml.nim.o \
c_code/2_7/@mastalgo.nim.o \
c_code/2_7/@mtrees.nim.o \
c_code/2_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_7/@mbtrees.nim.o \
c_code/2_7/@mpackages.nim.o \
c_code/2_7/@msuggestsymdb.nim.o \
c_code/2_7/@mic@srodfiles.nim.o \
c_code/2_7/@mic@sbitabs.nim.o \
c_code/2_7/@mic@siclineinfos.nim.o \
c_code/2_7/@mic@spacked_ast.nim.o \
c_code/2_7/@mic@sic.nim.o \
c_code/2_7/@mmodulegraphs.nim.o \
c_code/2_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/2_7/@mastmsgs.nim.o \
c_code/2_7/@mtypes.nim.o \
c_code/2_7/@mnimsets.nim.o \
c_code/2_7/@mcgendata.nim.o \
c_code/2_7/@mmangleutils.nim.o \
c_code/2_7/@mccgutils.nim.o \
c_code/2_7/@mtreetab.nim.o \
c_code/2_7/@msaturate.nim.o \
c_code/2_7/@mguards.nim.o \
c_code/2_7/@msemfold.nim.o \
c_code/2_7/@mvmdef.nim.o \
c_code/2_7/@mlayeredtable.nim.o \
c_code/2_7/@mlowerings.nim.o \
c_code/2_7/@mparampatterns.nim.o \
c_code/2_7/@msemdata.nim.o \
c_code/2_7/@mtypeallowed.nim.o \
c_code/2_7/@misolation_check.nim.o \
c_code/2_7/@mvarpartitions.nim.o \
c_code/2_7/@mnilcheck.nim.o \
c_code/2_7/@merrorhandling.nim.o \
c_code/2_7/@maliasanalysis.nim.o \
c_code/2_7/@msemstrictfuncs.nim.o \
c_code/2_7/@pstd@seditdistance.nim.o \
c_code/2_7/@pheapqueue.nim.o \
c_code/2_7/@mlookups.nim.o \
c_code/2_7/@mlinter.nim.o \
c_code/2_7/@msemtypinst.nim.o \
c_code/2_7/@mconcepts.nim.o \
c_code/2_7/@msigmatch.nim.o \
c_code/2_7/@mpragmas.nim.o \
c_code/2_7/@mpushpoppragmas.nim.o \
c_code/2_7/@msighashes.nim.o \
c_code/2_7/@mliftdestructors.nim.o \
c_code/2_7/@msempass2.nim.o \
c_code/2_7/@mcgmeth.nim.o \
c_code/2_7/@maliases.nim.o \
c_code/2_7/@mliftlocals.nim.o \
c_code/2_7/@mlambdalifting.nim.o \
c_code/2_7/@mclosureiters.nim.o \
c_code/2_7/@mtransf.nim.o \
c_code/2_7/@moptimizer.nim.o \
c_code/2_7/@mdfa.nim.o \
c_code/2_7/@minjectdestructors.nim.o \
c_code/2_7/@mexpanddefaults.nim.o \
c_code/2_7/@mpipelineutils.nim.o \
c_code/2_7/@mspawn.nim.o \
c_code/2_7/@msemparallel.nim.o \
c_code/2_7/@pdynlib.nim.o \
c_code/2_7/@mcgen.nim.o \
c_code/2_7/@mmodules.nim.o \
c_code/2_7/@msemmacrosanity.nim.o \
c_code/2_7/@mvmgen.nim.o \
c_code/2_7/@mvmdeps.nim.o \
c_code/2_7/@mgorgeimpl.nim.o \
c_code/2_7/@mmacrocacheimpl.nim.o \
c_code/2_7/@mvmprofiler.nim.o \
c_code/2_7/@mevaltempl.nim.o \
c_code/2_7/@mvmconv.nim.o \
c_code/2_7/@mvmmarshal.nim.o \
c_code/2_7/@mvm.nim.o \
c_code/2_7/@mimporter.nim.o \
c_code/2_7/@mprocfind.nim.o \
c_code/2_7/@mpatterns.nim.o \
c_code/2_7/@mpluginsupport.nim.o \
c_code/2_7/@mplugins@slocals.nim.o \
c_code/2_7/@mplugins@sitersgen.nim.o \
c_code/2_7/@mplugins@sactive.nim.o \
c_code/2_7/@menumtostr.nim.o \
c_code/2_7/@mvtables.nim.o \
c_code/2_7/@msem.nim.o \
c_code/2_7/@mreorder.nim.o \
c_code/2_7/@mdepends.nim.o \
c_code/2_7/@msourcemap.nim.o \
c_code/2_7/@mjsgen.nim.o \
c_code/2_7/@plists.nim.o \
c_code/2_7/@ppackages@sdocutils@srstast.nim.o \
c_code/2_7/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_7/@ppackages@sdocutils@srstidx.nim.o \
c_code/2_7/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_7/@ppackages@sdocutils@srst.nim.o \
c_code/2_7/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_7/@mtypesrenderer.nim.o \
c_code/2_7/@mrenderverbatim.nim.o \
c_code/2_7/@pxmltree.nim.o \
c_code/2_7/@puri.nim.o \
c_code/2_7/@mdocgen.nim.o \
c_code/2_7/@mdocgen2.nim.o \
c_code/2_7/@mic@sreplayer.nim.o \
c_code/2_7/@mpipelines.nim.o \
c_code/2_7/@mscriptconfig.nim.o \
c_code/2_7/@mnimconf.nim.o \
c_code/2_7/@mic@sdce.nim.o \
c_code/2_7/@mic@scbackend.nim.o \
c_code/2_7/@mic@sintegrity.nim.o \
c_code/2_7/@mic@snavigator.nim.o \
c_code/2_7/@mmain.nim.o \
c_code/2_7/@mcmdlinehelper.nim.o \
c_code/2_7/@pbrowsers.nim.o \
c_code/2_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@phashes.nim.c -o c_code/2_3/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_8/@mplatform.nim.c -o c_code/2_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_3/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_8/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@phashes.nim.c -o c_code/2_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_9/@mplatform.nim.c -o c_code/2_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_6/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_9/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  s390x)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@phashes.nim.c -o c_code/2_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_10/@mplatform.nim.c -o c_code/2_10/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_6/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_10/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  m68k)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@phashes.nim.c -o c_code/2_3/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_11/@mplatform.nim.c -o c_code/2_11/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_3/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_11/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@phashes.nim.c -o c_code/2_3/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_12/@mplatform.nim.c -o c_code/2_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_3/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_12/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@phashes.nim.c -o c_code/2_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_13/@mplatform.nim.c -o c_code/2_13/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_13/@mic@srodfiles.nim.c -o c_code/2_13/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_1/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_13/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_13/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@phashes.nim.c -o c_code/2_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_14/@mplatform.nim.c -o c_code/2_14/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_6/@mic@srodfiles.nim.c -o c_code/2_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_6/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_14/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_15/@mplatform.nim.c -o c_code/2_15/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_15/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@phashes.nim.c -o c_code/2_3/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_16/@mplatform.nim.c -o c_code/2_16/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@srodfiles.nim.c -o c_code/2_3/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_3/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_16/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_3/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_3/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_17/@mplatform.nim.c -o c_code/2_17/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_17/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem@sexceptions.nim.c -o c_code/2_18/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sdigitsutils.nim.c -o c_code/2_18/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sassertions.nim.c -o c_code/2_18/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem@siterators.nim.c -o c_code/2_18/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem@sdollars.nim.c -o c_code/2_18/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sdragonbox.nim.c -o c_code/2_18/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sschubfach.nim.c -o c_code/2_18/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sformatfloat.nim.c -o c_code/2_18/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem.nim.c -o c_code/2_18/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pparseutils.nim.c -o c_code/2_18/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pmath.nim.c -o c_code/2_18/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@palgorithm.nim.c -o c_code/2_18/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@senumutils.nim.c -o c_code/2_18/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@punicode.nim.c -o c_code/2_18/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstrutils.nim.c -o c_code/2_18/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppathnorm.nim.c -o c_code/2_18/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@soserrors.nim.c -o c_code/2_18/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@ssyncio.nim.c -o c_code/2_18/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@soscommon.nim.c -o c_code/2_18/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sospaths2.nim.c -o c_code/2_18/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_18/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ptimes.nim.c -o c_code/2_18/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sosfiles.nim.c -o c_code/2_18/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sosdirs.nim.c -o c_code/2_18/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@senvvars.nim.c -o c_code/2_18/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_18/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@scmdline.nim.c -o c_code/2_18/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pos.nim.c -o c_code/2_18/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pparseopt.nim.c -o c_code/2_18/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psequtils.nim.c -o c_code/2_18/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@phashes.nim.c -o c_code/2_18/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstrtabs.nim.c -o c_code/2_18/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ptables.nim.c -o c_code/2_18/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstrformat.nim.c -o c_code/2_18/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pterminal.nim.c -o c_code/2_18/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpathutils.nim.c -o c_code/2_18/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mropes.nim.c -o c_code/2_18/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlineinfos.nim.c -o c_code/2_18/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplatform.nim.c -o c_code/2_18/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mprefixmatches.nim.c -o c_code/2_18/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimpaths.nim.c -o c_code/2_18/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psets.nim.c -o c_code/2_18/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sobjectdollar.nim.c -o c_code/2_18/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sglobs.nim.c -o c_code/2_18/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@moptions.nim.c -o c_code/2_18/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmsgs.nim.c -o c_code/2_18/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcondsyms.nim.c -o c_code/2_18/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mwordrecg.nim.c -o c_code/2_18/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@midents.nim.c -o c_code/2_18/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mint128.nim.c -o c_code/2_18/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnodekinds.nim.c -o c_code/2_18/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mast.nim.c -o c_code/2_18/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mllstream.nim.c -o c_code/2_18/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimlexbase.nim.c -o c_code/2_18/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlexer.nim.c -o c_code/2_18/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mrenderer.nim.c -o c_code/2_18/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmodulepaths.nim.c -o c_code/2_18/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstreams.nim.c -o c_code/2_18/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pcpuinfo.nim.c -o c_code/2_18/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pdeques.nim.c -o c_code/2_18/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@smonotimes.nim.c -o c_code/2_18/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@posproc.nim.c -o c_code/2_18/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@plexbase.nim.c -o c_code/2_18/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pparsejson.nim.c -o c_code/2_18/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pjson.nim.c -o c_code/2_18/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sjsonutils.nim.c -o c_code/2_18/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mextccomp.nim.c -o c_code/2_18/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimblecmd.nim.c -o c_code/2_18/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcommands.nim.c -o c_code/2_18/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mparser.nim.c -o c_code/2_18/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mfilters.nim.c -o c_code/2_18/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mfilter_tmpl.nim.c -o c_code/2_18/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msyntaxes.nim.c -o c_code/2_18/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mrodutils.nim.c -o c_code/2_18/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@spackedsets.nim.c -o c_code/2_18/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastyaml.nim.c -o c_code/2_18/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastalgo.nim.c -o c_code/2_18/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtrees.nim.c -o c_code/2_18/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mbtrees.nim.c -o c_code/2_18/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpackages.nim.c -o c_code/2_18/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msuggestsymdb.nim.c -o c_code/2_18/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@srodfiles.nim.c -o c_code/2_18/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sbitabs.nim.c -o c_code/2_18/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@siclineinfos.nim.c -o c_code/2_18/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@spacked_ast.nim.c -o c_code/2_18/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sic.nim.c -o c_code/2_18/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmodulegraphs.nim.c -o c_code/2_18/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmagicsys.nim.c -o c_code/2_18/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mbitsets.nim.c -o c_code/2_18/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastmsgs.nim.c -o c_code/2_18/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypes.nim.c -o c_code/2_18/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimsets.nim.c -o c_code/2_18/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcgendata.nim.c -o c_code/2_18/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmangleutils.nim.c -o c_code/2_18/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mccgutils.nim.c -o c_code/2_18/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtreetab.nim.c -o c_code/2_18/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msaturate.nim.c -o c_code/2_18/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mguards.nim.c -o c_code/2_18/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemfold.nim.c -o c_code/2_18/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmdef.nim.c -o c_code/2_18/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlayeredtable.nim.c -o c_code/2_18/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlowerings.nim.c -o c_code/2_18/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mparampatterns.nim.c -o c_code/2_18/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemdata.nim.c -o c_code/2_18/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypeallowed.nim.c -o c_code/2_18/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@misolation_check.nim.c -o c_code/2_18/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvarpartitions.nim.c -o c_code/2_18/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnilcheck.nim.c -o c_code/2_18/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@merrorhandling.nim.c -o c_code/2_18/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@maliasanalysis.nim.c -o c_code/2_18/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemstrictfuncs.nim.c -o c_code/2_18/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@seditdistance.nim.c -o c_code/2_18/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pheapqueue.nim.c -o c_code/2_18/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlookups.nim.c -o c_code/2_18/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlinter.nim.c -o c_code/2_18/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemtypinst.nim.c -o c_code/2_18/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mconcepts.nim.c -o c_code/2_18/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msigmatch.nim.c -o c_code/2_18/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpragmas.nim.c -o c_code/2_18/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpushpoppragmas.nim.c -o c_code/2_18/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msighashes.nim.c -o c_code/2_18/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mliftdestructors.nim.c -o c_code/2_18/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msempass2.nim.c -o c_code/2_18/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcgmeth.nim.c -o c_code/2_18/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@maliases.nim.c -o c_code/2_18/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mliftlocals.nim.c -o c_code/2_18/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlambdalifting.nim.c -o c_code/2_18/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mclosureiters.nim.c -o c_code/2_18/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtransf.nim.c -o c_code/2_18/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@moptimizer.nim.c -o c_code/2_18/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdfa.nim.c -o c_code/2_18/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@minjectdestructors.nim.c -o c_code/2_18/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mexpanddefaults.nim.c -o c_code/2_18/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpipelineutils.nim.c -o c_code/2_18/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mspawn.nim.c -o c_code/2_18/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemparallel.nim.c -o c_code/2_18/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pdynlib.nim.c -o c_code/2_18/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcgen.nim.c -o c_code/2_18/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmodules.nim.c -o c_code/2_18/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemmacrosanity.nim.c -o c_code/2_18/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmgen.nim.c -o c_code/2_18/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmdeps.nim.c -o c_code/2_18/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mgorgeimpl.nim.c -o c_code/2_18/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmacrocacheimpl.nim.c -o c_code/2_18/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmprofiler.nim.c -o c_code/2_18/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mevaltempl.nim.c -o c_code/2_18/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmconv.nim.c -o c_code/2_18/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmmarshal.nim.c -o c_code/2_18/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvm.nim.c -o c_code/2_18/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mimporter.nim.c -o c_code/2_18/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mprocfind.nim.c -o c_code/2_18/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpatterns.nim.c -o c_code/2_18/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpluginsupport.nim.c -o c_code/2_18/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@slocals.nim.c -o c_code/2_18/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@sitersgen.nim.c -o c_code/2_18/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@sactive.nim.c -o c_code/2_18/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@menumtostr.nim.c -o c_code/2_18/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvtables.nim.c -o c_code/2_18/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msem.nim.c -o c_code/2_18/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mreorder.nim.c -o c_code/2_18/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdepends.nim.c -o c_code/2_18/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msourcemap.nim.c -o c_code/2_18/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mjsgen.nim.c -o c_code/2_18/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@plists.nim.c -o c_code/2_18/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@srstast.nim.c -o c_code/2_18/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_18/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_18/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@shighlite.nim.c -o c_code/2_18/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@srst.nim.c -o c_code/2_18/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_18/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypesrenderer.nim.c -o c_code/2_18/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mrenderverbatim.nim.c -o c_code/2_18/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pxmltree.nim.c -o c_code/2_18/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@puri.nim.c -o c_code/2_18/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdocgen.nim.c -o c_code/2_18/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdocgen2.nim.c -o c_code/2_18/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sreplayer.nim.c -o c_code/2_18/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpipelines.nim.c -o c_code/2_18/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mscriptconfig.nim.c -o c_code/2_18/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimconf.nim.c -o c_code/2_18/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sdce.nim.c -o c_code/2_18/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@scbackend.nim.c -o c_code/2_18/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sintegrity.nim.c -o c_code/2_18/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@snavigator.nim.c -o c_code/2_18/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmain.nim.c -o c_code/2_18/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcmdlinehelper.nim.c -o c_code/2_18/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pbrowsers.nim.c -o c_code/2_18/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnim.nim.c -o c_code/2_18/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_18/@psystem@sexceptions.nim.o \
c_code/2_18/@pstd@sprivate@sdigitsutils.nim.o \
c_code/2_18/@pstd@sassertions.nim.o \
c_code/2_18/@psystem@siterators.nim.o \
c_code/2_18/@psystem@sdollars.nim.o \
c_code/2_18/@pstd@sprivate@sdragonbox.nim.o \
c_code/2_18/@pstd@sprivate@sschubfach.nim.o \
c_code/2_18/@pstd@sformatfloat.nim.o \
c_code/2_18/@psystem.nim.o \
c_code/2_18/@pparseutils.nim.o \
c_code/2_18/@pmath.nim.o \
c_code/2_18/@palgorithm.nim.o \
c_code/2_18/@pstd@senumutils.nim.o \
c_code/2_18/@punicode.nim.o \
c_code/2_18/@pstrutils.nim.o \
c_code/2_18/@ppathnorm.nim.o \
c_code/2_18/@pstd@soserrors.nim.o \
c_code/2_18/@pstd@ssyncio.nim.o \
c_code/2_18/@pstd@sprivate@soscommon.nim.o \
c_code/2_18/@pstd@sprivate@sospaths2.nim.o \
c_code/2_18/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_18/@ptimes.nim.o \
c_code/2_18/@pstd@sprivate@sosfiles.nim.o \
c_code/2_18/@pstd@sprivate@sosdirs.nim.o \
c_code/2_18/@pstd@senvvars.nim.o \
c_code/2_18/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_18/@pstd@scmdline.nim.o \
c_code/2_18/@pos.nim.o \
c_code/2_18/@pparseopt.nim.o \
c_code/2_18/@psequtils.nim.o \
c_code/2_18/@phashes.nim.o \
c_code/2_18/@pstrtabs.nim.o \
c_code/2_18/@ptables.nim.o \
c_code/2_18/@pstrformat.nim.o \
c_code/2_18/@pterminal.nim.o \
c_code/2_18/@mpathutils.nim.o \
c_code/2_18/@mropes.nim.o \
c_code/2_18/@mlineinfos.nim.o \
c_code/2_18/@mplatform.nim.o \
c_code/2_18/@mprefixmatches.nim.o \
c_code/2_18/@mnimpaths.nim.o \
c_code/2_18/@psets.nim.o \
c_code/2_18/@pstd@sobjectdollar.nim.o \
c_code/2_18/@pstd@sprivate@sglobs.nim.o \
c_code/2_18/@moptions.nim.o \
c_code/2_18/@mmsgs.nim.o \
c_code/2_18/@mcondsyms.nim.o \
c_code/2_18/@mwordrecg.nim.o \
c_code/2_18/@midents.nim.o \
c_code/2_18/@mint128.nim.o \
c_code/2_18/@mnodekinds.nim.o \
c_code/2_18/@mast.nim.o \
c_code/2_18/@mllstream.nim.o \
c_code/2_18/@mnimlexbase.nim.o \
c_code/2_18/@mlexer.nim.o \
c_code/2_18/@mrenderer.nim.o \
c_code/2_18/@mmodulepaths.nim.o \
c_code/2_18/@pstreams.nim.o \
c_code/2_18/@pcpuinfo.nim.o \
c_code/2_18/@pdeques.nim.o \
c_code/2_18/@pstd@smonotimes.nim.o \
c_code/2_18/@posproc.nim.o \
c_code/2_18/@plexbase.nim.o \
c_code/2_18/@pparsejson.nim.o \
c_code/2_18/@pjson.nim.o \
c_code/2_18/@pstd@sjsonutils.nim.o \
c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_18/@mextccomp.nim.o \
c_code/2_18/@mnimblecmd.nim.o \
c_code/2_18/@mcommands.nim.o \
c_code/2_18/@mparser.nim.o \
c_code/2_18/@mfilters.nim.o \
c_code/2_18/@mfilter_tmpl.nim.o \
c_code/2_18/@msyntaxes.nim.o \
c_code/2_18/@mrodutils.nim.o \
c_code/2_18/@pstd@spackedsets.nim.o \
c_code/2_18/@mastyaml.nim.o \
c_code/2_18/@mastalgo.nim.o \
c_code/2_18/@mtrees.nim.o \
c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_18/@mbtrees.nim.o \
c_code/2_18/@mpackages.nim.o \
c_code/2_18/@msuggestsymdb.nim.o \
c_code/2_18/@mic@srodfiles.nim.o \
c_code/2_18/@mic@sbitabs.nim.o \
c_code/2_18/@mic@siclineinfos.nim.o \
c_code/2_18/@mic@spacked_ast.nim.o \
c_code/2_18/@mic@sic.nim.o \
c_code/2_18/@mmodulegraphs.nim.o \
c_code/2_18/@mmagicsys.nim.o \
c_code/2_18/@mbitsets.nim.o \
c_code/2_18/@mastmsgs.nim.o \
c_code/2_18/@mtypes.nim.o \
c_code/2_18/@mnimsets.nim.o \
c_code/2_18/@mcgendata.nim.o \
c_code/2_18/@mmangleutils.nim.o \
c_code/2_18/@mccgutils.nim.o \
c_code/2_18/@mtreetab.nim.o \
c_code/2_18/@msaturate.nim.o \
c_code/2_18/@mguards.nim.o \
c_code/2_18/@msemfold.nim.o \
c_code/2_18/@mvmdef.nim.o \
c_code/2_18/@mlayeredtable.nim.o \
c_code/2_18/@mlowerings.nim.o \
c_code/2_18/@mparampatterns.nim.o \
c_code/2_18/@msemdata.nim.o \
c_code/2_18/@mtypeallowed.nim.o \
c_code/2_18/@misolation_check.nim.o \
c_code/2_18/@mvarpartitions.nim.o \
c_code/2_18/@mnilcheck.nim.o \
c_code/2_18/@merrorhandling.nim.o \
c_code/2_18/@maliasanalysis.nim.o \
c_code/2_18/@msemstrictfuncs.nim.o \
c_code/2_18/@pstd@seditdistance.nim.o \
c_code/2_18/@pheapqueue.nim.o \
c_code/2_18/@mlookups.nim.o \
c_code/2_18/@mlinter.nim.o \
c_code/2_18/@msemtypinst.nim.o \
c_code/2_18/@mconcepts.nim.o \
c_code/2_18/@msigmatch.nim.o \
c_code/2_18/@mpragmas.nim.o \
c_code/2_18/@mpushpoppragmas.nim.o \
c_code/2_18/@msighashes.nim.o \
c_code/2_18/@mliftdestructors.nim.o \
c_code/2_18/@msempass2.nim.o \
c_code/2_18/@mcgmeth.nim.o \
c_code/2_18/@maliases.nim.o \
c_code/2_18/@mliftlocals.nim.o \
c_code/2_18/@mlambdalifting.nim.o \
c_code/2_18/@mclosureiters.nim.o \
c_code/2_18/@mtransf.nim.o \
c_code/2_18/@moptimizer.nim.o \
c_code/2_18/@mdfa.nim.o \
c_code/2_18/@minjectdestructors.nim.o \
c_code/2_18/@mexpanddefaults.nim.o \
c_code/2_18/@mpipelineutils.nim.o \
c_code/2_18/@mspawn.nim.o \
c_code/2_18/@msemparallel.nim.o \
c_code/2_18/@pdynlib.nim.o \
c_code/2_18/@mcgen.nim.o \
c_code/2_18/@mmodules.nim.o \
c_code/2_18/@msemmacrosanity.nim.o \
c_code/2_18/@mvmgen.nim.o \
c_code/2_18/@mvmdeps.nim.o \
c_code/2_18/@mgorgeimpl.nim.o \
c_code/2_18/@mmacrocacheimpl.nim.o \
c_code/2_18/@mvmprofiler.nim.o \
c_code/2_18/@mevaltempl.nim.o \
c_code/2_18/@mvmconv.nim.o \
c_code/2_18/@mvmmarshal.nim.o \
c_code/2_18/@mvm.nim.o \
c_code/2_18/@mimporter.nim.o \
c_code/2_18/@mprocfind.nim.o \
c_code/2_18/@mpatterns.nim.o \
c_code/2_18/@mpluginsupport.nim.o \
c_code/2_18/@mplugins@slocals.nim.o \
c_code/2_18/@mplugins@sitersgen.nim.o \
c_code/2_18/@mplugins@sactive.nim.o \
c_code/2_18/@menumtostr.nim.o \
c_code/2_18/@mvtables.nim.o \
c_code/2_18/@msem.nim.o \
c_code/2_18/@mreorder.nim.o \
c_code/2_18/@mdepends.nim.o \
c_code/2_18/@msourcemap.nim.o \
c_code/2_18/@mjsgen.nim.o \
c_code/2_18/@plists.nim.o \
c_code/2_18/@ppackages@sdocutils@srstast.nim.o \
c_code/2_18/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_18/@ppackages@sdocutils@srstidx.nim.o \
c_code/2_18/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_18/@ppackages@sdocutils@srst.nim.o \
c_code/2_18/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_18/@mtypesrenderer.nim.o \
c_code/2_18/@mrenderverbatim.nim.o \
c_code/2_18/@pxmltree.nim.o \
c_code/2_18/@puri.nim.o \
c_code/2_18/@mdocgen.nim.o \
c_code/2_18/@mdocgen2.nim.o \
c_code/2_18/@mic@sreplayer.nim.o \
c_code/2_18/@mpipelines.nim.o \
c_code/2_18/@mscriptconfig.nim.o \
c_code/2_18/@mnimconf.nim.o \
c_code/2_18/@mic@sdce.nim.o \
c_code/2_18/@mic@scbackend.nim.o \
c_code/2_18/@mic@sintegrity.nim.o \
c_code/2_18/@mic@snavigator.nim.o \
c_code/2_18/@mmain.nim.o \
c_code/2_18/@mcmdlinehelper.nim.o \
c_code/2_18/@pbrowsers.nim.o \
c_code/2_18/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem@sexceptions.nim.c -o c_code/2_3/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sdollars.nim.c -o c_code/2_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@psystem.nim.c -o c_code/2_3/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseutils.nim.c -o c_code/2_3/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pmath.nim.c -o c_code/2_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@palgorithm.nim.c -o c_code/2_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrutils.nim.c -o c_code/2_3/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppathnorm.nim.c -o c_code/2_3/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@soserrors.nim.c -o c_code/2_3/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@ssyncio.nim.c -o c_code/2_3/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sospaths2.nim.c -o c_code/2_3/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ptimes.nim.c -o c_code/2_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosfiles.nim.c -o c_code/2_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@sprivate@sosdirs.nim.c -o c_code/2_3/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstd@senvvars.nim.c -o c_code/2_3/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pos.nim.c -o c_code/2_3/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pparseopt.nim.c -o c_code/2_3/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@phashes.nim.c -o c_code/2_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstrtabs.nim.c -o c_code/2_3/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ptables.nim.c -o c_code/2_3/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pterminal.nim.c -o c_code/2_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpathutils.nim.c -o c_code/2_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mropes.nim.c -o c_code/2_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_19/@mplatform.nim.c -o c_code/2_19/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptions.nim.c -o c_code/2_3/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmsgs.nim.c -o c_code/2_3/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mast.nim.c -o c_code/2_3/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mllstream.nim.c -o c_code/2_3/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlexer.nim.c -o c_code/2_3/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderer.nim.c -o c_code/2_3/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulepaths.nim.c -o c_code/2_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pstreams.nim.c -o c_code/2_3/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pcpuinfo.nim.c -o c_code/2_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@smonotimes.nim.c -o c_code/2_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@posproc.nim.c -o c_code/2_3/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pjson.nim.c -o c_code/2_3/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sjsonutils.nim.c -o c_code/1_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mextccomp.nim.c -o c_code/2_3/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimblecmd.nim.c -o c_code/2_3/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcommands.nim.c -o c_code/2_3/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mparser.nim.c -o c_code/2_3/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mfilter_tmpl.nim.c -o c_code/2_3/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msyntaxes.nim.c -o c_code/2_3/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mastalgo.nim.c -o c_code/2_3/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mbtrees.nim.c -o c_code/2_3/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_13/@mic@srodfiles.nim.c -o c_code/2_13/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sic.nim.c -o c_code/2_3/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmodulegraphs.nim.c -o c_code/2_3/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimsets.nim.c -o c_code/2_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgendata.nim.c -o c_code/2_3/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mguards.nim.c -o c_code/2_3/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmdef.nim.c -o c_code/2_3/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlowerings.nim.c -o c_code/2_3/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemdata.nim.c -o c_code/2_3/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvarpartitions.nim.c -o c_code/2_3/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnilcheck.nim.c -o c_code/2_3/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pheapqueue.nim.c -o c_code/2_3/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlookups.nim.c -o c_code/2_3/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemtypinst.nim.c -o c_code/2_3/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mconcepts.nim.c -o c_code/2_3/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msigmatch.nim.c -o c_code/2_3/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpragmas.nim.c -o c_code/2_3/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftdestructors.nim.c -o c_code/2_3/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msempass2.nim.c -o c_code/2_3/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mliftlocals.nim.c -o c_code/2_3/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mlambdalifting.nim.c -o c_code/2_3/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mclosureiters.nim.c -o c_code/2_3/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtransf.nim.c -o c_code/2_3/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@moptimizer.nim.c -o c_code/2_3/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdfa.nim.c -o c_code/2_3/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@minjectdestructors.nim.c -o c_code/2_3/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemparallel.nim.c -o c_code/2_3/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pdynlib.nim.c -o c_code/2_3/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mcgen.nim.c -o c_code/2_3/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msemmacrosanity.nim.c -o c_code/2_3/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvmgen.nim.c -o c_code/2_3/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmdeps.nim.c -o c_code/2_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mgorgeimpl.nim.c -o c_code/2_3/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmprofiler.nim.c -o c_code/2_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mevaltempl.nim.c -o c_code/2_3/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mvmconv.nim.c -o c_code/1_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mvm.nim.c -o c_code/2_3/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mimporter.nim.c -o c_code/2_3/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mprocfind.nim.c -o c_code/2_3/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mpatterns.nim.c -o c_code/2_3/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msem.nim.c -o c_code/2_3/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mreorder.nim.c -o c_code/2_3/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdepends.nim.c -o c_code/2_3/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@msourcemap.nim.c -o c_code/2_3/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mjsgen.nim.c -o c_code/2_3/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srst.nim.c -o c_code/2_3/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_3/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mtypesrenderer.nim.c -o c_code/2_3/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mrenderverbatim.nim.c -o c_code/2_3/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen.nim.c -o c_code/2_3/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mdocgen2.nim.c -o c_code/2_3/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sreplayer.nim.c -o c_code/2_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelines.nim.c -o c_code/2_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mscriptconfig.nim.c -o c_code/2_3/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnimconf.nim.c -o c_code/2_3/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sdce.nim.c -o c_code/2_3/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@sintegrity.nim.c -o c_code/2_3/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mic@snavigator.nim.c -o c_code/2_3/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mmain.nim.c -o c_code/2_3/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@pbrowsers.nim.c -o c_code/2_3/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_3/@mnim.nim.c -o c_code/2_3/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_3/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/2_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/2_3/@psystem.nim.o \
c_code/2_3/@pparseutils.nim.o \
c_code/2_1/@pmath.nim.o \
c_code/2_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/2_3/@pstrutils.nim.o \
c_code/2_3/@ppathnorm.nim.o \
c_code/2_3/@pstd@soserrors.nim.o \
c_code/2_3/@pstd@ssyncio.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/2_3/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_1/@ptimes.nim.o \
c_code/2_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_3/@pstd@sprivate@sosdirs.nim.o \
c_code/2_3/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/2_3/@pos.nim.o \
c_code/2_3/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/2_1/@phashes.nim.o \
c_code/2_3/@pstrtabs.nim.o \
c_code/2_3/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/2_1/@pterminal.nim.o \
c_code/2_1/@mpathutils.nim.o \
c_code/2_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/2_19/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/2_3/@moptions.nim.o \
c_code/2_3/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_3/@mast.nim.o \
c_code/2_3/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/2_3/@mlexer.nim.o \
c_code/2_3/@mrenderer.nim.o \
c_code/2_1/@mmodulepaths.nim.o \
c_code/2_3/@pstreams.nim.o \
c_code/2_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/2_1/@pstd@smonotimes.nim.o \
c_code/2_3/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/2_3/@pjson.nim.o \
c_code/1_1/@pstd@sjsonutils.nim.o \
c_code/2_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_3/@mextccomp.nim.o \
c_code/2_3/@mnimblecmd.nim.o \
c_code/2_3/@mcommands.nim.o \
c_code/2_3/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_3/@mfilter_tmpl.nim.o \
c_code/2_3/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_3/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_3/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/2_13/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_3/@mic@sic.nim.o \
c_code/2_3/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/2_1/@mnimsets.nim.o \
c_code/2_3/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_3/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/2_3/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_3/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_3/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_3/@mvarpartitions.nim.o \
c_code/2_3/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_3/@pheapqueue.nim.o \
c_code/2_3/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_3/@msemtypinst.nim.o \
c_code/2_3/@mconcepts.nim.o \
c_code/2_3/@msigmatch.nim.o \
c_code/2_3/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_3/@mliftdestructors.nim.o \
c_code/2_3/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_3/@mliftlocals.nim.o \
c_code/2_3/@mlambdalifting.nim.o \
c_code/2_3/@mclosureiters.nim.o \
c_code/2_3/@mtransf.nim.o \
c_code/2_3/@moptimizer.nim.o \
c_code/2_3/@mdfa.nim.o \
c_code/2_3/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_3/@msemparallel.nim.o \
c_code/2_3/@pdynlib.nim.o \
c_code/2_3/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_3/@msemmacrosanity.nim.o \
c_code/2_3/@mvmgen.nim.o \
c_code/2_1/@mvmdeps.nim.o \
c_code/2_3/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/2_1/@mvmprofiler.nim.o \
c_code/2_3/@mevaltempl.nim.o \
c_code/1_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/2_3/@mvm.nim.o \
c_code/2_3/@mimporter.nim.o \
c_code/2_3/@mprocfind.nim.o \
c_code/2_3/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/2_3/@msem.nim.o \
c_code/2_3/@mreorder.nim.o \
c_code/2_3/@mdepends.nim.o \
c_code/2_3/@msourcemap.nim.o \
c_code/2_3/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/2_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_3/@ppackages@sdocutils@srst.nim.o \
c_code/2_3/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_3/@mtypesrenderer.nim.o \
c_code/2_3/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/2_3/@mdocgen.nim.o \
c_code/2_3/@mdocgen2.nim.o \
c_code/2_1/@mic@sreplayer.nim.o \
c_code/2_1/@mpipelines.nim.o \
c_code/2_3/@mscriptconfig.nim.o \
c_code/2_3/@mnimconf.nim.o \
c_code/2_3/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_3/@mic@sintegrity.nim.o \
c_code/2_3/@mic@snavigator.nim.o \
c_code/2_3/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/2_3/@pbrowsers.nim.o \
c_code/2_3/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_20/@mplatform.nim.c -o c_code/2_20/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_20/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sdollars.nim.c -o c_code/2_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem.nim.c -o c_code/2_4/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pmath.nim.c -o c_code/2_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@palgorithm.nim.c -o c_code/2_4/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrutils.nim.c -o c_code/2_4/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@ssyncio.nim.c -o c_code/2_4/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sospaths2.nim.c -o c_code/2_4/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptimes.nim.c -o c_code/2_4/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosfiles.nim.c -o c_code/2_4/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@senvvars.nim.c -o c_code/2_4/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pos.nim.c -o c_code/2_4/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseopt.nim.c -o c_code/2_4/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@phashes.nim.c -o c_code/2_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ptables.nim.c -o c_code/2_4/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pterminal.nim.c -o c_code/2_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpathutils.nim.c -o c_code/2_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mropes.nim.c -o c_code/2_4/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_21/@mplatform.nim.c -o c_code/2_21/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@moptions.nim.c -o c_code/2_4/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmsgs.nim.c -o c_code/2_4/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mllstream.nim.c -o c_code/2_4/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mlexer.nim.c -o c_code/2_4/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mrenderer.nim.c -o c_code/2_4/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulepaths.nim.c -o c_code/2_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstreams.nim.c -o c_code/2_4/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pcpuinfo.nim.c -o c_code/2_4/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@smonotimes.nim.c -o c_code/2_4/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@posproc.nim.c -o c_code/2_4/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pjson.nim.c -o c_code/2_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sjsonutils.nim.c -o c_code/1_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mextccomp.nim.c -o c_code/2_4/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimblecmd.nim.c -o c_code/2_4/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcommands.nim.c -o c_code/2_4/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msyntaxes.nim.c -o c_code/2_4/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mbtrees.nim.c -o c_code/2_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@srodfiles.nim.c -o c_code/2_4/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimsets.nim.c -o c_code/2_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdef.nim.c -o c_code/2_4/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msigmatch.nim.c -o c_code/2_4/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mpragmas.nim.c -o c_code/2_4/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mcgen.nim.c -o c_code/2_4/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvmdeps.nim.c -o c_code/2_4/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mgorgeimpl.nim.c -o c_code/2_4/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmprofiler.nim.c -o c_code/2_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmconv.nim.c -o c_code/2_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mvm.nim.c -o c_code/2_4/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msem.nim.c -o c_code/2_4/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdepends.nim.c -o c_code/2_4/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mjsgen.nim.c -o c_code/2_4/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstidx.nim.c -o c_code/2_4/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srst.nim.c -o c_code/2_4/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppackages@sdocutils@srstgen.nim.c -o c_code/2_4/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mdocgen.nim.c -o c_code/2_4/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sreplayer.nim.c -o c_code/2_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelines.nim.c -o c_code/2_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mscriptconfig.nim.c -o c_code/2_4/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnimconf.nim.c -o c_code/2_4/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mmain.nim.c -o c_code/2_4/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pbrowsers.nim.c -o c_code/2_4/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mnim.nim.c -o c_code/2_4/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/2_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/2_4/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/2_2/@pmath.nim.o \
c_code/2_4/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/2_4/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/2_4/@pstd@ssyncio.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/2_4/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/2_4/@ptimes.nim.o \
c_code/2_4/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/2_4/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/2_4/@pos.nim.o \
c_code/2_4/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/2_2/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/2_4/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/2_2/@pterminal.nim.o \
c_code/2_2/@mpathutils.nim.o \
c_code/2_4/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/2_21/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/2_4/@moptions.nim.o \
c_code/2_4/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/2_4/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/2_4/@mlexer.nim.o \
c_code/2_4/@mrenderer.nim.o \
c_code/2_2/@mmodulepaths.nim.o \
c_code/2_4/@pstreams.nim.o \
c_code/2_4/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/2_4/@pstd@smonotimes.nim.o \
c_code/2_4/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/2_2/@pjson.nim.o \
c_code/1_2/@pstd@sjsonutils.nim.o \
c_code/2_4/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/2_4/@mextccomp.nim.o \
c_code/2_4/@mnimblecmd.nim.o \
c_code/2_4/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/2_4/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/2_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/2_4/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/2_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/2_4/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/2_4/@msigmatch.nim.o \
c_code/2_4/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/2_4/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/2_4/@mvmdeps.nim.o \
c_code/2_4/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/2_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/2_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/2_4/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/2_4/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/2_4/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/2_4/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/2_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/2_4/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/2_4/@ppackages@sdocutils@srst.nim.o \
c_code/2_4/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/2_4/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/2_2/@mic@sreplayer.nim.o \
c_code/2_2/@mpipelines.nim.o \
c_code/2_4/@mscriptconfig.nim.o \
c_code/2_4/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/2_4/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/2_4/@pbrowsers.nim.o \
c_code/2_4/@mnim.nim.o $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
macosx)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psystem@sexceptions.nim.c -o c_code/2_1/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sassertions.nim.c -o c_code/1_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@psystem@sdollars.nim.c -o c_code/3_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sformatfloat.nim.c -o c_code/1_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@psystem.nim.c -o c_code/3_1/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparseutils.nim.c -o c_code/2_1/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pmath.nim.c -o c_code/3_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@palgorithm.nim.c -o c_code/3_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@punicode.nim.c -o c_code/2_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstrutils.nim.c -o c_code/3_1/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppathnorm.nim.c -o c_code/2_1/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@soserrors.nim.c -o c_code/2_1/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstd@ssyncio.nim.c -o c_code/3_1/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pposix.nim.c -o c_code/3_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@soscommon.nim.c -o c_code/2_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstd@sprivate@sospaths2.nim.c -o c_code/3_1/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ptimes.nim.c -o c_code/3_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstd@sprivate@sosfiles.nim.c -o c_code/3_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstd@senvvars.nim.c -o c_code/3_1/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@scmdline.nim.c -o c_code/2_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pos.nim.c -o c_code/3_1/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pparseopt.nim.c -o c_code/3_1/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@phashes.nim.c -o c_code/3_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrtabs.nim.c -o c_code/2_1/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ptables.nim.c -o c_code/3_1/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstrformat.nim.c -o c_code/2_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pterminal.nim.c -o c_code/3_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mpathutils.nim.c -o c_code/3_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mropes.nim.c -o c_code/3_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlineinfos.nim.c -o c_code/2_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mplatform.nim.c -o c_code/3_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mprefixmatches.nim.c -o c_code/1_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimpaths.nim.c -o c_code/2_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@psets.nim.c -o c_code/2_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@moptions.nim.c -o c_code/3_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmsgs.nim.c -o c_code/3_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mcondsyms.nim.c -o c_code/1_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mwordrecg.nim.c -o c_code/1_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@midents.nim.c -o c_code/2_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mint128.nim.c -o c_code/2_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mast.nim.c -o c_code/2_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mllstream.nim.c -o c_code/3_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnimlexbase.nim.c -o c_code/2_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mlexer.nim.c -o c_code/3_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mrenderer.nim.c -o c_code/3_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmodulepaths.nim.c -o c_code/3_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstreams.nim.c -o c_code/3_1/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pcpuinfo.nim.c -o c_code/3_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pdeques.nim.c -o c_code/3_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@posproc.nim.c -o c_code/3_1/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@plexbase.nim.c -o c_code/1_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pparsejson.nim.c -o c_code/2_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pjson.nim.c -o c_code/3_1/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pstd@sjsonutils.nim.c -o c_code/3_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mextccomp.nim.c -o c_code/3_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimblecmd.nim.c -o c_code/3_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcommands.nim.c -o c_code/3_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparser.nim.c -o c_code/2_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilters.nim.c -o c_code/2_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mfilter_tmpl.nim.c -o c_code/2_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msyntaxes.nim.c -o c_code/3_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrodutils.nim.c -o c_code/2_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@spackedsets.nim.c -o c_code/2_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastyaml.nim.c -o c_code/2_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastalgo.nim.c -o c_code/2_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtrees.nim.c -o c_code/1_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mbtrees.nim.c -o c_code/3_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpackages.nim.c -o c_code/2_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msuggestsymdb.nim.c -o c_code/2_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@srodfiles.nim.c -o c_code/3_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@sbitabs.nim.c -o c_code/1_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@siclineinfos.nim.c -o c_code/1_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mic@spacked_ast.nim.c -o c_code/1_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sic.nim.c -o c_code/2_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodulegraphs.nim.c -o c_code/2_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmagicsys.nim.c -o c_code/2_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mastmsgs.nim.c -o c_code/2_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypes.nim.c -o c_code/2_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimsets.nim.c -o c_code/3_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgendata.nim.c -o c_code/2_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmangleutils.nim.c -o c_code/2_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mccgutils.nim.c -o c_code/2_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mtreetab.nim.c -o c_code/1_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mguards.nim.c -o c_code/2_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemfold.nim.c -o c_code/2_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdef.nim.c -o c_code/3_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlayeredtable.nim.c -o c_code/2_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlowerings.nim.c -o c_code/2_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mparampatterns.nim.c -o c_code/2_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemdata.nim.c -o c_code/2_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypeallowed.nim.c -o c_code/2_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@misolation_check.nim.c -o c_code/2_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvarpartitions.nim.c -o c_code/2_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mnilcheck.nim.c -o c_code/2_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@merrorhandling.nim.c -o c_code/1_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@maliasanalysis.nim.c -o c_code/1_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@msemstrictfuncs.nim.c -o c_code/1_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@seditdistance.nim.c -o c_code/2_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pheapqueue.nim.c -o c_code/2_1/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlookups.nim.c -o c_code/2_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlinter.nim.c -o c_code/2_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemtypinst.nim.c -o c_code/2_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mconcepts.nim.c -o c_code/2_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msigmatch.nim.c -o c_code/3_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mpragmas.nim.c -o c_code/3_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpushpoppragmas.nim.c -o c_code/1_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msighashes.nim.c -o c_code/2_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftdestructors.nim.c -o c_code/2_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msempass2.nim.c -o c_code/2_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcgmeth.nim.c -o c_code/2_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@maliases.nim.c -o c_code/2_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mliftlocals.nim.c -o c_code/2_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mlambdalifting.nim.c -o c_code/2_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mclosureiters.nim.c -o c_code/2_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtransf.nim.c -o c_code/2_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@moptimizer.nim.c -o c_code/2_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdfa.nim.c -o c_code/2_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@minjectdestructors.nim.c -o c_code/2_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mexpanddefaults.nim.c -o c_code/1_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpipelineutils.nim.c -o c_code/2_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mspawn.nim.c -o c_code/2_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemparallel.nim.c -o c_code/2_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdynlib.nim.c -o c_code/2_1/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mcgen.nim.c -o c_code/3_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mmodules.nim.c -o c_code/2_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msemmacrosanity.nim.c -o c_code/2_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmgen.nim.c -o c_code/2_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmdeps.nim.c -o c_code/3_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mgorgeimpl.nim.c -o c_code/3_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mmacrocacheimpl.nim.c -o c_code/1_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmprofiler.nim.c -o c_code/3_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mevaltempl.nim.c -o c_code/2_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvmconv.nim.c -o c_code/3_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvmmarshal.nim.c -o c_code/2_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mvm.nim.c -o c_code/3_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mimporter.nim.c -o c_code/2_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mprocfind.nim.c -o c_code/2_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mpatterns.nim.c -o c_code/2_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mpluginsupport.nim.c -o c_code/1_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@slocals.nim.c -o c_code/1_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mplugins@sitersgen.nim.c -o c_code/2_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mplugins@sactive.nim.c -o c_code/1_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@menumtostr.nim.c -o c_code/1_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mvtables.nim.c -o c_code/2_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@msem.nim.c -o c_code/3_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mreorder.nim.c -o c_code/2_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdepends.nim.c -o c_code/3_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msourcemap.nim.c -o c_code/2_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mjsgen.nim.c -o c_code/3_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@plists.nim.c -o c_code/2_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@ppackages@sdocutils@srstast.nim.c -o c_code/2_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/3_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/3_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ppackages@sdocutils@srst.nim.c -o c_code/3_1/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@ppackages@sdocutils@srstgen.nim.c -o c_code/3_1/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mtypesrenderer.nim.c -o c_code/2_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mrenderverbatim.nim.c -o c_code/2_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pxmltree.nim.c -o c_code/1_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@puri.nim.c -o c_code/2_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mdocgen.nim.c -o c_code/3_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mdocgen2.nim.c -o c_code/2_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mic@sreplayer.nim.c -o c_code/3_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mpipelines.nim.c -o c_code/3_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mscriptconfig.nim.c -o c_code/3_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnimconf.nim.c -o c_code/3_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sdce.nim.c -o c_code/2_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@scbackend.nim.c -o c_code/2_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@sintegrity.nim.c -o c_code/2_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mic@snavigator.nim.c -o c_code/2_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mmain.nim.c -o c_code/3_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@mcmdlinehelper.nim.c -o c_code/2_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pbrowsers.nim.c -o c_code/3_1/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@mnim.nim.c -o c_code/3_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_1/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/3_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/1_1/@pstd@sformatfloat.nim.o \
c_code/3_1/@psystem.nim.o \
c_code/2_1/@pparseutils.nim.o \
c_code/3_1/@pmath.nim.o \
c_code/3_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/2_1/@punicode.nim.o \
c_code/3_1/@pstrutils.nim.o \
c_code/2_1/@ppathnorm.nim.o \
c_code/2_1/@pstd@soserrors.nim.o \
c_code/3_1/@pstd@ssyncio.nim.o \
c_code/3_1/@pposix.nim.o \
c_code/2_1/@pstd@sprivate@soscommon.nim.o \
c_code/3_1/@pstd@sprivate@sospaths2.nim.o \
c_code/2_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/3_1/@ptimes.nim.o \
c_code/3_1/@pstd@sprivate@sosfiles.nim.o \
c_code/2_1/@pstd@sprivate@sosdirs.nim.o \
c_code/3_1/@pstd@senvvars.nim.o \
c_code/2_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_1/@pstd@scmdline.nim.o \
c_code/3_1/@pos.nim.o \
c_code/3_1/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/3_1/@phashes.nim.o \
c_code/2_1/@pstrtabs.nim.o \
c_code/3_1/@ptables.nim.o \
c_code/2_1/@pstrformat.nim.o \
c_code/3_1/@pterminal.nim.o \
c_code/3_1/@mpathutils.nim.o \
c_code/3_1/@mropes.nim.o \
c_code/2_1/@mlineinfos.nim.o \
c_code/3_1/@mplatform.nim.o \
c_code/1_1/@mprefixmatches.nim.o \
c_code/2_1/@mnimpaths.nim.o \
c_code/2_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/3_1/@moptions.nim.o \
c_code/3_1/@mmsgs.nim.o \
c_code/1_1/@mcondsyms.nim.o \
c_code/1_1/@mwordrecg.nim.o \
c_code/2_1/@midents.nim.o \
c_code/2_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/2_1/@mast.nim.o \
c_code/3_1/@mllstream.nim.o \
c_code/2_1/@mnimlexbase.nim.o \
c_code/3_1/@mlexer.nim.o \
c_code/3_1/@mrenderer.nim.o \
c_code/3_1/@mmodulepaths.nim.o \
c_code/3_1/@pstreams.nim.o \
c_code/3_1/@pcpuinfo.nim.o \
c_code/3_1/@pdeques.nim.o \
c_code/3_1/@posproc.nim.o \
c_code/1_1/@plexbase.nim.o \
c_code/2_1/@pparsejson.nim.o \
c_code/3_1/@pjson.nim.o \
c_code/3_1/@pstd@sjsonutils.nim.o \
c_code/3_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_1/@mextccomp.nim.o \
c_code/3_1/@mnimblecmd.nim.o \
c_code/3_1/@mcommands.nim.o \
c_code/2_1/@mparser.nim.o \
c_code/2_1/@mfilters.nim.o \
c_code/2_1/@mfilter_tmpl.nim.o \
c_code/3_1/@msyntaxes.nim.o \
c_code/2_1/@mrodutils.nim.o \
c_code/2_1/@pstd@spackedsets.nim.o \
c_code/2_1/@mastyaml.nim.o \
c_code/2_1/@mastalgo.nim.o \
c_code/1_1/@mtrees.nim.o \
c_code/1_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_1/@mbtrees.nim.o \
c_code/2_1/@mpackages.nim.o \
c_code/2_1/@msuggestsymdb.nim.o \
c_code/3_1/@mic@srodfiles.nim.o \
c_code/1_1/@mic@sbitabs.nim.o \
c_code/1_1/@mic@siclineinfos.nim.o \
c_code/1_1/@mic@spacked_ast.nim.o \
c_code/2_1/@mic@sic.nim.o \
c_code/2_1/@mmodulegraphs.nim.o \
c_code/2_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/2_1/@mastmsgs.nim.o \
c_code/2_1/@mtypes.nim.o \
c_code/3_1/@mnimsets.nim.o \
c_code/2_1/@mcgendata.nim.o \
c_code/2_1/@mmangleutils.nim.o \
c_code/2_1/@mccgutils.nim.o \
c_code/1_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/2_1/@mguards.nim.o \
c_code/2_1/@msemfold.nim.o \
c_code/3_1/@mvmdef.nim.o \
c_code/2_1/@mlayeredtable.nim.o \
c_code/2_1/@mlowerings.nim.o \
c_code/2_1/@mparampatterns.nim.o \
c_code/2_1/@msemdata.nim.o \
c_code/2_1/@mtypeallowed.nim.o \
c_code/2_1/@misolation_check.nim.o \
c_code/2_1/@mvarpartitions.nim.o \
c_code/2_1/@mnilcheck.nim.o \
c_code/1_1/@merrorhandling.nim.o \
c_code/1_1/@maliasanalysis.nim.o \
c_code/1_1/@msemstrictfuncs.nim.o \
c_code/2_1/@pstd@seditdistance.nim.o \
c_code/2_1/@pheapqueue.nim.o \
c_code/2_1/@mlookups.nim.o \
c_code/2_1/@mlinter.nim.o \
c_code/2_1/@msemtypinst.nim.o \
c_code/2_1/@mconcepts.nim.o \
c_code/3_1/@msigmatch.nim.o \
c_code/3_1/@mpragmas.nim.o \
c_code/1_1/@mpushpoppragmas.nim.o \
c_code/2_1/@msighashes.nim.o \
c_code/2_1/@mliftdestructors.nim.o \
c_code/2_1/@msempass2.nim.o \
c_code/2_1/@mcgmeth.nim.o \
c_code/2_1/@maliases.nim.o \
c_code/2_1/@mliftlocals.nim.o \
c_code/2_1/@mlambdalifting.nim.o \
c_code/2_1/@mclosureiters.nim.o \
c_code/2_1/@mtransf.nim.o \
c_code/2_1/@moptimizer.nim.o \
c_code/2_1/@mdfa.nim.o \
c_code/2_1/@minjectdestructors.nim.o \
c_code/1_1/@mexpanddefaults.nim.o \
c_code/2_1/@mpipelineutils.nim.o \
c_code/2_1/@mspawn.nim.o \
c_code/2_1/@msemparallel.nim.o \
c_code/2_1/@pdynlib.nim.o \
c_code/3_1/@mcgen.nim.o \
c_code/2_1/@mmodules.nim.o \
c_code/2_1/@msemmacrosanity.nim.o \
c_code/2_1/@mvmgen.nim.o \
c_code/3_1/@mvmdeps.nim.o \
c_code/3_1/@mgorgeimpl.nim.o \
c_code/1_1/@mmacrocacheimpl.nim.o \
c_code/3_1/@mvmprofiler.nim.o \
c_code/2_1/@mevaltempl.nim.o \
c_code/3_1/@mvmconv.nim.o \
c_code/2_1/@mvmmarshal.nim.o \
c_code/3_1/@mvm.nim.o \
c_code/2_1/@mimporter.nim.o \
c_code/2_1/@mprocfind.nim.o \
c_code/2_1/@mpatterns.nim.o \
c_code/1_1/@mpluginsupport.nim.o \
c_code/1_1/@mplugins@slocals.nim.o \
c_code/2_1/@mplugins@sitersgen.nim.o \
c_code/1_1/@mplugins@sactive.nim.o \
c_code/1_1/@menumtostr.nim.o \
c_code/2_1/@mvtables.nim.o \
c_code/3_1/@msem.nim.o \
c_code/2_1/@mreorder.nim.o \
c_code/3_1/@mdepends.nim.o \
c_code/2_1/@msourcemap.nim.o \
c_code/3_1/@mjsgen.nim.o \
c_code/2_1/@plists.nim.o \
c_code/2_1/@ppackages@sdocutils@srstast.nim.o \
c_code/3_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/3_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/3_1/@ppackages@sdocutils@srst.nim.o \
c_code/3_1/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_1/@mtypesrenderer.nim.o \
c_code/2_1/@mrenderverbatim.nim.o \
c_code/1_1/@pxmltree.nim.o \
c_code/2_1/@puri.nim.o \
c_code/3_1/@mdocgen.nim.o \
c_code/2_1/@mdocgen2.nim.o \
c_code/3_1/@mic@sreplayer.nim.o \
c_code/3_1/@mpipelines.nim.o \
c_code/3_1/@mscriptconfig.nim.o \
c_code/3_1/@mnimconf.nim.o \
c_code/2_1/@mic@sdce.nim.o \
c_code/2_1/@mic@scbackend.nim.o \
c_code/2_1/@mic@sintegrity.nim.o \
c_code/2_1/@mic@snavigator.nim.o \
c_code/3_1/@mmain.nim.o \
c_code/2_1/@mcmdlinehelper.nim.o \
c_code/3_1/@pbrowsers.nim.o \
c_code/3_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psystem@sexceptions.nim.c -o c_code/2_2/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@psystem@sdollars.nim.c -o c_code/3_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@psystem.nim.c -o c_code/3_2/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparseutils.nim.c -o c_code/2_2/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pmath.nim.c -o c_code/3_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@palgorithm.nim.c -o c_code/3_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstrutils.nim.c -o c_code/3_2/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppathnorm.nim.c -o c_code/2_2/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@soserrors.nim.c -o c_code/2_2/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@ssyncio.nim.c -o c_code/3_2/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pposix.nim.c -o c_code/3_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sprivate@sospaths2.nim.c -o c_code/3_2/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ptimes.nim.c -o c_code/3_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sprivate@sosfiles.nim.c -o c_code/3_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sprivate@sosdirs.nim.c -o c_code/3_2/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@senvvars.nim.c -o c_code/3_2/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pos.nim.c -o c_code/3_2/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pparseopt.nim.c -o c_code/3_2/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@phashes.nim.c -o c_code/3_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrtabs.nim.c -o c_code/2_2/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ptables.nim.c -o c_code/3_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pterminal.nim.c -o c_code/3_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpathutils.nim.c -o c_code/3_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mplatform.nim.c -o c_code/3_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@moptions.nim.c -o c_code/3_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmsgs.nim.c -o c_code/3_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mllstream.nim.c -o c_code/3_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mlexer.nim.c -o c_code/3_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mrenderer.nim.c -o c_code/3_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstreams.nim.c -o c_code/3_2/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pcpuinfo.nim.c -o c_code/3_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pdeques.nim.c -o c_code/3_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@posproc.nim.c -o c_code/3_2/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pjson.nim.c -o c_code/3_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sjsonutils.nim.c -o c_code/3_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mextccomp.nim.c -o c_code/3_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimblecmd.nim.c -o c_code/3_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcommands.nim.c -o c_code/3_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparser.nim.c -o c_code/2_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilter_tmpl.nim.c -o c_code/2_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msyntaxes.nim.c -o c_code/3_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mbtrees.nim.c -o c_code/3_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@srodfiles.nim.c -o c_code/3_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sic.nim.c -o c_code/2_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimsets.nim.c -o c_code/3_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdef.nim.c -o c_code/3_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemdata.nim.c -o c_code/2_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msigmatch.nim.c -o c_code/3_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpragmas.nim.c -o c_code/3_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@minjectdestructors.nim.c -o c_code/2_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdynlib.nim.c -o c_code/2_2/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mcgen.nim.c -o c_code/3_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mgorgeimpl.nim.c -o c_code/3_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmprofiler.nim.c -o c_code/3_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvm.nim.c -o c_code/3_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@msem.nim.c -o c_code/3_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mreorder.nim.c -o c_code/2_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdepends.nim.c -o c_code/3_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msourcemap.nim.c -o c_code/2_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mjsgen.nim.c -o c_code/3_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/3_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@srst.nim.c -o c_code/3_2/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@srstgen.nim.c -o c_code/3_2/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypesrenderer.nim.c -o c_code/2_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mdocgen.nim.c -o c_code/3_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sreplayer.nim.c -o c_code/3_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpipelines.nim.c -o c_code/3_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mscriptconfig.nim.c -o c_code/3_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimconf.nim.c -o c_code/3_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmain.nim.c -o c_code/3_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pbrowsers.nim.c -o c_code/3_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnim.nim.c -o c_code/3_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_2/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/3_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/3_2/@psystem.nim.o \
c_code/2_2/@pparseutils.nim.o \
c_code/3_2/@pmath.nim.o \
c_code/3_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/3_2/@pstrutils.nim.o \
c_code/2_2/@ppathnorm.nim.o \
c_code/2_2/@pstd@soserrors.nim.o \
c_code/3_2/@pstd@ssyncio.nim.o \
c_code/3_2/@pposix.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/3_2/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/3_2/@ptimes.nim.o \
c_code/3_2/@pstd@sprivate@sosfiles.nim.o \
c_code/3_2/@pstd@sprivate@sosdirs.nim.o \
c_code/3_2/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/3_2/@pos.nim.o \
c_code/3_2/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/3_2/@phashes.nim.o \
c_code/2_2/@pstrtabs.nim.o \
c_code/3_2/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/3_2/@pterminal.nim.o \
c_code/3_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/3_2/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/3_2/@moptions.nim.o \
c_code/3_2/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/3_2/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/3_2/@mlexer.nim.o \
c_code/3_2/@mrenderer.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/3_2/@pstreams.nim.o \
c_code/3_2/@pcpuinfo.nim.o \
c_code/3_2/@pdeques.nim.o \
c_code/3_2/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/3_2/@pjson.nim.o \
c_code/3_2/@pstd@sjsonutils.nim.o \
c_code/3_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_2/@mextccomp.nim.o \
c_code/3_2/@mnimblecmd.nim.o \
c_code/3_2/@mcommands.nim.o \
c_code/2_2/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_2/@mfilter_tmpl.nim.o \
c_code/3_2/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/3_2/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_2/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/3_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/3_2/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_2/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/3_2/@msigmatch.nim.o \
c_code/3_2/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_2/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_2/@pdynlib.nim.o \
c_code/3_2/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/3_2/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/3_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_2/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/3_2/@msem.nim.o \
c_code/2_2/@mreorder.nim.o \
c_code/3_2/@mdepends.nim.o \
c_code/2_2/@msourcemap.nim.o \
c_code/3_2/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/3_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/3_2/@ppackages@sdocutils@srst.nim.o \
c_code/3_2/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_2/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/3_2/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/3_2/@mic@sreplayer.nim.o \
c_code/3_2/@mpipelines.nim.o \
c_code/3_2/@mscriptconfig.nim.o \
c_code/3_2/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/3_2/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/3_2/@pbrowsers.nim.o \
c_code/3_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@psystem@sexceptions.nim.c -o c_code/2_4/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sassertions.nim.c -o c_code/1_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@psystem@sdollars.nim.c -o c_code/3_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sformatfloat.nim.c -o c_code/1_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@psystem.nim.c -o c_code/3_6/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pparseutils.nim.c -o c_code/2_4/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pmath.nim.c -o c_code/3_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@palgorithm.nim.c -o c_code/3_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@punicode.nim.c -o c_code/2_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pstrutils.nim.c -o c_code/3_6/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@ppathnorm.nim.c -o c_code/2_4/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@soserrors.nim.c -o c_code/2_4/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pstd@ssyncio.nim.c -o c_code/3_6/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pposix.nim.c -o c_code/3_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@soscommon.nim.c -o c_code/2_4/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pstd@sprivate@sospaths2.nim.c -o c_code/3_6/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ptimes.nim.c -o c_code/3_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sprivate@sosfiles.nim.c -o c_code/3_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstd@sprivate@sosdirs.nim.c -o c_code/2_4/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pstd@senvvars.nim.c -o c_code/3_6/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@scmdline.nim.c -o c_code/2_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pos.nim.c -o c_code/3_6/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pparseopt.nim.c -o c_code/3_6/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@phashes.nim.c -o c_code/3_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pstrtabs.nim.c -o c_code/2_4/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@ptables.nim.c -o c_code/3_6/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstrformat.nim.c -o c_code/2_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pterminal.nim.c -o c_code/3_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpathutils.nim.c -o c_code/3_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mropes.nim.c -o c_code/3_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlineinfos.nim.c -o c_code/2_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mplatform.nim.c -o c_code/3_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mprefixmatches.nim.c -o c_code/1_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimpaths.nim.c -o c_code/2_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@psets.nim.c -o c_code/2_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@moptions.nim.c -o c_code/3_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmsgs.nim.c -o c_code/3_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mcondsyms.nim.c -o c_code/1_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mwordrecg.nim.c -o c_code/1_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@midents.nim.c -o c_code/2_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mint128.nim.c -o c_code/2_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mast.nim.c -o c_code/2_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mllstream.nim.c -o c_code/3_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnimlexbase.nim.c -o c_code/2_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mlexer.nim.c -o c_code/3_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mrenderer.nim.c -o c_code/3_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mmodulepaths.nim.c -o c_code/3_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@pstreams.nim.c -o c_code/3_6/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pcpuinfo.nim.c -o c_code/3_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pdeques.nim.c -o c_code/3_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@posproc.nim.c -o c_code/3_6/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@plexbase.nim.c -o c_code/1_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pparsejson.nim.c -o c_code/2_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pjson.nim.c -o c_code/3_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pstd@sjsonutils.nim.c -o c_code/3_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mextccomp.nim.c -o c_code/3_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimblecmd.nim.c -o c_code/3_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcommands.nim.c -o c_code/3_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mparser.nim.c -o c_code/2_4/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mfilters.nim.c -o c_code/2_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mfilter_tmpl.nim.c -o c_code/2_4/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msyntaxes.nim.c -o c_code/3_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrodutils.nim.c -o c_code/2_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@spackedsets.nim.c -o c_code/2_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastyaml.nim.c -o c_code/2_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastalgo.nim.c -o c_code/2_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtrees.nim.c -o c_code/1_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mbtrees.nim.c -o c_code/3_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpackages.nim.c -o c_code/2_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msuggestsymdb.nim.c -o c_code/2_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mic@srodfiles.nim.c -o c_code/3_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@sbitabs.nim.c -o c_code/1_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@siclineinfos.nim.c -o c_code/1_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mic@spacked_ast.nim.c -o c_code/1_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mic@sic.nim.c -o c_code/2_4/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodulegraphs.nim.c -o c_code/2_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmagicsys.nim.c -o c_code/2_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mastmsgs.nim.c -o c_code/2_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypes.nim.c -o c_code/2_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mnimsets.nim.c -o c_code/3_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgendata.nim.c -o c_code/2_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmangleutils.nim.c -o c_code/2_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mccgutils.nim.c -o c_code/2_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mtreetab.nim.c -o c_code/1_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mguards.nim.c -o c_code/2_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemfold.nim.c -o c_code/2_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvmdef.nim.c -o c_code/3_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlayeredtable.nim.c -o c_code/2_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlowerings.nim.c -o c_code/2_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mparampatterns.nim.c -o c_code/2_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msemdata.nim.c -o c_code/2_4/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtypeallowed.nim.c -o c_code/2_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@misolation_check.nim.c -o c_code/2_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvarpartitions.nim.c -o c_code/2_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mnilcheck.nim.c -o c_code/2_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@merrorhandling.nim.c -o c_code/1_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@maliasanalysis.nim.c -o c_code/1_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@msemstrictfuncs.nim.c -o c_code/1_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@seditdistance.nim.c -o c_code/2_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pheapqueue.nim.c -o c_code/2_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlookups.nim.c -o c_code/2_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlinter.nim.c -o c_code/2_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemtypinst.nim.c -o c_code/2_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mconcepts.nim.c -o c_code/2_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msigmatch.nim.c -o c_code/3_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mpragmas.nim.c -o c_code/3_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpushpoppragmas.nim.c -o c_code/1_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msighashes.nim.c -o c_code/2_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftdestructors.nim.c -o c_code/2_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msempass2.nim.c -o c_code/2_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcgmeth.nim.c -o c_code/2_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@maliases.nim.c -o c_code/2_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mliftlocals.nim.c -o c_code/2_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mlambdalifting.nim.c -o c_code/2_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mclosureiters.nim.c -o c_code/2_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mtransf.nim.c -o c_code/2_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@moptimizer.nim.c -o c_code/2_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdfa.nim.c -o c_code/2_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@minjectdestructors.nim.c -o c_code/2_4/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mexpanddefaults.nim.c -o c_code/1_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpipelineutils.nim.c -o c_code/2_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mspawn.nim.c -o c_code/2_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemparallel.nim.c -o c_code/2_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@pdynlib.nim.c -o c_code/2_4/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mcgen.nim.c -o c_code/3_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mmodules.nim.c -o c_code/2_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msemmacrosanity.nim.c -o c_code/2_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmgen.nim.c -o c_code/2_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmdeps.nim.c -o c_code/3_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mgorgeimpl.nim.c -o c_code/3_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mmacrocacheimpl.nim.c -o c_code/1_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mvmprofiler.nim.c -o c_code/3_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mevaltempl.nim.c -o c_code/2_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mvmconv.nim.c -o c_code/1_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvmmarshal.nim.c -o c_code/2_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mvm.nim.c -o c_code/3_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mimporter.nim.c -o c_code/2_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mprocfind.nim.c -o c_code/2_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mpatterns.nim.c -o c_code/2_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mpluginsupport.nim.c -o c_code/1_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@slocals.nim.c -o c_code/1_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mplugins@sitersgen.nim.c -o c_code/2_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mplugins@sactive.nim.c -o c_code/1_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@menumtostr.nim.c -o c_code/1_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mvtables.nim.c -o c_code/2_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@msem.nim.c -o c_code/3_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mreorder.nim.c -o c_code/2_4/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdepends.nim.c -o c_code/3_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@msourcemap.nim.c -o c_code/2_4/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mjsgen.nim.c -o c_code/3_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@plists.nim.c -o c_code/2_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@ppackages@sdocutils@srstast.nim.c -o c_code/2_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/3_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/1_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@ppackages@sdocutils@srst.nim.c -o c_code/3_6/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@ppackages@sdocutils@srstgen.nim.c -o c_code/3_6/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_4/@mtypesrenderer.nim.c -o c_code/2_4/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mrenderverbatim.nim.c -o c_code/2_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pxmltree.nim.c -o c_code/1_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@puri.nim.c -o c_code/2_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mdocgen.nim.c -o c_code/3_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mdocgen2.nim.c -o c_code/2_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mic@sreplayer.nim.c -o c_code/3_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@mpipelines.nim.c -o c_code/3_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mscriptconfig.nim.c -o c_code/3_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnimconf.nim.c -o c_code/3_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sdce.nim.c -o c_code/2_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@scbackend.nim.c -o c_code/2_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@sintegrity.nim.c -o c_code/2_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mic@snavigator.nim.c -o c_code/2_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mmain.nim.c -o c_code/3_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@mcmdlinehelper.nim.c -o c_code/2_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_2/@pbrowsers.nim.c -o c_code/3_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_6/@mnim.nim.c -o c_code/3_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_4/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/1_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/3_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/1_2/@pstd@sformatfloat.nim.o \
c_code/3_6/@psystem.nim.o \
c_code/2_4/@pparseutils.nim.o \
c_code/3_2/@pmath.nim.o \
c_code/3_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/2_2/@punicode.nim.o \
c_code/3_6/@pstrutils.nim.o \
c_code/2_4/@ppathnorm.nim.o \
c_code/2_4/@pstd@soserrors.nim.o \
c_code/3_6/@pstd@ssyncio.nim.o \
c_code/3_2/@pposix.nim.o \
c_code/2_4/@pstd@sprivate@soscommon.nim.o \
c_code/3_6/@pstd@sprivate@sospaths2.nim.o \
c_code/2_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/3_2/@ptimes.nim.o \
c_code/3_2/@pstd@sprivate@sosfiles.nim.o \
c_code/2_4/@pstd@sprivate@sosdirs.nim.o \
c_code/3_6/@pstd@senvvars.nim.o \
c_code/2_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_2/@pstd@scmdline.nim.o \
c_code/3_6/@pos.nim.o \
c_code/3_6/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/3_6/@phashes.nim.o \
c_code/2_4/@pstrtabs.nim.o \
c_code/3_6/@ptables.nim.o \
c_code/2_2/@pstrformat.nim.o \
c_code/3_2/@pterminal.nim.o \
c_code/3_2/@mpathutils.nim.o \
c_code/3_2/@mropes.nim.o \
c_code/2_2/@mlineinfos.nim.o \
c_code/3_6/@mplatform.nim.o \
c_code/1_2/@mprefixmatches.nim.o \
c_code/2_2/@mnimpaths.nim.o \
c_code/2_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/3_6/@moptions.nim.o \
c_code/3_6/@mmsgs.nim.o \
c_code/1_2/@mcondsyms.nim.o \
c_code/1_2/@mwordrecg.nim.o \
c_code/2_2/@midents.nim.o \
c_code/2_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/2_2/@mast.nim.o \
c_code/3_6/@mllstream.nim.o \
c_code/2_2/@mnimlexbase.nim.o \
c_code/3_6/@mlexer.nim.o \
c_code/3_6/@mrenderer.nim.o \
c_code/3_2/@mmodulepaths.nim.o \
c_code/3_6/@pstreams.nim.o \
c_code/3_2/@pcpuinfo.nim.o \
c_code/3_2/@pdeques.nim.o \
c_code/3_6/@posproc.nim.o \
c_code/1_2/@plexbase.nim.o \
c_code/2_2/@pparsejson.nim.o \
c_code/3_2/@pjson.nim.o \
c_code/3_2/@pstd@sjsonutils.nim.o \
c_code/3_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_6/@mextccomp.nim.o \
c_code/3_6/@mnimblecmd.nim.o \
c_code/3_6/@mcommands.nim.o \
c_code/2_4/@mparser.nim.o \
c_code/2_2/@mfilters.nim.o \
c_code/2_4/@mfilter_tmpl.nim.o \
c_code/3_6/@msyntaxes.nim.o \
c_code/2_2/@mrodutils.nim.o \
c_code/2_2/@pstd@spackedsets.nim.o \
c_code/2_2/@mastyaml.nim.o \
c_code/2_2/@mastalgo.nim.o \
c_code/1_2/@mtrees.nim.o \
c_code/1_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_2/@mbtrees.nim.o \
c_code/2_2/@mpackages.nim.o \
c_code/2_2/@msuggestsymdb.nim.o \
c_code/3_6/@mic@srodfiles.nim.o \
c_code/1_2/@mic@sbitabs.nim.o \
c_code/1_2/@mic@siclineinfos.nim.o \
c_code/1_2/@mic@spacked_ast.nim.o \
c_code/2_4/@mic@sic.nim.o \
c_code/2_2/@mmodulegraphs.nim.o \
c_code/2_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/2_2/@mastmsgs.nim.o \
c_code/2_2/@mtypes.nim.o \
c_code/3_2/@mnimsets.nim.o \
c_code/2_2/@mcgendata.nim.o \
c_code/2_2/@mmangleutils.nim.o \
c_code/2_2/@mccgutils.nim.o \
c_code/1_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/2_2/@mguards.nim.o \
c_code/2_2/@msemfold.nim.o \
c_code/3_6/@mvmdef.nim.o \
c_code/2_2/@mlayeredtable.nim.o \
c_code/2_2/@mlowerings.nim.o \
c_code/2_2/@mparampatterns.nim.o \
c_code/2_4/@msemdata.nim.o \
c_code/2_2/@mtypeallowed.nim.o \
c_code/2_2/@misolation_check.nim.o \
c_code/2_2/@mvarpartitions.nim.o \
c_code/2_2/@mnilcheck.nim.o \
c_code/1_2/@merrorhandling.nim.o \
c_code/1_2/@maliasanalysis.nim.o \
c_code/1_2/@msemstrictfuncs.nim.o \
c_code/2_2/@pstd@seditdistance.nim.o \
c_code/2_2/@pheapqueue.nim.o \
c_code/2_2/@mlookups.nim.o \
c_code/2_2/@mlinter.nim.o \
c_code/2_2/@msemtypinst.nim.o \
c_code/2_2/@mconcepts.nim.o \
c_code/3_6/@msigmatch.nim.o \
c_code/3_6/@mpragmas.nim.o \
c_code/1_2/@mpushpoppragmas.nim.o \
c_code/2_2/@msighashes.nim.o \
c_code/2_2/@mliftdestructors.nim.o \
c_code/2_2/@msempass2.nim.o \
c_code/2_2/@mcgmeth.nim.o \
c_code/2_2/@maliases.nim.o \
c_code/2_2/@mliftlocals.nim.o \
c_code/2_2/@mlambdalifting.nim.o \
c_code/2_2/@mclosureiters.nim.o \
c_code/2_2/@mtransf.nim.o \
c_code/2_2/@moptimizer.nim.o \
c_code/2_2/@mdfa.nim.o \
c_code/2_4/@minjectdestructors.nim.o \
c_code/1_2/@mexpanddefaults.nim.o \
c_code/2_2/@mpipelineutils.nim.o \
c_code/2_2/@mspawn.nim.o \
c_code/2_2/@msemparallel.nim.o \
c_code/2_4/@pdynlib.nim.o \
c_code/3_6/@mcgen.nim.o \
c_code/2_2/@mmodules.nim.o \
c_code/2_2/@msemmacrosanity.nim.o \
c_code/2_2/@mvmgen.nim.o \
c_code/3_2/@mvmdeps.nim.o \
c_code/3_6/@mgorgeimpl.nim.o \
c_code/1_2/@mmacrocacheimpl.nim.o \
c_code/3_2/@mvmprofiler.nim.o \
c_code/2_2/@mevaltempl.nim.o \
c_code/1_2/@mvmconv.nim.o \
c_code/2_2/@mvmmarshal.nim.o \
c_code/3_6/@mvm.nim.o \
c_code/2_2/@mimporter.nim.o \
c_code/2_2/@mprocfind.nim.o \
c_code/2_2/@mpatterns.nim.o \
c_code/1_2/@mpluginsupport.nim.o \
c_code/1_2/@mplugins@slocals.nim.o \
c_code/2_2/@mplugins@sitersgen.nim.o \
c_code/1_2/@mplugins@sactive.nim.o \
c_code/1_2/@menumtostr.nim.o \
c_code/2_2/@mvtables.nim.o \
c_code/3_6/@msem.nim.o \
c_code/2_4/@mreorder.nim.o \
c_code/3_6/@mdepends.nim.o \
c_code/2_4/@msourcemap.nim.o \
c_code/3_6/@mjsgen.nim.o \
c_code/2_2/@plists.nim.o \
c_code/2_2/@ppackages@sdocutils@srstast.nim.o \
c_code/3_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/3_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/1_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/3_6/@ppackages@sdocutils@srst.nim.o \
c_code/3_6/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_4/@mtypesrenderer.nim.o \
c_code/2_2/@mrenderverbatim.nim.o \
c_code/1_2/@pxmltree.nim.o \
c_code/2_2/@puri.nim.o \
c_code/3_6/@mdocgen.nim.o \
c_code/2_2/@mdocgen2.nim.o \
c_code/3_2/@mic@sreplayer.nim.o \
c_code/3_2/@mpipelines.nim.o \
c_code/3_6/@mscriptconfig.nim.o \
c_code/3_6/@mnimconf.nim.o \
c_code/2_2/@mic@sdce.nim.o \
c_code/2_2/@mic@scbackend.nim.o \
c_code/2_2/@mic@sintegrity.nim.o \
c_code/2_2/@mic@snavigator.nim.o \
c_code/3_6/@mmain.nim.o \
c_code/2_2/@mcmdlinehelper.nim.o \
c_code/3_2/@pbrowsers.nim.o \
c_code/3_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  s390x)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem@sexceptions.nim.c -o c_code/2_18/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sdigitsutils.nim.c -o c_code/2_18/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sassertions.nim.c -o c_code/2_18/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psystem@siterators.nim.c -o c_code/2_18/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@psystem@sdollars.nim.c -o c_code/3_18/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sdragonbox.nim.c -o c_code/2_18/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sschubfach.nim.c -o c_code/2_18/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sformatfloat.nim.c -o c_code/2_18/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@psystem.nim.c -o c_code/3_18/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pparseutils.nim.c -o c_code/2_18/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pmath.nim.c -o c_code/3_18/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@palgorithm.nim.c -o c_code/3_18/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@senumutils.nim.c -o c_code/2_18/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@punicode.nim.c -o c_code/2_18/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstrutils.nim.c -o c_code/3_18/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppathnorm.nim.c -o c_code/2_18/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@soserrors.nim.c -o c_code/2_18/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstd@ssyncio.nim.c -o c_code/3_18/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pposix.nim.c -o c_code/3_18/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@soscommon.nim.c -o c_code/2_18/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstd@sprivate@sospaths2.nim.c -o c_code/3_18/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sossymlinks.nim.c -o c_code/2_18/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ptimes.nim.c -o c_code/3_18/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstd@sprivate@sosfiles.nim.c -o c_code/3_18/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sosdirs.nim.c -o c_code/2_18/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstd@senvvars.nim.c -o c_code/3_18/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sosappdirs.nim.c -o c_code/2_18/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@scmdline.nim.c -o c_code/2_18/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pos.nim.c -o c_code/3_18/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pparseopt.nim.c -o c_code/3_18/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psequtils.nim.c -o c_code/2_18/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@phashes.nim.c -o c_code/3_18/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstrtabs.nim.c -o c_code/2_18/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ptables.nim.c -o c_code/3_18/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstrformat.nim.c -o c_code/2_18/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pterminal.nim.c -o c_code/3_18/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mpathutils.nim.c -o c_code/3_18/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mropes.nim.c -o c_code/3_18/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlineinfos.nim.c -o c_code/2_18/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mplatform.nim.c -o c_code/3_18/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mprefixmatches.nim.c -o c_code/2_18/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimpaths.nim.c -o c_code/2_18/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@psets.nim.c -o c_code/2_18/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sobjectdollar.nim.c -o c_code/2_18/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@sprivate@sglobs.nim.c -o c_code/2_18/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@moptions.nim.c -o c_code/3_18/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mmsgs.nim.c -o c_code/3_18/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcondsyms.nim.c -o c_code/2_18/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mwordrecg.nim.c -o c_code/2_18/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@midents.nim.c -o c_code/2_18/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mint128.nim.c -o c_code/2_18/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnodekinds.nim.c -o c_code/2_18/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mast.nim.c -o c_code/2_18/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mllstream.nim.c -o c_code/3_18/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnimlexbase.nim.c -o c_code/2_18/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mlexer.nim.c -o c_code/3_18/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mrenderer.nim.c -o c_code/3_18/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mmodulepaths.nim.c -o c_code/3_18/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstreams.nim.c -o c_code/3_18/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pcpuinfo.nim.c -o c_code/3_18/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pdeques.nim.c -o c_code/3_18/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@posproc.nim.c -o c_code/3_18/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@plexbase.nim.c -o c_code/2_18/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pparsejson.nim.c -o c_code/2_18/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pjson.nim.c -o c_code/3_18/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pstd@sjsonutils.nim.c -o c_code/3_18/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/3_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mextccomp.nim.c -o c_code/3_18/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mnimblecmd.nim.c -o c_code/3_18/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mcommands.nim.c -o c_code/3_18/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mparser.nim.c -o c_code/2_18/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mfilters.nim.c -o c_code/2_18/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mfilter_tmpl.nim.c -o c_code/2_18/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@msyntaxes.nim.c -o c_code/3_18/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mrodutils.nim.c -o c_code/2_18/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@spackedsets.nim.c -o c_code/2_18/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastyaml.nim.c -o c_code/2_18/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastalgo.nim.c -o c_code/2_18/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtrees.nim.c -o c_code/2_18/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mbtrees.nim.c -o c_code/3_18/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpackages.nim.c -o c_code/2_18/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msuggestsymdb.nim.c -o c_code/2_18/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mic@srodfiles.nim.c -o c_code/3_18/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sbitabs.nim.c -o c_code/2_18/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@siclineinfos.nim.c -o c_code/2_18/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@spacked_ast.nim.c -o c_code/2_18/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sic.nim.c -o c_code/2_18/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmodulegraphs.nim.c -o c_code/2_18/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmagicsys.nim.c -o c_code/2_18/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mbitsets.nim.c -o c_code/2_18/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mastmsgs.nim.c -o c_code/2_18/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypes.nim.c -o c_code/2_18/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mnimsets.nim.c -o c_code/3_18/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcgendata.nim.c -o c_code/2_18/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmangleutils.nim.c -o c_code/2_18/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mccgutils.nim.c -o c_code/2_18/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtreetab.nim.c -o c_code/2_18/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msaturate.nim.c -o c_code/2_18/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mguards.nim.c -o c_code/2_18/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemfold.nim.c -o c_code/2_18/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mvmdef.nim.c -o c_code/3_18/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlayeredtable.nim.c -o c_code/2_18/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlowerings.nim.c -o c_code/2_18/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mparampatterns.nim.c -o c_code/2_18/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemdata.nim.c -o c_code/2_18/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypeallowed.nim.c -o c_code/2_18/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@misolation_check.nim.c -o c_code/2_18/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvarpartitions.nim.c -o c_code/2_18/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mnilcheck.nim.c -o c_code/2_18/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@merrorhandling.nim.c -o c_code/2_18/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@maliasanalysis.nim.c -o c_code/2_18/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemstrictfuncs.nim.c -o c_code/2_18/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pstd@seditdistance.nim.c -o c_code/2_18/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pheapqueue.nim.c -o c_code/2_18/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlookups.nim.c -o c_code/2_18/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlinter.nim.c -o c_code/2_18/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemtypinst.nim.c -o c_code/2_18/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mconcepts.nim.c -o c_code/2_18/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@msigmatch.nim.c -o c_code/3_18/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mpragmas.nim.c -o c_code/3_18/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpushpoppragmas.nim.c -o c_code/2_18/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msighashes.nim.c -o c_code/2_18/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mliftdestructors.nim.c -o c_code/2_18/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msempass2.nim.c -o c_code/2_18/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcgmeth.nim.c -o c_code/2_18/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@maliases.nim.c -o c_code/2_18/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mliftlocals.nim.c -o c_code/2_18/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mlambdalifting.nim.c -o c_code/2_18/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mclosureiters.nim.c -o c_code/2_18/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtransf.nim.c -o c_code/2_18/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@moptimizer.nim.c -o c_code/2_18/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdfa.nim.c -o c_code/2_18/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@minjectdestructors.nim.c -o c_code/2_18/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mexpanddefaults.nim.c -o c_code/2_18/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpipelineutils.nim.c -o c_code/2_18/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mspawn.nim.c -o c_code/2_18/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemparallel.nim.c -o c_code/2_18/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pdynlib.nim.c -o c_code/2_18/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mcgen.nim.c -o c_code/3_18/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmodules.nim.c -o c_code/2_18/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msemmacrosanity.nim.c -o c_code/2_18/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmgen.nim.c -o c_code/2_18/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mvmdeps.nim.c -o c_code/3_18/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mgorgeimpl.nim.c -o c_code/3_18/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mmacrocacheimpl.nim.c -o c_code/2_18/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mvmprofiler.nim.c -o c_code/3_18/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mevaltempl.nim.c -o c_code/2_18/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mvmconv.nim.c -o c_code/3_18/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvmmarshal.nim.c -o c_code/2_18/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mvm.nim.c -o c_code/3_18/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mimporter.nim.c -o c_code/2_18/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mprocfind.nim.c -o c_code/2_18/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpatterns.nim.c -o c_code/2_18/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mpluginsupport.nim.c -o c_code/2_18/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@slocals.nim.c -o c_code/2_18/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@sitersgen.nim.c -o c_code/2_18/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mplugins@sactive.nim.c -o c_code/2_18/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@menumtostr.nim.c -o c_code/2_18/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mvtables.nim.c -o c_code/2_18/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@msem.nim.c -o c_code/3_18/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mreorder.nim.c -o c_code/2_18/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mdepends.nim.c -o c_code/3_18/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@msourcemap.nim.c -o c_code/2_18/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mjsgen.nim.c -o c_code/3_18/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@plists.nim.c -o c_code/2_18/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@srstast.nim.c -o c_code/2_18/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/3_18/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ppackages@sdocutils@srstidx.nim.c -o c_code/3_18/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@ppackages@sdocutils@shighlite.nim.c -o c_code/2_18/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ppackages@sdocutils@srst.nim.c -o c_code/3_18/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@ppackages@sdocutils@srstgen.nim.c -o c_code/3_18/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mtypesrenderer.nim.c -o c_code/2_18/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mrenderverbatim.nim.c -o c_code/2_18/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@pxmltree.nim.c -o c_code/2_18/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@puri.nim.c -o c_code/2_18/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mdocgen.nim.c -o c_code/3_18/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mdocgen2.nim.c -o c_code/2_18/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mic@sreplayer.nim.c -o c_code/3_18/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mpipelines.nim.c -o c_code/3_18/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mscriptconfig.nim.c -o c_code/3_18/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mnimconf.nim.c -o c_code/3_18/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sdce.nim.c -o c_code/2_18/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@scbackend.nim.c -o c_code/2_18/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@sintegrity.nim.c -o c_code/2_18/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mic@snavigator.nim.c -o c_code/2_18/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mmain.nim.c -o c_code/3_18/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_18/@mcmdlinehelper.nim.c -o c_code/2_18/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@pbrowsers.nim.c -o c_code/3_18/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_18/@mnim.nim.c -o c_code/3_18/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/2_18/@psystem@sexceptions.nim.o \
c_code/2_18/@pstd@sprivate@sdigitsutils.nim.o \
c_code/2_18/@pstd@sassertions.nim.o \
c_code/2_18/@psystem@siterators.nim.o \
c_code/3_18/@psystem@sdollars.nim.o \
c_code/2_18/@pstd@sprivate@sdragonbox.nim.o \
c_code/2_18/@pstd@sprivate@sschubfach.nim.o \
c_code/2_18/@pstd@sformatfloat.nim.o \
c_code/3_18/@psystem.nim.o \
c_code/2_18/@pparseutils.nim.o \
c_code/3_18/@pmath.nim.o \
c_code/3_18/@palgorithm.nim.o \
c_code/2_18/@pstd@senumutils.nim.o \
c_code/2_18/@punicode.nim.o \
c_code/3_18/@pstrutils.nim.o \
c_code/2_18/@ppathnorm.nim.o \
c_code/2_18/@pstd@soserrors.nim.o \
c_code/3_18/@pstd@ssyncio.nim.o \
c_code/3_18/@pposix.nim.o \
c_code/2_18/@pstd@sprivate@soscommon.nim.o \
c_code/3_18/@pstd@sprivate@sospaths2.nim.o \
c_code/2_18/@pstd@sprivate@sossymlinks.nim.o \
c_code/3_18/@ptimes.nim.o \
c_code/3_18/@pstd@sprivate@sosfiles.nim.o \
c_code/2_18/@pstd@sprivate@sosdirs.nim.o \
c_code/3_18/@pstd@senvvars.nim.o \
c_code/2_18/@pstd@sprivate@sosappdirs.nim.o \
c_code/2_18/@pstd@scmdline.nim.o \
c_code/3_18/@pos.nim.o \
c_code/3_18/@pparseopt.nim.o \
c_code/2_18/@psequtils.nim.o \
c_code/3_18/@phashes.nim.o \
c_code/2_18/@pstrtabs.nim.o \
c_code/3_18/@ptables.nim.o \
c_code/2_18/@pstrformat.nim.o \
c_code/3_18/@pterminal.nim.o \
c_code/3_18/@mpathutils.nim.o \
c_code/3_18/@mropes.nim.o \
c_code/2_18/@mlineinfos.nim.o \
c_code/3_18/@mplatform.nim.o \
c_code/2_18/@mprefixmatches.nim.o \
c_code/2_18/@mnimpaths.nim.o \
c_code/2_18/@psets.nim.o \
c_code/2_18/@pstd@sobjectdollar.nim.o \
c_code/2_18/@pstd@sprivate@sglobs.nim.o \
c_code/3_18/@moptions.nim.o \
c_code/3_18/@mmsgs.nim.o \
c_code/2_18/@mcondsyms.nim.o \
c_code/2_18/@mwordrecg.nim.o \
c_code/2_18/@midents.nim.o \
c_code/2_18/@mint128.nim.o \
c_code/2_18/@mnodekinds.nim.o \
c_code/2_18/@mast.nim.o \
c_code/3_18/@mllstream.nim.o \
c_code/2_18/@mnimlexbase.nim.o \
c_code/3_18/@mlexer.nim.o \
c_code/3_18/@mrenderer.nim.o \
c_code/3_18/@mmodulepaths.nim.o \
c_code/3_18/@pstreams.nim.o \
c_code/3_18/@pcpuinfo.nim.o \
c_code/3_18/@pdeques.nim.o \
c_code/3_18/@posproc.nim.o \
c_code/2_18/@plexbase.nim.o \
c_code/2_18/@pparsejson.nim.o \
c_code/3_18/@pjson.nim.o \
c_code/3_18/@pstd@sjsonutils.nim.o \
c_code/3_18/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/3_18/@mextccomp.nim.o \
c_code/3_18/@mnimblecmd.nim.o \
c_code/3_18/@mcommands.nim.o \
c_code/2_18/@mparser.nim.o \
c_code/2_18/@mfilters.nim.o \
c_code/2_18/@mfilter_tmpl.nim.o \
c_code/3_18/@msyntaxes.nim.o \
c_code/2_18/@mrodutils.nim.o \
c_code/2_18/@pstd@spackedsets.nim.o \
c_code/2_18/@mastyaml.nim.o \
c_code/2_18/@mastalgo.nim.o \
c_code/2_18/@mtrees.nim.o \
c_code/2_18/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/3_18/@mbtrees.nim.o \
c_code/2_18/@mpackages.nim.o \
c_code/2_18/@msuggestsymdb.nim.o \
c_code/3_18/@mic@srodfiles.nim.o \
c_code/2_18/@mic@sbitabs.nim.o \
c_code/2_18/@mic@siclineinfos.nim.o \
c_code/2_18/@mic@spacked_ast.nim.o \
c_code/2_18/@mic@sic.nim.o \
c_code/2_18/@mmodulegraphs.nim.o \
c_code/2_18/@mmagicsys.nim.o \
c_code/2_18/@mbitsets.nim.o \
c_code/2_18/@mastmsgs.nim.o \
c_code/2_18/@mtypes.nim.o \
c_code/3_18/@mnimsets.nim.o \
c_code/2_18/@mcgendata.nim.o \
c_code/2_18/@mmangleutils.nim.o \
c_code/2_18/@mccgutils.nim.o \
c_code/2_18/@mtreetab.nim.o \
c_code/2_18/@msaturate.nim.o \
c_code/2_18/@mguards.nim.o \
c_code/2_18/@msemfold.nim.o \
c_code/3_18/@mvmdef.nim.o \
c_code/2_18/@mlayeredtable.nim.o \
c_code/2_18/@mlowerings.nim.o \
c_code/2_18/@mparampatterns.nim.o \
c_code/2_18/@msemdata.nim.o \
c_code/2_18/@mtypeallowed.nim.o \
c_code/2_18/@misolation_check.nim.o \
c_code/2_18/@mvarpartitions.nim.o \
c_code/2_18/@mnilcheck.nim.o \
c_code/2_18/@merrorhandling.nim.o \
c_code/2_18/@maliasanalysis.nim.o \
c_code/2_18/@msemstrictfuncs.nim.o \
c_code/2_18/@pstd@seditdistance.nim.o \
c_code/2_18/@pheapqueue.nim.o \
c_code/2_18/@mlookups.nim.o \
c_code/2_18/@mlinter.nim.o \
c_code/2_18/@msemtypinst.nim.o \
c_code/2_18/@mconcepts.nim.o \
c_code/3_18/@msigmatch.nim.o \
c_code/3_18/@mpragmas.nim.o \
c_code/2_18/@mpushpoppragmas.nim.o \
c_code/2_18/@msighashes.nim.o \
c_code/2_18/@mliftdestructors.nim.o \
c_code/2_18/@msempass2.nim.o \
c_code/2_18/@mcgmeth.nim.o \
c_code/2_18/@maliases.nim.o \
c_code/2_18/@mliftlocals.nim.o \
c_code/2_18/@mlambdalifting.nim.o \
c_code/2_18/@mclosureiters.nim.o \
c_code/2_18/@mtransf.nim.o \
c_code/2_18/@moptimizer.nim.o \
c_code/2_18/@mdfa.nim.o \
c_code/2_18/@minjectdestructors.nim.o \
c_code/2_18/@mexpanddefaults.nim.o \
c_code/2_18/@mpipelineutils.nim.o \
c_code/2_18/@mspawn.nim.o \
c_code/2_18/@msemparallel.nim.o \
c_code/2_18/@pdynlib.nim.o \
c_code/3_18/@mcgen.nim.o \
c_code/2_18/@mmodules.nim.o \
c_code/2_18/@msemmacrosanity.nim.o \
c_code/2_18/@mvmgen.nim.o \
c_code/3_18/@mvmdeps.nim.o \
c_code/3_18/@mgorgeimpl.nim.o \
c_code/2_18/@mmacrocacheimpl.nim.o \
c_code/3_18/@mvmprofiler.nim.o \
c_code/2_18/@mevaltempl.nim.o \
c_code/3_18/@mvmconv.nim.o \
c_code/2_18/@mvmmarshal.nim.o \
c_code/3_18/@mvm.nim.o \
c_code/2_18/@mimporter.nim.o \
c_code/2_18/@mprocfind.nim.o \
c_code/2_18/@mpatterns.nim.o \
c_code/2_18/@mpluginsupport.nim.o \
c_code/2_18/@mplugins@slocals.nim.o \
c_code/2_18/@mplugins@sitersgen.nim.o \
c_code/2_18/@mplugins@sactive.nim.o \
c_code/2_18/@menumtostr.nim.o \
c_code/2_18/@mvtables.nim.o \
c_code/3_18/@msem.nim.o \
c_code/2_18/@mreorder.nim.o \
c_code/3_18/@mdepends.nim.o \
c_code/2_18/@msourcemap.nim.o \
c_code/3_18/@mjsgen.nim.o \
c_code/2_18/@plists.nim.o \
c_code/2_18/@ppackages@sdocutils@srstast.nim.o \
c_code/3_18/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/3_18/@ppackages@sdocutils@srstidx.nim.o \
c_code/2_18/@ppackages@sdocutils@shighlite.nim.o \
c_code/3_18/@ppackages@sdocutils@srst.nim.o \
c_code/3_18/@ppackages@sdocutils@srstgen.nim.o \
c_code/2_18/@mtypesrenderer.nim.o \
c_code/2_18/@mrenderverbatim.nim.o \
c_code/2_18/@pxmltree.nim.o \
c_code/2_18/@puri.nim.o \
c_code/3_18/@mdocgen.nim.o \
c_code/2_18/@mdocgen2.nim.o \
c_code/3_18/@mic@sreplayer.nim.o \
c_code/3_18/@mpipelines.nim.o \
c_code/3_18/@mscriptconfig.nim.o \
c_code/3_18/@mnimconf.nim.o \
c_code/2_18/@mic@sdce.nim.o \
c_code/2_18/@mic@scbackend.nim.o \
c_code/2_18/@mic@sintegrity.nim.o \
c_code/2_18/@mic@snavigator.nim.o \
c_code/3_18/@mmain.nim.o \
c_code/2_18/@mcmdlinehelper.nim.o \
c_code/3_18/@pbrowsers.nim.o \
c_code/3_18/@mnim.nim.o $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
solaris)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psystem@sexceptions.nim.c -o c_code/4_1/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sassertions.nim.c -o c_code/4_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psystem@sdollars.nim.c -o c_code/4_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sformatfloat.nim.c -o c_code/4_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psystem.nim.c -o c_code/4_1/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pparseutils.nim.c -o c_code/4_1/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pmath.nim.c -o c_code/4_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@palgorithm.nim.c -o c_code/4_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@punicode.nim.c -o c_code/4_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstrutils.nim.c -o c_code/4_1/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppathnorm.nim.c -o c_code/4_1/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@soserrors.nim.c -o c_code/4_1/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@ssyncio.nim.c -o c_code/4_1/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pposix.nim.c -o c_code/4_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@soscommon.nim.c -o c_code/4_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sospaths2.nim.c -o c_code/4_1/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/4_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ptimes.nim.c -o c_code/4_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sosfiles.nim.c -o c_code/4_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sosdirs.nim.c -o c_code/4_1/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@senvvars.nim.c -o c_code/4_1/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/4_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@scmdline.nim.c -o c_code/4_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pos.nim.c -o c_code/4_1/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pparseopt.nim.c -o c_code/4_1/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@phashes.nim.c -o c_code/4_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstrtabs.nim.c -o c_code/4_1/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ptables.nim.c -o c_code/4_1/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstrformat.nim.c -o c_code/4_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pterminal.nim.c -o c_code/4_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpathutils.nim.c -o c_code/4_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mropes.nim.c -o c_code/4_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlineinfos.nim.c -o c_code/4_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplatform.nim.c -o c_code/4_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprefixmatches.nim.c -o c_code/4_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimpaths.nim.c -o c_code/4_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psets.nim.c -o c_code/4_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptions.nim.c -o c_code/4_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmsgs.nim.c -o c_code/4_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcondsyms.nim.c -o c_code/4_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mwordrecg.nim.c -o c_code/4_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@midents.nim.c -o c_code/4_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mint128.nim.c -o c_code/4_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mast.nim.c -o c_code/4_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mllstream.nim.c -o c_code/4_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimlexbase.nim.c -o c_code/4_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlexer.nim.c -o c_code/4_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrenderer.nim.c -o c_code/4_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulepaths.nim.c -o c_code/4_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstreams.nim.c -o c_code/4_1/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pcpuinfo.nim.c -o c_code/4_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@smonotimes.nim.c -o c_code/4_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@posproc.nim.c -o c_code/4_1/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@plexbase.nim.c -o c_code/4_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pparsejson.nim.c -o c_code/4_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pjson.nim.c -o c_code/4_1/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sjsonutils.nim.c -o c_code/4_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mextccomp.nim.c -o c_code/4_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimblecmd.nim.c -o c_code/4_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcommands.nim.c -o c_code/4_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparser.nim.c -o c_code/4_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilters.nim.c -o c_code/4_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilter_tmpl.nim.c -o c_code/4_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msyntaxes.nim.c -o c_code/4_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrodutils.nim.c -o c_code/4_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@spackedsets.nim.c -o c_code/4_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastyaml.nim.c -o c_code/4_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastalgo.nim.c -o c_code/4_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtrees.nim.c -o c_code/4_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mbtrees.nim.c -o c_code/4_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpackages.nim.c -o c_code/4_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msuggestsymdb.nim.c -o c_code/4_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@srodfiles.nim.c -o c_code/4_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sbitabs.nim.c -o c_code/4_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@siclineinfos.nim.c -o c_code/4_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@spacked_ast.nim.c -o c_code/4_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sic.nim.c -o c_code/4_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulegraphs.nim.c -o c_code/4_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmagicsys.nim.c -o c_code/4_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastmsgs.nim.c -o c_code/4_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypes.nim.c -o c_code/4_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimsets.nim.c -o c_code/4_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgendata.nim.c -o c_code/4_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmangleutils.nim.c -o c_code/4_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mccgutils.nim.c -o c_code/4_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtreetab.nim.c -o c_code/4_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mguards.nim.c -o c_code/4_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemfold.nim.c -o c_code/4_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdef.nim.c -o c_code/4_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlayeredtable.nim.c -o c_code/4_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlowerings.nim.c -o c_code/4_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparampatterns.nim.c -o c_code/4_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemdata.nim.c -o c_code/4_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypeallowed.nim.c -o c_code/4_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@misolation_check.nim.c -o c_code/4_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvarpartitions.nim.c -o c_code/4_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnilcheck.nim.c -o c_code/4_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@merrorhandling.nim.c -o c_code/4_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliasanalysis.nim.c -o c_code/4_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemstrictfuncs.nim.c -o c_code/4_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@seditdistance.nim.c -o c_code/4_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pheapqueue.nim.c -o c_code/4_1/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlookups.nim.c -o c_code/4_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlinter.nim.c -o c_code/4_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemtypinst.nim.c -o c_code/4_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mconcepts.nim.c -o c_code/4_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msigmatch.nim.c -o c_code/4_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpragmas.nim.c -o c_code/4_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpushpoppragmas.nim.c -o c_code/4_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msighashes.nim.c -o c_code/4_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mliftdestructors.nim.c -o c_code/4_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msempass2.nim.c -o c_code/4_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgmeth.nim.c -o c_code/4_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliases.nim.c -o c_code/4_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mliftlocals.nim.c -o c_code/4_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlambdalifting.nim.c -o c_code/4_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mclosureiters.nim.c -o c_code/4_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtransf.nim.c -o c_code/4_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@moptimizer.nim.c -o c_code/4_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdfa.nim.c -o c_code/4_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@minjectdestructors.nim.c -o c_code/4_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mexpanddefaults.nim.c -o c_code/4_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelineutils.nim.c -o c_code/4_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mspawn.nim.c -o c_code/4_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemparallel.nim.c -o c_code/4_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pdynlib.nim.c -o c_code/4_1/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgen.nim.c -o c_code/4_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodules.nim.c -o c_code/4_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemmacrosanity.nim.c -o c_code/4_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmgen.nim.c -o c_code/4_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdeps.nim.c -o c_code/4_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mgorgeimpl.nim.c -o c_code/4_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmacrocacheimpl.nim.c -o c_code/4_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmprofiler.nim.c -o c_code/4_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mevaltempl.nim.c -o c_code/4_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmconv.nim.c -o c_code/4_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmmarshal.nim.c -o c_code/4_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvm.nim.c -o c_code/4_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mimporter.nim.c -o c_code/4_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprocfind.nim.c -o c_code/4_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpatterns.nim.c -o c_code/4_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpluginsupport.nim.c -o c_code/4_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@slocals.nim.c -o c_code/4_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sitersgen.nim.c -o c_code/4_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sactive.nim.c -o c_code/4_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@menumtostr.nim.c -o c_code/4_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvtables.nim.c -o c_code/4_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msem.nim.c -o c_code/4_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mreorder.nim.c -o c_code/4_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdepends.nim.c -o c_code/4_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msourcemap.nim.c -o c_code/4_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mjsgen.nim.c -o c_code/4_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@plists.nim.c -o c_code/4_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srstast.nim.c -o c_code/4_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/4_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/4_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srst.nim.c -o c_code/4_1/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srstgen.nim.c -o c_code/4_1/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypesrenderer.nim.c -o c_code/4_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrenderverbatim.nim.c -o c_code/4_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pxmltree.nim.c -o c_code/4_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@puri.nim.c -o c_code/4_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdocgen.nim.c -o c_code/4_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mdocgen2.nim.c -o c_code/4_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sreplayer.nim.c -o c_code/4_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelines.nim.c -o c_code/4_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mscriptconfig.nim.c -o c_code/4_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimconf.nim.c -o c_code/4_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sdce.nim.c -o c_code/4_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@scbackend.nim.c -o c_code/4_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sintegrity.nim.c -o c_code/4_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@snavigator.nim.c -o c_code/4_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmain.nim.c -o c_code/4_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcmdlinehelper.nim.c -o c_code/4_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pbrowsers.nim.c -o c_code/4_1/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnim.nim.c -o c_code/4_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_1/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/4_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/4_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/4_1/@pstd@sformatfloat.nim.o \
c_code/4_1/@psystem.nim.o \
c_code/4_1/@pparseutils.nim.o \
c_code/4_1/@pmath.nim.o \
c_code/4_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/4_1/@punicode.nim.o \
c_code/4_1/@pstrutils.nim.o \
c_code/4_1/@ppathnorm.nim.o \
c_code/4_1/@pstd@soserrors.nim.o \
c_code/4_1/@pstd@ssyncio.nim.o \
c_code/4_1/@pposix.nim.o \
c_code/4_1/@pstd@sprivate@soscommon.nim.o \
c_code/4_1/@pstd@sprivate@sospaths2.nim.o \
c_code/4_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/4_1/@ptimes.nim.o \
c_code/4_1/@pstd@sprivate@sosfiles.nim.o \
c_code/4_1/@pstd@sprivate@sosdirs.nim.o \
c_code/4_1/@pstd@senvvars.nim.o \
c_code/4_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/4_1/@pstd@scmdline.nim.o \
c_code/4_1/@pos.nim.o \
c_code/4_1/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/4_1/@phashes.nim.o \
c_code/4_1/@pstrtabs.nim.o \
c_code/4_1/@ptables.nim.o \
c_code/4_1/@pstrformat.nim.o \
c_code/4_1/@pterminal.nim.o \
c_code/4_1/@mpathutils.nim.o \
c_code/4_1/@mropes.nim.o \
c_code/4_1/@mlineinfos.nim.o \
c_code/4_1/@mplatform.nim.o \
c_code/4_1/@mprefixmatches.nim.o \
c_code/4_1/@mnimpaths.nim.o \
c_code/4_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/4_1/@moptions.nim.o \
c_code/4_1/@mmsgs.nim.o \
c_code/4_1/@mcondsyms.nim.o \
c_code/4_1/@mwordrecg.nim.o \
c_code/4_1/@midents.nim.o \
c_code/4_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/4_1/@mast.nim.o \
c_code/4_1/@mllstream.nim.o \
c_code/4_1/@mnimlexbase.nim.o \
c_code/4_1/@mlexer.nim.o \
c_code/4_1/@mrenderer.nim.o \
c_code/4_1/@mmodulepaths.nim.o \
c_code/4_1/@pstreams.nim.o \
c_code/4_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/4_1/@pstd@smonotimes.nim.o \
c_code/4_1/@posproc.nim.o \
c_code/4_1/@plexbase.nim.o \
c_code/4_1/@pparsejson.nim.o \
c_code/4_1/@pjson.nim.o \
c_code/4_1/@pstd@sjsonutils.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_1/@mextccomp.nim.o \
c_code/4_1/@mnimblecmd.nim.o \
c_code/4_1/@mcommands.nim.o \
c_code/4_1/@mparser.nim.o \
c_code/4_1/@mfilters.nim.o \
c_code/4_1/@mfilter_tmpl.nim.o \
c_code/4_1/@msyntaxes.nim.o \
c_code/4_1/@mrodutils.nim.o \
c_code/4_1/@pstd@spackedsets.nim.o \
c_code/4_1/@mastyaml.nim.o \
c_code/4_1/@mastalgo.nim.o \
c_code/4_1/@mtrees.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_1/@mbtrees.nim.o \
c_code/4_1/@mpackages.nim.o \
c_code/4_1/@msuggestsymdb.nim.o \
c_code/4_1/@mic@srodfiles.nim.o \
c_code/4_1/@mic@sbitabs.nim.o \
c_code/4_1/@mic@siclineinfos.nim.o \
c_code/4_1/@mic@spacked_ast.nim.o \
c_code/4_1/@mic@sic.nim.o \
c_code/4_1/@mmodulegraphs.nim.o \
c_code/4_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/4_1/@mastmsgs.nim.o \
c_code/4_1/@mtypes.nim.o \
c_code/4_1/@mnimsets.nim.o \
c_code/4_1/@mcgendata.nim.o \
c_code/4_1/@mmangleutils.nim.o \
c_code/4_1/@mccgutils.nim.o \
c_code/4_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/4_1/@mguards.nim.o \
c_code/4_1/@msemfold.nim.o \
c_code/4_1/@mvmdef.nim.o \
c_code/4_1/@mlayeredtable.nim.o \
c_code/4_1/@mlowerings.nim.o \
c_code/4_1/@mparampatterns.nim.o \
c_code/4_1/@msemdata.nim.o \
c_code/4_1/@mtypeallowed.nim.o \
c_code/4_1/@misolation_check.nim.o \
c_code/4_1/@mvarpartitions.nim.o \
c_code/4_1/@mnilcheck.nim.o \
c_code/4_1/@merrorhandling.nim.o \
c_code/4_1/@maliasanalysis.nim.o \
c_code/4_1/@msemstrictfuncs.nim.o \
c_code/4_1/@pstd@seditdistance.nim.o \
c_code/4_1/@pheapqueue.nim.o \
c_code/4_1/@mlookups.nim.o \
c_code/4_1/@mlinter.nim.o \
c_code/4_1/@msemtypinst.nim.o \
c_code/4_1/@mconcepts.nim.o \
c_code/4_1/@msigmatch.nim.o \
c_code/4_1/@mpragmas.nim.o \
c_code/4_1/@mpushpoppragmas.nim.o \
c_code/4_1/@msighashes.nim.o \
c_code/4_1/@mliftdestructors.nim.o \
c_code/4_1/@msempass2.nim.o \
c_code/4_1/@mcgmeth.nim.o \
c_code/4_1/@maliases.nim.o \
c_code/4_1/@mliftlocals.nim.o \
c_code/4_1/@mlambdalifting.nim.o \
c_code/4_1/@mclosureiters.nim.o \
c_code/4_1/@mtransf.nim.o \
c_code/4_1/@moptimizer.nim.o \
c_code/4_1/@mdfa.nim.o \
c_code/4_1/@minjectdestructors.nim.o \
c_code/4_1/@mexpanddefaults.nim.o \
c_code/4_1/@mpipelineutils.nim.o \
c_code/4_1/@mspawn.nim.o \
c_code/4_1/@msemparallel.nim.o \
c_code/4_1/@pdynlib.nim.o \
c_code/4_1/@mcgen.nim.o \
c_code/4_1/@mmodules.nim.o \
c_code/4_1/@msemmacrosanity.nim.o \
c_code/4_1/@mvmgen.nim.o \
c_code/4_1/@mvmdeps.nim.o \
c_code/4_1/@mgorgeimpl.nim.o \
c_code/4_1/@mmacrocacheimpl.nim.o \
c_code/4_1/@mvmprofiler.nim.o \
c_code/4_1/@mevaltempl.nim.o \
c_code/4_1/@mvmconv.nim.o \
c_code/4_1/@mvmmarshal.nim.o \
c_code/4_1/@mvm.nim.o \
c_code/4_1/@mimporter.nim.o \
c_code/4_1/@mprocfind.nim.o \
c_code/4_1/@mpatterns.nim.o \
c_code/4_1/@mpluginsupport.nim.o \
c_code/4_1/@mplugins@slocals.nim.o \
c_code/4_1/@mplugins@sitersgen.nim.o \
c_code/4_1/@mplugins@sactive.nim.o \
c_code/4_1/@menumtostr.nim.o \
c_code/4_1/@mvtables.nim.o \
c_code/4_1/@msem.nim.o \
c_code/4_1/@mreorder.nim.o \
c_code/4_1/@mdepends.nim.o \
c_code/4_1/@msourcemap.nim.o \
c_code/4_1/@mjsgen.nim.o \
c_code/4_1/@plists.nim.o \
c_code/4_1/@ppackages@sdocutils@srstast.nim.o \
c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/4_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/4_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/4_1/@ppackages@sdocutils@srst.nim.o \
c_code/4_1/@ppackages@sdocutils@srstgen.nim.o \
c_code/4_1/@mtypesrenderer.nim.o \
c_code/4_1/@mrenderverbatim.nim.o \
c_code/4_1/@pxmltree.nim.o \
c_code/4_1/@puri.nim.o \
c_code/4_1/@mdocgen.nim.o \
c_code/4_1/@mdocgen2.nim.o \
c_code/4_1/@mic@sreplayer.nim.o \
c_code/4_1/@mpipelines.nim.o \
c_code/4_1/@mscriptconfig.nim.o \
c_code/4_1/@mnimconf.nim.o \
c_code/4_1/@mic@sdce.nim.o \
c_code/4_1/@mic@scbackend.nim.o \
c_code/4_1/@mic@sintegrity.nim.o \
c_code/4_1/@mic@snavigator.nim.o \
c_code/4_1/@mmain.nim.o \
c_code/4_1/@mcmdlinehelper.nim.o \
c_code/4_1/@pbrowsers.nim.o \
c_code/4_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psystem@sexceptions.nim.c -o c_code/4_2/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sassertions.nim.c -o c_code/4_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psystem@sdollars.nim.c -o c_code/4_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sformatfloat.nim.c -o c_code/4_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psystem.nim.c -o c_code/4_2/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pparseutils.nim.c -o c_code/4_2/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pmath.nim.c -o c_code/4_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@palgorithm.nim.c -o c_code/4_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@punicode.nim.c -o c_code/4_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstrutils.nim.c -o c_code/4_2/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppathnorm.nim.c -o c_code/4_2/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@soserrors.nim.c -o c_code/4_2/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@ssyncio.nim.c -o c_code/4_2/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pposix.nim.c -o c_code/4_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@soscommon.nim.c -o c_code/4_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sospaths2.nim.c -o c_code/4_2/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/4_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ptimes.nim.c -o c_code/4_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sosfiles.nim.c -o c_code/4_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sosdirs.nim.c -o c_code/4_2/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@senvvars.nim.c -o c_code/4_2/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/4_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@scmdline.nim.c -o c_code/4_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pos.nim.c -o c_code/4_2/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pparseopt.nim.c -o c_code/4_2/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@phashes.nim.c -o c_code/4_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstrtabs.nim.c -o c_code/4_2/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ptables.nim.c -o c_code/4_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstrformat.nim.c -o c_code/4_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pterminal.nim.c -o c_code/4_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpathutils.nim.c -o c_code/4_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mropes.nim.c -o c_code/4_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlineinfos.nim.c -o c_code/4_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplatform.nim.c -o c_code/4_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprefixmatches.nim.c -o c_code/4_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimpaths.nim.c -o c_code/4_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psets.nim.c -o c_code/4_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptions.nim.c -o c_code/4_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmsgs.nim.c -o c_code/4_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcondsyms.nim.c -o c_code/4_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mwordrecg.nim.c -o c_code/4_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@midents.nim.c -o c_code/4_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mint128.nim.c -o c_code/4_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mast.nim.c -o c_code/4_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mllstream.nim.c -o c_code/4_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimlexbase.nim.c -o c_code/4_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlexer.nim.c -o c_code/4_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderer.nim.c -o c_code/4_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulepaths.nim.c -o c_code/4_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstreams.nim.c -o c_code/4_2/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pcpuinfo.nim.c -o c_code/4_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@smonotimes.nim.c -o c_code/4_2/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@posproc.nim.c -o c_code/4_2/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@plexbase.nim.c -o c_code/4_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pparsejson.nim.c -o c_code/4_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pjson.nim.c -o c_code/4_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sjsonutils.nim.c -o c_code/4_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mextccomp.nim.c -o c_code/4_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimblecmd.nim.c -o c_code/4_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcommands.nim.c -o c_code/4_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparser.nim.c -o c_code/4_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilters.nim.c -o c_code/4_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilter_tmpl.nim.c -o c_code/4_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msyntaxes.nim.c -o c_code/4_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrodutils.nim.c -o c_code/4_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@spackedsets.nim.c -o c_code/4_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastyaml.nim.c -o c_code/4_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastalgo.nim.c -o c_code/4_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtrees.nim.c -o c_code/4_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mbtrees.nim.c -o c_code/4_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpackages.nim.c -o c_code/4_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msuggestsymdb.nim.c -o c_code/4_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@srodfiles.nim.c -o c_code/4_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sbitabs.nim.c -o c_code/4_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@siclineinfos.nim.c -o c_code/4_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@spacked_ast.nim.c -o c_code/4_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sic.nim.c -o c_code/4_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulegraphs.nim.c -o c_code/4_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmagicsys.nim.c -o c_code/4_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastmsgs.nim.c -o c_code/4_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypes.nim.c -o c_code/4_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimsets.nim.c -o c_code/4_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgendata.nim.c -o c_code/4_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmangleutils.nim.c -o c_code/4_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mccgutils.nim.c -o c_code/4_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtreetab.nim.c -o c_code/4_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mguards.nim.c -o c_code/4_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemfold.nim.c -o c_code/4_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdef.nim.c -o c_code/4_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlayeredtable.nim.c -o c_code/4_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlowerings.nim.c -o c_code/4_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparampatterns.nim.c -o c_code/4_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemdata.nim.c -o c_code/4_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypeallowed.nim.c -o c_code/4_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@misolation_check.nim.c -o c_code/4_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvarpartitions.nim.c -o c_code/4_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnilcheck.nim.c -o c_code/4_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@merrorhandling.nim.c -o c_code/4_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliasanalysis.nim.c -o c_code/4_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemstrictfuncs.nim.c -o c_code/4_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@seditdistance.nim.c -o c_code/4_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pheapqueue.nim.c -o c_code/4_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlookups.nim.c -o c_code/4_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlinter.nim.c -o c_code/4_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemtypinst.nim.c -o c_code/4_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mconcepts.nim.c -o c_code/4_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msigmatch.nim.c -o c_code/4_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpragmas.nim.c -o c_code/4_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpushpoppragmas.nim.c -o c_code/4_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msighashes.nim.c -o c_code/4_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftdestructors.nim.c -o c_code/4_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msempass2.nim.c -o c_code/4_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgmeth.nim.c -o c_code/4_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliases.nim.c -o c_code/4_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftlocals.nim.c -o c_code/4_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlambdalifting.nim.c -o c_code/4_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mclosureiters.nim.c -o c_code/4_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtransf.nim.c -o c_code/4_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptimizer.nim.c -o c_code/4_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdfa.nim.c -o c_code/4_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@minjectdestructors.nim.c -o c_code/4_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mexpanddefaults.nim.c -o c_code/4_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelineutils.nim.c -o c_code/4_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mspawn.nim.c -o c_code/4_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemparallel.nim.c -o c_code/4_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pdynlib.nim.c -o c_code/4_2/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgen.nim.c -o c_code/4_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodules.nim.c -o c_code/4_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemmacrosanity.nim.c -o c_code/4_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmgen.nim.c -o c_code/4_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdeps.nim.c -o c_code/4_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mgorgeimpl.nim.c -o c_code/4_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmacrocacheimpl.nim.c -o c_code/4_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmprofiler.nim.c -o c_code/4_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mevaltempl.nim.c -o c_code/4_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmconv.nim.c -o c_code/4_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmmarshal.nim.c -o c_code/4_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvm.nim.c -o c_code/4_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mimporter.nim.c -o c_code/4_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprocfind.nim.c -o c_code/4_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpatterns.nim.c -o c_code/4_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpluginsupport.nim.c -o c_code/4_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@slocals.nim.c -o c_code/4_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sitersgen.nim.c -o c_code/4_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sactive.nim.c -o c_code/4_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@menumtostr.nim.c -o c_code/4_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvtables.nim.c -o c_code/4_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msem.nim.c -o c_code/4_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mreorder.nim.c -o c_code/4_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdepends.nim.c -o c_code/4_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msourcemap.nim.c -o c_code/4_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mjsgen.nim.c -o c_code/4_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@plists.nim.c -o c_code/4_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srstast.nim.c -o c_code/4_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/4_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/4_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srst.nim.c -o c_code/4_2/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srstgen.nim.c -o c_code/4_2/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypesrenderer.nim.c -o c_code/4_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderverbatim.nim.c -o c_code/4_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pxmltree.nim.c -o c_code/4_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@puri.nim.c -o c_code/4_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen.nim.c -o c_code/4_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen2.nim.c -o c_code/4_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sreplayer.nim.c -o c_code/4_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelines.nim.c -o c_code/4_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mscriptconfig.nim.c -o c_code/4_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimconf.nim.c -o c_code/4_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sdce.nim.c -o c_code/4_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@scbackend.nim.c -o c_code/4_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sintegrity.nim.c -o c_code/4_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@snavigator.nim.c -o c_code/4_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmain.nim.c -o c_code/4_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcmdlinehelper.nim.c -o c_code/4_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pbrowsers.nim.c -o c_code/4_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnim.nim.c -o c_code/4_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_2/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/4_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/4_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/4_2/@pstd@sformatfloat.nim.o \
c_code/4_2/@psystem.nim.o \
c_code/4_2/@pparseutils.nim.o \
c_code/4_2/@pmath.nim.o \
c_code/4_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/4_2/@punicode.nim.o \
c_code/4_2/@pstrutils.nim.o \
c_code/4_2/@ppathnorm.nim.o \
c_code/4_2/@pstd@soserrors.nim.o \
c_code/4_2/@pstd@ssyncio.nim.o \
c_code/4_2/@pposix.nim.o \
c_code/4_2/@pstd@sprivate@soscommon.nim.o \
c_code/4_2/@pstd@sprivate@sospaths2.nim.o \
c_code/4_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/4_2/@ptimes.nim.o \
c_code/4_2/@pstd@sprivate@sosfiles.nim.o \
c_code/4_2/@pstd@sprivate@sosdirs.nim.o \
c_code/4_2/@pstd@senvvars.nim.o \
c_code/4_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/4_2/@pstd@scmdline.nim.o \
c_code/4_2/@pos.nim.o \
c_code/4_2/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/4_2/@phashes.nim.o \
c_code/4_2/@pstrtabs.nim.o \
c_code/4_2/@ptables.nim.o \
c_code/4_2/@pstrformat.nim.o \
c_code/4_2/@pterminal.nim.o \
c_code/4_2/@mpathutils.nim.o \
c_code/4_2/@mropes.nim.o \
c_code/4_2/@mlineinfos.nim.o \
c_code/4_2/@mplatform.nim.o \
c_code/4_2/@mprefixmatches.nim.o \
c_code/4_2/@mnimpaths.nim.o \
c_code/4_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/4_2/@moptions.nim.o \
c_code/4_2/@mmsgs.nim.o \
c_code/4_2/@mcondsyms.nim.o \
c_code/4_2/@mwordrecg.nim.o \
c_code/4_2/@midents.nim.o \
c_code/4_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/4_2/@mast.nim.o \
c_code/4_2/@mllstream.nim.o \
c_code/4_2/@mnimlexbase.nim.o \
c_code/4_2/@mlexer.nim.o \
c_code/4_2/@mrenderer.nim.o \
c_code/4_2/@mmodulepaths.nim.o \
c_code/4_2/@pstreams.nim.o \
c_code/4_2/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/4_2/@pstd@smonotimes.nim.o \
c_code/4_2/@posproc.nim.o \
c_code/4_2/@plexbase.nim.o \
c_code/4_2/@pparsejson.nim.o \
c_code/4_2/@pjson.nim.o \
c_code/4_2/@pstd@sjsonutils.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_2/@mextccomp.nim.o \
c_code/4_2/@mnimblecmd.nim.o \
c_code/4_2/@mcommands.nim.o \
c_code/4_2/@mparser.nim.o \
c_code/4_2/@mfilters.nim.o \
c_code/4_2/@mfilter_tmpl.nim.o \
c_code/4_2/@msyntaxes.nim.o \
c_code/4_2/@mrodutils.nim.o \
c_code/4_2/@pstd@spackedsets.nim.o \
c_code/4_2/@mastyaml.nim.o \
c_code/4_2/@mastalgo.nim.o \
c_code/4_2/@mtrees.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_2/@mbtrees.nim.o \
c_code/4_2/@mpackages.nim.o \
c_code/4_2/@msuggestsymdb.nim.o \
c_code/4_2/@mic@srodfiles.nim.o \
c_code/4_2/@mic@sbitabs.nim.o \
c_code/4_2/@mic@siclineinfos.nim.o \
c_code/4_2/@mic@spacked_ast.nim.o \
c_code/4_2/@mic@sic.nim.o \
c_code/4_2/@mmodulegraphs.nim.o \
c_code/4_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/4_2/@mastmsgs.nim.o \
c_code/4_2/@mtypes.nim.o \
c_code/4_2/@mnimsets.nim.o \
c_code/4_2/@mcgendata.nim.o \
c_code/4_2/@mmangleutils.nim.o \
c_code/4_2/@mccgutils.nim.o \
c_code/4_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/4_2/@mguards.nim.o \
c_code/4_2/@msemfold.nim.o \
c_code/4_2/@mvmdef.nim.o \
c_code/4_2/@mlayeredtable.nim.o \
c_code/4_2/@mlowerings.nim.o \
c_code/4_2/@mparampatterns.nim.o \
c_code/4_2/@msemdata.nim.o \
c_code/4_2/@mtypeallowed.nim.o \
c_code/4_2/@misolation_check.nim.o \
c_code/4_2/@mvarpartitions.nim.o \
c_code/4_2/@mnilcheck.nim.o \
c_code/4_2/@merrorhandling.nim.o \
c_code/4_2/@maliasanalysis.nim.o \
c_code/4_2/@msemstrictfuncs.nim.o \
c_code/4_2/@pstd@seditdistance.nim.o \
c_code/4_2/@pheapqueue.nim.o \
c_code/4_2/@mlookups.nim.o \
c_code/4_2/@mlinter.nim.o \
c_code/4_2/@msemtypinst.nim.o \
c_code/4_2/@mconcepts.nim.o \
c_code/4_2/@msigmatch.nim.o \
c_code/4_2/@mpragmas.nim.o \
c_code/4_2/@mpushpoppragmas.nim.o \
c_code/4_2/@msighashes.nim.o \
c_code/4_2/@mliftdestructors.nim.o \
c_code/4_2/@msempass2.nim.o \
c_code/4_2/@mcgmeth.nim.o \
c_code/4_2/@maliases.nim.o \
c_code/4_2/@mliftlocals.nim.o \
c_code/4_2/@mlambdalifting.nim.o \
c_code/4_2/@mclosureiters.nim.o \
c_code/4_2/@mtransf.nim.o \
c_code/4_2/@moptimizer.nim.o \
c_code/4_2/@mdfa.nim.o \
c_code/4_2/@minjectdestructors.nim.o \
c_code/4_2/@mexpanddefaults.nim.o \
c_code/4_2/@mpipelineutils.nim.o \
c_code/4_2/@mspawn.nim.o \
c_code/4_2/@msemparallel.nim.o \
c_code/4_2/@pdynlib.nim.o \
c_code/4_2/@mcgen.nim.o \
c_code/4_2/@mmodules.nim.o \
c_code/4_2/@msemmacrosanity.nim.o \
c_code/4_2/@mvmgen.nim.o \
c_code/4_2/@mvmdeps.nim.o \
c_code/4_2/@mgorgeimpl.nim.o \
c_code/4_2/@mmacrocacheimpl.nim.o \
c_code/4_2/@mvmprofiler.nim.o \
c_code/4_2/@mevaltempl.nim.o \
c_code/4_2/@mvmconv.nim.o \
c_code/4_2/@mvmmarshal.nim.o \
c_code/4_2/@mvm.nim.o \
c_code/4_2/@mimporter.nim.o \
c_code/4_2/@mprocfind.nim.o \
c_code/4_2/@mpatterns.nim.o \
c_code/4_2/@mpluginsupport.nim.o \
c_code/4_2/@mplugins@slocals.nim.o \
c_code/4_2/@mplugins@sitersgen.nim.o \
c_code/4_2/@mplugins@sactive.nim.o \
c_code/4_2/@menumtostr.nim.o \
c_code/4_2/@mvtables.nim.o \
c_code/4_2/@msem.nim.o \
c_code/4_2/@mreorder.nim.o \
c_code/4_2/@mdepends.nim.o \
c_code/4_2/@msourcemap.nim.o \
c_code/4_2/@mjsgen.nim.o \
c_code/4_2/@plists.nim.o \
c_code/4_2/@ppackages@sdocutils@srstast.nim.o \
c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/4_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/4_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/4_2/@ppackages@sdocutils@srst.nim.o \
c_code/4_2/@ppackages@sdocutils@srstgen.nim.o \
c_code/4_2/@mtypesrenderer.nim.o \
c_code/4_2/@mrenderverbatim.nim.o \
c_code/4_2/@pxmltree.nim.o \
c_code/4_2/@puri.nim.o \
c_code/4_2/@mdocgen.nim.o \
c_code/4_2/@mdocgen2.nim.o \
c_code/4_2/@mic@sreplayer.nim.o \
c_code/4_2/@mpipelines.nim.o \
c_code/4_2/@mscriptconfig.nim.o \
c_code/4_2/@mnimconf.nim.o \
c_code/4_2/@mic@sdce.nim.o \
c_code/4_2/@mic@scbackend.nim.o \
c_code/4_2/@mic@sintegrity.nim.o \
c_code/4_2/@mic@snavigator.nim.o \
c_code/4_2/@mmain.nim.o \
c_code/4_2/@mcmdlinehelper.nim.o \
c_code/4_2/@pbrowsers.nim.o \
c_code/4_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@psystem@sexceptions.nim.c -o c_code/4_8/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sassertions.nim.c -o c_code/4_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psystem@sdollars.nim.c -o c_code/4_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sformatfloat.nim.c -o c_code/4_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@psystem.nim.c -o c_code/4_8/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pparseutils.nim.c -o c_code/4_8/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pmath.nim.c -o c_code/4_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@palgorithm.nim.c -o c_code/4_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@punicode.nim.c -o c_code/4_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstrutils.nim.c -o c_code/4_8/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@ppathnorm.nim.c -o c_code/4_8/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstd@soserrors.nim.c -o c_code/4_8/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstd@ssyncio.nim.c -o c_code/4_8/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pposix.nim.c -o c_code/4_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@soscommon.nim.c -o c_code/4_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstd@sprivate@sospaths2.nim.c -o c_code/4_8/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/4_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ptimes.nim.c -o c_code/4_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sosfiles.nim.c -o c_code/4_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstd@sprivate@sosdirs.nim.c -o c_code/4_8/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstd@senvvars.nim.c -o c_code/4_8/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/4_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@scmdline.nim.c -o c_code/4_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pos.nim.c -o c_code/4_8/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pparseopt.nim.c -o c_code/4_8/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@phashes.nim.c -o c_code/4_8/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstrtabs.nim.c -o c_code/4_8/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@ptables.nim.c -o c_code/4_8/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstrformat.nim.c -o c_code/4_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pterminal.nim.c -o c_code/4_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpathutils.nim.c -o c_code/4_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mropes.nim.c -o c_code/4_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlineinfos.nim.c -o c_code/4_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mplatform.nim.c -o c_code/4_8/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mprefixmatches.nim.c -o c_code/4_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimpaths.nim.c -o c_code/4_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@psets.nim.c -o c_code/4_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@moptions.nim.c -o c_code/4_8/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmsgs.nim.c -o c_code/4_8/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcondsyms.nim.c -o c_code/4_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mwordrecg.nim.c -o c_code/4_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@midents.nim.c -o c_code/4_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mint128.nim.c -o c_code/4_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mast.nim.c -o c_code/4_8/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mllstream.nim.c -o c_code/4_8/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimlexbase.nim.c -o c_code/4_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlexer.nim.c -o c_code/4_8/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mrenderer.nim.c -o c_code/4_8/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodulepaths.nim.c -o c_code/4_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pstreams.nim.c -o c_code/4_8/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pcpuinfo.nim.c -o c_code/4_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pdeques.nim.c -o c_code/2_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@smonotimes.nim.c -o c_code/4_1/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@posproc.nim.c -o c_code/4_8/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@plexbase.nim.c -o c_code/4_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pparsejson.nim.c -o c_code/4_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pjson.nim.c -o c_code/4_8/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@sjsonutils.nim.c -o c_code/4_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mextccomp.nim.c -o c_code/4_8/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnimblecmd.nim.c -o c_code/4_8/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcommands.nim.c -o c_code/4_8/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mparser.nim.c -o c_code/4_8/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mfilters.nim.c -o c_code/4_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mfilter_tmpl.nim.c -o c_code/4_8/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msyntaxes.nim.c -o c_code/4_8/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mrodutils.nim.c -o c_code/4_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@spackedsets.nim.c -o c_code/4_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastyaml.nim.c -o c_code/4_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mastalgo.nim.c -o c_code/4_8/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtrees.nim.c -o c_code/4_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mbtrees.nim.c -o c_code/4_8/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpackages.nim.c -o c_code/4_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msuggestsymdb.nim.c -o c_code/4_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@srodfiles.nim.c -o c_code/4_8/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sbitabs.nim.c -o c_code/4_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@siclineinfos.nim.c -o c_code/4_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@spacked_ast.nim.c -o c_code/4_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sic.nim.c -o c_code/4_8/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmodulegraphs.nim.c -o c_code/4_8/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmagicsys.nim.c -o c_code/4_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mastmsgs.nim.c -o c_code/4_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypes.nim.c -o c_code/4_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mnimsets.nim.c -o c_code/4_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcgendata.nim.c -o c_code/4_8/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmangleutils.nim.c -o c_code/4_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mccgutils.nim.c -o c_code/4_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtreetab.nim.c -o c_code/4_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mguards.nim.c -o c_code/4_8/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemfold.nim.c -o c_code/4_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvmdef.nim.c -o c_code/4_8/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlayeredtable.nim.c -o c_code/4_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlowerings.nim.c -o c_code/4_8/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mparampatterns.nim.c -o c_code/4_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemdata.nim.c -o c_code/4_8/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mtypeallowed.nim.c -o c_code/4_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@misolation_check.nim.c -o c_code/4_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvarpartitions.nim.c -o c_code/4_8/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnilcheck.nim.c -o c_code/4_8/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@merrorhandling.nim.c -o c_code/4_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliasanalysis.nim.c -o c_code/4_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msemstrictfuncs.nim.c -o c_code/4_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pstd@seditdistance.nim.c -o c_code/4_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pheapqueue.nim.c -o c_code/4_8/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlookups.nim.c -o c_code/4_8/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mlinter.nim.c -o c_code/4_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemtypinst.nim.c -o c_code/4_8/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mconcepts.nim.c -o c_code/4_8/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msigmatch.nim.c -o c_code/4_8/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mpragmas.nim.c -o c_code/4_8/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpushpoppragmas.nim.c -o c_code/4_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@msighashes.nim.c -o c_code/4_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mliftdestructors.nim.c -o c_code/4_8/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msempass2.nim.c -o c_code/4_8/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcgmeth.nim.c -o c_code/4_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@maliases.nim.c -o c_code/4_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mliftlocals.nim.c -o c_code/4_8/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mlambdalifting.nim.c -o c_code/4_8/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mclosureiters.nim.c -o c_code/4_8/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtransf.nim.c -o c_code/4_8/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@moptimizer.nim.c -o c_code/4_8/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdfa.nim.c -o c_code/4_8/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@minjectdestructors.nim.c -o c_code/4_8/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mexpanddefaults.nim.c -o c_code/4_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelineutils.nim.c -o c_code/4_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mspawn.nim.c -o c_code/4_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemparallel.nim.c -o c_code/4_8/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pdynlib.nim.c -o c_code/4_8/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mcgen.nim.c -o c_code/4_8/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmodules.nim.c -o c_code/4_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msemmacrosanity.nim.c -o c_code/4_8/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvmgen.nim.c -o c_code/4_8/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmdeps.nim.c -o c_code/4_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mgorgeimpl.nim.c -o c_code/4_8/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mmacrocacheimpl.nim.c -o c_code/4_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmprofiler.nim.c -o c_code/4_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mevaltempl.nim.c -o c_code/4_8/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmconv.nim.c -o c_code/4_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvmmarshal.nim.c -o c_code/4_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mvm.nim.c -o c_code/4_8/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mimporter.nim.c -o c_code/4_8/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mprocfind.nim.c -o c_code/4_8/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mpatterns.nim.c -o c_code/4_8/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpluginsupport.nim.c -o c_code/4_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@slocals.nim.c -o c_code/4_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sitersgen.nim.c -o c_code/4_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mplugins@sactive.nim.c -o c_code/4_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@menumtostr.nim.c -o c_code/4_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mvtables.nim.c -o c_code/4_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msem.nim.c -o c_code/4_8/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mreorder.nim.c -o c_code/4_8/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdepends.nim.c -o c_code/4_8/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@msourcemap.nim.c -o c_code/4_8/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mjsgen.nim.c -o c_code/4_8/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@plists.nim.c -o c_code/4_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srstast.nim.c -o c_code/4_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/4_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/4_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@ppackages@sdocutils@srst.nim.c -o c_code/4_8/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@ppackages@sdocutils@srstgen.nim.c -o c_code/4_8/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mtypesrenderer.nim.c -o c_code/4_8/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mrenderverbatim.nim.c -o c_code/4_8/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@pxmltree.nim.c -o c_code/4_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@puri.nim.c -o c_code/4_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen.nim.c -o c_code/4_8/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mdocgen2.nim.c -o c_code/4_8/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@sreplayer.nim.c -o c_code/4_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mpipelines.nim.c -o c_code/4_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mscriptconfig.nim.c -o c_code/4_8/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnimconf.nim.c -o c_code/4_8/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sdce.nim.c -o c_code/4_8/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mic@scbackend.nim.c -o c_code/4_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@sintegrity.nim.c -o c_code/4_8/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mic@snavigator.nim.c -o c_code/4_8/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mmain.nim.c -o c_code/4_8/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_1/@mcmdlinehelper.nim.c -o c_code/4_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@pbrowsers.nim.c -o c_code/4_8/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_8/@mnim.nim.c -o c_code/4_8/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_8/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/4_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/4_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/4_1/@pstd@sformatfloat.nim.o \
c_code/4_8/@psystem.nim.o \
c_code/4_8/@pparseutils.nim.o \
c_code/4_1/@pmath.nim.o \
c_code/4_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/4_1/@punicode.nim.o \
c_code/4_8/@pstrutils.nim.o \
c_code/4_8/@ppathnorm.nim.o \
c_code/4_8/@pstd@soserrors.nim.o \
c_code/4_8/@pstd@ssyncio.nim.o \
c_code/4_1/@pposix.nim.o \
c_code/4_1/@pstd@sprivate@soscommon.nim.o \
c_code/4_8/@pstd@sprivate@sospaths2.nim.o \
c_code/4_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/4_1/@ptimes.nim.o \
c_code/4_1/@pstd@sprivate@sosfiles.nim.o \
c_code/4_8/@pstd@sprivate@sosdirs.nim.o \
c_code/4_8/@pstd@senvvars.nim.o \
c_code/4_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/4_1/@pstd@scmdline.nim.o \
c_code/4_8/@pos.nim.o \
c_code/4_8/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/4_8/@phashes.nim.o \
c_code/4_8/@pstrtabs.nim.o \
c_code/4_8/@ptables.nim.o \
c_code/4_1/@pstrformat.nim.o \
c_code/4_1/@pterminal.nim.o \
c_code/4_1/@mpathutils.nim.o \
c_code/4_1/@mropes.nim.o \
c_code/4_1/@mlineinfos.nim.o \
c_code/4_8/@mplatform.nim.o \
c_code/4_1/@mprefixmatches.nim.o \
c_code/4_1/@mnimpaths.nim.o \
c_code/4_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/4_8/@moptions.nim.o \
c_code/4_8/@mmsgs.nim.o \
c_code/4_1/@mcondsyms.nim.o \
c_code/4_1/@mwordrecg.nim.o \
c_code/4_1/@midents.nim.o \
c_code/4_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/4_8/@mast.nim.o \
c_code/4_8/@mllstream.nim.o \
c_code/4_1/@mnimlexbase.nim.o \
c_code/4_8/@mlexer.nim.o \
c_code/4_8/@mrenderer.nim.o \
c_code/4_1/@mmodulepaths.nim.o \
c_code/4_8/@pstreams.nim.o \
c_code/4_1/@pcpuinfo.nim.o \
c_code/2_1/@pdeques.nim.o \
c_code/4_1/@pstd@smonotimes.nim.o \
c_code/4_8/@posproc.nim.o \
c_code/4_1/@plexbase.nim.o \
c_code/4_1/@pparsejson.nim.o \
c_code/4_8/@pjson.nim.o \
c_code/4_1/@pstd@sjsonutils.nim.o \
c_code/4_8/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_8/@mextccomp.nim.o \
c_code/4_8/@mnimblecmd.nim.o \
c_code/4_8/@mcommands.nim.o \
c_code/4_8/@mparser.nim.o \
c_code/4_1/@mfilters.nim.o \
c_code/4_8/@mfilter_tmpl.nim.o \
c_code/4_8/@msyntaxes.nim.o \
c_code/4_1/@mrodutils.nim.o \
c_code/4_1/@pstd@spackedsets.nim.o \
c_code/4_1/@mastyaml.nim.o \
c_code/4_8/@mastalgo.nim.o \
c_code/4_1/@mtrees.nim.o \
c_code/4_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_8/@mbtrees.nim.o \
c_code/4_1/@mpackages.nim.o \
c_code/4_1/@msuggestsymdb.nim.o \
c_code/4_8/@mic@srodfiles.nim.o \
c_code/4_1/@mic@sbitabs.nim.o \
c_code/4_1/@mic@siclineinfos.nim.o \
c_code/4_1/@mic@spacked_ast.nim.o \
c_code/4_8/@mic@sic.nim.o \
c_code/4_8/@mmodulegraphs.nim.o \
c_code/4_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/4_1/@mastmsgs.nim.o \
c_code/4_1/@mtypes.nim.o \
c_code/4_1/@mnimsets.nim.o \
c_code/4_8/@mcgendata.nim.o \
c_code/4_1/@mmangleutils.nim.o \
c_code/4_1/@mccgutils.nim.o \
c_code/4_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/4_8/@mguards.nim.o \
c_code/4_1/@msemfold.nim.o \
c_code/4_8/@mvmdef.nim.o \
c_code/4_1/@mlayeredtable.nim.o \
c_code/4_8/@mlowerings.nim.o \
c_code/4_1/@mparampatterns.nim.o \
c_code/4_8/@msemdata.nim.o \
c_code/4_1/@mtypeallowed.nim.o \
c_code/4_1/@misolation_check.nim.o \
c_code/4_8/@mvarpartitions.nim.o \
c_code/4_8/@mnilcheck.nim.o \
c_code/4_1/@merrorhandling.nim.o \
c_code/4_1/@maliasanalysis.nim.o \
c_code/4_1/@msemstrictfuncs.nim.o \
c_code/4_1/@pstd@seditdistance.nim.o \
c_code/4_8/@pheapqueue.nim.o \
c_code/4_8/@mlookups.nim.o \
c_code/4_1/@mlinter.nim.o \
c_code/4_8/@msemtypinst.nim.o \
c_code/4_8/@mconcepts.nim.o \
c_code/4_8/@msigmatch.nim.o \
c_code/4_8/@mpragmas.nim.o \
c_code/4_1/@mpushpoppragmas.nim.o \
c_code/4_1/@msighashes.nim.o \
c_code/4_8/@mliftdestructors.nim.o \
c_code/4_8/@msempass2.nim.o \
c_code/4_1/@mcgmeth.nim.o \
c_code/4_1/@maliases.nim.o \
c_code/4_8/@mliftlocals.nim.o \
c_code/4_8/@mlambdalifting.nim.o \
c_code/4_8/@mclosureiters.nim.o \
c_code/4_8/@mtransf.nim.o \
c_code/4_8/@moptimizer.nim.o \
c_code/4_8/@mdfa.nim.o \
c_code/4_8/@minjectdestructors.nim.o \
c_code/4_1/@mexpanddefaults.nim.o \
c_code/4_1/@mpipelineutils.nim.o \
c_code/4_1/@mspawn.nim.o \
c_code/4_8/@msemparallel.nim.o \
c_code/4_8/@pdynlib.nim.o \
c_code/4_8/@mcgen.nim.o \
c_code/4_1/@mmodules.nim.o \
c_code/4_8/@msemmacrosanity.nim.o \
c_code/4_8/@mvmgen.nim.o \
c_code/4_1/@mvmdeps.nim.o \
c_code/4_8/@mgorgeimpl.nim.o \
c_code/4_1/@mmacrocacheimpl.nim.o \
c_code/4_1/@mvmprofiler.nim.o \
c_code/4_8/@mevaltempl.nim.o \
c_code/4_1/@mvmconv.nim.o \
c_code/4_1/@mvmmarshal.nim.o \
c_code/4_8/@mvm.nim.o \
c_code/4_8/@mimporter.nim.o \
c_code/4_8/@mprocfind.nim.o \
c_code/4_8/@mpatterns.nim.o \
c_code/4_1/@mpluginsupport.nim.o \
c_code/4_1/@mplugins@slocals.nim.o \
c_code/4_1/@mplugins@sitersgen.nim.o \
c_code/4_1/@mplugins@sactive.nim.o \
c_code/4_1/@menumtostr.nim.o \
c_code/4_1/@mvtables.nim.o \
c_code/4_8/@msem.nim.o \
c_code/4_8/@mreorder.nim.o \
c_code/4_8/@mdepends.nim.o \
c_code/4_8/@msourcemap.nim.o \
c_code/4_8/@mjsgen.nim.o \
c_code/4_1/@plists.nim.o \
c_code/4_1/@ppackages@sdocutils@srstast.nim.o \
c_code/4_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/4_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/4_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/4_8/@ppackages@sdocutils@srst.nim.o \
c_code/4_8/@ppackages@sdocutils@srstgen.nim.o \
c_code/4_8/@mtypesrenderer.nim.o \
c_code/4_8/@mrenderverbatim.nim.o \
c_code/4_1/@pxmltree.nim.o \
c_code/4_1/@puri.nim.o \
c_code/4_8/@mdocgen.nim.o \
c_code/4_8/@mdocgen2.nim.o \
c_code/4_1/@mic@sreplayer.nim.o \
c_code/4_1/@mpipelines.nim.o \
c_code/4_8/@mscriptconfig.nim.o \
c_code/4_8/@mnimconf.nim.o \
c_code/4_8/@mic@sdce.nim.o \
c_code/4_1/@mic@scbackend.nim.o \
c_code/4_8/@mic@sintegrity.nim.o \
c_code/4_8/@mic@snavigator.nim.o \
c_code/4_8/@mmain.nim.o \
c_code/4_1/@mcmdlinehelper.nim.o \
c_code/4_8/@pbrowsers.nim.o \
c_code/4_8/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@psystem@sexceptions.nim.c -o c_code/4_9/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sassertions.nim.c -o c_code/4_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psystem@sdollars.nim.c -o c_code/4_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sformatfloat.nim.c -o c_code/4_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@psystem.nim.c -o c_code/4_9/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pparseutils.nim.c -o c_code/4_9/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pmath.nim.c -o c_code/4_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@palgorithm.nim.c -o c_code/4_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@punicode.nim.c -o c_code/4_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstrutils.nim.c -o c_code/4_9/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@ppathnorm.nim.c -o c_code/4_9/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstd@soserrors.nim.c -o c_code/4_9/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstd@ssyncio.nim.c -o c_code/4_9/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pposix.nim.c -o c_code/4_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@soscommon.nim.c -o c_code/4_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstd@sprivate@sospaths2.nim.c -o c_code/4_9/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/4_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ptimes.nim.c -o c_code/4_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sosfiles.nim.c -o c_code/4_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstd@sprivate@sosdirs.nim.c -o c_code/4_9/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstd@senvvars.nim.c -o c_code/4_9/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/4_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@scmdline.nim.c -o c_code/4_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pos.nim.c -o c_code/4_9/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pparseopt.nim.c -o c_code/4_9/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@phashes.nim.c -o c_code/4_9/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstrtabs.nim.c -o c_code/4_9/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ptables.nim.c -o c_code/4_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstrformat.nim.c -o c_code/4_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pterminal.nim.c -o c_code/4_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpathutils.nim.c -o c_code/4_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mropes.nim.c -o c_code/4_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlineinfos.nim.c -o c_code/4_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mplatform.nim.c -o c_code/4_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprefixmatches.nim.c -o c_code/4_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimpaths.nim.c -o c_code/4_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@psets.nim.c -o c_code/4_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@moptions.nim.c -o c_code/4_9/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmsgs.nim.c -o c_code/4_9/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcondsyms.nim.c -o c_code/4_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mwordrecg.nim.c -o c_code/4_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@midents.nim.c -o c_code/4_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mint128.nim.c -o c_code/4_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mast.nim.c -o c_code/4_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mllstream.nim.c -o c_code/4_9/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimlexbase.nim.c -o c_code/4_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mlexer.nim.c -o c_code/4_9/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mrenderer.nim.c -o c_code/4_9/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulepaths.nim.c -o c_code/4_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pstreams.nim.c -o c_code/4_9/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pcpuinfo.nim.c -o c_code/4_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pdeques.nim.c -o c_code/2_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@smonotimes.nim.c -o c_code/4_2/@pstd@smonotimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@posproc.nim.c -o c_code/4_9/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@plexbase.nim.c -o c_code/4_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pparsejson.nim.c -o c_code/4_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pjson.nim.c -o c_code/4_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@sjsonutils.nim.c -o c_code/4_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mextccomp.nim.c -o c_code/4_9/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnimblecmd.nim.c -o c_code/4_9/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcommands.nim.c -o c_code/4_9/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mparser.nim.c -o c_code/4_9/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mfilters.nim.c -o c_code/4_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mfilter_tmpl.nim.c -o c_code/4_9/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msyntaxes.nim.c -o c_code/4_9/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrodutils.nim.c -o c_code/4_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@spackedsets.nim.c -o c_code/4_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastyaml.nim.c -o c_code/4_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastalgo.nim.c -o c_code/4_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtrees.nim.c -o c_code/4_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mbtrees.nim.c -o c_code/4_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpackages.nim.c -o c_code/4_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msuggestsymdb.nim.c -o c_code/4_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mic@srodfiles.nim.c -o c_code/4_9/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sbitabs.nim.c -o c_code/4_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@siclineinfos.nim.c -o c_code/4_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@spacked_ast.nim.c -o c_code/4_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mic@sic.nim.c -o c_code/4_9/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodulegraphs.nim.c -o c_code/4_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmagicsys.nim.c -o c_code/4_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mastmsgs.nim.c -o c_code/4_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypes.nim.c -o c_code/4_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnimsets.nim.c -o c_code/4_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgendata.nim.c -o c_code/4_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmangleutils.nim.c -o c_code/4_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mccgutils.nim.c -o c_code/4_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtreetab.nim.c -o c_code/4_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mguards.nim.c -o c_code/4_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemfold.nim.c -o c_code/4_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdef.nim.c -o c_code/4_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlayeredtable.nim.c -o c_code/4_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlowerings.nim.c -o c_code/4_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mparampatterns.nim.c -o c_code/4_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemdata.nim.c -o c_code/4_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtypeallowed.nim.c -o c_code/4_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@misolation_check.nim.c -o c_code/4_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvarpartitions.nim.c -o c_code/4_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mnilcheck.nim.c -o c_code/4_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@merrorhandling.nim.c -o c_code/4_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliasanalysis.nim.c -o c_code/4_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemstrictfuncs.nim.c -o c_code/4_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pstd@seditdistance.nim.c -o c_code/4_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pheapqueue.nim.c -o c_code/4_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlookups.nim.c -o c_code/4_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlinter.nim.c -o c_code/4_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemtypinst.nim.c -o c_code/4_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mconcepts.nim.c -o c_code/4_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msigmatch.nim.c -o c_code/4_9/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mpragmas.nim.c -o c_code/4_9/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpushpoppragmas.nim.c -o c_code/4_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msighashes.nim.c -o c_code/4_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftdestructors.nim.c -o c_code/4_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msempass2.nim.c -o c_code/4_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcgmeth.nim.c -o c_code/4_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@maliases.nim.c -o c_code/4_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mliftlocals.nim.c -o c_code/4_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mlambdalifting.nim.c -o c_code/4_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mclosureiters.nim.c -o c_code/4_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mtransf.nim.c -o c_code/4_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@moptimizer.nim.c -o c_code/4_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdfa.nim.c -o c_code/4_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@minjectdestructors.nim.c -o c_code/4_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mexpanddefaults.nim.c -o c_code/4_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelineutils.nim.c -o c_code/4_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mspawn.nim.c -o c_code/4_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemparallel.nim.c -o c_code/4_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pdynlib.nim.c -o c_code/4_9/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mcgen.nim.c -o c_code/4_9/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmodules.nim.c -o c_code/4_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@msemmacrosanity.nim.c -o c_code/4_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmgen.nim.c -o c_code/4_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmdeps.nim.c -o c_code/4_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mgorgeimpl.nim.c -o c_code/4_9/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mmacrocacheimpl.nim.c -o c_code/4_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmprofiler.nim.c -o c_code/4_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mevaltempl.nim.c -o c_code/4_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmconv.nim.c -o c_code/4_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvmmarshal.nim.c -o c_code/4_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mvm.nim.c -o c_code/4_9/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mimporter.nim.c -o c_code/4_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mprocfind.nim.c -o c_code/4_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpatterns.nim.c -o c_code/4_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpluginsupport.nim.c -o c_code/4_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@slocals.nim.c -o c_code/4_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sitersgen.nim.c -o c_code/4_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mplugins@sactive.nim.c -o c_code/4_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@menumtostr.nim.c -o c_code/4_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mvtables.nim.c -o c_code/4_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msem.nim.c -o c_code/4_9/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mreorder.nim.c -o c_code/4_9/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mdepends.nim.c -o c_code/4_9/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@msourcemap.nim.c -o c_code/4_9/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mjsgen.nim.c -o c_code/4_9/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@plists.nim.c -o c_code/4_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srstast.nim.c -o c_code/4_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/4_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/4_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@ppackages@sdocutils@srst.nim.c -o c_code/4_9/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@ppackages@sdocutils@srstgen.nim.c -o c_code/4_9/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mtypesrenderer.nim.c -o c_code/4_9/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mrenderverbatim.nim.c -o c_code/4_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@pxmltree.nim.c -o c_code/4_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@puri.nim.c -o c_code/4_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mdocgen.nim.c -o c_code/4_9/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mdocgen2.nim.c -o c_code/4_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sreplayer.nim.c -o c_code/4_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mpipelines.nim.c -o c_code/4_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mscriptconfig.nim.c -o c_code/4_9/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnimconf.nim.c -o c_code/4_9/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sdce.nim.c -o c_code/4_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@scbackend.nim.c -o c_code/4_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@sintegrity.nim.c -o c_code/4_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mic@snavigator.nim.c -o c_code/4_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mmain.nim.c -o c_code/4_9/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_2/@mcmdlinehelper.nim.c -o c_code/4_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@pbrowsers.nim.c -o c_code/4_9/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/4_9/@mnim.nim.c -o c_code/4_9/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/4_9/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/4_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/4_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/4_2/@pstd@sformatfloat.nim.o \
c_code/4_9/@psystem.nim.o \
c_code/4_9/@pparseutils.nim.o \
c_code/4_2/@pmath.nim.o \
c_code/4_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/4_2/@punicode.nim.o \
c_code/4_9/@pstrutils.nim.o \
c_code/4_9/@ppathnorm.nim.o \
c_code/4_9/@pstd@soserrors.nim.o \
c_code/4_9/@pstd@ssyncio.nim.o \
c_code/4_2/@pposix.nim.o \
c_code/4_2/@pstd@sprivate@soscommon.nim.o \
c_code/4_9/@pstd@sprivate@sospaths2.nim.o \
c_code/4_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/4_2/@ptimes.nim.o \
c_code/4_2/@pstd@sprivate@sosfiles.nim.o \
c_code/4_9/@pstd@sprivate@sosdirs.nim.o \
c_code/4_9/@pstd@senvvars.nim.o \
c_code/4_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/4_2/@pstd@scmdline.nim.o \
c_code/4_9/@pos.nim.o \
c_code/4_9/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/4_9/@phashes.nim.o \
c_code/4_9/@pstrtabs.nim.o \
c_code/4_2/@ptables.nim.o \
c_code/4_2/@pstrformat.nim.o \
c_code/4_2/@pterminal.nim.o \
c_code/4_2/@mpathutils.nim.o \
c_code/4_2/@mropes.nim.o \
c_code/4_2/@mlineinfos.nim.o \
c_code/4_9/@mplatform.nim.o \
c_code/4_2/@mprefixmatches.nim.o \
c_code/4_2/@mnimpaths.nim.o \
c_code/4_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/4_9/@moptions.nim.o \
c_code/4_9/@mmsgs.nim.o \
c_code/4_2/@mcondsyms.nim.o \
c_code/4_2/@mwordrecg.nim.o \
c_code/4_2/@midents.nim.o \
c_code/4_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/4_2/@mast.nim.o \
c_code/4_9/@mllstream.nim.o \
c_code/4_2/@mnimlexbase.nim.o \
c_code/4_9/@mlexer.nim.o \
c_code/4_9/@mrenderer.nim.o \
c_code/4_2/@mmodulepaths.nim.o \
c_code/4_9/@pstreams.nim.o \
c_code/4_2/@pcpuinfo.nim.o \
c_code/2_2/@pdeques.nim.o \
c_code/4_2/@pstd@smonotimes.nim.o \
c_code/4_9/@posproc.nim.o \
c_code/4_2/@plexbase.nim.o \
c_code/4_2/@pparsejson.nim.o \
c_code/4_2/@pjson.nim.o \
c_code/4_2/@pstd@sjsonutils.nim.o \
c_code/4_9/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/4_9/@mextccomp.nim.o \
c_code/4_9/@mnimblecmd.nim.o \
c_code/4_9/@mcommands.nim.o \
c_code/4_9/@mparser.nim.o \
c_code/4_2/@mfilters.nim.o \
c_code/4_9/@mfilter_tmpl.nim.o \
c_code/4_9/@msyntaxes.nim.o \
c_code/4_2/@mrodutils.nim.o \
c_code/4_2/@pstd@spackedsets.nim.o \
c_code/4_2/@mastyaml.nim.o \
c_code/4_2/@mastalgo.nim.o \
c_code/4_2/@mtrees.nim.o \
c_code/4_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/4_2/@mbtrees.nim.o \
c_code/4_2/@mpackages.nim.o \
c_code/4_2/@msuggestsymdb.nim.o \
c_code/4_9/@mic@srodfiles.nim.o \
c_code/4_2/@mic@sbitabs.nim.o \
c_code/4_2/@mic@siclineinfos.nim.o \
c_code/4_2/@mic@spacked_ast.nim.o \
c_code/4_9/@mic@sic.nim.o \
c_code/4_2/@mmodulegraphs.nim.o \
c_code/4_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/4_2/@mastmsgs.nim.o \
c_code/4_2/@mtypes.nim.o \
c_code/4_2/@mnimsets.nim.o \
c_code/4_2/@mcgendata.nim.o \
c_code/4_2/@mmangleutils.nim.o \
c_code/4_2/@mccgutils.nim.o \
c_code/4_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/4_2/@mguards.nim.o \
c_code/4_2/@msemfold.nim.o \
c_code/4_2/@mvmdef.nim.o \
c_code/4_2/@mlayeredtable.nim.o \
c_code/4_2/@mlowerings.nim.o \
c_code/4_2/@mparampatterns.nim.o \
c_code/4_2/@msemdata.nim.o \
c_code/4_2/@mtypeallowed.nim.o \
c_code/4_2/@misolation_check.nim.o \
c_code/4_2/@mvarpartitions.nim.o \
c_code/4_2/@mnilcheck.nim.o \
c_code/4_2/@merrorhandling.nim.o \
c_code/4_2/@maliasanalysis.nim.o \
c_code/4_2/@msemstrictfuncs.nim.o \
c_code/4_2/@pstd@seditdistance.nim.o \
c_code/4_2/@pheapqueue.nim.o \
c_code/4_2/@mlookups.nim.o \
c_code/4_2/@mlinter.nim.o \
c_code/4_2/@msemtypinst.nim.o \
c_code/4_2/@mconcepts.nim.o \
c_code/4_9/@msigmatch.nim.o \
c_code/4_9/@mpragmas.nim.o \
c_code/4_2/@mpushpoppragmas.nim.o \
c_code/4_2/@msighashes.nim.o \
c_code/4_2/@mliftdestructors.nim.o \
c_code/4_2/@msempass2.nim.o \
c_code/4_2/@mcgmeth.nim.o \
c_code/4_2/@maliases.nim.o \
c_code/4_2/@mliftlocals.nim.o \
c_code/4_2/@mlambdalifting.nim.o \
c_code/4_2/@mclosureiters.nim.o \
c_code/4_2/@mtransf.nim.o \
c_code/4_2/@moptimizer.nim.o \
c_code/4_2/@mdfa.nim.o \
c_code/4_2/@minjectdestructors.nim.o \
c_code/4_2/@mexpanddefaults.nim.o \
c_code/4_2/@mpipelineutils.nim.o \
c_code/4_2/@mspawn.nim.o \
c_code/4_2/@msemparallel.nim.o \
c_code/4_9/@pdynlib.nim.o \
c_code/4_9/@mcgen.nim.o \
c_code/4_2/@mmodules.nim.o \
c_code/4_2/@msemmacrosanity.nim.o \
c_code/4_2/@mvmgen.nim.o \
c_code/4_2/@mvmdeps.nim.o \
c_code/4_9/@mgorgeimpl.nim.o \
c_code/4_2/@mmacrocacheimpl.nim.o \
c_code/4_2/@mvmprofiler.nim.o \
c_code/4_2/@mevaltempl.nim.o \
c_code/4_2/@mvmconv.nim.o \
c_code/4_2/@mvmmarshal.nim.o \
c_code/4_9/@mvm.nim.o \
c_code/4_2/@mimporter.nim.o \
c_code/4_2/@mprocfind.nim.o \
c_code/4_2/@mpatterns.nim.o \
c_code/4_2/@mpluginsupport.nim.o \
c_code/4_2/@mplugins@slocals.nim.o \
c_code/4_2/@mplugins@sitersgen.nim.o \
c_code/4_2/@mplugins@sactive.nim.o \
c_code/4_2/@menumtostr.nim.o \
c_code/4_2/@mvtables.nim.o \
c_code/4_9/@msem.nim.o \
c_code/4_9/@mreorder.nim.o \
c_code/4_9/@mdepends.nim.o \
c_code/4_9/@msourcemap.nim.o \
c_code/4_9/@mjsgen.nim.o \
c_code/4_2/@plists.nim.o \
c_code/4_2/@ppackages@sdocutils@srstast.nim.o \
c_code/4_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/4_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/4_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/4_9/@ppackages@sdocutils@srst.nim.o \
c_code/4_9/@ppackages@sdocutils@srstgen.nim.o \
c_code/4_9/@mtypesrenderer.nim.o \
c_code/4_2/@mrenderverbatim.nim.o \
c_code/4_2/@pxmltree.nim.o \
c_code/4_2/@puri.nim.o \
c_code/4_9/@mdocgen.nim.o \
c_code/4_2/@mdocgen2.nim.o \
c_code/4_2/@mic@sreplayer.nim.o \
c_code/4_2/@mpipelines.nim.o \
c_code/4_9/@mscriptconfig.nim.o \
c_code/4_9/@mnimconf.nim.o \
c_code/4_2/@mic@sdce.nim.o \
c_code/4_2/@mic@scbackend.nim.o \
c_code/4_2/@mic@sintegrity.nim.o \
c_code/4_2/@mic@snavigator.nim.o \
c_code/4_9/@mmain.nim.o \
c_code/4_2/@mcmdlinehelper.nim.o \
c_code/4_9/@pbrowsers.nim.o \
c_code/4_9/@mnim.nim.o $LINK_FLAGS
    ;;
  s390x)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mipsel)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64el)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  arm64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv32)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  riscv64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  loongarch64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  *)
    echo 2>&1 "Error: no C code generated for: [$myos: $mycpu]"
    exit 1
    ;;
  esac
  ;;
freebsd)
  case $mycpu in
  i386)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psystem@sexceptions.nim.c -o c_code/5_1/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sassertions.nim.c -o c_code/5_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psystem@sdollars.nim.c -o c_code/5_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sformatfloat.nim.c -o c_code/5_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psystem.nim.c -o c_code/5_1/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pparseutils.nim.c -o c_code/5_1/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pmath.nim.c -o c_code/5_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@palgorithm.nim.c -o c_code/5_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@punicode.nim.c -o c_code/5_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstrutils.nim.c -o c_code/5_1/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppathnorm.nim.c -o c_code/5_1/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@soserrors.nim.c -o c_code/5_1/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@ssyncio.nim.c -o c_code/5_1/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pposix.nim.c -o c_code/3_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@soscommon.nim.c -o c_code/5_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sospaths2.nim.c -o c_code/5_1/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ptimes.nim.c -o c_code/5_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosfiles.nim.c -o c_code/5_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosdirs.nim.c -o c_code/5_1/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@senvvars.nim.c -o c_code/5_1/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@scmdline.nim.c -o c_code/5_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pos.nim.c -o c_code/5_1/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pparseopt.nim.c -o c_code/5_1/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@phashes.nim.c -o c_code/5_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstrtabs.nim.c -o c_code/5_1/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ptables.nim.c -o c_code/5_1/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstrformat.nim.c -o c_code/5_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pterminal.nim.c -o c_code/5_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplatform.nim.c -o c_code/5_1/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psets.nim.c -o c_code/5_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@moptions.nim.c -o c_code/5_1/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmsgs.nim.c -o c_code/5_1/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mast.nim.c -o c_code/5_1/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mllstream.nim.c -o c_code/5_1/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlexer.nim.c -o c_code/5_1/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrenderer.nim.c -o c_code/5_1/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstreams.nim.c -o c_code/5_1/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pcpuinfo.nim.c -o c_code/5_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pdeques.nim.c -o c_code/5_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@posproc.nim.c -o c_code/5_1/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plexbase.nim.c -o c_code/5_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pparsejson.nim.c -o c_code/5_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pjson.nim.c -o c_code/5_1/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sjsonutils.nim.c -o c_code/5_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mextccomp.nim.c -o c_code/5_1/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimblecmd.nim.c -o c_code/5_1/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcommands.nim.c -o c_code/5_1/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparser.nim.c -o c_code/5_1/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilter_tmpl.nim.c -o c_code/5_1/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msyntaxes.nim.c -o c_code/5_1/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@spackedsets.nim.c -o c_code/5_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastalgo.nim.c -o c_code/5_1/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mbtrees.nim.c -o c_code/5_1/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@srodfiles.nim.c -o c_code/5_1/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sic.nim.c -o c_code/5_1/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulegraphs.nim.c -o c_code/5_1/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgendata.nim.c -o c_code/5_1/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mguards.nim.c -o c_code/5_1/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemfold.nim.c -o c_code/5_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdef.nim.c -o c_code/5_1/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlayeredtable.nim.c -o c_code/5_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlowerings.nim.c -o c_code/5_1/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparampatterns.nim.c -o c_code/5_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemdata.nim.c -o c_code/5_1/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypeallowed.nim.c -o c_code/5_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@misolation_check.nim.c -o c_code/5_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvarpartitions.nim.c -o c_code/5_1/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnilcheck.nim.c -o c_code/5_1/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@merrorhandling.nim.c -o c_code/5_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliasanalysis.nim.c -o c_code/5_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemstrictfuncs.nim.c -o c_code/5_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@seditdistance.nim.c -o c_code/5_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pheapqueue.nim.c -o c_code/5_1/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlookups.nim.c -o c_code/5_1/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlinter.nim.c -o c_code/5_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemtypinst.nim.c -o c_code/5_1/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mconcepts.nim.c -o c_code/5_1/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msigmatch.nim.c -o c_code/5_1/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpragmas.nim.c -o c_code/5_1/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpushpoppragmas.nim.c -o c_code/5_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msighashes.nim.c -o c_code/5_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mliftdestructors.nim.c -o c_code/5_1/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msempass2.nim.c -o c_code/5_1/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgmeth.nim.c -o c_code/5_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliases.nim.c -o c_code/5_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mliftlocals.nim.c -o c_code/5_1/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlambdalifting.nim.c -o c_code/5_1/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mclosureiters.nim.c -o c_code/5_1/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtransf.nim.c -o c_code/5_1/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@moptimizer.nim.c -o c_code/5_1/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdfa.nim.c -o c_code/5_1/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@minjectdestructors.nim.c -o c_code/5_1/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mexpanddefaults.nim.c -o c_code/5_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelineutils.nim.c -o c_code/5_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mspawn.nim.c -o c_code/5_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemparallel.nim.c -o c_code/5_1/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pdynlib.nim.c -o c_code/5_1/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgen.nim.c -o c_code/5_1/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodules.nim.c -o c_code/5_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemmacrosanity.nim.c -o c_code/5_1/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmgen.nim.c -o c_code/5_1/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mgorgeimpl.nim.c -o c_code/5_1/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmacrocacheimpl.nim.c -o c_code/5_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmprofiler.nim.c -o c_code/5_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mevaltempl.nim.c -o c_code/5_1/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmconv.nim.c -o c_code/5_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmmarshal.nim.c -o c_code/5_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvm.nim.c -o c_code/5_1/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mimporter.nim.c -o c_code/5_1/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprocfind.nim.c -o c_code/5_1/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpatterns.nim.c -o c_code/5_1/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpluginsupport.nim.c -o c_code/5_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@slocals.nim.c -o c_code/5_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sitersgen.nim.c -o c_code/5_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sactive.nim.c -o c_code/5_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@menumtostr.nim.c -o c_code/5_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvtables.nim.c -o c_code/5_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msem.nim.c -o c_code/5_1/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mreorder.nim.c -o c_code/5_1/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdepends.nim.c -o c_code/5_1/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msourcemap.nim.c -o c_code/5_1/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mjsgen.nim.c -o c_code/5_1/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plists.nim.c -o c_code/5_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstast.nim.c -o c_code/5_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srst.nim.c -o c_code/5_1/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_1/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypesrenderer.nim.c -o c_code/5_1/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrenderverbatim.nim.c -o c_code/5_1/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pxmltree.nim.c -o c_code/5_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@puri.nim.c -o c_code/5_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen.nim.c -o c_code/5_1/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mdocgen2.nim.c -o c_code/5_1/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sreplayer.nim.c -o c_code/5_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelines.nim.c -o c_code/5_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mscriptconfig.nim.c -o c_code/5_1/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimconf.nim.c -o c_code/5_1/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sdce.nim.c -o c_code/5_1/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@scbackend.nim.c -o c_code/5_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sintegrity.nim.c -o c_code/5_1/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@snavigator.nim.c -o c_code/5_1/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmain.nim.c -o c_code/5_1/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcmdlinehelper.nim.c -o c_code/5_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pbrowsers.nim.c -o c_code/5_1/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnim.nim.c -o c_code/5_1/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_1/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/5_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/5_1/@pstd@sformatfloat.nim.o \
c_code/5_1/@psystem.nim.o \
c_code/5_1/@pparseutils.nim.o \
c_code/5_1/@pmath.nim.o \
c_code/5_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/5_1/@punicode.nim.o \
c_code/5_1/@pstrutils.nim.o \
c_code/5_1/@ppathnorm.nim.o \
c_code/5_1/@pstd@soserrors.nim.o \
c_code/5_1/@pstd@ssyncio.nim.o \
c_code/3_1/@pposix.nim.o \
c_code/5_1/@pstd@sprivate@soscommon.nim.o \
c_code/5_1/@pstd@sprivate@sospaths2.nim.o \
c_code/5_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_1/@ptimes.nim.o \
c_code/5_1/@pstd@sprivate@sosfiles.nim.o \
c_code/5_1/@pstd@sprivate@sosdirs.nim.o \
c_code/5_1/@pstd@senvvars.nim.o \
c_code/5_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_1/@pstd@scmdline.nim.o \
c_code/5_1/@pos.nim.o \
c_code/5_1/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/5_1/@phashes.nim.o \
c_code/5_1/@pstrtabs.nim.o \
c_code/5_1/@ptables.nim.o \
c_code/5_1/@pstrformat.nim.o \
c_code/5_1/@pterminal.nim.o \
c_code/5_1/@mpathutils.nim.o \
c_code/5_1/@mropes.nim.o \
c_code/5_1/@mlineinfos.nim.o \
c_code/5_1/@mplatform.nim.o \
c_code/5_1/@mprefixmatches.nim.o \
c_code/5_1/@mnimpaths.nim.o \
c_code/5_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/5_1/@moptions.nim.o \
c_code/5_1/@mmsgs.nim.o \
c_code/5_1/@mcondsyms.nim.o \
c_code/5_1/@mwordrecg.nim.o \
c_code/5_1/@midents.nim.o \
c_code/5_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/5_1/@mast.nim.o \
c_code/5_1/@mllstream.nim.o \
c_code/5_1/@mnimlexbase.nim.o \
c_code/5_1/@mlexer.nim.o \
c_code/5_1/@mrenderer.nim.o \
c_code/5_1/@mmodulepaths.nim.o \
c_code/5_1/@pstreams.nim.o \
c_code/5_1/@pcpuinfo.nim.o \
c_code/5_1/@pdeques.nim.o \
c_code/5_1/@posproc.nim.o \
c_code/5_1/@plexbase.nim.o \
c_code/5_1/@pparsejson.nim.o \
c_code/5_1/@pjson.nim.o \
c_code/5_1/@pstd@sjsonutils.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_1/@mextccomp.nim.o \
c_code/5_1/@mnimblecmd.nim.o \
c_code/5_1/@mcommands.nim.o \
c_code/5_1/@mparser.nim.o \
c_code/5_1/@mfilters.nim.o \
c_code/5_1/@mfilter_tmpl.nim.o \
c_code/5_1/@msyntaxes.nim.o \
c_code/5_1/@mrodutils.nim.o \
c_code/5_1/@pstd@spackedsets.nim.o \
c_code/5_1/@mastyaml.nim.o \
c_code/5_1/@mastalgo.nim.o \
c_code/5_1/@mtrees.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_1/@mbtrees.nim.o \
c_code/5_1/@mpackages.nim.o \
c_code/5_1/@msuggestsymdb.nim.o \
c_code/5_1/@mic@srodfiles.nim.o \
c_code/5_1/@mic@sbitabs.nim.o \
c_code/5_1/@mic@siclineinfos.nim.o \
c_code/5_1/@mic@spacked_ast.nim.o \
c_code/5_1/@mic@sic.nim.o \
c_code/5_1/@mmodulegraphs.nim.o \
c_code/5_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/5_1/@mastmsgs.nim.o \
c_code/5_1/@mtypes.nim.o \
c_code/5_1/@mnimsets.nim.o \
c_code/5_1/@mcgendata.nim.o \
c_code/5_1/@mmangleutils.nim.o \
c_code/5_1/@mccgutils.nim.o \
c_code/5_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/5_1/@mguards.nim.o \
c_code/5_1/@msemfold.nim.o \
c_code/5_1/@mvmdef.nim.o \
c_code/5_1/@mlayeredtable.nim.o \
c_code/5_1/@mlowerings.nim.o \
c_code/5_1/@mparampatterns.nim.o \
c_code/5_1/@msemdata.nim.o \
c_code/5_1/@mtypeallowed.nim.o \
c_code/5_1/@misolation_check.nim.o \
c_code/5_1/@mvarpartitions.nim.o \
c_code/5_1/@mnilcheck.nim.o \
c_code/5_1/@merrorhandling.nim.o \
c_code/5_1/@maliasanalysis.nim.o \
c_code/5_1/@msemstrictfuncs.nim.o \
c_code/5_1/@pstd@seditdistance.nim.o \
c_code/5_1/@pheapqueue.nim.o \
c_code/5_1/@mlookups.nim.o \
c_code/5_1/@mlinter.nim.o \
c_code/5_1/@msemtypinst.nim.o \
c_code/5_1/@mconcepts.nim.o \
c_code/5_1/@msigmatch.nim.o \
c_code/5_1/@mpragmas.nim.o \
c_code/5_1/@mpushpoppragmas.nim.o \
c_code/5_1/@msighashes.nim.o \
c_code/5_1/@mliftdestructors.nim.o \
c_code/5_1/@msempass2.nim.o \
c_code/5_1/@mcgmeth.nim.o \
c_code/5_1/@maliases.nim.o \
c_code/5_1/@mliftlocals.nim.o \
c_code/5_1/@mlambdalifting.nim.o \
c_code/5_1/@mclosureiters.nim.o \
c_code/5_1/@mtransf.nim.o \
c_code/5_1/@moptimizer.nim.o \
c_code/5_1/@mdfa.nim.o \
c_code/5_1/@minjectdestructors.nim.o \
c_code/5_1/@mexpanddefaults.nim.o \
c_code/5_1/@mpipelineutils.nim.o \
c_code/5_1/@mspawn.nim.o \
c_code/5_1/@msemparallel.nim.o \
c_code/5_1/@pdynlib.nim.o \
c_code/5_1/@mcgen.nim.o \
c_code/5_1/@mmodules.nim.o \
c_code/5_1/@msemmacrosanity.nim.o \
c_code/5_1/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/5_1/@mgorgeimpl.nim.o \
c_code/5_1/@mmacrocacheimpl.nim.o \
c_code/5_1/@mvmprofiler.nim.o \
c_code/5_1/@mevaltempl.nim.o \
c_code/5_1/@mvmconv.nim.o \
c_code/5_1/@mvmmarshal.nim.o \
c_code/5_1/@mvm.nim.o \
c_code/5_1/@mimporter.nim.o \
c_code/5_1/@mprocfind.nim.o \
c_code/5_1/@mpatterns.nim.o \
c_code/5_1/@mpluginsupport.nim.o \
c_code/5_1/@mplugins@slocals.nim.o \
c_code/5_1/@mplugins@sitersgen.nim.o \
c_code/5_1/@mplugins@sactive.nim.o \
c_code/5_1/@menumtostr.nim.o \
c_code/5_1/@mvtables.nim.o \
c_code/5_1/@msem.nim.o \
c_code/5_1/@mreorder.nim.o \
c_code/5_1/@mdepends.nim.o \
c_code/5_1/@msourcemap.nim.o \
c_code/5_1/@mjsgen.nim.o \
c_code/5_1/@plists.nim.o \
c_code/5_1/@ppackages@sdocutils@srstast.nim.o \
c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_1/@ppackages@sdocutils@srst.nim.o \
c_code/5_1/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_1/@mtypesrenderer.nim.o \
c_code/5_1/@mrenderverbatim.nim.o \
c_code/5_1/@pxmltree.nim.o \
c_code/5_1/@puri.nim.o \
c_code/5_1/@mdocgen.nim.o \
c_code/5_1/@mdocgen2.nim.o \
c_code/5_1/@mic@sreplayer.nim.o \
c_code/5_1/@mpipelines.nim.o \
c_code/5_1/@mscriptconfig.nim.o \
c_code/5_1/@mnimconf.nim.o \
c_code/5_1/@mic@sdce.nim.o \
c_code/5_1/@mic@scbackend.nim.o \
c_code/5_1/@mic@sintegrity.nim.o \
c_code/5_1/@mic@snavigator.nim.o \
c_code/5_1/@mmain.nim.o \
c_code/5_1/@mcmdlinehelper.nim.o \
c_code/5_1/@pbrowsers.nim.o \
c_code/5_1/@mnim.nim.o $LINK_FLAGS
    ;;
  amd64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sexceptions.nim.c -o c_code/5_2/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sassertions.nim.c -o c_code/5_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sdollars.nim.c -o c_code/5_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sformatfloat.nim.c -o c_code/5_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem.nim.c -o c_code/5_2/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparseutils.nim.c -o c_code/5_2/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pmath.nim.c -o c_code/5_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@palgorithm.nim.c -o c_code/5_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@punicode.nim.c -o c_code/5_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrutils.nim.c -o c_code/5_2/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppathnorm.nim.c -o c_code/5_2/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@soserrors.nim.c -o c_code/5_2/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@ssyncio.nim.c -o c_code/5_2/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pposix.nim.c -o c_code/5_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@soscommon.nim.c -o c_code/5_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sospaths2.nim.c -o c_code/5_2/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptimes.nim.c -o c_code/5_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosfiles.nim.c -o c_code/5_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@senvvars.nim.c -o c_code/5_2/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@scmdline.nim.c -o c_code/5_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pos.nim.c -o c_code/5_2/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparseopt.nim.c -o c_code/5_2/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@phashes.nim.c -o c_code/5_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrtabs.nim.c -o c_code/5_2/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptables.nim.c -o c_code/5_2/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrformat.nim.c -o c_code/5_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pterminal.nim.c -o c_code/5_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplatform.nim.c -o c_code/5_2/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psets.nim.c -o c_code/5_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptions.nim.c -o c_code/5_2/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmsgs.nim.c -o c_code/5_2/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mllstream.nim.c -o c_code/5_2/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlexer.nim.c -o c_code/5_2/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderer.nim.c -o c_code/5_2/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstreams.nim.c -o c_code/5_2/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pcpuinfo.nim.c -o c_code/5_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdeques.nim.c -o c_code/5_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@posproc.nim.c -o c_code/5_2/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plexbase.nim.c -o c_code/5_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparsejson.nim.c -o c_code/5_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pjson.nim.c -o c_code/5_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sjsonutils.nim.c -o c_code/5_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mextccomp.nim.c -o c_code/5_2/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimblecmd.nim.c -o c_code/5_2/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcommands.nim.c -o c_code/5_2/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparser.nim.c -o c_code/5_2/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilter_tmpl.nim.c -o c_code/5_2/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msyntaxes.nim.c -o c_code/5_2/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@spackedsets.nim.c -o c_code/5_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@srodfiles.nim.c -o c_code/5_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sic.nim.c -o c_code/5_2/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdef.nim.c -o c_code/5_2/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlayeredtable.nim.c -o c_code/5_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemdata.nim.c -o c_code/5_2/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@seditdistance.nim.c -o c_code/5_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pheapqueue.nim.c -o c_code/5_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msigmatch.nim.c -o c_code/5_2/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpragmas.nim.c -o c_code/5_2/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@minjectdestructors.nim.c -o c_code/5_2/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdynlib.nim.c -o c_code/5_2/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgen.nim.c -o c_code/5_2/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mgorgeimpl.nim.c -o c_code/5_2/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvm.nim.c -o c_code/5_2/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msem.nim.c -o c_code/5_2/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mreorder.nim.c -o c_code/5_2/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdepends.nim.c -o c_code/5_2/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msourcemap.nim.c -o c_code/5_2/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mjsgen.nim.c -o c_code/5_2/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plists.nim.c -o c_code/5_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstast.nim.c -o c_code/5_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srst.nim.c -o c_code/5_2/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_2/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypesrenderer.nim.c -o c_code/5_2/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pxmltree.nim.c -o c_code/5_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@puri.nim.c -o c_code/5_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen.nim.c -o c_code/5_2/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mscriptconfig.nim.c -o c_code/5_2/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimconf.nim.c -o c_code/5_2/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmain.nim.c -o c_code/5_2/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pbrowsers.nim.c -o c_code/5_2/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnim.nim.c -o c_code/5_2/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_2/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/5_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/5_2/@pstd@sformatfloat.nim.o \
c_code/5_2/@psystem.nim.o \
c_code/5_2/@pparseutils.nim.o \
c_code/5_2/@pmath.nim.o \
c_code/5_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/5_2/@punicode.nim.o \
c_code/5_2/@pstrutils.nim.o \
c_code/5_2/@ppathnorm.nim.o \
c_code/5_2/@pstd@soserrors.nim.o \
c_code/5_2/@pstd@ssyncio.nim.o \
c_code/5_2/@pposix.nim.o \
c_code/5_2/@pstd@sprivate@soscommon.nim.o \
c_code/5_2/@pstd@sprivate@sospaths2.nim.o \
c_code/5_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@ptimes.nim.o \
c_code/5_2/@pstd@sprivate@sosfiles.nim.o \
c_code/5_2/@pstd@sprivate@sosdirs.nim.o \
c_code/5_2/@pstd@senvvars.nim.o \
c_code/5_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@pstd@scmdline.nim.o \
c_code/5_2/@pos.nim.o \
c_code/5_2/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/5_2/@phashes.nim.o \
c_code/5_2/@pstrtabs.nim.o \
c_code/5_2/@ptables.nim.o \
c_code/5_2/@pstrformat.nim.o \
c_code/5_2/@pterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_2/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/5_2/@moptions.nim.o \
c_code/5_2/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_2/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_2/@mlexer.nim.o \
c_code/5_2/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_2/@pstreams.nim.o \
c_code/5_2/@pcpuinfo.nim.o \
c_code/5_2/@pdeques.nim.o \
c_code/5_2/@posproc.nim.o \
c_code/5_2/@plexbase.nim.o \
c_code/5_2/@pparsejson.nim.o \
c_code/5_2/@pjson.nim.o \
c_code/5_2/@pstd@sjsonutils.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_2/@mextccomp.nim.o \
c_code/5_2/@mnimblecmd.nim.o \
c_code/5_2/@mcommands.nim.o \
c_code/5_2/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_2/@mfilter_tmpl.nim.o \
c_code/5_2/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@pstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_2/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_2/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_2/@mvmdef.nim.o \
c_code/5_2/@mlayeredtable.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_2/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@pstd@seditdistance.nim.o \
c_code/5_2/@pheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_2/@msigmatch.nim.o \
c_code/5_2/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_2/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_2/@pdynlib.nim.o \
c_code/5_2/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_2/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_2/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_2/@msem.nim.o \
c_code/5_2/@mreorder.nim.o \
c_code/5_2/@mdepends.nim.o \
c_code/5_2/@msourcemap.nim.o \
c_code/5_2/@mjsgen.nim.o \
c_code/5_2/@plists.nim.o \
c_code/5_2/@ppackages@sdocutils@srstast.nim.o \
c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_2/@ppackages@sdocutils@srst.nim.o \
c_code/5_2/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_2/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@pxmltree.nim.o \
c_code/5_2/@puri.nim.o \
c_code/5_2/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_2/@mscriptconfig.nim.o \
c_code/5_2/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_2/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_2/@pbrowsers.nim.o \
c_code/5_2/@mnim.nim.o $LINK_FLAGS
    ;;
  hppa)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  ia64)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  alpha)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  powerpc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem@sexceptions.nim.c -o c_code/5_6/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sassertions.nim.c -o c_code/5_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sdollars.nim.c -o c_code/5_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sformatfloat.nim.c -o c_code/5_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem.nim.c -o c_code/5_6/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseutils.nim.c -o c_code/5_6/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pmath.nim.c -o c_code/5_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@palgorithm.nim.c -o c_code/5_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@punicode.nim.c -o c_code/5_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrutils.nim.c -o c_code/5_6/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppathnorm.nim.c -o c_code/5_6/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@soserrors.nim.c -o c_code/5_6/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@ssyncio.nim.c -o c_code/5_6/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pposix.nim.c -o c_code/5_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@soscommon.nim.c -o c_code/5_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sospaths2.nim.c -o c_code/5_6/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptimes.nim.c -o c_code/5_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosfiles.nim.c -o c_code/5_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sosdirs.nim.c -o c_code/5_6/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@senvvars.nim.c -o c_code/5_6/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@scmdline.nim.c -o c_code/5_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pos.nim.c -o c_code/5_6/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseopt.nim.c -o c_code/5_6/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@phashes.nim.c -o c_code/5_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrtabs.nim.c -o c_code/5_6/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ptables.nim.c -o c_code/5_6/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrformat.nim.c -o c_code/5_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pterminal.nim.c -o c_code/5_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mplatform.nim.c -o c_code/5_6/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psets.nim.c -o c_code/5_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstreams.nim.c -o c_code/5_6/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pcpuinfo.nim.c -o c_code/5_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdeques.nim.c -o c_code/5_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@posproc.nim.c -o c_code/5_6/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plexbase.nim.c -o c_code/5_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparsejson.nim.c -o c_code/5_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pjson.nim.c -o c_code/5_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sjsonutils.nim.c -o c_code/5_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@spackedsets.nim.c -o c_code/5_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@srodfiles.nim.c -o c_code/5_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlayeredtable.nim.c -o c_code/5_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@seditdistance.nim.c -o c_code/5_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pheapqueue.nim.c -o c_code/5_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pdynlib.nim.c -o c_code/5_6/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plists.nim.c -o c_code/5_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstast.nim.c -o c_code/5_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srst.nim.c -o c_code/5_6/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_6/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pxmltree.nim.c -o c_code/5_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@puri.nim.c -o c_code/5_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pbrowsers.nim.c -o c_code/5_6/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/5_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/5_2/@pstd@sformatfloat.nim.o \
c_code/5_6/@psystem.nim.o \
c_code/5_6/@pparseutils.nim.o \
c_code/5_2/@pmath.nim.o \
c_code/5_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/5_2/@punicode.nim.o \
c_code/5_6/@pstrutils.nim.o \
c_code/5_6/@ppathnorm.nim.o \
c_code/5_6/@pstd@soserrors.nim.o \
c_code/5_6/@pstd@ssyncio.nim.o \
c_code/5_2/@pposix.nim.o \
c_code/5_2/@pstd@sprivate@soscommon.nim.o \
c_code/5_6/@pstd@sprivate@sospaths2.nim.o \
c_code/5_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@ptimes.nim.o \
c_code/5_2/@pstd@sprivate@sosfiles.nim.o \
c_code/5_6/@pstd@sprivate@sosdirs.nim.o \
c_code/5_6/@pstd@senvvars.nim.o \
c_code/5_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@pstd@scmdline.nim.o \
c_code/5_6/@pos.nim.o \
c_code/5_6/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/5_6/@phashes.nim.o \
c_code/5_6/@pstrtabs.nim.o \
c_code/5_6/@ptables.nim.o \
c_code/5_2/@pstrformat.nim.o \
c_code/5_2/@pterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_6/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@pstreams.nim.o \
c_code/5_2/@pcpuinfo.nim.o \
c_code/5_2/@pdeques.nim.o \
c_code/5_6/@posproc.nim.o \
c_code/5_2/@plexbase.nim.o \
c_code/5_2/@pparsejson.nim.o \
c_code/5_2/@pjson.nim.o \
c_code/5_2/@pstd@sjsonutils.nim.o \
c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@pstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_6/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_2/@mlayeredtable.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@pstd@seditdistance.nim.o \
c_code/5_2/@pheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@pdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@plists.nim.o \
c_code/5_2/@ppackages@sdocutils@srstast.nim.o \
c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_6/@ppackages@sdocutils@srst.nim.o \
c_code/5_6/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@pxmltree.nim.o \
c_code/5_2/@puri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/5_6/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_6/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_6/@pbrowsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  arm)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@psystem@sexceptions.nim.c -o c_code/5_7/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sdigitsutils.nim.c -o c_code/2_7/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sassertions.nim.c -o c_code/5_7/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psystem@siterators.nim.c -o c_code/2_7/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@psystem@sdollars.nim.c -o c_code/5_7/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sdragonbox.nim.c -o c_code/2_7/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sschubfach.nim.c -o c_code/2_7/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sformatfloat.nim.c -o c_code/5_7/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@psystem.nim.c -o c_code/5_7/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pparseutils.nim.c -o c_code/5_7/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pmath.nim.c -o c_code/5_7/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@palgorithm.nim.c -o c_code/5_7/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@senumutils.nim.c -o c_code/2_7/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@punicode.nim.c -o c_code/5_7/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstrutils.nim.c -o c_code/5_7/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppathnorm.nim.c -o c_code/5_7/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@soserrors.nim.c -o c_code/5_7/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@ssyncio.nim.c -o c_code/5_7/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pposix.nim.c -o c_code/5_7/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@soscommon.nim.c -o c_code/5_7/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@sospaths2.nim.c -o c_code/5_7/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_7/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ptimes.nim.c -o c_code/5_7/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@sosfiles.nim.c -o c_code/5_7/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@sosdirs.nim.c -o c_code/5_7/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@senvvars.nim.c -o c_code/5_7/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_7/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@scmdline.nim.c -o c_code/5_7/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pos.nim.c -o c_code/5_7/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pparseopt.nim.c -o c_code/5_7/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@psequtils.nim.c -o c_code/2_7/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@phashes.nim.c -o c_code/5_7/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstrtabs.nim.c -o c_code/5_7/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ptables.nim.c -o c_code/5_7/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstrformat.nim.c -o c_code/5_7/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pterminal.nim.c -o c_code/5_7/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpathutils.nim.c -o c_code/5_7/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mropes.nim.c -o c_code/5_7/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlineinfos.nim.c -o c_code/5_7/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplatform.nim.c -o c_code/5_7/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mprefixmatches.nim.c -o c_code/5_7/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimpaths.nim.c -o c_code/5_7/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@psets.nim.c -o c_code/5_7/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sobjectdollar.nim.c -o c_code/2_7/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@pstd@sprivate@sglobs.nim.c -o c_code/2_7/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@moptions.nim.c -o c_code/5_7/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmsgs.nim.c -o c_code/5_7/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcondsyms.nim.c -o c_code/5_7/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mwordrecg.nim.c -o c_code/5_7/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@midents.nim.c -o c_code/5_7/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mint128.nim.c -o c_code/5_7/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mnodekinds.nim.c -o c_code/2_7/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mast.nim.c -o c_code/5_7/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mllstream.nim.c -o c_code/5_7/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimlexbase.nim.c -o c_code/5_7/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlexer.nim.c -o c_code/5_7/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrenderer.nim.c -o c_code/5_7/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulepaths.nim.c -o c_code/5_7/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstreams.nim.c -o c_code/5_7/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pcpuinfo.nim.c -o c_code/5_7/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pdeques.nim.c -o c_code/5_7/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@posproc.nim.c -o c_code/5_7/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@plexbase.nim.c -o c_code/5_7/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pparsejson.nim.c -o c_code/5_7/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pjson.nim.c -o c_code/5_7/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@sjsonutils.nim.c -o c_code/5_7/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mextccomp.nim.c -o c_code/5_7/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimblecmd.nim.c -o c_code/5_7/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcommands.nim.c -o c_code/5_7/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mparser.nim.c -o c_code/5_7/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mfilters.nim.c -o c_code/5_7/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mfilter_tmpl.nim.c -o c_code/5_7/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msyntaxes.nim.c -o c_code/5_7/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrodutils.nim.c -o c_code/5_7/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@spackedsets.nim.c -o c_code/5_7/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastyaml.nim.c -o c_code/5_7/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastalgo.nim.c -o c_code/5_7/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtrees.nim.c -o c_code/5_7/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mbtrees.nim.c -o c_code/5_7/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpackages.nim.c -o c_code/5_7/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msuggestsymdb.nim.c -o c_code/5_7/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@srodfiles.nim.c -o c_code/5_7/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sbitabs.nim.c -o c_code/5_7/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@siclineinfos.nim.c -o c_code/5_7/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@spacked_ast.nim.c -o c_code/5_7/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sic.nim.c -o c_code/5_7/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodulegraphs.nim.c -o c_code/5_7/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmagicsys.nim.c -o c_code/5_7/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_7/@mbitsets.nim.c -o c_code/2_7/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mastmsgs.nim.c -o c_code/5_7/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypes.nim.c -o c_code/5_7/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimsets.nim.c -o c_code/5_7/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgendata.nim.c -o c_code/5_7/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmangleutils.nim.c -o c_code/5_7/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mccgutils.nim.c -o c_code/5_7/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtreetab.nim.c -o c_code/5_7/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msaturate.nim.c -o c_code/5_7/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mguards.nim.c -o c_code/5_7/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemfold.nim.c -o c_code/5_7/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdef.nim.c -o c_code/5_7/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlayeredtable.nim.c -o c_code/5_7/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlowerings.nim.c -o c_code/5_7/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mparampatterns.nim.c -o c_code/5_7/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemdata.nim.c -o c_code/5_7/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypeallowed.nim.c -o c_code/5_7/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@misolation_check.nim.c -o c_code/5_7/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvarpartitions.nim.c -o c_code/5_7/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnilcheck.nim.c -o c_code/5_7/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@merrorhandling.nim.c -o c_code/5_7/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@maliasanalysis.nim.c -o c_code/5_7/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemstrictfuncs.nim.c -o c_code/5_7/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pstd@seditdistance.nim.c -o c_code/5_7/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pheapqueue.nim.c -o c_code/5_7/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlookups.nim.c -o c_code/5_7/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlinter.nim.c -o c_code/5_7/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemtypinst.nim.c -o c_code/5_7/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mconcepts.nim.c -o c_code/5_7/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msigmatch.nim.c -o c_code/5_7/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpragmas.nim.c -o c_code/5_7/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpushpoppragmas.nim.c -o c_code/5_7/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msighashes.nim.c -o c_code/5_7/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mliftdestructors.nim.c -o c_code/5_7/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msempass2.nim.c -o c_code/5_7/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgmeth.nim.c -o c_code/5_7/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@maliases.nim.c -o c_code/5_7/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mliftlocals.nim.c -o c_code/5_7/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mlambdalifting.nim.c -o c_code/5_7/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mclosureiters.nim.c -o c_code/5_7/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtransf.nim.c -o c_code/5_7/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@moptimizer.nim.c -o c_code/5_7/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdfa.nim.c -o c_code/5_7/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@minjectdestructors.nim.c -o c_code/5_7/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mexpanddefaults.nim.c -o c_code/5_7/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpipelineutils.nim.c -o c_code/5_7/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mspawn.nim.c -o c_code/5_7/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemparallel.nim.c -o c_code/5_7/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pdynlib.nim.c -o c_code/5_7/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcgen.nim.c -o c_code/5_7/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmodules.nim.c -o c_code/5_7/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msemmacrosanity.nim.c -o c_code/5_7/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmgen.nim.c -o c_code/5_7/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmdeps.nim.c -o c_code/5_7/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mgorgeimpl.nim.c -o c_code/5_7/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmacrocacheimpl.nim.c -o c_code/5_7/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmprofiler.nim.c -o c_code/5_7/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mevaltempl.nim.c -o c_code/5_7/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmconv.nim.c -o c_code/5_7/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvmmarshal.nim.c -o c_code/5_7/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvm.nim.c -o c_code/5_7/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mimporter.nim.c -o c_code/5_7/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mprocfind.nim.c -o c_code/5_7/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpatterns.nim.c -o c_code/5_7/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpluginsupport.nim.c -o c_code/5_7/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@slocals.nim.c -o c_code/5_7/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@sitersgen.nim.c -o c_code/5_7/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mplugins@sactive.nim.c -o c_code/5_7/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@menumtostr.nim.c -o c_code/5_7/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mvtables.nim.c -o c_code/5_7/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msem.nim.c -o c_code/5_7/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mreorder.nim.c -o c_code/5_7/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdepends.nim.c -o c_code/5_7/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@msourcemap.nim.c -o c_code/5_7/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mjsgen.nim.c -o c_code/5_7/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@plists.nim.c -o c_code/5_7/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@srstast.nim.c -o c_code/5_7/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_7/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_7/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_7/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@srst.nim.c -o c_code/5_7/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_7/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mtypesrenderer.nim.c -o c_code/5_7/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mrenderverbatim.nim.c -o c_code/5_7/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pxmltree.nim.c -o c_code/5_7/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@puri.nim.c -o c_code/5_7/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen.nim.c -o c_code/5_7/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mdocgen2.nim.c -o c_code/5_7/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sreplayer.nim.c -o c_code/5_7/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mpipelines.nim.c -o c_code/5_7/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mscriptconfig.nim.c -o c_code/5_7/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnimconf.nim.c -o c_code/5_7/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sdce.nim.c -o c_code/5_7/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@scbackend.nim.c -o c_code/5_7/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@sintegrity.nim.c -o c_code/5_7/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mic@snavigator.nim.c -o c_code/5_7/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mmain.nim.c -o c_code/5_7/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mcmdlinehelper.nim.c -o c_code/5_7/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@pbrowsers.nim.c -o c_code/5_7/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_7/@mnim.nim.c -o c_code/5_7/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_7/@psystem@sexceptions.nim.o \
c_code/2_7/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_7/@pstd@sassertions.nim.o \
c_code/2_7/@psystem@siterators.nim.o \
c_code/5_7/@psystem@sdollars.nim.o \
c_code/2_7/@pstd@sprivate@sdragonbox.nim.o \
c_code/2_7/@pstd@sprivate@sschubfach.nim.o \
c_code/5_7/@pstd@sformatfloat.nim.o \
c_code/5_7/@psystem.nim.o \
c_code/5_7/@pparseutils.nim.o \
c_code/5_7/@pmath.nim.o \
c_code/5_7/@palgorithm.nim.o \
c_code/2_7/@pstd@senumutils.nim.o \
c_code/5_7/@punicode.nim.o \
c_code/5_7/@pstrutils.nim.o \
c_code/5_7/@ppathnorm.nim.o \
c_code/5_7/@pstd@soserrors.nim.o \
c_code/5_7/@pstd@ssyncio.nim.o \
c_code/5_7/@pposix.nim.o \
c_code/5_7/@pstd@sprivate@soscommon.nim.o \
c_code/5_7/@pstd@sprivate@sospaths2.nim.o \
c_code/5_7/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_7/@ptimes.nim.o \
c_code/5_7/@pstd@sprivate@sosfiles.nim.o \
c_code/5_7/@pstd@sprivate@sosdirs.nim.o \
c_code/5_7/@pstd@senvvars.nim.o \
c_code/5_7/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_7/@pstd@scmdline.nim.o \
c_code/5_7/@pos.nim.o \
c_code/5_7/@pparseopt.nim.o \
c_code/2_7/@psequtils.nim.o \
c_code/5_7/@phashes.nim.o \
c_code/5_7/@pstrtabs.nim.o \
c_code/5_7/@ptables.nim.o \
c_code/5_7/@pstrformat.nim.o \
c_code/5_7/@pterminal.nim.o \
c_code/5_7/@mpathutils.nim.o \
c_code/5_7/@mropes.nim.o \
c_code/5_7/@mlineinfos.nim.o \
c_code/5_7/@mplatform.nim.o \
c_code/5_7/@mprefixmatches.nim.o \
c_code/5_7/@mnimpaths.nim.o \
c_code/5_7/@psets.nim.o \
c_code/2_7/@pstd@sobjectdollar.nim.o \
c_code/2_7/@pstd@sprivate@sglobs.nim.o \
c_code/5_7/@moptions.nim.o \
c_code/5_7/@mmsgs.nim.o \
c_code/5_7/@mcondsyms.nim.o \
c_code/5_7/@mwordrecg.nim.o \
c_code/5_7/@midents.nim.o \
c_code/5_7/@mint128.nim.o \
c_code/2_7/@mnodekinds.nim.o \
c_code/5_7/@mast.nim.o \
c_code/5_7/@mllstream.nim.o \
c_code/5_7/@mnimlexbase.nim.o \
c_code/5_7/@mlexer.nim.o \
c_code/5_7/@mrenderer.nim.o \
c_code/5_7/@mmodulepaths.nim.o \
c_code/5_7/@pstreams.nim.o \
c_code/5_7/@pcpuinfo.nim.o \
c_code/5_7/@pdeques.nim.o \
c_code/5_7/@posproc.nim.o \
c_code/5_7/@plexbase.nim.o \
c_code/5_7/@pparsejson.nim.o \
c_code/5_7/@pjson.nim.o \
c_code/5_7/@pstd@sjsonutils.nim.o \
c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_7/@mextccomp.nim.o \
c_code/5_7/@mnimblecmd.nim.o \
c_code/5_7/@mcommands.nim.o \
c_code/5_7/@mparser.nim.o \
c_code/5_7/@mfilters.nim.o \
c_code/5_7/@mfilter_tmpl.nim.o \
c_code/5_7/@msyntaxes.nim.o \
c_code/5_7/@mrodutils.nim.o \
c_code/5_7/@pstd@spackedsets.nim.o \
c_code/5_7/@mastyaml.nim.o \
c_code/5_7/@mastalgo.nim.o \
c_code/5_7/@mtrees.nim.o \
c_code/5_7/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_7/@mbtrees.nim.o \
c_code/5_7/@mpackages.nim.o \
c_code/5_7/@msuggestsymdb.nim.o \
c_code/5_7/@mic@srodfiles.nim.o \
c_code/5_7/@mic@sbitabs.nim.o \
c_code/5_7/@mic@siclineinfos.nim.o \
c_code/5_7/@mic@spacked_ast.nim.o \
c_code/5_7/@mic@sic.nim.o \
c_code/5_7/@mmodulegraphs.nim.o \
c_code/5_7/@mmagicsys.nim.o \
c_code/2_7/@mbitsets.nim.o \
c_code/5_7/@mastmsgs.nim.o \
c_code/5_7/@mtypes.nim.o \
c_code/5_7/@mnimsets.nim.o \
c_code/5_7/@mcgendata.nim.o \
c_code/5_7/@mmangleutils.nim.o \
c_code/5_7/@mccgutils.nim.o \
c_code/5_7/@mtreetab.nim.o \
c_code/5_7/@msaturate.nim.o \
c_code/5_7/@mguards.nim.o \
c_code/5_7/@msemfold.nim.o \
c_code/5_7/@mvmdef.nim.o \
c_code/5_7/@mlayeredtable.nim.o \
c_code/5_7/@mlowerings.nim.o \
c_code/5_7/@mparampatterns.nim.o \
c_code/5_7/@msemdata.nim.o \
c_code/5_7/@mtypeallowed.nim.o \
c_code/5_7/@misolation_check.nim.o \
c_code/5_7/@mvarpartitions.nim.o \
c_code/5_7/@mnilcheck.nim.o \
c_code/5_7/@merrorhandling.nim.o \
c_code/5_7/@maliasanalysis.nim.o \
c_code/5_7/@msemstrictfuncs.nim.o \
c_code/5_7/@pstd@seditdistance.nim.o \
c_code/5_7/@pheapqueue.nim.o \
c_code/5_7/@mlookups.nim.o \
c_code/5_7/@mlinter.nim.o \
c_code/5_7/@msemtypinst.nim.o \
c_code/5_7/@mconcepts.nim.o \
c_code/5_7/@msigmatch.nim.o \
c_code/5_7/@mpragmas.nim.o \
c_code/5_7/@mpushpoppragmas.nim.o \
c_code/5_7/@msighashes.nim.o \
c_code/5_7/@mliftdestructors.nim.o \
c_code/5_7/@msempass2.nim.o \
c_code/5_7/@mcgmeth.nim.o \
c_code/5_7/@maliases.nim.o \
c_code/5_7/@mliftlocals.nim.o \
c_code/5_7/@mlambdalifting.nim.o \
c_code/5_7/@mclosureiters.nim.o \
c_code/5_7/@mtransf.nim.o \
c_code/5_7/@moptimizer.nim.o \
c_code/5_7/@mdfa.nim.o \
c_code/5_7/@minjectdestructors.nim.o \
c_code/5_7/@mexpanddefaults.nim.o \
c_code/5_7/@mpipelineutils.nim.o \
c_code/5_7/@mspawn.nim.o \
c_code/5_7/@msemparallel.nim.o \
c_code/5_7/@pdynlib.nim.o \
c_code/5_7/@mcgen.nim.o \
c_code/5_7/@mmodules.nim.o \
c_code/5_7/@msemmacrosanity.nim.o \
c_code/5_7/@mvmgen.nim.o \
c_code/5_7/@mvmdeps.nim.o \
c_code/5_7/@mgorgeimpl.nim.o \
c_code/5_7/@mmacrocacheimpl.nim.o \
c_code/5_7/@mvmprofiler.nim.o \
c_code/5_7/@mevaltempl.nim.o \
c_code/5_7/@mvmconv.nim.o \
c_code/5_7/@mvmmarshal.nim.o \
c_code/5_7/@mvm.nim.o \
c_code/5_7/@mimporter.nim.o \
c_code/5_7/@mprocfind.nim.o \
c_code/5_7/@mpatterns.nim.o \
c_code/5_7/@mpluginsupport.nim.o \
c_code/5_7/@mplugins@slocals.nim.o \
c_code/5_7/@mplugins@sitersgen.nim.o \
c_code/5_7/@mplugins@sactive.nim.o \
c_code/5_7/@menumtostr.nim.o \
c_code/5_7/@mvtables.nim.o \
c_code/5_7/@msem.nim.o \
c_code/5_7/@mreorder.nim.o \
c_code/5_7/@mdepends.nim.o \
c_code/5_7/@msourcemap.nim.o \
c_code/5_7/@mjsgen.nim.o \
c_code/5_7/@plists.nim.o \
c_code/5_7/@ppackages@sdocutils@srstast.nim.o \
c_code/5_7/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_7/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_7/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_7/@ppackages@sdocutils@srst.nim.o \
c_code/5_7/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_7/@mtypesrenderer.nim.o \
c_code/5_7/@mrenderverbatim.nim.o \
c_code/5_7/@pxmltree.nim.o \
c_code/5_7/@puri.nim.o \
c_code/5_7/@mdocgen.nim.o \
c_code/5_7/@mdocgen2.nim.o \
c_code/5_7/@mic@sreplayer.nim.o \
c_code/5_7/@mpipelines.nim.o \
c_code/5_7/@mscriptconfig.nim.o \
c_code/5_7/@mnimconf.nim.o \
c_code/5_7/@mic@sdce.nim.o \
c_code/5_7/@mic@scbackend.nim.o \
c_code/5_7/@mic@sintegrity.nim.o \
c_code/5_7/@mic@snavigator.nim.o \
c_code/5_7/@mmain.nim.o \
c_code/5_7/@mcmdlinehelper.nim.o \
c_code/5_7/@pbrowsers.nim.o \
c_code/5_7/@mnim.nim.o $LINK_FLAGS
    ;;
  sparc)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  sparc64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem@sexceptions.nim.c -o c_code/5_6/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sassertions.nim.c -o c_code/5_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sdollars.nim.c -o c_code/5_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sformatfloat.nim.c -o c_code/5_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem.nim.c -o c_code/5_6/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseutils.nim.c -o c_code/5_6/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pmath.nim.c -o c_code/5_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@palgorithm.nim.c -o c_code/5_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@punicode.nim.c -o c_code/5_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrutils.nim.c -o c_code/5_6/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppathnorm.nim.c -o c_code/5_6/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@soserrors.nim.c -o c_code/5_6/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@ssyncio.nim.c -o c_code/5_6/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pposix.nim.c -o c_code/5_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@soscommon.nim.c -o c_code/5_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sospaths2.nim.c -o c_code/5_6/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptimes.nim.c -o c_code/5_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosfiles.nim.c -o c_code/5_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sosdirs.nim.c -o c_code/5_6/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@senvvars.nim.c -o c_code/5_6/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@scmdline.nim.c -o c_code/5_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pos.nim.c -o c_code/5_6/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseopt.nim.c -o c_code/5_6/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@phashes.nim.c -o c_code/5_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrtabs.nim.c -o c_code/5_6/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ptables.nim.c -o c_code/5_6/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrformat.nim.c -o c_code/5_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pterminal.nim.c -o c_code/5_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_9/@mplatform.nim.c -o c_code/5_9/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psets.nim.c -o c_code/5_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstreams.nim.c -o c_code/5_6/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pcpuinfo.nim.c -o c_code/5_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdeques.nim.c -o c_code/5_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@posproc.nim.c -o c_code/5_6/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plexbase.nim.c -o c_code/5_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparsejson.nim.c -o c_code/5_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pjson.nim.c -o c_code/5_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sjsonutils.nim.c -o c_code/5_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@spackedsets.nim.c -o c_code/5_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@srodfiles.nim.c -o c_code/5_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlayeredtable.nim.c -o c_code/5_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@seditdistance.nim.c -o c_code/5_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pheapqueue.nim.c -o c_code/5_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pdynlib.nim.c -o c_code/5_6/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plists.nim.c -o c_code/5_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstast.nim.c -o c_code/5_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srst.nim.c -o c_code/5_6/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_6/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pxmltree.nim.c -o c_code/5_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@puri.nim.c -o c_code/5_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pbrowsers.nim.c -o c_code/5_6/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/5_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/5_2/@pstd@sformatfloat.nim.o \
c_code/5_6/@psystem.nim.o \
c_code/5_6/@pparseutils.nim.o \
c_code/5_2/@pmath.nim.o \
c_code/5_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/5_2/@punicode.nim.o \
c_code/5_6/@pstrutils.nim.o \
c_code/5_6/@ppathnorm.nim.o \
c_code/5_6/@pstd@soserrors.nim.o \
c_code/5_6/@pstd@ssyncio.nim.o \
c_code/5_2/@pposix.nim.o \
c_code/5_2/@pstd@sprivate@soscommon.nim.o \
c_code/5_6/@pstd@sprivate@sospaths2.nim.o \
c_code/5_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@ptimes.nim.o \
c_code/5_2/@pstd@sprivate@sosfiles.nim.o \
c_code/5_6/@pstd@sprivate@sosdirs.nim.o \
c_code/5_6/@pstd@senvvars.nim.o \
c_code/5_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@pstd@scmdline.nim.o \
c_code/5_6/@pos.nim.o \
c_code/5_6/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/5_6/@phashes.nim.o \
c_code/5_6/@pstrtabs.nim.o \
c_code/5_6/@ptables.nim.o \
c_code/5_2/@pstrformat.nim.o \
c_code/5_2/@pterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_9/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@pstreams.nim.o \
c_code/5_2/@pcpuinfo.nim.o \
c_code/5_2/@pdeques.nim.o \
c_code/5_6/@posproc.nim.o \
c_code/5_2/@plexbase.nim.o \
c_code/5_2/@pparsejson.nim.o \
c_code/5_2/@pjson.nim.o \
c_code/5_2/@pstd@sjsonutils.nim.o \
c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@pstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_6/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_2/@mlayeredtable.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@pstd@seditdistance.nim.o \
c_code/5_2/@pheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@pdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@plists.nim.o \
c_code/5_2/@ppackages@sdocutils@srstast.nim.o \
c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_6/@ppackages@sdocutils@srst.nim.o \
c_code/5_6/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@pxmltree.nim.o \
c_code/5_2/@puri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/5_6/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_6/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_6/@pbrowsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  s390x)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  m68k)
    set -x
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  $LINK_FLAGS
    ;;
  mips)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@psystem@sexceptions.nim.c -o c_code/5_12/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sassertions.nim.c -o c_code/5_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psystem@sdollars.nim.c -o c_code/5_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sformatfloat.nim.c -o c_code/5_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@psystem.nim.c -o c_code/5_12/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pparseutils.nim.c -o c_code/5_12/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pmath.nim.c -o c_code/5_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@palgorithm.nim.c -o c_code/5_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@punicode.nim.c -o c_code/5_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstrutils.nim.c -o c_code/5_12/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppathnorm.nim.c -o c_code/5_12/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@soserrors.nim.c -o c_code/5_12/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@ssyncio.nim.c -o c_code/5_12/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pposix.nim.c -o c_code/3_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@soscommon.nim.c -o c_code/5_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@sprivate@sospaths2.nim.c -o c_code/5_12/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ptimes.nim.c -o c_code/5_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosfiles.nim.c -o c_code/5_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@sprivate@sosdirs.nim.c -o c_code/5_12/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@senvvars.nim.c -o c_code/5_12/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@scmdline.nim.c -o c_code/5_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pos.nim.c -o c_code/5_12/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pparseopt.nim.c -o c_code/5_12/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@phashes.nim.c -o c_code/5_12/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstrtabs.nim.c -o c_code/5_12/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ptables.nim.c -o c_code/5_12/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstrformat.nim.c -o c_code/5_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pterminal.nim.c -o c_code/5_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mplatform.nim.c -o c_code/5_12/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psets.nim.c -o c_code/5_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@moptions.nim.c -o c_code/5_12/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmsgs.nim.c -o c_code/5_12/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mast.nim.c -o c_code/5_12/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mllstream.nim.c -o c_code/5_12/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlexer.nim.c -o c_code/5_12/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mrenderer.nim.c -o c_code/5_12/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstreams.nim.c -o c_code/5_12/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pcpuinfo.nim.c -o c_code/5_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pdeques.nim.c -o c_code/5_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@posproc.nim.c -o c_code/5_12/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plexbase.nim.c -o c_code/5_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pparsejson.nim.c -o c_code/5_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pjson.nim.c -o c_code/5_12/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sjsonutils.nim.c -o c_code/5_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_12/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mextccomp.nim.c -o c_code/5_12/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnimblecmd.nim.c -o c_code/5_12/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcommands.nim.c -o c_code/5_12/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mparser.nim.c -o c_code/5_12/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mfilter_tmpl.nim.c -o c_code/5_12/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msyntaxes.nim.c -o c_code/5_12/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@spackedsets.nim.c -o c_code/5_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mastalgo.nim.c -o c_code/5_12/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mbtrees.nim.c -o c_code/5_12/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@srodfiles.nim.c -o c_code/5_12/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sic.nim.c -o c_code/5_12/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmodulegraphs.nim.c -o c_code/5_12/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcgendata.nim.c -o c_code/5_12/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mguards.nim.c -o c_code/5_12/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemfold.nim.c -o c_code/5_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvmdef.nim.c -o c_code/5_12/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlayeredtable.nim.c -o c_code/5_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlowerings.nim.c -o c_code/5_12/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparampatterns.nim.c -o c_code/5_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemdata.nim.c -o c_code/5_12/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypeallowed.nim.c -o c_code/5_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@misolation_check.nim.c -o c_code/5_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvarpartitions.nim.c -o c_code/5_12/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnilcheck.nim.c -o c_code/5_12/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@merrorhandling.nim.c -o c_code/5_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliasanalysis.nim.c -o c_code/5_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemstrictfuncs.nim.c -o c_code/5_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@seditdistance.nim.c -o c_code/5_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pheapqueue.nim.c -o c_code/5_12/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlookups.nim.c -o c_code/5_12/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlinter.nim.c -o c_code/5_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemtypinst.nim.c -o c_code/5_12/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mconcepts.nim.c -o c_code/5_12/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msigmatch.nim.c -o c_code/5_12/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mpragmas.nim.c -o c_code/5_12/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpushpoppragmas.nim.c -o c_code/5_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msighashes.nim.c -o c_code/5_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mliftdestructors.nim.c -o c_code/5_12/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msempass2.nim.c -o c_code/5_12/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgmeth.nim.c -o c_code/5_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliases.nim.c -o c_code/5_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mliftlocals.nim.c -o c_code/5_12/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlambdalifting.nim.c -o c_code/5_12/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mclosureiters.nim.c -o c_code/5_12/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mtransf.nim.c -o c_code/5_12/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@moptimizer.nim.c -o c_code/5_12/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdfa.nim.c -o c_code/5_12/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@minjectdestructors.nim.c -o c_code/5_12/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mexpanddefaults.nim.c -o c_code/5_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelineutils.nim.c -o c_code/5_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mspawn.nim.c -o c_code/5_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemparallel.nim.c -o c_code/5_12/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pdynlib.nim.c -o c_code/5_12/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcgen.nim.c -o c_code/5_12/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodules.nim.c -o c_code/5_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemmacrosanity.nim.c -o c_code/5_12/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvmgen.nim.c -o c_code/5_12/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mgorgeimpl.nim.c -o c_code/5_12/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmacrocacheimpl.nim.c -o c_code/5_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmprofiler.nim.c -o c_code/5_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mevaltempl.nim.c -o c_code/5_12/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmconv.nim.c -o c_code/5_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmmarshal.nim.c -o c_code/5_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvm.nim.c -o c_code/5_12/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mimporter.nim.c -o c_code/5_12/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mprocfind.nim.c -o c_code/5_12/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mpatterns.nim.c -o c_code/5_12/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpluginsupport.nim.c -o c_code/5_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@slocals.nim.c -o c_code/5_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sitersgen.nim.c -o c_code/5_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sactive.nim.c -o c_code/5_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@menumtostr.nim.c -o c_code/5_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvtables.nim.c -o c_code/5_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msem.nim.c -o c_code/5_12/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mreorder.nim.c -o c_code/5_12/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdepends.nim.c -o c_code/5_12/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msourcemap.nim.c -o c_code/5_12/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mjsgen.nim.c -o c_code/5_12/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plists.nim.c -o c_code/5_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstast.nim.c -o c_code/5_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppackages@sdocutils@srst.nim.c -o c_code/5_12/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_12/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mtypesrenderer.nim.c -o c_code/5_12/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mrenderverbatim.nim.c -o c_code/5_12/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pxmltree.nim.c -o c_code/5_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@puri.nim.c -o c_code/5_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdocgen.nim.c -o c_code/5_12/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdocgen2.nim.c -o c_code/5_12/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sreplayer.nim.c -o c_code/5_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelines.nim.c -o c_code/5_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mscriptconfig.nim.c -o c_code/5_12/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnimconf.nim.c -o c_code/5_12/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sdce.nim.c -o c_code/5_12/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@scbackend.nim.c -o c_code/5_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sintegrity.nim.c -o c_code/5_12/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@snavigator.nim.c -o c_code/5_12/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmain.nim.c -o c_code/5_12/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcmdlinehelper.nim.c -o c_code/5_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pbrowsers.nim.c -o c_code/5_12/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnim.nim.c -o c_code/5_12/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_12/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/5_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/5_1/@pstd@sformatfloat.nim.o \
c_code/5_12/@psystem.nim.o \
c_code/5_12/@pparseutils.nim.o \
c_code/5_1/@pmath.nim.o \
c_code/5_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/5_1/@punicode.nim.o \
c_code/5_12/@pstrutils.nim.o \
c_code/5_12/@ppathnorm.nim.o \
c_code/5_12/@pstd@soserrors.nim.o \
c_code/5_12/@pstd@ssyncio.nim.o \
c_code/3_1/@pposix.nim.o \
c_code/5_1/@pstd@sprivate@soscommon.nim.o \
c_code/5_12/@pstd@sprivate@sospaths2.nim.o \
c_code/5_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_1/@ptimes.nim.o \
c_code/5_1/@pstd@sprivate@sosfiles.nim.o \
c_code/5_12/@pstd@sprivate@sosdirs.nim.o \
c_code/5_12/@pstd@senvvars.nim.o \
c_code/5_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_1/@pstd@scmdline.nim.o \
c_code/5_12/@pos.nim.o \
c_code/5_12/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/5_12/@phashes.nim.o \
c_code/5_12/@pstrtabs.nim.o \
c_code/5_12/@ptables.nim.o \
c_code/5_1/@pstrformat.nim.o \
c_code/5_1/@pterminal.nim.o \
c_code/5_1/@mpathutils.nim.o \
c_code/5_1/@mropes.nim.o \
c_code/5_1/@mlineinfos.nim.o \
c_code/5_12/@mplatform.nim.o \
c_code/5_1/@mprefixmatches.nim.o \
c_code/5_1/@mnimpaths.nim.o \
c_code/5_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/5_12/@moptions.nim.o \
c_code/5_12/@mmsgs.nim.o \
c_code/5_1/@mcondsyms.nim.o \
c_code/5_1/@mwordrecg.nim.o \
c_code/5_1/@midents.nim.o \
c_code/5_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/5_12/@mast.nim.o \
c_code/5_12/@mllstream.nim.o \
c_code/5_1/@mnimlexbase.nim.o \
c_code/5_12/@mlexer.nim.o \
c_code/5_12/@mrenderer.nim.o \
c_code/5_1/@mmodulepaths.nim.o \
c_code/5_12/@pstreams.nim.o \
c_code/5_1/@pcpuinfo.nim.o \
c_code/5_1/@pdeques.nim.o \
c_code/5_12/@posproc.nim.o \
c_code/5_1/@plexbase.nim.o \
c_code/5_1/@pparsejson.nim.o \
c_code/5_12/@pjson.nim.o \
c_code/5_1/@pstd@sjsonutils.nim.o \
c_code/5_12/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_12/@mextccomp.nim.o \
c_code/5_12/@mnimblecmd.nim.o \
c_code/5_12/@mcommands.nim.o \
c_code/5_12/@mparser.nim.o \
c_code/5_1/@mfilters.nim.o \
c_code/5_12/@mfilter_tmpl.nim.o \
c_code/5_12/@msyntaxes.nim.o \
c_code/5_1/@mrodutils.nim.o \
c_code/5_1/@pstd@spackedsets.nim.o \
c_code/5_1/@mastyaml.nim.o \
c_code/5_12/@mastalgo.nim.o \
c_code/5_1/@mtrees.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_12/@mbtrees.nim.o \
c_code/5_1/@mpackages.nim.o \
c_code/5_1/@msuggestsymdb.nim.o \
c_code/5_12/@mic@srodfiles.nim.o \
c_code/5_1/@mic@sbitabs.nim.o \
c_code/5_1/@mic@siclineinfos.nim.o \
c_code/5_1/@mic@spacked_ast.nim.o \
c_code/5_12/@mic@sic.nim.o \
c_code/5_12/@mmodulegraphs.nim.o \
c_code/5_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/5_1/@mastmsgs.nim.o \
c_code/5_1/@mtypes.nim.o \
c_code/5_1/@mnimsets.nim.o \
c_code/5_12/@mcgendata.nim.o \
c_code/5_1/@mmangleutils.nim.o \
c_code/5_1/@mccgutils.nim.o \
c_code/5_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/5_12/@mguards.nim.o \
c_code/5_1/@msemfold.nim.o \
c_code/5_12/@mvmdef.nim.o \
c_code/5_1/@mlayeredtable.nim.o \
c_code/5_12/@mlowerings.nim.o \
c_code/5_1/@mparampatterns.nim.o \
c_code/5_12/@msemdata.nim.o \
c_code/5_1/@mtypeallowed.nim.o \
c_code/5_1/@misolation_check.nim.o \
c_code/5_12/@mvarpartitions.nim.o \
c_code/5_12/@mnilcheck.nim.o \
c_code/5_1/@merrorhandling.nim.o \
c_code/5_1/@maliasanalysis.nim.o \
c_code/5_1/@msemstrictfuncs.nim.o \
c_code/5_1/@pstd@seditdistance.nim.o \
c_code/5_12/@pheapqueue.nim.o \
c_code/5_12/@mlookups.nim.o \
c_code/5_1/@mlinter.nim.o \
c_code/5_12/@msemtypinst.nim.o \
c_code/5_12/@mconcepts.nim.o \
c_code/5_12/@msigmatch.nim.o \
c_code/5_12/@mpragmas.nim.o \
c_code/5_1/@mpushpoppragmas.nim.o \
c_code/5_1/@msighashes.nim.o \
c_code/5_12/@mliftdestructors.nim.o \
c_code/5_12/@msempass2.nim.o \
c_code/5_1/@mcgmeth.nim.o \
c_code/5_1/@maliases.nim.o \
c_code/5_12/@mliftlocals.nim.o \
c_code/5_12/@mlambdalifting.nim.o \
c_code/5_12/@mclosureiters.nim.o \
c_code/5_12/@mtransf.nim.o \
c_code/5_12/@moptimizer.nim.o \
c_code/5_12/@mdfa.nim.o \
c_code/5_12/@minjectdestructors.nim.o \
c_code/5_1/@mexpanddefaults.nim.o \
c_code/5_1/@mpipelineutils.nim.o \
c_code/5_1/@mspawn.nim.o \
c_code/5_12/@msemparallel.nim.o \
c_code/5_12/@pdynlib.nim.o \
c_code/5_12/@mcgen.nim.o \
c_code/5_1/@mmodules.nim.o \
c_code/5_12/@msemmacrosanity.nim.o \
c_code/5_12/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/5_12/@mgorgeimpl.nim.o \
c_code/5_1/@mmacrocacheimpl.nim.o \
c_code/5_1/@mvmprofiler.nim.o \
c_code/5_12/@mevaltempl.nim.o \
c_code/5_1/@mvmconv.nim.o \
c_code/5_1/@mvmmarshal.nim.o \
c_code/5_12/@mvm.nim.o \
c_code/5_12/@mimporter.nim.o \
c_code/5_12/@mprocfind.nim.o \
c_code/5_12/@mpatterns.nim.o \
c_code/5_1/@mpluginsupport.nim.o \
c_code/5_1/@mplugins@slocals.nim.o \
c_code/5_1/@mplugins@sitersgen.nim.o \
c_code/5_1/@mplugins@sactive.nim.o \
c_code/5_1/@menumtostr.nim.o \
c_code/5_1/@mvtables.nim.o \
c_code/5_12/@msem.nim.o \
c_code/5_12/@mreorder.nim.o \
c_code/5_12/@mdepends.nim.o \
c_code/5_12/@msourcemap.nim.o \
c_code/5_12/@mjsgen.nim.o \
c_code/5_1/@plists.nim.o \
c_code/5_1/@ppackages@sdocutils@srstast.nim.o \
c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_12/@ppackages@sdocutils@srst.nim.o \
c_code/5_12/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_12/@mtypesrenderer.nim.o \
c_code/5_12/@mrenderverbatim.nim.o \
c_code/5_1/@pxmltree.nim.o \
c_code/5_1/@puri.nim.o \
c_code/5_12/@mdocgen.nim.o \
c_code/5_12/@mdocgen2.nim.o \
c_code/5_1/@mic@sreplayer.nim.o \
c_code/5_1/@mpipelines.nim.o \
c_code/5_12/@mscriptconfig.nim.o \
c_code/5_12/@mnimconf.nim.o \
c_code/5_12/@mic@sdce.nim.o \
c_code/5_1/@mic@scbackend.nim.o \
c_code/5_12/@mic@sintegrity.nim.o \
c_code/5_12/@mic@snavigator.nim.o \
c_code/5_12/@mmain.nim.o \
c_code/5_1/@mcmdlinehelper.nim.o \
c_code/5_12/@pbrowsers.nim.o \
c_code/5_12/@mnim.nim.o $LINK_FLAGS
    ;;
  mipsel)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@psystem@sexceptions.nim.c -o c_code/5_12/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sassertions.nim.c -o c_code/5_1/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psystem@siterators.nim.c -o c_code/1_1/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psystem@sdollars.nim.c -o c_code/5_1/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_1/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sprivate@sschubfach.nim.c -o c_code/1_1/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sformatfloat.nim.c -o c_code/5_1/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@psystem.nim.c -o c_code/5_12/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pparseutils.nim.c -o c_code/5_12/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pmath.nim.c -o c_code/5_1/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@palgorithm.nim.c -o c_code/5_1/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@senumutils.nim.c -o c_code/1_1/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@punicode.nim.c -o c_code/5_1/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstrutils.nim.c -o c_code/5_12/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppathnorm.nim.c -o c_code/5_12/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@soserrors.nim.c -o c_code/5_12/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@ssyncio.nim.c -o c_code/5_12/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/3_1/@pposix.nim.c -o c_code/3_1/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@soscommon.nim.c -o c_code/5_1/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@sprivate@sospaths2.nim.c -o c_code/5_12/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_1/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ptimes.nim.c -o c_code/5_1/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosfiles.nim.c -o c_code/5_1/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@sprivate@sosdirs.nim.c -o c_code/5_12/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstd@senvvars.nim.c -o c_code/5_12/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_1/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@scmdline.nim.c -o c_code/5_1/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pos.nim.c -o c_code/5_12/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pparseopt.nim.c -o c_code/5_12/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@psequtils.nim.c -o c_code/1_1/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@phashes.nim.c -o c_code/5_1/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstrtabs.nim.c -o c_code/5_12/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ptables.nim.c -o c_code/5_12/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstrformat.nim.c -o c_code/5_1/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pterminal.nim.c -o c_code/5_1/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpathutils.nim.c -o c_code/5_1/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mropes.nim.c -o c_code/5_1/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlineinfos.nim.c -o c_code/5_1/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_13/@mplatform.nim.c -o c_code/5_13/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mprefixmatches.nim.c -o c_code/5_1/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimpaths.nim.c -o c_code/5_1/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@psets.nim.c -o c_code/5_1/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@pstd@sobjectdollar.nim.c -o c_code/1_1/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@pstd@sprivate@sglobs.nim.c -o c_code/2_1/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@moptions.nim.c -o c_code/5_12/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmsgs.nim.c -o c_code/5_12/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcondsyms.nim.c -o c_code/5_1/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mwordrecg.nim.c -o c_code/5_1/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@midents.nim.c -o c_code/5_1/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mint128.nim.c -o c_code/5_1/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mnodekinds.nim.c -o c_code/1_1/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mast.nim.c -o c_code/5_12/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mllstream.nim.c -o c_code/5_12/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimlexbase.nim.c -o c_code/5_1/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlexer.nim.c -o c_code/5_12/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mrenderer.nim.c -o c_code/5_12/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodulepaths.nim.c -o c_code/5_1/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pstreams.nim.c -o c_code/5_12/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pcpuinfo.nim.c -o c_code/5_1/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pdeques.nim.c -o c_code/5_1/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@posproc.nim.c -o c_code/5_12/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plexbase.nim.c -o c_code/5_1/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pparsejson.nim.c -o c_code/5_1/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pjson.nim.c -o c_code/5_12/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@sjsonutils.nim.c -o c_code/5_1/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mextccomp.nim.c -o c_code/5_12/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnimblecmd.nim.c -o c_code/5_12/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcommands.nim.c -o c_code/5_12/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mparser.nim.c -o c_code/5_12/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mfilters.nim.c -o c_code/5_1/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mfilter_tmpl.nim.c -o c_code/5_12/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msyntaxes.nim.c -o c_code/5_12/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mrodutils.nim.c -o c_code/5_1/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@spackedsets.nim.c -o c_code/5_1/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastyaml.nim.c -o c_code/5_1/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mastalgo.nim.c -o c_code/5_12/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtrees.nim.c -o c_code/5_1/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mbtrees.nim.c -o c_code/5_12/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpackages.nim.c -o c_code/5_1/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msuggestsymdb.nim.c -o c_code/5_1/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_13/@mic@srodfiles.nim.c -o c_code/5_13/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sbitabs.nim.c -o c_code/5_1/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@siclineinfos.nim.c -o c_code/5_1/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@spacked_ast.nim.c -o c_code/5_1/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sic.nim.c -o c_code/5_12/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmodulegraphs.nim.c -o c_code/5_12/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmagicsys.nim.c -o c_code/5_1/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_1/@mbitsets.nim.c -o c_code/1_1/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mastmsgs.nim.c -o c_code/5_1/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypes.nim.c -o c_code/5_1/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mnimsets.nim.c -o c_code/5_1/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcgendata.nim.c -o c_code/5_12/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmangleutils.nim.c -o c_code/5_1/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mccgutils.nim.c -o c_code/5_1/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtreetab.nim.c -o c_code/5_1/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_1/@msaturate.nim.c -o c_code/2_1/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mguards.nim.c -o c_code/5_12/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemfold.nim.c -o c_code/5_1/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvmdef.nim.c -o c_code/5_12/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlayeredtable.nim.c -o c_code/5_1/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlowerings.nim.c -o c_code/5_12/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mparampatterns.nim.c -o c_code/5_1/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemdata.nim.c -o c_code/5_12/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mtypeallowed.nim.c -o c_code/5_1/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@misolation_check.nim.c -o c_code/5_1/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvarpartitions.nim.c -o c_code/5_12/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnilcheck.nim.c -o c_code/5_12/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@merrorhandling.nim.c -o c_code/5_1/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliasanalysis.nim.c -o c_code/5_1/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msemstrictfuncs.nim.c -o c_code/5_1/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pstd@seditdistance.nim.c -o c_code/5_1/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pheapqueue.nim.c -o c_code/5_12/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlookups.nim.c -o c_code/5_12/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mlinter.nim.c -o c_code/5_1/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemtypinst.nim.c -o c_code/5_12/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mconcepts.nim.c -o c_code/5_12/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msigmatch.nim.c -o c_code/5_12/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mpragmas.nim.c -o c_code/5_12/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpushpoppragmas.nim.c -o c_code/5_1/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@msighashes.nim.c -o c_code/5_1/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mliftdestructors.nim.c -o c_code/5_12/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msempass2.nim.c -o c_code/5_12/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcgmeth.nim.c -o c_code/5_1/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@maliases.nim.c -o c_code/5_1/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mliftlocals.nim.c -o c_code/5_12/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mlambdalifting.nim.c -o c_code/5_12/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mclosureiters.nim.c -o c_code/5_12/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mtransf.nim.c -o c_code/5_12/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@moptimizer.nim.c -o c_code/5_12/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdfa.nim.c -o c_code/5_12/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@minjectdestructors.nim.c -o c_code/5_12/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mexpanddefaults.nim.c -o c_code/5_1/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelineutils.nim.c -o c_code/5_1/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mspawn.nim.c -o c_code/5_1/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemparallel.nim.c -o c_code/5_12/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pdynlib.nim.c -o c_code/5_12/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mcgen.nim.c -o c_code/5_12/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmodules.nim.c -o c_code/5_1/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msemmacrosanity.nim.c -o c_code/5_12/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvmgen.nim.c -o c_code/5_12/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmdeps.nim.c -o c_code/5_1/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mgorgeimpl.nim.c -o c_code/5_12/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mmacrocacheimpl.nim.c -o c_code/5_1/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmprofiler.nim.c -o c_code/5_1/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mevaltempl.nim.c -o c_code/5_12/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmconv.nim.c -o c_code/5_1/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvmmarshal.nim.c -o c_code/5_1/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mvm.nim.c -o c_code/5_12/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mimporter.nim.c -o c_code/5_12/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mprocfind.nim.c -o c_code/5_12/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mpatterns.nim.c -o c_code/5_12/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpluginsupport.nim.c -o c_code/5_1/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@slocals.nim.c -o c_code/5_1/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sitersgen.nim.c -o c_code/5_1/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mplugins@sactive.nim.c -o c_code/5_1/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@menumtostr.nim.c -o c_code/5_1/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mvtables.nim.c -o c_code/5_1/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msem.nim.c -o c_code/5_12/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mreorder.nim.c -o c_code/5_12/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdepends.nim.c -o c_code/5_12/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@msourcemap.nim.c -o c_code/5_12/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mjsgen.nim.c -o c_code/5_12/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@plists.nim.c -o c_code/5_1/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstast.nim.c -o c_code/5_1/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_1/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_1/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppackages@sdocutils@srst.nim.c -o c_code/5_12/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_12/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mtypesrenderer.nim.c -o c_code/5_12/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mrenderverbatim.nim.c -o c_code/5_12/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@pxmltree.nim.c -o c_code/5_1/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@puri.nim.c -o c_code/5_1/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdocgen.nim.c -o c_code/5_12/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mdocgen2.nim.c -o c_code/5_12/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@sreplayer.nim.c -o c_code/5_1/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mpipelines.nim.c -o c_code/5_1/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mscriptconfig.nim.c -o c_code/5_12/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnimconf.nim.c -o c_code/5_12/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sdce.nim.c -o c_code/5_12/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mic@scbackend.nim.c -o c_code/5_1/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@sintegrity.nim.c -o c_code/5_12/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mic@snavigator.nim.c -o c_code/5_12/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mmain.nim.c -o c_code/5_12/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_1/@mcmdlinehelper.nim.c -o c_code/5_1/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@pbrowsers.nim.c -o c_code/5_12/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_12/@mnim.nim.c -o c_code/5_12/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_12/@psystem@sexceptions.nim.o \
c_code/1_1/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_1/@pstd@sassertions.nim.o \
c_code/1_1/@psystem@siterators.nim.o \
c_code/5_1/@psystem@sdollars.nim.o \
c_code/1_1/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_1/@pstd@sprivate@sschubfach.nim.o \
c_code/5_1/@pstd@sformatfloat.nim.o \
c_code/5_12/@psystem.nim.o \
c_code/5_12/@pparseutils.nim.o \
c_code/5_1/@pmath.nim.o \
c_code/5_1/@palgorithm.nim.o \
c_code/1_1/@pstd@senumutils.nim.o \
c_code/5_1/@punicode.nim.o \
c_code/5_12/@pstrutils.nim.o \
c_code/5_12/@ppathnorm.nim.o \
c_code/5_12/@pstd@soserrors.nim.o \
c_code/5_12/@pstd@ssyncio.nim.o \
c_code/3_1/@pposix.nim.o \
c_code/5_1/@pstd@sprivate@soscommon.nim.o \
c_code/5_12/@pstd@sprivate@sospaths2.nim.o \
c_code/5_1/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_1/@ptimes.nim.o \
c_code/5_1/@pstd@sprivate@sosfiles.nim.o \
c_code/5_12/@pstd@sprivate@sosdirs.nim.o \
c_code/5_12/@pstd@senvvars.nim.o \
c_code/5_1/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_1/@pstd@scmdline.nim.o \
c_code/5_12/@pos.nim.o \
c_code/5_12/@pparseopt.nim.o \
c_code/1_1/@psequtils.nim.o \
c_code/5_1/@phashes.nim.o \
c_code/5_12/@pstrtabs.nim.o \
c_code/5_12/@ptables.nim.o \
c_code/5_1/@pstrformat.nim.o \
c_code/5_1/@pterminal.nim.o \
c_code/5_1/@mpathutils.nim.o \
c_code/5_1/@mropes.nim.o \
c_code/5_1/@mlineinfos.nim.o \
c_code/5_13/@mplatform.nim.o \
c_code/5_1/@mprefixmatches.nim.o \
c_code/5_1/@mnimpaths.nim.o \
c_code/5_1/@psets.nim.o \
c_code/1_1/@pstd@sobjectdollar.nim.o \
c_code/2_1/@pstd@sprivate@sglobs.nim.o \
c_code/5_12/@moptions.nim.o \
c_code/5_12/@mmsgs.nim.o \
c_code/5_1/@mcondsyms.nim.o \
c_code/5_1/@mwordrecg.nim.o \
c_code/5_1/@midents.nim.o \
c_code/5_1/@mint128.nim.o \
c_code/1_1/@mnodekinds.nim.o \
c_code/5_12/@mast.nim.o \
c_code/5_12/@mllstream.nim.o \
c_code/5_1/@mnimlexbase.nim.o \
c_code/5_12/@mlexer.nim.o \
c_code/5_12/@mrenderer.nim.o \
c_code/5_1/@mmodulepaths.nim.o \
c_code/5_12/@pstreams.nim.o \
c_code/5_1/@pcpuinfo.nim.o \
c_code/5_1/@pdeques.nim.o \
c_code/5_12/@posproc.nim.o \
c_code/5_1/@plexbase.nim.o \
c_code/5_1/@pparsejson.nim.o \
c_code/5_12/@pjson.nim.o \
c_code/5_1/@pstd@sjsonutils.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_12/@mextccomp.nim.o \
c_code/5_12/@mnimblecmd.nim.o \
c_code/5_12/@mcommands.nim.o \
c_code/5_12/@mparser.nim.o \
c_code/5_1/@mfilters.nim.o \
c_code/5_12/@mfilter_tmpl.nim.o \
c_code/5_12/@msyntaxes.nim.o \
c_code/5_1/@mrodutils.nim.o \
c_code/5_1/@pstd@spackedsets.nim.o \
c_code/5_1/@mastyaml.nim.o \
c_code/5_12/@mastalgo.nim.o \
c_code/5_1/@mtrees.nim.o \
c_code/5_1/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_12/@mbtrees.nim.o \
c_code/5_1/@mpackages.nim.o \
c_code/5_1/@msuggestsymdb.nim.o \
c_code/5_13/@mic@srodfiles.nim.o \
c_code/5_1/@mic@sbitabs.nim.o \
c_code/5_1/@mic@siclineinfos.nim.o \
c_code/5_1/@mic@spacked_ast.nim.o \
c_code/5_12/@mic@sic.nim.o \
c_code/5_12/@mmodulegraphs.nim.o \
c_code/5_1/@mmagicsys.nim.o \
c_code/1_1/@mbitsets.nim.o \
c_code/5_1/@mastmsgs.nim.o \
c_code/5_1/@mtypes.nim.o \
c_code/5_1/@mnimsets.nim.o \
c_code/5_12/@mcgendata.nim.o \
c_code/5_1/@mmangleutils.nim.o \
c_code/5_1/@mccgutils.nim.o \
c_code/5_1/@mtreetab.nim.o \
c_code/2_1/@msaturate.nim.o \
c_code/5_12/@mguards.nim.o \
c_code/5_1/@msemfold.nim.o \
c_code/5_12/@mvmdef.nim.o \
c_code/5_1/@mlayeredtable.nim.o \
c_code/5_12/@mlowerings.nim.o \
c_code/5_1/@mparampatterns.nim.o \
c_code/5_12/@msemdata.nim.o \
c_code/5_1/@mtypeallowed.nim.o \
c_code/5_1/@misolation_check.nim.o \
c_code/5_12/@mvarpartitions.nim.o \
c_code/5_12/@mnilcheck.nim.o \
c_code/5_1/@merrorhandling.nim.o \
c_code/5_1/@maliasanalysis.nim.o \
c_code/5_1/@msemstrictfuncs.nim.o \
c_code/5_1/@pstd@seditdistance.nim.o \
c_code/5_12/@pheapqueue.nim.o \
c_code/5_12/@mlookups.nim.o \
c_code/5_1/@mlinter.nim.o \
c_code/5_12/@msemtypinst.nim.o \
c_code/5_12/@mconcepts.nim.o \
c_code/5_12/@msigmatch.nim.o \
c_code/5_12/@mpragmas.nim.o \
c_code/5_1/@mpushpoppragmas.nim.o \
c_code/5_1/@msighashes.nim.o \
c_code/5_12/@mliftdestructors.nim.o \
c_code/5_12/@msempass2.nim.o \
c_code/5_1/@mcgmeth.nim.o \
c_code/5_1/@maliases.nim.o \
c_code/5_12/@mliftlocals.nim.o \
c_code/5_12/@mlambdalifting.nim.o \
c_code/5_12/@mclosureiters.nim.o \
c_code/5_12/@mtransf.nim.o \
c_code/5_12/@moptimizer.nim.o \
c_code/5_12/@mdfa.nim.o \
c_code/5_12/@minjectdestructors.nim.o \
c_code/5_1/@mexpanddefaults.nim.o \
c_code/5_1/@mpipelineutils.nim.o \
c_code/5_1/@mspawn.nim.o \
c_code/5_12/@msemparallel.nim.o \
c_code/5_12/@pdynlib.nim.o \
c_code/5_12/@mcgen.nim.o \
c_code/5_1/@mmodules.nim.o \
c_code/5_12/@msemmacrosanity.nim.o \
c_code/5_12/@mvmgen.nim.o \
c_code/5_1/@mvmdeps.nim.o \
c_code/5_12/@mgorgeimpl.nim.o \
c_code/5_1/@mmacrocacheimpl.nim.o \
c_code/5_1/@mvmprofiler.nim.o \
c_code/5_12/@mevaltempl.nim.o \
c_code/5_1/@mvmconv.nim.o \
c_code/5_1/@mvmmarshal.nim.o \
c_code/5_12/@mvm.nim.o \
c_code/5_12/@mimporter.nim.o \
c_code/5_12/@mprocfind.nim.o \
c_code/5_12/@mpatterns.nim.o \
c_code/5_1/@mpluginsupport.nim.o \
c_code/5_1/@mplugins@slocals.nim.o \
c_code/5_1/@mplugins@sitersgen.nim.o \
c_code/5_1/@mplugins@sactive.nim.o \
c_code/5_1/@menumtostr.nim.o \
c_code/5_1/@mvtables.nim.o \
c_code/5_12/@msem.nim.o \
c_code/5_12/@mreorder.nim.o \
c_code/5_12/@mdepends.nim.o \
c_code/5_12/@msourcemap.nim.o \
c_code/5_12/@mjsgen.nim.o \
c_code/5_1/@plists.nim.o \
c_code/5_1/@ppackages@sdocutils@srstast.nim.o \
c_code/5_1/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_1/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_1/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_12/@ppackages@sdocutils@srst.nim.o \
c_code/5_12/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_12/@mtypesrenderer.nim.o \
c_code/5_12/@mrenderverbatim.nim.o \
c_code/5_1/@pxmltree.nim.o \
c_code/5_1/@puri.nim.o \
c_code/5_12/@mdocgen.nim.o \
c_code/5_12/@mdocgen2.nim.o \
c_code/5_1/@mic@sreplayer.nim.o \
c_code/5_1/@mpipelines.nim.o \
c_code/5_12/@mscriptconfig.nim.o \
c_code/5_12/@mnimconf.nim.o \
c_code/5_12/@mic@sdce.nim.o \
c_code/5_1/@mic@scbackend.nim.o \
c_code/5_12/@mic@sintegrity.nim.o \
c_code/5_12/@mic@snavigator.nim.o \
c_code/5_12/@mmain.nim.o \
c_code/5_1/@mcmdlinehelper.nim.o \
c_code/5_12/@pbrowsers.nim.o \
c_code/5_12/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem@sexceptions.nim.c -o c_code/5_6/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sassertions.nim.c -o c_code/5_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sdollars.nim.c -o c_code/5_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sformatfloat.nim.c -o c_code/5_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem.nim.c -o c_code/5_6/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseutils.nim.c -o c_code/5_6/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pmath.nim.c -o c_code/5_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@palgorithm.nim.c -o c_code/5_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@punicode.nim.c -o c_code/5_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrutils.nim.c -o c_code/5_6/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppathnorm.nim.c -o c_code/5_6/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@soserrors.nim.c -o c_code/5_6/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@ssyncio.nim.c -o c_code/5_6/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pposix.nim.c -o c_code/5_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@soscommon.nim.c -o c_code/5_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sospaths2.nim.c -o c_code/5_6/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptimes.nim.c -o c_code/5_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosfiles.nim.c -o c_code/5_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sosdirs.nim.c -o c_code/5_6/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@senvvars.nim.c -o c_code/5_6/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@scmdline.nim.c -o c_code/5_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pos.nim.c -o c_code/5_6/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseopt.nim.c -o c_code/5_6/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@phashes.nim.c -o c_code/5_6/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrtabs.nim.c -o c_code/5_6/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ptables.nim.c -o c_code/5_6/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrformat.nim.c -o c_code/5_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pterminal.nim.c -o c_code/5_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_14/@mplatform.nim.c -o c_code/5_14/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psets.nim.c -o c_code/5_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstreams.nim.c -o c_code/5_6/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pcpuinfo.nim.c -o c_code/5_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdeques.nim.c -o c_code/5_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@posproc.nim.c -o c_code/5_6/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plexbase.nim.c -o c_code/5_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparsejson.nim.c -o c_code/5_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pjson.nim.c -o c_code/5_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sjsonutils.nim.c -o c_code/5_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@spackedsets.nim.c -o c_code/5_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@srodfiles.nim.c -o c_code/5_6/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlayeredtable.nim.c -o c_code/5_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@seditdistance.nim.c -o c_code/5_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pheapqueue.nim.c -o c_code/5_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pdynlib.nim.c -o c_code/5_6/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plists.nim.c -o c_code/5_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstast.nim.c -o c_code/5_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srst.nim.c -o c_code/5_6/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_6/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pxmltree.nim.c -o c_code/5_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@puri.nim.c -o c_code/5_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pbrowsers.nim.c -o c_code/5_6/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/5_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/5_2/@pstd@sformatfloat.nim.o \
c_code/5_6/@psystem.nim.o \
c_code/5_6/@pparseutils.nim.o \
c_code/5_2/@pmath.nim.o \
c_code/5_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/5_2/@punicode.nim.o \
c_code/5_6/@pstrutils.nim.o \
c_code/5_6/@ppathnorm.nim.o \
c_code/5_6/@pstd@soserrors.nim.o \
c_code/5_6/@pstd@ssyncio.nim.o \
c_code/5_2/@pposix.nim.o \
c_code/5_2/@pstd@sprivate@soscommon.nim.o \
c_code/5_6/@pstd@sprivate@sospaths2.nim.o \
c_code/5_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@ptimes.nim.o \
c_code/5_2/@pstd@sprivate@sosfiles.nim.o \
c_code/5_6/@pstd@sprivate@sosdirs.nim.o \
c_code/5_6/@pstd@senvvars.nim.o \
c_code/5_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@pstd@scmdline.nim.o \
c_code/5_6/@pos.nim.o \
c_code/5_6/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/5_6/@phashes.nim.o \
c_code/5_6/@pstrtabs.nim.o \
c_code/5_6/@ptables.nim.o \
c_code/5_2/@pstrformat.nim.o \
c_code/5_2/@pterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_14/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@pstreams.nim.o \
c_code/5_2/@pcpuinfo.nim.o \
c_code/5_2/@pdeques.nim.o \
c_code/5_6/@posproc.nim.o \
c_code/5_2/@plexbase.nim.o \
c_code/5_2/@pparsejson.nim.o \
c_code/5_2/@pjson.nim.o \
c_code/5_2/@pstd@sjsonutils.nim.o \
c_code/5_6/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@pstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_6/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_2/@mlayeredtable.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@pstd@seditdistance.nim.o \
c_code/5_2/@pheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@pdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@plists.nim.o \
c_code/5_2/@ppackages@sdocutils@srstast.nim.o \
c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_6/@ppackages@sdocutils@srst.nim.o \
c_code/5_6/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@pxmltree.nim.o \
c_code/5_2/@puri.nim.o \
c_code/5_6/@mdocgen.nim.o \
c_code/5_2/@mdocgen2.nim.o \
c_code/5_2/@mic@sreplayer.nim.o \
c_code/5_2/@mpipelines.nim.o \
c_code/5_6/@mscriptconfig.nim.o \
c_code/5_6/@mnimconf.nim.o \
c_code/5_2/@mic@sdce.nim.o \
c_code/5_2/@mic@scbackend.nim.o \
c_code/5_2/@mic@sintegrity.nim.o \
c_code/5_2/@mic@snavigator.nim.o \
c_code/5_6/@mmain.nim.o \
c_code/5_2/@mcmdlinehelper.nim.o \
c_code/5_6/@pbrowsers.nim.o \
c_code/5_6/@mnim.nim.o $LINK_FLAGS
    ;;
  mips64el)
    set -x
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem@sexceptions.nim.c -o c_code/5_6/@psystem@sexceptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdigitsutils.nim.c -o c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sassertions.nim.c -o c_code/5_2/@pstd@sassertions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psystem@siterators.nim.c -o c_code/1_2/@psystem@siterators.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psystem@sdollars.nim.c -o c_code/5_2/@psystem@sdollars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sdragonbox.nim.c -o c_code/1_2/@pstd@sprivate@sdragonbox.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sprivate@sschubfach.nim.c -o c_code/1_2/@pstd@sprivate@sschubfach.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sformatfloat.nim.c -o c_code/5_2/@pstd@sformatfloat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@psystem.nim.c -o c_code/5_6/@psystem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseutils.nim.c -o c_code/5_6/@pparseutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pmath.nim.c -o c_code/5_2/@pmath.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@palgorithm.nim.c -o c_code/5_2/@palgorithm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@senumutils.nim.c -o c_code/1_2/@pstd@senumutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@punicode.nim.c -o c_code/5_2/@punicode.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrutils.nim.c -o c_code/5_6/@pstrutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppathnorm.nim.c -o c_code/5_6/@ppathnorm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@soserrors.nim.c -o c_code/5_6/@pstd@soserrors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@ssyncio.nim.c -o c_code/5_6/@pstd@ssyncio.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pposix.nim.c -o c_code/5_2/@pposix.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@soscommon.nim.c -o c_code/5_2/@pstd@sprivate@soscommon.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sospaths2.nim.c -o c_code/5_6/@pstd@sprivate@sospaths2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sossymlinks.nim.c -o c_code/5_2/@pstd@sprivate@sossymlinks.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ptimes.nim.c -o c_code/5_2/@ptimes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosfiles.nim.c -o c_code/5_2/@pstd@sprivate@sosfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@sprivate@sosdirs.nim.c -o c_code/5_6/@pstd@sprivate@sosdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstd@senvvars.nim.c -o c_code/5_6/@pstd@senvvars.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sprivate@sosappdirs.nim.c -o c_code/5_2/@pstd@sprivate@sosappdirs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@scmdline.nim.c -o c_code/5_2/@pstd@scmdline.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pos.nim.c -o c_code/5_6/@pos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pparseopt.nim.c -o c_code/5_6/@pparseopt.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@psequtils.nim.c -o c_code/1_2/@psequtils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@phashes.nim.c -o c_code/5_2/@phashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstrtabs.nim.c -o c_code/5_6/@pstrtabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ptables.nim.c -o c_code/5_6/@ptables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstrformat.nim.c -o c_code/5_2/@pstrformat.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pterminal.nim.c -o c_code/5_2/@pterminal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpathutils.nim.c -o c_code/5_2/@mpathutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mropes.nim.c -o c_code/5_2/@mropes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlineinfos.nim.c -o c_code/5_2/@mlineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_15/@mplatform.nim.c -o c_code/5_15/@mplatform.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprefixmatches.nim.c -o c_code/5_2/@mprefixmatches.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimpaths.nim.c -o c_code/5_2/@mnimpaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@psets.nim.c -o c_code/5_2/@psets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@pstd@sobjectdollar.nim.c -o c_code/1_2/@pstd@sobjectdollar.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@pstd@sprivate@sglobs.nim.c -o c_code/2_2/@pstd@sprivate@sglobs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@moptions.nim.c -o c_code/5_6/@moptions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmsgs.nim.c -o c_code/5_6/@mmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcondsyms.nim.c -o c_code/5_2/@mcondsyms.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mwordrecg.nim.c -o c_code/5_2/@mwordrecg.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@midents.nim.c -o c_code/5_2/@midents.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mint128.nim.c -o c_code/5_2/@mint128.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mnodekinds.nim.c -o c_code/1_2/@mnodekinds.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mast.nim.c -o c_code/5_2/@mast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mllstream.nim.c -o c_code/5_6/@mllstream.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimlexbase.nim.c -o c_code/5_2/@mnimlexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mlexer.nim.c -o c_code/5_6/@mlexer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mrenderer.nim.c -o c_code/5_6/@mrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulepaths.nim.c -o c_code/5_2/@mmodulepaths.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pstreams.nim.c -o c_code/5_6/@pstreams.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pcpuinfo.nim.c -o c_code/5_2/@pcpuinfo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pdeques.nim.c -o c_code/5_2/@pdeques.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@posproc.nim.c -o c_code/5_6/@posproc.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plexbase.nim.c -o c_code/5_2/@plexbase.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pparsejson.nim.c -o c_code/5_2/@pparsejson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pjson.nim.c -o c_code/5_2/@pjson.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@sjsonutils.nim.c -o c_code/5_2/@pstd@sjsonutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mextccomp.nim.c -o c_code/5_6/@mextccomp.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimblecmd.nim.c -o c_code/5_6/@mnimblecmd.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcommands.nim.c -o c_code/5_6/@mcommands.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mparser.nim.c -o c_code/5_6/@mparser.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mfilters.nim.c -o c_code/5_2/@mfilters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mfilter_tmpl.nim.c -o c_code/5_6/@mfilter_tmpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msyntaxes.nim.c -o c_code/5_6/@msyntaxes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrodutils.nim.c -o c_code/5_2/@mrodutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@spackedsets.nim.c -o c_code/5_2/@pstd@spackedsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastyaml.nim.c -o c_code/5_2/@mastyaml.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastalgo.nim.c -o c_code/5_2/@mastalgo.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtrees.nim.c -o c_code/5_2/@mtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.c -o c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mbtrees.nim.c -o c_code/5_2/@mbtrees.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpackages.nim.c -o c_code/5_2/@mpackages.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msuggestsymdb.nim.c -o c_code/5_2/@msuggestsymdb.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@srodfiles.nim.c -o c_code/5_2/@mic@srodfiles.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sbitabs.nim.c -o c_code/5_2/@mic@sbitabs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@siclineinfos.nim.c -o c_code/5_2/@mic@siclineinfos.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@spacked_ast.nim.c -o c_code/5_2/@mic@spacked_ast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mic@sic.nim.c -o c_code/5_6/@mic@sic.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodulegraphs.nim.c -o c_code/5_2/@mmodulegraphs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmagicsys.nim.c -o c_code/5_2/@mmagicsys.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/1_2/@mbitsets.nim.c -o c_code/1_2/@mbitsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mastmsgs.nim.c -o c_code/5_2/@mastmsgs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypes.nim.c -o c_code/5_2/@mtypes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnimsets.nim.c -o c_code/5_2/@mnimsets.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgendata.nim.c -o c_code/5_2/@mcgendata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmangleutils.nim.c -o c_code/5_2/@mmangleutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mccgutils.nim.c -o c_code/5_2/@mccgutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtreetab.nim.c -o c_code/5_2/@mtreetab.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/2_2/@msaturate.nim.c -o c_code/2_2/@msaturate.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mguards.nim.c -o c_code/5_2/@mguards.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemfold.nim.c -o c_code/5_2/@msemfold.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvmdef.nim.c -o c_code/5_6/@mvmdef.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlayeredtable.nim.c -o c_code/5_2/@mlayeredtable.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlowerings.nim.c -o c_code/5_2/@mlowerings.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mparampatterns.nim.c -o c_code/5_2/@mparampatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msemdata.nim.c -o c_code/5_6/@msemdata.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtypeallowed.nim.c -o c_code/5_2/@mtypeallowed.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@misolation_check.nim.c -o c_code/5_2/@misolation_check.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvarpartitions.nim.c -o c_code/5_2/@mvarpartitions.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mnilcheck.nim.c -o c_code/5_2/@mnilcheck.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@merrorhandling.nim.c -o c_code/5_2/@merrorhandling.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliasanalysis.nim.c -o c_code/5_2/@maliasanalysis.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemstrictfuncs.nim.c -o c_code/5_2/@msemstrictfuncs.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pstd@seditdistance.nim.c -o c_code/5_2/@pstd@seditdistance.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pheapqueue.nim.c -o c_code/5_2/@pheapqueue.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlookups.nim.c -o c_code/5_2/@mlookups.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlinter.nim.c -o c_code/5_2/@mlinter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemtypinst.nim.c -o c_code/5_2/@msemtypinst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mconcepts.nim.c -o c_code/5_2/@mconcepts.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msigmatch.nim.c -o c_code/5_6/@msigmatch.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mpragmas.nim.c -o c_code/5_6/@mpragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpushpoppragmas.nim.c -o c_code/5_2/@mpushpoppragmas.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msighashes.nim.c -o c_code/5_2/@msighashes.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftdestructors.nim.c -o c_code/5_2/@mliftdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msempass2.nim.c -o c_code/5_2/@msempass2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcgmeth.nim.c -o c_code/5_2/@mcgmeth.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@maliases.nim.c -o c_code/5_2/@maliases.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mliftlocals.nim.c -o c_code/5_2/@mliftlocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mlambdalifting.nim.c -o c_code/5_2/@mlambdalifting.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mclosureiters.nim.c -o c_code/5_2/@mclosureiters.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mtransf.nim.c -o c_code/5_2/@mtransf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@moptimizer.nim.c -o c_code/5_2/@moptimizer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdfa.nim.c -o c_code/5_2/@mdfa.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@minjectdestructors.nim.c -o c_code/5_6/@minjectdestructors.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mexpanddefaults.nim.c -o c_code/5_2/@mexpanddefaults.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelineutils.nim.c -o c_code/5_2/@mpipelineutils.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mspawn.nim.c -o c_code/5_2/@mspawn.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemparallel.nim.c -o c_code/5_2/@msemparallel.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pdynlib.nim.c -o c_code/5_6/@pdynlib.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mcgen.nim.c -o c_code/5_6/@mcgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmodules.nim.c -o c_code/5_2/@mmodules.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@msemmacrosanity.nim.c -o c_code/5_2/@msemmacrosanity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmgen.nim.c -o c_code/5_2/@mvmgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmdeps.nim.c -o c_code/5_2/@mvmdeps.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mgorgeimpl.nim.c -o c_code/5_6/@mgorgeimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mmacrocacheimpl.nim.c -o c_code/5_2/@mmacrocacheimpl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmprofiler.nim.c -o c_code/5_2/@mvmprofiler.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mevaltempl.nim.c -o c_code/5_2/@mevaltempl.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmconv.nim.c -o c_code/5_2/@mvmconv.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvmmarshal.nim.c -o c_code/5_2/@mvmmarshal.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mvm.nim.c -o c_code/5_6/@mvm.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mimporter.nim.c -o c_code/5_2/@mimporter.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mprocfind.nim.c -o c_code/5_2/@mprocfind.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpatterns.nim.c -o c_code/5_2/@mpatterns.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpluginsupport.nim.c -o c_code/5_2/@mpluginsupport.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@slocals.nim.c -o c_code/5_2/@mplugins@slocals.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sitersgen.nim.c -o c_code/5_2/@mplugins@sitersgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mplugins@sactive.nim.c -o c_code/5_2/@mplugins@sactive.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@menumtostr.nim.c -o c_code/5_2/@menumtostr.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mvtables.nim.c -o c_code/5_2/@mvtables.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msem.nim.c -o c_code/5_6/@msem.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mreorder.nim.c -o c_code/5_6/@mreorder.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdepends.nim.c -o c_code/5_6/@mdepends.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@msourcemap.nim.c -o c_code/5_6/@msourcemap.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mjsgen.nim.c -o c_code/5_6/@mjsgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@plists.nim.c -o c_code/5_2/@plists.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstast.nim.c -o c_code/5_2/@ppackages@sdocutils@srstast.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.c -o c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@srstidx.nim.c -o c_code/5_2/@ppackages@sdocutils@srstidx.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@ppackages@sdocutils@shighlite.nim.c -o c_code/5_2/@ppackages@sdocutils@shighlite.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srst.nim.c -o c_code/5_6/@ppackages@sdocutils@srst.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@ppackages@sdocutils@srstgen.nim.c -o c_code/5_6/@ppackages@sdocutils@srstgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mtypesrenderer.nim.c -o c_code/5_6/@mtypesrenderer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mrenderverbatim.nim.c -o c_code/5_2/@mrenderverbatim.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@pxmltree.nim.c -o c_code/5_2/@pxmltree.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@puri.nim.c -o c_code/5_2/@puri.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mdocgen.nim.c -o c_code/5_6/@mdocgen.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mdocgen2.nim.c -o c_code/5_2/@mdocgen2.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sreplayer.nim.c -o c_code/5_2/@mic@sreplayer.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mpipelines.nim.c -o c_code/5_2/@mpipelines.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mscriptconfig.nim.c -o c_code/5_6/@mscriptconfig.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnimconf.nim.c -o c_code/5_6/@mnimconf.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sdce.nim.c -o c_code/5_2/@mic@sdce.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@scbackend.nim.c -o c_code/5_2/@mic@scbackend.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@sintegrity.nim.c -o c_code/5_2/@mic@sintegrity.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mic@snavigator.nim.c -o c_code/5_2/@mic@snavigator.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mmain.nim.c -o c_code/5_6/@mmain.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_2/@mcmdlinehelper.nim.c -o c_code/5_2/@mcmdlinehelper.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@pbrowsers.nim.c -o c_code/5_6/@pbrowsers.nim.o
    $CC $COMP_FLAGS -Ic_code -c c_code/5_6/@mnim.nim.c -o c_code/5_6/@mnim.nim.o
    if [ "$parallel" -gt 0 ]; then
      sem --wait --id $$
    fi
    $CC -o $binDir/nim  \
c_code/5_6/@psystem@sexceptions.nim.o \
c_code/1_2/@pstd@sprivate@sdigitsutils.nim.o \
c_code/5_2/@pstd@sassertions.nim.o \
c_code/1_2/@psystem@siterators.nim.o \
c_code/5_2/@psystem@sdollars.nim.o \
c_code/1_2/@pstd@sprivate@sdragonbox.nim.o \
c_code/1_2/@pstd@sprivate@sschubfach.nim.o \
c_code/5_2/@pstd@sformatfloat.nim.o \
c_code/5_6/@psystem.nim.o \
c_code/5_6/@pparseutils.nim.o \
c_code/5_2/@pmath.nim.o \
c_code/5_2/@palgorithm.nim.o \
c_code/1_2/@pstd@senumutils.nim.o \
c_code/5_2/@punicode.nim.o \
c_code/5_6/@pstrutils.nim.o \
c_code/5_6/@ppathnorm.nim.o \
c_code/5_6/@pstd@soserrors.nim.o \
c_code/5_6/@pstd@ssyncio.nim.o \
c_code/5_2/@pposix.nim.o \
c_code/5_2/@pstd@sprivate@soscommon.nim.o \
c_code/5_6/@pstd@sprivate@sospaths2.nim.o \
c_code/5_2/@pstd@sprivate@sossymlinks.nim.o \
c_code/5_2/@ptimes.nim.o \
c_code/5_2/@pstd@sprivate@sosfiles.nim.o \
c_code/5_6/@pstd@sprivate@sosdirs.nim.o \
c_code/5_6/@pstd@senvvars.nim.o \
c_code/5_2/@pstd@sprivate@sosappdirs.nim.o \
c_code/5_2/@pstd@scmdline.nim.o \
c_code/5_6/@pos.nim.o \
c_code/5_6/@pparseopt.nim.o \
c_code/1_2/@psequtils.nim.o \
c_code/5_2/@phashes.nim.o \
c_code/5_6/@pstrtabs.nim.o \
c_code/5_6/@ptables.nim.o \
c_code/5_2/@pstrformat.nim.o \
c_code/5_2/@pterminal.nim.o \
c_code/5_2/@mpathutils.nim.o \
c_code/5_2/@mropes.nim.o \
c_code/5_2/@mlineinfos.nim.o \
c_code/5_15/@mplatform.nim.o \
c_code/5_2/@mprefixmatches.nim.o \
c_code/5_2/@mnimpaths.nim.o \
c_code/5_2/@psets.nim.o \
c_code/1_2/@pstd@sobjectdollar.nim.o \
c_code/2_2/@pstd@sprivate@sglobs.nim.o \
c_code/5_6/@moptions.nim.o \
c_code/5_6/@mmsgs.nim.o \
c_code/5_2/@mcondsyms.nim.o \
c_code/5_2/@mwordrecg.nim.o \
c_code/5_2/@midents.nim.o \
c_code/5_2/@mint128.nim.o \
c_code/1_2/@mnodekinds.nim.o \
c_code/5_2/@mast.nim.o \
c_code/5_6/@mllstream.nim.o \
c_code/5_2/@mnimlexbase.nim.o \
c_code/5_6/@mlexer.nim.o \
c_code/5_6/@mrenderer.nim.o \
c_code/5_2/@mmodulepaths.nim.o \
c_code/5_6/@pstreams.nim.o \
c_code/5_2/@pcpuinfo.nim.o \
c_code/5_2/@pdeques.nim.o \
c_code/5_6/@posproc.nim.o \
c_code/5_2/@plexbase.nim.o \
c_code/5_2/@pparsejson.nim.o \
c_code/5_2/@pjson.nim.o \
c_code/5_2/@pstd@sjsonutils.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@ssha1.nim.o \
c_code/5_6/@mextccomp.nim.o \
c_code/5_6/@mnimblecmd.nim.o \
c_code/5_6/@mcommands.nim.o \
c_code/5_6/@mparser.nim.o \
c_code/5_2/@mfilters.nim.o \
c_code/5_6/@mfilter_tmpl.nim.o \
c_code/5_6/@msyntaxes.nim.o \
c_code/5_2/@mrodutils.nim.o \
c_code/5_2/@pstd@spackedsets.nim.o \
c_code/5_2/@mastyaml.nim.o \
c_code/5_2/@mastalgo.nim.o \
c_code/5_2/@mtrees.nim.o \
c_code/5_2/@m..@sdist@schecksums@ssrc@schecksums@smd5.nim.o \
c_code/5_2/@mbtrees.nim.o \
c_code/5_2/@mpackages.nim.o \
c_code/5_2/@msuggestsymdb.nim.o \
c_code/5_2/@mic@srodfiles.nim.o \
c_code/5_2/@mic@sbitabs.nim.o \
c_code/5_2/@mic@siclineinfos.nim.o \
c_code/5_2/@mic@spacked_ast.nim.o \
c_code/5_6/@mic@sic.nim.o \
c_code/5_2/@mmodulegraphs.nim.o \
c_code/5_2/@mmagicsys.nim.o \
c_code/1_2/@mbitsets.nim.o \
c_code/5_2/@mastmsgs.nim.o \
c_code/5_2/@mtypes.nim.o \
c_code/5_2/@mnimsets.nim.o \
c_code/5_2/@mcgendata.nim.o \
c_code/5_2/@mmangleutils.nim.o \
c_code/5_2/@mccgutils.nim.o \
c_code/5_2/@mtreetab.nim.o \
c_code/2_2/@msaturate.nim.o \
c_code/5_2/@mguards.nim.o \
c_code/5_2/@msemfold.nim.o \
c_code/5_6/@mvmdef.nim.o \
c_code/5_2/@mlayeredtable.nim.o \
c_code/5_2/@mlowerings.nim.o \
c_code/5_2/@mparampatterns.nim.o \
c_code/5_6/@msemdata.nim.o \
c_code/5_2/@mtypeallowed.nim.o \
c_code/5_2/@misolation_check.nim.o \
c_code/5_2/@mvarpartitions.nim.o \
c_code/5_2/@mnilcheck.nim.o \
c_code/5_2/@merrorhandling.nim.o \
c_code/5_2/@maliasanalysis.nim.o \
c_code/5_2/@msemstrictfuncs.nim.o \
c_code/5_2/@pstd@seditdistance.nim.o \
c_code/5_2/@pheapqueue.nim.o \
c_code/5_2/@mlookups.nim.o \
c_code/5_2/@mlinter.nim.o \
c_code/5_2/@msemtypinst.nim.o \
c_code/5_2/@mconcepts.nim.o \
c_code/5_6/@msigmatch.nim.o \
c_code/5_6/@mpragmas.nim.o \
c_code/5_2/@mpushpoppragmas.nim.o \
c_code/5_2/@msighashes.nim.o \
c_code/5_2/@mliftdestructors.nim.o \
c_code/5_2/@msempass2.nim.o \
c_code/5_2/@mcgmeth.nim.o \
c_code/5_2/@maliases.nim.o \
c_code/5_2/@mliftlocals.nim.o \
c_code/5_2/@mlambdalifting.nim.o \
c_code/5_2/@mclosureiters.nim.o \
c_code/5_2/@mtransf.nim.o \
c_code/5_2/@moptimizer.nim.o \
c_code/5_2/@mdfa.nim.o \
c_code/5_6/@minjectdestructors.nim.o \
c_code/5_2/@mexpanddefaults.nim.o \
c_code/5_2/@mpipelineutils.nim.o \
c_code/5_2/@mspawn.nim.o \
c_code/5_2/@msemparallel.nim.o \
c_code/5_6/@pdynlib.nim.o \
c_code/5_6/@mcgen.nim.o \
c_code/5_2/@mmodules.nim.o \
c_code/5_2/@msemmacrosanity.nim.o \
c_code/5_2/@mvmgen.nim.o \
c_code/5_2/@mvmdeps.nim.o \
c_code/5_6/@mgorgeimpl.nim.o \
c_code/5_2/@mmacrocacheimpl.nim.o \
c_code/5_2/@mvmprofiler.nim.o \
c_code/5_2/@mevaltempl.nim.o \
c_code/5_2/@mvmconv.nim.o \
c_code/5_2/@mvmmarshal.nim.o \
c_code/5_6/@mvm.nim.o \
c_code/5_2/@mimporter.nim.o \
c_code/5_2/@mprocfind.nim.o \
c_code/5_2/@mpatterns.nim.o \
c_code/5_2/@mpluginsupport.nim.o \
c_code/5_2/@mplugins@slocals.nim.o \
c_code/5_2/@mplugins@sitersgen.nim.o \
c_code/5_2/@mplugins@sactive.nim.o \
c_code/5_2/@menumtostr.nim.o \
c_code/5_2/@mvtables.nim.o \
c_code/5_6/@msem.nim.o \
c_code/5_6/@mreorder.nim.o \
c_code/5_6/@mdepends.nim.o \
c_code/5_6/@msourcemap.nim.o \
c_code/5_6/@mjsgen.nim.o \
c_code/5_2/@plists.nim.o \
c_code/5_2/@ppackages@sdocutils@srstast.nim.o \
c_code/5_2/@ppackages@sdocutils@sdochelpers.nim.o \
c_code/5_2/@ppackages@sdocutils@srstidx.nim.o \
c_code/5_2/@ppackages@sdocutils@shighlite.nim.o \
c_code/5_6/@ppackages@sdocutils@srst.nim.o \
c_code/5_6/@ppackages@sdocutils@srstgen.nim.o \
c_code/5_6/@mtypesrenderer.nim.o \
c_code/5_2/@mrenderverbatim.nim.o \
c_code/5_2/@pxmltree.nim.o \
c_code/5_2/@puri.nim.o \
c_code/5