package sentences_test

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/17.0.0/ucd/auxiliary/SentenceBreakTest.txt

type unicodeTest struct {
	input    []byte
	expected [][]byte
	comment  string
}

var unicodeTests = [512]unicodeTest{
	{
		input:    []byte{0xd, 0xd},
		expected: [][]byte{{0xd}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa},
		expected: [][]byte{{0xd, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0x85},
		expected: [][]byte{{0xd}, {0xc2, 0x85}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x9},
		expected: [][]byte{{0xd}, {0x9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61},
		expected: [][]byte{{0xd}, {0x61}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x41},
		expected: [][]byte{{0xd}, {0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc6, 0xbb},
		expected: [][]byte{{0xd}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x30},
		expected: [][]byte{{0xd}, {0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2e},
		expected: [][]byte{{0xd}, {0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x21},
		expected: [][]byte{{0xd}, {0x21}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x22},
		expected: [][]byte{{0xd}, {0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2c},
		expected: [][]byte{{0xd}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x0},
		expected: [][]byte{{0xd}, {0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd},
		expected: [][]byte{{0xa}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xa},
		expected: [][]byte{{0xa}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0x85},
		expected: [][]byte{{0xa}, {0xc2, 0x85}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x9},
		expected: [][]byte{{0xa}, {0x9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61},
		expected: [][]byte{{0xa}, {0x61}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x41},
		expected: [][]byte{{0xa}, {0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc6, 0xbb},
		expected: [][]byte{{0xa}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x30},
		expected: [][]byte{{0xa}, {0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2e},
		expected: [][]byte{{0xa}, {0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x21},
		expected: [][]byte{{0xa}, {0x21}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x22},
		expected: [][]byte{{0xa}, {0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2c},
		expected: [][]byte{{0xa}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x0},
		expected: [][]byte{{0xa}, {0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0x85},
		expected: [][]byte{{0xcc, 0x80, 0xc2, 0x85}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x9},
		expected: [][]byte{{0xcc, 0x80, 0x9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61},
		expected: [][]byte{{0xcc, 0x80, 0x61}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x41},
		expected: [][]byte{{0xcc, 0x80, 0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc6, 0xbb},
		expected: [][]byte{{0xcc, 0x80, 0xc6, 0xbb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x30},
		expected: [][]byte{{0xcc, 0x80, 0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2e},
		expected: [][]byte{{0xcc, 0x80, 0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x21},
		expected: [][]byte{{0xcc, 0x80, 0x21}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x22},
		expected: [][]byte{{0xcc, 0x80, 0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x0},
		expected: [][]byte{{0xcc, 0x80, 0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xd},
		expected: [][]byte{{0xc2, 0xad, 0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xa},
		expected: [][]byte{{0xc2, 0xad, 0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc2, 0x85},
		expected: [][]byte{{0xc2, 0xad, 0xc2, 0x85}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x9},
		expected: [][]byte{{0xc2, 0xad, 0x9}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61},
		expected: [][]byte{{0xc2, 0xad, 0x61}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x41},
		expected: [][]byte{{0xc2, 0xad, 0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc6, 0xbb},
		expected: [][]byte{{0xc2, 0xad, 0xc6, 0xbb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x30},
		expected: [][]byte{{0xc2, 0xad, 0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2e},
		expected: [][]byte{{0xc2, 0xad, 0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x21},
		expected: [][]byte{{0xc2, 0xad, 0x21}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x22},
		expected: [][]byte{{0xc2, 0xad, 0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x0},
		expected: [][]byte{{0xc2, 0xad, 0x0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xd},
		expected: [][]byte{{0xc2, 0x85}, {0xd}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xa},
		expected: [][]byte{{0xc2, 0x85}, {0xa}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0x85}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xc2, 0x85},
		expected: [][]byte{{0xc2, 0x85}, {0xc2, 0x85}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x9},
		expected: [][]byte{{0xc2, 0x85}, {0x9}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x61},
		expected: [][]byte{{0xc2, 0x85}, {0x61}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x41},
		expected: [][]byte{{0xc2, 0x85}, {0x41}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xc6, 0xbb},
		expected: [][]byte{{0xc2, 0x85}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x30},
		expected: [][]byte{{0xc2, 0x85}, {0x30}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x2e},
		expected: [][]byte{{0xc2, 0x85}, {0x2e}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x21},
		expected: [][]byte{{0xc2, 0x85}, {0x21}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x22},
		expected: [][]byte{{0xc2, 0x85}, {0x22}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x2c},
		expected: [][]byte{{0xc2, 0x85}, {0x2c}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0x0},
		expected: [][]byte{{0xc2, 0x85}, {0x0}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0x85, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc2, 0x85}, {0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] <NEXT LINE (NEL)> (Sep) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xd},
		expected: [][]byte{{0x9, 0xd}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xa},
		expected: [][]byte{{0x9, 0xa}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x80},
		expected: [][]byte{{0x9, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xc2, 0xad},
		expected: [][]byte{{0x9, 0xc2, 0xad}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xc2, 0x85},
		expected: [][]byte{{0x9, 0xc2, 0x85}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x9},
		expected: [][]byte{{0x9, 0x9}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x61},
		expected: [][]byte{{0x9, 0x61}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x41},
		expected: [][]byte{{0x9, 0x41}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xc6, 0xbb},
		expected: [][]byte{{0x9, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x30},
		expected: [][]byte{{0x9, 0x30}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x2e},
		expected: [][]byte{{0x9, 0x2e}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x21},
		expected: [][]byte{{0x9, 0x21}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x22},
		expected: [][]byte{{0x9, 0x22}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x2c},
		expected: [][]byte{{0x9, 0x2c}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0x0},
		expected: [][]byte{{0x9, 0x0}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x9, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x9, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] <CHARACTER TABULATION> (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xd},
		expected: [][]byte{{0x61, 0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xa},
		expected: [][]byte{{0x61, 0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xc2, 0x85},
		expected: [][]byte{{0x61, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x9},
		expected: [][]byte{{0x61, 0x9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x61},
		expected: [][]byte{{0x61, 0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x41},
		expected: [][]byte{{0x61, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xc6, 0xbb},
		expected: [][]byte{{0x61, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x30},
		expected: [][]byte{{0x61, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e},
		expected: [][]byte{{0x61, 0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x21},
		expected: [][]byte{{0x61, 0x21}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x22},
		expected: [][]byte{{0x61, 0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c},
		expected: [][]byte{{0x61, 0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x0},
		expected: [][]byte{{0x61, 0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xd},
		expected: [][]byte{{0x41, 0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xa},
		expected: [][]byte{{0x41, 0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc2, 0x85},
		expected: [][]byte{{0x41, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x9},
		expected: [][]byte{{0x41, 0x9}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61},
		expected: [][]byte{{0x41, 0x61}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x41},
		expected: [][]byte{{0x41, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc6, 0xbb},
		expected: [][]byte{{0x41, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x30},
		expected: [][]byte{{0x41, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2e},
		expected: [][]byte{{0x41, 0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x21},
		expected: [][]byte{{0x41, 0x21}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x22},
		expected: [][]byte{{0x41, 0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2c},
		expected: [][]byte{{0x41, 0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x0},
		expected: [][]byte{{0x41, 0x0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xd},
		expected: [][]byte{{0xc6, 0xbb, 0xd}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xa},
		expected: [][]byte{{0xc6, 0xbb, 0xa}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x80},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xc2, 0xad},
		expected: [][]byte{{0xc6, 0xbb, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xc2, 0x85},
		expected: [][]byte{{0xc6, 0xbb, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x9},
		expected: [][]byte{{0xc6, 0xbb, 0x9}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x61},
		expected: [][]byte{{0xc6, 0xbb, 0x61}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x41},
		expected: [][]byte{{0xc6, 0xbb, 0x41}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xc6, 0xbb},
		expected: [][]byte{{0xc6, 0xbb, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x30},
		expected: [][]byte{{0xc6, 0xbb, 0x30}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x2e},
		expected: [][]byte{{0xc6, 0xbb, 0x2e}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x21},
		expected: [][]byte{{0xc6, 0xbb, 0x21}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x22},
		expected: [][]byte{{0xc6, 0xbb, 0x22}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x2c},
		expected: [][]byte{{0xc6, 0xbb, 0x2c}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0x0},
		expected: [][]byte{{0xc6, 0xbb, 0x0}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xc6, 0xbb, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0xc6, 0xbb, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] LATIN LETTER TWO WITH STROKE (OLetter) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xd},
		expected: [][]byte{{0x30, 0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xa},
		expected: [][]byte{{0x30, 0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc2, 0x85},
		expected: [][]byte{{0x30, 0xc2, 0x85}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x9},
		expected: [][]byte{{0x30, 0x9}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61},
		expected: [][]byte{{0x30, 0x61}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x41},
		expected: [][]byte{{0x30, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc6, 0xbb},
		expected: [][]byte{{0x30, 0xc6, 0xbb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x30},
		expected: [][]byte{{0x30, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2e},
		expected: [][]byte{{0x30, 0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x21},
		expected: [][]byte{{0x30, 0x21}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x22},
		expected: [][]byte{{0x30, 0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c},
		expected: [][]byte{{0x30, 0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x0},
		expected: [][]byte{{0x30, 0x0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xd},
		expected: [][]byte{{0x2e, 0xd}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xa},
		expected: [][]byte{{0x2e, 0xa}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc2, 0x85},
		expected: [][]byte{{0x2e, 0xc2, 0x85}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x9},
		expected: [][]byte{{0x2e, 0x9}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61},
		expected: [][]byte{{0x2e, 0x61}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x41},
		expected: [][]byte{{0x2e}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc6, 0xbb},
		expected: [][]byte{{0x2e}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] FULL STOP (ATerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x30},
		expected: [][]byte{{0x2e, 0x30}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [6.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2e},
		expected: [][]byte{{0x2e, 0x2e}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x21},
		expected: [][]byte{{0x2e, 0x21}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x22},
		expected: [][]byte{{0x2e, 0x22}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2c},
		expected: [][]byte{{0x2e, 0x2c}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [8.1] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x0},
		expected: [][]byte{{0x2e}, {0x0}},
		comment:  "÷ [0.2] FULL STOP (ATerm) ÷ [11.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] FULL STOP (ATerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xd},
		expected: [][]byte{{0x21, 0xd}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xa},
		expected: [][]byte{{0x21, 0xa}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x80},
		expected: [][]byte{{0x21, 0xcc, 0x80}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xc2, 0xad},
		expected: [][]byte{{0x21, 0xc2, 0xad}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xc2, 0x85},
		expected: [][]byte{{0x21, 0xc2, 0x85}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x9},
		expected: [][]byte{{0x21, 0x9}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x61},
		expected: [][]byte{{0x21}, {0x61}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x21, 0xcc, 0x88}, {0x61}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x41},
		expected: [][]byte{{0x21}, {0x41}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x21, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xc6, 0xbb},
		expected: [][]byte{{0x21}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x21, 0xcc, 0x88}, {0xc6, 0xbb}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x30},
		expected: [][]byte{{0x21}, {0x30}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x21, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x2e},
		expected: [][]byte{{0x21, 0x2e}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x21},
		expected: [][]byte{{0x21, 0x21}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x22},
		expected: [][]byte{{0x21, 0x22}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [9.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x2c},
		expected: [][]byte{{0x21, 0x2c}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [8.1] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x21, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) × [8.1] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x0},
		expected: [][]byte{{0x21}, {0x0}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) ÷ [11.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x21, 0xcc, 0x88}, {0x0}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xd},
		expected: [][]byte{{0x22, 0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xa},
		expected: [][]byte{{0x22, 0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc2, 0x85},
		expected: [][]byte{{0x22, 0xc2, 0x85}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x9},
		expected: [][]byte{{0x22, 0x9}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61},
		expected: [][]byte{{0x22, 0x61}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x41},
		expected: [][]byte{{0x22, 0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc6, 0xbb},
		expected: [][]byte{{0x22, 0xc6, 0xbb}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x30},
		expected: [][]byte{{0x22, 0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2e},
		expected: [][]byte{{0x22, 0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x21},
		expected: [][]byte{{0x22, 0x21}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x22},
		expected: [][]byte{{0x22, 0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2c},
		expected: [][]byte{{0x22, 0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x0},
		expected: [][]byte{{0x22, 0x0}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xd},
		expected: [][]byte{{0x2c, 0xd}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xa},
		expected: [][]byte{{0x2c, 0xa}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc2, 0x85},
		expected: [][]byte{{0x2c, 0xc2, 0x85}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x9},
		expected: [][]byte{{0x2c, 0x9}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61},
		expected: [][]byte{{0x2c, 0x61}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x41},
		expected: [][]byte{{0x2c, 0x41}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc6, 0xbb},
		expected: [][]byte{{0x2c, 0xc6, 0xbb}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x30},
		expected: [][]byte{{0x2c, 0x30}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2e},
		expected: [][]byte{{0x2c, 0x2e}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x21},
		expected: [][]byte{{0x2c, 0x21}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x22},
		expected: [][]byte{{0x2c, 0x22}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2c},
		expected: [][]byte{{0x2c, 0x2c}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x0},
		expected: [][]byte{{0x2c, 0x0}},
		comment:  "÷ [0.2] COMMA (SContinue) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] COMMA (SContinue) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xd},
		expected: [][]byte{{0x0, 0xd}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xd}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xa},
		expected: [][]byte{{0x0, 0xa}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xa}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x80},
		expected: [][]byte{{0x0, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] COMBINING GRAVE ACCENT (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc2, 0xad},
		expected: [][]byte{{0x0, 0xc2, 0xad}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] SOFT HYPHEN (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc2, 0x85},
		expected: [][]byte{{0x0, 0xc2, 0x85}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc2, 0x85},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xc2, 0x85}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NEXT LINE (NEL)> (Sep) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x9},
		expected: [][]byte{{0x0, 0x9}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x9},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x9}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <CHARACTER TABULATION> (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x61},
		expected: [][]byte{{0x0, 0x61}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x61},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x61}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x41},
		expected: [][]byte{{0x0, 0x41}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xc6, 0xbb},
		expected: [][]byte{{0x0, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0xc6, 0xbb},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0xc6, 0xbb}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN LETTER TWO WITH STROKE (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x30},
		expected: [][]byte{{0x0, 0x30}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x2e},
		expected: [][]byte{{0x0, 0x2e}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x2e}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x21},
		expected: [][]byte{{0x0, 0x21}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x21},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x21}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] EXCLAMATION MARK (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x22},
		expected: [][]byte{{0x0, 0x22}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x22}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] QUOTATION MARK (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x2c},
		expected: [][]byte{{0x0, 0x2c}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x2c}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] COMMA (SContinue) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0x0},
		expected: [][]byte{{0x0, 0x0}},
		comment:  "÷ [0.2] <NULL> (XX) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0x0, 0xcc, 0x88, 0x0},
		expected: [][]byte{{0x0, 0xcc, 0x88, 0x0}},
		comment:  "÷ [0.2] <NULL> (XX) × [5.0] COMBINING DIAERESIS (Extend) × [998.0] <NULL> (XX) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa, 0x61, 0xa, 0xcc, 0x88},
		expected: [][]byte{{0xd, 0xa}, {0x61, 0xa}, {0xcc, 0x88}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88},
		expected: [][]byte{{0x61, 0xcc, 0x88}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [5.0] COMBINING DIAERESIS (Extend) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86}},
		comment:  "÷ [0.2] SPACE (Sp) × [5.0] ZERO WIDTH JOINER (Extend) × [998.0] ARABIC LETTER NOON (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20}},
		comment:  "÷ [0.2] ARABIC LETTER NOON (OLetter) × [5.0] ZERO WIDTH JOINER (Extend) × [998.0] SPACE (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x28, 0x22, 0x47, 0x6f, 0x2e, 0x22, 0x29, 0x20, 0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29},
		expected: [][]byte{{0x28, 0x22, 0x47, 0x6f, 0x2e, 0x22, 0x29, 0x20}, {0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29}},
		comment:  "÷ [0.2] LEFT PARENTHESIS (Close) × [998.0] QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER G (Upper) × [998.0] LATIN SMALL LETTER O (Lower) × [998.0] FULL STOP (ATerm) × [9.0] QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x28, 0xe2, 0x80, 0x9c, 0x47, 0x6f, 0x3f, 0xe2, 0x80, 0x9d, 0x29, 0x20, 0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29},
		expected: [][]byte{{0x28, 0xe2, 0x80, 0x9c, 0x47, 0x6f, 0x3f, 0xe2, 0x80, 0x9d, 0x29, 0x20}, {0x28, 0x48, 0x65, 0x20, 0x64, 0x69, 0x64, 0x2e, 0x29}},
		comment:  "÷ [0.2] LEFT PARENTHESIS (Close) × [998.0] LEFT DOUBLE QUOTATION MARK (Close) × [998.0] LATIN CAPITAL LETTER G (Upper) × [998.0] LATIN SMALL LETTER O (Lower) × [998.0] QUESTION MARK (STerm) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] SPACE (Sp) ÷ [11.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) ÷ [0.3]",
	},
	{
		input:    []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e, 0x20, 0x69, 0x73},
		expected: [][]byte{{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e, 0x20, 0x69, 0x73}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER I (Lower) × [998.0] LATIN SMALL LETTER S (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x3f, 0x20, 0x48, 0x65},
		expected: [][]byte{{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x3f, 0x20}, {0x48, 0x65}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] QUESTION MARK (STerm) × [9.0] SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e},
		expected: [][]byte{{0x55, 0x2e, 0x53, 0x2e, 0x41, 0xcc, 0x80, 0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER U (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER S (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x33, 0x2e, 0x34},
		expected: [][]byte{{0x33, 0x2e, 0x34}},
		comment:  "÷ [0.2] DIGIT THREE (Numeric) × [998.0] FULL STOP (ATerm) × [6.0] DIGIT FOUR (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x63, 0x2e, 0x64},
		expected: [][]byte{{0x63, 0x2e, 0x64}},
		comment:  "÷ [0.2] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x43, 0x2e, 0x64},
		expected: [][]byte{{0x43, 0x2e, 0x64}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [998.0] FULL STOP (ATerm) × [8.0] LATIN SMALL LETTER D (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x63, 0x2e, 0x44},
		expected: [][]byte{{0x63, 0x2e, 0x44}},
		comment:  "÷ [0.2] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x43, 0x2e, 0x44},
		expected: [][]byte{{0x43, 0x2e, 0x44}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER C (Upper) × [998.0] FULL STOP (ATerm) × [7.0] LATIN CAPITAL LETTER D (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x74, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x74, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0x54, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0}, {0x54, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x74, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x74, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [998.0] LEFT PARENTHESIS (Close) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xe2, 0x80, 0x98, 0x28, 0x54, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0}, {0xe2, 0x80, 0x98, 0x28, 0x54, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [998.0] LEFT PARENTHESIS (Close) × [998.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x74, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x74, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.0] RIGHT PARENTHESIS (Close) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [8.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend) × [8.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88, 0x54, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xc2, 0xa0, 0xcc, 0x88}, {0x54, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [9.0] NO-BREAK SPACE (Sp) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xcc, 0x88, 0x54, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xe2, 0x80, 0x99, 0xcc, 0x88}, {0x54, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0x29, 0xa, 0xcc, 0x88, 0x54, 0x68, 0x65},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0x29, 0xa}, {0xcc, 0x88, 0x54, 0x68, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [9.0] RIGHT PARENTHESIS (Close) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] COMBINING DIAERESIS (Extend) × [998.0] LATIN CAPITAL LETTER T (Upper) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x2e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65},
		expected: [][]byte{{0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x2e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x20, 0x61, 0x72, 0x65}},
		comment:  "÷ [0.2] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER H (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER S (Lower) × [998.0] LATIN SMALL LETTER P (Lower) × [998.0] FULL STOP (ATerm) × [8.0] SPACE (Sp) × [8.0] LATIN SMALL LETTER L (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER D (Lower) × [998.0] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER S (Lower) × [998.0] SPACE (Sp) × [998.0] LATIN SMALL LETTER A (Lower) × [998.0] LATIN SMALL LETTER R (Lower) × [998.0] LATIN SMALL LETTER E (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0xe5, 0xad, 0x97, 0x2e, 0xe5, 0xad, 0x97},
		expected: [][]byte{{0xe5, 0xad, 0x97, 0x2e}, {0xe5, 0xad, 0x97}},
		comment:  "÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [998.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0xe5, 0xae, 0x83},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e}, {0xe5, 0xae, 0x83}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x65, 0x74, 0x63, 0x2e, 0xe3, 0x80, 0x82},
		expected: [][]byte{{0x65, 0x74, 0x63, 0x2e, 0xe3, 0x80, 0x82}},
		comment:  "÷ [0.2] LATIN SMALL LETTER E (Lower) × [998.0] LATIN SMALL LETTER T (Lower) × [998.0] LATIN SMALL LETTER C (Lower) × [998.0] FULL STOP (ATerm) × [8.1] IDEOGRAPHIC FULL STOP (STerm) ÷ [0.3]",
	},
	{
		input:    []byte{0xe5, 0xad, 0x97, 0xe3, 0x80, 0x82, 0xe5, 0xae, 0x83},
		expected: [][]byte{{0xe5, 0xad, 0x97, 0xe3, 0x80, 0x82}, {0xe5, 0xae, 0x83}},
		comment:  "÷ [0.2] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [998.0] IDEOGRAPHIC FULL STOP (STerm) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x21, 0x20, 0x20},
		expected: [][]byte{{0x21, 0x20, 0x20}},
		comment:  "÷ [0.2] EXCLAMATION MARK (STerm) × [9.0] SPACE (Sp) × [10.0] SPACE (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e},
		expected: [][]byte{{0x61, 0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0xd, 0xa},
		expected: [][]byte{{0x61, 0x2e, 0xd, 0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0xd, 0xa, 0x20},
		expected: [][]byte{{0x61, 0x2e, 0xd, 0xa}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Sp) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0xd, 0xa, 0x61},
		expected: [][]byte{{0x61, 0x2e, 0xd, 0xa}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (Lower) × [998.0] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2e, 0xd, 0xa, 0x41},
		expected: [][]byte{{0x41, 0x2e, 0xd, 0xa}, {0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (Upper) × [998.0] FULL STOP (ATerm) × [9.0] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x22, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, {0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9c, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x3f, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9d, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9c, 0xe2, 0x81, 0xa0, 0x47, 0xe2, 0x81, 0xa0, 0x6f, 0xe2, 0x81, 0xa0, 0x3f, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x9d, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, {0x28, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] LEFT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER G (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER O (Lower) × [5.0] WORD JOINER (Format) × [998.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT DOUBLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format) ÷ [11.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x69, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [8.0] LATIN SMALL LETTER I (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x3f, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x3f, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0}, {0x48, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] QUESTION MARK (STerm) × [5.0] WORD JOINER (Format) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format) ÷ [11.0] LATIN CAPITAL LETTER H (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x55, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x53, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0xcc, 0x80, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER U (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER S (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format) × [5.0] COMBINING GRAVE ACCENT (Extend) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x33, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x34, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] DIGIT THREE (Numeric) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [6.0] DIGIT FOUR (Numeric) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x43, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x44, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER C (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [7.0] LATIN CAPITAL LETTER D (Upper) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0}, {0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) × [8.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0}, {0xe2, 0x80, 0x98, 0xe2, 0x81, 0xa0, 0x28, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) ÷ [11.0] LEFT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [998.0] LEFT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [8.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [8.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) × [5.0] COMBINING DIAERESIS (Extend) × [8.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xc2, 0xa0, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [9.0] NO-BREAK SPACE (Sp) × [5.0] WORD JOINER (Format) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x99, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] RIGHT SINGLE QUOTATION MARK (Close) × [5.0] WORD JOINER (Format) × [5.0] COMBINING DIAERESIS (Extend) ÷ [11.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xa, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x29, 0xe2, 0x81, 0xa0, 0xa}, {0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x81, 0xa0, 0x54, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] RIGHT PARENTHESIS (Close) × [5.0] WORD JOINER (Format) × [9.0] <LINE FEED (LF)> (LF) ÷ [4.0] WORD JOINER (Format) × [5.0] COMBINING DIAERESIS (Extend) × [5.0] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER T (Upper) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x70, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x6c, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x68, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x70, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x6c, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x64, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x73, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x72, 0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER H (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER P (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [8.0] LATIN SMALL LETTER L (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER D (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER S (Lower) × [5.0] WORD JOINER (Format) × [998.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER R (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0}, {0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0}, {0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x65, 0xe2, 0x81, 0xa0, 0x74, 0xe2, 0x81, 0xa0, 0x63, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER E (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER T (Lower) × [5.0] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER C (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [8.1] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0, 0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0xe5, 0xad, 0x97, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0x82, 0xe2, 0x81, 0xa0}, {0xe5, 0xae, 0x83, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] CJK UNIFIED IDEOGRAPH-5B57 (OLetter) × [5.0] WORD JOINER (Format) × [998.0] IDEOGRAPHIC FULL STOP (STerm) × [5.0] WORD JOINER (Format) ÷ [11.0] CJK UNIFIED IDEOGRAPH-5B83 (OLetter) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x21, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x21, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] EXCLAMATION MARK (STerm) × [5.0] WORD JOINER (Format) × [9.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [10.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd, 0xe2, 0x81, 0xa0, 0xa, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd}, {0xe2, 0x81, 0xa0, 0xa}, {0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WORD JOINER (Format) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd, 0xe2, 0x81, 0xa0, 0xa, 0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd}, {0xe2, 0x81, 0xa0, 0xa}, {0x20, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WORD JOINER (Format) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] SPACE (Sp) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd, 0xe2, 0x81, 0xa0, 0xa, 0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd}, {0xe2, 0x81, 0xa0, 0xa}, {0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WORD JOINER (Format) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN SMALL LETTER A (Lower) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd, 0xe2, 0x81, 0xa0, 0xa, 0x41, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x81, 0xa0, 0x41, 0xe2, 0x81, 0xa0, 0x2e, 0xe2, 0x81, 0xa0, 0xd}, {0xe2, 0x81, 0xa0, 0xa}, {0x41, 0xe2, 0x81, 0xa0, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WORD JOINER (Format) × [998.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format) × [998.0] FULL STOP (ATerm) × [5.0] WORD JOINER (Format) × [9.0] <CARRIAGE RETURN (CR)> (CR) ÷ [4.0] WORD JOINER (Format) × [998.0] <LINE FEED (LF)> (LF) ÷ [4.0] LATIN CAPITAL LETTER A (Upper) × [5.0] WORD JOINER (Format) × [5.0] WORD JOINER (Format) ÷ [0.3]",
	},
}
