// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::get_delegated_access_token::_get_delegated_access_token_input::GetDelegatedAccessTokenInputBuilder;

pub use crate::operation::get_delegated_access_token::_get_delegated_access_token_output::GetDelegatedAccessTokenOutputBuilder;

impl crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.get_delegated_access_token();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `GetDelegatedAccessToken`.
///
/// <p>Exchanges a trade-in token for temporary Amazon Web Services credentials with the permissions associated with the assumed principal. This operation allows you to obtain credentials for a specific principal based on a trade-in token, enabling delegation of access to Amazon Web Services resources.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct GetDelegatedAccessTokenFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
    > for GetDelegatedAccessTokenFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
            crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl GetDelegatedAccessTokenFluentBuilder {
    /// Creates a new `GetDelegatedAccessTokenFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the GetDelegatedAccessToken as a reference.
    pub fn as_input(&self) -> &crate::operation::get_delegated_access_token::builders::GetDelegatedAccessTokenInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::get_delegated_access_token::GetDelegatedAccessToken::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::get_delegated_access_token::GetDelegatedAccessToken::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenOutput,
        crate::operation::get_delegated_access_token::GetDelegatedAccessTokenError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The token to exchange for temporary Amazon Web Services credentials. This token must be valid and unexpired at the time of the request.</p>
    pub fn trade_in_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.trade_in_token(input.into());
        self
    }
    /// <p>The token to exchange for temporary Amazon Web Services credentials. This token must be valid and unexpired at the time of the request.</p>
    pub fn set_trade_in_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_trade_in_token(input);
        self
    }
    /// <p>The token to exchange for temporary Amazon Web Services credentials. This token must be valid and unexpired at the time of the request.</p>
    pub fn get_trade_in_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_trade_in_token()
    }
}
