/***************************************************************************
 * SPDX-FileCopyrightText: 2014-2015 Pier Luigi Fiorini <pierluigi.fiorini@gmail.com>
 * SPDX-FileCopyrightText: 2014 Martin Bříza <mbriza@redhat.com>
 * SPDX-FileCopyrightText: 2013 Abdurrahman AVCI <abdurrahmanavci@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 ***************************************************************************/

#ifndef PLASMALOGIN_DISPLAY_H
#define PLASMALOGIN_DISPLAY_H

#include <QDir>
#include <QObject>
#include <QPointer>

#include "Auth.h"
#include "Session.h"

class QLocalSocket;

namespace PLASMALOGIN
{
class Authenticator;
class DisplayServer;
class Seat;
class SocketServer;
class Greeter;

class Display : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(Display)
public:
    explicit Display(Seat *parent);
    ~Display();

    int terminalId() const;

    QString sessionType() const;
    QString reuseSessionId() const
    {
        return m_reuseSessionId;
    }

    Seat *seat() const;

public slots:
    bool start();
    void stop();

    void login(QLocalSocket *socket, const QString &user, const QString &password, const Session &session);
    void displayServerStarted();

signals:
    void stopped();
    void displayServerFailed();

    void loginFailed(QLocalSocket *socket);
    void loginSucceeded(QLocalSocket *socket);

private:
    bool startAuth(const QString &user, const QString &password, const Session &session);

    void startSocketServerAndGreeter();
    bool handleAutologinFailure();

    bool m_started{false};

    int m_terminalId = -1;
    int m_sessionTerminalId = 0;

    QString m_passPhrase;
    QString m_sessionName;
    QString m_reuseSessionId;

    Session m_autologinSession;

    Auth *m_auth{nullptr};
    Seat *m_seat{nullptr};
    SocketServer *m_socketServer{nullptr};
    QPointer<QLocalSocket> m_socket;
    Greeter *m_greeter{nullptr};

private slots:
    void slotRequestChanged();
    void slotAuthenticationFinished(const QString &user, bool success);
    void slotSessionStarted(bool success);
    void slotHelperFinished(Auth::HelperExitStatus status);
    void slotAuthInfo(const QString &message, Auth::Info info);
    void slotAuthError(const QString &message, Auth::Error error);
};
}

#endif // PLASMALOGIN_DISPLAY_H
