/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_my extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ဂရင်းနစ် စံတော်ချိန်",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "အပီယာ စံတော်ချိန်",
               "",
               "အပီယာ နွေရာသီ အချိန်",
               "",
               "အပီယာ အချိန်",
               "",
            };
        final String[] Cook = new String[] {
               "ကွတ်ကျွန်းစု စံတော်ချိန်",
               "",
               "ကွတ်ကျွန်းစု နွေရာသီ အချိန်",
               "",
               "ကွတ်ကျွန်းစု အချိန်",
               "",
            };
        final String[] Cuba = new String[] {
               "ကျူးဘား စံတော်ချိန်",
               "CST",
               "ကျူးဘား နွေရာသီ စံတော်ချိန်",
               "CDT",
               "ကျူးဘား အချိန်",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ဖီဂျီ စံတော်ချိန်",
               "",
               "ဖီဂျီ နွေရာသီ အချိန်",
               "",
               "ဖီဂျီ အချိန်",
               "",
            };
        final String[] Gulf = new String[] {
               "ပင်လယ်ကွေ့ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ဟိုးဗ် စံတော်ချိန်",
               "",
               "ဟိုးဗ် နွေရာသီ အချိန်",
               "",
               "ဟိုးဗ် အချိန်",
               "",
            };
        final String[] Iran = new String[] {
               "အီရန် စံတော်ချိန်",
               "",
               "အီရန် နွေရာသီ အချိန်",
               "",
               "အီရန် အချိန်",
               "",
            };
        final String[] Niue = new String[] {
               "နီဥူအေ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "အွမ်းစ်ခ် စံတော်ချိန်",
               "",
               "အွမ်းစ်ခ် နွေရာသီ အချိန်",
               "",
               "အွမ်းစ်ခ် အချိန်",
               "",
            };
        final String[] Peru = new String[] {
               "ပီရူး စံတော်ချိန်",
               "",
               "ပီရူး နွေရာသီ အချိန်",
               "",
               "ပီရူး အချိန်",
               "",
            };
        final String[] Truk = new String[] {
               "ချုခ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ဝိတ်ခ်ကျွန်း အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ချီလီ စံတော်ချိန်",
               "",
               "ချီလီ နွေရာသီ အချိန်",
               "",
               "ချီလီ အချိန်",
               "",
            };
        final String[] China = new String[] {
               "တရုတ် စံတော်ချိန်",
               "CST",
               "တရုတ် နွေရာသီ အချိန်",
               "CDT",
               "တရုတ် အချိန်",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ကိုကိုးကျွန်း အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ဒေးဗစ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "အိန္ဒိယ စံတော်ချိန်",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ဂျပန် စံတော်ချိန်",
               "JST",
               "ဂျပန် နွေရာသီ အချိန်",
               "JDT",
               "ဂျပန် အချိန်",
               "JT",
            };
        final String[] Korea = new String[] {
               "ကိုရီးယား စံတော်ချိန်",
               "KST",
               "ကိုရီးယား နွေရာသီ အချိန်",
               "KST",
               "ကိုရီးယား အချိန်",
               "KST",
            };
        final String[] Nauru = new String[] {
               "နာဥူရူ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "နီပေါ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ပလာအို အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ဆမိုအာ စံတော်ချိန်",
               "SST",
               "ဆမိုးအား နွေရာသီ အချိန်",
               "SST",
               "ဆမိုအာ အချိန်",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ရှိုဝါ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "တွန်ဂါ စံတော်ချိန်",
               "",
               "တွန်ဂါ နွေရာသီ အချိန်",
               "",
               "တွန်ဂါ အချိန်",
               "",
            };
        final String[] Yukon = new String[] {
               "ယူကွန်း အချိန်",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "အလာစကာ စံတော်ချိန်",
               "AKST",
               "အလာစကာ နွေရာသီ စံတော်ချိန်",
               "AKDT",
               "အလာစကာ အချိန်",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "အမေဇုံ စံတော်ချိန်",
               "",
               "အမေဇုံ နွေရာသီအချိန်",
               "",
               "အမေဇုံ အချိန်",
               "",
            };
        final String[] Azores = new String[] {
               "အေဇိုးရီးစ် စံတော်ချိန်",
               "",
               "အေဇိုးရီးစ် နွေရာသီ အချိန်",
               "",
               "အေဇိုးရီးစ် အချိန်",
               "",
            };
        final String[] Bhutan = new String[] {
               "ဘူတန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ဘရူနိုင်း စံတော်ချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "အီစတာကျွန်း စံတော်ချိန်",
               "",
               "အီစတာကျွန်း နွေရာသီ အချိန်",
               "",
               "အီစတာကျွန်း အချိန်",
               "",
            };
        final String[] Guyana = new String[] {
               "ဂိုင်ယာနာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ဟာဝိုင်ယီ အယ်လူးရှန်း စံတော်ချိန်",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "အစ္စရေး စံတော်ချိန်",
               "IST",
               "အစ္စရေး နွေရာသီ အချိန်",
               "IDT",
               "အစ္စရေး အချိန်",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "ခိုစ်ရိုင် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "မော်စွန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "မော်စကို စံတော်ချိန်",
               "MSK",
               "မော်စကို နွေရာသီ အချိန်",
               "MSK",
               "မော်စကို အချိန်",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ဖိုနာဖဲအ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "တဟီတီ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ထိုင်ပေ စံတော်ချိန်",
               "CST",
               "ထိုင်ပေ နွေရာသီ အချိန်",
               "CDT",
               "ထိုင်ပေ အချိန်",
               "CT",
            };
        final String[] Turkey = new String[] {
               "တူရကီ စံတော်ချိန်",
               "",
               "တူရကီ နွေရာသီ အချိန်",
               "",
               "တူရကီ အချိန်",
               "",
            };
        final String[] Tuvalu = new String[] {
               "တူဗားလူ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ဗိုစ်တိုခ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ဝေါလီစ်နှင့် ဖူကျူနာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "အာရေဗျ စံတော်ချိန်",
               "",
               "အာရေဗျ နွေရာသီ အချိန်",
               "",
               "အာရေဗျ အချိန်",
               "",
            };
        final String[] Armenia = new String[] {
               "အာမေးနီးယား စံတော်ချိန်",
               "",
               "အာမေးနီးယား နွေရာသီ အချိန်",
               "",
               "အာမေးနီးယား အချိန်",
               "",
            };
        final String[] Bolivia = new String[] {
               "ဘိုလီးဘီးယား အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ချားသမ်စံတော်ချိန်",
               "",
               "ချားသမ် နွေရာသီ အချိန်",
               "",
               "ချားသမ်အချိန်",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "အီကွေဒေါ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ဂမ်ဘီယာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ဂျော်ဂျီယာ စံတော်ချိန်",
               "",
               "ဂျော်ဂျီယာ နွေရာသီ အချိန်",
               "",
               "ဂျော်ဂျီယာ အချိန်",
               "",
            };
        final String[] Irkutsk = new String[] {
               "အီရူခူတ် စံတော်ချိန်",
               "",
               "အီရူခူတ် နွေရာသီ အချိန်",
               "",
               "အီရူခူတ် အချိန်",
               "",
            };
        final String[] Magadan = new String[] {
               "မာဂါဒန်း စံတော်ချိန်",
               "",
               "မာဂါဒန်း နွေရာသီ အချိန်",
               "",
               "မာဂါဒန်း အချိန်",
               "",
            };
        final String[] Myanmar = new String[] {
               "မြန်မာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "နောဖော့ခ်ကျွန်း စံတော်ချိန်",
               "",
               "နောဖော့ခ်ကျွန်း နွေရာသီ စံတော်ချိန်",
               "",
               "နောဖော့ခ်ကျွန်း အချိန်",
               "",
            };
        final String[] Noronha = new String[] {
               "ဖာနန်ဒိုးဒီနိုးရိုးညာ စံတော်ချိန်",
               "",
               "ဖာနန်ဒိုးဒီနိုးရိုးညာ နွေရာသီ အချိန်",
               "",
               "ဖာနန်ဒိုးဒီနိုးရိုးညာ အချိန်",
               "",
            };
        final String[] Reunion = new String[] {
               "ရီယူနီယံ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ရိုသီရာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ဆော်လမွန်ကျွန်းစု အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "တိုကီလာဥ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ဥရုဂွေး စံတော်ချိန်",
               "",
               "ဥရုဂွေး နွေရာသီ အချိန်",
               "",
               "ဥရုဂွေး အချိန်",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ဗနွားတူ စံတော်ချိန်",
               "",
               "ဗနွားတူ နွေရာသီ အချိန်",
               "",
               "ဗနွားတူ အချိန်",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ယူခူးတ်စ် စံတော်ချိန်",
               "",
               "ယူခူးတ်စ် နွေရာသီ အချိန်",
               "",
               "ယူခူးတ်စ် အချိန်",
               "",
            };
        final String[] Atlantic = new String[] {
               "အတ္တလန်တစ် စံတော်ချိန်",
               "AST",
               "အတ္တလန်တစ် နွေရာသီ စံတော်ချိန်",
               "AST",
               "အတ္တလန်တစ် အချိန်",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ဘရာဇီး စံတော်ချိန်",
               "",
               "ဘရာဇီး နွေရာသီ အချိန်",
               "",
               "ဘရာဇီး အချိန်",
               "",
            };
        final String[] Chamorro = new String[] {
               "ချာမိုရို အချိန်",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "ကိုလံဘီယာ စံတော်ချိန်",
               "",
               "ကိုလံဘီယာ နွေရာသီ အချိန်",
               "",
               "ကိုလံဘီယာ အချိန်",
               "",
            };
        final String[] Falkland = new String[] {
               "ဖော့ကလန်ကျွန်းစု စံတော်ချိန်",
               "",
               "ဖော့ကလန်ကျွန်းစု နွေရာသီ အချိန်",
               "",
               "ဖော့ကလန်ကျွန်းစု အချိန်",
               "",
            };
        final String[] Malaysia = new String[] {
               "မလေးရှား အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "မော်လဒိုက် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ဥလန်ဘာတော စံတော်ချိန်",
               "",
               "ဥလန်ဘာတော နွေရာသီ အချိန်",
               "",
               "ဥလန်ဘာတော အချိန်",
               "",
            };
        final String[] Pakistan = new String[] {
               "ပါကစ္စတန် စံတော်ချိန်",
               "PKT",
               "ပါကစ္စတန် နွေရာသီ အချိန်",
               "PKST",
               "ပါကစ္စတန် အချိန်",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ပါရာဂွေး စံတော်ချိန်",
               "",
               "ပါရာဂွေး နွေရာသီ အချိန်",
               "",
               "ပါရာဂွေး အချိန်",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ပါတ်ကယ်ရင် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "စူးရီနာမ်အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "အာဂျင်တီးနား စံတော်ချိန်",
               "",
               "အာဂျင်တီးနား နွေရာသီအချိန်",
               "",
               "အာဂျင်တီးနား အချိန်",
               "",
            };
        final String[] Christmas = new String[] {
               "ခရစ်စမတ်ကျွန်း အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ဂါလားပါဂိုးစ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ဟောင်ကောင် စံတော်ချိန်",
               "HKT",
               "ဟောင်ကောင် နွေရာသီ အချိန်",
               "HKST",
               "ဟောင်ကောင် အချိန်",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "အင်ဒိုချိုင်းနား အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ကာဂျစ္စတန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "လော့ဒ်ဟောင် စံတော်ချိန်",
               "",
               "လော့ဒ်ဟောင် နွေရာသီ အချိန်",
               "",
               "လော့ဒ်ဟောင် အချိန်",
               "",
            };
        final String[] Marquesas = new String[] {
               "မာခေးအပ်စ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "မောရစ်ရှ စံတော်ချိန်",
               "",
               "မောရစ်ရှ နွေရာသီ အချိန်",
               "",
               "မောရစ်ရှ အချိန်",
               "",
            };
        final String[] Singapore = new String[] {
               "စင်္ကာပူ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ဗင်နီဇွဲလား အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "အဇာဘိုင်ဂျန် စံတော်ချိန်",
               "",
               "အဇာဘိုင်ဂျန် နွေရာသီ အချိန်",
               "",
               "အဇာဘိုင်ဂျန် အချိန်",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ဘင်္ဂလားဒေ့ရှ် စံတော်ချိန်",
               "",
               "ဘင်္ဂလားဒေ့ရှ် နွေရာသီ အချိန်",
               "",
               "ဘင်္ဂလားဒေ့ရှ် အချိန်",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "ကိတ်ဗာဒီ စံတော်ချိန်",
               "",
               "ကိတ်ဗာဒီ နွေရာသီ အချိန်",
               "",
               "ကိတ်ဗာဒီ အချိန်",
               "",
            };
        final String[] East_Timor = new String[] {
               "အရှေ့တီမော အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ကာဇက်စတန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ဆေးရှဲ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "တာဂျစ်ကစ္စတန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ဥဇဘက်ကစ္စတန် စံတော်ချိန်",
               "",
               "ဥဇဘက်ကစ္စတန် နွေရာသီ အချိန်",
               "",
               "ဥဇဘက်ကစ္စတန် အချိန်",
               "",
            };
        final String[] Afghanistan = new String[] {
               "အာဖဂန်နစ္စတန် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ခရာ့စ်နိုရာစ် စံတော်ချိန်",
               "",
               "ခရာ့စ်နိုရာစ် နွေရာသီ အချိန်",
               "",
               "ခရာ့စ်နိုရာစ် အချိန်",
               "",
            };
        final String[] New_Zealand = new String[] {
               "နယူးဇီလန် စံတော်ချိန်",
               "NZST",
               "နယူးဇီလန် နွေရာသီ အချိန်",
               "NZDT",
               "နယူးဇီလန် အချိန်",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ဖိလစ်ပိုင် စံတော်ချိန်",
               "PST",
               "ဖိလစ်ပိုင် နွေရာသီ အချိန်",
               "PDT",
               "ဖိလစ်ပိုင် အချိန်",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ဗလာဒီဗော့စတော့ခ် စံတော်ချိန်",
               "",
               "ဗလာဒီဗော့စတော့ခ် နွေရာသီ အချိန်",
               "",
               "ဗလာဒီဗော့စတော့ခ် အချိန်",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "အိန္ဒိယသမုဒ္ဒရာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "လိုင်းကျွန်းစု အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "နယူးဖောင်လန် စံတော်ချိန်",
               "NST",
               "နယူးဖောင်လန် နွေရာသီ စံတော်ချိန်",
               "NDT",
               "နယူးဖောင်လန် အချိန်",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "တာ့ခ်မင်နစ္စတန် စံတော်ချိန်",
               "",
               "တာ့ခ်မင်နစ္စတန် နွေရာသီ အချိန်",
               "",
               "တာ့ခ်မင်နစ္စတန် အချိန်",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ပြင်သစ် ဂီအားနား အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "နယူးကာလီဒိုးနီးယား စံတော်ချိန်",
               "",
               "နယူးကာလီဒိုးနီးယား နွေရာသီ အချိန်",
               "",
               "နယူးကယ်လီဒိုးနီးယား အချိန်",
               "",
            };
        final String[] South_Georgia = new String[] {
               "တောင်ဂျော်ဂျီယာ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ရယ်ခါးတီရင်ဘားခ် စံတော်ချိန်",
               "",
               "ရယ်ခါးတီရင်ဘာခ် နွေရာသီ အချိန်",
               "",
               "ရယ်ခါးတီရင်ဘားခ် အချိန်",
               "",
            };
        final String[] Africa_Central = new String[] {
               "အလယ်အာဖရိက အချိန်",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "အရှေ့အာဖရိက အချိန်",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "အနောက်အာဖရိက အချိန်",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ဒူးမော့တ် ဒါရ်ဗီးလ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ဥရောပအလယ်ပိုင်း စံတော်ချိန်",
               "CET",
               "ဥရောပအလယ်ပိုင်း နွေရာသီ အချိန်",
               "CEST",
               "ဥရောပအလယ်ပိုင်း အချိန်",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "အရှေ့ဥရောပ စံတော်ချိန်",
               "EET",
               "အရှေ့ဥရောပ နွေရာသီ အချိန်",
               "EEST",
               "အရှေ့ဥရောပ အချိန်",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "အနောက်ဥရောပ စံတော်ချိန်",
               "WET",
               "အနောက်ဥရောပ နွေရာသီ အချိန်",
               "WEST",
               "အနောက်ဥရောပ အချိန်",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "မက္ကဆီကန် ပစိဖိတ် စံတော်ချိန်",
               "MST",
               "မက္ကစီကန် ပစိဖိတ် နွေရာသီ စံတော်ချိန်",
               "MDT",
               "မက္ကဆီကန် ပစိဖိတ် အချိန်",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "တောင်အာဖရိက အချိန်",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "အလယ်ပိုင်းစံတော်ချိန်",
               "CST",
               "အလယ်ပိုင်း နွေရာသီစံတော်ချိန်",
               "CDT",
               "အလယ်ပိုင်းအချိန်",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "အရှေ့ပိုင်းစံတော်ချိန်",
               "EST",
               "အရှေ့ပိုင်း နွေရာသီစံတော်ချိန်",
               "EST",
               "အရှေ့ပိုင်းအချိန်",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ပစိဖိတ်စံတော်ချိန်",
               "PST",
               "ပစိဖိတ် နွေရာသီစံတော်ချိန်",
               "PDT",
               "ပစိဖိတ်အချိန်",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ပြင်သစ်တောင်ပိုင်းနှင့် အန္တာတိတ် အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ဂီလ်ဘတ်ကျွန်းစု အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ဟာဝိုင်ယီ အယ်လူးရှန်း စံတော်ချိန်",
               "HST",
               "ဟာဝိုင်ယီ အယ်လူးရှန်း နွေရာသီ စံတော်ချိန်",
               "HDT",
               "ဟာဝိုင်ယီ အယ်လူးရှန်း အချိန်",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ဖီးနစ်ကျွန်းစု အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "စိန့်ပီအဲနှင့်မီခွီလွန်စံတော်ချိန်",
               "",
               "စိန့်ပီအဲနှင့် မီခွီလွန် နွေရာသီ စံတော်ချိန်",
               "",
               "စိန့်ပီအဲနှင့်မီခွီလွန်အချိန်",
               "",
            };
        final String[] America_Mountain = new String[] {
               "တောင်တန်းစံတော်ချိန်",
               "MST",
               "တောင်တန်း နွေရာသီစံတော်ချိန်",
               "MST",
               "တောင်တန်းအချိန်",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "မာရှယ်ကျွန်းစု အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ပါပူအာနယူးဂီနီ အချိန်",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ဩစတြေးလျ အလယ်ပိုင်း စံတော်ချိန်",
               "ACST",
               "ဩစတြေးလျ အလယ်ပိုင်း နွေရာသီ အချိန်",
               "ACDT",
               "ဩစတြေးလျ အလယ်ပိုင်း အချိန်",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "အရှေ့ဩစတြေးလျ စံတော်ချိန်",
               "AEST",
               "အရှေ့ဩစတြေးလျ နွေရာသီ အချိန်",
               "AEDT",
               "အရှေ့ဩစတြေးလျ အချိန်",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "အနောက်ဩစတြေးလျ စံတော်ချိန်",
               "AWST",
               "ဩစတြေးလျ နွေရာသီ အချိန်",
               "AWDT",
               "အနောက်ဩစတြေးလျ အချိန်",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "အလယ်ပိုင်း အင်ဒိုနီးရှား အချိန်",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "အရှေ့ပိုင်း အင်ဒိုနီးရှား အချိန်",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "အနောက်ပိုင်း အင်ဒိုနီးရှား အချိန်",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "သြစတြေးလျား အနောက်အလယ်ပိုင်း စံတော်ချိန်",
               "",
               "သြစတြေးလျား အနောက်အလယ်ပိုင်း နွေရာသီ အချိန်",
               "",
               "သြစတြေးလျား အနောက်အလယ်ပိုင်း အချိန်",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "အိုင်းရစ်ရှ် စံတော်ချိန်",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "Turkey", Turkey },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Istanbul", Turkey },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ညှိထားသည့် ကမ္ဘာ့ စံတော်ချိန်",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "အိုင်းရစ်ရှ် စံတော်ချိန်",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Istanbul", Turkey },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ဂရင်းနစ် စံတော်ချိန်",
                    "GMT",
                    "ဗြိတိန် နွေရာသီ အချိန်",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "အာဒင်" },
            { "timezone.excity.Asia/Baku", "ဘာကူ" },
            { "timezone.excity.Asia/Dili", "ဒစ်လီ" },
            { "timezone.excity.Asia/Gaza", "ဂါဇာ" },
            { "timezone.excity.Asia/Hovd", "ဟိုးဗျ" },
            { "timezone.excity.Asia/Omsk", "အွမ်းစ်ခ်" },
            { "timezone.excity.Asia/Oral", "အော်ရဲလ်" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "အာမာန်း" },
            { "timezone.excity.Asia/Aqtau", "အက်တာဥု" },
            { "timezone.excity.Asia/Chita", "ချီတာ" },
            { "timezone.excity.Asia/Dhaka", "ဒက်ကာ" },
            { "timezone.excity.Asia/Dubai", "ဒူဘိုင်း" },
            { "timezone.excity.Asia/Kabul", "ကာဘူးလ်" },
            { "timezone.excity.Asia/Macau", "မကာအို" },
            { "timezone.excity.Asia/Qatar", "ကာတာ" },
            { "timezone.excity.Asia/Seoul", "ဆိုးလ်" },
            { "timezone.excity.Asia/Tokyo", "တိုကျို" },
            { "timezone.excity.Asia/Tomsk", "တွန်မ်စ်ခ်" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ဂျုဘာ" },
            { "timezone.excity.Africa/Lome", "လိုမီ" },
            { "timezone.excity.Asia/Almaty", "အော်မာတီ" },
            { "timezone.excity.Asia/Anadyr", "အန်အာဒီအာ" },
            { "timezone.excity.Asia/Aqtobe", "အာချတူးဘီ" },
            { "timezone.excity.Asia/Atyrau", "အာတီရအူ" },
            { "timezone.excity.Asia/Beirut", "ဘေရွတ်" },
            { "timezone.excity.Asia/Brunei", "ဘရူနိုင်း" },
            { "timezone.excity.Asia/Hebron", "ဟီဘရွန်" },
            { "timezone.excity.Asia/Kuwait", "ကူဝိတ်" },
            { "timezone.excity.Asia/Manila", "မနီလာ" },
            { "timezone.excity.Asia/Muscat", "မတ်စ်ကက်တ်" },
            { "timezone.excity.Asia/Riyadh", "ရီယားဒ်" },
            { "timezone.excity.Asia/Saigon", "ဟိုချီမင်းစီးတီး" },
            { "timezone.excity.Asia/Taipei", "တိုင်ပေ" },
            { "timezone.excity.Asia/Tehran", "တီဟီရန်" },
            { "timezone.excity.Asia/Urumqi", "အူရုမ်ချီ" },
            { "timezone.excity.Etc/Unknown", "အမည်မသိသောမြို့" },
            { "timezone.excity.Europe/Kiev", "ခီးအက်ဖ်" },
            { "timezone.excity.Europe/Oslo", "အော်စလို" },
            { "timezone.excity.Europe/Riga", "ရီဂါ" },
            { "timezone.excity.Europe/Rome", "ရောမ" },
            { "timezone.excity.Indian/Mahe", "မာဟီ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "အက်ကရာ" },
            { "timezone.excity.Africa/Cairo", "ကိုင်ရို" },
            { "timezone.excity.Africa/Ceuta", "ဆီရူးတာ" },
            { "timezone.excity.Africa/Dakar", "ဒကျကား" },
            { "timezone.excity.Africa/Lagos", "လာဂိုစ်" },
            { "timezone.excity.Africa/Tunis", "တူနီစ်" },
            { "timezone.excity.America/Adak", "အာဒချ" },
            { "timezone.excity.America/Lima", "လီမာ" },
            { "timezone.excity.America/Nome", "နိုမီ" },
            { "timezone.excity.Asia/Baghdad", "ဘဂ္ဂဒက်" },
            { "timezone.excity.Asia/Bahrain", "ဘာရိန်း" },
            { "timezone.excity.Asia/Bangkok", "ဘန်ကောက်" },
            { "timezone.excity.Asia/Barnaul", "ဘရ်နာအူ" },
            { "timezone.excity.Asia/Bishkek", "ဘီရှ်ခက်" },
            { "timezone.excity.Asia/Colombo", "ကိုလံဘို" },
            { "timezone.excity.Asia/Irkutsk", "အီရူခူတ်" },
            { "timezone.excity.Asia/Jakarta", "ဂျကာတာ" },
            { "timezone.excity.Asia/Karachi", "ကရာချိ" },
            { "timezone.excity.Asia/Kuching", "ကူချင်" },
            { "timezone.excity.Asia/Magadan", "မာဂါဒန်း" },
            { "timezone.excity.Asia/Nicosia", "နီကိုရှား" },
            { "timezone.excity.Asia/Rangoon", "ရန်ကုန်" },
            { "timezone.excity.Asia/Tbilisi", "တဘီးလီစီ" },
            { "timezone.excity.Asia/Thimphu", "တင်ဖူး" },
            { "timezone.excity.Asia/Yakutsk", "ယူခူးတ်စ်" },
            { "timezone.excity.Asia/Yerevan", "ရဲယ်ရေဗန်း" },
            { "timezone.excity.Europe/Kirov", "ခီရိုဗ်" },
            { "timezone.excity.Europe/Malta", "မော်လ်တာ" },
            { "timezone.excity.Europe/Minsk", "မင်းစခ်" },
            { "timezone.excity.Europe/Paris", "ပဲရစ်" },
            { "timezone.excity.Europe/Sofia", "ဆိုဖီအာ" },
            { "timezone.excity.Europe/Vaduz", "ဗာဒူးစ်" },
            { "timezone.excity.Indian/Cocos", "ကိုကိုးစ်" },
            { "timezone.excity.Pacific/Apia", "အားပီအား" },
            { "timezone.excity.Pacific/Fiji", "ဖီဂျီ" },
            { "timezone.excity.Pacific/Guam", "ဂူအမ်" },
            { "timezone.excity.Pacific/Niue", "နီဦးအေ" },
            { "timezone.excity.Pacific/Truk", "ချုခ်" },
            { "timezone.excity.Pacific/Wake", "ဝိတ်ခ်" },
            { "timezone.excity.Africa/Asmera", "အားစ်မားရာ" },
            { "timezone.excity.Africa/Bamako", "ဘာမာကို" },
            { "timezone.excity.Africa/Bangui", "ဘာန်ဂီး" },
            { "timezone.excity.Africa/Banjul", "ဘန်ဂျုးလ်" },
            { "timezone.excity.Africa/Bissau", "ဘီစာအို" },
            { "timezone.excity.Africa/Douala", "ဒိုအူအာလာ" },
            { "timezone.excity.Africa/Harare", "ဟာရားရဲယ်" },
            { "timezone.excity.Africa/Kigali", "ကီဂါးလီ" },
            { "timezone.excity.Africa/Luanda", "လူဝမ်ဒါ" },
            { "timezone.excity.Africa/Lusaka", "လူစာကာ" },
            { "timezone.excity.Africa/Malabo", "မာလာဘို" },
            { "timezone.excity.Africa/Maputo", "မာပူးတို" },
            { "timezone.excity.Africa/Maseru", "မာဆူရူး" },
            { "timezone.excity.Africa/Niamey", "ညာမဲယ်" },
            { "timezone.excity.America/Aruba", "အာရူးဗာ" },
            { "timezone.excity.America/Bahia", "ဘာဟီအာ" },
            { "timezone.excity.America/Belem", "ဘီလင်မ်" },
            { "timezone.excity.America/Boise", "ဗွိုက်စီ" },
            { "timezone.excity.America/Jujuy", "ဂျုဂျေ" },
            { "timezone.excity.America/Sitka", "စစ်ကာ" },
            { "timezone.excity.America/Thule", "သုလီ" },
            { "timezone.excity.Asia/Ashgabat", "အာရှ်ဂါဘာဒ်" },
            { "timezone.excity.Asia/Calcutta", "ကိုလျကတ်တား" },
            { "timezone.excity.Asia/Damascus", "ဒမားစကပ်" },
            { "timezone.excity.Asia/Dushanbe", "ဒူရှန်းဘဲ" },
            { "timezone.excity.Asia/Jayapura", "ဂျာရာပူရာ" },
            { "timezone.excity.Asia/Katmandu", "ခတ်တမန်ဒူ" },
            { "timezone.excity.Asia/Khandyga", "ခန်ဒိုင်ဂါ" },
            { "timezone.excity.Asia/Makassar", "မခက်စ်ဆာ" },
            { "timezone.excity.Asia/Qostanay", "ကော့စ်တနေ" },
            { "timezone.excity.Asia/Sakhalin", "ဆာခါလင်" },
            { "timezone.excity.Asia/Shanghai", "ရှန်ဟိုင်း" },
            { "timezone.excity.Asia/Tashkent", "တာရှ်ကဲန့်" },
            { "timezone.excity.Asia/Ust-Nera", "အူးစ် နီရား" },
            { "timezone.excity.Europe/Athens", "အေသင်" },
            { "timezone.excity.Europe/Berlin", "ဘာလင်" },
            { "timezone.excity.Europe/Dublin", "ဒတ်ဘလင်" },
            { "timezone.excity.Europe/Jersey", "ဂျာစီ" },
            { "timezone.excity.Europe/Lisbon", "လစ္စဘွန်း" },
            { "timezone.excity.Europe/London", "လန်ဒန်" },
            { "timezone.excity.Europe/Madrid", "မဒရစ်" },
            { "timezone.excity.Europe/Monaco", "မိုနာကို" },
            { "timezone.excity.Europe/Moscow", "မော်စကို" },
            { "timezone.excity.Europe/Prague", "ပရက်ဂ်" },
            { "timezone.excity.Europe/Samara", "ဆာမားရာ" },
            { "timezone.excity.Europe/Skopje", "စကော့ပ်ရာ" },
            { "timezone.excity.Europe/Tirane", "တီရာနီ" },
            { "timezone.excity.Europe/Vienna", "ဗီယင်နာ" },
            { "timezone.excity.Europe/Warsaw", "ဝါဆော" },
            { "timezone.excity.Europe/Zagreb", "ဇာဂ်ဂရက်ဘ်" },
            { "timezone.excity.Europe/Zurich", "ဇူးရစ်ချ်" },
            { "timezone.excity.Indian/Chagos", "ချာဂိုစ်" },
            { "timezone.excity.Indian/Comoro", "ကိုမိုရို" },
            { "timezone.excity.Pacific/Efate", "အီဖာတီ" },
            { "timezone.excity.Pacific/Nauru", "နာဥူရူ" },
            { "timezone.excity.Pacific/Palau", "ပလာအို" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "အာဘီဂျန်" },
            { "timezone.excity.Africa/Algiers", "အယ်လ်ဂျီးရီးယား" },
            { "timezone.excity.Africa/Conakry", "ကိုနာကရီး" },
            { "timezone.excity.Africa/Kampala", "ကမ်ပါလာ" },
            { "timezone.excity.Africa/Mbabane", "ဘားဘာန်း" },
            { "timezone.excity.Africa/Nairobi", "နိုင်ရိုဘီ" },
            { "timezone.excity.Africa/Tripoli", "ထရီပိုလီ" },
            { "timezone.excity.America/Belize", "ဘလိဇ်" },
            { "timezone.excity.America/Bogota", "ဘိုဂိုတာ" },
            { "timezone.excity.America/Cancun", "ကန်ခန်" },
            { "timezone.excity.America/Cayman", "ကေမန်" },
            { "timezone.excity.America/Cuiaba", "ကွီရာဘာ" },
            { "timezone.excity.America/Dawson", "ဒေါ်ဆန်" },
            { "timezone.excity.America/Denver", "ဒင်န်ဗာ" },
            { "timezone.excity.America/Guyana", "ဂိုင်ယာနာ" },
            { "timezone.excity.America/Havana", "ဟာဗာနာ" },
            { "timezone.excity.America/Inuvik", "အီနုဗီခ်" },
            { "timezone.excity.America/Juneau", "ဂျုနိုအော" },
            { "timezone.excity.America/La_Paz", "လာပါဇ်" },
            { "timezone.excity.America/Maceio", "မာဆဲသွာ" },
            { "timezone.excity.America/Manaus", "မာနောက်စ်" },
            { "timezone.excity.America/Merida", "မီရီဒါ" },
            { "timezone.excity.America/Nassau", "နာ့ဆော်" },
            { "timezone.excity.America/Panama", "ပနားမား" },
            { "timezone.excity.America/Recife", "ဟေစီဖီလ်" },
            { "timezone.excity.America/Regina", "ရယ်ဂျီနာ" },
            { "timezone.excity.Asia/Famagusta", "ဖာမာဂူစတာ" },
            { "timezone.excity.Asia/Hong_Kong", "ဟောင်ကောင်" },
            { "timezone.excity.Asia/Jerusalem", "ဂျေရုဆလင်" },
            { "timezone.excity.Asia/Kamchatka", "ခမ်ချာ့ခါ" },
            { "timezone.excity.Asia/Pontianak", "ပွန်တီအားနာ့ခ်" },
            { "timezone.excity.Asia/Pyongyang", "ပြုံယန်း" },
            { "timezone.excity.Asia/Qyzylorda", "ကီဇလော်ဒါ" },
            { "timezone.excity.Asia/Samarkand", "ဆမ်းမာခန်းဒ်" },
            { "timezone.excity.Asia/Singapore", "စင်္ကာပူ" },
            { "timezone.excity.Asia/Vientiane", "ဗီယင်ကျန်း" },
            { "timezone.excity.Europe/Andorra", "အန်ဒိုရာ" },
            { "timezone.excity.Europe/Saratov", "ဆာရာတို့ဖ်" },
            { "timezone.excity.Europe/Tallinn", "ထားလင်" },
            { "timezone.excity.Europe/Vatican", "ဗာတီကန်" },
            { "timezone.excity.Europe/Vilnius", "ဗီးလ်နီအိုးစ်" },
            { "timezone.excity.Indian/Mayotte", "မာယိုတဲ" },
            { "timezone.excity.Indian/Reunion", "ရီယူနီယန်" },
            { "timezone.excity.Pacific/Easter", "အီစတာ" },
            { "timezone.excity.Pacific/Kosrae", "ခိုစ်ရိုင်" },
            { "timezone.excity.Pacific/Majuro", "မာဂျူးရို" },
            { "timezone.excity.Pacific/Midway", "မစ်ဒ်ဝေး" },
            { "timezone.excity.Pacific/Noumea", "နူမယ်အာ" },
            { "timezone.excity.Pacific/Ponape", "ဖိုနာဖဲအ်" },
            { "timezone.excity.Pacific/Saipan", "ဆိုင်ပန်" },
            { "timezone.excity.Pacific/Tahiti", "တဟီတီ" },
            { "timezone.excity.Pacific/Tarawa", "တာရာဝါ" },
            { "timezone.excity.Pacific/Wallis", "ဝေါလီစ်" },
            { "timezone.excity.Africa/Blantyre", "ဘလန်တိုင်းရဲလ်" },
            { "timezone.excity.Africa/Djibouti", "ဂျီဘူတီ" },
            { "timezone.excity.Africa/El_Aaiun", "အယ်လ်အာယွန်း" },
            { "timezone.excity.Africa/Freetown", "ဖရီးတောင်းန်" },
            { "timezone.excity.Africa/Gaborone", "ဂါဘာရွန်းနီ" },
            { "timezone.excity.Africa/Khartoum", "ခါတိုအန်" },
            { "timezone.excity.Africa/Kinshasa", "ကင်ရှာစာ" },
            { "timezone.excity.Africa/Monrovia", "မွန်ရိုးဗီးယား" },
            { "timezone.excity.Africa/Ndjamena", "အင်ဂျာမီနာ" },
            { "timezone.excity.Africa/Sao_Tome", "ဆောင်တူမေး" },
            { "timezone.excity.Africa/Windhoek", "ဗင်းဟူးခ်" },
            { "timezone.excity.America/Antigua", "အန်တီဂွါ" },
            { "timezone.excity.America/Caracas", "ကာရာကာစ်" },
            { "timezone.excity.America/Cayenne", "ကေညင်န်" },
            { "timezone.excity.America/Chicago", "ချီကာကို" },
            { "timezone.excity.America/Cordoba", "ကိုဒိုဘာ" },
            { "timezone.excity.America/Creston", "ကရစ်စတွန်" },
            { "timezone.excity.America/Curacao", "ကျူရေးကိုး" },
            { "timezone.excity.America/Detroit", "ဒက်ထရွိုက်" },
            { "timezone.excity.America/Godthab", "နုခ်" },
            { "timezone.excity.America/Grenada", "ဂရီနေဒါ" },
            { "timezone.excity.America/Halifax", "ဟလီဖက်စ်" },
            { "timezone.excity.America/Iqaluit", "အီကာလူအီတ်" },
            { "timezone.excity.America/Jamaica", "ဂျမေကာ" },
            { "timezone.excity.America/Managua", "မာနာဂွါ" },
            { "timezone.excity.America/Marigot", "မာရီဂေါ့" },
            { "timezone.excity.America/Mendoza", "မန်ဒိုဇာ" },
            { "timezone.excity.America/Moncton", "မွန်ခ်တွန်" },
            { "timezone.excity.America/Noronha", "နိုရိုညာ" },
            { "timezone.excity.America/Ojinaga", "အိုခီနဂါ" },
            { "timezone.excity.America/Phoenix", "ဖီးနစ်" },
            { "timezone.excity.America/Tijuana", "တီဂွါနာ" },
            { "timezone.excity.America/Toronto", "တိုရန်တို" },
            { "timezone.excity.America/Tortola", "တောတိုလာ" },
            { "timezone.excity.America/Yakutat", "ရာကုတတ်" },
            { "timezone.excity.Asia/Phnom_Penh", "ဖနွမ်ပင်" },
            { "timezone.excity.Atlantic/Azores", "အေဇိုးရီးစ်" },
            { "timezone.excity.Atlantic/Canary", "ကနေရီ" },
            { "timezone.excity.Atlantic/Faeroe", "ဖါရို" },
            { "timezone.excity.Australia/Eucla", "ယူးခလာ" },
            { "timezone.excity.Australia/Perth", "ပါးသ်" },
            { "timezone.excity.Europe/Belgrade", "ဘဲလ်ဂရိတ်" },
            { "timezone.excity.Europe/Brussels", "ဘရပ်ဆဲလ်" },
            { "timezone.excity.Europe/Budapest", "ဘူဒါပက်စ်" },
            { "timezone.excity.Europe/Busingen", "ဘူရှင်ဂျင်" },
            { "timezone.excity.Europe/Chisinau", "ချီရှီနားအူ" },
            { "timezone.excity.Europe/Guernsey", "ဂွန်းဇီ" },
            { "timezone.excity.Europe/Helsinki", "ဟဲလ်စင်ကီ" },
            { "timezone.excity.Europe/Istanbul", "အစ္စတန်ဘူလ်" },
            { "timezone.excity.Europe/Sarajevo", "ဆာရာယေဗို" },
            { "timezone.excity.Indian/Maldives", "မော်လဒိုက်" },
            { "timezone.excity.Pacific/Chatham", "ချားသမ်" },
            { "timezone.excity.Pacific/Fakaofo", "ဖာခါအိုဖို" },
            { "timezone.excity.Pacific/Gambier", "ဂမ်ဘီယာ" },
            { "timezone.excity.Pacific/Norfolk", "နော်ဖော့ခ်" },
            { "timezone.excity.Africa/Bujumbura", "ဘူဂျွန်ဘူးရာ" },
            { "timezone.excity.Africa/Mogadishu", "မော်ဂါဒီးသျုး" },
            { "timezone.excity.America/Anguilla", "အန်ဂီလာ" },
            { "timezone.excity.America/Asuncion", "အာဆူစီအွန်း" },
            { "timezone.excity.America/Barbados", "ဘာဘေးဒိုးစ်" },
            { "timezone.excity.America/Dominica", "ဒိုမီနီကာ" },
            { "timezone.excity.America/Edmonton", "အက်ဒ်မွန်တန်" },
            { "timezone.excity.America/Eirunepe", "အီရူနီပီ" },
            { "timezone.excity.America/Mazatlan", "မာဇတ်လန်" },
            { "timezone.excity.America/Miquelon", "မီကွီလွန်" },
            { "timezone.excity.America/New_York", "နယူးယောက်" },
            { "timezone.excity.America/Resolute", "ရီဆိုလုပ်(တ်)" },
            { "timezone.excity.America/Santarem", "ဆန်တာရမ်" },
            { "timezone.excity.America/Santiago", "ဆန်တီအာဂို" },
            { "timezone.excity.America/St_Johns", "စိန့်ဂျွန်း" },
            { "timezone.excity.America/St_Kitts", "စိန့်ကိစ်" },
            { "timezone.excity.America/St_Lucia", "စိန့်လူစီယာ" },
            { "timezone.excity.America/Winnipeg", "ဝီနီဗက်ဂ်" },
            { "timezone.excity.Antarctica/Casey", "ကေစီ" },
            { "timezone.excity.Antarctica/Davis", "ဒေးဗစ်" },
            { "timezone.excity.Antarctica/Syowa", "ရှိုးဝါ" },
            { "timezone.excity.Antarctica/Troll", "ထရိုလ်" },
            { "timezone.excity.Asia/Krasnoyarsk", "ခရာ့စ်နိုရာစ်" },
            { "timezone.excity.Asia/Novosibirsk", "နိုဗိုစဲဘီအဲယ်စ်" },
            { "timezone.excity.Asia/Ulaanbaatar", "ဥလန်ဘာတော" },
            { "timezone.excity.Asia/Vladivostok", "ဗလာဒီဗော့စတော့ခ်" },
            { "timezone.excity.Atlantic/Bermuda", "ဘာမြူဒါ" },
            { "timezone.excity.Atlantic/Madeira", "မဒီးရာ" },
            { "timezone.excity.Atlantic/Stanley", "စတန်လေ" },
            { "timezone.excity.Australia/Darwin", "ဒါဝင်" },
            { "timezone.excity.Australia/Hobart", "ဟိုးဘားတ်" },
            { "timezone.excity.Australia/Sydney", "ဆစ်ဒနီ" },
            { "timezone.excity.Europe/Amsterdam", "အမ်စတာဒမ်" },
            { "timezone.excity.Europe/Astrakhan", "အားစ်တရခန်း" },
            { "timezone.excity.Europe/Bucharest", "ဘူခါရက်စ်" },
            { "timezone.excity.Europe/Gibraltar", "ဂျီဘရော်လ်တာ" },
            { "timezone.excity.Europe/Ljubljana", "လူဘလီအားနား" },
            { "timezone.excity.Europe/Mariehamn", "မရီအာ ဟားမန်" },
            { "timezone.excity.Europe/Podgorica", "ပေါ့ဂိုရီကာ" },
            { "timezone.excity.Europe/Stockholm", "စတော့ဟုမ်း" },
            { "timezone.excity.Europe/Ulyanovsk", "အူလီယာနိုစကစ်ဖ်" },
            { "timezone.excity.Europe/Volgograd", "ဗိုလ်ဂိုဂရက်" },
            { "timezone.excity.Indian/Christmas", "ခရစ်စမတ်" },
            { "timezone.excity.Indian/Kerguelen", "ခါဂါလန်" },
            { "timezone.excity.Indian/Mauritius", "မောရစ်ရှ" },
            { "timezone.excity.Pacific/Auckland", "အော့ကလန်" },
            { "timezone.excity.Pacific/Funafuti", "ဖူနာဖူတီ" },
            { "timezone.excity.Pacific/Honolulu", "ဟိုနိုလူလူ" },
            { "timezone.excity.Pacific/Pitcairn", "ပါတ်ကယ်ရင်" },
            { "timezone.excity.Africa/Casablanca", "ကာဆာဘလန်ကာ" },
            { "timezone.excity.Africa/Libreville", "လီဗရာဗီးလ်" },
            { "timezone.excity.Africa/Lubumbashi", "လူဘွန်းဘာရှီ" },
            { "timezone.excity.Africa/Nouakchott", "နိုအာ့ခ်ရှော့တ်" },
            { "timezone.excity.Africa/Porto-Novo", "ပိုတို-နိုဗို" },
            { "timezone.excity.America/Anchorage", "အန်ကာရေ့ဂျ်" },
            { "timezone.excity.America/Araguaina", "အာရာဂွါအီနာ" },
            { "timezone.excity.America/Boa_Vista", "ဘိုအာဗီစ်တာ" },
            { "timezone.excity.America/Catamarca", "ကာတာမာရကာ" },
            { "timezone.excity.America/Chihuahua", "ချီဟူအာဟူအာ" },
            { "timezone.excity.America/Coyhaique", "ကွိုင်းဟိုင်ခ်" },
            { "timezone.excity.America/Fortaleza", "ဖို့တ်တာလီဇာ" },
            { "timezone.excity.America/Glace_Bay", "ဂလဲစ်ဘေး" },
            { "timezone.excity.America/Goose_Bay", "ဂူးစ်ဘေး" },
            { "timezone.excity.America/Guatemala", "ဂွါတီမာလာ" },
            { "timezone.excity.America/Guayaquil", "ဂွါရာကွီးလ်" },
            { "timezone.excity.America/Matamoros", "မာတာမိုရိုစ်" },
            { "timezone.excity.America/Menominee", "မီနိုမီနီး" },
            { "timezone.excity.America/Monterrey", "မွန်တဲရေး" },
            { "timezone.excity.America/Sao_Paulo", "ဆော်ပိုလို" },
            { "timezone.excity.America/St_Thomas", "စိန့်သောမတ်စ်" },
            { "timezone.excity.America/Vancouver", "ဗန်ကူးဗား" },
            { "timezone.excity.Antarctica/Mawson", "မော်စွန်" },
            { "timezone.excity.Antarctica/Palmer", "ပါလ်မာ" },
            { "timezone.excity.Antarctica/Vostok", "ဗိုစ်တိုခ်" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ကွာလာလမ်ပူ" },
            { "timezone.excity.Asia/Novokuznetsk", "နိုဗိုခူဇ်နက်စ်" },
            { "timezone.excity.Europe/Bratislava", "ဘရာတီးစ်လားဗာ" },
            { "timezone.excity.Europe/Copenhagen", "ကိုပင်ဟေဂင်" },
            { "timezone.excity.Europe/Luxembourg", "လူဇင်ဘတ်" },
            { "timezone.excity.Europe/San_Marino", "ဆန်မရီးနို" },
            { "timezone.excity.Europe/Simferopol", "စင်ဖာရိုးဖို" },
            { "timezone.excity.Pacific/Enderbury", "ကန်တွန်" },
            { "timezone.excity.Pacific/Galapagos", "ဂါလာပါကပ်စ်" },
            { "timezone.excity.Pacific/Kwajalein", "ခွာဂျာလိန်" },
            { "timezone.excity.Pacific/Marquesas", "မာခေးအပ်စ်" },
            { "timezone.excity.Pacific/Pago_Pago", "ပါဂိုပါဂို" },
            { "timezone.excity.Pacific/Rarotonga", "ရာရိုတွန်းဂါ" },
            { "timezone.excity.Pacific/Tongatapu", "တွန်ဂါတာပု" },
            { "timezone.excity.Africa/Addis_Ababa", "အားဒစ် အဘာဘာ" },
            { "timezone.excity.Africa/Brazzaville", "ဘရားဇာဗီးလ်" },
            { "timezone.excity.Africa/Ouagadougou", "ဝါဂါဒူးဂူ" },
            { "timezone.excity.America/Costa_Rica", "ကို့စတာရီကာ" },
            { "timezone.excity.America/Grand_Turk", "ဂရန်ဒ် တခ်" },
            { "timezone.excity.America/Guadeloupe", "ဂွါဒီလုပ်" },
            { "timezone.excity.America/Hermosillo", "ဟာမိုစ်စီလို" },
            { "timezone.excity.America/Kralendijk", "ခရာလဲန်းဒစ်ချ်" },
            { "timezone.excity.America/Louisville", "လူဝီဗီးလ်" },
            { "timezone.excity.America/Martinique", "မာတီနီဂ်" },
            { "timezone.excity.America/Metlakatla", "မက်တ်လာကက်လာ" },
            { "timezone.excity.America/Montevideo", "မွန်တီဗီဒီအို" },
            { "timezone.excity.America/Montserrat", "မွန့်(တ်)ဆေးရတ်" },
            { "timezone.excity.America/Paramaribo", "ပါရာမာရီဘို" },
            { "timezone.excity.America/Rio_Branco", "ရီယို ဘရန်ကို" },
            { "timezone.excity.America/St_Vincent", "စိန့်ဗင်းဆင့်" },
            { "timezone.excity.America/Whitehorse", "ဝိုက်(တ်)ဟိုစ်" },
            { "timezone.excity.Antarctica/McMurdo", "မက်မူဒိုး" },
            { "timezone.excity.Antarctica/Rothera", "ရိုသီရာ" },
            { "timezone.excity.Asia/Srednekolymsk", "ဆရစ်နစ်ကာလင်မ်စ်" },
            { "timezone.excity.Asia/Yekaterinburg", "ရယ်ခါးတီရင်ဘားခ်" },
            { "timezone.excity.Atlantic/Reykjavik", "ရေးကီဗစ်ခ်" },
            { "timezone.excity.Atlantic/St_Helena", "စိန့်ဟယ်လယ်နာ" },
            { "timezone.excity.Australia/Adelaide", "အန္ဒီလိတ်ဒ်" },
            { "timezone.excity.Australia/Brisbane", "ဘရစ္စဘိန်း" },
            { "timezone.excity.Australia/Lindeman", "လင်းဒီမန်း" },
            { "timezone.excity.Europe/Isle_of_Man", "မန်းကျွန်း" },
            { "timezone.excity.Europe/Kaliningrad", "ခါလီနင်ဂရက်" },
            { "timezone.excity.Pacific/Kiritimati", "ခရိဒီမတီ" },
            { "timezone.excity.Africa/Johannesburg", "ဂျိုဟန်းနက်စဘတ်" },
            { "timezone.excity.America/El_Salvador", "အယ်လ်ဆာဗေဒို" },
            { "timezone.excity.America/Fort_Nelson", "ဖို့တ် နယ်လ်ဆင်" },
            { "timezone.excity.America/Los_Angeles", "လော့စ်အိန်ဂျယ်လိစ်" },
            { "timezone.excity.America/Mexico_City", "မက်ကဆီကို စီးတီး" },
            { "timezone.excity.America/Porto_Velho", "ပို့တ်တို ဗဲလီယို" },
            { "timezone.excity.America/Puerto_Rico", "ပေါ်တိုရီကို" },
            { "timezone.excity.America/Tegucigalpa", "တီဂူစီဂလ်ပါ" },
            { "timezone.excity.Arctic/Longyearbyen", "လောင်ရီယားဘရံ" },
            { "timezone.excity.Atlantic/Cape_Verde", "ကိတ်ပ် ဗာဒီ" },
            { "timezone.excity.Australia/Lord_Howe", "လော့ဒ် ဟောင်" },
            { "timezone.excity.Australia/Melbourne", "မဲလ်ဘုန်း" },
            { "timezone.excity.Indian/Antananarivo", "အန်တာနာနာရီးဘို" },
            { "timezone.excity.Pacific/Guadalcanal", "ဂွါဒါကနဲလ်" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ဒါရက်စ်ဆာလမ်" },
            { "timezone.excity.America/Blanc-Sablon", "ဘလွန်ခ်-စာဘလွန်" },
            { "timezone.excity.America/Buenos_Aires", "ဗျူနိုအေးရိစ်" },
            { "timezone.excity.America/Campo_Grande", "ကိမ်ပို ဂရန်ဒီ" },
            { "timezone.excity.America/Danmarkshavn", "ဒန်မတ်ရှ်ဗာန်" },
            { "timezone.excity.America/Dawson_Creek", "ဒေါ်ဆန် ခရိခ်" },
            { "timezone.excity.America/Indiana/Knox", "နောက်ခ်စ်၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Indianapolis", "အင်ဒီယားနား ပိုလိစ်" },
            { "timezone.excity.America/Punta_Arenas", "ပွန်တာ အရီနာစ်" },
            { "timezone.excity.America/Rankin_Inlet", "ရန်ကင် အင်းလက်" },
            { "timezone.excity.America/Scoresbysund", "အစ်တာကာ တိုးမိရက်တ်" },
            { "timezone.excity.Antarctica/Macquarie", "မက်ကွယ်ရီ" },
            { "timezone.excity.Pacific/Bougainville", "ဘူဂန်ဗီးလီးယား" },
            { "timezone.excity.Pacific/Port_Moresby", "ဖို့တ် မိုရက်စ်ဘီ" },
            { "timezone.excity.America/Cambridge_Bay", "ကိန်းဘရစ်ချ် ဘေး" },
            { "timezone.excity.America/Ciudad_Juarez", "စီယူဒတ်စ် ဟွာရက်စ်" },
            { "timezone.excity.America/Coral_Harbour", "အာတီကိုကန်" },
            { "timezone.excity.America/Indiana/Vevay", "ဗီဗဲ၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Lower_Princes", "လိုအာပရင့်စ် ကွာတာ" },
            { "timezone.excity.America/Port_of_Spain", "ပို့တ် အော့ဖ် စပိန်" },
            { "timezone.excity.America/Santo_Domingo", "ဆန်တို ဒိုမင်းဂို" },
            { "timezone.excity.America/St_Barthelemy", "စိန့်ဘာသယ်လမီ" },
            { "timezone.excity.America/Swift_Current", "စွတ်ဖ်တ် ကားရင့်" },
            { "timezone.excity.Australia/Broken_Hill", "ဘရိုကင်ဟီးလ်" },
            { "timezone.excity.America/Bahia_Banderas", "ဘာဟီအာ ဘန်ဒရက်စ်" },
            { "timezone.excity.America/Port-au-Prince", "ပို့တ်-အို-ပရင့်စ်" },
            { "timezone.excity.Atlantic/South_Georgia", "တောင်ဂျော်ဂျီယာ" },
            { "timezone.excity.America/Argentina/Salta", "ဆာလ်တာ" },
            { "timezone.excity.America/Indiana/Marengo", "မာရန်ဂို၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Indiana/Winamac", "ဝီနာမက်ခ်၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Argentina/Tucuman", "တူကူမန်" },
            { "timezone.excity.America/Argentina/Ushuaia", "ဥဆွာအီအာ" },
            { "timezone.excity.America/Indiana/Tell_City", "တဲလ်စီးတီး၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Indiana/Vincennes", "ဗင်ဆင့်စ်၊ အင်ဒီယားနား" },
            { "timezone.excity.Antarctica/DumontDUrville", "ဒူးမော့တ် ဒါရ်ဗီးလ်" },
            { "timezone.excity.America/Argentina/La_Rioja", "လာ ရီယိုဟာ" },
            { "timezone.excity.America/Argentina/San_Juan", "ဆန် ဂွမ်" },
            { "timezone.excity.America/Argentina/San_Luis", "ဆန် လူဝီစ်" },
            { "timezone.excity.America/Indiana/Petersburg", "ပီတာစ်ဘတ်ခ်၊ အင်ဒီယားနား" },
            { "timezone.excity.America/Kentucky/Monticello", "မွန်တီချယ်လို၊ ကင်တပ်ကီ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ဗြူလာ၊ မြောက်ဒါကိုတာ" },
            { "timezone.excity.America/North_Dakota/Center", "စင်တာ၊ မြောက်ဒါကိုတာ" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ရီယို ဂါလီဂိုစ်" },
            { "timezone.excity.America/North_Dakota/New_Salem", "နယူးဆေးလမ်၊ မြောက်ဒါကိုတာ" },
        };
        return data;
    }
}
