# Release Notes - v2.8.36

**Date**: 2026-02-13

## 📝 Executive Summary

```text
2.8.36 2026-02-13

- fix: migrate CI workflows to native GitHub services to resolve Docker API version mismatch.
- fix: modernize release workflow using softprops/action-gh-release@v2.
- fix: enhance Docker publishing with Buildx setup for reliable multi-platform builds.
- fix: robust, version-agnostic detection of password column in mysql.user via schema inspection (Issue #22).
- fix: correct regression in tests/test_issue_875.t by updating database mocks.
- fix: prevent creation of directory "0" when --dumpdir is not specified or set to 0 (Issue #20).
- test: add comprehensive test suite for password column detection (tests/repro_issue_22.t).
- test: add reproduction test for Performance Schema disabled diagnostic (tests/repro_pfs_disabled.t).
- test: add reproduction test for Performance Schema disabled scenario (repro_pfs_disabled.t).
- ci: fix Docker API mismatch in GitHub Actions by migrating to native services.
- docs: fix broken endoflife.date links in README files (Issue #877).
```

## 📈 Diagnostic Growth Indicators

| Metric | Current | Progress | Status |
| :--- | :--- | :--- | :--- |
| Total Indicators | 12 | 0 | 🛡️ |
| Efficiency Checks | 0 | 0 | 🛡️ |
| Risk Detections | 2 | 0 | 🛡️ |
| Information Points | 10 | 0 | 🛡️ |

## 🛠️ Internal Commit History

- feat(release): release 2.8.36 (2c1465c)
- feat(update changelog and release notes for issue #877): docs (ce08d34)
- fix(security): robust version-agnostic password column detection (Issue #22) (2450ebb)
- docs: synchronize agent roadmap (8e207f7)
- chore: fix typo in release-manager workflow (test-it -> test-all) (0c7a175)
- docs: generate vulnerabilities list (6fc12e6)
- docs: generate FEATURES.md (2b9415e)
- chore: update Makefile to use Conventional Commits for generation targets (b00aedb)
- style: tidy mysqltuner.pl (5ee6751)
- feat: release 2.8.36 (0e84219)
- fix: normalize CLI option keys in %opt to strip Getopt modifiers (79daa70)
- docs: add systemic system call audit and core perl replacement candidates (daa60f8)
- test: record laboratory audit findings in POTENTIAL_ISSUES (e801b8d)
- chore: bump version to 2.8.36 (6a5b075)

## ⚙️ Technical Evolutions

*Internal logic hardening (no interface or diagnostic changes).*

## ✅ Laboratory Verification Results

- [x] Automated TDD suite passed.
- [x] Multi-DB version laboratory execution validated.
- [x] Performance indicator delta analysis completed.
