/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.util.HashMap;
import java.util.Map;

class UserFieldDataType<E extends Enum<E>> {
    private final Class<E> m_class;
    private final Map<String, Integer> m_counters = new HashMap<String, Integer>();
    private static final Map<Integer, String> TYPE_MAP = new HashMap<Integer, String>();

    public UserFieldDataType(Class<E> clazz) {
        this.m_class = clazz;
    }

    public E nextField(Integer dataType) {
        try {
            String customFieldName = TYPE_MAP.get(dataType);
            int index = this.m_counters.compute(customFieldName, (k, v) -> v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1));
            return Enum.valueOf(this.m_class, customFieldName + index);
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        TYPE_MAP.put(0, "FLAG");
        TYPE_MAP.put(6, "NUMBER");
        TYPE_MAP.put(8, "NUMBER");
        TYPE_MAP.put(9, "TEXT");
        TYPE_MAP.put(13, "DATE");
        TYPE_MAP.put(15, "DURATION");
        TYPE_MAP.put(24, "TEXT");
    }
}

