/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.output.DBCOutputSeverity;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReaderExt;
import org.jkiss.dbeaver.model.impl.AsyncServerOutputReader;
import org.jkiss.utils.BeanUtils;

public class PostgreServerOutputReader
extends AsyncServerOutputReader
implements DBCServerOutputReaderExt {
    private static final String PSQL_WARNING_CLASS = "org.postgresql.util.PSQLWarning";
    private static final String PSQL_WARNING_GET_SERVER_ERROR_MESSAGE_METHOD = "getServerErrorMessage";
    private static final String SERVER_ERROR_MESSAGE_MESSAGE_PARTS = "mesgParts";
    private static final Character SERVER_ERROR_MESSAGE_SEVERITY_LOCALIZED = Character.valueOf('S');
    private static final Character SERVER_ERROR_MESSAGE_SEVERITY = Character.valueOf('V');

    @NotNull
    public DBCOutputSeverity[] getSupportedSeverities(@NotNull DBCExecutionContext context) {
        return PostgreOutputSeverity.values();
    }

    protected void dumpWarning(@NotNull DBCOutputWriter output, @NotNull Throwable warning) {
        output.println(PostgreServerOutputReader.getSeverity(warning), warning.getMessage());
    }

    @Nullable
    private static DBCOutputSeverity getSeverity(@NotNull Throwable warning) {
        if (!PSQL_WARNING_CLASS.equals(warning.getClass().getName())) {
            return null;
        }
        try {
            Object obj = BeanUtils.invokeObjectMethod((Object)warning, (String)PSQL_WARNING_GET_SERVER_ERROR_MESSAGE_METHOD);
            Map parts = (Map)BeanUtils.getFieldValue((Object)obj, (String)SERVER_ERROR_MESSAGE_MESSAGE_PARTS);
            String severity = parts.containsKey(SERVER_ERROR_MESSAGE_SEVERITY) ? (String)parts.get(SERVER_ERROR_MESSAGE_SEVERITY) : (String)parts.get(SERVER_ERROR_MESSAGE_SEVERITY_LOCALIZED);
            return PostgreOutputSeverity.valueOf(severity);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private static enum PostgreOutputSeverity implements DBCOutputSeverity
    {
        DEBUG("Debug"),
        LOG("Log"),
        INFO("Info"),
        NOTICE("Notice"),
        WARNING("Warning"),
        ERROR("Error");

        private final String name;

        private PostgreOutputSeverity(String name) {
            this.name = name;
        }

        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

