/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.prompt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.AIPromptGenerator;
import org.jkiss.dbeaver.model.ai.AISettings;
import org.jkiss.dbeaver.model.ai.engine.AIDatabaseContext;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIPromptGeneratorRegistry;
import org.jkiss.dbeaver.model.ai.registry.AISettingsManager;
import org.jkiss.utils.CommonUtils;

public abstract class AIPromptAbstract
implements AIPromptGenerator {
    private final List<String> instructions = new ArrayList<String>();
    private final List<String> examples = new ArrayList<String>();
    private final List<String> contexts = new ArrayList<String>();
    private final List<String> outputFormats = new ArrayList<String>();

    protected AIPromptAbstract() {
    }

    public AIPromptAbstract addExamples(String ... examples) {
        this.examples.addAll(Arrays.asList(examples));
        return this;
    }

    public AIPromptAbstract addInstructions(String ... instructions) {
        this.instructions.addAll(Arrays.asList(instructions));
        return this;
    }

    public AIPromptAbstract addContexts(String ... contexts) {
        this.contexts.addAll(Arrays.asList(contexts));
        return this;
    }

    public AIPromptAbstract addOutputFormats(String ... outputFormats) {
        this.outputFormats.addAll(Arrays.asList(outputFormats));
        return this;
    }

    protected void clear() {
        this.examples.clear();
        this.instructions.clear();
        this.contexts.clear();
        this.outputFormats.clear();
    }

    @Override
    @NotNull
    public String build(@Nullable AIDatabaseContext context) {
        String customInstructions;
        this.clear();
        this.initializePrompt(context);
        AISettings settings = AISettingsManager.getInstance().getSettings();
        AIPromptGeneratorDescriptor gd = AIPromptGeneratorRegistry.getInstance().getPromptGenerator(this.generatorId());
        if (gd != null && settings.getFunctionSettings().isFunctionsEnabled()) {
            for (AIPromptGeneratorDescriptor.Uses use : gd.getUses()) {
                if (!settings.getFunctionSettings().getEnabledFunctions().contains(use.function())) continue;
                this.addInstructions(use.instructions());
            }
        }
        if (CommonUtils.isNotEmpty((String)(customInstructions = settings.getCustomInstructions(this.generatorId())))) {
            this.addInstructions(customInstructions);
        }
        StringBuilder prompt = new StringBuilder();
        if (!this.instructions.isEmpty()) {
            prompt.append("Instructions:\n");
            this.instructions.forEach(instruction -> prompt.append("- ").append((String)instruction).append("\n"));
        }
        if (!this.examples.isEmpty()) {
            prompt.append("\nExamples:\n");
            this.examples.forEach(example -> prompt.append("- ").append((String)example).append("\n"));
        }
        if (!this.contexts.isEmpty()) {
            prompt.append("\nContext:\n");
            this.contexts.forEach(ctx -> prompt.append("- ").append((String)ctx).append("\n"));
        }
        if (!this.outputFormats.isEmpty()) {
            prompt.append("\nOutput Format:\n");
            this.outputFormats.forEach(outputFormat -> prompt.append("- ").append((String)outputFormat).append("\n"));
        }
        return prompt.toString();
    }

    protected abstract void initializePrompt(@Nullable AIDatabaseContext var1);
}

