﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/SourceRevision.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CodePipeline {
namespace Model {

SourceRevision::SourceRevision(JsonView jsonValue) { *this = jsonValue; }

SourceRevision& SourceRevision::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("actionName")) {
    m_actionName = jsonValue.GetString("actionName");
    m_actionNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("revisionId")) {
    m_revisionId = jsonValue.GetString("revisionId");
    m_revisionIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("revisionSummary")) {
    m_revisionSummary = jsonValue.GetString("revisionSummary");
    m_revisionSummaryHasBeenSet = true;
  }
  if (jsonValue.ValueExists("revisionUrl")) {
    m_revisionUrl = jsonValue.GetString("revisionUrl");
    m_revisionUrlHasBeenSet = true;
  }
  return *this;
}

JsonValue SourceRevision::Jsonize() const {
  JsonValue payload;

  if (m_actionNameHasBeenSet) {
    payload.WithString("actionName", m_actionName);
  }

  if (m_revisionIdHasBeenSet) {
    payload.WithString("revisionId", m_revisionId);
  }

  if (m_revisionSummaryHasBeenSet) {
    payload.WithString("revisionSummary", m_revisionSummary);
  }

  if (m_revisionUrlHasBeenSet) {
    payload.WithString("revisionUrl", m_revisionUrl);
  }

  return payload;
}

}  // namespace Model
}  // namespace CodePipeline
}  // namespace Aws
