/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.verifier.identity;

import com.sun.msv.grammar.xmlschema.XPath;
import com.sun.msv.verifier.identity.IDConstraintChecker;
import com.sun.msv.verifier.identity.Matcher;
import com.sun.msv.verifier.identity.MatcherBundle;
import org.relaxng.datatype.Datatype;
import org.xml.sax.SAXException;

public abstract class PathMatcher
extends MatcherBundle {
    private boolean matchFound = false;

    protected PathMatcher(IDConstraintChecker iDConstraintChecker, XPath[] xPathArray) {
        super(iDConstraintChecker);
        this.children = new Matcher[xPathArray.length];
        int n = 0;
        while (n < xPathArray.length) {
            this.children[n] = new SinglePathMatcher(xPathArray[n]);
            ++n;
        }
    }

    protected void start(String string, String string2) throws SAXException {
        if (this.matchFound) {
            this.onElementMatched(string, string2);
        }
        this.matchFound = false;
    }

    protected abstract void onElementMatched(String var1, String var2) throws SAXException;

    protected abstract void onAttributeMatched(String var1, String var2, String var3, Datatype var4) throws SAXException;

    protected void startElement(String string, String string2) throws SAXException {
        super.startElement(string, string2);
        if (this.matchFound) {
            this.onElementMatched(string, string2);
        }
        this.matchFound = false;
    }

    protected void onAttribute(String string, String string2, String string3, Datatype datatype) throws SAXException {
        super.onAttribute(string, string2, string3, datatype);
        if (this.matchFound) {
            this.onAttributeMatched(string, string2, string3, datatype);
        }
        this.matchFound = false;
    }

    private class SinglePathMatcher
    extends Matcher {
        private boolean[][] activeSteps;
        protected final XPath path;
        private boolean elementMatched = false;

        protected SinglePathMatcher(XPath xPath) {
            super(PathMatcher.this.owner);
            this.path = xPath;
            this.activeSteps = new boolean[4][];
            this.activeSteps[0] = new boolean[xPath.steps.length + 1];
            this.activeSteps[0][0] = true;
            if (xPath.steps.length == 0) {
                if (xPath.attributeStep == null) {
                    PathMatcher.this.matchFound = true;
                } else {
                    this.elementMatched = true;
                }
            }
        }

        protected void startElement(String string, String string2) throws SAXException {
            this.elementMatched = false;
            int n = PathMatcher.this.getDepth();
            if (n == this.activeSteps.length - 1) {
                boolean[][] blArrayArray = new boolean[n * 2][];
                System.arraycopy(this.activeSteps, 0, blArrayArray, 0, this.activeSteps.length);
                this.activeSteps = blArrayArray;
            }
            int n2 = this.path.steps.length;
            boolean[] blArray = this.activeSteps[n - 1];
            boolean[] blArray2 = this.activeSteps[n];
            if (blArray2 == null) {
                blArray2 = new boolean[n2 + 1];
                this.activeSteps[n] = blArray2;
            }
            if (n2 != 0) {
                System.arraycopy(blArray, 0, blArray2, 1, n2);
                blArray2[0] = this.path.isAnyDescendant;
            }
            int n3 = 1;
            while (n3 <= n2) {
                if (blArray2[n3] && !this.path.steps[n3 - 1].accepts(string, string2)) {
                    blArray2[n3] = false;
                }
                ++n3;
            }
            if (blArray2[n2]) {
                if (this.path.attributeStep == null) {
                    PathMatcher.this.matchFound = true;
                } else {
                    this.elementMatched = true;
                }
            }
        }

        protected void onAttribute(String string, String string2, String string3, Datatype datatype) throws SAXException {
            if (!this.elementMatched) {
                return;
            }
            if (this.path.attributeStep.accepts(string, string2)) {
                PathMatcher.this.matchFound = true;
            }
        }

        protected void endElement(Datatype datatype) {
            this.elementMatched = false;
        }
    }
}

