/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	v1 "kubevirt.io/api/core/v1"
	corev1 "kubevirt.io/client-go/kubevirt/typed/core/v1"
)

// fakeKubeVirts implements KubeVirtInterface
type fakeKubeVirts struct {
	*gentype.FakeClientWithList[*v1.KubeVirt, *v1.KubeVirtList]
	Fake *FakeKubevirtV1
}

func newFakeKubeVirts(fake *FakeKubevirtV1, namespace string) corev1.KubeVirtInterface {
	return &fakeKubeVirts{
		gentype.NewFakeClientWithList[*v1.KubeVirt, *v1.KubeVirtList](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("kubevirts"),
			v1.SchemeGroupVersion.WithKind("KubeVirt"),
			func() *v1.KubeVirt { return &v1.KubeVirt{} },
			func() *v1.KubeVirtList { return &v1.KubeVirtList{} },
			func(dst, src *v1.KubeVirtList) { dst.ListMeta = src.ListMeta },
			func(list *v1.KubeVirtList) []*v1.KubeVirt { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.KubeVirtList, items []*v1.KubeVirt) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
