/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.util;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class SameThreadExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    protected volatile boolean terminated;

    @Override
    public void shutdown() {
        this.terminated = true;
    }

    @Override
    @NonNullByDefault(value={})
    public List<Runnable> shutdownNow() {
        this.terminated = true;
        return List.of();
    }

    @Override
    public boolean isShutdown() {
        return this.terminated;
    }

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public boolean awaitTermination(long timeout, @Nullable TimeUnit unit) throws InterruptedException {
        return this.terminated;
    }

    @Override
    public void execute(@Nullable Runnable command) {
        Objects.requireNonNull(command);
        command.run();
    }

    @Override
    public <T> Future<T> submit(@Nullable Callable<T> task) {
        Objects.requireNonNull(task);
        FutureTask<T> future = new FutureTask<T>(task);
        future.run();
        return future;
    }

    @Override
    public Future<?> submit(@Nullable Runnable task) {
        Objects.requireNonNull(task);
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        future.run();
        return future;
    }

    @Override
    public <T> Future<T> submit(@Nullable Runnable task, @Nullable T result) {
        Objects.requireNonNull(task);
        FutureTask<T> future = new FutureTask<T>(task, result);
        future.run();
        return future;
    }

    @Override
    public ScheduledFuture<?> schedule(@Nullable Runnable command, long delay, @Nullable TimeUnit unit) {
        Objects.requireNonNull(command);
        if (delay == 0L) {
            FutureTask<Object> future = new FutureTask<Object>(command, null);
            future.run();
            return new ImpostorScheduledFuture<Object>(future);
        }
        throw new UnsupportedOperationException("Delayed schedule not supported by SameThreadExecutorService");
    }

    @Override
    public <V> ScheduledFuture<V> schedule(@Nullable Callable<V> callable, long delay, @Nullable TimeUnit unit) {
        Objects.requireNonNull(callable);
        if (delay == 0L) {
            FutureTask<V> future = new FutureTask<V>(callable);
            future.run();
            return new ImpostorScheduledFuture<V>(future);
        }
        throw new UnsupportedOperationException("Delayed schedule not supported by SameThreadExecutorService");
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(@Nullable Runnable task, long initialDelay, long period, @Nullable TimeUnit unit) {
        Objects.requireNonNull(task);
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        future.run();
        return new ImpostorScheduledFuture<Object>(future);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(@Nullable Runnable task, long initialDelay, long delay, @Nullable TimeUnit unit) {
        Objects.requireNonNull(task);
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        future.run();
        return new ImpostorScheduledFuture<Object>(future);
    }

    protected static class ImpostorScheduledFuture<T>
    implements ScheduledFuture<T> {
        protected final Future<T> delegate;

        public ImpostorScheduledFuture(Future<T> future) {
            this.delegate = future;
        }

        @Override
        public long getDelay(@Nullable TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(@Nullable Delayed other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return -1;
            }
            long diff = 0L - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public T get(long timeout, @Nullable TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }
    }
}

