/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_gu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "ગ્રીનવિચ મધ્યમ સમય",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "એકર પ્રમાણભૂત સમય",
               "",
               "એકર ગ્રીષ્મ સમય",
               "",
               "એકર સમય",
               "",
            };
        final String[] Apia = new String[] {
               "એપિયા માનક સમય",
               "",
               "એપિયા દિવસ સમય",
               "",
               "એપિયા સમય",
               "",
            };
        final String[] Cook = new String[] {
               "કુક આઇલેન્ડ્સ માનક સમય",
               "",
               "કુક આઇલેન્ડ્સ અર્ધ ગ્રીષ્મ સમય",
               "",
               "કુક આઇલેન્ડ્સ સમય",
               "",
            };
        final String[] Cuba = new String[] {
               "ક્યુબા માનક સમય",
               "CST",
               "ક્યુબા દિવસ સમય",
               "CDT",
               "ક્યુબા સમય",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ફીજી માનક સમય",
               "",
               "ફીજી ગ્રીષ્મ સમય",
               "",
               "ફીજી સમય",
               "",
            };
        final String[] Gulf = new String[] {
               "ગલ્ફ માનક સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "હોવ્ડ માનક સમય",
               "",
               "હોવ્ડ ગ્રીષ્મ સમય",
               "",
               "હોવ્ડ સમય",
               "",
            };
        final String[] Iran = new String[] {
               "ઈરાન માનક સમય",
               "",
               "ઈરાન દિવસ સમય",
               "",
               "ઈરાન સમય",
               "",
            };
        final String[] Niue = new String[] {
               "નીયુ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ઓમ્સ્ક માનક સમય",
               "",
               "ઓમ્સ્ક ગ્રીષ્મ સમય",
               "",
               "ઓમ્સ્ક સમય",
               "",
            };
        final String[] Peru = new String[] {
               "પેરુ માનક સમય",
               "",
               "પેરુ ગ્રીષ્મ સમય",
               "",
               "પેરુ સમય",
               "",
            };
        final String[] Truk = new String[] {
               "ચુઉક સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "વૅક આઇલેન્ડ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ચિલી માનક સમય",
               "",
               "ચિલી ગ્રીષ્મ સમય",
               "",
               "ચિલી સમય",
               "",
            };
        final String[] China = new String[] {
               "ચીન માનક સમય",
               "CST",
               "ચીન દિવસ સમય",
               "CDT",
               "ચીન સમય",
               "CT",
            };
        final String[] Cocos = new String[] {
               "કોકોઝ આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ડેવિસ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ભારતીય માનક સમય",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "જાપાન માનક સમય",
               "JST",
               "જાપાન દિવસ સમય",
               "JDT",
               "જાપાન સમય",
               "JT",
            };
        final String[] Korea = new String[] {
               "કોરિયન માનક સમય",
               "KST",
               "કોરિયન દિવસ સમય",
               "KST",
               "કોરિયન સમય",
               "KST",
            };
        final String[] Nauru = new String[] {
               "નૌરુ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "નેપાળ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "પલાઉ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "સમોઆ માનક સમય",
               "SST",
               "સમોઆ ગ્રીષ્મ સમય",
               "SST",
               "સમોઆ સમય",
               "SST",
            };
        final String[] Syowa = new String[] {
               "સ્યોવા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ટોંગા માનક સમય",
               "",
               "ટોંગા ગ્રીષ્મ સમય",
               "",
               "ટોંગા સમય",
               "",
            };
        final String[] Yukon = new String[] {
               "યુકોન સમય",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "અલાસ્કા માનક સમય",
               "AKST",
               "અલાસ્કા દિવસ સમય",
               "AKDT",
               "અલાસ્કા સમય",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "એમેઝોન માનક સમય",
               "",
               "એમેઝોન ગ્રીષ્મ સમય",
               "",
               "એમેઝોન સમય",
               "",
            };
        final String[] Azores = new String[] {
               "એઝોર્સ માનક સમય",
               "",
               "એઝોર્સ ગ્રીષ્મ સમય",
               "",
               "એઝોર્સ સમય",
               "",
            };
        final String[] Bhutan = new String[] {
               "ભૂટાન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "બ્રુનેઇ દરુસલામ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ઇસ્ટર આઇલેન્ડ માનક સમય",
               "",
               "ઇસ્ટર આઇલેન્ડ ગ્રીષ્મ સમય",
               "",
               "ઇસ્ટર આઇલેન્ડ સમય",
               "",
            };
        final String[] Guyana = new String[] {
               "ગયાના સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "હવાઇ-એલ્યુશિઅન માનક સમય",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ઇઝરાઇલ માનક સમય",
               "IST",
               "ઇઝરાઇલ દિવસ સમય",
               "IDT",
               "ઇઝરાઇલ સમય",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "કોસરે સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "મોસન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "મોસ્કો માનક સમય",
               "MSK",
               "મોસ્કો ગ્રીષ્મ સમય",
               "MSK",
               "મોસ્કો સમય",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "પોનપે સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "સમારા પ્રમાણભૂત સમય",
               "",
               "સમારા ગ્રીષ્મ સમય",
               "",
               "સમારા સમય",
               "",
            };
        final String[] Tahiti = new String[] {
               "તાહિતી સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "તાઇપેઇ માનક સમય",
               "CST",
               "તાઇપેઇ દિવસ સમય",
               "CDT",
               "તાઇપેઇ સમય",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ટવાલૂ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "વોસ્ટોક સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "વૉલિસ અને ફ્યુચુના સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "અરેબિયન માનક સમય",
               "",
               "અરેબિયન દિવસ સમય",
               "",
               "અરેબિયન સમય",
               "",
            };
        final String[] Armenia = new String[] {
               "આર્મેનિયા માનક સમય",
               "",
               "આર્મેનિયા ગ્રીષ્મ સમય",
               "",
               "આર્મેનિયા સમય",
               "",
            };
        final String[] Bolivia = new String[] {
               "બોલિવિયા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ચેતહામ માનક સમય",
               "",
               "ચેતહામ દિવસ સમય",
               "",
               "ચેતહામ સમય",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "સંકલિત યુનિવર્સલ સમય",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "એક્વાડોર સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ગેમ્બિયર સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "જ્યોર્જિયા માનક સમય",
               "",
               "જ્યોર્જિયા ગ્રીષ્મ સમય",
               "",
               "જ્યોર્જિયા સમય",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ઇર્કુત્સ્ક માનક સમય",
               "",
               "ઇર્કુત્સ્ક ગ્રીષ્મ સમય",
               "",
               "ઇર્કુત્સ્ક સમય",
               "",
            };
        final String[] Magadan = new String[] {
               "મગાડન માનક સમય",
               "",
               "મગાડન ગ્રીષ્મ સમય",
               "",
               "મગાડન સમય",
               "",
            };
        final String[] Myanmar = new String[] {
               "મ્યાનમાર સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "નોરફૉક આઇલેન્ડ માનક સમય",
               "",
               "નોરફૉક આઇલેન્ડ દિવસ સમય",
               "",
               "નોરફૉક આઇલેન્ડ સમય",
               "",
            };
        final String[] Noronha = new String[] {
               "ફર્નાન્ડો ડી નોરોન્હા માનક સમય",
               "",
               "ફર્નાન્ડો દે નોરોહા ગ્રીષ્મ સમય",
               "",
               "ફર્નાન્ડો ડી નોરોન્હા સમય",
               "",
            };
        final String[] Reunion = new String[] {
               "રીયુનિયન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "રોથેરા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "સોલોમન આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ટોકલાઉ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ઉરુગ્વે માનક સમય",
               "",
               "ઉરુગ્વે ગ્રીષ્મ સમય",
               "",
               "ઉરુગ્વે સમય",
               "",
            };
        final String[] Vanuatu = new String[] {
               "વનાતૂ માનક સમય",
               "",
               "વનાતૂ ગ્રીષ્મ સમય",
               "",
               "વનાતૂ સમય",
               "",
            };
        final String[] Yakutsk = new String[] {
               "યાકુત્સ્ક માનક સમય",
               "",
               "યાકુત્સ્ક ગ્રીષ્મ સમય",
               "",
               "યાકુત્સ્ક સમય",
               "",
            };
        final String[] Atlantic = new String[] {
               "એટલાન્ટિક માનક સમય",
               "AST",
               "એટલાન્ટિક દિવસ સમય",
               "AST",
               "એટલાન્ટિક સમય",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "બ્રાઝિલિયા માનક સમય",
               "",
               "બ્રાઝિલિયા ગ્રીષ્મ સમય",
               "",
               "બ્રાઝિલિયા સમય",
               "",
            };
        final String[] Chamorro = new String[] {
               "કેમોરો માનક સમય",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "કોલમ્બિયા માનક સમય",
               "",
               "કોલમ્બિયા ગ્રીષ્મ સમય",
               "",
               "કોલમ્બિયા સમય",
               "",
            };
        final String[] Falkland = new String[] {
               "ફૉકલેન્ડ આઇલેન્ડ્સ માનક સમય",
               "",
               "ફૉકલેન્ડ આઇલેન્ડ્સ ગ્રીષ્મ સમય",
               "",
               "ફૉકલેન્ડ આઇલેન્ડ્સ સમય",
               "",
            };
        final String[] Malaysia = new String[] {
               "મલેશિયા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "માલદીવ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ઉલાન બાટોર માનક સમય",
               "",
               "ઉલાન બટોર ગ્રીષ્મ સમય",
               "",
               "ઉલાન બાટોર સમય",
               "",
            };
        final String[] Pakistan = new String[] {
               "પાકિસ્તાન માનક સમય",
               "PKT",
               "પાકિસ્તાન ગ્રીષ્મ સમય",
               "PKST",
               "પાકિસ્તાન સમય",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "પેરાગ્વે માનક સમય",
               "",
               "પેરાગ્વે ગ્રીષ્મ સમય",
               "",
               "પેરાગ્વે સમય",
               "",
            };
        final String[] Pitcairn = new String[] {
               "પિટકેયર્ન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "સુરીનામ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "આર્જેન્ટીના માનક સમય",
               "",
               "આર્જેન્ટીના ગ્રીષ્મ સમય",
               "",
               "આર્જેન્ટીના સમય",
               "",
            };
        final String[] Christmas = new String[] {
               "ક્રિસમસ આઇલેન્ડ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ગાલાપાગોસ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "હોંગ કોંગ માનક સમય",
               "HKT",
               "હોંગ કોંગ ગ્રીષ્મ સમય",
               "HKST",
               "હોંગ કોંગ સમય",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ઇન્ડોચાઇના સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી પ્રમાણભૂત સમય",
               "",
               "પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી ગ્રીષ્મ સમય",
               "",
               "પેટ્રોપેવલોવ્સ્ક-કામચતસ્કી સમય",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "કિર્ગિઝ્સ્તાન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "લોર્ડ હોવ માનક સમય",
               "",
               "લોર્ડ હોવ દિવસ સમય",
               "",
               "લોર્ડ હોવ સમય",
               "",
            };
        final String[] Marquesas = new String[] {
               "માર્ક્યૂસસ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "મોરિશિયસ માનક સમય",
               "",
               "મોરિશિયસ ગ્રીષ્મ સમય",
               "",
               "મોરિશિયસ સમય",
               "",
            };
        final String[] Singapore = new String[] {
               "સિંગાપુર માનક સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "વેનેઝુએલા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "અઝરબૈજાન માનક સમય",
               "",
               "અઝરબૈજાન ગ્રીષ્મ સમય",
               "",
               "અઝરબૈજાન સમય",
               "",
            };
        final String[] Bangladesh = new String[] {
               "બાંગ્લાદેશ માનક સમય",
               "",
               "બાંગ્લાદેશ ગ્રીષ્મ સમય",
               "",
               "બાંગ્લાદેશ સમય",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "કૅપ વર્ડે માનક સમય",
               "",
               "કૅપ વર્ડે ગ્રીષ્મ સમય",
               "",
               "કૅપ વર્ડે સમય",
               "",
            };
        final String[] East_Timor = new String[] {
               "પૂર્વ તિમોર સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "કઝાકિસ્તાન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "સેશલ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "તાજીકિસ્તાન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ઉઝ્બેકિસ્તાન માનક સમય",
               "",
               "ઉઝ્બેકિસ્તાન ગ્રીષ્મ સમય",
               "",
               "ઉઝ્બેકિસ્તાન સમય",
               "",
            };
        final String[] Afghanistan = new String[] {
               "અફઘાનિસ્તાન સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ક્રેસ્નોયાર્સ્ક માનક સમય",
               "",
               "ક્રેસ્નોયાર્સ્ક ગ્રીષ્મ સમય",
               "",
               "ક્રેસ્નોયાર્સ્ક સમય",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ન્યુઝીલેન્ડ માનક સમય",
               "NZST",
               "ન્યુઝીલેન્ડ દિવસ સમય",
               "NZDT",
               "ન્યુઝીલેન્ડ સમય",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ફિલિપાઇન માનક સમય",
               "PST",
               "ફિલિપાઇન ગ્રીષ્મ સમય",
               "PDT",
               "ફિલિપાઇન સમય",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "વ્લાડિવોસ્ટોક માનક સમય",
               "",
               "વ્લાડિવોસ્ટોક ગ્રીષ્મ સમય",
               "",
               "વ્લાડિવોસ્ટોક સમય",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ભારતીય મહાસાગર સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "લાઇન આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ન્યૂફાઉન્ડલેન્ડ માનક સમય",
               "NST",
               "ન્યૂફાઉન્ડલેન્ડ દિવસ સમય",
               "NDT",
               "ન્યૂફાઉન્ડલેન્ડ સમય",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "તુર્કમેનિસ્તાન માનક સમય",
               "",
               "તુર્કમેનિસ્તાન ગ્રીષ્મ સમય",
               "",
               "તુર્કમેનિસ્તાન સમય",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ફ્રેંચ ગયાના સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ન્યુ સેલેડોનિયા માનક સમય",
               "",
               "ન્યુ સેલેડોનિયા ગ્રીષ્મ સમય",
               "",
               "ન્યુ સેલેડોનિયા સમય",
               "",
            };
        final String[] South_Georgia = new String[] {
               "દક્ષિણ જ્યોર્જિયા સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "યેકાટેરિનબર્ગ માનક સમય",
               "",
               "યેકાટેરિનબર્ગ ગ્રીષ્મ સમય",
               "",
               "યેકાટેરિનબર્ગ સમય",
               "",
            };
        final String[] Africa_Central = new String[] {
               "મધ્ય આફ્રિકા સમય",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "પૂર્વ આફ્રિકા સમય",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "પશ્ચિમ આફ્રિકા સમય",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ડ્યુમોન્ટ-ડી‘ઉર્વિલ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "મધ્ય યુરોપિયન માનક સમય",
               "CET",
               "મધ્ય યુરોપિયન ગ્રીષ્મ સમય",
               "CEST",
               "મધ્ય યુરોપિયન સમય",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "પૂર્વી યુરોપિયન માનક સમય",
               "EET",
               "પૂર્વી યુરોપિયન ગ્રીષ્મ સમય",
               "EEST",
               "પૂર્વી યુરોપિયન સમય",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "પશ્ચિમી યુરોપિયન માનક સમય",
               "WET",
               "પશ્ચિમી યુરોપિયન ગ્રીષ્મ સમય",
               "WEST",
               "પશ્ચિમી યુરોપિયન સમય",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "મેક્સિકન પેસિફિક માનક સમય",
               "MST",
               "મેક્સિકન પેસિફિક દિવસ સમય",
               "MDT",
               "મેક્સિકન પેસિફિક સમય",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "દક્ષિણ આફ્રિકા માનક સમય",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ઉત્તર અમેરિકન કેન્દ્રીય માનક સમય",
               "CST",
               "ઉત્તર અમેરિકન કેન્દ્રીય દિવસ સમય",
               "CDT",
               "ઉત્તર અમેરિકન કેન્દ્રીય સમય",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ઉત્તર અમેરિકન પૂર્વી માનક સમય",
               "EST",
               "ઉત્તર અમેરિકન પૂર્વી દિવસ સમય",
               "EST",
               "ઉત્તર અમેરિકન પૂર્વી સમય",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ઉત્તર અમેરિકન પેસિફિક માનક સમય",
               "PST",
               "ઉત્તર અમેરિકન પેસિફિક દિવસ સમય",
               "PDT",
               "ઉત્તર અમેરિકન પેસિફિક સમય",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ફ્રેંચ સધર્ન અને એન્ટાર્કટિક સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ગિલબર્ટ આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "હવાઇ-એલ્યુશિઅન માનક સમય",
               "HST",
               "હવાઇ-એલ્યુશિઅન દિવસ સમય",
               "HDT",
               "હવાઈ-એલ્યુશિઅન સમય",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ફોનિક્સ આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "સેંટ પીએરી અને મિક્યુલોન માનક સમય",
               "",
               "સેંટ પીએરી અને મિક્યુલોન દિવસ સમય",
               "",
               "સેંટ પીએરી અને મિક્યુલોન સમય",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ઉત્તર અમેરિકન માઉન્ટન માનક સમય",
               "MST",
               "ઉત્તર અમેરિકન માઉન્ટન દિવસ સમય",
               "MST",
               "ઉત્તર અમેરિકન માઉન્ટન સમય",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "માર્શલ આઇલેન્ડ્સ સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "પાપુઆ ન્યુ ગિની સમય",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ઑસ્ટ્રેલિયન કેન્દ્રીય માનક સમય",
               "ACST",
               "ઓસ્ટ્રેલિયન કેન્દ્રીય દિવસ સમય",
               "ACDT",
               "કેન્દ્રીય ઑસ્ટ્રેલિયન સમય",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ઑસ્ટ્રેલિયન પૂર્વીય માનક સમય",
               "AEST",
               "ઓસ્ટ્રેલિયન પૂર્વીય દિવસ સમય",
               "AEDT",
               "પૂર્વીય ઑસ્ટ્રેલિયા સમય",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ઑસ્ટ્રેલિયન પશ્ચિમી માનક સમય",
               "AWST",
               "ઓસ્ટ્રેલિયન પશ્ચિમી દિવસ સમય",
               "AWDT",
               "પશ્ચિમી ઑસ્ટ્રેલિયા સમય",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "મધ્ય ઇન્ડોનેશિયા સમય",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "પૂર્વીય ઇન્ડોનેશિયા સમય",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "પશ્ચિમી ઇન્ડોનેશિયા સમય",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ઑસ્ટ્રેલિયન કેન્દ્રીય પશ્ચિમી માનક સમય",
               "",
               "ઓસ્ટ્રેલિયન કેન્દ્રીય પશ્ચિમી દિવસ સમય",
               "",
               "ઑસ્ટ્રેલિયન કેન્દ્રીય પશ્ચિમી સમય",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "આઈરિશ માનક સમય",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "સંકલિત યુનિવર્સલ સમય",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "આઈરિશ માનક સમય",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "ગ્રીનવિચ મધ્યમ સમય",
                    "GMT",
                    "બ્રિટિશ ગ્રીષ્મ સમય",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "એદેન" },
            { "timezone.excity.Asia/Baku", "બાકુ" },
            { "timezone.excity.Asia/Dili", "દિલિ" },
            { "timezone.excity.Asia/Gaza", "ગાઝા" },
            { "timezone.excity.Asia/Hovd", "હોવ્ડ" },
            { "timezone.excity.Asia/Omsk", "ઓમ્સ્ક" },
            { "timezone.excity.Asia/Oral", "ઓરલ" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "અમ્માન" },
            { "timezone.excity.Asia/Aqtau", "અકટાઉ" },
            { "timezone.excity.Asia/Chita", "ચિતા" },
            { "timezone.excity.Asia/Dhaka", "ઢાકા" },
            { "timezone.excity.Asia/Dubai", "દુબઈ" },
            { "timezone.excity.Asia/Kabul", "કાબુલ" },
            { "timezone.excity.Asia/Macau", "મકાઉ" },
            { "timezone.excity.Asia/Qatar", "કતાર" },
            { "timezone.excity.Asia/Seoul", "સીઓલ" },
            { "timezone.excity.Asia/Tokyo", "ટોક્યો" },
            { "timezone.excity.Asia/Tomsk", "તોમસ્ક" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "જુબા" },
            { "timezone.excity.Africa/Lome", "લોમ" },
            { "timezone.excity.Asia/Almaty", "અલ્માટી" },
            { "timezone.excity.Asia/Anadyr", "અનદિર" },
            { "timezone.excity.Asia/Aqtobe", "ઍક્ટોબ" },
            { "timezone.excity.Asia/Atyrau", "અત્યારુ" },
            { "timezone.excity.Asia/Beirut", "બૈરુત" },
            { "timezone.excity.Asia/Brunei", "બ્રુનેઇ" },
            { "timezone.excity.Asia/Hebron", "હેબ્રોન" },
            { "timezone.excity.Asia/Kuwait", "કુવૈત" },
            { "timezone.excity.Asia/Manila", "મનિલા" },
            { "timezone.excity.Asia/Muscat", "મસ્કત" },
            { "timezone.excity.Asia/Riyadh", "રિયાધ" },
            { "timezone.excity.Asia/Saigon", "હો ચી મીન સિટી" },
            { "timezone.excity.Asia/Taipei", "તાઇપેઇ" },
            { "timezone.excity.Asia/Tehran", "તેહરાન" },
            { "timezone.excity.Asia/Urumqi", "ઉરુમ્કી" },
            { "timezone.excity.Etc/Unknown", "અજ્ઞાત શહેર" },
            { "timezone.excity.Europe/Kiev", "કૈવ" },
            { "timezone.excity.Europe/Oslo", "ઑસ્લો" },
            { "timezone.excity.Europe/Riga", "રિગા" },
            { "timezone.excity.Europe/Rome", "રોમ" },
            { "timezone.excity.Indian/Mahe", "માહે" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ઍકરા" },
            { "timezone.excity.Africa/Cairo", "કૈરો" },
            { "timezone.excity.Africa/Ceuta", "ક્વેટા" },
            { "timezone.excity.Africa/Dakar", "ડકાર" },
            { "timezone.excity.Africa/Lagos", "લાગોસ" },
            { "timezone.excity.Africa/Tunis", "ટ્યુનિસ" },
            { "timezone.excity.America/Adak", "અદક" },
            { "timezone.excity.America/Lima", "લિમા" },
            { "timezone.excity.America/Nome", "નોમ" },
            { "timezone.excity.Asia/Baghdad", "બગદાદ" },
            { "timezone.excity.Asia/Bahrain", "બેહરીન" },
            { "timezone.excity.Asia/Bangkok", "બેંગકોક" },
            { "timezone.excity.Asia/Barnaul", "બારનૌલ" },
            { "timezone.excity.Asia/Bishkek", "બિશકેક" },
            { "timezone.excity.Asia/Colombo", "કોલંબો" },
            { "timezone.excity.Asia/Irkutsk", "ઇર્કુત્સ્ક" },
            { "timezone.excity.Asia/Jakarta", "જકાર્તા" },
            { "timezone.excity.Asia/Karachi", "કરાચી" },
            { "timezone.excity.Asia/Kuching", "કુચિંગ" },
            { "timezone.excity.Asia/Magadan", "મેગાડન" },
            { "timezone.excity.Asia/Nicosia", "નિકોસિયા" },
            { "timezone.excity.Asia/Rangoon", "રંગૂન" },
            { "timezone.excity.Asia/Tbilisi", "બિલિસિ" },
            { "timezone.excity.Asia/Thimphu", "થીમ્ફુ" },
            { "timezone.excity.Asia/Yakutsk", "યકુત્સક" },
            { "timezone.excity.Asia/Yerevan", "યેરેવાન" },
            { "timezone.excity.Europe/Kirov", "કીરોવ" },
            { "timezone.excity.Europe/Malta", "માલ્ટા" },
            { "timezone.excity.Europe/Minsk", "મિંસ્ક" },
            { "timezone.excity.Europe/Paris", "પેરિસ" },
            { "timezone.excity.Europe/Sofia", "સોફિયા" },
            { "timezone.excity.Europe/Vaduz", "વડુઝ" },
            { "timezone.excity.Indian/Cocos", "કોકોઝ" },
            { "timezone.excity.Pacific/Apia", "એપિયા" },
            { "timezone.excity.Pacific/Fiji", "ફીજી" },
            { "timezone.excity.Pacific/Guam", "ગ્વામ" },
            { "timezone.excity.Pacific/Niue", "નીયુ" },
            { "timezone.excity.Pacific/Truk", "ચુક" },
            { "timezone.excity.Pacific/Wake", "વેક" },
            { "timezone.excity.Africa/Asmera", "અસ્મારા" },
            { "timezone.excity.Africa/Bamako", "બમેકો" },
            { "timezone.excity.Africa/Bangui", "બાંગુઈ" },
            { "timezone.excity.Africa/Banjul", "બાંજુલ" },
            { "timezone.excity.Africa/Bissau", "બિસાઉ" },
            { "timezone.excity.Africa/Douala", "ડૌઆલા" },
            { "timezone.excity.Africa/Harare", "હરારે" },
            { "timezone.excity.Africa/Kigali", "કિગાલી" },
            { "timezone.excity.Africa/Luanda", "લ્યુએન્ડા" },
            { "timezone.excity.Africa/Lusaka", "લુસાકા" },
            { "timezone.excity.Africa/Malabo", "મલાબો" },
            { "timezone.excity.Africa/Maputo", "માપુટો" },
            { "timezone.excity.Africa/Maseru", "મસેરુ" },
            { "timezone.excity.Africa/Niamey", "નિયામી" },
            { "timezone.excity.America/Aruba", "અરુબા" },
            { "timezone.excity.America/Bahia", "બાહિયા" },
            { "timezone.excity.America/Belem", "બેલેમ" },
            { "timezone.excity.America/Boise", "બોઇઝ" },
            { "timezone.excity.America/Jujuy", "હુહુઇ" },
            { "timezone.excity.America/Sitka", "સિટ્કા" },
            { "timezone.excity.America/Thule", "થુલે" },
            { "timezone.excity.Asia/Ashgabat", "અશગાબટ" },
            { "timezone.excity.Asia/Calcutta", "કોલકાતા" },
            { "timezone.excity.Asia/Damascus", "દમાસ્કસ" },
            { "timezone.excity.Asia/Dushanbe", "દુશામ્બે" },
            { "timezone.excity.Asia/Jayapura", "જયાપુરા" },
            { "timezone.excity.Asia/Katmandu", "કાઠમંડુ" },
            { "timezone.excity.Asia/Khandyga", "ખંડિગા" },
            { "timezone.excity.Asia/Makassar", "માકસ્સર" },
            { "timezone.excity.Asia/Qostanay", "કોસ્ટાને" },
            { "timezone.excity.Asia/Sakhalin", "સખાલિન" },
            { "timezone.excity.Asia/Shanghai", "શાંઘાઈ" },
            { "timezone.excity.Asia/Tashkent", "તાશકેન્ટ" },
            { "timezone.excity.Asia/Ust-Nera", "ઉસ્ત-નેરા" },
            { "timezone.excity.Europe/Athens", "એથેંસ" },
            { "timezone.excity.Europe/Berlin", "બર્લિન" },
            { "timezone.excity.Europe/Dublin", "ડબલિન" },
            { "timezone.excity.Europe/Jersey", "જર્સી" },
            { "timezone.excity.Europe/Lisbon", "લિસ્બન" },
            { "timezone.excity.Europe/London", "લંડન" },
            { "timezone.excity.Europe/Madrid", "મેડ્રિડ" },
            { "timezone.excity.Europe/Monaco", "મોનાકો" },
            { "timezone.excity.Europe/Moscow", "મોસ્કો" },
            { "timezone.excity.Europe/Prague", "પ્રાગ" },
            { "timezone.excity.Europe/Samara", "સમારા" },
            { "timezone.excity.Europe/Skopje", "સ્કોપયે" },
            { "timezone.excity.Europe/Tirane", "તિરાના" },
            { "timezone.excity.Europe/Vienna", "વિયેના" },
            { "timezone.excity.Europe/Warsaw", "વોરસૉ" },
            { "timezone.excity.Europe/Zagreb", "ઝેગરેબ" },
            { "timezone.excity.Europe/Zurich", "ઝુરીક" },
            { "timezone.excity.Indian/Chagos", "ચાગોસ" },
            { "timezone.excity.Indian/Comoro", "કોમોરો" },
            { "timezone.excity.Pacific/Efate", "એફેટ" },
            { "timezone.excity.Pacific/Nauru", "નૌરુ" },
            { "timezone.excity.Pacific/Palau", "પલાઉ" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "આબિદ્જાન" },
            { "timezone.excity.Africa/Algiers", "અલ્જીયર્સ" },
            { "timezone.excity.Africa/Conakry", "કોનૅક્રી" },
            { "timezone.excity.Africa/Kampala", "કમ્પાલા" },
            { "timezone.excity.Africa/Mbabane", "અમ્બબાન" },
            { "timezone.excity.Africa/Nairobi", "નૈરોબી" },
            { "timezone.excity.Africa/Tripoli", "ટ્રીપોલી" },
            { "timezone.excity.America/Belize", "બેલીઝ" },
            { "timezone.excity.America/Bogota", "બોગોટા" },
            { "timezone.excity.America/Cancun", "કાન્કુન" },
            { "timezone.excity.America/Cayman", "કેમેન" },
            { "timezone.excity.America/Cuiaba", "ક્યુએબા" },
            { "timezone.excity.America/Dawson", "ડૌસન" },
            { "timezone.excity.America/Denver", "દેન્વર" },
            { "timezone.excity.America/Guyana", "ગયાના" },
            { "timezone.excity.America/Havana", "હવાના" },
            { "timezone.excity.America/Inuvik", "ઇનુવિક" },
            { "timezone.excity.America/Juneau", "જુનેઇ" },
            { "timezone.excity.America/La_Paz", "લા પેઝ" },
            { "timezone.excity.America/Maceio", "મેસિઓ" },
            { "timezone.excity.America/Manaus", "મનૌસ" },
            { "timezone.excity.America/Merida", "મેરિદા" },
            { "timezone.excity.America/Nassau", "નાસાઉ" },
            { "timezone.excity.America/Panama", "પનામા" },
            { "timezone.excity.America/Recife", "રેસીફ" },
            { "timezone.excity.America/Regina", "રેજીના" },
            { "timezone.excity.Asia/Famagusta", "ફામાગુસ્તા" },
            { "timezone.excity.Asia/Hong_Kong", "હોંગકોંગ" },
            { "timezone.excity.Asia/Jerusalem", "જેરુસલેમ" },
            { "timezone.excity.Asia/Kamchatka", "કામચટ્કા" },
            { "timezone.excity.Asia/Pontianak", "પોન્ટિયનેક" },
            { "timezone.excity.Asia/Pyongyang", "પ્યોંગયાંગ" },
            { "timezone.excity.Asia/Qyzylorda", "કિઝિલોર્ડા" },
            { "timezone.excity.Asia/Samarkand", "સમરકન્ડ" },
            { "timezone.excity.Asia/Singapore", "સિંગાપુર" },
            { "timezone.excity.Asia/Vientiane", "વિયેનટિયેન" },
            { "timezone.excity.Europe/Andorra", "ઍંડોરા" },
            { "timezone.excity.Europe/Saratov", "સારાટોવ" },
            { "timezone.excity.Europe/Tallinn", "તલ્લીન" },
            { "timezone.excity.Europe/Vatican", "વેટિકન" },
            { "timezone.excity.Europe/Vilnius", "વિલ્નિઅસ" },
            { "timezone.excity.Indian/Mayotte", "મેયોટ" },
            { "timezone.excity.Indian/Reunion", "રીયુનિયન" },
            { "timezone.excity.Pacific/Easter", "ઇસ્ટર" },
            { "timezone.excity.Pacific/Kosrae", "કોસરે" },
            { "timezone.excity.Pacific/Majuro", "માજુરો" },
            { "timezone.excity.Pacific/Midway", "મીડવે" },
            { "timezone.excity.Pacific/Noumea", "નૌમીઆ" },
            { "timezone.excity.Pacific/Ponape", "પોન્પે" },
            { "timezone.excity.Pacific/Saipan", "સાઇપન" },
            { "timezone.excity.Pacific/Tahiti", "તાહીતી" },
            { "timezone.excity.Pacific/Tarawa", "તારાવા" },
            { "timezone.excity.Pacific/Wallis", "વાલિસ" },
            { "timezone.excity.Africa/Blantyre", "બ્લેંટીર" },
            { "timezone.excity.Africa/Djibouti", "જીબુટી" },
            { "timezone.excity.Africa/El_Aaiun", "એલ ઐઉન" },
            { "timezone.excity.Africa/Freetown", "ફ્રીટાઉન" },
            { "timezone.excity.Africa/Gaborone", "ગૅબોરોન" },
            { "timezone.excity.Africa/Khartoum", "ખાર્ટૂમ" },
            { "timezone.excity.Africa/Kinshasa", "કિંશાસા" },
            { "timezone.excity.Africa/Monrovia", "મોંરોવિયા" },
            { "timezone.excity.Africa/Ndjamena", "અન્જમેન" },
            { "timezone.excity.Africa/Sao_Tome", "સાઓ ટૉમ" },
            { "timezone.excity.Africa/Windhoek", "વિંડહૉક" },
            { "timezone.excity.America/Antigua", "ઍન્ટિગુઆ" },
            { "timezone.excity.America/Caracas", "કૅરાકસ" },
            { "timezone.excity.America/Cayenne", "કાયેને" },
            { "timezone.excity.America/Chicago", "શિકાગો" },
            { "timezone.excity.America/Cordoba", "કોર્ડોબા" },
            { "timezone.excity.America/Creston", "ક્રેસ્ટન" },
            { "timezone.excity.America/Curacao", "કુરાકાઓ" },
            { "timezone.excity.America/Detroit", "ડેટ્રોઇટ" },
            { "timezone.excity.America/Godthab", "નૂક" },
            { "timezone.excity.America/Grenada", "ગ્રેનેડા" },
            { "timezone.excity.America/Halifax", "હેલિફેક્સ" },
            { "timezone.excity.America/Iqaluit", "ઇકાલુઇત" },
            { "timezone.excity.America/Jamaica", "જમૈકા" },
            { "timezone.excity.America/Managua", "માનાગુઆ" },
            { "timezone.excity.America/Marigot", "મેરીગોટ" },
            { "timezone.excity.America/Mendoza", "મેન્ડોઝા" },
            { "timezone.excity.America/Moncton", "મોન્કટન" },
            { "timezone.excity.America/Noronha", "નોરોન્હા" },
            { "timezone.excity.America/Ojinaga", "ઓજિનાગા" },
            { "timezone.excity.America/Phoenix", "ફોનિક્સ" },
            { "timezone.excity.America/Tijuana", "તિજુઆના" },
            { "timezone.excity.America/Toronto", "ટોરન્ટો" },
            { "timezone.excity.America/Tortola", "ટોર્ટોલા" },
            { "timezone.excity.America/Yakutat", "યકુતત" },
            { "timezone.excity.Asia/Phnom_Penh", "ફ્નોમ પેન્હ" },
            { "timezone.excity.Atlantic/Azores", "એઝોરેઝ" },
            { "timezone.excity.Atlantic/Canary", "કૅનેરી" },
            { "timezone.excity.Atlantic/Faeroe", "ફેરો" },
            { "timezone.excity.Australia/Eucla", "ઉક્લા" },
            { "timezone.excity.Australia/Perth", "પર્થ" },
            { "timezone.excity.Europe/Belgrade", "બેલગ્રેડ" },
            { "timezone.excity.Europe/Brussels", "બ્રસેલ્સ" },
            { "timezone.excity.Europe/Budapest", "બુડાપેસ્ટ" },
            { "timezone.excity.Europe/Busingen", "બિઝેન્ગન" },
            { "timezone.excity.Europe/Chisinau", "ચિસીનાઉ" },
            { "timezone.excity.Europe/Guernsey", "ગર્નઝી" },
            { "timezone.excity.Europe/Helsinki", "હેલસિંકી" },
            { "timezone.excity.Europe/Istanbul", "ઇસ્તાંબુલ" },
            { "timezone.excity.Europe/Sarajevo", "સારાજેવો" },
            { "timezone.excity.Indian/Maldives", "માલદિવ્સ" },
            { "timezone.excity.Pacific/Chatham", "ચથમ" },
            { "timezone.excity.Pacific/Fakaofo", "ફાકાઓફો" },
            { "timezone.excity.Pacific/Gambier", "ગેમ્બિયર" },
            { "timezone.excity.Pacific/Norfolk", "નૉરફૉક" },
            { "timezone.excity.Africa/Bujumbura", "બુજમ્બુરા" },
            { "timezone.excity.Africa/Mogadishu", "મોગાડીશુ" },
            { "timezone.excity.America/Anguilla", "ઍંગ્વિલા" },
            { "timezone.excity.America/Asuncion", "એસન્શિયન" },
            { "timezone.excity.America/Barbados", "બારબાડોસ" },
            { "timezone.excity.America/Dominica", "ડોમિનિકા" },
            { "timezone.excity.America/Edmonton", "એડમેન્ટન" },
            { "timezone.excity.America/Eirunepe", "ઇરુનેપ" },
            { "timezone.excity.America/Mazatlan", "મઝત્લાન" },
            { "timezone.excity.America/Miquelon", "મિક્યુલોન" },
            { "timezone.excity.America/New_York", "ન્યૂયોર્ક" },
            { "timezone.excity.America/Resolute", "રેઝોલૂટ" },
            { "timezone.excity.America/Santarem", "સેન્તારેમ" },
            { "timezone.excity.America/Santiago", "સાંટિયાગો" },
            { "timezone.excity.America/St_Johns", "સેંટ જ્હોન્સ" },
            { "timezone.excity.America/St_Kitts", "સેંટ કીટ્સ" },
            { "timezone.excity.America/St_Lucia", "સેંટ લુસિયા" },
            { "timezone.excity.America/Winnipeg", "વિન્નિપેગ" },
            { "timezone.excity.Antarctica/Casey", "કૅસી" },
            { "timezone.excity.Antarctica/Davis", "ડેવિસ" },
            { "timezone.excity.Antarctica/Syowa", "સ્યોવા" },
            { "timezone.excity.Antarctica/Troll", "ટ્રોલ" },
            { "timezone.excity.Asia/Krasnoyarsk", "ક્રિસ્નોયાર્સ્ક" },
            { "timezone.excity.Asia/Novosibirsk", "નોવોસીર્બિર્સ્ક" },
            { "timezone.excity.Asia/Ulaanbaatar", "ઉલાંબાતર" },
            { "timezone.excity.Asia/Vladivostok", "વ્લેડિવોસ્ટોક" },
            { "timezone.excity.Atlantic/Bermuda", "બર્મુડા" },
            { "timezone.excity.Atlantic/Madeira", "મડિરા" },
            { "timezone.excity.Atlantic/Stanley", "સ્ટેનલી" },
            { "timezone.excity.Australia/Darwin", "ડાર્વિન" },
            { "timezone.excity.Australia/Hobart", "હોબાર્ટ" },
            { "timezone.excity.Australia/Sydney", "સિડની" },
            { "timezone.excity.Europe/Amsterdam", "ઍમ્સ્ટરડૅમ" },
            { "timezone.excity.Europe/Astrakhan", "આસ્ટ્રખન" },
            { "timezone.excity.Europe/Bucharest", "બુકરેસ્ટ" },
            { "timezone.excity.Europe/Gibraltar", "જિબ્રાલ્ટર" },
            { "timezone.excity.Europe/Ljubljana", "લુબ્લિયાના" },
            { "timezone.excity.Europe/Mariehamn", "મેરિહેમ" },
            { "timezone.excity.Europe/Podgorica", "પોડગોરિકા" },
            { "timezone.excity.Europe/Stockholm", "સ્ટોકહૉમ" },
            { "timezone.excity.Europe/Ulyanovsk", "ઉલેનોવ્સ્ક" },
            { "timezone.excity.Europe/Volgograd", "વોલ્ગોગ્રેડ" },
            { "timezone.excity.Indian/Christmas", "ક્રિસમસ" },
            { "timezone.excity.Indian/Kerguelen", "કેરગ્વેલિન" },
            { "timezone.excity.Indian/Mauritius", "મોરિશિયસ" },
            { "timezone.excity.Pacific/Auckland", "ઑકલેન્ડ" },
            { "timezone.excity.Pacific/Funafuti", "ફુનાફુટી" },
            { "timezone.excity.Pacific/Honolulu", "હોનોલુલુ" },
            { "timezone.excity.Pacific/Pitcairn", "પીટકૈર્ન" },
            { "timezone.excity.Africa/Casablanca", "કાસાબ્લાંકા" },
            { "timezone.excity.Africa/Libreville", "લિબ્રેવિલે" },
            { "timezone.excity.Africa/Lubumbashi", "લુબુમ્બાશી" },
            { "timezone.excity.Africa/Nouakchott", "નૌકચોટ" },
            { "timezone.excity.Africa/Porto-Novo", "પોર્ટો-નોવો" },
            { "timezone.excity.America/Anchorage", "એન્કોરેજ" },
            { "timezone.excity.America/Araguaina", "અરાગુઇના" },
            { "timezone.excity.America/Boa_Vista", "બોઆ વિસ્ટા" },
            { "timezone.excity.America/Catamarca", "કાતામાર્કા" },
            { "timezone.excity.America/Chihuahua", "ચિહુઆહુઆ" },
            { "timezone.excity.America/Coyhaique", "કોહેક" },
            { "timezone.excity.America/Fortaleza", "ફોર્ટાલેઝા" },
            { "timezone.excity.America/Glace_Bay", "ગ્લેસ બે" },
            { "timezone.excity.America/Goose_Bay", "ગૂસ બે" },
            { "timezone.excity.America/Guatemala", "ગ્વાટેમાલા" },
            { "timezone.excity.America/Guayaquil", "ગુયાક્વિલ" },
            { "timezone.excity.America/Matamoros", "માતામોરોસ" },
            { "timezone.excity.America/Menominee", "મેનોમિની" },
            { "timezone.excity.America/Monterrey", "મોન્તોરે" },
            { "timezone.excity.America/Sao_Paulo", "સાઓ પાઉલો" },
            { "timezone.excity.America/St_Thomas", "સેંટ થોમસ" },
            { "timezone.excity.America/Vancouver", "વેન્કુવર" },
            { "timezone.excity.Antarctica/Mawson", "મોસન" },
            { "timezone.excity.Antarctica/Palmer", "પાલ્મર" },
            { "timezone.excity.Antarctica/Vostok", "વોસ્ટૉક" },
            { "timezone.excity.Asia/Kuala_Lumpur", "કુઆલા લુમ્પુર" },
            { "timezone.excity.Asia/Novokuznetsk", "નોવોકુઝ્નેત્સ્ક" },
            { "timezone.excity.Europe/Bratislava", "બ્રેટિસલાવા" },
            { "timezone.excity.Europe/Copenhagen", "કોપનહેગન" },
            { "timezone.excity.Europe/Luxembourg", "લક્ઝમબર્ગ" },
            { "timezone.excity.Europe/San_Marino", "સૅન મેરિનો" },
            { "timezone.excity.Europe/Simferopol", "સિમ્ફેરોપોલ" },
            { "timezone.excity.Pacific/Enderbury", "કેંટન આઇલૅન્ડ" },
            { "timezone.excity.Pacific/Galapagos", "ગાલાપેગોસ" },
            { "timezone.excity.Pacific/Kwajalein", "ક્વાજાલીન" },
            { "timezone.excity.Pacific/Marquesas", "માર્કીસાસ" },
            { "timezone.excity.Pacific/Pago_Pago", "પેગો પેગો" },
            { "timezone.excity.Pacific/Rarotonga", "રેરોટોંગા" },
            { "timezone.excity.Pacific/Tongatapu", "ટૉંગાટાપુ" },
            { "timezone.excity.Africa/Addis_Ababa", "એડિસ અબાબા" },
            { "timezone.excity.Africa/Brazzaville", "બ્રાઝાવિલે" },
            { "timezone.excity.Africa/Ouagadougou", "ઔઆગાદૌગૌ" },
            { "timezone.excity.America/Costa_Rica", "કોસ્ટા રિકા" },
            { "timezone.excity.America/Grand_Turk", "ગ્રાન્ડ ટર્ક" },
            { "timezone.excity.America/Guadeloupe", "ગ્વાડેલોપ" },
            { "timezone.excity.America/Hermosillo", "એરમોસિયો" },
            { "timezone.excity.America/Kralendijk", "ક્રાલેન્ડિક" },
            { "timezone.excity.America/Louisville", "લૂઇવિલ" },
            { "timezone.excity.America/Martinique", "માર્ટીનીક" },
            { "timezone.excity.America/Metlakatla", "મેટ્લાકાટ્લા" },
            { "timezone.excity.America/Montevideo", "મૉંટેવિડિઓ" },
            { "timezone.excity.America/Montserrat", "મોંટસેરાત" },
            { "timezone.excity.America/Paramaribo", "પેરામેરિબો" },
            { "timezone.excity.America/Rio_Branco", "રિયો બ્રાંકો" },
            { "timezone.excity.America/St_Vincent", "સેંટ વિન્સેન્ટ" },
            { "timezone.excity.America/Whitehorse", "વ્હાઇટહોર્સ" },
            { "timezone.excity.Antarctica/McMurdo", "મૅકમર્ડો" },
            { "timezone.excity.Antarctica/Rothera", "રોથેરા" },
            { "timezone.excity.Asia/Srednekolymsk", "સ્રેડ્નેકોલીમ્સ્ક" },
            { "timezone.excity.Asia/Yekaterinburg", "યેકાતેરિનબર્ગ" },
            { "timezone.excity.Atlantic/Reykjavik", "રૅકયાવિક" },
            { "timezone.excity.Atlantic/St_Helena", "સેંટ હેલેના" },
            { "timezone.excity.Australia/Adelaide", "એડિલેઇડ" },
            { "timezone.excity.Australia/Brisbane", "બ્રિસબેન" },
            { "timezone.excity.Australia/Lindeman", "લિન્ડેમેન" },
            { "timezone.excity.Europe/Isle_of_Man", "આઇલ ઑફ મેન" },
            { "timezone.excity.Europe/Kaliningrad", "કલિનિન્ગ્રેડ" },
            { "timezone.excity.Pacific/Kiritimati", "કિરિતિમાતી" },
            { "timezone.excity.Africa/Johannesburg", "જોહાન્સબર્ગ" },
            { "timezone.excity.America/El_Salvador", "એલ સેલ્વાડોર" },
            { "timezone.excity.America/Fort_Nelson", "ફોર્ટ નેલ્સન" },
            { "timezone.excity.America/Los_Angeles", "લોસ એંજેલેસ" },
            { "timezone.excity.America/Mexico_City", "મેક્સિકો સિટી" },
            { "timezone.excity.America/Porto_Velho", "પોર્ટો વેલ્હો" },
            { "timezone.excity.America/Puerto_Rico", "પ્યુઅર્ટો રિકો" },
            { "timezone.excity.America/Tegucigalpa", "તેગુસિગલ્પા" },
            { "timezone.excity.Arctic/Longyearbyen", "લોંગઇયરબિયેન" },
            { "timezone.excity.Atlantic/Cape_Verde", "કૅપ વર્ડે" },
            { "timezone.excity.Australia/Lord_Howe", "લોર્ડ હોવ" },
            { "timezone.excity.Australia/Melbourne", "મેલબોર્ન" },
            { "timezone.excity.Indian/Antananarivo", "અંતાનાનારિવો" },
            { "timezone.excity.Pacific/Guadalcanal", "ગૌડલકૅનલ" },
            { "timezone.excity.Africa/Dar_es_Salaam", "દાર એસ સલામ" },
            { "timezone.excity.America/Blanc-Sablon", "બ્લાંક-સેબલોન" },
            { "timezone.excity.America/Buenos_Aires", "બ્યુનસ એયર્સ" },
            { "timezone.excity.America/Campo_Grande", "કામ્પો ગ્રાંડ" },
            { "timezone.excity.America/Danmarkshavn", "ડેનમાર્કશૉન" },
            { "timezone.excity.America/Dawson_Creek", "ડૌસન ક્રિક" },
            { "timezone.excity.America/Indiana/Knox", "નોક્સ, ઇન્ડિયાના" },
            { "timezone.excity.America/Indianapolis", "ઇન્ડિયાનાપોલિસ" },
            { "timezone.excity.America/Punta_Arenas", "પુન્ટા એરીનાઝ" },
            { "timezone.excity.America/Rankin_Inlet", "રેંકિન ઇન્લેટ" },
            { "timezone.excity.America/Scoresbysund", "ઇતોકોર્ટોરોમિટ" },
            { "timezone.excity.Antarctica/Macquarie", "મેક્વેરી" },
            { "timezone.excity.Pacific/Bougainville", "બૌગેઈનવિલે" },
            { "timezone.excity.Pacific/Port_Moresby", "પોર્ટ મોર્સ્બી" },
            { "timezone.excity.America/Cambridge_Bay", "કેમ્બ્રિજ બે" },
            { "timezone.excity.America/Ciudad_Juarez", "સિયુદાદ હુઆરેઝ" },
            { "timezone.excity.America/Coral_Harbour", "એટિકોકેન" },
            { "timezone.excity.America/Indiana/Vevay", "વેવૈ, ઇન્ડિયાના" },
            { "timezone.excity.America/Lower_Princes", "લોઅર પ્રિન્સનું ક્વાર્ટર" },
            { "timezone.excity.America/Port_of_Spain", "પોર્ટ ઑફ સ્પેન" },
            { "timezone.excity.America/Santo_Domingo", "સેંટો ડોમિંગો" },
            { "timezone.excity.America/St_Barthelemy", "સેંટ બાર્થેલેમી" },
            { "timezone.excity.America/Swift_Current", "સ્વિફ્ટ કરંટ" },
            { "timezone.excity.Australia/Broken_Hill", "બ્રોકન હિલ" },
            { "timezone.excity.America/Bahia_Banderas", "બહિયા બાંદ્રાસ" },
            { "timezone.excity.America/Port-au-Prince", "પોર્ટ-ઓ-પ્રિન્સ" },
            { "timezone.excity.Atlantic/South_Georgia", "દક્ષિણ જ્યોર્જિયા" },
            { "timezone.excity.America/Argentina/Salta", "સાલ્ટા" },
            { "timezone.excity.America/Indiana/Marengo", "મેરેંગો, ઇન્ડિયાના" },
            { "timezone.excity.America/Indiana/Winamac", "વિનામેક, ઇન્ડિયાના" },
            { "timezone.excity.America/Argentina/Tucuman", "તુકુમાન" },
            { "timezone.excity.America/Argentina/Ushuaia", "ઉશાયા" },
            { "timezone.excity.America/Indiana/Tell_City", "ટેલ સિટી, ઇન્ડિયાના" },
            { "timezone.excity.America/Indiana/Vincennes", "વિન્સેન્સ, ઇન્ડિયાના" },
            { "timezone.excity.Antarctica/DumontDUrville", "દુમોન્ત દી‘ઉર્વિલ" },
            { "timezone.excity.America/Argentina/La_Rioja", "લા રિઓહા" },
            { "timezone.excity.America/Argentina/San_Juan", "સેન જુએન" },
            { "timezone.excity.America/Argentina/San_Luis", "સેન લુઇસ" },
            { "timezone.excity.America/Indiana/Petersburg", "પિટર્સબર્ગ, ઇન્ડિયાના" },
            { "timezone.excity.America/Kentucky/Monticello", "મોન્ટીસેલો, કેન્ટુકી" },
            { "timezone.excity.America/North_Dakota/Beulah", "બિયુલાહ, ઉત્તર ડેકોટા" },
            { "timezone.excity.America/North_Dakota/Center", "સેન્ટર, ઉત્તર ડેકોટા" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "રિઓ ગેલેગોસ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ન્યુ સેલમ, ઉત્તર ડેકોટા" },
        };
        return data;
    }
}
