// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package mock

import (
	"github.com/NVIDIA/go-nvml/pkg/nvml"
	"sync"
)

// Ensure, that EventSet does implement nvml.EventSet.
// If this is not the case, regenerate this file with moq.
var _ nvml.EventSet = &EventSet{}

// EventSet is a mock implementation of nvml.EventSet.
//
//	func TestSomethingThatUsesEventSet(t *testing.T) {
//
//		// make and configure a mocked nvml.EventSet
//		mockedEventSet := &EventSet{
//			FreeFunc: func() nvml.Return {
//				panic("mock out the Free method")
//			},
//			WaitFunc: func(v uint32) (nvml.EventData, nvml.Return) {
//				panic("mock out the Wait method")
//			},
//		}
//
//		// use mockedEventSet in code that requires nvml.EventSet
//		// and then make assertions.
//
//	}
type EventSet struct {
	// FreeFunc mocks the Free method.
	FreeFunc func() nvml.Return

	// WaitFunc mocks the Wait method.
	WaitFunc func(v uint32) (nvml.EventData, nvml.Return)

	// calls tracks calls to the methods.
	calls struct {
		// Free holds details about calls to the Free method.
		Free []struct {
		}
		// Wait holds details about calls to the Wait method.
		Wait []struct {
			// V is the v argument value.
			V uint32
		}
	}
	lockFree sync.RWMutex
	lockWait sync.RWMutex
}

// Free calls FreeFunc.
func (mock *EventSet) Free() nvml.Return {
	if mock.FreeFunc == nil {
		panic("EventSet.FreeFunc: method is nil but EventSet.Free was just called")
	}
	callInfo := struct {
	}{}
	mock.lockFree.Lock()
	mock.calls.Free = append(mock.calls.Free, callInfo)
	mock.lockFree.Unlock()
	return mock.FreeFunc()
}

// FreeCalls gets all the calls that were made to Free.
// Check the length with:
//
//	len(mockedEventSet.FreeCalls())
func (mock *EventSet) FreeCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockFree.RLock()
	calls = mock.calls.Free
	mock.lockFree.RUnlock()
	return calls
}

// Wait calls WaitFunc.
func (mock *EventSet) Wait(v uint32) (nvml.EventData, nvml.Return) {
	if mock.WaitFunc == nil {
		panic("EventSet.WaitFunc: method is nil but EventSet.Wait was just called")
	}
	callInfo := struct {
		V uint32
	}{
		V: v,
	}
	mock.lockWait.Lock()
	mock.calls.Wait = append(mock.calls.Wait, callInfo)
	mock.lockWait.Unlock()
	return mock.WaitFunc(v)
}

// WaitCalls gets all the calls that were made to Wait.
// Check the length with:
//
//	len(mockedEventSet.WaitCalls())
func (mock *EventSet) WaitCalls() []struct {
	V uint32
} {
	var calls []struct {
		V uint32
	}
	mock.lockWait.RLock()
	calls = mock.calls.Wait
	mock.lockWait.RUnlock()
	return calls
}
