#include "unimath/uni_symbol.h"

#include <cstring>

using namespace std;

namespace microtex {

static constexpr auto ord = static_cast<i8>(AtomType::ordinary) << 8;
static constexpr auto rel = static_cast<i8>(AtomType::relation) << 8;
static constexpr auto acc = static_cast<i8>(AtomType::accent) << 8;
static constexpr auto bin = static_cast<i8>(AtomType::binaryOperator) << 8;
static constexpr auto opt = static_cast<i8>(AtomType::bigOperator) << 8;
static constexpr auto opn = static_cast<i8>(AtomType::opening) << 8;
static constexpr auto cls = static_cast<i8>(AtomType::closing) << 8;
static constexpr auto puc = static_cast<i8>(AtomType::punctuation) << 8;

static constexpr i8 N = 1 << 1;
static constexpr i8 F = 1;

// clang-format off
// IMPORTANT: sorted by the name, you must re-sort this array after add item
const Symbol _symbols[]{
  {0x00023, ord,     "#"},
  {0x00024, ord,     "$"},
  {0x00025, ord,     "%"},
  {0x00026, ord,     "&"},
  {0x0223F, ord,     "AC"},
  {0x02370, ord,     "APLboxquestion"},
  {0x02353, ord,     "APLboxupcaret"},
  {0x0235D, ord,     "APLcomment"},
  {0x02357, ord,     "APLdownarrowbox"},
  {0x0235E, ord,     "APLinput"},
  {0x02339, ord,     "APLinv"},
  {0x02347, ord,     "APLleftarrowbox"},
  {0x0235F, ord,     "APLlog"},
  {0x02340, ord,     "APLnotbackslash"},
  {0x0233F, rel,     "APLnotslash"},
  {0x02348, ord,     "APLrightarrowbox"},
  {0x02350, ord,     "APLuparrowbox"},
  {0x0212B, ord,     "Angstroem"},
  {0x0212B, ord,     "Angstrom"},
  {0x02648, ord,     "Aries"},
  {0x02AE7, rel,     "Barv"},
  {0x1D538, ord,     "BbbA"},
  {0x1D539, ord,     "BbbB"},
  {0x02102, ord,     "BbbC"},
  {0x1D53B, ord,     "BbbD"},
  {0x1D53C, ord,     "BbbE"},
  {0x1D53D, ord,     "BbbF"},
  {0x1D53E, ord,     "BbbG"},
  {0x0213E, ord,     "BbbGamma"},
  {0x0210D, ord,     "BbbH"},
  {0x1D540, ord,     "BbbI"},
  {0x1D541, ord,     "BbbJ"},
  {0x1D542, ord,     "BbbK"},
  {0x1D543, ord,     "BbbL"},
  {0x1D544, ord,     "BbbM"},
  {0x02115, ord,     "BbbN"},
  {0x1D546, ord,     "BbbO"},
  {0x02119, ord,     "BbbP"},
  {0x0213F, ord,     "BbbPi"},
  {0x0211A, ord,     "BbbQ"},
  {0x0211D, ord,     "BbbR"},
  {0x1D54A, ord,     "BbbS"},
  {0x1D54B, ord,     "BbbT"},
  {0x1D54C, ord,     "BbbU"},
  {0x1D54D, ord,     "BbbV"},
  {0x1D54E, ord,     "BbbW"},
  {0x1D54F, ord,     "BbbX"},
  {0x1D550, ord,     "BbbY"},
  {0x02124, ord,     "BbbZ"},
  {0x1D552, ord,     "Bbba"},
  {0x1D553, ord,     "Bbbb"},
  {0x1D554, ord,     "Bbbc"},
  {0x1D555, ord,     "Bbbd"},
  {0x1D556, ord,     "Bbbe"},
  {0x1D7E0, ord,     "Bbbeight"},
  {0x1D557, ord,     "Bbbf"},
  {0x1D7DD, ord,     "Bbbfive"},
  {0x1D7DC, ord,     "Bbbfour"},
  {0x1D558, ord,     "Bbbg"},
  {0x0213D, ord,     "Bbbgamma"},
  {0x1D559, ord,     "Bbbh"},
  {0x1D55A, ord,     "Bbbi"},
  {0x1D55B, ord,     "Bbbj"},
  {0x1D55C, ord,     "Bbbk"},
  {0x1D55D, ord,     "Bbbl"},
  {0x1D55E, ord,     "Bbbm"},
  {0x1D55F, ord,     "Bbbn"},
  {0x1D7E1, ord,     "Bbbnine"},
  {0x1D560, ord,     "Bbbo"},
  {0x1D7D9, ord,     "Bbbone"},
  {0x1D561, ord,     "Bbbp"},
  {0x0213C, ord,     "Bbbpi"},
  {0x1D562, ord,     "Bbbq"},
  {0x1D563, ord,     "Bbbr"},
  {0x1D564, ord,     "Bbbs"},
  {0x1D7DF, ord,     "Bbbseven"},
  {0x1D7DE, ord,     "Bbbsix"},
  {0x02140, opt,     "Bbbsum"},
  {0x1D565, ord,     "Bbbt"},
  {0x1D7DB, ord,     "Bbbthree"},
  {0x1D7DA, ord,     "Bbbtwo"},
  {0x1D566, ord,     "Bbbu"},
  {0x1D567, ord,     "Bbbv"},
  {0x1D568, ord,     "Bbbw"},
  {0x1D569, ord,     "Bbbx"},
  {0x1D56A, ord,     "Bbby"},
  {0x1D56B, ord,     "Bbbz"},
  {0x1D7D8, ord,     "Bbbzero"},
  {0x02AEB, rel,     "Bot"},
  {0x0224E, rel,     "Bumpeq"},
  {0x025CF, ord,     "CIRCLE"},
  {0x022D2, bin,     "Cap"},
  {0x02145, ord,     "CapitalDifferentialD"},
  {0x02611, ord,     "CheckedBox"},
  {0x025CB, bin,     "Circle"},
  {0x02237, rel,     "Colon"},
  {0x02A74, rel,     "Coloneq"},
  {0x02A74, rel,     "Coloneqq"},
  {0x02148, ord,     "ComplexI"},
  {0x02149, ord,     "ComplexJ"},
  {0x022D3, bin,     "Cup"},
  {0x02145, ord,     "DD"},
  {0x020DB, acc,     "DDDot"},
  {0x00308, acc,     "DDot"},
  {0x027F1, rel,     "DDownarrow"},
  {0x02AE5, rel,     "DashV"},
  {0x027DA, rel,     "DashVDash"},
  {0x02AE4, rel,     "Dashv"},
  {0x0290B, rel,     "Ddownarrow"},
  {0x00394, ord,     "Delta"},
  {0x025C7, ord,     "Diamond"},
  {0x025C6, ord,     "Diamondblack"},
  {0x027D0, ord,     "Diamonddot"},
  {0x02146, ord,     "DifferentialD"},
  {0x003DC, ord,     "Digamma"},
  {0x00307, acc,     "Dot"},
  {0x02251, rel,     "Doteq"},
  {0x02913, rel,     "DownArrowBar"},
  {0x0295E, rel,     "DownLeftTeeVector"},
  {0x02956, rel,     "DownLeftVectorBar"},
  {0x0295F, rel,     "DownRightTeeVector"},
  {0x02957, rel,     "DownRightVectorBar"},
  {0x021D3, rel,     "Downarrow"},
  {0x02A75, rel,     "Equal"},
  {0x02263, rel,     "Equiv"},
  {0x02107, ord,     "Euler"},
  {0x02107, ord,     "Eulerconst"},
  {0x0203C, ord,     "Exclam"},
  {0x02147, ord,     "ExponetialE"},
  {0x02132, ord,     "Finv"},
  {0x02141, ord,     "Game"},
  {0x00393, ord,     "Gamma"},
  {0x0264A, ord,     "Gemini"},
  {0x02277, rel,     "GreaterLess"},
  {0x02273, rel,     "GreaterTilde"},
  {0x02AA2, rel,     "Gt"},
  {0x0210F, ord,     "HBar"},
  {0x026A5, ord,     "Hermaphrodite"},
  {0x02111, ord,     "Im"},
  {0x02A1D, opt,     "Join"},
  {0x02643, ord,     "Jupiter"},
  {0x003D8, ord,     "Koppa"},
  {0x025D6, ord,     "LEFTCIRCLE"},
  {0x025D0, ord,     "LEFTcircle"},
  {0x025C0, bin,     "LHD"},
  {0x02B45, rel,     "LLeftarrow"},
  {0x020D6, acc,     "LVec"},
  {0x0039B, ord,     "Lambda"},
  {0x027C5, opn,     "Lbag"},
  {0x027E6, opn,     "Lbrack"},
  {0x027EC, opn,     "Lbrbrak"},
  {0x021B2, rel,     "Ldsh"},
  {0x021E4, rel,     "LeftArrowBar"},
  {0x02961, rel,     "LeftDownTeeVector"},
  {0x02959, rel,     "LeftDownVectorBar"},
  {0x0295A, rel,     "LeftTeeVector"},
  {0x025C1, bin,     "LeftTriangle"},
  {0x029CF, rel,     "LeftTriangleBar"},
  {0x02960, rel,     "LeftUpTeeVector"},
  {0x02958, rel,     "LeftUpVectorBar"},
  {0x02952, rel,     "LeftVectorBar"},
  {0x021D0, rel,     "Leftarrow"},
  {0x021D4, rel,     "Leftrightarrow"},
  {0x0264C, ord,     "Leo"},
  {0x02272, rel,     "LessTilde"},
  {0x0264E, ord,     "Libra"},
  {0x021DA, rel,     "Lleftarrow"},
  {0x027F8, rel,     "Longleftarrow"},
  {0x027FA, rel,     "Longleftrightarrow"},
  {0x027FD, rel,     "Longmappedfrom"},
  {0x027FD, rel,     "Longmapsfrom"},
  {0x027FE, rel,     "Longmapsto"},
  {0x027F9, rel,     "Longrightarrow"},
  {0x02985, opn,     "Lparen"},
  {0x02995, opn,     "Lparengtr"},
  {0x021B0, rel,     "Lsh"},
  {0x02AA1, rel,     "Lt"},
  {0x029DA, opn,     "Lvzigzag"},
  {0x02906, rel,     "Mappedfrom"},
  {0x021A7, rel,     "MapsDown"},
  {0x021A5, rel,     "MapsUp"},
  {0x02906, rel,     "Mapsfrom"},
  {0x02907, rel,     "Mapsto"},
  {0x02642, ord,     "Mars"},
  {0x0263F, ord,     "Mercury"},
  {0x02127, ord,     "Mho"},
  {0x000B5, ord,     "Micro"},
  {0x021D7, rel,     "Nearrow"},
  {0x02646, ord,     "Neptune"},
  {0x02AA2, rel,     "NestedGreaterGreater"},
  {0x02AA1, rel,     "NestedLessLess"},
  {0x02AEC, rel,     "Not"},
  {0x02279, rel,     "NotGreaterLess"},
  {0x02275, rel,     "NotGreaterTilde"},
  {0x022EA, rel,     "NotLeftTriangle"},
  {0x02274, rel,     "NotLessTilde"},
  {0x022EB, rel,     "NotRightTriangle"},
  {0x021D6, rel,     "Nwarrow"},
  {0x003A9, ord,     "Omega"},
  {0x02A37, bin,     "Otimes"},
  {0x02AEB, rel,     "Perp"},
  {0x003A6, ord,     "Phi"},
  {0x003A0, ord,     "Pi"},
  {0x0210E, ord,     "Planckconst"},
  {0x02647, ord,     "Pluto"},
  {0x02ABB, rel,     "Prec"},
  {0x0227C, rel,     "PrecedesSlantEqual"},
  {0x0227E, rel,     "PrecedesTilde"},
  {0x0214A, ord,     "PropertyLine"},
  {0x02237, rel,     "Proportion"},
  {0x003A8, ord,     "Psi"},
  {0x0220E, ord,     "QED"},
  {0x003D8, ord,     "Qoppa"},
  {0x02047, ord,     "Question"},
  {0x025B6, bin,     "RHD"},
  {0x025D7, ord,     "RIGHTCIRCLE"},
  {0x025D1, ord,     "RIGHTcircle"},
  {0x02B46, rel,     "RRightarrow"},
  {0x027C6, cls,     "Rbag"},
  {0x027E7, cls,     "Rbrack"},
  {0x027ED, cls,     "Rbrbrak"},
  {0x021B3, rel,     "Rdsh"},
  {0x0211C, ord,     "Re"},
  {0x021E5, rel,     "RightArrowBar"},
  {0x0295D, rel,     "RightDownTeeVector"},
  {0x02955, rel,     "RightDownVectorBar"},
  {0x0295B, rel,     "RightTeeVector"},
  {0x025B7, bin,     "RightTriangle"},
  {0x029D0, rel,     "RightTriangleBar"},
  {0x0295C, rel,     "RightUpTeeVector"},
  {0x02954, rel,     "RightUpVectorBar"},
  {0x02953, rel,     "RightVectorBar"},
  {0x021D2, rel,     "Rightarrow"},
  {0x02986, cls,     "Rparen"},
  {0x02996, cls,     "Rparenless"},
  {0x021DB, rel,     "Rrightarrow"},
  {0x021B1, rel,     "Rsh"},
  {0x029DB, cls,     "Rvzigzag"},
  {0x02A76, rel,     "Same"},
  {0x003E0, ord,     "Sampi"},
  {0x02644, ord,     "Saturn"},
  {0x0264F, ord,     "Scorpio"},
  {0x021D8, rel,     "Searrow"},
  {0x02254, rel,     "SetDelayed"},
  {0x003A3, ord,     "Sigma"},
  {0x02A4E, bin,     "Sqcap"},
  {0x02A4F, bin,     "Sqcup"},
  {0x02610, ord,     "Square"},
  {0x003DA, ord,     "Stigma"},
  {0x022D0, rel,     "Subset"},
  {0x02ABC, rel,     "Succ"},
  {0x0227D, rel,     "SucceedsSlantEqual"},
  {0x0227F, rel,     "SucceedsTilde"},
  {0x02609, ord,     "Sun"},
  {0x022D1, rel,     "Supset"},
  {0x021D9, rel,     "Swarrow"},
  {0x02649, ord,     "Taurus"},
  {0x00398, ord,     "Theta"},
  {0x02AEA, rel,     "Top"},
  {0x027F0, rel,     "UUparrow"},
  {0x02912, rel,     "UpArrowBar"},
  {0x021D1, rel,     "Uparrow"},
  {0x021D5, rel,     "Updownarrow"},
  {0x003A5, ord,     "Upsilon"},
  {0x02645, ord,     "Uranus"},
  {0x0290A, rel,     "Uuparrow"},
  {0x022AB, rel,     "VDash"},
  {0x02980, ord,     "VERT"},
  {0x02AEB, rel,     "Vbar"},
  {0x022A9, rel,     "Vdash"},
  {0x020D7, acc,     "Vec"},
  {0x02A54, bin,     "Vee"},
  {0x02640, ord,     "Venus"},
  {0x02016, ord,     "Vert"},
  {0x022AA, rel,     "Vvdash"},
  {0x02980, ord,     "Vvert"},
  {0x02A53, bin,     "Wedge"},
  {0x02612, ord,     "XBox"},
  {0x0039E, ord,     "Xi"},
  {0x02144, ord,     "Yup"},
  {0x001B5, ord,     "Zbar"},
  {0x0005F, ord,     "_"},
  {0x023E6, ord,     "accurrent"},
  {0x0267E, ord,     "acidfree"},
  {0x00301, acc,     "acute"},
  {0x02940, rel,     "acwcirclearrow"},
  {0x027F2, rel,     "acwgapcirclearrow"},
  {0x02939, rel,     "acwleftarcarrow"},
  {0x021BA, ord,     "acwopencirclearrow"},
  {0x0293A, rel,     "acwoverarcarrow"},
  {0x0293B, rel,     "acwunderarcarrow"},
  {0x022F0, rel,     "adots"},
  {0x02135, ord,     "aleph"},
  {0x003B1, ord,     "alpha"},
  {0x003B1, ord,     "alphaup"},
  {0x02A3F, bin,     "amalg"},
  {0x00026, ord,     "ampersand"},
  {0x02693, ord,     "anchor"},
  {0x0299F, ord,     "angdnr"},
  {0x02220, ord,     "angle"},
  {0x0299E, ord,     "angles"},
  {0x029A4, ord,     "angleubar"},
  {0x020E7, acc,     "annuity"},
  {0x02273, rel,     "apprge"},
  {0x02272, rel,     "apprle"},
  {0x02248, rel,     "approx"},
  {0x0224A, rel,     "approxeq"},
  {0x02A70, rel,     "approxeqq"},
  {0x0224B, rel,     "approxident"},
  {0x02652, ord,     "aquarius"},
  {0x02258, rel,     "arceq"},
  {0x02648, ord,     "aries"},
  {0x027A2, ord,     "arrowbullet"},
  {0x022A6, rel,     "assert"},
  {0x02217, bin,     "ast"},
  {0x02A6E, rel,     "asteq"},
  {0x020F0, acc,     "asteraccent"},
  {0x02609, ord,     "astrosun"},
  {0x0224D, rel,     "asymp"},
  {0x00040, ord,     "atsign"},
  {0x02A11, opt | N, "awint"},
  {0x02AED, rel,     "bNot"},
  {0x0224C, rel,     "backcong"},
  {0x02036, ord,     "backdprime"},
  {0x003F6, ord,     "backepsilon"},
  {0x02035, ord,     "backprime"},
  {0x0223D, rel,     "backsim"},
  {0x022CD, rel,     "backsimeq"},
  {0x0005C, ord,     "backslash"},
  {0x02037, ord,     "backtrprime"},
  {0x022FF, rel,     "bagmember"},
  {0x02713, ord,     "ballotcheck"},
  {0x02717, ord,     "ballotx"},
  {0x00304, acc,     "bar"},
  {0x02AEA, rel,     "barV"},
  {0x02A43, bin,     "barcap"},
  {0x02A42, bin,     "barcup"},
  {0x02961, rel,     "bardownharpoonleft"},
  {0x0295D, rel,     "bardownharpoonright"},
  {0x022F6, rel,     "barin"},
  {0x021E4, rel,     "barleftarrow"},
  {0x021B9, ord,     "barleftarrowrightarrowba"},
  {0x0296B, rel,     "barleftharpoon"},
  {0x02956, rel,     "barleftharpoondown"},
  {0x02952, rel,     "barleftharpoonup"},
  {0x021B8, ord,     "barovernorthwestarrow"},
  {0x02920, rel,     "barrightarrowdiamond"},
  {0x0296D, rel,     "barrightharpoon"},
  {0x0295F, rel,     "barrightharpoondown"},
  {0x0295B, rel,     "barrightharpoonup"},
  {0x02912, rel,     "baruparrow"},
  {0x02958, rel,     "barupharpoonleft"},
  {0x02954, rel,     "barupharpoonright"},
  {0x022BD, bin,     "barvee"},
  {0x022BC, bin,     "barwedge"},
  {0x023B6, ord,     "bbrktbrk"},
  {0x02506, ord,     "bdtriplevdash"},
  {0x02235, ord,     "because"},
  {0x023E3, ord,     "benzenr"},
  {0x003B2, ord,     "beta"},
  {0x003B2, ord,     "betaup"},
  {0x02136, ord,     "beth"},
  {0x0226C, rel,     "between"},
  {0x025BC, ord,     "bigblacktriangledown"},
  {0x025B2, ord,     "bigblacktriangleup"},
  {0x027D8, opt,     "bigbot"},
  {0x022C2, opt,     "bigcap"},
  {0x022C3, opt,     "bigcup"},
  {0x02A03, opt,     "bigcupdot"},
  {0x02AFC, opt,     "biginterleave"},
  {0x02A00, opt,     "bigodot"},
  {0x02A01, opt,     "bigoplus"},
  {0x02A02, opt,     "bigotimes"},
  {0x02A57, bin,     "bigslopedvee"},
  {0x02A58, bin,     "bigslopedwedge"},
  {0x02A05, opt,     "bigsqcap"},
  {0x02A06, opt,     "bigsqcup"},
  {0x02605, ord,     "bigstar"},
  {0x02AFF, opt,     "bigtalloblong"},
  {0x02A09, opt,     "bigtimes"},
  {0x027D9, opt,     "bigtop"},
  {0x025BD, bin,     "bigtriangledown"},
  {0x02A1E, opt,     "bigtriangleleft"},
  {0x025B3, bin,     "bigtriangleup"},
  {0x02A04, opt,     "biguplus"},
  {0x022C1, opt,     "bigvee"},
  {0x022C0, opt,     "bigwedge"},
  {0x02606, ord,     "bigwhitestar"},
  {0x02916, rel,     "bij"},
  {0x02623, ord,     "biohazard"},
  {0x029ED, ord,     "blackcircledownarrow"},
  {0x02688, ord,     "blackcircledrightdot"},
  {0x02689, ord,     "blackcircledtwodots"},
  {0x025D5, ord,     "blackcircleulquadwhite"},
  {0x029EA, ord,     "blackdiamonddownarrow"},
  {0x029D7, bin,     "blackhourglass"},
  {0x025C8, ord,     "blackinwhitediamond"},
  {0x025A3, ord,     "blackinwhitesquare"},
  {0x025D6, ord,     "blacklefthalfcircle"},
  {0x029EB, bin,     "blacklozenge"},
  {0x025C4, ord,     "blackpointerleft"},
  {0x025BA, ord,     "blackpointerright"},
  {0x025D7, ord,     "blackrighthalfcircle"},
  {0x0263B, ord,     "blacksmiley"},
  {0x025FC, ord,     "blacksquare"},
  {0x025B4, bin,     "blacktriangle"},
  {0x025BE, bin,     "blacktriangledown"},
  {0x025C0, bin,     "blacktriangleleft"},
  {0x025B6, bin,     "blacktriangleright"},
  {0x025B4, bin,     "blacktriangleup"},
  {0x02B2C, ord,     "blkhorzoval"},
  {0x02B2E, ord,     "blkvertoval"},
  {0x02588, ord,     "blockfull"},
  {0x02592, ord,     "blockhalfshaded"},
  {0x0258C, ord,     "blocklefthalf"},
  {0x02584, ord,     "blocklowhalf"},
  {0x02591, ord,     "blockqtrshaded"},
  {0x02590, ord,     "blockrighthalf"},
  {0x02593, ord,     "blockthreeqtrshaded"},
  {0x02580, ord,     "blockuphalf"},
  {0x022A5, ord,     "bot"},
  {0x025E1, ord,     "botsemicircle"},
  {0x022C8, rel,     "bowtie"},
  {0x029C6, bin,     "boxast"},
  {0x025EB, bin,     "boxbar"},
  {0x029C8, bin,     "boxbox"},
  {0x029C5, bin,     "boxbslash"},
  {0x029C7, bin,     "boxcircle"},
  {0x029C4, bin,     "boxdiag"},
  {0x022A1, bin,     "boxdot"},
  {0x0229F, bin,     "boxminus"},
  {0x029C9, ord,     "boxonbox"},
  {0x0229E, bin,     "boxplus"},
  {0x029C4, bin,     "boxslash"},
  {0x022A0, bin,     "boxtimes"},
  {0x02642, ord,     "boy"},
  {0x00306, acc,     "breve"},
  {0x02B41, rel,     "bsimilarleftarrow"},
  {0x02B47, rel,     "bsimilarrightarrow"},
  {0x027C8, rel,     "bsolhsub"},
  {0x02A32, bin,     "btimes"},
  {0x02022, bin,     "bullet"},
  {0x025CE, ord,     "bullseye"},
  {0x0224F, rel,     "bumpeq"},
  {0x02AAE, rel,     "bumpeqq"},
  {0x0228E, bin,     "buni"},
  {0x0264B, ord,     "cancer"},
  {0x00310, acc,     "candra"},
  {0x02229, bin,     "cap"},
  {0x02A49, bin,     "capbarcup"},
  {0x02A40, bin,     "capdot"},
  {0x02A47, bin,     "capovercup"},
  {0x02651, ord,     "capricornus"},
  {0x02A44, bin,     "capwedge"},
  {0x02038, ord,     "caretinsert"},
  {0x021B5, ord,     "carriagereturn"},
  {0x02040, bin,     "cat"},
  {0x0293F, rel,     "ccwundercurvearrow"},
  {0x022C5, bin,     "cdot"},
  {0x000B7, bin,     "cdotp"},
  {0x022EF, ord,     "cdots"},
  {0x000A2, ord,     "cent"},
  {0x0030C, acc,     "check"},
  {0x02713, ord,     "checkmark"},
  {0x003C7, ord,     "chi"},
  {0x003C7, ord,     "chiup"},
  {0x029C3, ord,     "cirE"},
  {0x027DF, rel,     "cirbot"},
  {0x02218, bin,     "circ"},
  {0x02257, rel,     "circeq"},
  {0x021BA, ord,     "circlearrowleft"},
  {0x021BB, ord,     "circlearrowright"},
  {0x025D2, ord,     "circlebottomhalfblack"},
  {0x000AE, ord,     "circledR"},
  {0x0229B, bin,     "circledast"},
  {0x029B8, bin,     "circledbslash"},
  {0x029BF, ord,     "circledbullet"},
  {0x0229A, bin,     "circledcirc"},
  {0x0229D, bin,     "circleddash"},
  {0x0229C, bin,     "circledequal"},
  {0x029C1, bin,     "circledgtr"},
  {0x029C0, bin,     "circledless"},
  {0x029EC, ord,     "circledownarrow"},
  {0x029B7, bin,     "circledparallel"},
  {0x02686, ord,     "circledrightdot"},
  {0x0272A, ord,     "circledstar"},
  {0x02687, ord,     "circledtwodots"},
  {0x029B6, bin,     "circledvert"},
  {0x029BE, ord,     "circledwhitebullet"},
  {0x029B5, bin,     "circlehbar"},
  {0x025D0, ord,     "circlelefthalfblack"},
  {0x025F5, ord,     "circlellquad"},
  {0x025F6, ord,     "circlelrquad"},
  {0x02B30, rel,     "circleonleftarrow"},
  {0x021F4, rel,     "circleonrightarrow"},
  {0x025D1, ord,     "circlerighthalfblack"},
  {0x025D3, ord,     "circletophalfblack"},
  {0x025F4, ord,     "circleulquad"},
  {0x025F7, ord,     "circleurquad"},
  {0x025D4, ord,     "circleurquadblack"},
  {0x025CD, ord,     "circlevertfill"},
  {0x02A10, opt | N, "cirfnint"},
  {0x02AEF, rel,     "cirmid"},
  {0x029C2, ord,     "cirscir"},
  {0x02232, opt | N, "clockoint"},
  {0x02A4D, bin,     "closedvarcap"},
  {0x02A4C, bin,     "closedvarcup"},
  {0x02A50, bin,     "closedvarcupsmashprod"},
  {0x02050, rel,     "closure"},
  {0x02663, ord,     "clubsuit"},
  {0x02233, opt | N, "cntclockoint"},
  {0x0003A, puc,     "colon"},
  {0x02254, rel,     "coloneq"},
  {0x02254, rel,     "coloneqq"},
  {0x0002C, puc,     "comma"},
  {0x02A29, bin,     "commaminus"},
  {0x02A3E, bin,     "comp"},
  {0x02201, ord,     "complement"},
  {0x027E1, bin,     "concavediamond"},
  {0x027E2, bin,     "concavediamondtickleft"},
  {0x027E3, bin,     "concavediamondtickright"},
  {0x02245, rel,     "cong"},
  {0x02A6D, rel,     "congdot"},
  {0x02332, ord,     "conictaper"},
  {0x02A07, opt,     "conjquant"},
  {0x02210, opt,     "coprod"},
  {0x02259, rel,     "corresponds"},
  {0x02ACF, rel,     "csub"},
  {0x02AD1, rel,     "csube"},
  {0x02AD0, rel,     "csup"},
  {0x02AD2, rel,     "csupe"},
  {0x0221B, ord,     "cuberoot"},
  {0x0222A, bin,     "cup"},
  {0x02A48, bin,     "cupbarcap"},
  {0x0228D, bin,     "cupdot"},
  {0x0228C, bin,     "cupleftarrow"},
  {0x02A46, bin,     "cupovercap"},
  {0x02A45, bin,     "cupvee"},
  {0x022DE, rel,     "curlyeqprec"},
  {0x022DF, rel,     "curlyeqsucc"},
  {0x022CE, bin,     "curlyvee"},
  {0x022CF, bin,     "curlywedge"},
  {0x021B6, rel,     "curvearrowleft"},
  {0x0293D, rel,     "curvearrowleftplus"},
  {0x021B7, rel,     "curvearrowright"},
  {0x0293C, rel,     "curvearrowrightminus"},
  {0x02941, rel,     "cwcirclearrow"},
  {0x027F3, rel,     "cwgapcirclearrow"},
  {0x021BB, ord,     "cwopencirclearrow"},
  {0x02938, rel,     "cwrightarcarrow"},
  {0x0293E, rel,     "cwundercurvearrow"},
  {0x02020, bin,     "dagger"},
  {0x02138, ord,     "daleth"},
  {0x02621, ord,     "danger"},
  {0x02AE3, rel,     "dashV"},
  {0x027DB, rel,     "dashVdash"},
  {0x021E2, ord,     "dasharrow"},
  {0x02239, rel,     "dashcolon"},
  {0x021E0, ord,     "dashleftarrow"},
  {0x0296B, rel,     "dashleftharpoondown"},
  {0x021E2, ord,     "dashrightarrow"},
  {0x0296D, rel,     "dashrightharpoondown"},
  {0x022A3, rel,     "dashv"},
  {0x0290F, rel,     "dbkarow"},
  {0x0222F, opt | N, "dbloint"},
  {0x02146, ord,     "dd"},
  {0x02021, bin,     "ddagger"},
  {0x020DC, acc,     "ddddot"},
  {0x020DB, acc,     "dddot"},
  {0x00308, acc,     "ddot"},
  {0x022F1, rel,     "ddots"},
  {0x02A77, rel,     "ddotseq"},
  {0x003B4, ord,     "delta"},
  {0x003B4, ord,     "deltaup"},
  {0x02300, ord,     "diameter"},
  {0x022C4, bin,     "diamond"},
  {0x02B19, ord,     "diamondbotblack"},
  {0x027D0, ord,     "diamondcdot"},
  {0x0291D, rel,     "diamondleftarrow"},
  {0x0291F, rel,     "diamondleftarrowbar"},
  {0x02B16, ord,     "diamondleftblack"},
  {0x02B17, ord,     "diamondrightblack"},
  {0x02662, ord,     "diamondsuit"},
  {0x02B18, ord,     "diamondtopblack"},
  {0x02680, ord,     "dicei"},
  {0x02681, ord,     "diceii"},
  {0x02682, ord,     "diceiii"},
  {0x02683, ord,     "diceiv"},
  {0x02684, ord,     "dicev"},
  {0x02685, ord,     "dicevi"},
  {0x003DD, ord,     "digamma"},
  {0x0273D, ord,     "dingasterisk"},
  {0x022C2, opt | N, "dint"},
  {0x022F2, rel,     "disin"},
  {0x02A08, opt,     "disjquant"},
  {0x000F7, bin,     "div"},
  {0x022C7, bin,     "divideontimes"},
  {0x02215, bin,     "divslash"},
  {0x021B2, rel,     "dlsh"},
  {0x00307, acc,     "dot"},
  {0x02250, rel,     "doteq"},
  {0x02251, rel,     "doteqdot"},
  {0x02250, rel,     "dotequal"},
  {0x02A67, rel,     "dotequiv"},
  {0x02238, bin,     "dotminus"},
  {0x02214, bin,     "dotplus"},
  {0x02A6A, rel,     "dotsim"},
  {0x0223A, rel,     "dotsminusdots"},
  {0x025CC, ord,     "dottedcircle"},
  {0x02B1A, ord,     "dottedsquare"},
  {0x02A30, bin,     "dottimes"},
  {0x02A62, bin,     "doublebarvee"},
  {0x02A5E, bin,     "doublebarwedge"},
  {0x029FA, bin,     "doubleplus"},
  {0x02193, rel,     "downarrow"},
  {0x02913, rel,     "downarrowbar"},
  {0x02908, rel,     "downarrowbarred"},
  {0x021F5, rel,     "downarrowuparrow"},
  {0x021E3, ord,     "downdasharrow"},
  {0x021CA, rel,     "downdownarrows"},
  {0x02965, rel,     "downdownharpoons"},
  {0x0297F, rel,     "downfishtail"},
  {0x021C3, rel,     "downharpoonleft"},
  {0x02959, rel,     "downharpoonleftbar"},
  {0x021C2, rel,     "downharpoonright"},
  {0x02955, rel,     "downharpoonrightbar"},
  {0x02965, rel,     "downharpoonsleftright"},
  {0x02935, ord,     "downrightcurvedarrow"},
  {0x029E8, ord,     "downtriangleleftblack"},
  {0x029E9, ord,     "downtrianglerightblack"},
  {0x021F5, rel,     "downuparrows"},
  {0x0296F, rel,     "downupharpoons"},
  {0x0296F, rel,     "downupharpoonsleftright"},
  {0x021E9, ord,     "downwhitearrow"},
  {0x021AF, rel,     "downzigzagarrow"},
  {0x02033, ord,     "dprime"},
  {0x0279B, ord,     "draftingarrow"},
  {0x02910, rel,     "drbkarow"},
  {0x025C1, bin,     "dres"},
  {0x0031A, acc,     "droang"},
  {0x021B3, rel,     "drsh"},
  {0x029F6, bin,     "dsol"},
  {0x02A64, bin,     "dsub"},
  {0x029DF, rel,     "dualmap"},
  {0x022C3, opt,     "duni"},
  {0x02641, ord,     "earth"},
  {0x02147, ord,     "ee"},
  {0x02A98, rel,     "egsdot"},
  {0x0266A, ord,     "eighthnote"},
  {0x023E7, ord,     "elinters"},
  {0x02113, ord,     "ell"},
  {0x02A97, rel,     "elsdot"},
  {0x02205, ord,     "emptyset"},
  {0x029B3, ord,     "emptysetoarr"},
  {0x029B4, ord,     "emptysetoarrl"},
  {0x029B1, ord,     "emptysetobar"},
  {0x029B2, ord,     "emptysetocirc"},
  {0x020DD, acc,     "enclosecircle"},
  {0x020DF, acc,     "enclosediamond"},
  {0x020DE, acc,     "enclosesquare"},
  {0x020E4, acc,     "enclosetriangle"},
  {0x02025, ord,     "enleadertwodots"},
  {0x029E3, rel,     "eparsl"},
  {0x003F5, ord,     "epsilon"},
  {0x003F5, ord,     "epsilonup"},
  {0x02256, rel,     "eqcirc"},
  {0x02255, rel,     "eqcolon"},
  {0x0225D, rel,     "eqdef"},
  {0x02A66, rel,     "eqdot"},
  {0x02A75, rel,     "eqeq"},
  {0x02A76, rel,     "eqeqeq"},
  {0x022DD, rel,     "eqgtr"},
  {0x022DC, rel,     "eqless"},
  {0x02255, rel,     "eqqcolon"},
  {0x02A9A, rel,     "eqqgtr"},
  {0x02A99, rel,     "eqqless"},
  {0x02A71, bin,     "eqqplus"},
  {0x02A73, rel,     "eqqsim"},
  {0x02A9C, rel,     "eqqslantgtr"},
  {0x02A9B, rel,     "eqqslantless"},
  {0x02242, rel,     "eqsim"},
  {0x02A96, rel,     "eqslantgtr"},
  {0x02A95, rel,     "eqslantless"},
  {0x0003D, rel,     "equal"},
  {0x02B40, rel,     "equalleftarrow"},
  {0x022D5, rel,     "equalparallel"},
  {0x02971, rel,     "equalrightarrow"},
  {0x021CC, rel,     "equilibrium"},
  {0x02261, rel,     "equiv"},
  {0x02A78, rel,     "equivDD"},
  {0x02A68, rel,     "equivVert"},
  {0x02A69, rel,     "equivVvert"},
  {0x029E5, rel,     "eqvparsl"},
  {0x029F3, ord,     "errbarblackcircle"},
  {0x029F1, ord,     "errbarblackdiamond"},
  {0x029EF, ord,     "errbarblacksquare"},
  {0x029F2, ord,     "errbarcircle"},
  {0x029F0, ord,     "errbardiamond"},
  {0x029EE, ord,     "errbarsquare"},
  {0x003B7, ord,     "eta"},
  {0x003B7, ord,     "etaup"},
  {0x000F0, ord,     "eth"},
  {0x020AC, ord,     "euro"},
  {0x00021, puc,     "exclam"},
  {0x02203, ord,     "exi"},
  {0x02203, ord,     "exists"},
  {0x02252, rel,     "fallingdotseq"},
  {0x02A1F, opt,     "fatsemi"},
  {0x029D3, rel,     "fbowtie"},
  {0x02A3E, bin,     "fcmp"},
  {0x0292F, ord,     "fdiagovnearrow"},
  {0x0292C, ord,     "fdiagovrdiag"},
  {0x02640, ord,     "female"},
  {0x021FB, rel,     "ffun"},
  {0x02915, rel,     "finj"},
  {0x02A0F, opt | N, "fint"},
  {0x025C9, ord,     "fisheye"},
  {0x0266D, ord,     "flat"},
  {0x023E5, ord,     "fltns"},
  {0x02200, ord,     "forall"},
  {0x02ADC, rel,     "forks"},
  {0x02ADD, rel,     "forksnot"},
  {0x02AD9, rel,     "forkv"},
  {0x02057, ord,     "fourth"},
  {0x0221C, ord,     "fourthroot"},
  {0x02999, ord,     "fourvdots"},
  {0x02044, bin,     "fracslash"},
  {0x02322, rel,     "frown"},
  {0x02639, ord,     "frownie"},
  {0x027D7, opt,     "fullouterjoin"},
  {0x02192, rel,     "fun"},
  {0x003B3, ord,     "gamma"},
  {0x003B3, ord,     "gammaup"},
  {0x02265, rel,     "ge"},
  {0x0264A, ord,     "gemini"},
  {0x02265, rel,     "geq"},
  {0x02267, rel,     "geqq"},
  {0x02AFA, rel,     "geqqslant"},
  {0x02A7E, rel,     "geqslant"},
  {0x02AA9, rel,     "gescc"},
  {0x02A80, rel,     "gesdot"},
  {0x02A82, rel,     "gesdoto"},
  {0x02A84, rel,     "gesdotol"},
  {0x02A94, rel,     "gesles"},
  {0x02190, rel,     "gets"},
  {0x0226B, rel,     "gg"},
  {0x02ABC, rel,     "ggcurly"},
  {0x022D9, rel,     "ggg"},
  {0x02AF8, rel,     "gggnest"},
  {0x02137, ord,     "gimel"},
  {0x02640, ord,     "girl"},
  {0x02A92, rel,     "glE"},
  {0x02AA5, rel,     "gla"},
  {0x029E6, rel,     "gleichstark"},
  {0x02AA4, rel,     "glj"},
  {0x02A8A, rel,     "gnapprox"},
  {0x02A88, rel,     "gneq"},
  {0x02269, rel,     "gneqq"},
  {0x022E7, rel,     "gnsim"},
  {0x00300, acc,     "grave"},
  {0x0003E, rel,     "greater"},
  {0x02A8E, rel,     "gsime"},
  {0x02A90, rel,     "gsiml"},
  {0x0003E, rel,     "gt"},
  {0x02AA7, rel,     "gtcc"},
  {0x02A7A, rel,     "gtcir"},
  {0x029A0, ord,     "gtlpar"},
  {0x02A7C, rel,     "gtquest"},
  {0x02A86, rel,     "gtrapprox"},
  {0x02978, rel,     "gtrarr"},
  {0x022D7, rel,     "gtrdot"},
  {0x022DB, rel,     "gtreqless"},
  {0x02A8C, rel,     "gtreqqless"},
  {0x02277, rel,     "gtrless"},
  {0x02273, rel,     "gtrsim"},
  {0x023AF, ord,     "harrowextender"},
  {0x022D5, rel,     "hash"},
  {0x00302, acc,     "hat"},
  {0x02A6F, rel,     "hatapprox"},
  {0x02661, ord,     "heartsuit"},
  {0x022B9, ord,     "hermitmatrix"},
  {0x02394, ord,     "hexagon"},
  {0x02B23, ord,     "hexagonblack"},
  {0x029F9, opt,     "hide"},
  {0x02924, rel,     "hknearrow"},
  {0x02923, rel,     "hknwarrow"},
  {0x02925, rel,     "hksearow"},
  {0x02926, rel,     "hkswarow"},
  {0x021A9, rel,     "hookleftarrow"},
  {0x021AA, rel,     "hookrightarrow"},
  {0x02015, ord,     "horizbar"},
  {0x029D6, bin,     "hourglass"},
  {0x02302, ord,     "house"},
  {0x025AD, ord,     "hrectangle"},
  {0x025AC, ord,     "hrectangleblack"},
  {0x0210F, ord,     "hslash"},
  {0x02043, ord,     "hyphenbullet"},
  {0x03030, ord,     "hzigzag"},
  {0x022F0, rel,     "iddots"},
  {0x027FA, rel,     "iff"},
  {0x02148, ord,     "ii"},
  {0x02A0C, opt | N, "iiiint"},
  {0x0222D, opt | N, "iiint"},
  {0x029DC, ord,     "iinfin"},
  {0x0222C, opt | N, "iint"},
  {0x022B7, rel,     "imageof"},
  {0x00131, ord,     "imath"},
  {0x027F8, rel,     "impliedby"},
  {0x027F9, rel,     "implies"},
  {0x02208, rel,     "in"},
  {0x02206, ord,     "increment"},
  {0x0221E, ord,     "infty"},
  {0x021A3, rel,     "inj"},
  {0x0222B, opt | N, "int"},
  {0x02A0E, opt | N, "intBar"},
  {0x02A0D, opt | N, "intbar"},
  {0x02321, ord,     "intbottom"},
  {0x02A19, opt | N, "intcap"},
  {0x02231, opt | N, "intclockwise"},
  {0x02A1A, opt | N, "intcup"},
  {0x022BA, bin,     "intercal"},
  {0x02AF4, bin,     "interleave"},
  {0x023AE, ord,     "intextender"},
  {0x02A17, opt | N, "intlarhk"},
  {0x02A3C, bin,     "intprod"},
  {0x02A3D, bin,     "intprodr"},
  {0x02320, ord,     "inttop"},
  {0x02A18, opt | N, "intx"},
  {0x0214B, bin,     "invamp"},
  {0x02349, ord,     "invdiameter"},
  {0x025D8, ord,     "inversebullet"},
  {0x025D9, ord,     "inversewhitecircle"},
  {0x0223E, bin,     "invlazys"},
  {0x02310, ord,     "invneg"},
  {0x02310, ord,     "invnot"},
  {0x0263B, ord,     "invsmileface"},
  {0x025DB, ord,     "invwhitelowerhalfcircle"},
  {0x025DA, ord,     "invwhiteupperhalfcircle"},
  {0x003B9, ord,     "iota"},
  {0x003B9, ord,     "iotaup"},
  {0x022F9, rel,     "isinE"},
  {0x022F5, rel,     "isindot"},
  {0x022F7, rel,     "isinobar"},
  {0x022F4, rel,     "isins"},
  {0x022F8, rel,     "isinvb"},
  {0x02149, ord,     "jj"},
  {0x00237, ord,     "jmath"},
  {0x02643, ord,     "jupiter"},
  {0x003BA, ord,     "kappa"},
  {0x003BA, ord,     "kappaup"},
  {0x0223B, rel,     "kernelcontraction"},
  {0x003D9, ord,     "koppa"},
  {0x027EA, opn,     "lAngle"},
  {0x02983, opn,     "lBrace"},
  {0x027E6, opn,     "lBrack"},
  {0x02985, opn,     "lParen"},
  {0x003BB, ord,     "lambda"},
  {0x003BB, ord,     "lambdaup"},
  {0x02227, bin,     "land"},
  {0x027EA, opn,     "lang"},
  {0x027E8, opn,     "langle"},
  {0x02991, opn,     "langledot"},
  {0x029E0, ord,     "laplac"},
  {0x02AAB, rel,     "lat"},
  {0x02AAD, rel,     "late"},
  {0x027C5, opn,     "lbag"},
  {0x02997, opn,     "lblkbrbrak"},
  {0x02989, opn,     "lblot"},
  {0x0007B, opn,     "lbrace"},
  {0x023A9, ord,     "lbracelend"},
  {0x023A8, ord,     "lbracemid"},
  {0x023A7, ord,     "lbraceuend"},
  {0x0005B, opn,     "lbrack"},
  {0x023A2, ord,     "lbrackextender"},
  {0x023A3, ord,     "lbracklend"},
  {0x0298F, opn,     "lbracklltick"},
  {0x0298B, opn,     "lbrackubar"},
  {0x023A1, ord,     "lbrackuend"},
  {0x0298D, opn,     "lbrackultick"},
  {0x02772, opn,     "lbrbrak"},
  {0x02308, opn,     "lceil"},
  {0x029FC, opn,     "lcurvyangle"},
  {0x02026, ord,     "ldots"},
  {0x02264, rel,     "le"},
  {0x02933, rel,     "leadsto"},
  {0x02190, rel,     "leftarrow"},
  {0x02B4A, rel,     "leftarrowapprox"},
  {0x02B42, rel,     "leftarrowbackapprox"},
  {0x02B4B, rel,     "leftarrowbsimilar"},
  {0x02977, rel,     "leftarrowless"},
  {0x02B32, rel,     "leftarrowonoplus"},
  {0x02946, rel,     "leftarrowplus"},
  {0x02943, rel,     "leftarrowshortrightarrow"},
  {0x02973, rel,     "leftarrowsimilar"},
  {0x0297A, rel,     "leftarrowsubset"},
  {0x021A2, rel,     "leftarrowtail"},
  {0x021FD, rel,     "leftarrowtriangle"},
  {0x02B3E, rel,     "leftarrowx"},
  {0x0296A, rel,     "leftbarharpoon"},
  {0x0290C, rel,     "leftbkarrow"},
  {0x02B3F, rel,     "leftcurvedarrow"},
  {0x021E0, ord,     "leftdasharrow"},
  {0x0290E, rel,     "leftdbkarrow"},
  {0x0291B, rel,     "leftdbltail"},
  {0x02B38, rel,     "leftdotarrow"},
  {0x02936, rel,     "leftdowncurvedarrow"},
  {0x0297C, rel,     "leftfishtail"},
  {0x020D0, acc,     "leftharpoonaccent"},
  {0x021BD, rel,     "leftharpoondown"},
  {0x0295E, rel,     "leftharpoondownbar"},
  {0x02962, rel,     "leftharpoonsupdown"},
  {0x021BC, rel,     "leftharpoonup"},
  {0x0295A, rel,     "leftharpoonupbar"},
  {0x0296A, rel,     "leftharpoonupdash"},
  {0x021C7, rel,     "leftleftarrows"},
  {0x02962, rel,     "leftleftharpoons"},
  {0x0263E, ord,     "leftmoon"},
  {0x027D5, opt,     "leftouterjoin"},
  {0x02194, rel,     "leftrightarrow"},
  {0x02948, rel,     "leftrightarrowcircle"},
  {0x021C6, rel,     "leftrightarrows"},
  {0x021FF, rel,     "leftrightarrowtriangle"},
  {0x0294A, rel,     "leftrightharpoon"},
  {0x02950, rel,     "leftrightharpoondown"},
  {0x02950, rel,     "leftrightharpoondowndown"},
  {0x0294B, rel,     "leftrightharpoondownup"},
  {0x021CB, rel,     "leftrightharpoons"},
  {0x02967, rel,     "leftrightharpoonsdown"},
  {0x02966, rel,     "leftrightharpoonsup"},
  {0x0294E, rel,     "leftrightharpoonup"},
  {0x0294A, rel,     "leftrightharpoonupdown"},
  {0x0294E, rel,     "leftrightharpoonupup"},
  {0x021AD, rel,     "leftrightsquigarrow"},
  {0x02AA6, rel,     "leftslice"},
  {0x021DC, rel,     "leftsquigarrow"},
  {0x02919, rel,     "lefttail"},
  {0x02B31, rel,     "leftthreearrows"},
  {0x022CB, bin,     "leftthreetimes"},
  {0x021BA, ord,     "leftturn"},
  {0x02951, rel,     "leftupdownharpoon"},
  {0x0219C, rel,     "leftwavearrow"},
  {0x021E6, ord,     "leftwhitearrow"},
  {0x0264C, ord,     "leo"},
  {0x02264, rel,     "leq"},
  {0x02266, rel,     "leqq"},
  {0x02AF9, rel,     "leqqslant"},
  {0x02A7D, rel,     "leqslant"},
  {0x02AA8, rel,     "lescc"},
  {0x02A7F, rel,     "lesdot"},
  {0x02A81, rel,     "lesdoto"},
  {0x02A83, rel,     "lesdotor"},
  {0x02A93, rel,     "lesges"},
  {0x0003C, rel,     "less"},
  {0x02A85, rel,     "lessapprox"},
  {0x022D6, rel,     "lessdot"},
  {0x022DA, rel,     "lesseqgtr"},
  {0x02A8B, rel,     "lesseqqgtr"},
  {0x02276, rel,     "lessgtr"},
  {0x02272, rel,     "lesssim"},
  {0x029D1, rel,     "lfbowtie"},
  {0x0230A, opn,     "lfloor"},
  {0x029D4, rel,     "lftimes"},
  {0x02A91, rel,     "lgE"},
  {0x02B24, ord,     "lgblkcircle"},
  {0x02B1B, ord,     "lgblksquare"},
  {0x027EE, opn,     "lgroup"},
  {0x025EF, ord,     "lgwhtcircle"},
  {0x02B1C, ord,     "lgwhtsquare"},
  {0x025C1, bin,     "lhd"},
  {0x0264E, ord,     "libra"},
  {0x021AF, rel,     "lightning"},
  {0x02987, opn,     "limg"},
  {0x021B4, ord,     "linefeed"},
  {0x0226A, rel,     "ll"},
  {0x02989, opn,     "llangle"},
  {0x025DF, ord,     "llarc"},
  {0x025E3, ord,     "llblacktriangle"},
  {0x027E6, opn,     "llbracket"},
  {0x0231E, opn,     "llcorner"},
  {0x02ABB, rel,     "llcurly"},
  {0x022D8, rel,     "lll"},
  {0x02AF7, rel,     "lllnest"},
  {0x02987, opn,     "llparenthesis"},
  {0x025FA, ord,     "lltriangle"},
  {0x023B0, ord,     "lmoustache"},
  {0x02A89, rel,     "lnapprox"},
  {0x02A87, rel,     "lneq"},
  {0x02268, rel,     "lneqq"},
  {0x000AC, ord,     "lnot"},
  {0x022E6, rel,     "lnsim"},
  {0x027DE, rel,     "longdashv"},
  {0x027CC, opn,     "longdivision"},
  {0x027F5, rel,     "longleftarrow"},
  {0x027F7, rel,     "longleftrightarrow"},
  {0x02B33, rel,     "longleftsquigarrow"},
  {0x027FB, rel,     "longmappedfrom"},
  {0x027FB, rel,     "longmapsfrom"},
  {0x027FC, rel,     "longmapsto"},
  {0x027F6, rel,     "longrightarrow"},
  {0x027FF, rel,     "longrightsquigarrow"},
  {0x021AB, rel,     "looparrowleft"},
  {0x021AC, rel,     "looparrowright"},
  {0x02228, bin,     "lor"},
  {0x02A1C, opt | N, "lowint"},
  {0x025CA, ord,     "lozenge"},
  {0x027E0, bin,     "lozengeminus"},
  {0x00028, opn,     "lparen"},
  {0x0239C, ord,     "lparenextender"},
  {0x0239D, ord,     "lparenlend"},
  {0x02993, opn,     "lparenless"},
  {0x0239B, ord,     "lparenuend"},
  {0x025DE, ord,     "lrarc"},
  {0x025E2, ord,     "lrblacktriangle"},
  {0x0231F, cls,     "lrcorner"},
  {0x022C8, rel,     "lrtimes"},
  {0x025FF, ord,     "lrtriangle"},
  {0x029E1, rel,     "lrtriangleeq"},
  {0x02A8D, rel,     "lsime"},
  {0x02A8F, rel,     "lsimg"},
  {0x02ACD, rel,     "lsqhook"},
  {0x0003C, rel,     "lt"},
  {0x02AA6, rel,     "ltcc"},
  {0x02A79, rel,     "ltcir"},
  {0x022C9, bin,     "ltimes"},
  {0x02976, rel,     "ltlarr"},
  {0x02A7B, rel,     "ltquest"},
  {0x029CF, rel,     "ltrivb"},
  {0x023B8, ord,     "lvboxline"},
  {0x020D0, acc,     "lvec"},
  {0x029D8, opn,     "lvzigzag"},
  {0x02642, ord,     "male"},
  {0x02720, ord,     "maltese"},
  {0x021A4, rel,     "mappedfrom"},
  {0x021A7, rel,     "mapsdown"},
  {0x021A4, rel,     "mapsfrom"},
  {0x021A6, rel,     "mapsto"},
  {0x021A5, rel,     "mapsup"},
  {0x000A2, ord,     "mathcent"},
  {0x0003A, puc,     "mathcolon"},
  {0x00024, ord,     "mathdollar"},
  {0x000F0, ord,     "matheth"},
  {0x02236, rel,     "mathratio"},
  {0x0030A, acc,     "mathring"},
  {0x02215, ord,     "mathslash"},
  {0x000A3, ord,     "mathsterling"},
  {0x1D400, ord,     "mbfA"},
  {0x1D6A8, ord,     "mbfAlpha"},
  {0x1D401, ord,     "mbfB"},
  {0x1D6A9, ord,     "mbfBeta"},
  {0x1D402, ord,     "mbfC"},
  {0x1D6BE, ord,     "mbfChi"},
  {0x1D403, ord,     "mbfD"},
  {0x1D6AB, ord,     "mbfDelta"},
  {0x1D7CA, ord,     "mbfDigamma"},
  {0x1D404, ord,     "mbfE"},
  {0x1D6AC, ord,     "mbfEpsilon"},
  {0x1D6AE, ord,     "mbfEta"},
  {0x1D405, ord,     "mbfF"},
  {0x1D406, ord,     "mbfG"},
  {0x1D6AA, ord,     "mbfGamma"},
  {0x1D407, ord,     "mbfH"},
  {0x1D408, ord,     "mbfI"},
  {0x1D6B0, ord,     "mbfIota"},
  {0x1D409, ord,     "mbfJ"},
  {0x1D40A, ord,     "mbfK"},
  {0x1D6B1, ord,     "mbfKappa"},
  {0x1D40B, ord,     "mbfL"},
  {0x1D6B2, ord,     "mbfLambda"},
  {0x1D40C, ord,     "mbfM"},
  {0x1D6B3, ord,     "mbfMu"},
  {0x1D40D, ord,     "mbfN"},
  {0x1D6B4, ord,     "mbfNu"},
  {0x1D40E, ord,     "mbfO"},
  {0x1D6C0, ord,     "mbfOmega"},
  {0x1D6B6, ord,     "mbfOmicron"},
  {0x1D40F, ord,     "mbfP"},
  {0x1D6BD, ord,     "mbfPhi"},
  {0x1D6B7, ord,     "mbfPi"},
  {0x1D6BF, ord,     "mbfPsi"},
  {0x1D410, ord,     "mbfQ"},
  {0x1D411, ord,     "mbfR"},
  {0x1D6B8, ord,     "mbfRho"},
  {0x1D412, ord,     "mbfS"},
  {0x1D6BA, ord,     "mbfSigma"},
  {0x1D413, ord,     "mbfT"},
  {0x1D6BB, ord,     "mbfTau"},
  {0x1D6AF, ord,     "mbfTheta"},
  {0x1D414, ord,     "mbfU"},
  {0x1D6BC, ord,     "mbfUpsilon"},
  {0x1D415, ord,     "mbfV"},
  {0x1D416, ord,     "mbfW"},
  {0x1D417, ord,     "mbfX"},
  {0x1D6B5, ord,     "mbfXi"},
  {0x1D418, ord,     "mbfY"},
  {0x1D419, ord,     "mbfZ"},
  {0x1D6AD, ord,     "mbfZeta"},
  {0x1D41A, ord,     "mbfa"},
  {0x1D6C2, ord,     "mbfalpha"},
  {0x1D41B, ord,     "mbfb"},
  {0x1D6C3, ord,     "mbfbeta"},
  {0x1D41C, ord,     "mbfc"},
  {0x1D6D8, ord,     "mbfchi"},
  {0x1D41D, ord,     "mbfd"},
  {0x1D6C5, ord,     "mbfdelta"},
  {0x1D7CB, ord,     "mbfdigamma"},
  {0x1D41E, ord,     "mbfe"},
  {0x1D6C6, ord,     "mbfepsilon"},
  {0x1D6C8, ord,     "mbfeta"},
  {0x1D41F, ord,     "mbff"},
  {0x1D56C, ord,     "mbffrakA"},
  {0x1D56D, ord,     "mbffrakB"},
  {0x1D56E, ord,     "mbffrakC"},
  {0x1D56F, ord,     "mbffrakD"},
  {0x1D570, ord,     "mbffrakE"},
  {0x1D571, ord,     "mbffrakF"},
  {0x1D572, ord,     "mbffrakG"},
  {0x1D573, ord,     "mbffrakH"},
  {0x1D574, ord,     "mbffrakI"},
  {0x1D575, ord,     "mbffrakJ"},
  {0x1D576, ord,     "mbffrakK"},
  {0x1D577, ord,     "mbffrakL"},
  {0x1D578, ord,     "mbffrakM"},
  {0x1D579, ord,     "mbffrakN"},
  {0x1D57A, ord,     "mbffrakO"},
  {0x1D57B, ord,     "mbffrakP"},
  {0x1D57C, ord,     "mbffrakQ"},
  {0x1D57D, ord,     "mbffrakR"},
  {0x1D57E, ord,     "mbffrakS"},
  {0x1D57F, ord,     "mbffrakT"},
  {0x1D580, ord,     "mbffrakU"},
  {0x1D581, ord,     "mbffrakV"},
  {0x1D582, ord,     "mbffrakW"},
  {0x1D583, ord,     "mbffrakX"},
  {0x1D584, ord,     "mbffrakY"},
  {0x1D585, ord,     "mbffrakZ"},
  {0x1D586, ord,     "mbffraka"},
  {0x1D587, ord,     "mbffrakb"},
  {0x1D588, ord,     "mbffrakc"},
  {0x1D589, ord,     "mbffrakd"},
  {0x1D58A, ord,     "mbffrake"},
  {0x1D58B, ord,     "mbffrakf"},
  {0x1D58C, ord,     "mbffrakg"},
  {0x1D58D, ord,     "mbffrakh"},
  {0x1D58E, ord,     "mbffraki"},
  {0x1D58F, ord,     "mbffrakj"},
  {0x1D590, ord,     "mbffrakk"},
  {0x1D591, ord,     "mbffrakl"},
  {0x1D592, ord,     "mbffrakm"},
  {0x1D593, ord,     "mbffrakn"},
  {0x1D594, ord,     "mbffrako"},
  {0x1D595, ord,     "mbffrakp"},
  {0x1D596, ord,     "mbffrakq"},
  {0x1D597, ord,     "mbffrakr"},
  {0x1D598, ord,     "mbffraks"},
  {0x1D599, ord,     "mbffrakt"},
  {0x1D59A, ord,     "mbffraku"},
  {0x1D59B, ord,     "mbffrakv"},
  {0x1D59C, ord,     "mbffrakw"},
  {0x1D59D, ord,     "mbffrakx"},
  {0x1D59E, ord,     "mbffraky"},
  {0x1D59F, ord,     "mbffrakz"},
  {0x1D420, ord,     "mbfg"},
  {0x1D6C4, ord,     "mbfgamma"},
  {0x1D421, ord,     "mbfh"},
  {0x1D422, ord,     "mbfi"},
  {0x1D6CA, ord,     "mbfiota"},
  {0x1D468, ord,     "mbfitA"},
  {0x1D71C, ord,     "mbfitAlpha"},
  {0x1D469, ord,     "mbfitB"},
  {0x1D71D, ord,     "mbfitBeta"},
  {0x1D46A, ord,     "mbfitC"},
  {0x1D732, ord,     "mbfitChi"},
  {0x1D46B, ord,     "mbfitD"},
  {0x1D71F, ord,     "mbfitDelta"},
  {0x1D46C, ord,     "mbfitE"},
  {0x1D720, ord,     "mbfitEpsilon"},
  {0x1D722, ord,     "mbfitEta"},
  {0x1D46D, ord,     "mbfitF"},
  {0x1D46E, ord,     "mbfitG"},
  {0x1D71E, ord,     "mbfitGamma"},
  {0x1D46F, ord,     "mbfitH"},
  {0x1D470, ord,     "mbfitI"},
  {0x1D724, ord,     "mbfitIota"},
  {0x1D471, ord,     "mbfitJ"},
  {0x1D472, ord,     "mbfitK"},
  {0x1D725, ord,     "mbfitKappa"},
  {0x1D473, ord,     "mbfitL"},
  {0x1D726, ord,     "mbfitLambda"},
  {0x1D474, ord,     "mbfitM"},
  {0x1D727, ord,     "mbfitMu"},
  {0x1D475, ord,     "mbfitN"},
  {0x1D728, ord,     "mbfitNu"},
  {0x1D476, ord,     "mbfitO"},
  {0x1D734, ord,     "mbfitOmega"},
  {0x1D72A, ord,     "mbfitOmicron"},
  {0x1D477, ord,     "mbfitP"},
  {0x1D731, ord,     "mbfitPhi"},
  {0x1D72B, ord,     "mbfitPi"},
  {0x1D733, ord,     "mbfitPsi"},
  {0x1D478, ord,     "mbfitQ"},
  {0x1D479, ord,     "mbfitR"},
  {0x1D72C, ord,     "mbfitRho"},
  {0x1D47A, ord,     "mbfitS"},
  {0x1D72E, ord,     "mbfitSigma"},
  {0x1D47B, ord,     "mbfitT"},
  {0x1D72F, ord,     "mbfitTau"},
  {0x1D723, ord,     "mbfitTheta"},
  {0x1D47C, ord,     "mbfitU"},
  {0x1D730, ord,     "mbfitUpsilon"},
  {0x1D47D, ord,     "mbfitV"},
  {0x1D47E, ord,     "mbfitW"},
  {0x1D47F, ord,     "mbfitX"},
  {0x1D729, ord,     "mbfitXi"},
  {0x1D480, ord,     "mbfitY"},
  {0x1D481, ord,     "mbfitZ"},
  {0x1D721, ord,     "mbfitZeta"},
  {0x1D482, ord,     "mbfita"},
  {0x1D736, ord,     "mbfitalpha"},
  {0x1D483, ord,     "mbfitb"},
  {0x1D737, ord,     "mbfitbeta"},
  {0x1D484, ord,     "mbfitc"},
  {0x1D74C, ord,     "mbfitchi"},
  {0x1D485, ord,     "mbfitd"},
  {0x1D739, ord,     "mbfitdelta"},
  {0x1D486, ord,     "mbfite"},
  {0x1D73A, ord,     "mbfitepsilon"},
  {0x1D73C, ord,     "mbfiteta"},
  {0x1D487, ord,     "mbfitf"},
  {0x1D488, ord,     "mbfitg"},
  {0x1D738, ord,     "mbfitgamma"},
  {0x1D489, ord,     "mbfith"},
  {0x1D48A, ord,     "mbfiti"},
  {0x1D73E, ord,     "mbfitiota"},
  {0x1D48B, ord,     "mbfitj"},
  {0x1D48C, ord,     "mbfitk"},
  {0x1D73F, ord,     "mbfitkappa"},
  {0x1D48D, ord,     "mbfitl"},
  {0x1D740, ord,     "mbfitlambda"},
  {0x1D48E, ord,     "mbfitm"},
  {0x1D741, ord,     "mbfitmu"},
  {0x1D48F, ord,     "mbfitn"},
  {0x1D735, ord,     "mbfitnabla"},
  {0x1D742, ord,     "mbfitnu"},
  {0x1D490, ord,     "mbfito"},
  {0x1D74E, ord,     "mbfitomega"},
  {0x1D744, ord,     "mbfitomicron"},
  {0x1D491, ord,     "mbfitp"},
  {0x1D74F, ord,     "mbfitpartial"},
  {0x1D74B, ord,     "mbfitphi"},
  {0x1D745, ord,     "mbfitpi"},
  {0x1D74D, ord,     "mbfitpsi"},
  {0x1D492, ord,     "mbfitq"},
  {0x1D493, ord,     "mbfitr"},
  {0x1D746, ord,     "mbfitrho"},
  {0x1D494, ord,     "mbfits"},
  {0x1D63C, ord,     "mbfitsansA"},
  {0x1D790, ord,     "mbfitsansAlpha"},
  {0x1D63D, ord,     "mbfitsansB"},
  {0x1D791, ord,     "mbfitsansBeta"},
  {0x1D63E, ord,     "mbfitsansC"},
  {0x1D7A6, ord,     "mbfitsansChi"},
  {0x1D63F, ord,     "mbfitsansD"},
  {0x1D793, ord,     "mbfitsansDelta"},
  {0x1D640, ord,     "mbfitsansE"},
  {0x1D794, ord,     "mbfitsansEpsilon"},
  {0x1D796, ord,     "mbfitsansEta"},
  {0x1D641, ord,     "mbfitsansF"},
  {0x1D642, ord,     "mbfitsansG"},
  {0x1D792, ord,     "mbfitsansGamma"},
  {0x1D643, ord,     "mbfitsansH"},
  {0x1D644, ord,     "mbfitsansI"},
  {0x1D798, ord,     "mbfitsansIota"},
  {0x1D645, ord,     "mbfitsansJ"},
  {0x1D646, ord,     "mbfitsansK"},
  {0x1D799, ord,     "mbfitsansKappa"},
  {0x1D647, ord,     "mbfitsansL"},
  {0x1D79A, ord,     "mbfitsansLambda"},
  {0x1D648, ord,     "mbfitsansM"},
  {0x1D79B, ord,     "mbfitsansMu"},
  {0x1D649, ord,     "mbfitsansN"},
  {0x1D79C, ord,     "mbfitsansNu"},
  {0x1D64A, ord,     "mbfitsansO"},
  {0x1D7A8, ord,     "mbfitsansOmega"},
  {0x1D79E, ord,     "mbfitsansOmicron"},
  {0x1D64B, ord,     "mbfitsansP"},
  {0x1D7A5, ord,     "mbfitsansPhi"},
  {0x1D79F, ord,     "mbfitsansPi"},
  {0x1D7A7, ord,     "mbfitsansPsi"},
  {0x1D64C, ord,     "mbfitsansQ"},
  {0x1D64D, ord,     "mbfitsansR"},
  {0x1D7A0, ord,     "mbfitsansRho"},
  {0x1D64E, ord,     "mbfitsansS"},
  {0x1D7A2, ord,     "mbfitsansSigma"},
  {0x1D64F, ord,     "mbfitsansT"},
  {0x1D7A3, ord,     "mbfitsansTau"},
  {0x1D797, ord,     "mbfitsansTheta"},
  {0x1D650, ord,     "mbfitsansU"},
  {0x1D7A4, ord,     "mbfitsansUpsilon"},
  {0x1D651, ord,     "mbfitsansV"},
  {0x1D652, ord,     "mbfitsansW"},
  {0x1D653, ord,     "mbfitsansX"},
  {0x1D79D, ord,     "mbfitsansXi"},
  {0x1D654, ord,     "mbfitsansY"},
  {0x1D655, ord,     "mbfitsansZ"},
  {0x1D795, ord,     "mbfitsansZeta"},
  {0x1D656, ord,     "mbfitsansa"},
  {0x1D7AA, ord,     "mbfitsansalpha"},
  {0x1D657, ord,     "mbfitsansb"},
  {0x1D7AB, ord,     "mbfitsansbeta"},
  {0x1D658, ord,     "mbfitsansc"},
  {0x1D7C0, ord,     "mbfitsanschi"},
  {0x1D659, ord,     "mbfitsansd"},
  {0x1D7AD, ord,     "mbfitsansdelta"},
  {0x1D65A, ord,     "mbfitsanse"},
  {0x1D7AE, ord,     "mbfitsansepsilon"},
  {0x1D7B0, ord,     "mbfitsanseta"},
  {0x1D65B, ord,     "mbfitsansf"},
  {0x1D65C, ord,     "mbfitsansg"},
  {0x1D7AC, ord,     "mbfitsansgamma"},
  {0x1D65D, ord,     "mbfitsansh"},
  {0x1D65E, ord,     "mbfitsansi"},
  {0x1D7B2, ord,     "mbfitsansiota"},
  {0x1D65F, ord,     "mbfitsansj"},
  {0x1D660, ord,     "mbfitsansk"},
  {0x1D7B3, ord,     "mbfitsanskappa"},
  {0x1D661, ord,     "mbfitsansl"},
  {0x1D7B4, ord,     "mbfitsanslambda"},
  {0x1D662, ord,     "mbfitsansm"},
  {0x1D7B5, ord,     "mbfitsansmu"},
  {0x1D663, ord,     "mbfitsansn"},
  {0x1D7A9, ord,     "mbfitsansnabla"},
  {0x1D7B6, ord,     "mbfitsansnu"},
  {0x1D664, ord,     "mbfitsanso"},
  {0x1D7C2, ord,     "mbfitsansomega"},
  {0x1D7B8, ord,     "mbfitsansomicron"},
  {0x1D665, ord,     "mbfitsansp"},
  {0x1D7C3, ord,     "mbfitsanspartial"},
  {0x1D7BF, ord,     "mbfitsansphi"},
  {0x1D7B9, ord,     "mbfitsanspi"},
  {0x1D7C1, ord,     "mbfitsanspsi"},
  {0x1D666, ord,     "mbfitsansq"},
  {0x1D667, ord,     "mbfitsansr"},
  {0x1D7BA, ord,     "mbfitsansrho"},
  {0x1D668, ord,     "mbfitsanss"},
  {0x1D7BC, ord,     "mbfitsanssigma"},
  {0x1D669, ord,     "mbfitsanst"},
  {0x1D7BD, ord,     "mbfitsanstau"},
  {0x1D7B1, ord,     "mbfitsanstheta"},
  {0x1D66A, ord,     "mbfitsansu"},
  {0x1D7BE, ord,     "mbfitsansupsilon"},
  {0x1D66B, ord,     "mbfitsansv"},
  {0x1D7A1, ord,     "mbfitsansvarTheta"},
  {0x1D7C4, ord,     "mbfitsansvarepsilon"},
  {0x1D7C6, ord,     "mbfitsansvarkappa"},
  {0x1D7C7, ord,     "mbfitsansvarphi"},
  {0x1D7C9, ord,     "mbfitsansvarpi"},
  {0x1D7C8, ord,     "mbfitsansvarrho"},
  {0x1D7BB, ord,     "mbfitsansvarsigma"},
  {0x1D7C5, ord,     "mbfitsansvartheta"},
  {0x1D66C, ord,     "mbfitsansw"},
  {0x1D66D, ord,     "mbfitsansx"},
  {0x1D7B7, ord,     "mbfitsansxi"},
  {0x1D66E, ord,     "mbfitsansy"},
  {0x1D66F, ord,     "mbfitsansz"},
  {0x1D7AF, ord,     "mbfitsanszeta"},
  {0x1D748, ord,     "mbfitsigma"},
  {0x1D495, ord,     "mbfitt"},
  {0x1D749, ord,     "mbfittau"},
  {0x1D73D, ord,     "mbfittheta"},
  {0x1D496, ord,     "mbfitu"},
  {0x1D74A, ord,     "mbfitupsilon"},
  {0x1D497, ord,     "mbfitv"},
  {0x1D72D, ord,     "mbfitvarTheta"},
  {0x1D750, ord,     "mbfitvarepsilon"},
  {0x1D752, ord,     "mbfitvarkappa"},
  {0x1D753, ord,     "mbfitvarphi"},
  {0x1D755, ord,     "mbfitvarpi"},
  {0x1D754, ord,     "mbfitvarrho"},
  {0x1D747, ord,     "mbfitvarsigma"},
  {0x1D751, ord,     "mbfitvartheta"},
  {0x1D498, ord,     "mbfitw"},
  {0x1D499, ord,     "mbfitx"},
  {0x1D743, ord,     "mbfitxi"},
  {0x1D49A, ord,     "mbfity"},
  {0x1D49B, ord,     "mbfitz"},
  {0x1D73B, ord,     "mbfitzeta"},
  {0x1D423, ord,     "mbfj"},
  {0x1D424, ord,     "mbfk"},
  {0x1D6CB, ord,     "mbfkappa"},
  {0x1D425, ord,     "mbfl"},
  {0x1D6CC, ord,     "mbflambda"},
  {0x1D426, ord,     "mbfm"},
  {0x1D6CD, ord,     "mbfmu"},
  {0x1D427, ord,     "mbfn"},
  {0x1D6C1, ord,     "mbfnabla"},
  {0x1D6CE, ord,     "mbfnu"},
  {0x1D428, ord,     "mbfo"},
  {0x1D6DA, ord,     "mbfomega"},
  {0x1D6D0, ord,     "mbfomicron"},
  {0x1D429, ord,     "mbfp"},
  {0x1D6DB, ord,     "mbfpartial"},
  {0x1D6DF, ord,     "mbfphi"},
  {0x1D6D1, ord,     "mbfpi"},
  {0x1D6D9, ord,     "mbfpsi"},
  {0x1D42A, ord,     "mbfq"},
  {0x1D42B, ord,     "mbfr"},
  {0x1D6D2, ord,     "mbfrho"},
  {0x1D42C, ord,     "mbfs"},
  {0x1D5D4, ord,     "mbfsansA"},
  {0x1D756, ord,     "mbfsansAlpha"},
  {0x1D5D5, ord,     "mbfsansB"},
  {0x1D757, ord,     "mbfsansBeta"},
  {0x1D5D6, ord,     "mbfsansC"},
  {0x1D76C, ord,     "mbfsansChi"},
  {0x1D5D7, ord,     "mbfsansD"},
  {0x1D759, ord,     "mbfsansDelta"},
  {0x1D5D8, ord,     "mbfsansE"},
  {0x1D75A, ord,     "mbfsansEpsilon"},
  {0x1D75C, ord,     "mbfsansEta"},
  {0x1D5D9, ord,     "mbfsansF"},
  {0x1D5DA, ord,     "mbfsansG"},
  {0x1D758, ord,     "mbfsansGamma"},
  {0x1D5DB, ord,     "mbfsansH"},
  {0x1D5DC, ord,     "mbfsansI"},
  {0x1D75E, ord,     "mbfsansIota"},
  {0x1D5DD, ord,     "mbfsansJ"},
  {0x1D5DE, ord,     "mbfsansK"},
  {0x1D75F, ord,     "mbfsansKappa"},
  {0x1D5DF, ord,     "mbfsansL"},
  {0x1D760, ord,     "mbfsansLambda"},
  {0x1D5E0, ord,     "mbfsansM"},
  {0x1D761, ord,     "mbfsansMu"},
  {0x1D5E1, ord,     "mbfsansN"},
  {0x1D762, ord,     "mbfsansNu"},
  {0x1D5E2, ord,     "mbfsansO"},
  {0x1D76E, ord,     "mbfsansOmega"},
  {0x1D764, ord,     "mbfsansOmicron"},
  {0x1D5E3, ord,     "mbfsansP"},
  {0x1D76B, ord,     "mbfsansPhi"},
  {0x1D765, ord,     "mbfsansPi"},
  {0x1D76D, ord,     "mbfsansPsi"},
  {0x1D5E4, ord,     "mbfsansQ"},
  {0x1D5E5, ord,     "mbfsansR"},
  {0x1D766, ord,     "mbfsansRho"},
  {0x1D5E6, ord,     "mbfsansS"},
  {0x1D768, ord,     "mbfsansSigma"},
  {0x1D5E7, ord,     "mbfsansT"},
  {0x1D769, ord,     "mbfsansTau"},
  {0x1D75D, ord,     "mbfsansTheta"},
  {0x1D5E8, ord,     "mbfsansU"},
  {0x1D76A, ord,     "mbfsansUpsilon"},
  {0x1D5E9, ord,     "mbfsansV"},
  {0x1D5EA, ord,     "mbfsansW"},
  {0x1D5EB, ord,     "mbfsansX"},
  {0x1D763, ord,     "mbfsansXi"},
  {0x1D5EC, ord,     "mbfsansY"},
  {0x1D5ED, ord,     "mbfsansZ"},
  {0x1D75B, ord,     "mbfsansZeta"},
  {0x1D5EE, ord,     "mbfsansa"},
  {0x1D770, ord,     "mbfsansalpha"},
  {0x1D5EF, ord,     "mbfsansb"},
  {0x1D771, ord,     "mbfsansbeta"},
  {0x1D5F0, ord,     "mbfsansc"},
  {0x1D786, ord,     "mbfsanschi"},
  {0x1D5F1, ord,     "mbfsansd"},
  {0x1D773, ord,     "mbfsansdelta"},
  {0x1D5F2, ord,     "mbfsanse"},
  {0x1D7F4, ord,     "mbfsanseight"},
  {0x1D774, ord,     "mbfsansepsilon"},
  {0x1D776, ord,     "mbfsanseta"},
  {0x1D5F3, ord,     "mbfsansf"},
  {0x1D7F1, ord,     "mbfsansfive"},
  {0x1D7F0, ord,     "mbfsansfour"},
  {0x1D5F4, ord,     "mbfsansg"},
  {0x1D772, ord,     "mbfsansgamma"},
  {0x1D5F5, ord,     "mbfsansh"},
  {0x1D5F6, ord,     "mbfsansi"},
  {0x1D778, ord,     "mbfsansiota"},
  {0x1D5F7, ord,     "mbfsansj"},
  {0x1D5F8, ord,     "mbfsansk"},
  {0x1D779, ord,     "mbfsanskappa"},
  {0x1D5F9, ord,     "mbfsansl"},
  {0x1D77A, ord,     "mbfsanslambda"},
  {0x1D5FA, ord,     "mbfsansm"},
  {0x1D77B, ord,     "mbfsansmu"},
  {0x1D5FB, ord,     "mbfsansn"},
  {0x1D76F, ord,     "mbfsansnabla"},
  {0x1D7F5, ord,     "mbfsansnine"},
  {0x1D77C, ord,     "mbfsansnu"},
  {0x1D5FC, ord,     "mbfsanso"},
  {0x1D788, ord,     "mbfsansomega"},
  {0x1D77E, ord,     "mbfsansomicron"},
  {0x1D7ED, ord,     "mbfsansone"},
  {0x1D5FD, ord,     "mbfsansp"},
  {0x1D789, ord,     "mbfsanspartial"},
  {0x1D785, ord,     "mbfsansphi"},
  {0x1D77F, ord,     "mbfsanspi"},
  {0x1D787, ord,     "mbfsanspsi"},
  {0x1D5FE, ord,     "mbfsansq"},
  {0x1D5FF, ord,     "mbfsansr"},
  {0x1D780, ord,     "mbfsansrho"},
  {0x1D600, ord,     "mbfsanss"},
  {0x1D7F3, ord,     "mbfsansseven"},
  {0x1D782, ord,     "mbfsanssigma"},
  {0x1D7F2, ord,     "mbfsanssix"},
  {0x1D601, ord,     "mbfsanst"},
  {0x1D783, ord,     "mbfsanstau"},
  {0x1D777, ord,     "mbfsanstheta"},
  {0x1D7EF, ord,     "mbfsansthree"},
  {0x1D7EE, ord,     "mbfsanstwo"},
  {0x1D602, ord,     "mbfsansu"},
  {0x1D784, ord,     "mbfsansupsilon"},
  {0x1D603, ord,     "mbfsansv"},
  {0x1D767, ord,     "mbfsansvarTheta"},
  {0x1D78A, ord,     "mbfsansvarepsilon"},
  {0x1D78C, ord,     "mbfsansvarkappa"},
  {0x1D78D, ord,     "mbfsansvarphi"},
  {0x1D78F, ord,     "mbfsansvarpi"},
  {0x1D78E, ord,     "mbfsansvarrho"},
  {0x1D781, ord,     "mbfsansvarsigma"},
  {0x1D78B, ord,     "mbfsansvartheta"},
  {0x1D604, ord,     "mbfsansw"},
  {0x1D605, ord,     "mbfsansx"},
  {0x1D77D, ord,     "mbfsansxi"},
  {0x1D606, ord,     "mbfsansy"},
  {0x1D607, ord,     "mbfsansz"},
  {0x1D7EC, ord,     "mbfsanszero"},
  {0x1D775, ord,     "mbfsanszeta"},
  {0x1D4D0, ord,     "mbfscrA"},
  {0x1D4D1, ord,     "mbfscrB"},
  {0x1D4D2, ord,     "mbfscrC"},
  {0x1D4D3, ord,     "mbfscrD"},
  {0x1D4D4, ord,     "mbfscrE"},
  {0x1D4D5, ord,     "mbfscrF"},
  {0x1D4D6, ord,     "mbfscrG"},
  {0x1D4D7, ord,     "mbfscrH"},
  {0x1D4D8, ord,     "mbfscrI"},
  {0x1D4D9, ord,     "mbfscrJ"},
  {0x1D4DA, ord,     "mbfscrK"},
  {0x1D4DB, ord,     "mbfscrL"},
  {0x1D4DC, ord,     "mbfscrM"},
  {0x1D4DD, ord,     "mbfscrN"},
  {0x1D4DE, ord,     "mbfscrO"},
  {0x1D4DF, ord,     "mbfscrP"},
  {0x1D4E0, ord,     "mbfscrQ"},
  {0x1D4E1, ord,     "mbfscrR"},
  {0x1D4E2, ord,     "mbfscrS"},
  {0x1D4E3, ord,     "mbfscrT"},
  {0x1D4E4, ord,     "mbfscrU"},
  {0x1D4E5, ord,     "mbfscrV"},
  {0x1D4E6, ord,     "mbfscrW"},
  {0x1D4E7, ord,     "mbfscrX"},
  {0x1D4E8, ord,     "mbfscrY"},
  {0x1D4E9, ord,     "mbfscrZ"},
  {0x1D4EA, ord,     "mbfscra"},
  {0x1D4EB, ord,     "mbfscrb"},
  {0x1D4EC, ord,     "mbfscrc"},
  {0x1D4ED, ord,     "mbfscrd"},
  {0x1D4EE, ord,     "mbfscre"},
  {0x1D4EF, ord,     "mbfscrf"},
  {0x1D4F0, ord,     "mbfscrg"},
  {0x1D4F1, ord,     "mbfscrh"},
  {0x1D4F2, ord,     "mbfscri"},
  {0x1D4F3, ord,     "mbfscrj"},
  {0x1D4F4, ord,     "mbfscrk"},
  {0x1D4F5, ord,     "mbfscrl"},
  {0x1D4F6, ord,     "mbfscrm"},
  {0x1D4F7, ord,     "mbfscrn"},
  {0x1D4F8, ord,     "mbfscro"},
  {0x1D4F9, ord,     "mbfscrp"},
  {0x1D4FA, ord,     "mbfscrq"},
  {0x1D4FB, ord,     "mbfscrr"},
  {0x1D4FC, ord,     "mbfscrs"},
  {0x1D4FD, ord,     "mbfscrt"},
  {0x1D4FE, ord,     "mbfscru"},
  {0x1D4FF, ord,     "mbfscrv"},
  {0x1D500, ord,     "mbfscrw"},
  {0x1D501, ord,     "mbfscrx"},
  {0x1D502, ord,     "mbfscry"},
  {0x1D503, ord,     "mbfscrz"},
  {0x1D6D4, ord,     "mbfsigma"},
  {0x1D42D, ord,     "mbft"},
  {0x1D6D5, ord,     "mbftau"},
  {0x1D6C9, ord,     "mbftheta"},
  {0x1D42E, ord,     "mbfu"},
  {0x1D6D6, ord,     "mbfupsilon"},
  {0x1D42F, ord,     "mbfv"},
  {0x1D6B9, ord,     "mbfvarTheta"},
  {0x1D6DC, ord,     "mbfvarepsilon"},
  {0x1D6DE, ord,     "mbfvarkappa"},
  {0x1D6D7, ord,     "mbfvarphi"},
  {0x1D6E1, ord,     "mbfvarpi"},
  {0x1D6E0, ord,     "mbfvarrho"},
  {0x1D6D3, ord,     "mbfvarsigma"},
  {0x1D6DD, ord,     "mbfvartheta"},
  {0x1D430, ord,     "mbfw"},
  {0x1D431, ord,     "mbfx"},
  {0x1D6CF, ord,     "mbfxi"},
  {0x1D432, ord,     "mbfy"},
  {0x1D433, ord,     "mbfz"},
  {0x1D6C7, ord,     "mbfzeta"},
  {0x026AB, ord,     "mdblkcircle"},
  {0x02B25, ord,     "mdblkdiamond"},
  {0x02B27, ord,     "mdblklozenge"},
  {0x025FC, ord,     "mdblksquare"},
  {0x025CF, ord,     "mdlgblkcircle"},
  {0x025C6, ord,     "mdlgblkdiamond"},
  {0x029EB, bin,     "mdlgblklozenge"},
  {0x025A0, ord,     "mdlgblksquare"},
  {0x025CB, bin,     "mdlgwhtcircle"},
  {0x025C7, ord,     "mdlgwhtdiamond"},
  {0x025CA, ord,     "mdlgwhtlozenge"},
  {0x025A1, ord,     "mdlgwhtsquare"},
  {0x02981, ord,     "mdsmblkcircle"},
  {0x025FE, ord,     "mdsmblksquare"},
  {0x026AC, ord,     "mdsmwhtcircle"},
  {0x025FD, ord,     "mdsmwhtsquare"},
  {0x026AA, ord,     "mdwhtcircle"},
  {0x02B26, ord,     "mdwhtdiamond"},
  {0x02B28, ord,     "mdwhtlozenge"},
  {0x025FB, ord,     "mdwhtsquare"},
  {0x029AF, ord,     "measangledltosw"},
  {0x029AE, ord,     "measangledrtose"},
  {0x029AB, ord,     "measangleldtosw"},
  {0x029A9, ord,     "measanglelutonw"},
  {0x029AA, ord,     "measanglerdtose"},
  {0x029A8, ord,     "measanglerutone"},
  {0x029AD, ord,     "measangleultonw"},
  {0x029AC, ord,     "measangleurtone"},
  {0x0225E, rel,     "measeq"},
  {0x02221, ord,     "measuredangle"},
  {0x0299B, ord,     "measuredangleleft"},
  {0x022BE, ord,     "measuredrightangle"},
  {0x02B51, ord,     "medblackstar"},
  {0x026AB, ord,     "medbullet"},
  {0x026AA, ord,     "medcirc"},
  {0x0205F, ord,     "medspace"},
  {0x02B50, ord,     "medwhitestar"},
  {0x0263F, ord,     "mercury"},
  {0x1D504, ord,     "mfrakA"},
  {0x1D505, ord,     "mfrakB"},
  {0x0212D, ord,     "mfrakC"},
  {0x1D507, ord,     "mfrakD"},
  {0x1D508, ord,     "mfrakE"},
  {0x1D509, ord,     "mfrakF"},
  {0x1D50A, ord,     "mfrakG"},
  {0x0210C, ord,     "mfrakH"},
  {0x1D50D, ord,     "mfrakJ"},
  {0x1D50E, ord,     "mfrakK"},
  {0x1D50F, ord,     "mfrakL"},
  {0x1D510, ord,     "mfrakM"},
  {0x1D511, ord,     "mfrakN"},
  {0x1D512, ord,     "mfrakO"},
  {0x1D513, ord,     "mfrakP"},
  {0x1D514, ord,     "mfrakQ"},
  {0x1D516, ord,     "mfrakS"},
  {0x1D517, ord,     "mfrakT"},
  {0x1D518, ord,     "mfrakU"},
  {0x1D519, ord,     "mfrakV"},
  {0x1D51A, ord,     "mfrakW"},
  {0x1D51B, ord,     "mfrakX"},
  {0x1D51C, ord,     "mfrakY"},
  {0x02128, ord,     "mfrakZ"},
  {0x1D51E, ord,     "mfraka"},
  {0x1D51F, ord,     "mfrakb"},
  {0x1D520, ord,     "mfrakc"},
  {0x1D521, ord,     "mfrakd"},
  {0x1D522, ord,     "mfrake"},
  {0x1D523, ord,     "mfrakf"},
  {0x1D524, ord,     "mfrakg"},
  {0x1D525, ord,     "mfrakh"},
  {0x1D526, ord,     "mfraki"},
  {0x1D527, ord,     "mfrakj"},
  {0x1D528, ord,     "mfrakk"},
  {0x1D529, ord,     "mfrakl"},
  {0x1D52A, ord,     "mfrakm"},
  {0x1D52B, ord,     "mfrakn"},
  {0x1D52C, ord,     "mfrako"},
  {0x1D52D, ord,     "mfrakp"},
  {0x1D52E, ord,     "mfrakq"},
  {0x1D52F, ord,     "mfrakr"},
  {0x1D530, ord,     "mfraks"},
  {0x1D531, ord,     "mfrakt"},
  {0x1D532, ord,     "mfraku"},
  {0x1D533, ord,     "mfrakv"},
  {0x1D534, ord,     "mfrakw"},
  {0x1D535, ord,     "mfrakx"},
  {0x1D536, ord,     "mfraky"},
  {0x1D537, ord,     "mfrakz"},
  {0x02127, ord,     "mho"},
  {0x02223, rel,     "mid"},
  {0x02A5D, bin,     "midbarvee"},
  {0x02A5C, bin,     "midbarwedge"},
  {0x02AF0, rel,     "midcir"},
  {0x02212, bin,     "minus"},
  {0x02A2A, bin,     "minusdot"},
  {0x02A2B, bin,     "minusfdots"},
  {0x02A2C, bin,     "minusrdots"},
  {0x1D434, ord,     "mitA"},
  {0x1D6E2, ord,     "mitAlpha"},
  {0x1D435, ord,     "mitB"},
  {0x02145, ord,     "mitBbbD"},
  {0x02146, ord,     "mitBbbd"},
  {0x02147, ord,     "mitBbbe"},
  {0x02148, ord,     "mitBbbi"},
  {0x02149, ord,     "mitBbbj"},
  {0x1D6E3, ord,     "mitBeta"},
  {0x1D436, ord,     "mitC"},
  {0x1D6F8, ord,     "mitChi"},
  {0x1D437, ord,     "mitD"},
  {0x1D6E5, ord,     "mitDelta"},
  {0x1D438, ord,     "mitE"},
  {0x1D6E6, ord,     "mitEpsilon"},
  {0x1D6E8, ord,     "mitEta"},
  {0x1D439, ord,     "mitF"},
  {0x1D43A, ord,     "mitG"},
  {0x1D6E4, ord,     "mitGamma"},
  {0x1D43B, ord,     "mitH"},
  {0x1D43C, ord,     "mitI"},
  {0x1D6EA, ord,     "mitIota"},
  {0x1D43D, ord,     "mitJ"},
  {0x1D43E, ord,     "mitK"},
  {0x1D6EB, ord,     "mitKappa"},
  {0x1D43F, ord,     "mitL"},
  {0x1D6EC, ord,     "mitLambda"},
  {0x1D440, ord,     "mitM"},
  {0x1D6ED, ord,     "mitMu"},
  {0x1D441, ord,     "mitN"},
  {0x1D6EE, ord,     "mitNu"},
  {0x1D442, ord,     "mitO"},
  {0x1D6FA, ord,     "mitOmega"},
  {0x1D6F0, ord,     "mitOmicron"},
  {0x1D443, ord,     "mitP"},
  {0x1D6F7, ord,     "mitPhi"},
  {0x1D6F1, ord,     "mitPi"},
  {0x1D6F9, ord,     "mitPsi"},
  {0x1D444, ord,     "mitQ"},
  {0x1D445, ord,     "mitR"},
  {0x1D6F2, ord,     "mitRho"},
  {0x1D446, ord,     "mitS"},
  {0x1D6F4, ord,     "mitSigma"},
  {0x1D447, ord,     "mitT"},
  {0x1D6F5, ord,     "mitTau"},
  {0x1D6E9, ord,     "mitTheta"},
  {0x1D448, ord,     "mitU"},
  {0x1D6F6, ord,     "mitUpsilon"},
  {0x1D449, ord,     "mitV"},
  {0x1D44A, ord,     "mitW"},
  {0x1D44B, ord,     "mitX"},
  {0x1D6EF, ord,     "mitXi"},
  {0x1D44C, ord,     "mitY"},
  {0x1D44D, ord,     "mitZ"},
  {0x1D6E7, ord,     "mitZeta"},
  {0x1D44E, ord,     "mita"},
  {0x1D6FC, ord,     "mitalpha"},
  {0x1D44F, ord,     "mitb"},
  {0x1D6FD, ord,     "mitbeta"},
  {0x1D450, ord,     "mitc"},
  {0x1D712, ord,     "mitchi"},
  {0x1D451, ord,     "mitd"},
  {0x1D6FF, ord,     "mitdelta"},
  {0x1D452, ord,     "mite"},
  {0x1D700, ord,     "mitepsilon"},
  {0x1D702, ord,     "miteta"},
  {0x1D453, ord,     "mitf"},
  {0x1D454, ord,     "mitg"},
  {0x1D6FE, ord,     "mitgamma"},
  {0x1D456, ord,     "miti"},
  {0x1D704, ord,     "mitiota"},
  {0x1D457, ord,     "mitj"},
  {0x1D458, ord,     "mitk"},
  {0x1D705, ord,     "mitkappa"},
  {0x1D459, ord,     "mitl"},
  {0x1D706, ord,     "mitlambda"},
  {0x1D45A, ord,     "mitm"},
  {0x1D707, ord,     "mitmu"},
  {0x1D45B, ord,     "mitn"},
  {0x1D6FB, ord,     "mitnabla"},
  {0x1D708, ord,     "mitnu"},
  {0x1D45C, ord,     "mito"},
  {0x1D714, ord,     "mitomega"},
  {0x1D70A, ord,     "mitomicron"},
  {0x1D45D, ord,     "mitp"},
  {0x1D715, ord,     "mitpartial"},
  {0x1D711, ord,     "mitphi"},
  {0x1D70B, ord,     "mitpi"},
  {0x1D713, ord,     "mitpsi"},
  {0x1D45E, ord,     "mitq"},
  {0x1D45F, ord,     "mitr"},
  {0x1D70C, ord,     "mitrho"},
  {0x1D460, ord,     "mits"},
  {0x1D608, ord,     "mitsansA"},
  {0x1D609, ord,     "mitsansB"},
  {0x1D60A, ord,     "mitsansC"},
  {0x1D60B, ord,     "mitsansD"},
  {0x1D60C, ord,     "mitsansE"},
  {0x1D60D, ord,     "mitsansF"},
  {0x1D60E, ord,     "mitsansG"},
  {0x1D60F, ord,     "mitsansH"},
  {0x1D610, ord,     "mitsansI"},
  {0x1D611, ord,     "mitsansJ"},
  {0x1D612, ord,     "mitsansK"},
  {0x1D613, ord,     "mitsansL"},
  {0x1D614, ord,     "mitsansM"},
  {0x1D615, ord,     "mitsansN"},
  {0x1D616, ord,     "mitsansO"},
  {0x1D617, ord,     "mitsansP"},
  {0x1D618, ord,     "mitsansQ"},
  {0x1D619, ord,     "mitsansR"},
  {0x1D61A, ord,     "mitsansS"},
  {0x1D61B, ord,     "mitsansT"},
  {0x1D61C, ord,     "mitsansU"},
  {0x1D61D, ord,     "mitsansV"},
  {0x1D61E, ord,     "mitsansW"},
  {0x1D61F, ord,     "mitsansX"},
  {0x1D620, ord,     "mitsansY"},
  {0x1D621, ord,     "mitsansZ"},
  {0x1D622, ord,     "mitsansa"},
  {0x1D623, ord,     "mitsansb"},
  {0x1D624, ord,     "mitsansc"},
  {0x1D625, ord,     "mitsansd"},
  {0x1D626, ord,     "mitsanse"},
  {0x1D627, ord,     "mitsansf"},
  {0x1D628, ord,     "mitsansg"},
  {0x1D629, ord,     "mitsansh"},
  {0x1D62A, ord,     "mitsansi"},
  {0x1D62B, ord,     "mitsansj"},
  {0x1D62C, ord,     "mitsansk"},
  {0x1D62D, ord,     "mitsansl"},
  {0x1D62E, ord,     "mitsansm"},
  {0x1D62F, ord,     "mitsansn"},
  {0x1D630, ord,     "mitsanso"},
  {0x1D631, ord,     "mitsansp"},
  {0x1D632, ord,     "mitsansq"},
  {0x1D633, ord,     "mitsansr"},
  {0x1D634, ord,     "mitsanss"},
  {0x1D635, ord,     "mitsanst"},
  {0x1D636, ord,     "mitsansu"},
  {0x1D637, ord,     "mitsansv"},
  {0x1D638, ord,     "mitsansw"},
  {0x1D639, ord,     "mitsansx"},
  {0x1D63A, ord,     "mitsansy"},
  {0x1D63B, ord,     "mitsansz"},
  {0x1D70E, ord,     "mitsigma"},
  {0x1D461, ord,     "mitt"},
  {0x1D70F, ord,     "mittau"},
  {0x1D703, ord,     "mittheta"},
  {0x1D462, ord,     "mitu"},
  {0x1D710, ord,     "mitupsilon"},
  {0x1D463, ord,     "mitv"},
  {0x1D6F3, ord,     "mitvarTheta"},
  {0x1D716, ord,     "mitvarepsilon"},
  {0x1D718, ord,     "mitvarkappa"},
  {0x1D719, ord,     "mitvarphi"},
  {0x1D71B, ord,     "mitvarpi"},
  {0x1D71A, ord,     "mitvarrho"},
  {0x1D70D, ord,     "mitvarsigma"},
  {0x1D717, ord,     "mitvartheta"},
  {0x1D464, ord,     "mitw"},
  {0x1D465, ord,     "mitx"},
  {0x1D709, ord,     "mitxi"},
  {0x1D466, ord,     "mity"},
  {0x1D467, ord,     "mitz"},
  {0x1D701, ord,     "mitzeta"},
  {0x02ADB, rel,     "mlcp"},
  {0x022A7, rel,     "models"},
  {0x02A0A, ord,     "modtwosum"},
  {0x02213, bin,     "mp"},
  {0x1D5A0, ord,     "msansA"},
  {0x1D5A1, ord,     "msansB"},
  {0x1D5A2, ord,     "msansC"},
  {0x1D5A3, ord,     "msansD"},
  {0x1D5A4, ord,     "msansE"},
  {0x1D5A5, ord,     "msansF"},
  {0x1D5A6, ord,     "msansG"},
  {0x1D5A7, ord,     "msansH"},
  {0x1D5A8, ord,     "msansI"},
  {0x1D5A9, ord,     "msansJ"},
  {0x1D5AA, ord,     "msansK"},
  {0x1D5AB, ord,     "msansL"},
  {0x1D5AC, ord,     "msansM"},
  {0x1D5AD, ord,     "msansN"},
  {0x1D5AE, ord,     "msansO"},
  {0x1D5AF, ord,     "msansP"},
  {0x1D5B0, ord,     "msansQ"},
  {0x1D5B1, ord,     "msansR"},
  {0x1D5B2, ord,     "msansS"},
  {0x1D5B3, ord,     "msansT"},
  {0x1D5B4, ord,     "msansU"},
  {0x1D5B5, ord,     "msansV"},
  {0x1D5B6, ord,     "msansW"},
  {0x1D5B7, ord,     "msansX"},
  {0x1D5B8, ord,     "msansY"},
  {0x1D5B9, ord,     "msansZ"},
  {0x1D5BA, ord,     "msansa"},
  {0x1D5BB, ord,     "msansb"},
  {0x1D5BC, ord,     "msansc"},
  {0x1D5BD, ord,     "msansd"},
  {0x1D5BE, ord,     "msanse"},
  {0x1D7EA, ord,     "msanseight"},
  {0x1D5BF, ord,     "msansf"},
  {0x1D7E7, ord,     "msansfive"},
  {0x1D7E6, ord,     "msansfour"},
  {0x1D5C0, ord,     "msansg"},
  {0x1D5C1, ord,     "msansh"},
  {0x1D5C2, ord,     "msansi"},
  {0x1D5C3, ord,     "msansj"},
  {0x1D5C4, ord,     "msansk"},
  {0x1D5C5, ord,     "msansl"},
  {0x1D5C6, ord,     "msansm"},
  {0x1D5C7, ord,     "msansn"},
  {0x1D7EB, ord,     "msansnine"},
  {0x1D5C8, ord,     "msanso"},
  {0x1D7E3, ord,     "msansone"},
  {0x1D5C9, ord,     "msansp"},
  {0x1D5CA, ord,     "msansq"},
  {0x1D5CB, ord,     "msansr"},
  {0x1D5CC, ord,     "msanss"},
  {0x1D7E9, ord,     "msansseven"},
  {0x1D7E8, ord,     "msanssix"},
  {0x1D5CD, ord,     "msanst"},
  {0x1D7E5, ord,     "msansthree"},
  {0x1D7E4, ord,     "msanstwo"},
  {0x1D5CE, ord,     "msansu"},
  {0x1D5CF, ord,     "msansv"},
  {0x1D5D0, ord,     "msansw"},
  {0x1D5D1, ord,     "msansx"},
  {0x1D5D2, ord,     "msansy"},
  {0x1D5D3, ord,     "msansz"},
  {0x1D7E2, ord,     "msanszero"},
  {0x1D49C, ord,     "mscrA"},
  {0x0212C, ord,     "mscrB"},
  {0x1D49E, ord,     "mscrC"},
  {0x1D49F, ord,     "mscrD"},
  {0x02130, ord,     "mscrE"},
  {0x02131, ord,     "mscrF"},
  {0x1D4A2, ord,     "mscrG"},
  {0x0210B, ord,     "mscrH"},
  {0x02110, ord,     "mscrI"},
  {0x1D4A5, ord,     "mscrJ"},
  {0x1D4A6, ord,     "mscrK"},
  {0x02112, ord,     "mscrL"},
  {0x02133, ord,     "mscrM"},
  {0x1D4A9, ord,     "mscrN"},
  {0x1D4AA, ord,     "mscrO"},
  {0x1D4AB, ord,     "mscrP"},
  {0x1D4AC, ord,     "mscrQ"},
  {0x0211B, ord,     "mscrR"},
  {0x1D4AE, ord,     "mscrS"},
  {0x1D4AF, ord,     "mscrT"},
  {0x1D4B0, ord,     "mscrU"},
  {0x1D4B1, ord,     "mscrV"},
  {0x1D4B2, ord,     "mscrW"},
  {0x1D4B3, ord,     "mscrX"},
  {0x1D4B4, ord,     "mscrY"},
  {0x1D4B5, ord,     "mscrZ"},
  {0x1D4B6, ord,     "mscra"},
  {0x1D4B7, ord,     "mscrb"},
  {0x1D4B8, ord,     "mscrc"},
  {0x1D4B9, ord,     "mscrd"},
  {0x0212F, ord,     "mscre"},
  {0x1D4BB, ord,     "mscrf"},
  {0x0210A, ord,     "mscrg"},
  {0x1D4BD, ord,     "mscrh"},
  {0x1D4BE, ord,     "mscri"},
  {0x1D4BF, ord,     "mscrj"},
  {0x1D4C0, ord,     "mscrk"},
  {0x1D4C1, ord,     "mscrl"},
  {0x1D4C2, ord,     "mscrm"},
  {0x1D4C3, ord,     "mscrn"},
  {0x02134, ord,     "mscro"},
  {0x1D4C5, ord,     "mscrp"},
  {0x1D4C6, ord,     "mscrq"},
  {0x1D4C7, ord,     "mscrr"},
  {0x1D4C8, ord,     "mscrs"},
  {0x1D4C9, ord,     "mscrt"},
  {0x1D4CA, ord,     "mscru"},
  {0x1D4CB, ord,     "mscrv"},
  {0x1D4CC, ord,     "mscrw"},
  {0x1D4CD, ord,     "mscrx"},
  {0x1D4CE, ord,     "mscry"},
  {0x1D4CF, ord,     "mscrz"},
  {0x1D670, ord,     "mttA"},
  {0x1D671, ord,     "mttB"},
  {0x1D672, ord,     "mttC"},
  {0x1D673, ord,     "mttD"},
  {0x1D674, ord,     "mttE"},
  {0x1D675, ord,     "mttF"},
  {0x1D676, ord,     "mttG"},
  {0x1D677, ord,     "mttH"},
  {0x1D678, ord,     "mttI"},
  {0x1D679, ord,     "mttJ"},
  {0x1D67A, ord,     "mttK"},
  {0x1D67B, ord,     "mttL"},
  {0x1D67C, ord,     "mttM"},
  {0x1D67D, ord,     "mttN"},
  {0x1D67E, ord,     "mttO"},
  {0x1D67F, ord,     "mttP"},
  {0x1D680, ord,     "mttQ"},
  {0x1D681, ord,     "mttR"},
  {0x1D682, ord,     "mttS"},
  {0x1D683, ord,     "mttT"},
  {0x1D684, ord,     "mttU"},
  {0x1D685, ord,     "mttV"},
  {0x1D686, ord,     "mttW"},
  {0x1D687, ord,     "mttX"},
  {0x1D688, ord,     "mttY"},
  {0x1D689, ord,     "mttZ"},
  {0x1D68A, ord,     "mtta"},
  {0x1D68B, ord,     "mttb"},
  {0x1D68C, ord,     "mttc"},
  {0x1D68D, ord,     "mttd"},
  {0x1D68E, ord,     "mtte"},
  {0x1D7FE, ord,     "mtteight"},
  {0x1D68F, ord,     "mttf"},
  {0x1D7FB, ord,     "mttfive"},
  {0x1D7FA, ord,     "mttfour"},
  {0x1D690, ord,     "mttg"},
  {0x1D691, ord,     "mtth"},
  {0x1D692, ord,     "mtti"},
  {0x1D693, ord,     "mttj"},
  {0x1D694, ord,     "mttk"},
  {0x1D695, ord,     "mttl"},
  {0x1D696, ord,     "mttm"},
  {0x1D697, ord,     "mttn"},
  {0x1D7FF, ord,     "mttnine"},
  {0x1D698, ord,     "mtto"},
  {0x1D7F7, ord,     "mttone"},
  {0x1D699, ord,     "mttp"},
  {0x1D69A, ord,     "mttq"},
  {0x1D69B, ord,     "mttr"},
  {0x1D69C, ord,     "mtts"},
  {0x1D7FD, ord,     "mttseven"},
  {0x1D7FC, ord,     "mttsix"},
  {0x1D69D, ord,     "mttt"},
  {0x1D7F9, ord,     "mttthree"},
  {0x1D7F8, ord,     "mtttwo"},
  {0x1D69E, ord,     "mttu"},
  {0x1D69F, ord,     "mttv"},
  {0x1D6A0, ord,     "mttw"},
  {0x1D6A1, ord,     "mttx"},
  {0x1D6A2, ord,     "mtty"},
  {0x1D6A3, ord,     "mttz"},
  {0x1D7F6, ord,     "mttzero"},
  {0x003BC, ord,     "mu"},
  {0x022B8, rel,     "multimap"},
  {0x029DF, rel,     "multimapboth"},
  {0x022B6, rel,     "multimapdotbothA"},
  {0x022B7, rel,     "multimapdotbothB"},
  {0x027DC, rel,     "multimapinv"},
  {0x003BC, ord,     "muup"},
  {0x021DF, ord,     "nHdownarrow"},
  {0x021DE, ord,     "nHuparrow"},
  {0x021CD, rel,     "nLeftarrow"},
  {0x021CE, rel,     "nLeftrightarrow"},
  {0x021CF, rel,     "nRightarrow"},
  {0x022AF, rel,     "nVDash"},
  {0x022AE, rel,     "nVdash"},
  {0x021FA, rel,     "nVleftarrow"},
  {0x02B3A, rel,     "nVleftarrowtail"},
  {0x021FC, rel,     "nVleftrightarrow"},
  {0x021FB, rel,     "nVrightarrow"},
  {0x02915, rel,     "nVrightarrowtail"},
  {0x02B35, rel,     "nVtwoheadleftarrow"},
  {0x02B3D, rel,     "nVtwoheadleftarrowtail"},
  {0x02901, rel,     "nVtwoheadrightarrow"},
  {0x02918, rel,     "nVtwoheadrightarrowtail"},
  {0x02207, ord,     "nabla"},
  {0x02249, rel,     "napprox"},
  {0x0226D, rel,     "nasymp"},
  {0x0266E, ord,     "natural"},
  {0x02247, rel,     "ncong"},
  {0x02A64, bin,     "ndres"},
  {0x02260, rel,     "ne"},
  {0x02197, rel,     "nearrow"},
  {0x000AC, ord,     "neg"},
  {0x02931, ord,     "neovnwarrow"},
  {0x0292E, ord,     "neovsearrow"},
  {0x02646, ord,     "neptune"},
  {0x02260, rel,     "neq"},
  {0x02262, rel,     "nequiv"},
  {0x02922, rel,     "neswarrow"},
  {0x026B2, ord,     "neuter"},
  {0x02204, ord,     "nexi"},
  {0x02204, ord,     "nexists"},
  {0x02271, rel,     "ngeq"},
  {0x02271, rel,     "ngeqslant"},
  {0x0226F, rel,     "ngtr"},
  {0x02279, rel,     "ngtrless"},
  {0x02275, rel,     "ngtrsim"},
  {0x02AF5, bin,     "nhVvert"},
  {0x02AF2, rel,     "nhpar"},
  {0x0220B, rel,     "ni"},
  {0x02209, rel,     "nin"},
  {0x022FE, rel,     "niobar"},
  {0x022FC, rel,     "nis"},
  {0x022FA, rel,     "nisd"},
  {0x0219A, rel,     "nleftarrow"},
  {0x021AE, rel,     "nleftrightarrow"},
  {0x02270, rel,     "nleq"},
  {0x02270, rel,     "nleqslant"},
  {0x0226E, rel,     "nless"},
  {0x02278, rel,     "nlessgtr"},
  {0x02274, rel,     "nlesssim"},
  {0x02224, rel,     "nmid"},
  {0x0220C, rel,     "nni"},
  {0x00338, acc,     "not"},
  {0x0226D, rel,     "notasymp"},
  {0x02340, ord,     "notbackslash"},
  {0x02209, rel,     "notin"},
  {0x0220C, rel,     "notni"},
  {0x0220C, rel,     "notowner"},
  {0x0220C, rel,     "notowns"},
  {0x0233F, rel,     "notslash"},
  {0x02226, rel,     "nparallel"},
  {0x02A14, opt | N, "npolint"},
  {0x02280, rel,     "nprec"},
  {0x022E0, rel,     "npreccurlyeq"},
  {0x022E0, rel,     "npreceq"},
  {0x0219B, rel,     "nrightarrow"},
  {0x02A65, bin,     "nrres"},
  {0x02241, rel,     "nsim"},
  {0x02244, rel,     "nsime"},
  {0x02244, rel,     "nsimeq"},
  {0x022E2, rel,     "nsqsubseteq"},
  {0x022E3, rel,     "nsqsupseteq"},
  {0x02284, rel,     "nsubset"},
  {0x02288, rel,     "nsubseteq"},
  {0x02281, rel,     "nsucc"},
  {0x022E1, rel,     "nsucccurlyeq"},
  {0x022E1, rel,     "nsucceq"},
  {0x02285, rel,     "nsupset"},
  {0x02289, rel,     "nsupseteq"},
  {0x022EA, rel,     "ntriangleleft"},
  {0x022EC, rel,     "ntrianglelefteq"},
  {0x022EB, rel,     "ntriangleright"},
  {0x022ED, rel,     "ntrianglerighteq"},
  {0x003BD, ord,     "nu"},
  {0x022EC, rel,     "nunlhd"},
  {0x022ED, rel,     "nunrhd"},
  {0x003BD, ord,     "nuup"},
  {0x022AD, rel,     "nvDash"},
  {0x02902, rel,     "nvLeftarrow"},
  {0x02904, rel,     "nvLeftrightarrow"},
  {0x02903, rel,     "nvRightarrow"},
  {0x022AC, rel,     "nvdash"},
  {0x029DE, ord,     "nvinfty"},
  {0x021F7, rel,     "nvleftarrow"},
  {0x02B39, rel,     "nvleftarrowtail"},
  {0x021F9, rel,     "nvleftrightarrow"},
  {0x021F8, rel,     "nvrightarrow"},
  {0x02914, rel,     "nvrightarrowtail"},
  {0x02B34, rel,     "nvtwoheadleftarrow"},
  {0x02B3C, rel,     "nvtwoheadleftarrowtail"},
  {0x02900, rel,     "nvtwoheadrightarrow"},
  {0x02917, rel,     "nvtwoheadrightarrowtail"},
  {0x02196, rel,     "nwarrow"},
  {0x02932, ord,     "nwovnearrow"},
  {0x02921, rel,     "nwsearrow"},
  {0x0233D, bin,     "obar"},
  {0x029BA, ord,     "obot"},
  {0x023E0, ord,     "obrbrak"},
  {0x029B8, bin,     "obslash"},
  {0x0030A, acc,     "ocirc"},
  {0x00315, acc,     "ocommatopright"},
  {0x00023, ord,     "octothorpe"},
  {0x02A38, bin,     "odiv"},
  {0x02299, bin,     "odot"},
  {0x029BC, ord,     "odotslashdot"},
  {0x029C1, bin,     "ogreaterthan"},
  {0x02230, opt | N, "oiiint"},
  {0x0222F, opt | N, "oiint"},
  {0x0222E, opt | N, "oint"},
  {0x02233, opt | N, "ointctrclockwise"},
  {0x029BB, ord,     "olcross"},
  {0x029C0, bin,     "olessthan"},
  {0x003C9, ord,     "omega"},
  {0x003C9, ord,     "omegaup"},
  {0x02296, bin,     "ominus"},
  {0x029B9, bin,     "operp"},
  {0x02295, bin,     "oplus"},
  {0x02A2D, bin,     "opluslhrim"},
  {0x02A2E, bin,     "oplusrhrim"},
  {0x022B6, rel,     "origof"},
  {0x02298, bin,     "oslash"},
  {0x02297, bin,     "otimes"},
  {0x02A36, bin,     "otimeshat"},
  {0x02A34, bin,     "otimeslhrim"},
  {0x02A35, bin,     "otimesrhrim"},
  {0x00312, acc,     "oturnedcomma"},
  {0x00305, acc,     "overbar"},
  {0x023DE, ord,     "overbrace"},
  {0x023B4, ord,     "overbracket"},
  {0x020D6, acc,     "overleftarrow"},
  {0x020E1, acc,     "overleftrightarrow"},
  {0x00305, acc,     "overline"},
  {0x023DC, ord,     "overparen"},
  {0x020D7, acc,     "overrightarrow"},
  {0x00309, acc,     "ovhook"},
  {0x0220B, rel,     "owns"},
  {0x02225, rel,     "parallel"},
  {0x025B1, ord,     "parallelogram"},
  {0x025B0, ord,     "parallelogramblack"},
  {0x02AF3, rel,     "parsim"},
  {0x02202, ord,     "partial"},
  {0x02AA3, rel,     "partialmeetcontraction"},
  {0x02202, ord,     "partialup"},
  {0x0270E, ord,     "pencil"},
  {0x02B20, ord,     "pentagon"},
  {0x02B1F, ord,     "pentagonblack"},
  {0x00025, ord,     "percent"},
  {0x0002E, ord,     "period"},
  {0x027C2, rel,     "perp"},
  {0x02AE1, ord,     "perps"},
  {0x021F8, rel,     "pfun"},
  {0x003D5, ord,     "phi"},
  {0x003D5, ord,     "phiup"},
  {0x003C0, ord,     "pi"},
  {0x02914, rel,     "pinj"},
  {0x02653, ord,     "pisces"},
  {0x022D4, rel,     "pitchfork"},
  {0x003C0, ord,     "piup"},
  {0x0002B, bin,     "plus"},
  {0x02A25, bin,     "plusdot"},
  {0x02A72, bin,     "pluseqq"},
  {0x02A23, bin,     "plushat"},
  {0x02A26, bin,     "plussim"},
  {0x02A27, bin,     "plussubtwo"},
  {0x02A28, bin,     "plustrif"},
  {0x02647, ord,     "pluto"},
  {0x000B1, bin,     "pm"},
  {0x02A15, opt | N, "pointint"},
  {0x0261E, ord,     "pointright"},
  {0x03012, ord,     "postalmark"},
  {0x000A3, ord,     "pounds"},
  {0x0227A, rel,     "prec"},
  {0x02AB7, rel,     "precapprox"},
  {0x0227C, rel,     "preccurlyeq"},
  {0x02AAF, rel,     "preceq"},
  {0x02AB3, rel,     "preceqq"},
  {0x02AB9, rel,     "precnapprox"},
  {0x02AB1, rel,     "precneq"},
  {0x02AB5, rel,     "precneqq"},
  {0x022E8, rel,     "precnsim"},
  {0x0227E, rel,     "precsim"},
  {0x02032, ord,     "prime"},
  {0x0220F, opt,     "prod"},
  {0x02312, ord,     "profline"},
  {0x02313, ord,     "profsurf"},
  {0x02A21, opt,     "project"},
  {0x0221D, rel,     "propto"},
  {0x022B0, rel,     "prurel"},
  {0x003C8, ord,     "psi"},
  {0x003C8, ord,     "psiup"},
  {0x02900, rel,     "psur"},
  {0x02900, rel,     "psurj"},
  {0x027D3, rel,     "pullback"},
  {0x027D4, rel,     "pushout"},
  {0x003D9, ord,     "qoppa"},
  {0x02057, ord,     "qprime"},
  {0x02001, ord,     "quad"},
  {0x02669, ord,     "quarternote"},
  {0x0225F, rel,     "questeq"},
  {0x0003F, ord,     "question"},
  {0x027EB, cls,     "rAngle"},
  {0x02984, cls,     "rBrace"},
  {0x027E7, cls,     "rBrack"},
  {0x02986, cls,     "rParen"},
  {0x02622, ord,     "radiation"},
  {0x027EB, cls,     "rang"},
  {0x027E9, cls,     "rangle"},
  {0x02992, cls,     "rangledot"},
  {0x0237C, ord,     "rangledownzigzagarrow"},
  {0x027C6, cls,     "rbag"},
  {0x02998, cls,     "rblkbrbrak"},
  {0x0298A, cls,     "rblot"},
  {0x0007D, cls,     "rbrace"},
  {0x023AD, ord,     "rbracelend"},
  {0x023AC, ord,     "rbracemid"},
  {0x023AB, ord,     "rbraceuend"},
  {0x0005D, cls,     "rbrack"},
  {0x023A5, ord,     "rbrackextender"},
  {0x023A6, ord,     "rbracklend"},
  {0x0298E, cls,     "rbracklrtick"},
  {0x0298C, cls,     "rbrackubar"},
  {0x023A4, ord,     "rbrackuend"},
  {0x02990, cls,     "rbrackurtick"},
  {0x02773, cls,     "rbrbrak"},
  {0x02309, cls,     "rceil"},
  {0x029FD, cls,     "rcurvyangle"},
  {0x0292B, ord,     "rdiagovfdiag"},
  {0x02930, ord,     "rdiagovsearrow"},
  {0x0267B, ord,     "recycle"},
  {0x02194, rel,     "rel"},
  {0x021BE, rel,     "restriction"},
  {0x029A3, ord,     "revangle"},
  {0x029A5, ord,     "revangleubar"},
  {0x029B0, ord,     "revemptyset"},
  {0x021CB, rel,     "revequilibrium"},
  {0x02AEE, rel,     "revnmid"},
  {0x029D2, rel,     "rfbowtie"},
  {0x0230B, cls,     "rfloor"},
  {0x029D5, rel,     "rftimes"},
  {0x027EF, cls,     "rgroup"},
  {0x025B7, bin,     "rhd"},
  {0x003C1, ord,     "rho"},
  {0x003C1, ord,     "rhoup"},
  {0x0221F, ord,     "rightangle"},
  {0x0299D, ord,     "rightanglemdot"},
  {0x0299C, ord,     "rightanglesqr"},
  {0x02192, rel,     "rightarrow"},
  {0x02975, rel,     "rightarrowapprox"},
  {0x02B48, rel,     "rightarrowbackapprox"},
  {0x021E5, rel,     "rightarrowbar"},
  {0x02B4C, rel,     "rightarrowbsimilar"},
  {0x0291E, rel,     "rightarrowdiamond"},
  {0x02B43, rel,     "rightarrowgtr"},
  {0x027F4, rel,     "rightarrowonoplus"},
  {0x02945, rel,     "rightarrowplus"},
  {0x02942, rel,     "rightarrowshortleftarrow"},
  {0x02974, rel,     "rightarrowsimilar"},
  {0x02B44, rel,     "rightarrowsupset"},
  {0x021A3, rel,     "rightarrowtail"},
  {0x021FE, rel,     "rightarrowtriangle"},
  {0x02947, rel,     "rightarrowx"},
  {0x0296C, rel,     "rightbarharpoon"},
  {0x0290D, rel,     "rightbkarrow"},
  {0x02933, rel,     "rightcurvedarrow"},
  {0x021E2, ord,     "rightdasharrow"},
  {0x0291C, rel,     "rightdbltail"},
  {0x02911, rel,     "rightdotarrow"},
  {0x02937, rel,     "rightdowncurvedarrow"},
  {0x0297D, rel,     "rightfishtail"},
  {0x020D1, acc,     "rightharpoonaccent"},
  {0x021C1, rel,     "rightharpoondown"},
  {0x02957, rel,     "rightharpoondownbar"},
  {0x02964, rel,     "rightharpoonsupdown"},
  {0x021C0, rel,     "rightharpoonup"},
  {0x02953, rel,     "rightharpoonupbar"},
  {0x0296C, rel,     "rightharpoonupdash"},
  {0x02970, rel,     "rightimply"},
  {0x021C4, rel,     "rightleftarrow"},
  {0x021C4, rel,     "rightleftarrows"},
  {0x0294B, rel,     "rightleftharpoon"},
  {0x021CC, rel,     "rightleftharpoons"},
  {0x02969, rel,     "rightleftharpoonsdown"},
  {0x02968, rel,     "rightleftharpoonsup"},
  {0x0263D, ord,     "rightmoon"},
  {0x027D6, opt,     "rightouterjoin"},
  {0x02B54, ord,     "rightpentagon"},
  {0x02B53, ord,     "rightpentagonblack"},
  {0x021C9, rel,     "rightrightarrows"},
  {0x02964, rel,     "rightrightharpoons"},
  {0x02AA7, rel,     "rightslice"},
  {0x021DD, rel,     "rightsquigarrow"},
  {0x0291A, rel,     "righttail"},
  {0x021F6, rel,     "rightthreearrows"},
  {0x022CC, bin,     "rightthreetimes"},
  {0x021BB, ord,     "rightturn"},
  {0x0294F, rel,     "rightupdownharpoon"},
  {0x0219D, rel,     "rightwavearrow"},
  {0x021E8, ord,     "rightwhitearrow"},
  {0x02988, cls,     "rimg"},
  {0x0030A, acc,     "ring"},
  {0x02A22, bin,     "ringplus"},
  {0x02253, rel,     "risingdotseq"},
  {0x023B1, ord,     "rmoustache"},
  {0x00029, cls,     "rparen"},
  {0x0239F, ord,     "rparenextender"},
  {0x02994, cls,     "rparengtr"},
  {0x023A0, ord,     "rparenlend"},
  {0x0239E, ord,     "rparenuend"},
  {0x02A12, opt | N, "rppolint"},
  {0x0298A, cls,     "rrangle"},
  {0x027E7, cls,     "rrbracket"},
  {0x025B7, bin,     "rres"},
  {0x02988, cls,     "rrparenthesis"},
  {0x029F7, bin,     "rsolbar"},
  {0x02ACE, rel,     "rsqhook"},
  {0x02A65, bin,     "rsub"},
  {0x022CA, bin,     "rtimes"},
  {0x029CE, rel,     "rtriltri"},
  {0x029F4, rel,     "ruledelayed"},
  {0x023B9, ord,     "rvboxline"},
  {0x029D9, cls,     "rvzigzag"},
  {0x02639, ord,     "sadface"},
  {0x02650, ord,     "sagittarius"},
  {0x003E1, ord,     "sampi"},
  {0x02143, ord,     "sansLmirrored"},
  {0x02142, ord,     "sansLturned"},
  {0x02644, ord,     "saturn"},
  {0x0264F, ord,     "scorpio"},
  {0x02A13, opt | N, "scpolint"},
  {0x022B1, rel,     "scurel"},
  {0x02259, rel,     "sdef"},
  {0x02198, rel,     "searrow"},
  {0x02033, ord,     "second"},
  {0x02A1F, opt,     "semi"},
  {0x0003B, puc,     "semicolon"},
  {0x0292D, ord,     "seovnearrow"},
  {0x029F5, bin,     "setminus"},
  {0x0266F, ord,     "sharp"},
  {0x02ADF, rel,     "shortdowntack"},
  {0x02ADE, rel,     "shortlefttack"},
  {0x02944, rel,     "shortrightarrowleftarrow"},
  {0x02AE0, rel,     "shortuptack"},
  {0x029E2, bin,     "shuffle"},
  {0x003C3, ord,     "sigma"},
  {0x003C3, ord,     "sigmaup"},
  {0x0223C, rel,     "sim"},
  {0x02243, rel,     "simeq"},
  {0x02AA0, rel,     "simgE"},
  {0x02A9E, rel,     "simgtr"},
  {0x02B49, rel,     "similarleftarrow"},
  {0x02972, rel,     "similarrightarrow"},
  {0x02A9F, rel,     "simlE"},
  {0x02A9D, rel,     "simless"},
  {0x02A6C, rel,     "simminussim"},
  {0x02246, rel,     "simneqq"},
  {0x02A24, bin,     "simplus"},
  {0x02A6B, rel,     "simrdots"},
  {0x0223F, ord,     "sinewave"},
  {0x0266C, ord,     "sixteenthnote"},
  {0x02620, ord,     "skull"},
  {0x0002F, bin,     "slash"},
  {0x025C2, bin,     "smallblacktriangleleft"},
  {0x025B8, bin,     "smallblacktriangleright"},
  {0x0220A, rel,     "smallin"},
  {0x0220D, rel,     "smallni"},
  {0x02216, bin,     "smallsetminus"},
  {0x025BF, bin,     "smalltriangledown"},
  {0x025C3, bin,     "smalltriangleleft"},
  {0x025B9, bin,     "smalltriangleright"},
  {0x025B5, bin,     "smalltriangleup"},
  {0x02A33, bin,     "smashtimes"},
  {0x02022, bin,     "smblkcircle"},
  {0x02B29, ord,     "smblkdiamond"},
  {0x02B2A, ord,     "smblklozenge"},
  {0x025AA, ord,     "smblksquare"},
  {0x029E4, rel,     "smeparsl"},
  {0x02323, rel,     "smile"},
  {0x0263A, ord,     "smileface"},
  {0x0263A, ord,     "smiley"},
  {0x02AAA, rel,     "smt"},
  {0x02AAC, rel,     "smte"},
  {0x02B52, ord,     "smwhitestar"},
  {0x025E6, ord,     "smwhtcircle"},
  {0x022C4, bin,     "smwhtdiamond"},
  {0x02B2B, ord,     "smwhtlozenge"},
  {0x025AB, ord,     "smwhtsquare"},
  {0x02660, ord,     "spadesuit"},
  {0x000A8, ord,     "spddot"},
  {0x0005E, ord,     "sphat"},
  {0x02222, ord,     "sphericalangle"},
  {0x029A1, ord,     "sphericalangleup"},
  {0x02981, ord,     "spot"},
  {0x0007E, ord,     "sptilde"},
  {0x02293, bin,     "sqcap"},
  {0x02294, bin,     "sqcup"},
  {0x02A16, opt | N, "sqint"},
  {0x02311, ord,     "sqlozenge"},
  {0x02A16, opt | N, "sqrint"},
  {0x0221A, ord,     "sqrt"},
  {0x023B7, ord,     "sqrtbottom"},
  {0x0228F, rel,     "sqsubset"},
  {0x02291, rel,     "sqsubseteq"},
  {0x022E4, rel,     "sqsubsetneq"},
  {0x02290, rel,     "sqsupset"},
  {0x02292, rel,     "sqsupseteq"},
  {0x022E5, rel,     "sqsupsetneq"},
  {0x025FB, ord,     "square"},
  {0x02B13, ord,     "squarebotblack"},
  {0x025A9, ord,     "squarecrossfill"},
  {0x025A4, ord,     "squarehfill"},
  {0x025A6, ord,     "squarehvfill"},
  {0x025E7, ord,     "squareleftblack"},
  {0x02B15, ord,     "squarellblack"},
  {0x025F1, ord,     "squarellquad"},
  {0x025EA, ord,     "squarelrblack"},
  {0x025F2, ord,     "squarelrquad"},
  {0x025A8, ord,     "squareneswfill"},
  {0x025A7, ord,     "squarenwsefill"},
  {0x025E8, ord,     "squarerightblack"},
  {0x02B12, ord,     "squaretopblack"},
  {0x025E9, ord,     "squareulblack"},
  {0x025F0, ord,     "squareulquad"},
  {0x02B14, ord,     "squareurblack"},
  {0x025F3, ord,     "squareurquad"},
  {0x025A5, ord,     "squarevfill"},
  {0x025A2, ord,     "squoval"},
  {0x02AFD, bin,     "sslash"},
  {0x022C6, bin,     "star"},
  {0x0225B, rel,     "stareq"},
  {0x02615, ord,     "steaming"},
  {0x000A3, ord,     "sterling"},
  {0x003DB, ord,     "stigma"},
  {0x0297C, rel,     "strictfi"},
  {0x0297D, rel,     "strictif"},
  {0x023E4, ord,     "strns"},
  {0x02AC3, rel,     "subedot"},
  {0x02AC1, rel,     "submult"},
  {0x02979, rel,     "subrarr"},
  {0x02282, rel,     "subset"},
  {0x02AC9, rel,     "subsetapprox"},
  {0x027C3, ord,     "subsetcirc"},
  {0x02ABD, rel,     "subsetdot"},
  {0x02286, rel,     "subseteq"},
  {0x02AC5, rel,     "subseteqq"},
  {0x0228A, rel,     "subsetneq"},
  {0x02ACB, rel,     "subsetneqq"},
  {0x02ABF, rel,     "subsetplus"},
  {0x02AC7, rel,     "subsim"},
  {0x02AD5, rel,     "subsub"},
  {0x02AD3, rel,     "subsup"},
  {0x0227B, rel,     "succ"},
  {0x02AB8, rel,     "succapprox"},
  {0x0227D, rel,     "succcurlyeq"},
  {0x02AB0, rel,     "succeq"},
  {0x02AB4, rel,     "succeqq"},
  {0x02ABA, rel,     "succnapprox"},
  {0x02AB2, rel,     "succneq"},
  {0x02AB6, rel,     "succneqq"},
  {0x022E9, rel,     "succnsim"},
  {0x0227F, rel,     "succsim"},
  {0x02211, opt,     "sum"},
  {0x023B3, ord,     "sumbottom"},
  {0x02A0B, opt | N, "sumint"},
  {0x023B2, ord,     "sumtop"},
  {0x0263C, ord,     "sun"},
  {0x02AD8, rel,     "supdsub"},
  {0x02AC4, rel,     "supedot"},
  {0x027C9, rel,     "suphsol"},
  {0x02AD7, rel,     "suphsub"},
  {0x0297B, rel,     "suplarr"},
  {0x02AC2, rel,     "supmult"},
  {0x02283, rel,     "supset"},
  {0x02ACA, rel,     "supsetapprox"},
  {0x027C4, ord,     "supsetcirc"},
  {0x02ABE, rel,     "supsetdot"},
  {0x02287, rel,     "supseteq"},
  {0x02AC6, rel,     "supseteqq"},
  {0x0228B, rel,     "supsetneq"},
  {0x02ACC, rel,     "supsetneqq"},
  {0x02AC0, rel,     "supsetplus"},
  {0x02AC8, rel,     "supsim"},
  {0x02AD4, rel,     "supsub"},
  {0x02AD6, rel,     "supsup"},
  {0x021A0, rel,     "surj"},
  {0x02199, rel,     "swarrow"},
  {0x02694, ord,     "swords"},
  {0x02AFE, bin,     "talloblong"},
  {0x003C4, ord,     "tau"},
  {0x02649, ord,     "taurus"},
  {0x003C4, ord,     "tauup"},
  {0x000B5, ord,     "tcmu"},
  {0x02126, ord,     "tcohm"},
  {0x0005c, ord,     "textbackslash"},
  {0x02192, rel,     "tfun"},
  {0x02234, ord,     "therefore"},
  {0x029E7, ord,     "thermod"},
  {0x003B8, ord,     "theta"},
  {0x003B8, ord,     "thetaup"},
  {0x02034, ord,     "third"},
  {0x027C0, ord,     "threedangle"},
  {0x02AF6, bin,     "threedotcolon"},
  {0x020E8, acc,     "threeunderdot"},
  {0x02040, bin,     "tieconcat"},
  {0x029DD, ord,     "tieinfty"},
  {0x00303, acc,     "tilde"},
  {0x000D7, bin,     "times"},
  {0x02A31, bin,     "timesbar"},
  {0x021A3, rel,     "tinj"},
  {0x029FF, bin,     "tminus"},
  {0x02192, rel,     "to"},
  {0x02928, rel,     "toea"},
  {0x02927, rel,     "tona"},
  {0x022A4, ord,     "top"},
  {0x02336, ord,     "topbot"},
  {0x02AF1, ord,     "topcir"},
  {0x02ADA, rel,     "topfork"},
  {0x025E0, ord,     "topsemicircle"},
  {0x02929, rel,     "tosa"},
  {0x0292A, rel,     "towa"},
  {0x029FE, bin,     "tplus"},
  {0x023E2, ord,     "trapezium"},
  {0x025B3, bin,     "triangle"},
  {0x025EC, ord,     "trianglecdot"},
  {0x025BF, bin,     "triangledown"},
  {0x025C1, bin,     "triangleleft"},
  {0x025ED, ord,     "triangleleftblack"},
  {0x022B4, rel,     "trianglelefteq"},
  {0x02A3A, bin,     "triangleminus"},
  {0x029CA, ord,     "triangleodot"},
  {0x02A39, bin,     "triangleplus"},
  {0x0225C, rel,     "triangleq"},
  {0x025B7, bin,     "triangleright"},
  {0x025EE, ord,     "trianglerightblack"},
  {0x022B5, rel,     "trianglerighteq"},
  {0x029CC, ord,     "triangles"},
  {0x029CD, bin,     "triangleserifs"},
  {0x02A3B, bin,     "triangletimes"},
  {0x029CB, ord,     "triangleubar"},
  {0x029FB, bin,     "tripleplus"},
  {0x02034, ord,     "trprime"},
  {0x02AFB, bin,     "trslash"},
  {0x021A0, rel,     "tsur"},
  {0x029A2, ord,     "turnangle"},
  {0x02129, ord,     "turnediota"},
  {0x02319, ord,     "turnednot"},
  {0x02A4B, bin,     "twocaps"},
  {0x02A4A, bin,     "twocups"},
  {0x021A1, rel,     "twoheaddownarrow"},
  {0x0219E, rel,     "twoheadleftarrow"},
  {0x02B3B, rel,     "twoheadleftarrowtail"},
  {0x02B37, rel,     "twoheadleftdbkarrow"},
  {0x02B36, rel,     "twoheadmapsfrom"},
  {0x02905, rel,     "twoheadmapsto"},
  {0x021A0, rel,     "twoheadrightarrow"},
  {0x02916, rel,     "twoheadrightarrowtail"},
  {0x0219F, rel,     "twoheaduparrow"},
  {0x02949, rel,     "twoheaduparrowcircle"},
  {0x02017, ord,     "twolowline"},
  {0x0266B, ord,     "twonotes"},
  {0x02982, bin,     "typecolon"},
  {0x023E1, ord,     "ubrbrak"},
  {0x025DC, ord,     "ularc"},
  {0x025E4, ord,     "ulblacktriangle"},
  {0x0231C, opn,     "ulcorner"},
  {0x025F8, ord,     "ultriangle"},
  {0x02A41, bin,     "uminus"},
  {0x00331, acc,     "underbar"},
  {0x023DF, ord,     "underbrace"},
  {0x023B5, ord,     "underbracket"},
  {0x020EE, acc,     "underleftarrow"},
  {0x020ED, acc,     "underleftharpoondown"},
  {0x0034D, acc,     "underleftrightarrow"},
  {0x00332, acc,     "underline"},
  {0x023DD, ord,     "underparen"},
  {0x020EF, acc,     "underrightarrow"},
  {0x020EC, acc,     "underrightharpoondown"},
  {0x022EF, ord,     "unicodecdots"},
  {0x02026, ord,     "unicodeellipsis"},
  {0x022B4, rel,     "unlhd"},
  {0x022B5, rel,     "unrhd"},
  {0x00391, ord | F, "upAlpha"},
  {0x00392, ord | F, "upBeta"},
  {0x003A7, ord | F, "upChi"},
  {0x00394, ord | F, "upDelta"},
  {0x003DC, ord | F, "upDigamma"},
  {0x00395, ord | F, "upEpsilon"},
  {0x00397, ord | F, "upEta"},
  {0x00393, ord | F, "upGamma"},
  {0x00399, ord | F, "upIota"},
  {0x0039A, ord | F, "upKappa"},
  {0x003DE, ord | F, "upKoppa"},
  {0x0039B, ord | F, "upLambda"},
  {0x0039C, ord | F, "upMu"},
  {0x0039D, ord | F, "upNu"},
  {0x003A9, ord | F, "upOmega"},
  {0x0039F, ord | F, "upOmicron"},
  {0x003A6, ord | F, "upPhi"},
  {0x003A0, ord | F, "upPi"},
  {0x003A8, ord | F, "upPsi"},
  {0x003A1, ord | F, "upRho"},
  {0x003E0, ord | F, "upSampi"},
  {0x003A3, ord | F, "upSigma"},
  {0x003DA, ord | F, "upStigma"},
  {0x003A4, ord | F, "upTau"},
  {0x00398, ord | F, "upTheta"},
  {0x003A5, ord | F, "upUpsilon"},
  {0x0039E, ord | F, "upXi"},
  {0x00396, ord | F, "upZeta"},
  {0x003B1, ord | F, "upalpha"},
  {0x0214B, bin,     "upand"},
  {0x02191, rel,     "uparrow"},
  {0x02909, rel,     "uparrowbarred"},
  {0x021C5, rel,     "uparrowdownarrow"},
  {0x029BD, ord,     "uparrowoncircle"},
  {0x003F6, ord | F, "upbackepsilon"},
  {0x003B2, ord | F, "upbeta"},
  {0x003C7, ord | F, "upchi"},
  {0x021E1, ord,     "updasharrow"},
  {0x003B4, ord | F, "updelta"},
  {0x003DD, ord | F, "updigamma"},
  {0x02195, rel,     "updownarrow"},
  {0x021A8, ord,     "updownarrowbar"},
  {0x021C5, rel,     "updownarrows"},
  {0x02951, rel,     "updownharpoonleftleft"},
  {0x0294D, rel,     "updownharpoonleftright"},
  {0x0294C, rel,     "updownharpoonrightleft"},
  {0x0294F, rel,     "updownharpoonrightright"},
  {0x0296E, rel,     "updownharpoons"},
  {0x0296E, rel,     "updownharpoonsleftright"},
  {0x003B5, ord | F, "upepsilon"},
  {0x0296E, rel | F, "upequilibrium"},
  {0x003B7, ord | F, "upeta"},
  {0x0297E, rel,     "upfishtail"},
  {0x003B3, ord | F, "upgamma"},
  {0x021BF, rel,     "upharpoonleft"},
  {0x02960, rel,     "upharpoonleftbar"},
  {0x021C3, rel,     "upharpoonleftdown"},
  {0x021BF, rel,     "upharpoonleftup"},
  {0x021BE, rel,     "upharpoonright"},
  {0x0295C, rel,     "upharpoonrightbar"},
  {0x021C2, rel,     "upharpoonrightdown"},
  {0x021BE, rel,     "upharpoonrightup"},
  {0x02963, rel,     "upharpoonsleftright"},
  {0x027D2, rel,     "upin"},
  {0x02A1B, opt | N, "upint"},
  {0x003B9, ord | F, "upiota"},
  {0x003BA, ord | F, "upkappa"},
  {0x003DF, ord | F, "upkoppa"},
  {0x003BB, ord | F, "uplambda"},
  {0x0228E, bin | F, "uplus"},
  {0x003BC, ord | F, "upmu"},
  {0x003BD, ord | F, "upnu"},
  {0x003D8, ord | F, "upoldKoppa"},
  {0x003D9, ord | F, "upoldkoppa"},
  {0x003C9, ord | F, "upomega"},
  {0x003BF, ord | F, "upomicron"},
  {0x003D5, ord | F, "upphi"},
  {0x003C0, ord | F, "uppi"},
  {0x003C8, ord | F, "uppsi"},
  {0x0296F, rel | F, "uprevequilibrium"},
  {0x003C1, ord | F, "uprho"},
  {0x02934, ord,     "uprightcurvearrow"},
  {0x003E1, ord | F, "upsampi"},
  {0x003C3, ord | F, "upsigma"},
  {0x003C5, ord,     "upsilon"},
  {0x003C5, ord | F, "upsilonup"},
  {0x003DB, ord | F, "upstigma"},
  {0x003C4, ord | F, "uptau"},
  {0x003B8, ord | F, "uptheta"},
  {0x021C8, rel | F, "upuparrows"},
  {0x02963, rel | F, "upupharpoons"},
  {0x003C5, ord | F, "upupsilon"},
  {0x003F4, ord | F, "upvarTheta"},
  {0x003D0, ord | F, "upvarbeta"},
  {0x003F5, ord | F, "upvarepsilon"},
  {0x003F0, ord | F, "upvarkappa"},
  {0x003C6, ord | F, "upvarphi"},
  {0x003D6, ord | F, "upvarpi"},
  {0x003F1, ord | F, "upvarrho"},
  {0x003C2, ord | F, "upvarsigma"},
  {0x003D1, ord | F, "upvartheta"},
  {0x021E7, ord | F, "upwhitearrow"},
  {0x003BE, ord | F, "upxi"},
  {0x003B6, ord | F, "upzeta"},
  {0x02645, ord,     "uranus"},
  {0x025DD, ord,     "urarc"},
  {0x025E5, ord,     "urblacktriangle"},
  {0x0231D, cls,     "urcorner"},
  {0x025F9, ord,     "urtriangle"},
  {0x00330, acc,     "utilde"},
  {0x02AE8, rel,     "vBar"},
  {0x02AE9, rel,     "vBarv"},
  {0x022A8, rel,     "vDash"},
  {0x02AE2, rel,     "vDdash"},
  {0x1D6E5, ord,     "varDelta"},
  {0x02641, ord,     "varEarth"},
  {0x1D6E4, ord,     "varGamma"},
  {0x1D6EC, ord,     "varLambda"},
  {0x1D6FA, ord,     "varOmega"},
  {0x1D6F7, ord,     "varPhi"},
  {0x1D6F1, ord,     "varPi"},
  {0x1D6F9, ord,     "varPsi"},
  {0x1D6F4, ord,     "varSigma"},
  {0x1D6E9, ord,     "varTheta"},
  {0x1D6F6, ord,     "varUpsilon"},
  {0x02AE6, rel,     "varVdash"},
  {0x1D6EF, ord,     "varXi"},
  {0x02305, bin,     "varbarwedge"},
  {0x003D0, ord,     "varbeta"},
  {0x023CE, ord,     "varcarriagereturn"},
  {0x02667, ord,     "varclub"},
  {0x02667, ord,     "varclubsuit"},
  {0x02666, ord,     "vardiamond"},
  {0x02666, ord,     "vardiamondsuit"},
  {0x02306, bin,     "vardoublebarwedge"},
  {0x003B5, ord,     "varepsilon"},
  {0x003B5, ord,     "varepsilonup"},
  {0x02665, ord,     "varheart"},
  {0x02665, ord,     "varheartsuit"},
  {0x02B21, ord,     "varhexagon"},
  {0x02B22, ord,     "varhexagonblack"},
  {0x0232C, ord,     "varhexagonlrbonds"},
  {0x022F6, rel,     "varisinobar"},
  {0x022F3, rel,     "varisins"},
  {0x003F0, ord,     "varkappa"},
  {0x022BF, ord,     "varlrtriangle"},
  {0x022FD, rel,     "varniobar"},
  {0x022FB, rel,     "varnis"},
  {0x02300, ord,     "varnothing"},
  {0x02232, opt | N, "varointclockwise"},
  {0x003C6, ord,     "varphi"},
  {0x003C6, ord,     "varphiup"},
  {0x003D6, ord,     "varpi"},
  {0x003D6, ord,     "varpiup"},
  {0x02A09, opt,     "varprod"},
  {0x003F1, ord,     "varrho"},
  {0x003F1, ord,     "varrhoup"},
  {0x0225C, rel,     "varsdef"},
  {0x003C2, ord,     "varsigma"},
  {0x003C2, ord,     "varsigmaup"},
  {0x02664, ord,     "varspade"},
  {0x02664, ord,     "varspadesuit"},
  {0x02736, ord,     "varstar"},
  {0x0228A, rel,     "varsubsetneq"},
  {0x003D1, ord,     "vartheta"},
  {0x003D1, ord,     "varthetaup"},
  {0x025B5, bin,     "vartriangle"},
  {0x022B2, rel,     "vartriangleleft"},
  {0x022B3, rel,     "vartriangleright"},
  {0x02A61, bin,     "varveebar"},
  {0x023AA, ord,     "vbraceextender"},
  {0x029D0, rel,     "vbrtri"},
  {0x022A2, rel,     "vdash"},
  {0x022EE, rel,     "vdots"},
  {0x020D1, acc,     "vec"},
  {0x02A2F, bin,     "vectimes"},
  {0x02228, bin,     "vee"},
  {0x022BB, bin,     "veebar"},
  {0x027C7, bin,     "veedot"},
  {0x02A63, bin,     "veedoublebar"},
  {0x0225A, rel,     "veeeq"},
  {0x02A5B, bin,     "veemidvert"},
  {0x02A52, bin,     "veeodot"},
  {0x02A56, bin,     "veeonvee"},
  {0x02A59, rel,     "veeonwedge"},
  {0x0007C, ord,     "vert"},
  {0x020D2, acc,     "vertoverlay"},
  {0x02317, ord,     "viewdata"},
  {0x0264D, ord,     "virgo"},
  {0x027DD, rel,     "vlongdash"},
  {0x025AF, ord,     "vrectangle"},
  {0x025AE, ord,     "vrectangleblack"},
  {0x02219, bin,     "vysmblkcircle"},
  {0x02B1D, ord,     "vysmblksquare"},
  {0x02218, bin,     "vysmwhtcircle"},
  {0x02B1E, ord,     "vysmwhtsquare"},
  {0x0299A, ord,     "vzigzag"},
  {0x026A0, ord,     "warning"},
  {0x02311, ord,     "wasylozenge"},
  {0x02234, ord,     "wasytherefore"},
  {0x02227, bin,     "wedge"},
  {0x02A5F, bin,     "wedgebar"},
  {0x027D1, bin,     "wedgedot"},
  {0x02A60, bin,     "wedgedoublebar"},
  {0x02A5A, bin,     "wedgemidvert"},
  {0x02A51, bin,     "wedgeodot"},
  {0x02A55, bin,     "wedgeonwedge"},
  {0x02259, rel,     "wedgeq"},
  {0x021EA, ord,     "whitearrowupfrombar"},
  {0x027C1, ord,     "whiteinwhitetriangle"},
  {0x025C5, ord,     "whitepointerleft"},
  {0x025BB, ord,     "whitepointerright"},
  {0x027E4, bin,     "whitesquaretickleft"},
  {0x027E5, bin,     "whitesquaretickright"},
  {0x02B2D, ord,     "whthorzoval"},
  {0x02B2F, ord,     "whtvertoval"},
  {0x029A6, ord,     "wideangledown"},
  {0x029A7, ord,     "wideangleup"},
  {0x020E9, acc,     "widebridgeabove"},
  {0x023DC, ord,     "wideparen"},
  {0x00330, acc,     "wideutilde"},
  {0x02118, ord,     "wp"},
  {0x02240, bin,     "wr"},
  {0x029F9, opt,     "xbsol"},
  {0x003BE, ord,     "xi"},
  {0x003BE, ord,     "xiup"},
  {0x029F8, opt,     "xsol"},
  {0x000A5, ord,     "yen"},
  {0x0262F, ord,     "yinyang"},
  {0x02A1F, opt,     "zcmp"},
  {0x003B6, ord,     "zeta"},
  {0x003B6, ord,     "zetaup"},
  {0x029F9, opt,     "zhide"},
  {0x02A20, opt,     "zpipe"},
  {0x02A21, opt,     "zproject"},
  {0x0007B, opn,     "{"},
  {0x0007c, ord,     "|"},
  {0x0007D, cls,     "}"},
};
// clang-format on

const i32 _count = sizeof(_symbols) / sizeof(Symbol);

const Symbol* Symbol::get(const char* name) {
  const int i = binIndexOf(_count, [&](int i) { return strcmp(name, _symbols[i].name); });
  if (i < 0) return nullptr;
  return _symbols + i;
}

AtomType Symbol::type() const {
  return static_cast<AtomType>(flag >> 8);
}

LimitsType Symbol::limitsType() const {
  if (type() != AtomType::bigOperator) return LimitsType::noLimits;
  return flag & 0x00000002 ? LimitsType::noLimits : LimitsType::normal;
}

bool Symbol::isVariable() const {
  return flag & 0x00000001;
}

}  // namespace microtex
