// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package pprofile

import (
	"go.opentelemetry.io/collector/pdata/internal"
)

// ProfilesData represents the profiles data that can be stored in persistent storage,
// OR can be embedded by other protocols that transfer OTLP profiles data but do not
// implement the OTLP protocol.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewProfilesData function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ProfilesData internal.ProfilesDataWrapper

func newProfilesData(orig *internal.ProfilesData, state *internal.State) ProfilesData {
	return ProfilesData(internal.NewProfilesDataWrapper(orig, state))
}

// NewProfilesData creates a new empty ProfilesData.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewProfilesData() ProfilesData {
	return newProfilesData(internal.NewProfilesData(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms ProfilesData) MoveTo(dest ProfilesData) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteProfilesData(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// ResourceProfiles returns the ResourceProfiles associated with this ProfilesData.
func (ms ProfilesData) ResourceProfiles() ResourceProfilesSlice {
	return newResourceProfilesSlice(&ms.getOrig().ResourceProfiles, ms.getState())
}

// Dictionary returns the dictionary associated with this ProfilesData.
func (ms ProfilesData) Dictionary() ProfilesDictionary {
	return newProfilesDictionary(&ms.getOrig().Dictionary, ms.getState())
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms ProfilesData) CopyTo(dest ProfilesData) {
	dest.getState().AssertMutable()
	internal.CopyProfilesData(dest.getOrig(), ms.getOrig())
}

func (ms ProfilesData) getOrig() *internal.ProfilesData {
	return internal.GetProfilesDataOrig(internal.ProfilesDataWrapper(ms))
}

func (ms ProfilesData) getState() *internal.State {
	return internal.GetProfilesDataState(internal.ProfilesDataWrapper(ms))
}
