/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAccessMethod;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAvailableExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCharset;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreCollation;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataTypeCache;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreEnumValue;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreEventTrigger;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExecutionContext;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreExtension;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignServer;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJob;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreJobClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreLanguage;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSetting;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTablespace;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPStatefulObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectLookupCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueListProvider;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.LongKeyMap;

public class PostgreDatabase
extends JDBCRemoteInstance
implements DBSCatalog,
DBPRefreshableObject,
DBPStatefulObject,
DBPNamedObject2,
PostgreObject,
DBPDataTypeProvider,
DBSInstanceLazy,
DBPObjectStatistics,
DBPObjectWithLazyDescription {
    private static final Log log = Log.getLog(PostgreDatabase.class);
    private transient PostgreRole initialOwner;
    private transient PostgreTablespace initialTablespace;
    private transient PostgreCharset initialEncoding;
    private long oid;
    private String name;
    private long ownerId;
    private String templateName;
    private long encodingId;
    private String collate;
    private String ctype;
    private boolean isTemplate;
    private boolean allowConnect;
    private int connectionLimit;
    private long tablespaceId;
    private String description;
    private long dbTotalSize = -1L;
    private Boolean supportTypColumn;
    private final PostgreDatabaseJDBCObjectCache<? extends PostgreRole> roleCache = this.createRoleCache();
    final AccessMethodCache accessMethodCache = new AccessMethodCache();
    final ForeignDataWrapperCache foreignDataWrapperCache = new ForeignDataWrapperCache();
    public final ForeignServerCache foreignServerCache = new ForeignServerCache();
    final LanguageCache languageCache = new LanguageCache();
    private final EncodingCache encodingCache = new EncodingCache();
    private final EventTriggersCache eventTriggersCache = new EventTriggersCache();
    public final ExtensionCache extensionCache = new ExtensionCache();
    private final AvailableExtensionCache availableExtensionCache = new AvailableExtensionCache();
    private final CollationCache collationCache = new CollationCache();
    public final TablespaceCache tablespaceCache = new TablespaceCache();
    private final LongKeyMap<PostgreDataType> dataTypeCache = new LongKeyMap();
    public final JobCache jobCache = new JobCache();
    public final JobClassCache jobClassCache = new JobClassCache();
    public JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> schemaCache;
    private final EnumValueCache enumValueCache = new EnumValueCache();

    protected PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, ResultSet dbResult) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.initCaches();
        this.loadInfo(dbResult);
    }

    protected PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String databaseName) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.name = databaseName;
        this.initCaches();
        this.checkInstanceConnection(monitor, false);
        try {
            this.readDatabaseInfo(monitor);
        }
        catch (DBCException e) {
            log.debug((Object)"Error reading database info", (Throwable)e);
        }
    }

    protected PostgreDatabase(DBRProgressMonitor monitor, PostgreDataSource dataSource, String name, PostgreRole owner, String templateName, PostgreTablespace tablespace, PostgreCharset encoding) throws DBException {
        super(monitor, (JDBCDataSource)dataSource, false);
        this.name = name;
        this.initialOwner = owner;
        this.initialTablespace = tablespace;
        this.initialEncoding = encoding;
        this.ownerId = owner == null ? 0L : owner.getObjectId();
        this.templateName = templateName;
        this.tablespaceId = tablespace == null ? 0L : tablespace.getObjectId();
        this.encodingId = encoding == null ? 0L : encoding.getObjectId();
        this.initCaches();
    }

    PostgreDatabase(PostgreDataSource dataSource, String databaseName) {
        super((JDBCDataSource)dataSource);
        this.name = databaseName;
        this.initCaches();
        PostgreSchema sysSchema = new PostgreSchema(this, "pg_catalog");
        sysSchema.getDataTypeCache().loadDefaultTypes(sysSchema);
        this.schemaCache.cacheObject((DBSObject)sysSchema);
    }

    public boolean isSharedDatabase() {
        return false;
    }

    @NotNull
    public PostgreExecutionContext getMetaContext() {
        return (PostgreExecutionContext)super.getDefaultContext(true);
    }

    private void initCaches() {
        this.schemaCache = this.getDataSource().getServerType().createSchemaCache(this);
    }

    private void initEnumTypesCache(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (((PostgreDataSource)this.dataSource).isSupportsEnumTable()) {
            this.enumValueCache.getAllObjects(monitor, this);
        }
    }

    private void readDatabaseInfo(DBRProgressMonitor monitor) throws DBCException {
        PostgreExecutionContext context = this.getMetaContext();
        try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Load database info");){
            ((PostgreDataSource)this.dataSource).readDatabaseServerVersion(session);
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT db.oid,db.* FROM pg_catalog.pg_database db WHERE datname=?");){
                dbStat.setString(1, this.name);
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    if (dbResult.nextRow()) {
                        this.loadInfo((ResultSet)dbResult);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)context);
        }
    }

    public PostgreRole getInitialOwner() {
        return this.initialOwner;
    }

    public void setInitialOwner(PostgreRole initialOwner) {
        this.initialOwner = initialOwner;
    }

    public PostgreTablespace getInitialTablespace() {
        return this.initialTablespace;
    }

    public void setInitialTablespace(PostgreTablespace initialTablespace) {
        this.initialTablespace = initialTablespace;
    }

    public PostgreCharset getInitialEncoding() {
        return this.initialEncoding;
    }

    public void setInitialEncoding(PostgreCharset initialEncoding) {
        this.initialEncoding = initialEncoding;
    }

    public void checkInstanceConnection(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (!this.isSharedDatabase() && this.executionContext == null) {
            this.checkInstanceConnection(monitor, true);
        }
    }

    void checkInstanceConnection(@NotNull DBRProgressMonitor monitor, boolean cacheMetadata) throws DBException {
        if (!this.isSharedDatabase() && this.executionContext == null) {
            this.initializeMainContext(monitor);
            this.initializeMetaContext(monitor);
            if (cacheMetadata) {
                this.cacheDataTypes(monitor, true);
            }
        }
    }

    public boolean isInstanceConnected() {
        return this.metaContext != null || this.executionContext != null || this.sharedInstance != null;
    }

    protected void loadInfo(ResultSet dbResult) {
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
        this.ownerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"datdba");
        this.encodingId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"encoding");
        if (this.dataSource.isServerVersionAtLeast(8, 4)) {
            this.collate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datcollate");
            this.ctype = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datctype");
        }
        this.isTemplate = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datistemplate");
        this.allowConnect = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"datallowconn");
        if (this.dataSource.isServerVersionAtLeast(8, 1)) {
            this.connectionLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"datconnlimit");
        }
        this.tablespaceId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"dattablespace");
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this;
    }

    public long getObjectId() {
        return this.oid;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String newName) {
        this.name = newName;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @NotNull
    protected String getMainContextName() {
        return "Main <" + this.getName() + ">";
    }

    @NotNull
    protected String getMetadataContextName() {
        return "Metadata <" + this.getName() + ">";
    }

    @NotNull
    public PostgreExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        PostgreExecutionContext ec = (PostgreExecutionContext)super.openIsolatedContext(monitor, purpose, initFrom);
        ec.setIsolatedContext(true);
        return ec;
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription(@NotNull DBRProgressMonitor monitor) {
        if (!this.getDataSource().getServerType().supportsDatabaseDescription()) {
            return null;
        }
        if (this.description != null) {
            return this.description;
        }
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this.getDataSource(), (String)"Read database description");){
            this.description = JDBCUtils.queryString((Connection)session, (String)"select description from pg_shdescription join pg_database on objoid = pg_database.oid where datname = ?", (Object[])new Object[]{this.getName()});
        }
        catch (Exception e) {
            log.debug((Object)"Error reading database description ", (Throwable)e);
        }
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return (PostgreDataSource)this.dataSource;
    }

    public boolean isPersisted() {
        return true;
    }

    public boolean isActiveDatabase() {
        return this.dataSource.getDefaultInstance() == this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Property(editable=true, updatable=true, order=3, listProvider=RoleListProvider.class)
    @Nullable
    public PostgreRole getDBA(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.getRoleById(monitor, this.ownerId);
    }

    public void setDBA(PostgreRole owner) {
        this.ownerId = owner.getObjectId();
    }

    public PostgreDatabaseJDBCObjectCache<? extends PostgreRole> getRoleCache() {
        return this.roleCache;
    }

    @Nullable
    public PostgreRole getRoleById(DBRProgressMonitor monitor, long roleId) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreRole)PostgreUtils.getObjectById(monitor, this.roleCache, this, roleId);
    }

    @Nullable
    public PostgreRole getRoleByReference(@NotNull DBRProgressMonitor monitor, @NotNull PostgreRoleReference reference) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreRole)this.roleCache.getObject(monitor, this, reference.getRoleName());
    }

    @Property(editable=false, updatable=false, order=5)
    public PostgreCharset getDefaultEncoding(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsEncodings()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return (PostgreCharset)PostgreUtils.getObjectById(monitor, this.encodingCache, this, this.encodingId);
    }

    public void setDefaultEncoding(PostgreCharset charset) throws DBException {
        this.encodingId = charset.getObjectId();
    }

    @Property(order=10)
    public String getCollate() {
        return this.collate;
    }

    @Property(order=11)
    public String getCtype() {
        return this.ctype;
    }

    @Property(order=12)
    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Property(order=13)
    public boolean isAllowConnect() {
        return this.allowConnect;
    }

    @Property(order=14)
    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    @Association
    public Collection<? extends PostgreRole> getAuthIds(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().supportsRoles()) {
            return Collections.emptyList();
        }
        this.checkInstanceConnection(monitor);
        return this.roleCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreAccessMethod> getAccessMethods(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.accessMethodCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignDataWrapper> getForeignDataWrappers(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.foreignDataWrapperCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreForeignServer> getForeignServers(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.foreignServerCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreLanguage> getLanguages(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.languageCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreSetting> getSettings(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.getDataSource().getSettingCache().getAllObjects(monitor, (DBSObject)this.getDataSource());
    }

    @Association
    public Collection<PostgreCharset> getEncodings(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsEncodings()) {
            return null;
        }
        this.checkInstanceConnection(monitor);
        return this.encodingCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreEventTrigger> getEventTriggers(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.eventTriggersCache.getAllObjects(monitor, this);
    }

    @Association
    public PostgreEventTrigger getEventTrigger(DBRProgressMonitor monitor, String triggerName) throws DBException {
        return (PostgreEventTrigger)this.eventTriggersCache.getObject(monitor, this, triggerName);
    }

    public EventTriggersCache getEventTriggersCache() {
        return this.eventTriggersCache;
    }

    @Association
    public Collection<PostgreExtension> getExtensions(DBRProgressMonitor monitor) throws DBException {
        return this.extensionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreAvailableExtension> getAvailableExtensions(DBRProgressMonitor monitor) throws DBException {
        return this.availableExtensionCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreCollation> getCollations(DBRProgressMonitor monitor) throws DBException {
        if (this.getDataSource().getServerType().supportsCollations()) {
            return this.collationCache.getAllObjects(monitor, this);
        }
        return null;
    }

    @Association
    public PostgreCollation getCollation(DBRProgressMonitor monitor, long id) throws DBException {
        if (this.getDataSource().getServerType().supportsCollations()) {
            for (PostgreCollation collation : this.collationCache.getAllObjects(monitor, this)) {
                if (collation.getObjectId() != id) continue;
                return collation;
            }
        }
        log.debug((Object)("Collation '" + id + "' not found in schema " + this.getName()));
        return null;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return this.dataSource.resolveDataKind(typeName, typeID);
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return PostgreUtils.resolveTypeFullName(monitor, this, typeFullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<PostgreDataType> getLocalDataTypes() {
        LongKeyMap<PostgreDataType> longKeyMap = this.dataTypeCache;
        synchronized (longKeyMap) {
            if (!CommonUtils.isEmpty(this.dataTypeCache)) {
                return new ArrayList<PostgreDataType>(this.dataTypeCache.values());
            }
        }
        PostgreSchema schema = this.getCatalogSchema();
        if (schema != null) {
            return schema.getDataTypeCache().getCachedObjects();
        }
        return null;
    }

    @Nullable
    public PostgreDataType getLocalDataType(String typeName) {
        return this.getDataType(null, typeName);
    }

    @Nullable
    public DBSDataType getLocalDataType(int typeID) {
        return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeID);
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return PostgreUtils.getDefaultDataTypeName(dataKind);
    }

    EnumValueCache getEnumValueCache() {
        return this.enumValueCache;
    }

    TablespaceCache getTablespaceCache() {
        return this.tablespaceCache;
    }

    @Association
    public Collection<PostgreTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.tablespaceCache.getAllObjects(monitor, this);
    }

    @Property(editable=true, updatable=true, order=4, listProvider=TablespaceListProvider.class)
    public PostgreTablespace getDefaultTablespace(DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return (PostgreTablespace)PostgreUtils.getObjectById(monitor, this.tablespaceCache, this, this.tablespaceId);
    }

    public void setDefaultTablespace(PostgreTablespace tablespace) throws DBException {
        this.tablespaceId = tablespace.getObjectId();
    }

    public PostgreTablespace getTablespace(DBRProgressMonitor monitor, long tablespaceId) throws DBException {
        this.checkInstanceConnection(monitor);
        for (PostgreTablespace ts : this.tablespaceCache.getAllObjects(monitor, this)) {
            if (ts.getObjectId() != tablespaceId) continue;
            return ts;
        }
        return null;
    }

    JobClassCache getJobClassCache() {
        return this.jobClassCache;
    }

    @Association
    public Collection<PostgreJob> getJobs(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.jobCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreJob getJob(@NotNull DBRProgressMonitor monitor, @NotNull String name) throws DBException {
        this.checkInstanceConnection(monitor);
        return (PostgreJob)this.jobCache.getObject(monitor, this, name);
    }

    @Association
    public Collection<PostgreJobClass> getJobClasses(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.checkInstanceConnection(monitor);
        return this.jobClassCache.getAllObjects(monitor, this);
    }

    @Nullable
    public PostgreJobClass getJobClass(@NotNull DBRProgressMonitor monitor, long id) throws DBException {
        for (PostgreJobClass cls : this.getJobClasses(monitor)) {
            if (cls.getObjectId() != id) continue;
            return cls;
        }
        return null;
    }

    @Association
    public Collection<PostgreSchema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        if (monitor != null) {
            this.checkInstanceConnection(monitor);
        }
        return monitor == null ? this.schemaCache.getCachedObjects() : this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Nullable
    public PostgreSchema getCatalogSchema(DBRProgressMonitor monitor) throws DBException {
        return this.getSchema(monitor, "pg_catalog");
    }

    @Nullable
    PostgreSchema getCatalogSchema() {
        return (PostgreSchema)this.schemaCache.getCachedObject("pg_catalog");
    }

    @Nullable
    PostgreSchema getActiveSchema() {
        return this.getMetaContext().getDefaultSchema();
    }

    @Nullable
    PostgreSchema getPublicSchema() {
        return (PostgreSchema)this.schemaCache.getCachedObject("public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheDataTypes(DBRProgressMonitor monitor, boolean forceRefresh) throws DBException {
        boolean hasDataTypes;
        LongKeyMap<PostgreDataType> longKeyMap = this.dataTypeCache;
        synchronized (longKeyMap) {
            hasDataTypes = !this.dataTypeCache.isEmpty();
        }
        if (!hasDataTypes || forceRefresh) {
            longKeyMap = this.dataTypeCache;
            synchronized (longKeyMap) {
                this.dataTypeCache.clear();
                this.enumValueCache.clearCache();
            }
            PostgreDataSource postgreDataSource = this.getDataSource();
            boolean readAllTypes = postgreDataSource.supportReadingAllDataTypes();
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read data types");){
                StringBuilder sql = new StringBuilder(256);
                boolean supportsSysTypColumn = this.supportsSysTypCategoryColumn(session);
                sql.append("SELECT t.oid,t.*,c.relkind,").append(PostgreDataTypeCache.getBaseTypeNameClause(postgreDataSource)).append(", d.description\nFROM pg_catalog.pg_type t");
                if (!readAllTypes && supportsSysTypColumn) {
                    sql.append("\nLEFT OUTER JOIN pg_catalog.pg_type et ON et.oid=t.typelem ");
                }
                sql.append("\nLEFT OUTER JOIN pg_catalog.pg_class c ON c.oid=t.typrelid\nLEFT OUTER JOIN pg_catalog.pg_description d ON t.oid=d.objoid\nWHERE t.typname IS NOT NULL");
                if (!readAllTypes) {
                    sql.append("\nAND (c.relkind IS NULL OR c.relkind = 'c')");
                    if (supportsSysTypColumn) {
                        sql.append(" AND (et.typcategory IS NULL OR et.typcategory <> 'C')");
                    }
                }
                ArrayList<Object> loadedDataTypes = new ArrayList<Object>();
                try (JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
                     JDBCResultSet dbResult = dbStat.executeQuery();){
                    PostgreSchema catalogSchema;
                    HashSet<PostgreSchema> hashSet = new HashSet<PostgreSchema>();
                    while (dbResult.next()) {
                        PostgreDataType dataType = PostgreDataType.readDataType(session, this, dbResult, !readAllTypes);
                        if (dataType == null) continue;
                        PostgreSchema schema = (PostgreSchema)dataType.getParentObject();
                        hashSet.add(schema);
                        schema.getDataTypeCache().cacheObject(dataType);
                        loadedDataTypes.add(dataType);
                    }
                    if (!hashSet.isEmpty()) {
                        for (PostgreSchema schema : hashSet) {
                            schema.getDataTypeCache().setFullCache(true);
                        }
                    }
                    if ((catalogSchema = this.getCatalogSchema()) != null) {
                        catalogSchema.getDataTypeCache().mapAliases(catalogSchema);
                    }
                }
                LongKeyMap<PostgreDataType> longKeyMap2 = this.dataTypeCache;
                synchronized (longKeyMap2) {
                    for (PostgreDataType postgreDataType : loadedDataTypes) {
                        this.dataTypeCache.put(postgreDataType.getObjectId(), (Object)postgreDataType);
                    }
                }
            }
            catch (SQLException e) {
                throw new DBDatabaseException((Throwable)e, (DBPDataSource)postgreDataSource);
            }
            this.initEnumTypesCache(monitor);
        }
    }

    boolean supportsSysTypCategoryColumn(JDBCSession session) {
        if (this.supportTypColumn == null) {
            if (!this.dataSource.isServerVersionAtLeast(10, 0)) {
                if (!this.dataSource.isServerVersionAtLeast(8, 4)) {
                    this.supportTypColumn = false;
                } else {
                    try {
                        JDBCUtils.queryString((Connection)session, (String)PostgreUtils.getQueryForSystemColumnChecking("pg_type", "typcategory"), (Object[])new Object[0]);
                        this.supportTypColumn = true;
                    }
                    catch (SQLException e) {
                        log.debug((Object)("Error reading system information from the pg_type table: " + e.getMessage()));
                        try {
                            if (!session.isClosed() && !session.getAutoCommit()) {
                                session.rollback();
                            }
                        }
                        catch (SQLException ex) {
                            log.warn((Object)"Can't rollback transaction", (Throwable)e);
                        }
                        this.supportTypColumn = false;
                    }
                }
            } else {
                this.supportTypColumn = true;
            }
        }
        return this.supportTypColumn;
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        this.checkInstanceConnection(monitor);
        return (PostgreSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public PostgreSchema getSchema(DBRProgressMonitor monitor, long oid) throws DBException {
        this.checkInstanceConnection(monitor);
        for (PostgreSchema schema : this.schemaCache.getAllObjects(monitor, (DBSObject)this)) {
            if (schema.getObjectId() != oid) continue;
            return schema;
        }
        return null;
    }

    @Nullable
    public PostgreSchema getSchema(long oid) {
        for (PostgreSchema schema : this.schemaCache.getCachedObjects()) {
            if (schema.getObjectId() != oid) continue;
            return schema;
        }
        return null;
    }

    public PostgreSchema createSchemaImpl(@NotNull PostgreDatabase owner, @NotNull String name, @NotNull JDBCResultSet resultSet) throws SQLException {
        return new PostgreSchema(owner, name, (ResultSet)resultSet);
    }

    public PostgreSchema createSchemaImpl(@NotNull PostgreDatabase owner, @NotNull String name, @Nullable PostgreRole postgreRole) {
        return new PostgreSchema(owner, name, postgreRole);
    }

    PostgreTableBase findTable(DBRProgressMonitor monitor, long schemaId, long tableId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema == null) {
            log.error((Object)("Catalog " + schemaId + " not found"));
            return null;
        }
        return schema.getTable(monitor, tableId);
    }

    @Nullable
    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return PostgreSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBSObjectState getObjectState() {
        if (!this.dataSource.isConnectionRefreshing() && this == this.dataSource.getDefaultInstance() || this.isSharedDatabase()) {
            return DBSObjectState.NORMAL;
        }
        return PostgreConstants.STATE_UNAVAILABLE;
    }

    public void refreshObjectState(@NotNull DBRProgressMonitor monitor) throws DBCException {
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sharedInstance == null && this.metaContext == null && this.executionContext == null) {
            return this;
        }
        this.readDatabaseInfo(monitor);
        this.roleCache.clearCache();
        this.accessMethodCache.clearCache();
        this.foreignDataWrapperCache.clearCache();
        this.foreignServerCache.clearCache();
        this.languageCache.clearCache();
        this.encodingCache.clearCache();
        this.eventTriggersCache.clearCache();
        this.extensionCache.clearCache();
        this.availableExtensionCache.clearCache();
        this.collationCache.clearCache();
        this.tablespaceCache.clearCache();
        this.jobCache.clearCache();
        this.jobClassCache.clearCache();
        this.schemaCache.clearCache();
        this.cacheDataTypes(monitor, true);
        this.enumValueCache.clearCache();
        return this;
    }

    public Collection<? extends PostgreRole> getUsers(DBRProgressMonitor monitor) throws DBException {
        if (!this.getDataSource().getServerType().supportsRoles()) {
            return Collections.emptyList();
        }
        this.checkInstanceConnection(monitor);
        return this.roleCache.getAllObjects(monitor, this);
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long schemaId, long procId) throws DBException {
        PostgreSchema schema = this.getSchema(monitor, schemaId);
        if (schema != null) {
            return (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.getProceduresCache(), schema, procId);
        }
        return null;
    }

    public PostgreProcedure getProcedure(DBRProgressMonitor monitor, long procId) throws DBException {
        for (PostgreSchema schema : this.getSchemas(monitor)) {
            PostgreProcedure procedure = (PostgreProcedure)PostgreUtils.getObjectById(monitor, schema.getProceduresCache(), schema, procId);
            if (procedure == null) continue;
            return procedure;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public PostgreDataType getDataType(DBRProgressMonitor monitor, long typeId) {
        PostgreDataType dataType;
        if (typeId <= 0L) {
            return null;
        }
        Object object = this.dataTypeCache;
        synchronized (object) {
            dataType = (PostgreDataType)this.dataTypeCache.get(typeId);
            if (dataType != null) {
                return dataType;
            }
        }
        for (PostgreSchema schema : this.schemaCache.getCachedObjects()) {
            dataType = schema.getDataTypeCache().getDataType(typeId);
            if (dataType == null) continue;
            LongKeyMap<PostgreDataType> longKeyMap = this.dataTypeCache;
            synchronized (longKeyMap) {
                this.dataTypeCache.put(typeId, (Object)dataType);
            }
            return dataType;
        }
        try {
            dataType = PostgreDataTypeCache.resolveDataType(monitor, this, typeId);
            ((PostgreSchema)dataType.getParentObject()).getDataTypeCache().cacheObject(dataType);
            object = this.dataTypeCache;
            synchronized (object) {
                this.dataTypeCache.put(dataType.getObjectId(), (Object)dataType);
            }
            return dataType;
        }
        catch (Exception e) {
            log.debug((Object)("Can't resolve data type " + typeId), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PostgreDataType getDataType(@Nullable DBRProgressMonitor monitor, String typeName) {
        PostgreDataType dataType;
        PostgreSchema schema;
        if (((String)typeName).endsWith("[]")) {
            typeName = "_" + ((String)typeName).substring(0, ((String)typeName).length() - 2);
        }
        if ((schema = this.getCatalogSchema()) != null && (dataType = (PostgreDataType)schema.getDataTypeCache().getCachedObject((String)typeName)) != null) {
            return dataType;
        }
        PostgreExecutionContext metaContext = this.getMetaContext();
        List<String> searchPath = metaContext == null ? Collections.singletonList("pg_catalog") : metaContext.getSearchPath();
        for (String schemaName : searchPath) {
            PostgreDataType dataType2;
            PostgreSchema schema2 = (PostgreSchema)this.schemaCache.getCachedObject(schemaName);
            if (schema2 == null || (dataType2 = (PostgreDataType)schema2.getDataTypeCache().getCachedObject((String)typeName)) == null) continue;
            return dataType2;
        }
        for (PostgreSchema schema3 : this.schemaCache.getCachedObjects()) {
            PostgreDataType dataType3;
            if (searchPath.contains(schema3.getName()) || (dataType3 = (PostgreDataType)schema3.getDataTypeCache().getCachedObject((String)typeName)) == null) continue;
            return dataType3;
        }
        if (monitor == null || monitor.isForceCacheUsage()) {
            return null;
        }
        try {
            PostgreDataType dataType4 = PostgreDataTypeCache.resolveDataType(monitor, this, (String)typeName);
            ((PostgreSchema)dataType4.getParentObject()).getDataTypeCache().cacheObject(dataType4);
            LongKeyMap<PostgreDataType> longKeyMap = this.dataTypeCache;
            synchronized (longKeyMap) {
                this.dataTypeCache.put(dataType4.getObjectId(), (Object)dataType4);
            }
            return dataType4;
        }
        catch (Exception e) {
            log.debug((Object)("Can't resolve data type '" + (String)typeName + "' in database '" + this.getName() + "'"));
            return null;
        }
    }

    public boolean hasStatistics() {
        return true;
    }

    public long getStatObjectSize() {
        return this.dbTotalSize;
    }

    public void setDbTotalSize(long dbTotalSize) {
        this.dbTotalSize = dbTotalSize;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    protected PostgreDatabaseJDBCObjectCache<? extends PostgreRole> createRoleCache() {
        return new RoleCache();
    }

    protected static abstract class PostgreDatabaseJDBCObjectCache<OBJECT extends DBSObject>
    extends JDBCObjectCache<PostgreDatabase, OBJECT> {
        protected PostgreDatabaseJDBCObjectCache() {
        }

        boolean handlePermissionDeniedError(Exception e) {
            if ("42501".equals(SQLState.getStateFromException((Throwable)e))) {
                log.warn((Object)e);
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    static class AccessMethodCache
    extends PostgreDatabaseJDBCObjectCache<PostgreAccessMethod> {
        AccessMethodCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT am.oid,am.* FROM pg_catalog.pg_am am \nORDER BY am.oid");
        }

        protected PostgreAccessMethod fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreAccessMethod(owner, (ResultSet)dbResult);
        }
    }

    static class ForeignDataWrapperCache
    extends PostgreDatabaseJDBCObjectCache<PostgreForeignDataWrapper> {
        ForeignDataWrapperCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.*,p.pronamespace as handler_schema_id \nFROM pg_catalog.pg_foreign_data_wrapper l\nLEFT OUTER JOIN pg_catalog.pg_proc p ON p.oid=l.fdwhandler \nORDER BY l.fdwname");
        }

        protected PostgreForeignDataWrapper fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignDataWrapper(owner, (ResultSet)dbResult);
        }
    }

    static class ForeignServerCache
    extends PostgreDatabaseJDBCObjectCache<PostgreForeignServer> {
        ForeignServerCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_foreign_server l\nORDER BY l.srvname");
        }

        protected PostgreForeignServer fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreForeignServer(owner, (ResultSet)dbResult);
        }
    }

    static class LanguageCache
    extends PostgreDatabaseJDBCObjectCache<PostgreLanguage> {
        LanguageCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT l.oid,l.* FROM pg_catalog.pg_language l \nORDER BY l.oid");
        }

        protected PostgreLanguage fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreLanguage(owner, (ResultSet)dbResult);
        }
    }

    static class EncodingCache
    extends PostgreDatabaseJDBCObjectCache<PostgreCharset> {
        EncodingCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT c.contoencoding as encid,pg_catalog.pg_encoding_to_char(c.contoencoding) as encname\nFROM pg_catalog.pg_conversion c\nGROUP BY c.contoencoding\nORDER BY 2\n");
        }

        protected PostgreCharset fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCharset(owner, (ResultSet)dbResult);
        }
    }

    static class EventTriggersCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreEventTrigger> {
        EventTriggersCache() {
        }

        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreEventTrigger object, @Nullable String objectName) throws SQLException {
            String statement = "SELECT pet.*, d.description FROM pg_catalog.pg_event_trigger pet\nLEFT OUTER JOIN pg_catalog.pg_description d ON pet.\"oid\" = d.objoid" + (object != null || CommonUtils.isNotEmpty((String)objectName) ? " WHERE pet.evtname = ?" : "");
            JDBCPreparedStatement prepareStatement = session.prepareStatement(statement);
            if (object != null || CommonUtils.isNotEmpty((String)objectName)) {
                prepareStatement.setString(1, object != null ? object.getName() : objectName);
            }
            return prepareStatement;
        }

        @Nullable
        protected PostgreEventTrigger fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String eventTriggerName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"evtname");
            if (CommonUtils.isEmpty((String)eventTriggerName)) {
                return null;
            }
            return new PostgreEventTrigger(database, eventTriggerName, resultSet);
        }

        protected boolean handleCacheReadError(@NotNull Exception error) {
            if ("42501".equals(SQLState.getStateFromException((Throwable)error))) {
                log.warn((Object)error);
                this.setCache(Collections.emptyList());
                return true;
            }
            return false;
        }
    }

    static class ExtensionCache
    extends PostgreDatabaseJDBCObjectCache<PostgreExtension> {
        ExtensionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT \n e.oid,\n cfg.tbls,\n  n.nspname as schema_name,\n e.* \nFROM \n pg_catalog.pg_extension e \n join pg_namespace n on n.oid =e.extnamespace\n left join  (\n         select\n            ARRAY_AGG(ns.nspname || '.' ||  cls.relname) tbls, oid_ext\n          from\n            (\n            select\n                unnest(e1.extconfig) oid , e1.oid oid_ext\n            from\n                pg_catalog.pg_extension e1 ) c \n                join    pg_class cls on cls.oid = c.oid \n                join pg_namespace ns on ns.oid = cls.relnamespace\n            group by oid_ext        \n         ) cfg on cfg.oid_ext = e.oid\nORDER BY e.oid");
        }

        protected PostgreExtension fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreExtension(owner, (ResultSet)dbResult);
        }
    }

    static class AvailableExtensionCache
    extends PostgreDatabaseJDBCObjectCache<PostgreAvailableExtension> {
        AvailableExtensionCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT name,default_version,installed_version,comment FROM pg_catalog.pg_available_extensions ORDER BY name");
        }

        protected PostgreAvailableExtension fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreAvailableExtension(owner, (ResultSet)dbResult);
        }
    }

    static class CollationCache
    extends PostgreDatabaseJDBCObjectCache<PostgreCollation> {
        CollationCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT c.oid,c.* FROM pg_catalog.pg_collation c \nORDER BY c.oid");
        }

        protected PostgreCollation fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreCollation(session.getProgressMonitor(), owner, (ResultSet)dbResult);
        }
    }

    static class TablespaceCache
    extends PostgreDatabaseJDBCObjectCache<PostgreTablespace> {
        TablespaceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            return session.prepareStatement("SELECT t.oid,t.*" + (owner.getDataSource().getServerType().supportsTablespaceLocation() ? ",pg_tablespace_location(t.oid) loc" : "") + "\nFROM pg_catalog.pg_tablespace t \nORDER BY t.oid");
        }

        protected PostgreTablespace fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreTablespace(owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(@NotNull Exception error) {
            log.debug((Object)"Error reading tablespaces", (Throwable)error);
            return true;
        }
    }

    public static class JobCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreJob> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreJob object, @Nullable String objectName) throws SQLException {
            StringBuilder sql = new StringBuilder("SELECT * FROM pgagent.pga_job");
            if (object != null) {
                sql.append(" WHERE jobid=").append(object.getObjectId());
            }
            return session.prepareStatement(sql.toString());
        }

        @Nullable
        protected PostgreJob fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreJob(session.getProgressMonitor(), database, (ResultSet)resultSet);
        }

        protected boolean handleCacheReadError(@NotNull Exception error) {
            DBWorkbench.getPlatformUI().showError("Error accessing pgAgent jobs", "Can't access pgAgent jobs.\n\nThis database may not have the extension installed or you don't have sufficient permissions to access them.\n\nIf you believe that this is DBeaver's fault, please report it.", (Throwable)error);
            this.setCache(Collections.emptyList());
            return true;
        }
    }

    public static class JobClassCache
    extends PostgreDatabaseJDBCObjectCache<PostgreJobClass> {
        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database) throws SQLException {
            return session.prepareStatement("SELECT * FROM pgagent.pga_jobclass");
        }

        @Nullable
        protected PostgreJobClass fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull JDBCResultSet dbResult) {
            return new PostgreJobClass(database, (ResultSet)dbResult);
        }
    }

    public static class EnumValueCache
    extends PostgreDatabaseJDBCObjectCache<PostgreEnumValue> {
        @NotNull
        public JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database) throws SQLException {
            if (!database.getDataSource().isSupportsEnumTable()) {
                return session.prepareStatement("SELECT 1");
            }
            return session.prepareStatement("SELECT * FROM pg_catalog.pg_enum");
        }

        @Nullable
        protected PostgreEnumValue fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new PostgreEnumValue(database.getDataSource(), database, resultSet);
        }
    }

    static class RoleCache
    extends PostgreDatabaseJDBCObjectCache<PostgreRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase owner) throws SQLException {
            boolean supportsCommentsOnRole = owner.getDataSource().getServerType().supportsCommentsOnRole();
            String sql = "SELECT a.oid,a.*" + (supportsCommentsOnRole ? ",pd.description" : "") + " FROM pg_catalog.pg_roles a " + (supportsCommentsOnRole ? "\nleft join pg_catalog.pg_shdescription pd on a.oid = pd.objoid" : "") + "\nORDER BY a.rolname";
            return session.prepareStatement(sql);
        }

        protected PostgreRole fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRole(owner, (ResultSet)dbResult);
        }

        protected boolean handleCacheReadError(@NotNull Exception error) {
            return this.handlePermissionDeniedError(error);
        }
    }

    public static class CharsetListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<PostgreCharset> tablespaces = object.getEncodings((DBRProgressMonitor)new VoidProgressMonitor());
                return tablespaces.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class RoleListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<? extends PostgreRole> roles = object.getAuthIds((DBRProgressMonitor)new VoidProgressMonitor());
                return roles.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class TablespaceListProvider
    implements IPropertyValueListProvider<PostgreDatabase> {
        public boolean allowCustomValue() {
            return false;
        }

        @Nullable
        public Object[] getPossibleValues(PostgreDatabase object) {
            try {
                Collection<PostgreTablespace> tablespaces = object.getTablespaces((DBRProgressMonitor)new VoidProgressMonitor());
                return tablespaces.toArray(new Object[0]);
            }
            catch (DBException e) {
                log.error((Object)e);
                return new Object[0];
            }
        }
    }

    public static class SchemaCache
    extends JDBCObjectLookupCache<PostgreDatabase, PostgreSchema> {
        @NotNull
        public JDBCStatement prepareLookupStatement(@NotNull JDBCSession session, @NotNull PostgreDatabase database, @Nullable PostgreSchema object, @Nullable String objectName) throws SQLException {
            StringBuilder catalogQuery = new StringBuilder("SELECT n.oid,n.*,d.description FROM pg_catalog.pg_namespace n\nLEFT OUTER JOIN pg_catalog.pg_description d ON d.objoid=n.oid AND d.objsubid=0 AND d.classoid='pg_namespace'::regclass\n");
            boolean extraConditionAdded = this.addExtraCondition(session, catalogQuery);
            DBSObjectFilter catalogFilters = database.getDataSource().getContainer().getObjectFilter(PostgreSchema.class, null, false);
            if (catalogFilters != null && !catalogFilters.isNotApplicable() || object != null || objectName != null) {
                if (object != null || objectName != null) {
                    catalogFilters = new DBSObjectFilter();
                    catalogFilters.addInclude(object != null ? object.getName() : objectName);
                } else {
                    List includeFilters = (catalogFilters = new DBSObjectFilter(catalogFilters)).getInclude();
                    if (!CommonUtils.isEmpty((Collection)includeFilters) && !includeFilters.contains("pg_catalog")) {
                        catalogFilters.addInclude("pg_catalog");
                    }
                }
                JDBCUtils.appendFilterClause((StringBuilder)catalogQuery, (DBSObjectFilter)catalogFilters, (String)"nspname", (!extraConditionAdded ? 1 : 0) != 0, (DBPDataSource)database.getDataSource());
            }
            catalogQuery.append(" ORDER BY nspname");
            JDBCPreparedStatement dbStat = session.prepareStatement(catalogQuery.toString());
            if (catalogFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)catalogFilters);
            }
            return dbStat;
        }

        protected PostgreSchema fetchObject(@NotNull JDBCSession session, @NotNull PostgreDatabase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            String name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"nspname");
            if (name == null) {
                log.debug((Object)"Skipping schema with NULL name");
                return null;
            }
            if (PostgreSchema.isUtilitySchema(name) && !owner.getDataSource().getContainer().getNavigatorSettings().isShowUtilityObjects()) {
                return null;
            }
            return owner.createSchemaImpl(owner, name, resultSet);
        }

        protected boolean addExtraCondition(@NotNull JDBCSession session, @NotNull StringBuilder query) {
            return false;
        }
    }
}

