/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.runtime.IPluginService;

public class PluginServiceRegistry {
    private static final Log log = Log.getLog(PluginServiceRegistry.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.pluginService";
    private static PluginServiceRegistry instance = null;
    private final List<IPluginService> services = new ArrayList<IPluginService>();

    public static synchronized PluginServiceRegistry getInstance() {
        if (instance == null) {
            instance = new PluginServiceRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private PluginServiceRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement ext : extElements = registry.getConfigurationElementsFor(EXTENSION_ID)) {
            ServiceDescriptor serviceDescriptor = new ServiceDescriptor(this, ext);
            try {
                IPluginService pluginService = (IPluginService)serviceDescriptor.type.createInstance(IPluginService.class);
                this.services.add(pluginService);
            }
            catch (DBException e) {
                log.error((Object)"Can't create plugin service", (Throwable)e);
            }
        }
    }

    public List<IPluginService> getServices() {
        return this.services;
    }

    private class ServiceDescriptor
    extends AbstractDescriptor {
        private final AbstractDescriptor.ObjectType type;

        protected ServiceDescriptor(PluginServiceRegistry pluginServiceRegistry, IConfigurationElement config) {
            super(config);
            this.type = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        }
    }
}

