/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPAttributeReferencePurpose;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.DBPVirtualObject;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeFilter;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.data.DBDVoid;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProviderExt;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformerExt;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeDynamic;
import org.jkiss.dbeaver.model.struct.DBSContextBoundAttribute;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSObjectWithType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSPartitionContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTablePartition;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public final class DBUtils {
    private static final Log log = Log.getLog(DBUtils.class);

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPNamedObject object) {
        String string;
        if (object instanceof DBSContextBoundAttribute) {
            DBSContextBoundAttribute cba = (DBSContextBoundAttribute)object;
            return cba.formatMemberReference(false, null, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        if (object instanceof DBSObject) {
            DBSObject dbo = (DBSObject)object;
            string = DBUtils.getQuotedIdentifier(dbo.getDataSource(), object.getName());
        } else {
            string = object.getName();
        }
        return string;
    }

    public static void closeSafely(@NotNull AutoCloseable object) {
        try {
            object.close();
        }
        catch (Exception e) {
            log.error("Error when closing object '" + String.valueOf(object) + "'", e);
        }
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBSObject object) {
        if (object instanceof DBSContextBoundAttribute) {
            DBSContextBoundAttribute cba = (DBSContextBoundAttribute)object;
            return cba.formatMemberReference(false, null, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        return DBUtils.getQuotedIdentifier(object.getDataSource(), object.getName());
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBSObject object, @NotNull DBPAttributeReferencePurpose purpose) {
        if (object instanceof DBSContextBoundAttribute) {
            DBSContextBoundAttribute cba = (DBSContextBoundAttribute)object;
            return cba.formatMemberReference(false, null, purpose);
        }
        return DBUtils.getQuotedIdentifier(object.getDataSource(), object.getName());
    }

    public static boolean isQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return dataSource.getSQLDialect().isQuotedIdentifier(str);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return dataSource.getSQLDialect().getUnquotedIdentifier(str);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String[][] quoteStrings) {
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            quoteStrings = BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
        }
        for (String[] quoteString : quoteStrings) {
            str = DBUtils.getUnQuotedIdentifier(str, quoteString[0], quoteString[1]);
        }
        return str;
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote) {
        return DBUtils.getUnQuotedIdentifier(str, quote, quote);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote1, @NotNull String quote2) {
        if (str.length() >= quote1.length() + quote2.length() && str.startsWith(quote1) && str.endsWith(quote2)) {
            return str.substring(quote1.length(), str.length() - quote2.length());
        }
        return str;
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return DBUtils.getQuotedIdentifier(dataSource, str, true, false);
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str, boolean caseSensitiveNames, boolean quoteAlways) {
        return dataSource.getSQLDialect().getQuotedIdentifier(str, caseSensitiveNames, quoteAlways);
    }

    @NotNull
    public static String getFullQualifiedName(@Nullable DBPDataSource dataSource, DBPNamedObject ... path) {
        StringBuilder name = new StringBuilder(20 * path.length);
        if (dataSource == null) {
            for (DBPNamedObject namePart : path) {
                if (DBUtils.isVirtualObject(namePart)) continue;
                if (!name.isEmpty()) {
                    name.append('.');
                }
                name.append(namePart.getName());
            }
        } else {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            DBPNamedObject parent = null;
            for (DBPNamedObject namePart : path) {
                if (namePart == null || DBUtils.isVirtualObject(namePart) || namePart instanceof DBSCatalog && (sqlDialect.getCatalogUsage() & 1) == 0 || namePart instanceof DBSSchema && (sqlDialect.getSchemaUsage() & 1) == 0 || !DBUtils.isValidObjectName(namePart.getName())) continue;
                if (!name.isEmpty()) {
                    if (parent instanceof DBSCatalog) {
                        if (!sqlDialect.isCatalogAtStart()) {
                            log.warn("Catalog name should be at the start of full-qualified name!");
                        }
                        name.append(sqlDialect.getCatalogSeparator());
                    } else {
                        name.append(sqlDialect.getStructSeparator());
                    }
                }
                name.append(DBUtils.getQuotedIdentifier(dataSource, namePart.getName()));
                parent = namePart;
            }
        }
        return name.toString();
    }

    @NotNull
    public static String getSimpleQualifiedName(Object ... names) {
        StringBuilder name = new StringBuilder(names.length * 16);
        for (Object namePart : names) {
            if (namePart == null) continue;
            if (!name.isEmpty() && name.charAt(name.length() - 1) != '.') {
                name.append('.');
            }
            name.append(namePart);
        }
        return name.toString();
    }

    @NotNull
    public static String getFullyQualifiedName(@NotNull DBPDataSource dataSource, String ... names) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        StringBuilder name = new StringBuilder(names.length * 16);
        for (String namePart : names) {
            if (namePart == null) continue;
            if (!name.isEmpty()) {
                name.append(dialect.getStructSeparator());
            }
            name.append(DBUtils.getQuotedIdentifier(dataSource, namePart));
        }
        return name.toString();
    }

    public static boolean isValidObjectName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isWhitespace(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static DBSObject getObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer rootSC, @Nullable String catalogName, @Nullable String schemaName, @Nullable String objectName) throws DBException {
        Class<? extends DBSObject> childType;
        if (!CommonUtils.isEmpty((String)catalogName) && (DBSSchema.class.isAssignableFrom(childType = rootSC.getPrimaryChildType(monitor)) || DBSEntity.class.isAssignableFrom(childType))) {
            catalogName = null;
        }
        if (!CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty((String)schemaName)) {
            DBSObject catalog = rootSC.getChild(monitor, catalogName);
            if (!(catalog instanceof DBSObjectContainer)) {
                return null;
            }
            DBSObjectContainer catalogOC = (DBSObjectContainer)catalog;
            rootSC = catalogOC;
            DBSObject schema = rootSC.getChild(monitor, schemaName);
            if (!(schema instanceof DBSObjectContainer)) {
                return null;
            }
            DBSObjectContainer schemaOC = (DBSObjectContainer)schema;
            rootSC = schemaOC;
        } else if (!CommonUtils.isEmpty((String)catalogName) || !CommonUtils.isEmpty((String)schemaName)) {
            DBSObject child;
            DBSCatalog catalog;
            Class<? extends DBSObject> childType2;
            String containerName = !CommonUtils.isEmpty((String)catalogName) ? catalogName : schemaName;
            DBSObject sc = rootSC.getChild(monitor, containerName);
            if (!DBStructUtils.isConnectedContainer(sc)) {
                sc = null;
            }
            if (!(sc instanceof DBSObjectContainer)) {
                DBSObject selectedObject = DBUtils.getSelectedObject(executionContext);
                if (selectedObject instanceof DBSObjectContainer) {
                    if (selectedObject instanceof DBSSchema && selectedObject.getParentObject() instanceof DBSCatalog && CommonUtils.isEmpty((String)catalogName) && !CommonUtils.equalObjects((Object)schemaName, (Object)selectedObject.getName())) {
                        selectedObject = selectedObject.getParentObject();
                    }
                    if (selectedObject instanceof DBSSchema && CommonUtils.equalObjects((Object)schemaName, (Object)selectedObject.getName()) || selectedObject instanceof DBSCatalog && CommonUtils.equalObjects((Object)catalogName, (Object)selectedObject.getName())) {
                        sc = selectedObject;
                    } else if (selectedObject instanceof DBSObjectContainer) {
                        DBSObjectContainer objectContainer = (DBSObjectContainer)selectedObject;
                        sc = objectContainer.getChild(monitor, containerName);
                    }
                }
                if (!(sc instanceof DBSObjectContainer)) {
                    return null;
                }
            } else if (CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty((String)schemaName) && sc instanceof DBSCatalog && DBSSchema.class.isAssignableFrom(childType2 = (catalog = (DBSCatalog)sc).getPrimaryChildType(monitor)) && (child = catalog.getChild(monitor, schemaName)) instanceof DBSSchema) {
                sc = child;
            }
            rootSC = (DBSObjectContainer)sc;
        }
        if (objectName == null) {
            return rootSC;
        }
        DBSObject object = rootSC.getChild(monitor, objectName);
        if (object instanceof DBSEntity) {
            return object;
        }
        DBSObject selectedObject = DBUtils.getSelectedObject(executionContext);
        if (selectedObject instanceof DBSObjectContainer) {
            DBSObjectContainer oc = (DBSObjectContainer)selectedObject;
            return oc.getChild(monitor, objectName);
        }
        return object;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName) {
        return DBUtils.findObject(theList, objectName, false);
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName, boolean caseInsensitive) {
        if (theList != null && !theList.isEmpty()) {
            for (DBPNamedObject object : theList) {
                if (!(caseInsensitive ? object.getName().equalsIgnoreCase(objectName) : object.getName().equals(objectName))) continue;
                return (T)object;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable T[] theList, String objectName) {
        if (theList != null) {
            for (T object : theList) {
                if (!object.getName().equals(objectName)) continue;
                return object;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> List<T> findObjects(@Nullable Collection<T> theList, @Nullable String objectName) {
        if (theList != null && !theList.isEmpty()) {
            ArrayList<DBPNamedObject> result = new ArrayList<DBPNamedObject>();
            for (DBPNamedObject object : theList) {
                if (!object.getName().equalsIgnoreCase(objectName)) continue;
                result.add(object);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public static <T> T getAdapter(@NotNull Class<T> adapterType, @Nullable Object object) {
        if (object instanceof DBPDataSourceContainer) {
            DBPDataSourceContainer ds = (DBPDataSourceContainer)object;
            object = ds.getDataSource();
        }
        if (object == null) {
            return null;
        }
        if (adapterType.isAssignableFrom(object.getClass())) {
            return adapterType.cast(object);
        }
        if (object instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)object;
            return (T)adaptable.getAdapter(adapterType);
        }
        return null;
    }

    @Nullable
    public static <T> T getParentAdapter(@NotNull Class<T> i, DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject parent = object.getParentObject();
        if (parent == null) {
            return null;
        }
        T adapter = DBUtils.getAdapter(i, parent);
        return adapter == object ? null : (T)adapter;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBSObject object) {
        if (object == null) {
            return null;
        }
        for (DBSObject parent = object.getParentObject(); parent != null && (parent = DBUtils.getPublicObject(parent)) != null; parent = parent.getParentObject()) {
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBPDataSource || parent instanceof DBPDataSourceContainer) break;
        }
        return null;
    }

    public static boolean isParentOf(@NotNull DBSObject child, @NotNull DBSObject parent) {
        for (DBSObject object = child; object != null; object = object.getParentObject()) {
            if (!parent.equals(object)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static DBSObject[] getObjectPath(@NotNull DBSObject object, boolean includeSelf) {
        DBSTablePartition part;
        DBSObject root;
        int depth = 0;
        for (DBSObject obj = root = includeSelf ? object : (object instanceof DBSTablePartition && (part = (DBSTablePartition)object).needFullPath() && part.isSubPartition() ? part.getPartitionParent() : object.getParentObject()); obj != null; obj = obj.getParentObject()) {
            obj = DBUtils.getPublicObjectContainer(obj);
            ++depth;
        }
        if (object instanceof DBSTablePartition && (part = (DBSTablePartition)object).needFullPath()) {
            ++depth;
        }
        DBSObject[] path = new DBSObject[depth];
        for (DBSObject obj = root; obj != null; obj = obj.getParentObject()) {
            DBSTablePartition part2;
            obj = DBUtils.getPublicObjectContainer(obj);
            path[depth-- - 1] = obj;
            if (!(obj instanceof DBSTablePartition) || !(part2 = (DBSTablePartition)obj).needFullPath()) continue;
            path[depth-- - 1] = part2.getParentTable();
        }
        return path;
    }

    public static String getObjectFullId(@NotNull DBSObject object) {
        DBSObject[] path = DBUtils.getObjectPath(object, true);
        StringBuilder pathStr = new StringBuilder();
        for (DBSObject obj : path) {
            if (DBUtils.isVirtualObject(obj)) continue;
            if (!pathStr.isEmpty()) {
                pathStr.append('/');
            }
            if ((obj = DBUtils.getPublicObjectContainer(obj)) instanceof DBPDataSourceContainer) {
                DBPDataSourceContainer ds = (DBPDataSourceContainer)obj;
                pathStr.append(ds.getId());
                continue;
            }
            pathStr.append(obj.getName());
        }
        return pathStr.toString();
    }

    @NotNull
    public static String getObjectNameFromId(@NotNull String objectId) {
        String[] parts = objectId.split("/");
        return parts[parts.length - 1];
    }

    @Nullable
    public static DBSObject findObjectById(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String objectId) throws DBException {
        DBPDataSource dataSource;
        String[] names = objectId.split("/");
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSource(names[0]);
        if (dataSourceContainer == null) {
            log.debug("Can't find datasource '" + names[0] + "' in project " + project.getName());
            return null;
        }
        if (names.length == 1) {
            return dataSourceContainer;
        }
        if (!dataSourceContainer.isConnected()) {
            try {
                dataSourceContainer.connect(monitor, true, true);
            }
            catch (DBException e) {
                throw new DBException("Error connecting to datasource '" + dataSourceContainer.getName() + "'", e);
            }
        }
        if ((dataSource = dataSourceContainer.getDataSource()) == null) {
            log.debug("Null datasource in container " + dataSourceContainer.getId());
            return null;
        }
        DBSObjectContainer sc = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        DBSEntity finalEntity = null;
        if (sc != null) {
            for (int i = 1; i < names.length - 1; ++i) {
                DBSObjectContainer oc;
                String name = names[i];
                DBSObject child = sc.getChild(monitor, name);
                if (child == null) {
                    log.debug("Can't find child container " + name + " in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                    return null;
                }
                if (!(child instanceof DBSObjectContainer)) {
                    if (child instanceof DBSEntity) {
                        DBSEntity entity = (DBSEntity)child;
                        if (i == names.length - 2) {
                            sc = null;
                            finalEntity = entity;
                            break;
                        }
                    }
                    log.debug("Child object '" + name + "' is not a container or entity");
                    return null;
                }
                sc = oc = (DBSObjectContainer)child;
            }
        }
        String objectName = names[names.length - 1];
        if (sc != null) {
            DBSObject object = sc.getChild(monitor, objectName);
            if (object == null) {
                log.debug("Child object '" + objectName + "' not found in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                throw new DBException("Child object '" + objectName + "' not found in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
            }
            return object;
        }
        if (finalEntity != null) {
            DBSEntityAttribute attribute = finalEntity.getAttribute(monitor, objectName);
            if (attribute != null) {
                return attribute;
            }
            if (finalEntity instanceof DBSTable) {
                DBSTablePartition partition;
                DBSPartitionContainer partitionContainer;
                Collection<? extends DBSTablePartition> partitions;
                DBSTableIndex index;
                DBSTrigger trigger;
                DBSTable table = (DBSTable)finalEntity;
                List<? extends DBSTrigger> triggers = table.getTriggers(monitor);
                if (triggers != null && (trigger = DBUtils.findObject(triggers, objectName)) != null) {
                    return trigger;
                }
                Collection<? extends DBSTableIndex> indices = table.getIndexes(monitor);
                if (indices != null && (index = DBUtils.findObject(indices, objectName)) != null) {
                    return index;
                }
                if (finalEntity instanceof DBSPartitionContainer && !CommonUtils.isEmpty(partitions = (partitionContainer = (DBSPartitionContainer)((Object)finalEntity)).getPartitions(monitor)) && (partition = DBUtils.findObject(partitions, objectName)) != null) {
                    return partition;
                }
                log.debug("Object '" + objectName + "' not found in entity " + DBUtils.getObjectFullName(finalEntity, DBPEvaluationContext.UI));
                return null;
            }
        }
        return null;
    }

    @Nullable
    public static DBPDataSourceContainer findDataSourceByObjectId(@NotNull DBPProject project, @NotNull String objectId) {
        return project.getDataSourceRegistry().getDataSource(objectId.split("/")[0]);
    }

    public static boolean isNullValue(@Nullable Object value) {
        DBDValue dbv;
        return value == null || value instanceof DBDValue && (dbv = (DBDValue)value).isNull();
    }

    public static boolean isErrorValue(@Nullable Object value) {
        return value instanceof DBDValueError;
    }

    @Nullable
    public static Object makeNullValue(@NotNull DBCSession session, @NotNull DBDValueHandler valueHandler, @NotNull DBSTypedObject type) throws DBCException {
        return valueHandler.getValueFromObject(session, type, null, false, false);
    }

    @NotNull
    public static DBDAttributeBindingMeta getAttributeBinding(@NotNull DBSDataContainer dataContainer, @NotNull DBCSession session, @NotNull DBCAttributeMetaData attributeMeta) {
        return new DBDAttributeBindingMeta(dataContainer, session, attributeMeta);
    }

    @NotNull
    public static DBDAttributeBinding[] getAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSetMetaData metaData) {
        List<? extends DBCAttributeMetaData> metaAttributes = metaData.getAttributes();
        int columnsCount = metaAttributes.size();
        DBDAttributeBinding[] bindings = new DBDAttributeBinding[columnsCount];
        for (int i = 0; i < columnsCount; ++i) {
            bindings[i] = DBUtils.getAttributeBinding(dataContainer, session, metaAttributes.get(i));
        }
        return DBUtils.injectAndFilterAttributeBindings(session.getDataSource(), dataContainer, bindings, false);
    }

    @NotNull
    public static DBDAttributeBinding[] injectAndFilterAttributeBindings(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer dataContainer, @NotNull DBDAttributeBinding[] bindings, boolean filterAttributes) {
        List<DBVEntityAttribute> customAttributes;
        DBVEntity vEntity = DBVUtils.getVirtualEntity(dataContainer, false);
        if (vEntity != null && !CommonUtils.isEmpty(customAttributes = DBVUtils.getCustomAttributes(vEntity))) {
            DBDAttributeBinding[] customBindings = new DBDAttributeBinding[customAttributes.size()];
            for (int i = 0; i < customAttributes.size(); ++i) {
                customBindings[i] = new DBDAttributeBindingCustom(null, dataContainer, dataSource, customAttributes.get(i), bindings.length + i);
            }
            DBDAttributeBinding[] combinedAttrs = new DBDAttributeBinding[bindings.length + customBindings.length];
            System.arraycopy(bindings, 0, combinedAttrs, 0, bindings.length);
            System.arraycopy(customBindings, 0, combinedAttrs, bindings.length, customBindings.length);
            bindings = combinedAttrs;
        }
        if (filterAttributes && dataContainer instanceof DBDAttributeFilter) {
            DBDAttributeFilter attributeFilter = (DBDAttributeFilter)dataContainer;
            return attributeFilter.filterAttributeBindings(bindings);
        }
        return bindings;
    }

    @Nullable
    public static Object getAttributeValue(@NotNull DBDAttributeBinding attribute, @NotNull DBDAttributeBinding[] allAttributes, @NotNull Object[] row) {
        return DBUtils.getAttributeValue(attribute, allAttributes, row, null, false);
    }

    @Nullable
    public static Object getAttributeValue(@NotNull DBDAttributeBinding attribute, @NotNull DBDAttributeBinding[] allAttributes, @NotNull Object[] row, @Nullable int[] nestedIndexes, boolean retrieveDeepestCollectionElement) {
        if (attribute.isCustom()) {
            try {
                return DBVUtils.executeExpression(((DBDAttributeBindingCustom)attribute).getEntityAttribute(), allAttributes, row);
            }
            catch (Exception e) {
                return new DBDValueError(e);
            }
        }
        int depth = attribute.getLevel();
        int index = attribute.getTopParent().getOrdinalPosition();
        if (depth == 0 && attribute != attribute.getTopParent()) {
            log.debug("Top-level attribute '" + attribute.getName() + "' has bad top-level parent: '" + attribute.getTopParent().getName() + "'");
            return null;
        }
        if (index >= row.length) {
            log.debug("Bad attribute '" + attribute.getName() + "' index: " + index + " is out of row values' bounds (" + row.length + ")");
            return null;
        }
        int remainingIndices = nestedIndexes != null ? nestedIndexes.length : 0;
        int remainingAttributes = depth;
        Object curValue = row[index];
        while ((remainingAttributes > 0 || remainingIndices > 0 || retrieveDeepestCollectionElement) && curValue != null) {
            if (!(curValue instanceof DBDCollection)) {
                if (remainingAttributes == 0) {
                    return DBDVoid.INSTANCE;
                }
                DBDAttributeBinding parent = Objects.requireNonNull(attribute.getParent(--remainingAttributes));
                try {
                    curValue = parent.extractNestedValue(curValue, 0);
                }
                catch (DBException e) {
                    return new DBDValueError(e);
                }
            }
            while (curValue instanceof DBDCollection) {
                int itemIndex;
                DBDCollection collection = (DBDCollection)curValue;
                if (remainingIndices > 0) {
                    itemIndex = nestedIndexes[nestedIndexes.length - remainingIndices];
                    --remainingIndices;
                } else if (retrieveDeepestCollectionElement) {
                    itemIndex = 0;
                } else {
                    return curValue;
                }
                if (itemIndex >= collection.getItemCount()) {
                    return DBDVoid.INSTANCE;
                }
                curValue = collection.get(itemIndex);
            }
            if (!retrieveDeepestCollectionElement || remainingAttributes != 0) continue;
            return curValue;
        }
        return curValue;
    }

    public static void updateAttributeValue(@NotNull DBDValue rootValue, @NotNull DBDAttributeBinding attribute, @Nullable int[] nestedIndexes, @Nullable Object elementValue) throws DBCException {
        int depth = attribute.getLevel();
        if (depth == 0 && attribute != attribute.getTopParent()) {
            throw new DBCException("Top-level attribute '" + attribute.getName() + "' has bad top-level parent: '" + attribute.getTopParent().getName() + "'");
        }
        Object curValue = rootValue;
        Object ownerValue = null;
        int remainingIndices = nestedIndexes != null ? nestedIndexes.length : 0;
        int remainingAttributes = depth;
        while (remainingAttributes + remainingIndices > 0 && curValue != null) {
            if (!(curValue instanceof DBDCollection)) {
                if (remainingAttributes == 0) {
                    throw new DBCException("Cannot update complex attribute: out of nested attributes");
                }
                DBDAttributeBinding parent = Objects.requireNonNull(attribute.getParent(--remainingAttributes));
                try {
                    ownerValue = curValue;
                    curValue = parent.extractNestedValue(curValue, 0);
                }
                catch (DBException e) {
                    throw new DBCException("Error extracting nested value", e);
                }
            }
            while (curValue instanceof DBDCollection) {
                DBDCollection collection = (DBDCollection)curValue;
                if (remainingIndices <= 0) {
                    throw new DBCException("Out of indexes for collections");
                }
                int itemIndex = nestedIndexes[nestedIndexes.length - remainingIndices];
                --remainingIndices;
                if (itemIndex >= collection.getItemCount()) {
                    throw new DBCException("Item index out of range " + itemIndex + ">=" + collection.getItemCount());
                }
                ownerValue = curValue;
                curValue = collection.get(itemIndex);
            }
        }
        Object object = ownerValue;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DBDCollection.class, DBDComposite.class}, object, n)) {
            case -1: {
                throw new DBCException("Cannot determine owner value for update");
            }
            case 0: {
                DBDCollection collection = (DBDCollection)object;
                collection.setItem(nestedIndexes[nestedIndexes.length - 1], elementValue);
                break;
            }
            case 1: {
                DBDComposite composite = (DBDComposite)object;
                composite.setAttributeValue(attribute, elementValue);
                break;
            }
            default: {
                throw new DBCException("Don't know how to update complex value '" + String.valueOf(ownerValue) + "' (" + ownerValue.getClass().getSimpleName() + ")");
            }
        }
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBCSession session, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(session.getDataSource(), session, column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(dataSource, dataSource.getContainer(), column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@Nullable DBPDataSource dataSource, @Nullable DBDFormatSettings preferences, @NotNull DBSTypedObject column) {
        DBDValueHandler valueHandler = null;
        DBDValueHandlerProvider handlerProvider = DBUtils.getAdapter(DBDValueHandlerProvider.class, dataSource);
        if (handlerProvider != null && (valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column)) != null) {
            return valueHandler;
        }
        if (dataSource != null && (handlerProvider = DBWorkbench.getPlatform().getValueHandlerRegistry().getValueHandlerProvider(dataSource, column)) != null) {
            valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column);
        }
        if (valueHandler == null) {
            valueHandler = preferences == null ? DefaultValueHandler.INSTANCE : preferences.getDefaultValueHandler();
        }
        return valueHandler;
    }

    public static boolean isIdentifyingAssociation(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        if (!(association instanceof DBSEntityReferrer)) {
            return false;
        }
        DBSEntityReferrer referrer = (DBSEntityReferrer)((Object)association);
        DBSEntity refEntity = association.getAssociatedEntity();
        DBSEntity ownerEntity = association.getParentObject();
        if (refEntity == ownerEntity) {
            return false;
        }
        List<DBSEntityAttribute> ownAttrs = DBUtils.getEntityAttributes(monitor, referrer);
        Collection<? extends DBSEntityConstraint> constraints = ownerEntity.getConstraints(monitor);
        if (constraints != null) {
            boolean hasPrimaryKey = false;
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
                hasPrimaryKey = true;
                break;
            }
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (!(dBSEntityConstraint instanceof DBSEntityReferrer)) continue;
                DBSEntityReferrer eref = (DBSEntityReferrer)dBSEntityConstraint;
                if ((!hasPrimaryKey || dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) && (hasPrimaryKey || !dBSEntityConstraint.getConstraintType().isUnique())) continue;
                List<DBSEntityAttribute> constAttrs = DBUtils.getEntityAttributes(monitor, eref);
                boolean included = true;
                for (DBSEntityAttribute attr : ownAttrs) {
                    if (constAttrs.contains(attr)) continue;
                    included = false;
                    break;
                }
                if (!included) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOptionalAssociation(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        if (!(association instanceof DBSEntityReferrer)) {
            return false;
        }
        DBSEntityReferrer eref = (DBSEntityReferrer)((Object)association);
        for (DBSEntityAttributeRef ref : CommonUtils.safeCollection(eref.getAttributeReferences(monitor))) {
            if (ref.getAttribute() == null || ref.getAttribute().isRequired()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDefaultDataTypeName(@NotNull DBSObject objectContainer, DBPDataKind dataKind) {
        if (objectContainer instanceof DBPDataTypeProvider) {
            DBPDataTypeProvider dtp = (DBPDataTypeProvider)((Object)objectContainer);
            return dtp.getDefaultDataTypeName(dataKind);
        }
        return "?";
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull Collection<DBDAttributeBinding> bindings, @NotNull DBSAttributeBase attribute) {
        for (DBDAttributeBinding binding : bindings) {
            DBDAttributeBinding subBinding;
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings == null || (subBinding = DBUtils.findBinding(nestedBindings, attribute)) == null) continue;
            return subBinding;
        }
        return null;
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull DBDAttributeBinding[] bindings, @Nullable DBSAttributeBase attribute) {
        if (attribute == null) {
            return null;
        }
        for (DBDAttributeBinding binding : bindings) {
            DBDAttributeBinding subBinding;
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings == null || (subBinding = DBUtils.findBinding(nestedBindings, attribute)) == null) continue;
            return subBinding;
        }
        return null;
    }

    @NotNull
    public static List<DBSEntityReferrer> getAttributeReferrers(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute entityAttribute, boolean includeVirtual) throws DBException {
        Collection<DBSEntityAssociation> associations;
        DBSEntity entity = entityAttribute.getParentObject();
        Collection<DBSEntityAssociation> collection = associations = includeVirtual ? DBVUtils.getAllAssociations(monitor, entity) : entity.getAssociations(monitor);
        if (associations != null) {
            ArrayList<DBSEntityReferrer> refs = new ArrayList<DBSEntityReferrer>();
            for (DBSEntityAssociation fk : associations) {
                DBSEntityReferrer referrer;
                if (!(fk instanceof DBSEntityReferrer) || DBUtils.getConstraintAttribute(monitor, referrer = (DBSEntityReferrer)((Object)fk), entityAttribute) == null) continue;
                refs.add((DBSEntityReferrer)((Object)fk));
            }
            return refs;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static List<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        Collection<? extends DBSEntityConstraint> uniqueKeys;
        DBSTable table;
        if (entity instanceof DBSTable && (table = (DBSTable)entity).isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty(entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityConstraint> identifiers = new ArrayList<DBSEntityConstraint>();
        if (entity instanceof DBSTable) {
            DBSTable table2 = (DBSTable)entity;
            try {
                Collection<? extends DBSTableIndex> indexes = table2.getIndexes(monitor);
                if (!CommonUtils.isEmpty(indexes)) {
                    for (DBSTableIndex dBSTableIndex : indexes) {
                        if (!DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                        identifiers.add(dBSTableIndex);
                    }
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (identifiers.isEmpty() && (uniqueKeys = entity.getConstraints(monitor)) != null) {
            for (DBSEntityConstraint dBSEntityConstraint : uniqueKeys) {
                if (!DBUtils.isIdentifierConstraint(monitor, dBSEntityConstraint)) continue;
                identifiers.add(dBSEntityConstraint);
            }
        }
        if (!identifiers.isEmpty()) {
            List<Object> list;
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                DBSTableIndex tableIndex;
                if (dBSEntityConstraint instanceof DBSEntityReferrer) {
                    DBSEntityReferrer dBSEntityReferrer = (DBSEntityReferrer)dBSEntityConstraint;
                    if (dBSEntityConstraint.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                        return DBUtils.getEntityAttributes(monitor, dBSEntityReferrer);
                    }
                }
                if (dBSEntityConstraint.getConstraintType().isUnique()) {
                    uniqueId = dBSEntityConstraint;
                    continue;
                }
                if (!(dBSEntityConstraint instanceof DBSTableIndex) || !(tableIndex = (DBSTableIndex)dBSEntityConstraint).isUnique()) continue;
                uniqueId = dBSEntityConstraint;
            }
            if (uniqueId instanceof DBSEntityReferrer) {
                DBSEntityReferrer referrer = (DBSEntityReferrer)uniqueId;
                list = DBUtils.getEntityAttributes(monitor, referrer);
            } else {
                list = Collections.emptyList();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static boolean isIdentifierIndex(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        if (!index.isUnique()) {
            return false;
        }
        List<? extends DBSTableIndexColumn> attrs = index.getAttributeReferences(monitor);
        if (attrs == null || attrs.isEmpty()) {
            return false;
        }
        for (DBSTableIndexColumn dBSTableIndexColumn : attrs) {
            if (dBSTableIndexColumn.getTableColumn() != null && dBSTableIndexColumn.getTableColumn().isRequired()) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierConstraint(DBRProgressMonitor monitor, DBSEntityConstraint constraint) throws DBException {
        if (constraint.getConstraintType().isUnique()) {
            if (constraint instanceof DBSEntityReferrer) {
                DBSEntityReferrer referrer = (DBSEntityReferrer)constraint;
                List<? extends DBSEntityAttributeRef> attrs = referrer.getAttributeReferences(monitor);
                if (attrs == null || attrs.isEmpty()) {
                    return false;
                }
                for (DBSEntityAttributeRef dBSEntityAttributeRef : attrs) {
                    if (dBSEntityAttributeRef.getAttribute() != null && dBSEntityAttributeRef.getAttribute().isRequired() || constraint.getDataSource().getInfo().supportsNullableUniqueConstraints()) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static DBSEntityConstraint findEntityConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        DBSTable table;
        Collection<? extends DBSTableIndex> collection;
        Collection<? extends DBSEntityConstraint> constraints = entity.getConstraints(monitor);
        if (!CommonUtils.isEmpty(constraints)) {
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                DBSEntityReferrer referrer;
                if (!(dBSEntityConstraint instanceof DBSEntityReferrer) || !DBUtils.referrerMatches(monitor, referrer = (DBSEntityReferrer)dBSEntityConstraint, attributes)) continue;
                return dBSEntityConstraint;
            }
        }
        if (entity instanceof DBSTable && !CommonUtils.isEmpty(collection = (table = (DBSTable)entity).getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : collection) {
                if (!dBSTableIndex.isUnique() || !DBUtils.referrerMatches(monitor, dBSTableIndex, attributes)) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    public static boolean referrerMatches(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer referrer, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        List<? extends DBSEntityAttributeRef> refs = referrer.getAttributeReferences(monitor);
        if (refs != null && !refs.isEmpty() && attributes.size() == refs.size()) {
            Iterator<? extends DBSEntityAttribute> attrIterator = attributes.iterator();
            for (DBSEntityAttributeRef dBSEntityAttributeRef : refs) {
                if (!attrIterator.hasNext()) {
                    return false;
                }
                if (dBSEntityAttributeRef.getAttribute() != null && CommonUtils.equalObjects((Object)dBSEntityAttributeRef.getAttribute().getName(), (Object)attrIterator.next().getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<DBSEntityAttribute> getEntityAttributes(@NotNull DBRProgressMonitor monitor, @Nullable DBSEntityReferrer referrer) {
        try {
            DBSEntity realEntity;
            DBVEntityConstraint ec;
            if (referrer instanceof DBVEntityConstraint && (ec = (DBVEntityConstraint)referrer).isUseAllColumns() && (realEntity = ec.getEntity().getRealEntity(monitor)) != null) {
                List<? extends DBSEntityAttribute> attributes = realEntity.getAttributes(monitor);
                return attributes == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(attributes);
            }
        }
        catch (DBException e) {
            log.error("Error discovering virtual constraint attributes", e);
        }
        List<? extends DBSEntityAttributeRef> constraintColumns = null;
        if (referrer != null) {
            try {
                constraintColumns = referrer.getAttributeReferences(monitor);
            }
            catch (DBException e) {
                log.warn("Error reading reference attributes", e);
            }
        }
        if (constraintColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityAttribute> attributes = new ArrayList<DBSEntityAttribute>(constraintColumns.size());
        for (DBSEntityAttributeRef dBSEntityAttributeRef : constraintColumns) {
            DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull DBSEntityAttribute tableColumn) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                if (dBSEntityAttributeRef.getAttribute() != tableColumn) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull String columnName) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
                if (attribute == null || !attribute.getName().equals(columnName)) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttribute getReferenceAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association, @NotNull DBSEntityAttribute tableColumn, boolean reference) throws DBException {
        DBSEntityConstraint refConstr = association.getReferencedConstraint();
        if (association instanceof DBSEntityReferrer) {
            DBSEntityReferrer eRef = (DBSEntityReferrer)((Object)association);
            if (refConstr instanceof DBSEntityReferrer) {
                DBSEntityReferrer rRef = (DBSEntityReferrer)refConstr;
                List<? extends DBSEntityAttributeRef> ownAttrs = eRef.getAttributeReferences(monitor);
                List<? extends DBSEntityAttributeRef> refAttrs = rRef.getAttributeReferences(monitor);
                if (ownAttrs == null || refAttrs == null || ownAttrs.size() != refAttrs.size()) {
                    log.error("Invalid internal state of referrer association");
                    return null;
                }
                Iterator ownIterator = ownAttrs.iterator();
                Iterator refIterator = refAttrs.iterator();
                while (ownIterator.hasNext()) {
                    DBSTableForeignKeyColumn fkc;
                    DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownIterator.next();
                    if (reference ? ownAttr instanceof DBSTableForeignKeyColumn && (fkc = (DBSTableForeignKeyColumn)ownAttr).getReferencedColumn() == tableColumn : ownAttr.getAttribute() == tableColumn) {
                        return ((DBSEntityAttributeRef)refIterator.next()).getAttribute();
                    }
                    refIterator.next();
                }
            }
        }
        return null;
    }

    @NotNull
    public static DBCStatement makeStatement(@Nullable DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull String query, long offset, long maxRows) throws DBCException {
        SQLQuery sqlQuery = new SQLQuery(session.getDataSource(), query);
        return DBUtils.makeStatement(executionSource, session, statementType, sqlQuery, offset, maxRows);
    }

    @NotNull
    public static DBCStatement makeStatement(@Nullable DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull SQLQuery sqlQuery, long offset, long maxRows) throws DBCException {
        String queryText;
        DBCQueryTransformerExt faQT;
        DBCQueryTransformerExt lQT;
        DBCQueryTransformProvider transformProvider;
        boolean selectQuery = sqlQuery.getType() == SQLQueryType.SELECT && sqlQuery.isPlainSelect();
        boolean hasLimits = (offset > 0L || selectQuery) && maxRows > 0L;
        boolean isShouldSetLimit = true;
        boolean possiblySelect = sqlQuery.getType() == SQLQueryType.SELECT || sqlQuery.getType() == SQLQueryType.UNKNOWN;
        boolean limitAffectsDML = Boolean.TRUE.equals(session.getDataSource().getDataSourceFeature("datasource.limit-affects-dml"));
        DBCQueryTransformer limitTransformer = null;
        DBCQueryTransformer fetchAllTransformer = null;
        if (selectQuery && (transformProvider = DBUtils.getAdapter(DBCQueryTransformProvider.class, session.getDataSource())) != null) {
            DBCQueryTransformProviderExt qtp;
            if (transformProvider instanceof DBCQueryTransformProviderExt) {
                qtp = (DBCQueryTransformProviderExt)((Object)transformProvider);
                isShouldSetLimit = qtp.isLimitApplicableTo(sqlQuery);
            }
            if (hasLimits) {
                if (session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.maxrows.sql") || transformProvider instanceof DBCQueryTransformProviderExt && (qtp = (DBCQueryTransformProviderExt)((Object)transformProvider)).isForceTransform(session, sqlQuery)) {
                    limitTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.RESULT_SET_LIMIT);
                }
            } else {
                fetchAllTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.FETCH_ALL_TABLE);
            }
        }
        if (limitTransformer instanceof DBCQueryTransformerExt && !(lQT = (DBCQueryTransformerExt)((Object)limitTransformer)).isApplicableTo(sqlQuery)) {
            limitTransformer = null;
        }
        if (fetchAllTransformer instanceof DBCQueryTransformerExt && !(faQT = (DBCQueryTransformerExt)((Object)fetchAllTransformer)).isApplicableTo(sqlQuery)) {
            fetchAllTransformer = null;
        }
        boolean doScrollable = offset > 0L;
        try {
            if (hasLimits && limitTransformer != null) {
                limitTransformer.setParameters(offset, maxRows);
                queryText = limitTransformer.transformQueryString(sqlQuery);
                doScrollable = false;
            } else {
                queryText = fetchAllTransformer != null ? fetchAllTransformer.transformQueryString(sqlQuery) : sqlQuery.getText();
            }
        }
        catch (Exception e) {
            log.debug("Error transforming SQL query", e);
            queryText = sqlQuery.getText();
        }
        DBCStatement dbStat = statementType == DBCStatementType.SCRIPT ? DBUtils.createStatement(session, queryText, doScrollable) : DBUtils.makeStatement(session, queryText, doScrollable);
        dbStat.setStatementSource(executionSource);
        if (offset > 0L || hasLimits || possiblySelect && maxRows > 0L && !limitAffectsDML) {
            if (limitTransformer == null) {
                if (isShouldSetLimit) {
                    dbStat.setLimit(offset, maxRows);
                }
            } else {
                limitTransformer.transformStatement(dbStat, 0);
            }
        } else if (fetchAllTransformer != null) {
            fetchAllTransformer.transformStatement(dbStat, 0);
        }
        return dbStat;
    }

    @NotNull
    public static DBCStatement createStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        SQLDialect dialect = SQLUtils.getDialectFromObject(session.getDataSource());
        DBCStatementType statementType = DBCStatementType.SCRIPT;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(dialect, query)) {
            statementType = DBCStatementType.EXEC;
            query = dialect.formatStoredProcedureCall(session.getDataSource(), query);
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        DBCStatementType statementType = DBCStatementType.QUERY;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(SQLUtils.getDialectFromObject(session.getDataSource()), query)) {
            statementType = DBCStatementType.EXEC;
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    public static void fireObjectUpdate(@NotNull DBSObject object) {
        DBUtils.fireObjectUpdate(object, null, null);
    }

    public static void fireObjectUpdate(DBSObject object, boolean enabled) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, enabled));
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Map<String, Object> options, @Nullable Object data) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, data);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Object data) {
        DBUtils.fireObjectUpdate(object, null, data);
    }

    public static void fireObjectAdd(DBSObject object, Map<String, Object> options) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_ADD, object);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectRemove(DBSObject object) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_REMOVE, object));
        }
    }

    public static void fireObjectSelect(@Nullable DBSObject object, boolean select, @Nullable DBCExecutionContext context) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_SELECT, object, select, context));
        }
    }

    public static void fireObjectRefresh(DBSObject object) {
        DBUtils.fireObjectSelect(object, true, null);
    }

    @NotNull
    public static String getObjectUniqueName(@NotNull DBSObject object) {
        if (object instanceof DBPUniqueObject) {
            DBPUniqueObject uo = (DBPUniqueObject)((Object)object);
            return uo.getUniqueName();
        }
        return object.getName();
    }

    @Nullable
    public static DBSDataType findBestDataType(@NotNull Collection<? extends DBSDataType> allTypes, String ... typeNames) {
        for (String testType : typeNames) {
            for (DBSDataType dBSDataType : allTypes) {
                if (!dBSDataType.getName().equalsIgnoreCase(testType)) continue;
                return dBSDataType;
            }
        }
        return null;
    }

    @NotNull
    public static <T extends DBSTypedObject> T getMoreCommonType(@NotNull T t1, @NotNull T t2) {
        if (!t1.equals(t2) && t1.getDataKind().getCommonality() < t2.getDataKind().getCommonality()) {
            return t2;
        }
        return t1;
    }

    @Nullable
    public static DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String fullTypeName) throws DBException {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.resolveDataType(monitor, fullTypeName);
    }

    @Nullable
    public static DBSDataType getLocalDataType(@NotNull DBPDataSource dataSource, @NotNull String fullTypeName) {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.getLocalDataType(fullTypeName);
    }

    public static DBSObject getPublicObject(@Nullable DBSObject object) {
        if (object instanceof DBPDataSourceContainer) {
            return object.getDataSource();
        }
        return object;
    }

    public static DBSObject getPublicObjectContainer(@NotNull DBSObject object) {
        if (object instanceof DBPDataSource) {
            DBPDataSource ds = (DBPDataSource)object;
            return ds.getContainer();
        }
        return object;
    }

    @Nullable
    public static DBPDataSourceContainer getContainer(@Nullable DBSObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DBPDataSourceContainer) {
            DBPDataSourceContainer dsc = (DBPDataSourceContainer)object;
            return dsc;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null ? null : dataSource.getContainer();
    }

    @Nullable
    public static DBPDataSourceRegistry getObjectRegistry(@NotNull DBSObject object) {
        DBPDataSourceContainer container;
        if (object instanceof DBPDataSourceContainer) {
            DBPDataSourceContainer dsc;
            container = dsc = (DBPDataSourceContainer)object;
        } else {
            DBPDataSource dataSource = object.getDataSource();
            if (dataSource == null) {
                return null;
            }
            container = dataSource.getContainer();
        }
        return container.getRegistry();
    }

    @Nullable
    public static DBPProject getObjectOwnerProject(@NotNull DBSObject object) {
        DBPDataSourceRegistry registry = DBUtils.getObjectRegistry(object);
        return registry == null ? null : registry.getProject();
    }

    @NotNull
    public static String getObjectShortName(Object object) {
        String strValue;
        if (object instanceof DBPNamedObject) {
            DBPNamedObject no = (DBPNamedObject)object;
            strValue = no.getName();
        } else {
            strValue = String.valueOf(object);
        }
        return strValue;
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPNamedObject object, DBPEvaluationContext context) {
        DBSObject dbso;
        if (object instanceof DBPQualifiedObject) {
            DBPQualifiedObject qo = (DBPQualifiedObject)((Object)object);
            return qo.getFullyQualifiedName(context);
        }
        if (object instanceof DBSObject && (dbso = (DBSObject)object).getDataSource() != null) {
            return DBUtils.getObjectFullName(dbso.getDataSource(), object, context, DBPAttributeReferencePurpose.UNSPECIFIED);
        }
        return object.getName();
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPDataSource dataSource, @NotNull DBPNamedObject object, @NotNull DBPEvaluationContext context) {
        return DBUtils.getObjectFullName(dataSource, object, context, DBPAttributeReferencePurpose.UNSPECIFIED);
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPDataSource dataSource, @NotNull DBPNamedObject object, @NotNull DBPEvaluationContext context, @NotNull DBPAttributeReferencePurpose purpose) {
        if (object instanceof DBDAttributeBinding) {
            DBDAttributeBinding binding = (DBDAttributeBinding)object;
            return binding.getFullyQualifiedName(context, purpose);
        }
        if (object instanceof DBPQualifiedObject) {
            DBPQualifiedObject qo = (DBPQualifiedObject)((Object)object);
            return qo.getFullyQualifiedName(context);
        }
        return DBUtils.getQuotedIdentifier(dataSource, object.getName());
    }

    @NotNull
    public static String getFullTypeName(@NotNull DBSTypedObject typedObject) {
        DBSObject structObject = DBUtils.getFromObject(typedObject);
        DBPDataSource dataSource = structObject == null ? null : structObject.getDataSource();
        return DBUtils.getFullTypeName(dataSource, typedObject);
    }

    @NotNull
    public static String getFullTypeName(DBPDataSource dataSource, @NotNull DBSTypedObject typedObject) {
        String typeName = typedObject.getTypeName();
        if (CommonUtils.isEmpty((String)typeName)) {
            return "<" + ModelMessages.dbutils_type_name_unknown + ">";
        }
        String typeModifiers = SQLUtils.getColumnTypeModifiers(dataSource, typedObject, typeName, typedObject.getDataKind());
        return typeModifiers == null ? typeName : typeName + typeModifiers;
    }

    public static void releaseValue(@Nullable Object value) {
        if (value instanceof DBDValue) {
            DBDValue dbdv = (DBDValue)value;
            dbdv.release();
        }
    }

    public static void resetValue(@Nullable Object value) {
        if (value instanceof DBDContent) {
            DBDContent dbdc = (DBDContent)value;
            dbdc.resetContents();
        }
    }

    @NotNull
    public static DBCLogicalOperator[] getAttributeOperators(DBSTypedObject attribute) {
        DBSTypedObjectEx typedObjectEx;
        DBSDataType dataType;
        if (attribute instanceof DBSTypedObjectEx && (dataType = (typedObjectEx = (DBSTypedObjectEx)((Object)attribute)).getDataType()) != null) {
            return dataType.getSupportedOperators(attribute);
        }
        return DBUtils.getDefaultOperators(attribute);
    }

    @NotNull
    public static DBCLogicalOperator[] getDefaultOperators(DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (attribute instanceof DBSAttributeBase && !((DBSAttributeBase)attribute).isRequired()) {
            operators.add(DBCLogicalOperator.IS_NULL);
            operators.add(DBCLogicalOperator.IS_NOT_NULL);
        }
        if (dataKind == DBPDataKind.BOOLEAN || dataKind == DBPDataKind.ROWID || dataKind == DBPDataKind.OBJECT || dataKind == DBPDataKind.BINARY) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
        } else if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
            operators.add(DBCLogicalOperator.IN);
        }
        if (dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.LIKE);
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }

    public static Object getRawValue(Object value) {
        if (value instanceof DBDValue) {
            return ((DBDValue)value).getRawValue();
        }
        return value;
    }

    public static DBSTableIndex findAttributeIndex(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        Collection<? extends DBSTableIndex> indexes;
        DBSEntity entity = attribute.getParentObject();
        if (entity instanceof DBSTable && !CommonUtils.isEmpty(indexes = ((DBSTable)entity).getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : indexes) {
                if (DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)dBSTableIndex, attribute) == null) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    @Nullable
    public static DBCTransactionManager getTransactionManager(@Nullable DBCExecutionContext executionContext) {
        if (executionContext != null && executionContext.isConnected()) {
            return DBUtils.getAdapter(DBCTransactionManager.class, executionContext);
        }
        return null;
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) throws DBCException {
        DBCExecutionContext defaultContext = DBUtils.getOrOpenDefaultContext(object, true);
        if (defaultContext == null) {
            throw new DBCException("Default context not found");
        }
        return (T)defaultContext.openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String task) throws DBCException {
        return (T)dataSource.getDefaultInstance().getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openUtilSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) throws DBCException {
        DBCExecutionContext defaultContext = DBUtils.getOrOpenDefaultContext(object, true);
        if (defaultContext == null) {
            throw new DBCException("Default context not found");
        }
        return (T)DBUtils.getOrOpenDefaultContext(object, false).openSession(monitor, DBCExecutionPurpose.UTIL, task);
    }

    @Nullable
    public static DBSObject getFromObject(Object object) {
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DBSWrapper.class, DBSObject.class}, (Object)object2, n)) {
            case -1 -> null;
            case 0 -> {
                DBSWrapper dbsWrapper = (DBSWrapper)object2;
                yield dbsWrapper.getObject();
            }
            case 1 -> {
                DBSObject dbsObject;
                yield dbsObject = (DBSObject)object2;
            }
            default -> RuntimeUtils.getObjectAdapter(object, DBSObject.class);
        };
    }

    public static boolean isAtomicParameter(Object o) {
        return o == null || o instanceof CharSequence || o instanceof Number || o instanceof Date || o instanceof Boolean;
    }

    @NotNull
    public static DBSObject getDefaultOrActiveObject(@NotNull DBSInstance object) {
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext(object, true);
        DBSObject activeObject = defaultContext == null ? null : DBUtils.getActiveInstanceObject(defaultContext);
        return activeObject == null ? object.getDataSource() : activeObject;
    }

    @Nullable
    public static DBSObject getActiveInstanceObject(@NotNull DBCExecutionContext executionContext) {
        return DBUtils.getSelectedObject(executionContext);
    }

    @Nullable
    public static DBSObject getSelectedObject(@NotNull DBCExecutionContext context) {
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults != null) {
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (defaultSchema != null) {
                return defaultSchema;
            }
            return contextDefaults.getDefaultCatalog();
        }
        return null;
    }

    @Nullable
    public static <T> T getSelectedObject(@NotNull DBCExecutionContext context, @NotNull Class<T> theClass) {
        DBSObject selectedObject = DBUtils.getSelectedObject(context);
        if (theClass.isInstance(selectedObject)) {
            return theClass.cast(selectedObject);
        }
        return null;
    }

    @NotNull
    public static DBSObject[] getSelectedObjects(@Nullable DBCExecutionContext context) {
        if (context == null || context.getContextDefaults() == null) {
            return new DBSObject[0];
        }
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        Object defaultCatalog = contextDefaults.getDefaultCatalog();
        Object defaultSchema = contextDefaults.getDefaultSchema();
        if (defaultCatalog != null && defaultSchema != null) {
            return new DBSObject[]{defaultCatalog, defaultSchema};
        }
        if (defaultCatalog != null) {
            return new DBSObject[]{defaultCatalog};
        }
        if (defaultSchema != null) {
            return new DBSObject[]{defaultSchema};
        }
        return new DBSObject[0];
    }

    public static void refreshContextDefaultsAndReflect(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContextDefaults<?, ?> contextDefaults, @Nullable DBCExecutionContext context) {
        try {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (contextDefaults.refreshDefaults(monitor, false)) {
                DBUtils.fireObjectSelectionChange(defaultCatalog, contextDefaults.getDefaultCatalog(), context);
                DBUtils.fireObjectSelectionChange(defaultSchema, contextDefaults.getDefaultSchema(), context);
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void fireObjectSelectionChange(@Nullable DBSObject oldDefaultObject, @Nullable DBSObject newDefaultObject, @Nullable DBCExecutionContext context) {
        if (oldDefaultObject != newDefaultObject) {
            if (oldDefaultObject != null) {
                DBUtils.fireObjectSelect(oldDefaultObject, false, context);
            }
            if (newDefaultObject != null) {
                DBUtils.fireObjectSelect(newDefaultObject, true, context);
            }
        }
    }

    public static DBSObjectContainer getChangeableObjectContainer(DBCExecutionContextDefaults<?, ?> contextDefaults, DBSObjectContainer root, Class<? extends DBSObject> childType) {
        if (contextDefaults == null) {
            return null;
        }
        if (childType == DBSCatalog.class && contextDefaults.supportsCatalogChange()) {
            return root;
        }
        if (childType == DBSSchema.class && contextDefaults.supportsSchemaChange()) {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                return defaultCatalog;
            }
            return root;
        }
        return null;
    }

    public static boolean isHiddenObject(Object object) {
        DBPHiddenObject ho;
        return object instanceof DBPHiddenObject && (ho = (DBPHiddenObject)object).isHidden();
    }

    public static boolean isSystemObject(Object object) {
        DBPSystemObject so;
        return object instanceof DBPSystemObject && (so = (DBPSystemObject)object).isSystem();
    }

    public static boolean isVirtualObject(Object object) {
        DBPVirtualObject vo;
        return object instanceof DBPVirtualObject && (vo = (DBPVirtualObject)object).isVirtual();
    }

    public static boolean isInheritedObject(Object object) {
        DBPInheritedObject io;
        return object instanceof DBPInheritedObject && (io = (DBPInheritedObject)object).isInherited();
    }

    public static DBDPseudoAttribute getRowIdAttribute(DBSEntity entity) {
        if (entity instanceof DBDPseudoAttributeContainer) {
            DBDPseudoAttributeContainer pac = (DBDPseudoAttributeContainer)((Object)entity);
            try {
                return DBDPseudoAttribute.getAttribute(pac.getPseudoAttributes(), DBDPseudoAttributeType.ROWID);
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    public static boolean isDynamicAttribute(DBSAttributeBase attr) {
        DBSAttributeDynamic da;
        return attr instanceof DBSAttributeDynamic && (da = (DBSAttributeDynamic)attr).isDynamicAttribute();
    }

    public static boolean isRowIdAttribute(DBSEntityAttribute attr) {
        DBDPseudoAttribute rowIdAttribute = DBUtils.getRowIdAttribute(attr.getParentObject());
        return rowIdAttribute != null && rowIdAttribute.getName().equals(attr.getName());
    }

    public static DBDPseudoAttribute getPseudoAttribute(DBSEntity entity, String attrName) {
        if (entity instanceof DBDPseudoAttributeContainer) {
            DBDPseudoAttributeContainer pac = (DBDPseudoAttributeContainer)((Object)entity);
            try {
                DBDPseudoAttribute[] pseudoAttributes = pac.getPseudoAttributes();
                if (pseudoAttributes != null) {
                    for (DBDPseudoAttribute pa : pseudoAttributes) {
                        String attrId = pa.getAlias();
                        if (CommonUtils.isEmpty((String)attrId)) {
                            attrId = pa.getName();
                        }
                        if (!attrId.equals(attrName)) continue;
                        return pa;
                    }
                }
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    public static boolean isPseudoAttribute(DBSAttributeBase attr) {
        DBDAttributeBinding ab;
        return attr instanceof DBDAttributeBinding && (ab = (DBDAttributeBinding)attr).isPseudoAttribute();
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparator() {
        return Comparator.comparing(DBPNamedObject::getName);
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparatorIgnoreCase() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public static Comparator<? super DBPObjectWithOrdinalPosition> orderComparator() {
        return Comparator.comparingInt(DBPObjectWithOrdinalPosition::getOrdinalPosition);
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull Collection<T> objects) {
        ArrayList<T> ordered = new ArrayList<T>(objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull T[] objects) {
        ArrayList ordered = new ArrayList();
        Collections.addAll(ordered, objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> void orderObjects(@NotNull List<T> objects) {
        objects.sort(Comparator.comparing(DBPNamedObject::getName));
    }

    @NotNull
    public static String getClientApplicationName(@NotNull DBPDataSourceContainer container, @Nullable DBCExecutionContext context, @Nullable String purpose) {
        return DBUtils.getClientApplicationName(container, context, purpose, true);
    }

    @NotNull
    public static String getClientApplicationName(@NotNull DBPDataSourceContainer container, @Nullable DBCExecutionContext context, @Nullable String purpose, boolean addVersion) {
        if (container.getPreferenceStore().getBoolean("database.meta.client.name.override")) {
            String appName = CommonUtils.notEmpty((String)container.getPreferenceStore().getString("database.meta.client.name.value"));
            IVariableResolver varResolver = container.getVariablesResolver(false);
            return GeneralUtils.replaceVariables(appName, name -> switch (name) {
                case "context.name" -> {
                    if (context == null) {
                        yield null;
                    }
                    yield context.getContextName();
                }
                case "context.id" -> {
                    if (context == null) {
                        yield null;
                    }
                    yield String.valueOf(context.getContextId());
                }
                default -> varResolver.get(name);
            });
        }
        String productTitle = addVersion ? GeneralUtils.getProductTitle() : GeneralUtils.getProductName();
        return purpose == null ? productTitle : productTitle + " - " + purpose;
    }

    public static DBSInstance getObjectOwnerInstance(DBSObject object) {
        if (object == null) {
            return null;
        }
        for (DBSObject p = object; p != null; p = p.getParentObject()) {
            if (!(p instanceof DBSInstance)) continue;
            return (DBSInstance)p;
        }
        DBPDataSource dataSource = object.getDataSource();
        if (dataSource == null || dataSource.isConnectionRefreshing()) {
            return null;
        }
        return dataSource.getDefaultInstance();
    }

    @Nullable
    public static DBCExecutionContext getDefaultContext(@Nullable DBSObject object, boolean meta) {
        DBSInstanceLazy instanceLazy;
        if (object == null) {
            return null;
        }
        DBSInstance instance = DBUtils.getObjectOwnerInstance(object);
        if (instance == null || instance instanceof DBSInstanceLazy && !(instanceLazy = (DBSInstanceLazy)instance).isInstanceConnected() || instance.getDataSource() != null && instance.getDataSource().isConnectionRefreshing() && !DBWorkbench.getPlatform().getApplication().isHeadlessMode()) {
            return null;
        }
        return instance.getDefaultContext(new VoidProgressMonitor(), meta);
    }

    public static DBCExecutionContext getOrOpenDefaultContext(DBSObject object, boolean meta) throws DBCException {
        DBSInstanceLazy instanceLazy;
        DBSInstance ownerInstance;
        DBCExecutionContext context = DBUtils.getDefaultContext(object, meta);
        if (context == null && (ownerInstance = DBUtils.getObjectOwnerInstance(object)) instanceof DBSInstanceLazy && !(instanceLazy = (DBSInstanceLazy)ownerInstance).isInstanceConnected()) {
            if (!RuntimeUtils.runTask(monitor -> {
                try {
                    instanceLazy.checkInstanceConnection(monitor);
                }
                catch (DBException e) {
                    throw new InvocationTargetException(e);
                }
            }, "Initiate instance connection", object.getDataSource().getContainer().getPreferenceStore().getInt("connection.open.timeout"))) {
                throw new DBCException("Timeout while opening database connection");
            }
            context = DBUtils.getDefaultContext(object, meta);
        }
        return context;
    }

    public static List<DBPDataSourceRegistry> getAllRegistries(boolean forceLoad) {
        ArrayList<DBPDataSourceRegistry> result = new ArrayList<DBPDataSourceRegistry>();
        for (DBPProject dBPProject : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            if (!forceLoad && (!dBPProject.isOpen() || !dBPProject.isRegistryLoaded())) continue;
            dBPProject.ensureOpen();
            DBPDataSourceRegistry registry = dBPProject.getDataSourceRegistry();
            result.add(registry);
        }
        return result;
    }

    @Deprecated
    @Nullable
    public static DBPDataSourceContainer findDataSource(@NotNull String dataSourceId) {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject dBPProject : workspace.getProjects()) {
            DBPDataSourceRegistry dataSourceRegistry = dBPProject.getDataSourceRegistry();
            DBPDataSourceContainer dataSourceContainer = dataSourceRegistry.getDataSource(dataSourceId);
            if (dataSourceContainer == null) continue;
            return dataSourceContainer;
        }
        return null;
    }

    @Nullable
    public static DBPDataSourceContainer findDataSource(@Nullable String projectName, @NotNull String dataSourceId) {
        DBPProject project = null;
        if (!CommonUtils.isEmpty((String)projectName)) {
            project = DBWorkbench.getPlatform().getWorkspace().getProject(projectName);
        }
        if (project != null) {
            return project.getDataSourceRegistry().getDataSource(dataSourceId);
        }
        return DBUtils.findDataSource(dataSourceId);
    }

    public static int compareDataValues(@Nullable Object cell1, @Nullable Object cell2) {
        if (cell1 == cell2 || DBUtils.isNullValue(cell1) && DBUtils.isNullValue(cell2)) {
            return 0;
        }
        if (DBUtils.isNullValue(cell1)) {
            return 1;
        }
        if (DBUtils.isNullValue(cell2)) {
            return -1;
        }
        if (cell1 instanceof Number && cell2 instanceof Number) {
            return CommonUtils.compareNumbers((Number)((Number)cell1), (Number)((Number)cell2));
        }
        if (cell1 instanceof Comparable) {
            Comparable cmp1 = (Comparable)cell1;
            if (cell1.getClass() == cell2.getClass()) {
                return cmp1.compareTo(cell2);
            }
        }
        if (cell1 instanceof Number) {
            Object num2 = GeneralUtils.convertString(String.valueOf(cell2), cell1.getClass());
            if (num2 == null) {
                return -1;
            }
            if (num2 instanceof Number) {
                return CommonUtils.compareNumbers((Number)((Number)cell1), (Number)((Number)num2));
            }
        } else if (cell2 instanceof Number) {
            Object num1 = GeneralUtils.convertString(String.valueOf(cell1), cell2.getClass());
            if (num1 == null) {
                return 1;
            }
            if (num1 instanceof Number) {
                return CommonUtils.compareNumbers((Number)((Number)num1), (Number)((Number)cell2));
            }
        }
        String str1 = String.valueOf(cell1);
        String str2 = String.valueOf(cell2);
        return str1.compareTo(str2);
    }

    @Nullable
    public static DBSEntity getEntityFromMetaData(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBCEntityMetaData entityMeta) throws DBException {
        DBSObjectContainer objectContainer = DBUtils.getAdapter(DBSObjectContainer.class, executionContext.getDataSource());
        if (objectContainer != null) {
            DBSEntity entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, false);
            if (entity == null) {
                entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, true);
            }
            return entity;
        }
        return null;
    }

    @Nullable
    public static DBSEntity getEntityFromMetaData(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer objectContainer, @NotNull DBCEntityMetaData entityMeta, boolean transformName) throws DBException {
        DBPDataSource dataSource = objectContainer.getDataSource();
        String catalogName = entityMeta.getCatalogName();
        String schemaName = entityMeta.getSchemaName();
        String entityName = entityMeta.getEntityName();
        if (transformName) {
            catalogName = DBObjectNameCaseTransformer.transformName(dataSource, catalogName);
            schemaName = DBObjectNameCaseTransformer.transformName(dataSource, schemaName);
            entityName = DBObjectNameCaseTransformer.transformName(dataSource, entityName);
        }
        if (CommonUtils.isEmpty((String)entityName)) {
            return null;
        }
        DBSObject entityObject = DBUtils.getObjectByPath(monitor, executionContext, objectContainer, catalogName, schemaName, entityName);
        if (entityObject instanceof DBSAlias) {
            DBSAlias alias = (DBSAlias)entityObject;
            if (!(entityObject instanceof DBSEntity)) {
                entityObject = alias.getTargetObject(monitor);
            }
        }
        if (entityObject == null) {
            return null;
        }
        if (entityObject instanceof DBSEntity) {
            DBSEntity entity = (DBSEntity)entityObject;
            return entity;
        }
        log.debug("Unsupported table class: " + entityObject.getClass().getName());
        return null;
    }

    @Nullable
    public static DBSEntityConstraint getConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity dbsEntity, @NotNull DBSAttributeBase attribute) throws DBException {
        for (DBSEntityConstraint constraint : CommonUtils.safeCollection(dbsEntity.getConstraints(monitor))) {
            DBSEntityAttributeRef constraintAttribute = DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)constraint, attribute.getName());
            if (constraintAttribute == null || constraintAttribute.getAttribute() != attribute) continue;
            return constraint;
        }
        return null;
    }

    public static boolean isReadOnly(@Nullable DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || !dataSource.getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA) || dataSource.getInfo().isReadOnlyMetaData();
    }

    public static boolean isView(@NotNull DBSEntity table) {
        DBSTable dbsTab;
        return table instanceof DBSView || table instanceof DBSTable && (dbsTab = (DBSTable)table).isView();
    }

    @NotNull
    public static String getEntityScriptName(@NotNull DBSObject object, @NotNull Map<String, Object> options) {
        String string;
        if (CommonUtils.getOption(options, (String)"useFQN", (boolean)true) && object instanceof DBPQualifiedObject) {
            DBPQualifiedObject qo = (DBPQualifiedObject)((Object)object);
            string = qo.getFullyQualifiedName(DBPEvaluationContext.DDL);
        } else {
            string = DBUtils.getQuotedIdentifier(object);
        }
        return string;
    }

    @NotNull
    public static String getObjectTypeName(@NotNull DBSObject object) {
        DBSObjectType[] objectTypes;
        if (object instanceof DBSObjectWithType) {
            DBSObjectWithType owt = (DBSObjectWithType)((Object)object);
            return owt.getObjectType().getTypeName();
        }
        for (DBSObjectType ot : objectTypes = object.getDataSource().getInfo().getSupportedObjectTypes()) {
            Class<? extends DBSObject> typeClass = ot.getTypeClass();
            if (typeClass == null || typeClass == DBSObject.class || !typeClass.isInstance(object)) continue;
            return ot.getTypeName();
        }
        if (object instanceof DBSSchema) {
            return "Schema";
        }
        if (object instanceof DBSCatalog) {
            return "Catalog";
        }
        if (object instanceof DBSEntity) {
            return "Entity";
        }
        return "Object";
    }

    @Nullable
    public static DBSDataType getDataType(@NotNull DBSTypedObject typedObject) {
        if (typedObject instanceof DBSDataType) {
            DBSDataType dt = (DBSDataType)typedObject;
            return dt;
        }
        if (typedObject instanceof DBSTypedObjectEx) {
            DBSTypedObjectEx dte = (DBSTypedObjectEx)((Object)typedObject);
            return dte.getDataType();
        }
        return null;
    }

    @Nullable
    public static DBSDataType getDataType(@Nullable DBPDataSource dataSource, @NotNull DBSTypedObject typedObject) {
        DBSDataType dataType = DBUtils.getDataType(typedObject);
        if (dataType != null) {
            return dataType;
        }
        if (dataSource instanceof DBPDataTypeProvider) {
            DBPDataTypeProvider dtp = (DBPDataTypeProvider)((Object)dataSource);
            return dtp.getLocalDataType(typedObject.getFullTypeName());
        }
        return null;
    }

    @NotNull
    public static Pair<String, String[]> getTypeModifiers(@NotNull String type) throws DBException {
        int modEndIndex;
        int modStartIndex = type.indexOf(40);
        if (modStartIndex < 0 ^ (modEndIndex = type.indexOf(41)) < 0) {
            throw new DBException("Type '" + type + "' has malformed modifiers");
        }
        if (modStartIndex < 0) {
            return new Pair((Object)type, (Object)new String[0]);
        }
        String name = (type.substring(0, modStartIndex) + type.substring(modEndIndex + 1)).trim();
        if (name.isEmpty()) {
            throw new DBException("Type name is missing");
        }
        String mod = type.substring(modStartIndex + 1, modEndIndex).trim();
        if (mod.isEmpty()) {
            throw new DBException("Type with zero modifiers is not allowed");
        }
        String[] mods = mod.split(",");
        for (int i = 0; i < mods.length; ++i) {
            mods[i] = mods[i].trim();
            if (!mods[i].isEmpty()) continue;
            throw new DBException("Type has empty modifiers");
        }
        return new Pair((Object)name, (Object)mods);
    }

    @NotNull
    public static <PARENT extends DBSObject, CHILD extends DBSObject> String makeNewObjectName(@NotNull DBRProgressMonitor monitor, @NotNull String template, @NotNull PARENT parent, @NotNull Class<? extends CHILD> type, @NotNull ChildExtractor<PARENT, CHILD> extractor, @NotNull DBECommandContext context) {
        int suffix = 1;
        while (true) {
            String name = Objects.requireNonNull(DBObjectNameCaseTransformer.transformName(parent.getDataSource(), NLS.bind((String)template, (Object)suffix)));
            try {
                boolean exists;
                boolean bl = exists = extractor.extract(parent, monitor, name) != null;
                if (!exists) {
                    for (DBPObject object : context.getEditedObjects()) {
                        if (!type.isInstance(object) || ((DBSObject)object).getParentObject() != parent || !name.equalsIgnoreCase(((DBSObject)object).getName())) continue;
                        exists = true;
                        break;
                    }
                }
                if (!exists) {
                    return name;
                }
            }
            catch (DBException e) {
                log.warn(e);
                return name;
            }
            ++suffix;
        }
    }

    @NotNull
    public static List<DBSDataContainer> getAllDataContainersFromParentContainer(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject parent) throws DBException {
        List<DBSDataContainer> containers;
        DBPDataSource dataSource;
        ArrayList<DBSDataContainer> result = new ArrayList<DBSDataContainer>();
        if (parent instanceof DBSDataContainer) {
            DBSDataContainer container = (DBSDataContainer)parent;
            result.add(container);
        } else if (parent instanceof DBSObjectContainer) {
            Collection<? extends DBSObject> children;
            DBSObjectContainer container = (DBSObjectContainer)parent;
            Class<? extends DBSObject> primaryChildType = container.getPrimaryChildType(monitor);
            if (DBSDataContainer.class.isAssignableFrom(primaryChildType)) {
                Collection<? extends DBSObject> children2 = container.getChildren(monitor);
                if (!CommonUtils.isEmpty(children2)) {
                    for (DBSObject dBSObject : children2) {
                        if (!(dBSObject instanceof DBSDataContainer)) continue;
                        result.add((DBSDataContainer)dBSObject);
                    }
                }
            } else if (DBSObjectContainer.class.isAssignableFrom(primaryChildType) && (children = container.getChildren(monitor)) != null) {
                for (DBSObject dBSObject : children) {
                    Collection<? extends DBSObject> grandChildren = ((DBSObjectContainer)dBSObject).getChildren(monitor);
                    if (grandChildren == null) continue;
                    for (DBSObject dBSObject2 : grandChildren) {
                        if (!(dBSObject2 instanceof DBSDataContainer)) continue;
                        DBSDataContainer dataContainer = (DBSDataContainer)dBSObject2;
                        result.add(dataContainer);
                    }
                }
            }
        } else if (parent instanceof DBNDatabaseFolder) {
            Collection<DBSObject> dbsObjects = ((DBNDatabaseFolder)parent).getChildrenObjects(monitor);
            for (DBSObject dbsObject : dbsObjects) {
                List<DBSDataContainer> list = DBUtils.getAllDataContainersFromParentContainer(monitor, dbsObject);
                if (CommonUtils.isEmpty(list)) continue;
                result.addAll(list);
            }
        } else if (parent instanceof DBPDataSourceContainer && (dataSource = parent.getDataSource()) instanceof DBSObjectContainer && !CommonUtils.isEmpty(containers = DBUtils.getAllDataContainersFromParentContainer(monitor, dataSource))) {
            result.addAll(containers);
        }
        return result;
    }

    public static boolean initDataSource(@Nullable DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer dataSource, @Nullable DBRProgressListener onFinish) throws DBException {
        if (!dataSource.isConnected()) {
            DBServiceConnections serviceConnections = DBWorkbench.getService(DBServiceConnections.class);
            if (serviceConnections != null) {
                serviceConnections.initConnection(monitor, dataSource, onFinish);
            }
        } else if (onFinish != null) {
            onFinish.onTaskFinished(Status.OK_STATUS);
        }
        return dataSource.isConnected();
    }

    public static long readRowCount(@NotNull DBRProgressMonitor monitor, @Nullable DBCExecutionContext executionContext, @Nullable DBSDataContainer dataContainer, @Nullable DBDDataFilter dataFilter, @NotNull Object controller) throws DBException {
        if (executionContext == null || dataContainer == null) {
            throw new DBException(ModelMessages.error_not_connected_to_database);
        }
        long[] result = new long[1];
        DBExecUtils.tryExecuteRecover(monitor, executionContext.getDataSource(), param -> {
            try (DBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.USER, "Read total row count");){
                long rowCount;
                result[0] = rowCount = dataContainer.countData(new AbstractExecutionSource(dataContainer, executionContext, controller), session, dataFilter, 0L);
            }
        });
        return result[0];
    }

    public static long countDataFromQuery(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull SQLQuery query) throws DBException {
        try (DBCStatement dbStatement = DBUtils.makeStatement(source, session, DBCStatementType.SCRIPT, query, 0L, 0L);){
            if (dbStatement.executeStatement()) {
                try (DBCResultSet rs = dbStatement.openResultSet();){
                    if (rs.nextRow()) {
                        Object singleValue;
                        Map map;
                        List<? extends DBCAttributeMetaData> resultAttrs = rs.getMeta().getAttributes();
                        Object countValue = null;
                        if (resultAttrs.size() == 1) {
                            countValue = rs.getAttributeValue(0);
                        } else {
                            for (int i = 0; i < resultAttrs.size(); ++i) {
                                DBCAttributeMetaData ma = resultAttrs.get(i);
                                if (!ma.getName().toLowerCase(Locale.ENGLISH).contains("count")) continue;
                                countValue = rs.getAttributeValue(i);
                                break;
                            }
                        }
                        if (countValue instanceof Map && (map = (Map)countValue).size() == 1 && (singleValue = map.values().iterator().next()) instanceof Number) {
                            countValue = singleValue;
                        }
                        if (countValue instanceof Number) {
                            Number number = (Number)countValue;
                            long l = number.longValue();
                            return l;
                        }
                        throw new DBCException("Unexpected row count value: " + String.valueOf(countValue));
                    }
                    throw new DBCException("Row count result is empty");
                }
            }
            throw new DBCException("Row count query didn't return any value");
        }
    }

    public static boolean isUniqueIndexForAttributes(@NotNull DBRProgressMonitor monitor, @NotNull List<DBSEntityAttribute> attributes, @NotNull DBSEntity entity) throws DBException, InterruptedException {
        Collection<? extends DBSTableIndex> tableIndexes = ((DBSTable)entity).getIndexes(monitor);
        for (DBSTableIndex dBSTableIndex : tableIndexes) {
            if (monitor.isCanceled()) break;
            List<DBSEntityAttribute> indexAttributes = DBUtils.getEntityAttributes(monitor, dBSTableIndex);
            if (!dBSTableIndex.isUnique() || !indexAttributes.equals(attributes)) continue;
            return true;
        }
        return false;
    }

    public static interface ChildExtractor<PARENT, CHILD> {
        @Nullable
        public CHILD extract(@NotNull PARENT var1, @NotNull DBRProgressMonitor var2, @NotNull String var3) throws DBException;
    }
}

