/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;

public abstract class SQLQueryConnectionContext {
    private static final Log log = Log.getLog(SQLQueryConnectionContext.class);
    @NotNull
    public final SQLDialect dialect;

    protected SQLQueryConnectionContext(@NotNull SQLDialect dialect) {
        this.dialect = dialect;
    }

    @NotNull
    public abstract List<SQLQueryResultPseudoColumn> obtainRowsetPseudoColumns(@Nullable SQLQueryRowsSourceModel var1);

    @Nullable
    public static DBSObject expandAliases(@NotNull DBRProgressMonitor monitor, @Nullable DBSObject obj) {
        while (obj instanceof DBSAlias) {
            DBSAlias aliasObject = (DBSAlias)obj;
            try {
                obj = aliasObject.getTargetObject(monitor);
            }
            catch (DBException e) {
                obj = null;
                log.debug((Object)("Can't resolve target object for alias '" + aliasObject.getName() + "'"), (Throwable)e);
            }
        }
        return obj;
    }

    @NotNull
    public List<DBSEntity> findRealTables(@NotNull DBRProgressMonitor monitor, @NotNull List<String> tableName) {
        List<? extends DBSObject> objs = this.findRealObjectsImpl(monitor, tableName);
        if (objs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntity> results = new ArrayList<DBSEntity>(objs.size());
        for (int i = 0; i < objs.size(); ++i) {
            DBSObject obj = SQLQueryConnectionContext.expandAliases(monitor, objs.get(i));
            if (!(obj instanceof DBSTable) && !(obj instanceof DBSView)) continue;
            results.add((DBSEntity)obj);
        }
        return results;
    }

    @NotNull
    public final List<? extends DBSObject> findRealObjects(@NotNull DBRProgressMonitor monitor, @NotNull DBSObjectType objectType, @NotNull List<String> objectName) {
        List<? extends DBSObject> objs = this.findRealObjectsImpl(monitor, objectName);
        if (objs.isEmpty()) {
            return Collections.emptyList();
        }
        if (objs.size() == 1) {
            return objectType.getTypeClass().isInstance(objs.getFirst()) ? objs : Collections.emptyList();
        }
        return objs.stream().filter(o -> objectType.getTypeClass().isInstance(o)).toList();
    }

    public abstract boolean isDummy();

    @NotNull
    protected abstract List<? extends DBSObject> findRealObjectsImpl(@NotNull DBRProgressMonitor var1, @NotNull List<String> var2);

    @Nullable
    public abstract SQLQueryResultPseudoColumn resolveGlobalPseudoColumn(@NotNull String var1);
}

