/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.codec.decoder.mqtt5;

import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderContext;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttDecoderException;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoder;
import com.hivemq.client.internal.mqtt.codec.decoder.MqttMessageDecoderUtil;
import com.hivemq.client.internal.mqtt.codec.decoder.mqtt5.Mqtt5MessageDecoderUtil;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertiesImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUserPropertyImpl;
import com.hivemq.client.internal.mqtt.datatypes.MqttUtf8StringImpl;
import com.hivemq.client.internal.mqtt.message.unsubscribe.unsuback.MqttUnsubAck;
import com.hivemq.client.internal.util.collections.ImmutableList;
import com.hivemq.client.mqtt.mqtt5.message.unsubscribe.unsuback.Mqtt5UnsubAckReasonCode;
import io.netty.buffer.ByteBuf;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jetbrains.annotations.NotNull;

@Singleton
public class Mqtt5UnsubAckDecoder
implements MqttMessageDecoder {
    private static final int FLAGS = 0;
    private static final int MIN_REMAINING_LENGTH = 3;

    @Inject
    Mqtt5UnsubAckDecoder() {
    }

    @Override
    @NotNull
    public MqttUnsubAck decode(int flags, @NotNull ByteBuf in, @NotNull MqttDecoderContext context) throws MqttDecoderException {
        int readPropertyLength;
        MqttMessageDecoderUtil.checkFixedHeaderFlags(0, flags);
        if (in.readableBytes() < 3) {
            throw MqttMessageDecoderUtil.remainingLengthTooShort();
        }
        int packetIdentifier = in.readUnsignedShort();
        int propertyLength = Mqtt5MessageDecoderUtil.decodePropertyLength(in);
        MqttUtf8StringImpl reasonString = null;
        ImmutableList.Builder<MqttUserPropertyImpl> userPropertiesBuilder = null;
        int propertiesStartIndex = in.readerIndex();
        block4: while ((readPropertyLength = in.readerIndex() - propertiesStartIndex) < propertyLength) {
            int propertyIdentifier = Mqtt5MessageDecoderUtil.decodePropertyIdentifier(in);
            switch (propertyIdentifier) {
                case 31: {
                    reasonString = Mqtt5MessageDecoderUtil.decodeReasonStringIfRequested(reasonString, in, context);
                    continue block4;
                }
                case 38: {
                    userPropertiesBuilder = Mqtt5MessageDecoderUtil.decodeUserPropertyIfRequested(userPropertiesBuilder, in, context);
                    continue block4;
                }
            }
            throw Mqtt5MessageDecoderUtil.wrongProperty(propertyIdentifier);
        }
        if (readPropertyLength != propertyLength) {
            throw Mqtt5MessageDecoderUtil.malformedPropertyLength();
        }
        int reasonCodeCount = in.readableBytes();
        if (reasonCodeCount == 0) {
            throw Mqtt5MessageDecoderUtil.noReasonCodes();
        }
        ImmutableList.Builder<Mqtt5UnsubAckReasonCode> reasonCodesBuilder = ImmutableList.builder(reasonCodeCount);
        for (int i = 0; i < reasonCodeCount; ++i) {
            Mqtt5UnsubAckReasonCode reasonCode = Mqtt5UnsubAckReasonCode.fromCode(in.readUnsignedByte());
            if (reasonCode == null) {
                throw Mqtt5MessageDecoderUtil.wrongReasonCode();
            }
            reasonCodesBuilder.add(reasonCode);
        }
        ImmutableList<Mqtt5UnsubAckReasonCode> reasonCodes = reasonCodesBuilder.build();
        MqttUserPropertiesImpl userProperties = MqttUserPropertiesImpl.build(userPropertiesBuilder);
        return new MqttUnsubAck(packetIdentifier, reasonCodes, reasonString, userProperties);
    }
}

