/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.http.HttpMethod;
import org.openhab.core.io.net.http.HttpUtil;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.library.types.RawType;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.model.script.actions.BusEvent;
import org.openhab.core.model.script.engine.action.ActionDoc;
import org.openhab.core.model.script.engine.action.ParamDoc;
import org.openhab.core.types.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP {
    public static final String CONTENT_TYPE_JSON = "application/json";
    private static Logger logger = LoggerFactory.getLogger(HTTP.class);

    public static String sendHttpGetRequest(String url) {
        return HTTP.sendHttpGetRequest(url, 5000);
    }

    public static String sendHttpGetRequest(String url, int timeout) {
        String response = null;
        try {
            return HttpUtil.executeUrl((String)HttpMethod.GET.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return response;
        }
    }

    public static String sendHttpGetRequest(String url, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.GET.name(), (String)url, (Properties)headerProperties, null, null, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpPutRequest(String url) {
        return HTTP.sendHttpPutRequest(url, 1000);
    }

    public static String sendHttpPutRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPutRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPutRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPutRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPutRequest(String url, String contentType, String content, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.PUT.name(), (String)url, (Properties)headerProperties, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpPostRequest(String url) {
        return HTTP.sendHttpPostRequest(url, 1000);
    }

    public static String sendHttpPostRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url, String contentType, String content) {
        return HTTP.sendHttpPostRequest(url, contentType, content, 1000);
    }

    public static String sendHttpPostRequest(String url, String contentType, String content, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpPostRequest(String url, String contentType, String content, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.POST.name(), (String)url, (Properties)headerProperties, (InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), (String)contentType, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sendHttpDeleteRequest(String url) {
        return HTTP.sendHttpDeleteRequest(url, 1000);
    }

    public static String sendHttpDeleteRequest(String url, int timeout) {
        String response = null;
        try {
            response = HttpUtil.executeUrl((String)HttpMethod.DELETE.name(), (String)url, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
        }
        return response;
    }

    public static String sendHttpDeleteRequest(String url, Map<String, String> headers, int timeout) {
        try {
            Properties headerProperties = new Properties();
            headerProperties.putAll(headers);
            return HttpUtil.executeUrl((String)HttpMethod.DELETE.name(), (String)url, (Properties)headerProperties, null, null, (int)timeout);
        }
        catch (IOException e) {
            logger.error("Fatal transport error: {}", (Object)e.getMessage());
            return null;
        }
    }

    @ActionDoc(text="downloads an image from a url and updates the Image item's state with it", returns="true if successful, false otherwise")
    public static boolean setImage(@ParamDoc(name="itemName", text="the name of the target Image Item") String itemName, @ParamDoc(name="url", text="the URL of the image") String url) {
        return HTTP.setImage(itemName, HttpUtil.downloadImage((String)url));
    }

    @ActionDoc(text="downloads an image from a url and updates the Image item's state with it", returns="true if successful, false otherwise")
    public static boolean setImage(@ParamDoc(name="itemName", text="the name of the target Image Item") String itemName, @ParamDoc(name="url", text="the URL of the image") String url, @ParamDoc(name="timeout", text="timeout in milliseconds") int timeout) {
        return HTTP.setImage(itemName, HttpUtil.downloadImage((String)url, (int)timeout));
    }

    @ActionDoc(text="downloads an image from a url and updates the Image item's state with it", returns="true if successful, false otherwise")
    public static boolean setImage(@ParamDoc(name="itemName", text="the name of the target Image Item") String itemName, @ParamDoc(name="url", text="the URL of the image") String url, @ParamDoc(name="maxContentLength", text="maximum data size in bytes, negative to ignore") long maxContentLength, @ParamDoc(name="timeout", text="timeout in milliseconds") int timeout) {
        return HTTP.setImage(itemName, HttpUtil.downloadImage((String)url, (boolean)true, (long)maxContentLength, (int)timeout));
    }

    private static boolean setImage(String itemName, RawType raw) {
        if (raw == null) {
            logger.error("Image download failed for item '{}'", (Object)itemName);
            return false;
        }
        ItemRegistry registry = ScriptServiceUtil.getItemRegistry();
        if (registry == null) {
            logger.error("Item registry is not available.");
            return false;
        }
        try {
            Item item = registry.getItem(itemName);
            BusEvent.postUpdate(item, (State)raw);
            return true;
        }
        catch (ItemNotFoundException e) {
            logger.error("Item '{}' does not exist.", (Object)itemName);
            return false;
        }
        catch (IllegalArgumentException e) {
            logger.error("Cannot update item '{}' with image: {}", (Object)itemName, (Object)e.getMessage());
            return false;
        }
    }
}

