/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.util.Locale;
import javax.security.auth.kerberos.ServicePermission;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;

public class Krb5NameElement
implements GSSNameSpi {
    private PrincipalName krb5PrincipalName;
    private String gssNameStr = null;
    private Oid gssNameType = null;
    private static String CHAR_ENCODING = "UTF-8";

    private Krb5NameElement(PrincipalName principalName, String string, Oid oid) {
        this.krb5PrincipalName = principalName;
        this.gssNameStr = string;
        this.gssNameType = oid;
    }

    static Krb5NameElement getInstance(String string, Oid oid) throws GSSException {
        Object object;
        PrincipalName principalName;
        if (oid == null) {
            oid = Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL;
        } else if (!(oid.equals(GSSName.NT_USER_NAME) || oid.equals(GSSName.NT_HOSTBASED_SERVICE) || oid.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL) || oid.equals(GSSName.NT_EXPORT_NAME))) {
            throw new GSSException(4, -1, oid.toString() + " is an unsupported nametype");
        }
        try {
            if (oid.equals(GSSName.NT_EXPORT_NAME) || oid.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL)) {
                principalName = new PrincipalName(string, 1);
            } else {
                object = Krb5NameElement.getComponents(string);
                if (oid.equals(GSSName.NT_USER_NAME)) {
                    principalName = new PrincipalName(string, 1);
                } else {
                    String string2 = null;
                    String string3 = object[0];
                    if (((String[])object).length >= 2) {
                        string2 = object[1];
                    }
                    String string4 = Krb5NameElement.getHostBasedInstance(string3, string2);
                    principalName = new PrincipalName(string4, 3);
                }
            }
        }
        catch (KrbException krbException) {
            throw new GSSException(3, -1, krbException.getMessage());
        }
        if (principalName.isRealmDeduced() && !Realm.AUTODEDUCEREALM && (object = System.getSecurityManager()) != null) {
            try {
                ((SecurityManager)object).checkPermission(new ServicePermission("@" + principalName.getRealmAsString(), "-"));
            }
            catch (SecurityException securityException) {
                throw new GSSException(11);
            }
        }
        return new Krb5NameElement(principalName, string, oid);
    }

    public static Krb5NameElement getInstance(PrincipalName principalName) {
        return new Krb5NameElement(principalName, principalName.getName(), Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
    }

    private static String[] getComponents(String string) throws GSSException {
        String[] stringArray;
        int n = string.lastIndexOf(64, string.length());
        if (n > 0 && string.charAt(n - 1) == '\\' && (n - 2 < 0 || string.charAt(n - 2) != '\\')) {
            n = -1;
        }
        if (n > 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            stringArray = new String[]{string2, string3};
        } else {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    private static String getHostBasedInstance(String string, String string2) throws GSSException {
        StringBuffer stringBuffer = new StringBuffer(string);
        try {
            if (string2 == null) {
                string2 = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        string2 = string2.toLowerCase(Locale.ENGLISH);
        stringBuffer = stringBuffer.append('/').append(string2);
        return stringBuffer.toString();
    }

    public final PrincipalName getKrb5PrincipalName() {
        return this.krb5PrincipalName;
    }

    @Override
    public boolean equals(GSSNameSpi gSSNameSpi) throws GSSException {
        if (gSSNameSpi == this) {
            return true;
        }
        if (gSSNameSpi instanceof Krb5NameElement) {
            Krb5NameElement krb5NameElement = (Krb5NameElement)gSSNameSpi;
            return this.krb5PrincipalName.getName().equals(krb5NameElement.krb5PrincipalName.getName());
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        try {
            if (object instanceof Krb5NameElement) {
                return this.equals((Krb5NameElement)object);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 629 + this.krb5PrincipalName.getName().hashCode();
    }

    @Override
    public byte[] export() throws GSSException {
        byte[] byArray = null;
        try {
            byArray = this.krb5PrincipalName.getName().getBytes(CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public String toString() {
        return this.gssNameStr;
    }

    public Oid getGSSNameType() {
        return this.gssNameType;
    }

    @Override
    public Oid getStringNameType() {
        return this.gssNameType;
    }

    @Override
    public boolean isAnonymousName() {
        return this.gssNameType.equals(GSSName.NT_ANONYMOUS);
    }

    @Override
    public Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }
}

