/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import sun.invoke.WrapperInstance;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class MethodHandleProxies {
    private MethodHandleProxies() {
    }

    @CallerSensitive
    public static <T> T asInterfaceInstance(final Class<T> clazz, final MethodHandle methodHandle) {
        Object object;
        Object object2;
        Object object3;
        MethodHandle methodHandle2;
        Object object4;
        Object object5;
        if (!clazz.isInterface() || !Modifier.isPublic(clazz.getModifiers())) {
            throw MethodHandleStatics.newIllegalArgumentException("not a public interface", clazz.getName());
        }
        if (System.getSecurityManager() != null) {
            object5 = Reflection.getCallerClass();
            object4 = object5 != null ? ((Class)object5).getClassLoader() : null;
            ReflectUtil.checkProxyPackageAccess((ClassLoader)object4, clazz);
            methodHandle2 = object4 != null ? MethodHandleProxies.bindCaller(methodHandle, object5) : methodHandle;
        } else {
            methodHandle2 = methodHandle;
        }
        object5 = clazz.getClassLoader();
        if (object5 == null) {
            object4 = Thread.currentThread().getContextClassLoader();
            Object object6 = object5 = object4 != null ? object4 : ClassLoader.getSystemClassLoader();
        }
        if ((object4 = MethodHandleProxies.getSingleNameMethods(clazz)) == null) {
            throw MethodHandleStatics.newIllegalArgumentException("not a single-method interface", clazz.getName());
        }
        MethodHandle[] methodHandleArray = new MethodHandle[((Method[])object4).length];
        for (int i = 0; i < ((Method[])object4).length; ++i) {
            object3 = object4[i];
            object2 = MethodType.methodType(((Method)object3).getReturnType(), ((Method)object3).getParameterTypes());
            object = methodHandle2.asType((MethodType)object2);
            object = ((MethodHandle)object).asType(((MethodHandle)object).type().changeReturnType(Object.class));
            methodHandleArray[i] = ((MethodHandle)object).asSpreader(Object[].class, ((MethodType)object2).parameterCount());
        }
        ConcurrentHashMap concurrentHashMap = MethodHandleProxies.hasDefaultMethods(clazz) ? new ConcurrentHashMap() : null;
        object3 = new InvocationHandler((Method[])object4, methodHandleArray, concurrentHashMap){
            final /* synthetic */ Method[] val$methods;
            final /* synthetic */ MethodHandle[] val$vaTargets;
            final /* synthetic */ ConcurrentHashMap val$defaultMethodMap;
            {
                this.val$methods = methodArray;
                this.val$vaTargets = methodHandleArray;
                this.val$defaultMethodMap = concurrentHashMap;
            }

            private Object getArg(String string) {
                if (string == "getWrapperInstanceTarget") {
                    return methodHandle;
                }
                if (string == "getWrapperInstanceType") {
                    return clazz;
                }
                throw new AssertionError();
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                for (int i = 0; i < this.val$methods.length; ++i) {
                    if (!method.equals(this.val$methods[i])) continue;
                    return this.val$vaTargets[i].invokeExact(objectArray);
                }
                if (method.getDeclaringClass() == WrapperInstance.class) {
                    return this.getArg(method.getName());
                }
                if (MethodHandleProxies.isObjectMethod(method)) {
                    return MethodHandleProxies.callObjectMethod(object, method, objectArray);
                }
                if (MethodHandleProxies.isDefaultMethod(method)) {
                    return MethodHandleProxies.callDefaultMethod(this.val$defaultMethodMap, object, clazz, method, objectArray);
                }
                throw MethodHandleStatics.newInternalError("bad proxy method: " + method);
            }
        };
        if (System.getSecurityManager() != null) {
            object = object5;
            object2 = AccessController.doPrivileged(new PrivilegedAction<Object>((ClassLoader)object, clazz, (InvocationHandler)object3){
                final /* synthetic */ ClassLoader val$loader;
                final /* synthetic */ Class val$intfc;
                final /* synthetic */ InvocationHandler val$ih;
                {
                    this.val$loader = classLoader;
                    this.val$intfc = clazz;
                    this.val$ih = invocationHandler;
                }

                @Override
                public Object run() {
                    return Proxy.newProxyInstance(this.val$loader, new Class[]{this.val$intfc, WrapperInstance.class}, this.val$ih);
                }
            });
        } else {
            object2 = Proxy.newProxyInstance((ClassLoader)object5, new Class[]{clazz, WrapperInstance.class}, (InvocationHandler)object3);
        }
        return clazz.cast(object2);
    }

    private static MethodHandle bindCaller(MethodHandle methodHandle, Class<?> clazz) {
        MethodHandle methodHandle2 = MethodHandleImpl.bindCaller(methodHandle, clazz);
        if (methodHandle.isVarargsCollector()) {
            MethodType methodType = methodHandle2.type();
            int n = methodType.parameterCount();
            return methodHandle2.asVarargsCollector(methodType.parameterType(n - 1));
        }
        return methodHandle2;
    }

    public static boolean isWrapperInstance(Object object) {
        return object instanceof WrapperInstance;
    }

    private static WrapperInstance asWrapperInstance(Object object) {
        try {
            if (object != null) {
                return (WrapperInstance)object;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw MethodHandleStatics.newIllegalArgumentException("not a wrapper instance");
    }

    public static MethodHandle wrapperInstanceTarget(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceTarget();
    }

    public static Class<?> wrapperInstanceType(Object object) {
        return MethodHandleProxies.asWrapperInstance(object).getWrapperInstanceType();
    }

    private static boolean isObjectMethod(Method method) {
        switch (method.getName()) {
            case "toString": {
                return method.getReturnType() == String.class && method.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
            }
            case "equals": {
                return method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private static Object callObjectMethod(Object object, Method method, Object[] objectArray) {
        assert (MethodHandleProxies.isObjectMethod(method)) : method;
        switch (method.getName()) {
            case "toString": {
                return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
            }
            case "hashCode": {
                return System.identityHashCode(object);
            }
            case "equals": {
                return object == objectArray[0];
            }
        }
        return null;
    }

    private static Method[] getSingleNameMethods(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        String string = null;
        for (Method method : clazz.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(method) || !Modifier.isAbstract(method.getModifiers())) continue;
            String string2 = method.getName();
            if (string == null) {
                string = string2;
            } else if (!string.equals(string2)) {
                return null;
            }
            arrayList.add(method);
        }
        if (string == null) {
            return null;
        }
        return arrayList.toArray(new Method[arrayList.size()]);
    }

    private static boolean isDefaultMethod(Method method) {
        return !Modifier.isAbstract(method.getModifiers());
    }

    private static boolean hasDefaultMethods(Class<?> clazz) {
        for (Method method : clazz.getMethods()) {
            if (MethodHandleProxies.isObjectMethod(method) || Modifier.isAbstract(method.getModifiers())) continue;
            return true;
        }
        return false;
    }

    private static Object callDefaultMethod(ConcurrentHashMap<Method, MethodHandle> concurrentHashMap, Object object, Class<?> clazz, Method method2, Object[] objectArray) throws Throwable {
        assert (MethodHandleProxies.isDefaultMethod(method2) && !MethodHandleProxies.isObjectMethod(method2)) : method2;
        MethodHandle methodHandle = concurrentHashMap.computeIfAbsent(method2, method -> {
            try {
                MethodHandle methodHandle = MethodHandles.Lookup.IMPL_LOOKUP.findSpecial(clazz, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), object.getClass());
                return methodHandle.asSpreader(Object[].class, method.getParameterCount());
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw new InternalError(reflectiveOperationException);
            }
        });
        return methodHandle.invoke(object, objectArray);
    }
}

