macro(configure_stats_backend _NAME_TARGET)
    set(PREVIOUS_INVOCATION ${CONFIGURE_STATS_BACKEND_INVOKED_PREVIOUSLY})
    target_compile_definitions(${_NAME_TARGET} PRIVATE -D USE_STATS)
    find_library(MATH_LIBRARY m)
    if(MATH_LIBRARY)
        TARGET_LINK_LIBRARIES(${_NAME_TARGET} PRIVATE ${MATH_LIBRARY})
    endif()
    if(NOT PREVIOUS_INVOCATION)
        message(STATUS "Support for statistics backend - Ready")
    endif()
    set(CONFIGURE_STATS_BACKEND_INVOKED_PREVIOUSLY YES CACHE
        INTERNAL "Mark if CONFIGURE_STATS_BACKEND called successfully" FORCE)
endmacro()
