/*****************************************************************************
 * hevc_test: H265 packetizer unit testing
 *****************************************************************************
 * Copyright (C) 2019 VideoLabs, VideoLAN and VLC Authors
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <vlc/vlc.h>
#include "../../../lib/libvlc_internal.h"
#include "../../libvlc/test.h"

#include "packetizer.h"

/* 16x16, keyint 25, 50frames */
const uint8_t test_samples_raw_h265[] = {
  0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01, 0xff, 0xff, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x1e,
  0x95, 0x98, 0x09, 0x00, 0x00, 0x00, 0x01, 0x42, 0x01, 0x01, 0x04, 0x08,
  0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00, 0x03, 0x00, 0x00, 0x1e,
  0x90, 0x11, 0x08, 0xb2, 0xca, 0xcd, 0x57, 0x95, 0xcd, 0x40, 0x80, 0x80,
  0x01, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x03, 0x00, 0x19, 0x08,
  0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc1, 0x73, 0x18, 0x31, 0x08, 0x90,
  0x00, 0x00, 0x01, 0x28, 0x01, 0xaf, 0x19, 0x80, 0xef, 0xef, 0xcb, 0x5f,
  0xfe, 0x52, 0x0b, 0xfe, 0xbb, 0x6d, 0xfd, 0x0f, 0xf8, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x01, 0xd0, 0x29, 0x4b, 0xe1, 0x0c, 0x20, 0xa4, 0xfa, 0x44,
  0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xe0, 0x64, 0x9d, 0x78, 0x20, 0xc4,
  0xbf, 0x20, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe0, 0x24, 0xf5, 0x5f,
  0xa2, 0x41, 0xd8, 0xc1, 0xe0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe0,
  0x44, 0xd7, 0x5f, 0xa2, 0x41, 0xc8, 0xc1, 0xe0, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x01, 0xe0, 0x86, 0xb7, 0xfd, 0x42, 0x0e, 0xc0, 0xc1, 0xe0, 0x00,
  0x00, 0x00, 0x01, 0x02, 0x01, 0xd0, 0x50, 0x92, 0xd5, 0xfd, 0xc4, 0x30,
  0x08, 0x90, 0xea, 0xca, 0xf7, 0xb0, 0xeb, 0x50, 0x00, 0x00, 0x00, 0x01,
  0x02, 0x01, 0xe1, 0x02, 0x27, 0x57, 0x5f, 0x70, 0x82, 0x10, 0x48, 0x3f,
  0xa0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe0, 0xc6, 0xf5, 0x55, 0xf4,
  0x89, 0x07, 0x60, 0xc1, 0xe0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe0,
  0xe6, 0xd5, 0x75, 0xf4, 0x89, 0x06, 0x20, 0xbf, 0x20, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0xe1, 0x22, 0x2d, 0xd7, 0xf7, 0x08, 0x23, 0xbe, 0xe0,
  0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xd0, 0x78, 0xb2, 0xd5, 0xd7, 0xdc,
  0x43, 0x00, 0x87, 0x40, 0xf4, 0x8a, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01,
  0xe1, 0xa2, 0x27, 0x52, 0xd7, 0xdc, 0x25, 0xb8, 0x60, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0xe1, 0x66, 0xf5, 0x55, 0xf4, 0x89, 0x0d, 0x80, 0xbe,
  0xa0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe1, 0x86, 0xd5, 0x75, 0xf4,
  0x89, 0x08, 0x80, 0xbb, 0xa0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe1,
  0xc2, 0x2d, 0xd7, 0xf7, 0x09, 0xc0, 0xb8, 0x60, 0x00, 0x00, 0x00, 0x01,
  0x02, 0x01, 0xd0, 0xa0, 0xb2, 0xd5, 0xd7, 0xdc, 0x43, 0x00, 0x83, 0xd0,
  0xef, 0xac, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xe2, 0x42, 0x27, 0x52,
  0xd7, 0xdc, 0x20, 0x9c, 0xad, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
  0xe2, 0x06, 0xf5, 0x55, 0xf4, 0x89, 0x1a, 0xb6, 0xb0, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0xe2, 0x26, 0xd5, 0x75, 0xf4, 0x89, 0x0b, 0x80, 0xb3,
  0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe2, 0x62, 0x2d, 0xd7, 0xf7,
  0x08, 0x27, 0xad, 0x50, 0x00, 0x00, 0x00, 0x01, 0x40, 0x01, 0x0c, 0x01,
  0xff, 0xff, 0x04, 0x08, 0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x1e, 0x95, 0x98, 0x09, 0x00, 0x00, 0x00, 0x01, 0x42,
  0x01, 0x01, 0x04, 0x08, 0x00, 0x00, 0x03, 0x00, 0x9e, 0x08, 0x00, 0x00,
  0x03, 0x00, 0x00, 0x1e, 0x90, 0x11, 0x08, 0xb2, 0xca, 0xcd, 0x57, 0x95,
  0xcd, 0x40, 0x80, 0x80, 0x01, 0x00, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00,
  0x03, 0x00, 0x19, 0x08, 0x00, 0x00, 0x00, 0x01, 0x44, 0x01, 0xc1, 0x73,
  0x18, 0x31, 0x08, 0x90, 0x00, 0x00, 0x01, 0x2a, 0x01, 0xac, 0x64, 0x59,
  0x48, 0xc9, 0xcb, 0x80, 0xf7, 0x06, 0x46, 0x3f, 0xfd, 0xb5, 0xad, 0xff,
  0xc7, 0x0a, 0xff, 0xe7, 0xc3, 0xe0, 0x00, 0x00, 0x00, 0x01, 0x12, 0x01,
  0xe2, 0xe2, 0x27, 0x52, 0xd7, 0xdc, 0x20, 0xd4, 0xa7, 0xb0, 0x00, 0x00,
  0x00, 0x01, 0x10, 0x01, 0xe2, 0xa6, 0xf5, 0x55, 0xf4, 0x89, 0x05, 0xa0,
  0xab, 0x30, 0x00, 0x00, 0x00, 0x01, 0x10, 0x01, 0xe2, 0xc6, 0xd5, 0x75,
  0xf4, 0x89, 0x05, 0xe0, 0xab, 0x30, 0x00, 0x00, 0x00, 0x01, 0x10, 0x01,
  0xe3, 0x02, 0x2d, 0xd7, 0xf7, 0x08, 0x2f, 0xab, 0x30, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x01, 0xd0, 0xf1, 0x4b, 0xe1, 0x0c, 0x21, 0xf0, 0xf4, 0x8a,
  0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xe3, 0x84, 0x9d, 0x78, 0x21, 0x70,
  0xb3, 0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe3, 0x44, 0xf5, 0x5f,
  0xa2, 0x47, 0x80, 0xb6, 0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe3,
  0x64, 0xd7, 0x5f, 0xa2, 0x47, 0x80, 0xb6, 0xb0, 0x00, 0x00, 0x00, 0x01,
  0x00, 0x01, 0xe3, 0xa6, 0xb7, 0xfd, 0x42, 0x34, 0xb6, 0xb0, 0x00, 0x00,
  0x00, 0x01, 0x02, 0x01, 0xd1, 0x18, 0x92, 0xd5, 0xfd, 0xc4, 0x30, 0x08,
  0x3f, 0xef, 0xac, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xe4, 0x22, 0x27,
  0x57, 0x5f, 0x70, 0x82, 0x50, 0xad, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x01, 0xe3, 0xe6, 0xf5, 0x55, 0xf4, 0x89, 0x1e, 0xb6, 0xb0, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x01, 0xe4, 0x06, 0xd5, 0x75, 0xf4, 0x89, 0x0b, 0x80,
  0xb3, 0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe4, 0x42, 0x2d, 0xd7,
  0xf7, 0x08, 0x25, 0xad, 0x50, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xd1,
  0x40, 0xb2, 0xd5, 0xd7, 0xdc, 0x43, 0x00, 0x81, 0x7c, 0xe7, 0xb6, 0x00,
  0x00, 0x00, 0x01, 0x02, 0x01, 0xe4, 0xc2, 0x27, 0x52, 0xd7, 0xdc, 0x20,
  0x45, 0xa0, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe4, 0x86, 0xf5,
  0x55, 0xf4, 0x89, 0x05, 0xa0, 0xab, 0x30, 0x00, 0x00, 0x00, 0x01, 0x00,
  0x01, 0xe4, 0xa6, 0xd5, 0x75, 0xf4, 0x89, 0x06, 0xe0, 0xa7, 0xb0, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x01, 0xe4, 0xe2, 0x2d, 0xd7, 0xf7, 0x08, 0x11,
  0x40, 0xa0, 0x50, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xd1, 0x68, 0xb2,
  0xd5, 0xd7, 0xdc, 0x43, 0x00, 0x81, 0xfc, 0x2b, 0xda, 0x00, 0x00, 0x00,
  0x01, 0x02, 0x01, 0xe5, 0x62, 0x27, 0x52, 0xd7, 0xdc, 0x20, 0x65, 0x94,
  0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe5, 0x26, 0xf5, 0x55, 0xf4,
  0x89, 0x02, 0x68, 0x9c, 0x50, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe5,
  0x46, 0xd5, 0x75, 0xf4, 0x89, 0x02, 0xb8, 0x98, 0x98, 0x00, 0x00, 0x00,
  0x01, 0x00, 0x01, 0xe5, 0x82, 0x2d, 0xd7, 0xf7, 0x08, 0x19, 0x40, 0x94,
  0xa8, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0xd1, 0x88, 0xb2, 0x55, 0xd7,
  0xdc, 0x43, 0x00, 0x80, 0x87, 0x2b, 0xda, 0x00, 0x00, 0x00, 0x01, 0x02,
  0x01, 0xe5, 0xe2, 0x25, 0x52, 0xd7, 0xdc, 0x20, 0x75, 0x8a, 0x68, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x01, 0xe5, 0xc6, 0xf5, 0xd7, 0xd2, 0x24, 0x0d,
  0xa0, 0x8f, 0xa8, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0xe6, 0x02, 0x2d,
  0x57, 0xf7, 0x08, 0x1b, 0xc0, 0x8f, 0xa8
};
const size_t test_samples_raw_h265_len = 979;

int main(void)
{
    test_init();

    libvlc_instance_t *vlc = libvlc_new(0, NULL);
    if(!vlc)
        return 1;

    struct params_s params;
    params.vlc = vlc;
    params.obj = VLC_OBJECT(vlc->p_libvlc_int);
    params.codec = VLC_CODEC_HEVC;
    params.i_rate_num = 0;
    params.i_rate_den = 0;
    params.i_frame_count = 2*25;
    params.b_extra = true;

    params.i_read_size = 500;
    RUN("block 500", test_packetize,
        test_samples_raw_h265, test_samples_raw_h265_len, 0);

    params.i_rate_num = 60000;
    params.i_rate_den = 1001;
    params.i_read_size = 8;
    RUN("block 8", test_packetize,
        test_samples_raw_h265, test_samples_raw_h265_len, 0);

    params.i_frame_count = 1*25 + 4 /* RASL from previous GOP */;
    params.i_read_size = 500;
    RUN("skip 1st Iframe", test_packetize,
        test_samples_raw_h265 + 10, test_samples_raw_h265_len - 10, 0);

    libvlc_release(vlc);
    return 0;
}
