# Building / Developing / Contributing

The `dst` package relies heavily on code generation. So heavily, in fact, that `README.md` is
itself generated by a preprocessor! Here are a few tips/tricks to get started developing `dst`.

## Adding Features, Fixing Bugs

Generally speaking, code handling node annotation is generated from the files in the `gendst` directory.
In order to add/change decorations, edit the `gendst/data.go` file. Once you have made your edits, you can
regenerate the library's source code based on those changes by

1. `go run github.com/dave/dst/gendst`: This command will build and run a program generated from the
   source code in the `gendst` folder that regenerates all the dst source fiels to reflect the changes
   that you just made in the `gendst/data.go` file.

Whenever you make a change to the `gendst/data.go` file, you must perform the aforementioned step.

If you add a Node to the `gendst/data.go` file, you will need to make corresponding additions to non-generated
files as well. Those files include, but are not limited to,:

- `dst.go`
- `walk.go`
- `dstutil/rewrite.go`

Depending on the changes that you have made to the description of the decorated Nodes, you may have to change some, none,
or all of those files listed above (or even others that are not listed!).

## Adding/Running Tests

Any changes to the decorations of Nodes (or the addition of new Nodes) should be accompanied
by an entry in `gendst/positions.go`.

The format of the file is ...

```
// <NodeTypeName>
// <Example of NodeType used (in real go), with a comment in every decoration point
// whose contents are the name of the decoration point.
```

For instance,

```
// Field
type A struct {
	/*Start*/ A int /*Type*/ `a:"a"` /*End*/
}
```

will generate a test that guarantees that all the decoration points for an `Field` node are handled correctly.
It is important to see that, although the `Field` node is *wrapped* in a `TypeSpec`, only the `Field` decoration
points are labeled here. That is because the `// Field` that precedes the code indicates that this test is specifically
for a `Field` node.

As with the `gendst/data.go` file, if you make changes to the `gendst/positions.go` file, you will need to run 
`gendst` to bring all the sources files in the project into sync.

Once you have generated new tests, running the test suite is straightforward:

```
go test ./...
```

## Updating This README.md

Make all content changes in the `README.md.tpl` file. Then, regenerate `README.md` with

```
becca -package .
```

You can install `becca` using the `go` tools:

```
go install github.com/dave/rebecca/cmd/becca@latest
```

You can find out more about `becca` at the project's [GitHub](https://github.com/dave/rebecca).
