// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// NewWebhookServiceUpdateWebhookParams creates a new WebhookServiceUpdateWebhookParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebhookServiceUpdateWebhookParams() *WebhookServiceUpdateWebhookParams {
	return &WebhookServiceUpdateWebhookParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebhookServiceUpdateWebhookParamsWithTimeout creates a new WebhookServiceUpdateWebhookParams object
// with the ability to set a timeout on a request.
func NewWebhookServiceUpdateWebhookParamsWithTimeout(timeout time.Duration) *WebhookServiceUpdateWebhookParams {
	return &WebhookServiceUpdateWebhookParams{
		timeout: timeout,
	}
}

// NewWebhookServiceUpdateWebhookParamsWithContext creates a new WebhookServiceUpdateWebhookParams object
// with the ability to set a context for a request.
func NewWebhookServiceUpdateWebhookParamsWithContext(ctx context.Context) *WebhookServiceUpdateWebhookParams {
	return &WebhookServiceUpdateWebhookParams{
		Context: ctx,
	}
}

// NewWebhookServiceUpdateWebhookParamsWithHTTPClient creates a new WebhookServiceUpdateWebhookParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebhookServiceUpdateWebhookParamsWithHTTPClient(client *http.Client) *WebhookServiceUpdateWebhookParams {
	return &WebhookServiceUpdateWebhookParams{
		HTTPClient: client,
	}
}

/*
WebhookServiceUpdateWebhookParams contains all the parameters to send to the API endpoint

	for the webhook service update webhook operation.

	Typically these are written to a http.Request.
*/
type WebhookServiceUpdateWebhookParams struct {

	/* Body.

	   The information to update a webhook.
	*/
	Body *models.HashicorpCloudWebhookUpdateWebhookRequestBody

	/* ResourceName.

	     The webhook resource name.
	A webhook's resource name format name is `webhook/project/<project-id>/geo/<geography>/webhook/<webhook-name>`.
	*/
	ResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the webhook service update webhook params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceUpdateWebhookParams) WithDefaults() *WebhookServiceUpdateWebhookParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the webhook service update webhook params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceUpdateWebhookParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) WithTimeout(timeout time.Duration) *WebhookServiceUpdateWebhookParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) WithContext(ctx context.Context) *WebhookServiceUpdateWebhookParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) WithHTTPClient(client *http.Client) *WebhookServiceUpdateWebhookParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) WithBody(body *models.HashicorpCloudWebhookUpdateWebhookRequestBody) *WebhookServiceUpdateWebhookParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) SetBody(body *models.HashicorpCloudWebhookUpdateWebhookRequestBody) {
	o.Body = body
}

// WithResourceName adds the resourceName to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) WithResourceName(resourceName string) *WebhookServiceUpdateWebhookParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the webhook service update webhook params
func (o *WebhookServiceUpdateWebhookParams) SetResourceName(resourceName string) {
	o.ResourceName = resourceName
}

// WriteToRequest writes these params to a swagger request
func (o *WebhookServiceUpdateWebhookParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param resource_name
	if err := r.SetPathParam("resource_name", o.ResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
