// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListNoCodeModulesReader is a Reader for the WaypointServiceListNoCodeModules structure.
type WaypointServiceListNoCodeModulesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListNoCodeModulesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListNoCodeModulesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListNoCodeModulesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListNoCodeModulesOK creates a WaypointServiceListNoCodeModulesOK with default headers values
func NewWaypointServiceListNoCodeModulesOK() *WaypointServiceListNoCodeModulesOK {
	return &WaypointServiceListNoCodeModulesOK{}
}

/*
WaypointServiceListNoCodeModulesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListNoCodeModulesOK struct {
	Payload *models.HashicorpCloudWaypointListNoCodeModulesResponse
}

// IsSuccess returns true when this waypoint service list no code modules o k response has a 2xx status code
func (o *WaypointServiceListNoCodeModulesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list no code modules o k response has a 3xx status code
func (o *WaypointServiceListNoCodeModulesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list no code modules o k response has a 4xx status code
func (o *WaypointServiceListNoCodeModulesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list no code modules o k response has a 5xx status code
func (o *WaypointServiceListNoCodeModulesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list no code modules o k response a status code equal to that given
func (o *WaypointServiceListNoCodeModulesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list no code modules o k response
func (o *WaypointServiceListNoCodeModulesOK) Code() int {
	return 200
}

func (o *WaypointServiceListNoCodeModulesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcmodules][%d] waypointServiceListNoCodeModulesOK %s", 200, payload)
}

func (o *WaypointServiceListNoCodeModulesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcmodules][%d] waypointServiceListNoCodeModulesOK %s", 200, payload)
}

func (o *WaypointServiceListNoCodeModulesOK) GetPayload() *models.HashicorpCloudWaypointListNoCodeModulesResponse {
	return o.Payload
}

func (o *WaypointServiceListNoCodeModulesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListNoCodeModulesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListNoCodeModulesDefault creates a WaypointServiceListNoCodeModulesDefault with default headers values
func NewWaypointServiceListNoCodeModulesDefault(code int) *WaypointServiceListNoCodeModulesDefault {
	return &WaypointServiceListNoCodeModulesDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListNoCodeModulesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListNoCodeModulesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list no code modules default response has a 2xx status code
func (o *WaypointServiceListNoCodeModulesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list no code modules default response has a 3xx status code
func (o *WaypointServiceListNoCodeModulesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list no code modules default response has a 4xx status code
func (o *WaypointServiceListNoCodeModulesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list no code modules default response has a 5xx status code
func (o *WaypointServiceListNoCodeModulesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list no code modules default response a status code equal to that given
func (o *WaypointServiceListNoCodeModulesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list no code modules default response
func (o *WaypointServiceListNoCodeModulesDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListNoCodeModulesDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcmodules][%d] WaypointService_ListNoCodeModules default %s", o._statusCode, payload)
}

func (o *WaypointServiceListNoCodeModulesDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/tfcmodules][%d] WaypointService_ListNoCodeModules default %s", o._statusCode, payload)
}

func (o *WaypointServiceListNoCodeModulesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListNoCodeModulesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
