// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetGatewayPoolReader is a Reader for the GetGatewayPool structure.
type GetGatewayPoolReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGatewayPoolReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGatewayPoolOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetGatewayPoolDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetGatewayPoolOK creates a GetGatewayPoolOK with default headers values
func NewGetGatewayPoolOK() *GetGatewayPoolOK {
	return &GetGatewayPoolOK{}
}

/*
GetGatewayPoolOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetGatewayPoolOK struct {
	Payload *models.Secrets20231128GetGatewayPoolResponse
}

// IsSuccess returns true when this get gateway pool o k response has a 2xx status code
func (o *GetGatewayPoolOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get gateway pool o k response has a 3xx status code
func (o *GetGatewayPoolOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get gateway pool o k response has a 4xx status code
func (o *GetGatewayPoolOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get gateway pool o k response has a 5xx status code
func (o *GetGatewayPoolOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get gateway pool o k response a status code equal to that given
func (o *GetGatewayPoolOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get gateway pool o k response
func (o *GetGatewayPoolOK) Code() int {
	return 200
}

func (o *GetGatewayPoolOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] getGatewayPoolOK %s", 200, payload)
}

func (o *GetGatewayPoolOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] getGatewayPoolOK %s", 200, payload)
}

func (o *GetGatewayPoolOK) GetPayload() *models.Secrets20231128GetGatewayPoolResponse {
	return o.Payload
}

func (o *GetGatewayPoolOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetGatewayPoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGatewayPoolDefault creates a GetGatewayPoolDefault with default headers values
func NewGetGatewayPoolDefault(code int) *GetGatewayPoolDefault {
	return &GetGatewayPoolDefault{
		_statusCode: code,
	}
}

/*
GetGatewayPoolDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetGatewayPoolDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get gateway pool default response has a 2xx status code
func (o *GetGatewayPoolDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get gateway pool default response has a 3xx status code
func (o *GetGatewayPoolDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get gateway pool default response has a 4xx status code
func (o *GetGatewayPoolDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get gateway pool default response has a 5xx status code
func (o *GetGatewayPoolDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get gateway pool default response a status code equal to that given
func (o *GetGatewayPoolDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get gateway pool default response
func (o *GetGatewayPoolDefault) Code() int {
	return o._statusCode
}

func (o *GetGatewayPoolDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] GetGatewayPool default %s", o._statusCode, payload)
}

func (o *GetGatewayPoolDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] GetGatewayPool default %s", o._statusCode, payload)
}

func (o *GetGatewayPoolDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetGatewayPoolDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
