// Code generated by go-swagger; DO NOT EDIT.

package tenant_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// CreateTenantReader is a Reader for the CreateTenant structure.
type CreateTenantReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateTenantReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateTenantOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateTenantDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateTenantOK creates a CreateTenantOK with default headers values
func NewCreateTenantOK() *CreateTenantOK {
	return &CreateTenantOK{}
}

/*
CreateTenantOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateTenantOK struct {
	Payload *models.VaultRadar20230501TenantCreateResponse
}

// IsSuccess returns true when this create tenant o k response has a 2xx status code
func (o *CreateTenantOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create tenant o k response has a 3xx status code
func (o *CreateTenantOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create tenant o k response has a 4xx status code
func (o *CreateTenantOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create tenant o k response has a 5xx status code
func (o *CreateTenantOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create tenant o k response a status code equal to that given
func (o *CreateTenantOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create tenant o k response
func (o *CreateTenantOK) Code() int {
	return 200
}

func (o *CreateTenantOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants][%d] createTenantOK  %+v", 200, o.Payload)
}

func (o *CreateTenantOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants][%d] createTenantOK  %+v", 200, o.Payload)
}

func (o *CreateTenantOK) GetPayload() *models.VaultRadar20230501TenantCreateResponse {
	return o.Payload
}

func (o *CreateTenantOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.VaultRadar20230501TenantCreateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateTenantDefault creates a CreateTenantDefault with default headers values
func NewCreateTenantDefault(code int) *CreateTenantDefault {
	return &CreateTenantDefault{
		_statusCode: code,
	}
}

/*
CreateTenantDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateTenantDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create tenant default response has a 2xx status code
func (o *CreateTenantDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create tenant default response has a 3xx status code
func (o *CreateTenantDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create tenant default response has a 4xx status code
func (o *CreateTenantDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create tenant default response has a 5xx status code
func (o *CreateTenantDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create tenant default response a status code equal to that given
func (o *CreateTenantDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create tenant default response
func (o *CreateTenantDefault) Code() int {
	return o._statusCode
}

func (o *CreateTenantDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants][%d] CreateTenant default  %+v", o._statusCode, o.Payload)
}

func (o *CreateTenantDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants][%d] CreateTenant default  %+v", o._statusCode, o.Payload)
}

func (o *CreateTenantDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateTenantDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateTenantBody create tenant body
swagger:model CreateTenantBody
*/
type CreateTenantBody struct {

	// location
	Location *CreateTenantParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this create tenant body
func (o *CreateTenantBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateTenantBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create tenant body based on the context it is used
func (o *CreateTenantBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateTenantBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateTenantBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateTenantBody) UnmarshalBinary(b []byte) error {
	var res CreateTenantBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateTenantParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateTenantParamsBodyLocation
*/
type CreateTenantParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create tenant params body location
func (o *CreateTenantParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateTenantParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create tenant params body location based on the context it is used
func (o *CreateTenantParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateTenantParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateTenantParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateTenantParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateTenantParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
