// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceCreateProjectServicePrincipalReader is a Reader for the ServicePrincipalsServiceCreateProjectServicePrincipal structure.
type ServicePrincipalsServiceCreateProjectServicePrincipalReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceCreateProjectServicePrincipalOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceCreateProjectServicePrincipalDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceCreateProjectServicePrincipalOK creates a ServicePrincipalsServiceCreateProjectServicePrincipalOK with default headers values
func NewServicePrincipalsServiceCreateProjectServicePrincipalOK() *ServicePrincipalsServiceCreateProjectServicePrincipalOK {
	return &ServicePrincipalsServiceCreateProjectServicePrincipalOK{}
}

/*
ServicePrincipalsServiceCreateProjectServicePrincipalOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceCreateProjectServicePrincipalOK struct {
	Payload *models.HashicorpCloudIamCreateProjectServicePrincipalResponse
}

// IsSuccess returns true when this service principals service create project service principal o k response has a 2xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service create project service principal o k response has a 3xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service create project service principal o k response has a 4xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service create project service principal o k response has a 5xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service create project service principal o k response a status code equal to that given
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service create project service principal o k response
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals][%d] servicePrincipalsServiceCreateProjectServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals][%d] servicePrincipalsServiceCreateProjectServicePrincipalOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) GetPayload() *models.HashicorpCloudIamCreateProjectServicePrincipalResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamCreateProjectServicePrincipalResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceCreateProjectServicePrincipalDefault creates a ServicePrincipalsServiceCreateProjectServicePrincipalDefault with default headers values
func NewServicePrincipalsServiceCreateProjectServicePrincipalDefault(code int) *ServicePrincipalsServiceCreateProjectServicePrincipalDefault {
	return &ServicePrincipalsServiceCreateProjectServicePrincipalDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceCreateProjectServicePrincipalDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceCreateProjectServicePrincipalDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service create project service principal default response has a 2xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service create project service principal default response has a 3xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service create project service principal default response has a 4xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service create project service principal default response has a 5xx status code
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service create project service principal default response a status code equal to that given
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service create project service principal default response
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals][%d] ServicePrincipalsService_CreateProjectServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/organizations/{organization_id}/projects/{project_id}/service-principals][%d] ServicePrincipalsService_CreateProjectServicePrincipal default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceCreateProjectServicePrincipalDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ServicePrincipalsServiceCreateProjectServicePrincipalBody CreateProjectServicePrincipalRequest is the request message used when creating a
// service principal on project level.
swagger:model ServicePrincipalsServiceCreateProjectServicePrincipalBody
*/
type ServicePrincipalsServiceCreateProjectServicePrincipalBody struct {

	// name is the customer-chosen name for this service principal.
	Name string `json:"name,omitempty"`
}

// Validate validates this service principals service create project service principal body
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this service principals service create project service principal body based on context it is used
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ServicePrincipalsServiceCreateProjectServicePrincipalBody) UnmarshalBinary(b []byte) error {
	var res ServicePrincipalsServiceCreateProjectServicePrincipalBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
