// Code generated by go-swagger; DO NOT EDIT.

package clusters

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2023-10-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetClusterReader is a Reader for the GetCluster structure.
type GetClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetClusterOK creates a GetClusterOK with default headers values
func NewGetClusterOK() *GetClusterOK {
	return &GetClusterOK{}
}

/*
GetClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetClusterOK struct {
	Payload *models.HashicorpCloudConsulCloudManager20231010GetClusterResponse
}

// IsSuccess returns true when this get cluster o k response has a 2xx status code
func (o *GetClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get cluster o k response has a 3xx status code
func (o *GetClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get cluster o k response has a 4xx status code
func (o *GetClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get cluster o k response has a 5xx status code
func (o *GetClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get cluster o k response a status code equal to that given
func (o *GetClusterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get cluster o k response
func (o *GetClusterOK) Code() int {
	return 200
}

func (o *GetClusterOK) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{resource_name}][%d] getClusterOK  %+v", 200, o.Payload)
}

func (o *GetClusterOK) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{resource_name}][%d] getClusterOK  %+v", 200, o.Payload)
}

func (o *GetClusterOK) GetPayload() *models.HashicorpCloudConsulCloudManager20231010GetClusterResponse {
	return o.Payload
}

func (o *GetClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulCloudManager20231010GetClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetClusterDefault creates a GetClusterDefault with default headers values
func NewGetClusterDefault(code int) *GetClusterDefault {
	return &GetClusterDefault{
		_statusCode: code,
	}
}

/*
GetClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetClusterDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get cluster default response has a 2xx status code
func (o *GetClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get cluster default response has a 3xx status code
func (o *GetClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get cluster default response has a 4xx status code
func (o *GetClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get cluster default response has a 5xx status code
func (o *GetClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get cluster default response a status code equal to that given
func (o *GetClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get cluster default response
func (o *GetClusterDefault) Code() int {
	return o._statusCode
}

func (o *GetClusterDefault) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{resource_name}][%d] Get Cluster default  %+v", o._statusCode, o.Payload)
}

func (o *GetClusterDefault) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{resource_name}][%d] Get Cluster default  %+v", o._statusCode, o.Payload)
}

func (o *GetClusterDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
