// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribeservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateCallAnalyticsCategory = "CreateCallAnalyticsCategory"

// CreateCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCallAnalyticsCategory for more information on using the CreateCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCallAnalyticsCategoryRequest method.
//	req, resp := client.CreateCallAnalyticsCategoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory
func (c *TranscribeService) CreateCallAnalyticsCategoryRequest(input *CreateCallAnalyticsCategoryInput) (req *request.Request, output *CreateCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opCreateCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCallAnalyticsCategoryInput{}
	}

	output = &CreateCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Creates a new Call Analytics category.
//
// All categories are automatically applied to your Call Analytics transcriptions.
// Note that in order to apply categories to your transcriptions, you must create
// them before submitting your transcription request, as categories cannot be
// applied retroactively.
//
// When creating a new category, you can use the InputType parameter to label
// the category as a POST_CALL or a REAL_TIME category. POST_CALL categories
// can only be applied to post-call transcriptions and REAL_TIME categories
// can only be applied to real-time transcriptions. If you do not include InputType,
// your category is created as a POST_CALL category by default.
//
// Call Analytics categories are composed of rules. For each category, you must
// create between 1 and 20 rules. Rules can include these parameters: , , ,
// and .
//
// To update an existing category, see .
//
// To learn more about Call Analytics categories, see Creating categories for
// post-call transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html)
// and Creating categories for real-time transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateCallAnalyticsCategory
func (c *TranscribeService) CreateCallAnalyticsCategory(input *CreateCallAnalyticsCategoryInput) (*CreateCallAnalyticsCategoryOutput, error) {
	req, out := c.CreateCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// CreateCallAnalyticsCategoryWithContext is the same as CreateCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateCallAnalyticsCategoryWithContext(ctx aws.Context, input *CreateCallAnalyticsCategoryInput, opts ...request.Option) (*CreateCallAnalyticsCategoryOutput, error) {
	req, out := c.CreateCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLanguageModel = "CreateLanguageModel"

// CreateLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLanguageModel for more information on using the CreateLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLanguageModelRequest method.
//	req, resp := client.CreateLanguageModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModelRequest(input *CreateLanguageModelInput) (req *request.Request, output *CreateLanguageModelOutput) {
	op := &request.Operation{
		Name:       opCreateLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLanguageModelInput{}
	}

	output = &CreateLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLanguageModel API operation for Amazon Transcribe Service.
//
// Creates a new custom language model.
//
// When creating a new custom language model, you must specify:
//
//   - If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband
//     (audio sample rates under 16,000 Hz) base model
//
//   - The location of your training and tuning files (this must be an Amazon
//     S3 URI)
//
//   - The language of your model
//
//   - A unique name for your model
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateLanguageModel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateLanguageModel
func (c *TranscribeService) CreateLanguageModel(input *CreateLanguageModelInput) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	return out, req.Send()
}

// CreateLanguageModelWithContext is the same as CreateLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateLanguageModelWithContext(ctx aws.Context, input *CreateLanguageModelInput, opts ...request.Option) (*CreateLanguageModelOutput, error) {
	req, out := c.CreateLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMedicalVocabulary = "CreateMedicalVocabulary"

// CreateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMedicalVocabulary for more information on using the CreateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMedicalVocabularyRequest method.
//	req, resp := client.CreateMedicalVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabularyRequest(input *CreateMedicalVocabularyInput) (req *request.Request, output *CreateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateMedicalVocabularyInput{}
	}

	output = &CreateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom medical vocabulary.
//
// Before creating a new custom medical vocabulary, you must first upload a
// text file that contains your vocabulary table into an Amazon S3 bucket. Note
// that this differs from , where you can include a list of terms within your
// request using the Phrases flag; CreateMedicalVocabulary does not support
// the Phrases flag and only accepts vocabularies in table format.
//
// Each language has a character set that contains all allowed characters for
// that specific language. If you use unsupported characters, your custom vocabulary
// request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
// to get the character set for your language.
//
// For more information, see Custom vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateMedicalVocabulary
func (c *TranscribeService) CreateMedicalVocabulary(input *CreateMedicalVocabularyInput) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// CreateMedicalVocabularyWithContext is the same as CreateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateMedicalVocabularyWithContext(ctx aws.Context, input *CreateMedicalVocabularyInput, opts ...request.Option) (*CreateMedicalVocabularyOutput, error) {
	req, out := c.CreateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabulary = "CreateVocabulary"

// CreateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabulary for more information on using the CreateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVocabularyRequest method.
//	req, resp := client.CreateVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabularyRequest(input *CreateVocabularyInput) (req *request.Request, output *CreateVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyInput{}
	}

	output = &CreateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabulary API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary.
//
// When creating a new custom vocabulary, you can either upload a text file
// that contains your new entries, phrases, and terms into an Amazon S3 bucket
// and include the URI in your request. Or you can include a list of terms directly
// in your request using the Phrases flag.
//
// Each language has a character set that contains all allowed characters for
// that specific language. If you use unsupported characters, your custom vocabulary
// request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
// to get the character set for your language.
//
// For more information, see Custom vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabulary
func (c *TranscribeService) CreateVocabulary(input *CreateVocabularyInput) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	return out, req.Send()
}

// CreateVocabularyWithContext is the same as CreateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyWithContext(ctx aws.Context, input *CreateVocabularyInput, opts ...request.Option) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabularyFilter = "CreateVocabularyFilter"

// CreateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabularyFilter for more information on using the CreateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVocabularyFilterRequest method.
//	req, resp := client.CreateVocabularyFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilterRequest(input *CreateVocabularyFilterInput) (req *request.Request, output *CreateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opCreateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateVocabularyFilterInput{}
	}

	output = &CreateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Creates a new custom vocabulary filter.
//
// You can use custom vocabulary filters to mask, delete, or flag specific words
// from your transcript. Custom vocabulary filters are commonly used to mask
// profanity in transcripts.
//
// Each language has a character set that contains all allowed characters for
// that specific language. If you use unsupported characters, your custom vocabulary
// filter request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
// to get the character set for your language.
//
// For more information, see Vocabulary filtering (https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation CreateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/CreateVocabularyFilter
func (c *TranscribeService) CreateVocabularyFilter(input *CreateVocabularyFilterInput) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	return out, req.Send()
}

// CreateVocabularyFilterWithContext is the same as CreateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) CreateVocabularyFilterWithContext(ctx aws.Context, input *CreateVocabularyFilterInput, opts ...request.Option) (*CreateVocabularyFilterOutput, error) {
	req, out := c.CreateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCallAnalyticsCategory = "DeleteCallAnalyticsCategory"

// DeleteCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCallAnalyticsCategory for more information on using the DeleteCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCallAnalyticsCategoryRequest method.
//	req, resp := client.DeleteCallAnalyticsCategoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory
func (c *TranscribeService) DeleteCallAnalyticsCategoryRequest(input *DeleteCallAnalyticsCategoryInput) (req *request.Request, output *DeleteCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opDeleteCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCallAnalyticsCategoryInput{}
	}

	output = &DeleteCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Deletes a Call Analytics category. To use this operation, specify the name
// of the category you want to delete using CategoryName. Category names are
// case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsCategory
func (c *TranscribeService) DeleteCallAnalyticsCategory(input *DeleteCallAnalyticsCategoryInput) (*DeleteCallAnalyticsCategoryOutput, error) {
	req, out := c.DeleteCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// DeleteCallAnalyticsCategoryWithContext is the same as DeleteCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteCallAnalyticsCategoryWithContext(ctx aws.Context, input *DeleteCallAnalyticsCategoryInput, opts ...request.Option) (*DeleteCallAnalyticsCategoryOutput, error) {
	req, out := c.DeleteCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCallAnalyticsJob = "DeleteCallAnalyticsJob"

// DeleteCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCallAnalyticsJob for more information on using the DeleteCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCallAnalyticsJobRequest method.
//	req, resp := client.DeleteCallAnalyticsJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob
func (c *TranscribeService) DeleteCallAnalyticsJobRequest(input *DeleteCallAnalyticsJobInput) (req *request.Request, output *DeleteCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opDeleteCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCallAnalyticsJobInput{}
	}

	output = &DeleteCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Deletes a Call Analytics job. To use this operation, specify the name of
// the job you want to delete using CallAnalyticsJobName. Job names are case
// sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteCallAnalyticsJob
func (c *TranscribeService) DeleteCallAnalyticsJob(input *DeleteCallAnalyticsJobInput) (*DeleteCallAnalyticsJobOutput, error) {
	req, out := c.DeleteCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// DeleteCallAnalyticsJobWithContext is the same as DeleteCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteCallAnalyticsJobWithContext(ctx aws.Context, input *DeleteCallAnalyticsJobInput, opts ...request.Option) (*DeleteCallAnalyticsJobOutput, error) {
	req, out := c.DeleteCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLanguageModel = "DeleteLanguageModel"

// DeleteLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLanguageModel for more information on using the DeleteLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLanguageModelRequest method.
//	req, resp := client.DeleteLanguageModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModelRequest(input *DeleteLanguageModelInput) (req *request.Request, output *DeleteLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDeleteLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLanguageModelInput{}
	}

	output = &DeleteLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLanguageModel API operation for Amazon Transcribe Service.
//
// Deletes a custom language model. To use this operation, specify the name
// of the language model you want to delete using ModelName. custom language
// model names are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteLanguageModel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteLanguageModel
func (c *TranscribeService) DeleteLanguageModel(input *DeleteLanguageModelInput) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	return out, req.Send()
}

// DeleteLanguageModelWithContext is the same as DeleteLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteLanguageModelWithContext(ctx aws.Context, input *DeleteLanguageModelInput, opts ...request.Option) (*DeleteLanguageModelOutput, error) {
	req, out := c.DeleteLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalTranscriptionJob = "DeleteMedicalTranscriptionJob"

// DeleteMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalTranscriptionJob for more information on using the DeleteMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMedicalTranscriptionJobRequest method.
//	req, resp := client.DeleteMedicalTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJobRequest(input *DeleteMedicalTranscriptionJobInput) (req *request.Request, output *DeleteMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalTranscriptionJobInput{}
	}

	output = &DeleteMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a medical transcription job. To use this operation, specify the name
// of the job you want to delete using MedicalTranscriptionJobName. Job names
// are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalTranscriptionJob
func (c *TranscribeService) DeleteMedicalTranscriptionJob(input *DeleteMedicalTranscriptionJobInput) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteMedicalTranscriptionJobWithContext is the same as DeleteMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalTranscriptionJobWithContext(ctx aws.Context, input *DeleteMedicalTranscriptionJobInput, opts ...request.Option) (*DeleteMedicalTranscriptionJobOutput, error) {
	req, out := c.DeleteMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMedicalVocabulary = "DeleteMedicalVocabulary"

// DeleteMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMedicalVocabulary for more information on using the DeleteMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMedicalVocabularyRequest method.
//	req, resp := client.DeleteMedicalVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabularyRequest(input *DeleteMedicalVocabularyInput) (req *request.Request, output *DeleteMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMedicalVocabularyInput{}
	}

	output = &DeleteMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a custom medical vocabulary. To use this operation, specify the name
// of the custom vocabulary you want to delete using VocabularyName. Custom
// vocabulary names are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteMedicalVocabulary
func (c *TranscribeService) DeleteMedicalVocabulary(input *DeleteMedicalVocabularyInput) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	return out, req.Send()
}

// DeleteMedicalVocabularyWithContext is the same as DeleteMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteMedicalVocabularyWithContext(ctx aws.Context, input *DeleteMedicalVocabularyInput, opts ...request.Option) (*DeleteMedicalVocabularyOutput, error) {
	req, out := c.DeleteMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTranscriptionJob = "DeleteTranscriptionJob"

// DeleteTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTranscriptionJob for more information on using the DeleteTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTranscriptionJobRequest method.
//	req, resp := client.DeleteTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJobRequest(input *DeleteTranscriptionJobInput) (req *request.Request, output *DeleteTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opDeleteTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTranscriptionJobInput{}
	}

	output = &DeleteTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTranscriptionJob API operation for Amazon Transcribe Service.
//
// Deletes a transcription job. To use this operation, specify the name of the
// job you want to delete using TranscriptionJobName. Job names are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteTranscriptionJob
func (c *TranscribeService) DeleteTranscriptionJob(input *DeleteTranscriptionJobInput) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	return out, req.Send()
}

// DeleteTranscriptionJobWithContext is the same as DeleteTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteTranscriptionJobWithContext(ctx aws.Context, input *DeleteTranscriptionJobInput, opts ...request.Option) (*DeleteTranscriptionJobOutput, error) {
	req, out := c.DeleteTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabulary for more information on using the DeleteVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVocabularyRequest method.
//	req, resp := client.DeleteVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabularyRequest(input *DeleteVocabularyInput) (req *request.Request, output *DeleteVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	output = &DeleteVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabulary API operation for Amazon Transcribe Service.
//
// Deletes a custom vocabulary. To use this operation, specify the name of the
// custom vocabulary you want to delete using VocabularyName. Custom vocabulary
// names are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabulary
func (c *TranscribeService) DeleteVocabulary(input *DeleteVocabularyInput) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	return out, req.Send()
}

// DeleteVocabularyWithContext is the same as DeleteVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyWithContext(ctx aws.Context, input *DeleteVocabularyInput, opts ...request.Option) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabularyFilter = "DeleteVocabularyFilter"

// DeleteVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabularyFilter for more information on using the DeleteVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVocabularyFilterRequest method.
//	req, resp := client.DeleteVocabularyFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilterRequest(input *DeleteVocabularyFilterInput) (req *request.Request, output *DeleteVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVocabularyFilterInput{}
	}

	output = &DeleteVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVocabularyFilter API operation for Amazon Transcribe Service.
//
// Deletes a custom vocabulary filter. To use this operation, specify the name
// of the custom vocabulary filter you want to delete using VocabularyFilterName.
// Custom vocabulary filter names are case sensitive.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DeleteVocabularyFilter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DeleteVocabularyFilter
func (c *TranscribeService) DeleteVocabularyFilter(input *DeleteVocabularyFilterInput) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	return out, req.Send()
}

// DeleteVocabularyFilterWithContext is the same as DeleteVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DeleteVocabularyFilterWithContext(ctx aws.Context, input *DeleteVocabularyFilterInput, opts ...request.Option) (*DeleteVocabularyFilterOutput, error) {
	req, out := c.DeleteVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLanguageModel = "DescribeLanguageModel"

// DescribeLanguageModelRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLanguageModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLanguageModel for more information on using the DescribeLanguageModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeLanguageModelRequest method.
//	req, resp := client.DescribeLanguageModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModelRequest(input *DescribeLanguageModelInput) (req *request.Request, output *DescribeLanguageModelOutput) {
	op := &request.Operation{
		Name:       opDescribeLanguageModel,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLanguageModelInput{}
	}

	output = &DescribeLanguageModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLanguageModel API operation for Amazon Transcribe Service.
//
// Provides information about the specified custom language model.
//
// This operation also shows if the base language model that you used to create
// your custom language model has been updated. If Amazon Transcribe has updated
// the base model, you can create a new custom language model using the updated
// base model.
//
// If you tried to create a new custom language model and the request wasn't
// successful, you can use DescribeLanguageModel to help identify the reason
// for this failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation DescribeLanguageModel for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/DescribeLanguageModel
func (c *TranscribeService) DescribeLanguageModel(input *DescribeLanguageModelInput) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	return out, req.Send()
}

// DescribeLanguageModelWithContext is the same as DescribeLanguageModel with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLanguageModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) DescribeLanguageModelWithContext(ctx aws.Context, input *DescribeLanguageModelInput, opts ...request.Option) (*DescribeLanguageModelOutput, error) {
	req, out := c.DescribeLanguageModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCallAnalyticsCategory = "GetCallAnalyticsCategory"

// GetCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the GetCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCallAnalyticsCategory for more information on using the GetCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCallAnalyticsCategoryRequest method.
//	req, resp := client.GetCallAnalyticsCategoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory
func (c *TranscribeService) GetCallAnalyticsCategoryRequest(input *GetCallAnalyticsCategoryInput) (req *request.Request, output *GetCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opGetCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCallAnalyticsCategoryInput{}
	}

	output = &GetCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Provides information about the specified Call Analytics category.
//
// To get a list of your Call Analytics categories, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsCategory
func (c *TranscribeService) GetCallAnalyticsCategory(input *GetCallAnalyticsCategoryInput) (*GetCallAnalyticsCategoryOutput, error) {
	req, out := c.GetCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// GetCallAnalyticsCategoryWithContext is the same as GetCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See GetCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetCallAnalyticsCategoryWithContext(ctx aws.Context, input *GetCallAnalyticsCategoryInput, opts ...request.Option) (*GetCallAnalyticsCategoryOutput, error) {
	req, out := c.GetCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCallAnalyticsJob = "GetCallAnalyticsJob"

// GetCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the GetCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCallAnalyticsJob for more information on using the GetCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCallAnalyticsJobRequest method.
//	req, resp := client.GetCallAnalyticsJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob
func (c *TranscribeService) GetCallAnalyticsJobRequest(input *GetCallAnalyticsJobInput) (req *request.Request, output *GetCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opGetCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCallAnalyticsJobInput{}
	}

	output = &GetCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Provides information about the specified Call Analytics job.
//
// To view the job's status, refer to CallAnalyticsJobStatus. If the status
// is COMPLETED, the job is finished. You can find your completed transcript
// at the URI specified in TranscriptFileUri. If the status is FAILED, FailureReason
// provides details on why your transcription job failed.
//
// If you enabled personally identifiable information (PII) redaction, the redacted
// transcript appears at the location specified in RedactedTranscriptFileUri.
//
// If you chose to redact the audio in your media file, you can find your redacted
// media file at the location specified in RedactedMediaFileUri.
//
// To get a list of your Call Analytics jobs, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetCallAnalyticsJob
func (c *TranscribeService) GetCallAnalyticsJob(input *GetCallAnalyticsJobInput) (*GetCallAnalyticsJobOutput, error) {
	req, out := c.GetCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// GetCallAnalyticsJobWithContext is the same as GetCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetCallAnalyticsJobWithContext(ctx aws.Context, input *GetCallAnalyticsJobInput, opts ...request.Option) (*GetCallAnalyticsJobOutput, error) {
	req, out := c.GetCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalTranscriptionJob = "GetMedicalTranscriptionJob"

// GetMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalTranscriptionJob for more information on using the GetMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMedicalTranscriptionJobRequest method.
//	req, resp := client.GetMedicalTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJobRequest(input *GetMedicalTranscriptionJobInput) (req *request.Request, output *GetMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalTranscriptionJobInput{}
	}

	output = &GetMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Provides information about the specified medical transcription job.
//
// To view the status of the specified medical transcription job, check the
// TranscriptionJobStatus field. If the status is COMPLETED, the job is finished.
// You can find the results at the location specified in TranscriptFileUri.
// If the status is FAILED, FailureReason provides details on why your transcription
// job failed.
//
// To get a list of your medical transcription jobs, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalTranscriptionJob
func (c *TranscribeService) GetMedicalTranscriptionJob(input *GetMedicalTranscriptionJobInput) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetMedicalTranscriptionJobWithContext is the same as GetMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalTranscriptionJobWithContext(ctx aws.Context, input *GetMedicalTranscriptionJobInput, opts ...request.Option) (*GetMedicalTranscriptionJobOutput, error) {
	req, out := c.GetMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMedicalVocabulary = "GetMedicalVocabulary"

// GetMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMedicalVocabulary for more information on using the GetMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMedicalVocabularyRequest method.
//	req, resp := client.GetMedicalVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabularyRequest(input *GetMedicalVocabularyInput) (req *request.Request, output *GetMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetMedicalVocabularyInput{}
	}

	output = &GetMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Provides information about the specified custom medical vocabulary.
//
// To view the status of the specified custom medical vocabulary, check the
// VocabularyState field. If the status is READY, your custom vocabulary is
// available to use. If the status is FAILED, FailureReason provides details
// on why your vocabulary failed.
//
// To get a list of your custom medical vocabularies, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetMedicalVocabulary
func (c *TranscribeService) GetMedicalVocabulary(input *GetMedicalVocabularyInput) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	return out, req.Send()
}

// GetMedicalVocabularyWithContext is the same as GetMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetMedicalVocabularyWithContext(ctx aws.Context, input *GetMedicalVocabularyInput, opts ...request.Option) (*GetMedicalVocabularyOutput, error) {
	req, out := c.GetMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTranscriptionJob = "GetTranscriptionJob"

// GetTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the GetTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTranscriptionJob for more information on using the GetTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTranscriptionJobRequest method.
//	req, resp := client.GetTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJobRequest(input *GetTranscriptionJobInput) (req *request.Request, output *GetTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opGetTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTranscriptionJobInput{}
	}

	output = &GetTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTranscriptionJob API operation for Amazon Transcribe Service.
//
// Provides information about the specified transcription job.
//
// To view the status of the specified transcription job, check the TranscriptionJobStatus
// field. If the status is COMPLETED, the job is finished. You can find the
// results at the location specified in TranscriptFileUri. If the status is
// FAILED, FailureReason provides details on why your transcription job failed.
//
// If you enabled content redaction, the redacted transcript can be found at
// the location specified in RedactedTranscriptFileUri.
//
// To get a list of your transcription jobs, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetTranscriptionJob
func (c *TranscribeService) GetTranscriptionJob(input *GetTranscriptionJobInput) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	return out, req.Send()
}

// GetTranscriptionJobWithContext is the same as GetTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetTranscriptionJobWithContext(ctx aws.Context, input *GetTranscriptionJobInput, opts ...request.Option) (*GetTranscriptionJobOutput, error) {
	req, out := c.GetTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabulary = "GetVocabulary"

// GetVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabulary for more information on using the GetVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVocabularyRequest method.
//	req, resp := client.GetVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabularyRequest(input *GetVocabularyInput) (req *request.Request, output *GetVocabularyOutput) {
	op := &request.Operation{
		Name:       opGetVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyInput{}
	}

	output = &GetVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabulary API operation for Amazon Transcribe Service.
//
// Provides information about the specified custom vocabulary.
//
// To view the status of the specified custom vocabulary, check the VocabularyState
// field. If the status is READY, your custom vocabulary is available to use.
// If the status is FAILED, FailureReason provides details on why your custom
// vocabulary failed.
//
// To get a list of your custom vocabularies, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabulary
func (c *TranscribeService) GetVocabulary(input *GetVocabularyInput) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	return out, req.Send()
}

// GetVocabularyWithContext is the same as GetVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyWithContext(ctx aws.Context, input *GetVocabularyInput, opts ...request.Option) (*GetVocabularyOutput, error) {
	req, out := c.GetVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVocabularyFilter = "GetVocabularyFilter"

// GetVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the GetVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVocabularyFilter for more information on using the GetVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetVocabularyFilterRequest method.
//	req, resp := client.GetVocabularyFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilterRequest(input *GetVocabularyFilterInput) (req *request.Request, output *GetVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opGetVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetVocabularyFilterInput{}
	}

	output = &GetVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVocabularyFilter API operation for Amazon Transcribe Service.
//
// Provides information about the specified custom vocabulary filter.
//
// To get a list of your custom vocabulary filters, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation GetVocabularyFilter for usage and error information.
//
// Returned Error Types:
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/GetVocabularyFilter
func (c *TranscribeService) GetVocabularyFilter(input *GetVocabularyFilterInput) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	return out, req.Send()
}

// GetVocabularyFilterWithContext is the same as GetVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See GetVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) GetVocabularyFilterWithContext(ctx aws.Context, input *GetVocabularyFilterInput, opts ...request.Option) (*GetVocabularyFilterOutput, error) {
	req, out := c.GetVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCallAnalyticsCategories = "ListCallAnalyticsCategories"

// ListCallAnalyticsCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListCallAnalyticsCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCallAnalyticsCategories for more information on using the ListCallAnalyticsCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCallAnalyticsCategoriesRequest method.
//	req, resp := client.ListCallAnalyticsCategoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories
func (c *TranscribeService) ListCallAnalyticsCategoriesRequest(input *ListCallAnalyticsCategoriesInput) (req *request.Request, output *ListCallAnalyticsCategoriesOutput) {
	op := &request.Operation{
		Name:       opListCallAnalyticsCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCallAnalyticsCategoriesInput{}
	}

	output = &ListCallAnalyticsCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCallAnalyticsCategories API operation for Amazon Transcribe Service.
//
// Provides a list of Call Analytics categories, including all rules that make
// up each category.
//
// To get detailed information about a specific Call Analytics category, use
// the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListCallAnalyticsCategories for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsCategories
func (c *TranscribeService) ListCallAnalyticsCategories(input *ListCallAnalyticsCategoriesInput) (*ListCallAnalyticsCategoriesOutput, error) {
	req, out := c.ListCallAnalyticsCategoriesRequest(input)
	return out, req.Send()
}

// ListCallAnalyticsCategoriesWithContext is the same as ListCallAnalyticsCategories with the addition of
// the ability to pass a context and additional request options.
//
// See ListCallAnalyticsCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsCategoriesWithContext(ctx aws.Context, input *ListCallAnalyticsCategoriesInput, opts ...request.Option) (*ListCallAnalyticsCategoriesOutput, error) {
	req, out := c.ListCallAnalyticsCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCallAnalyticsCategoriesPages iterates over the pages of a ListCallAnalyticsCategories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCallAnalyticsCategories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCallAnalyticsCategories operation.
//	pageNum := 0
//	err := client.ListCallAnalyticsCategoriesPages(params,
//	    func(page *transcribeservice.ListCallAnalyticsCategoriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListCallAnalyticsCategoriesPages(input *ListCallAnalyticsCategoriesInput, fn func(*ListCallAnalyticsCategoriesOutput, bool) bool) error {
	return c.ListCallAnalyticsCategoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCallAnalyticsCategoriesPagesWithContext same as ListCallAnalyticsCategoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsCategoriesPagesWithContext(ctx aws.Context, input *ListCallAnalyticsCategoriesInput, fn func(*ListCallAnalyticsCategoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCallAnalyticsCategoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCallAnalyticsCategoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCallAnalyticsCategoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCallAnalyticsJobs = "ListCallAnalyticsJobs"

// ListCallAnalyticsJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListCallAnalyticsJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCallAnalyticsJobs for more information on using the ListCallAnalyticsJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCallAnalyticsJobsRequest method.
//	req, resp := client.ListCallAnalyticsJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs
func (c *TranscribeService) ListCallAnalyticsJobsRequest(input *ListCallAnalyticsJobsInput) (req *request.Request, output *ListCallAnalyticsJobsOutput) {
	op := &request.Operation{
		Name:       opListCallAnalyticsJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCallAnalyticsJobsInput{}
	}

	output = &ListCallAnalyticsJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCallAnalyticsJobs API operation for Amazon Transcribe Service.
//
// Provides a list of Call Analytics jobs that match the specified criteria.
// If no criteria are specified, all Call Analytics jobs are returned.
//
// To get detailed information about a specific Call Analytics job, use the
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListCallAnalyticsJobs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListCallAnalyticsJobs
func (c *TranscribeService) ListCallAnalyticsJobs(input *ListCallAnalyticsJobsInput) (*ListCallAnalyticsJobsOutput, error) {
	req, out := c.ListCallAnalyticsJobsRequest(input)
	return out, req.Send()
}

// ListCallAnalyticsJobsWithContext is the same as ListCallAnalyticsJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListCallAnalyticsJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsJobsWithContext(ctx aws.Context, input *ListCallAnalyticsJobsInput, opts ...request.Option) (*ListCallAnalyticsJobsOutput, error) {
	req, out := c.ListCallAnalyticsJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCallAnalyticsJobsPages iterates over the pages of a ListCallAnalyticsJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCallAnalyticsJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCallAnalyticsJobs operation.
//	pageNum := 0
//	err := client.ListCallAnalyticsJobsPages(params,
//	    func(page *transcribeservice.ListCallAnalyticsJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListCallAnalyticsJobsPages(input *ListCallAnalyticsJobsInput, fn func(*ListCallAnalyticsJobsOutput, bool) bool) error {
	return c.ListCallAnalyticsJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCallAnalyticsJobsPagesWithContext same as ListCallAnalyticsJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListCallAnalyticsJobsPagesWithContext(ctx aws.Context, input *ListCallAnalyticsJobsInput, fn func(*ListCallAnalyticsJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCallAnalyticsJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCallAnalyticsJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCallAnalyticsJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLanguageModels = "ListLanguageModels"

// ListLanguageModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListLanguageModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLanguageModels for more information on using the ListLanguageModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLanguageModelsRequest method.
//	req, resp := client.ListLanguageModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModelsRequest(input *ListLanguageModelsInput) (req *request.Request, output *ListLanguageModelsOutput) {
	op := &request.Operation{
		Name:       opListLanguageModels,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLanguageModelsInput{}
	}

	output = &ListLanguageModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLanguageModels API operation for Amazon Transcribe Service.
//
// Provides a list of custom language models that match the specified criteria.
// If no criteria are specified, all custom language models are returned.
//
// To get detailed information about a specific custom language model, use the
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListLanguageModels for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListLanguageModels
func (c *TranscribeService) ListLanguageModels(input *ListLanguageModelsInput) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	return out, req.Send()
}

// ListLanguageModelsWithContext is the same as ListLanguageModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListLanguageModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsWithContext(ctx aws.Context, input *ListLanguageModelsInput, opts ...request.Option) (*ListLanguageModelsOutput, error) {
	req, out := c.ListLanguageModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLanguageModelsPages iterates over the pages of a ListLanguageModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLanguageModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLanguageModels operation.
//	pageNum := 0
//	err := client.ListLanguageModelsPages(params,
//	    func(page *transcribeservice.ListLanguageModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListLanguageModelsPages(input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool) error {
	return c.ListLanguageModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLanguageModelsPagesWithContext same as ListLanguageModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListLanguageModelsPagesWithContext(ctx aws.Context, input *ListLanguageModelsInput, fn func(*ListLanguageModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLanguageModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLanguageModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLanguageModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalTranscriptionJobs = "ListMedicalTranscriptionJobs"

// ListMedicalTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalTranscriptionJobs for more information on using the ListMedicalTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMedicalTranscriptionJobsRequest method.
//	req, resp := client.ListMedicalTranscriptionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobsRequest(input *ListMedicalTranscriptionJobsInput) (req *request.Request, output *ListMedicalTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListMedicalTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalTranscriptionJobsInput{}
	}

	output = &ListMedicalTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Provides a list of medical transcription jobs that match the specified criteria.
// If no criteria are specified, all medical transcription jobs are returned.
//
// To get detailed information about a specific medical transcription job, use
// the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *TranscribeService) ListMedicalTranscriptionJobs(input *ListMedicalTranscriptionJobsInput) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsWithContext is the same as ListMedicalTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, opts ...request.Option) (*ListMedicalTranscriptionJobsOutput, error) {
	req, out := c.ListMedicalTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalTranscriptionJobsPages iterates over the pages of a ListMedicalTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMedicalTranscriptionJobs operation.
//	pageNum := 0
//	err := client.ListMedicalTranscriptionJobsPages(params,
//	    func(page *transcribeservice.ListMedicalTranscriptionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListMedicalTranscriptionJobsPages(input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool) error {
	return c.ListMedicalTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalTranscriptionJobsPagesWithContext same as ListMedicalTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListMedicalTranscriptionJobsInput, fn func(*ListMedicalTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMedicalVocabularies = "ListMedicalVocabularies"

// ListMedicalVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListMedicalVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMedicalVocabularies for more information on using the ListMedicalVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMedicalVocabulariesRequest method.
//	req, resp := client.ListMedicalVocabulariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabulariesRequest(input *ListMedicalVocabulariesInput) (req *request.Request, output *ListMedicalVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListMedicalVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalVocabulariesInput{}
	}

	output = &ListMedicalVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListMedicalVocabularies API operation for Amazon Transcribe Service.
//
// Provides a list of custom medical vocabularies that match the specified criteria.
// If no criteria are specified, all custom medical vocabularies are returned.
//
// To get detailed information about a specific custom medical vocabulary, use
// the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListMedicalVocabularies for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalVocabularies
func (c *TranscribeService) ListMedicalVocabularies(input *ListMedicalVocabulariesInput) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	return out, req.Send()
}

// ListMedicalVocabulariesWithContext is the same as ListMedicalVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListMedicalVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, opts ...request.Option) (*ListMedicalVocabulariesOutput, error) {
	req, out := c.ListMedicalVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMedicalVocabulariesPages iterates over the pages of a ListMedicalVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMedicalVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMedicalVocabularies operation.
//	pageNum := 0
//	err := client.ListMedicalVocabulariesPages(params,
//	    func(page *transcribeservice.ListMedicalVocabulariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListMedicalVocabulariesPages(input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool) error {
	return c.ListMedicalVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMedicalVocabulariesPagesWithContext same as ListMedicalVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListMedicalVocabulariesPagesWithContext(ctx aws.Context, input *ListMedicalVocabulariesInput, fn func(*ListMedicalVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMedicalVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMedicalVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMedicalVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource
func (c *TranscribeService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Transcribe Service.
//
// Lists all tags associated with the specified transcription job, vocabulary,
// model, or resource.
//
// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTagsForResource
func (c *TranscribeService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTranscriptionJobs = "ListTranscriptionJobs"

// ListTranscriptionJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListTranscriptionJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTranscriptionJobs for more information on using the ListTranscriptionJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTranscriptionJobsRequest method.
//	req, resp := client.ListTranscriptionJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobsRequest(input *ListTranscriptionJobsInput) (req *request.Request, output *ListTranscriptionJobsOutput) {
	op := &request.Operation{
		Name:       opListTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTranscriptionJobsInput{}
	}

	output = &ListTranscriptionJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTranscriptionJobs API operation for Amazon Transcribe Service.
//
// Provides a list of transcription jobs that match the specified criteria.
// If no criteria are specified, all transcription jobs are returned.
//
// To get detailed information about a specific transcription job, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListTranscriptionJobs for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListTranscriptionJobs
func (c *TranscribeService) ListTranscriptionJobs(input *ListTranscriptionJobsInput) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	return out, req.Send()
}

// ListTranscriptionJobsWithContext is the same as ListTranscriptionJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListTranscriptionJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, opts ...request.Option) (*ListTranscriptionJobsOutput, error) {
	req, out := c.ListTranscriptionJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTranscriptionJobsPages iterates over the pages of a ListTranscriptionJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTranscriptionJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTranscriptionJobs operation.
//	pageNum := 0
//	err := client.ListTranscriptionJobsPages(params,
//	    func(page *transcribeservice.ListTranscriptionJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListTranscriptionJobsPages(input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool) error {
	return c.ListTranscriptionJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTranscriptionJobsPagesWithContext same as ListTranscriptionJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListTranscriptionJobsPagesWithContext(ctx aws.Context, input *ListTranscriptionJobsInput, fn func(*ListTranscriptionJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTranscriptionJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTranscriptionJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTranscriptionJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularies = "ListVocabularies"

// ListVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularies for more information on using the ListVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVocabulariesRequest method.
//	req, resp := client.ListVocabulariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabulariesRequest(input *ListVocabulariesInput) (req *request.Request, output *ListVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabulariesInput{}
	}

	output = &ListVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularies API operation for Amazon Transcribe Service.
//
// Provides a list of custom vocabularies that match the specified criteria.
// If no criteria are specified, all custom vocabularies are returned.
//
// To get detailed information about a specific custom vocabulary, use the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularies for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularies
func (c *TranscribeService) ListVocabularies(input *ListVocabulariesInput) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	return out, req.Send()
}

// ListVocabulariesWithContext is the same as ListVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesWithContext(ctx aws.Context, input *ListVocabulariesInput, opts ...request.Option) (*ListVocabulariesOutput, error) {
	req, out := c.ListVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabulariesPages iterates over the pages of a ListVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVocabularies operation.
//	pageNum := 0
//	err := client.ListVocabulariesPages(params,
//	    func(page *transcribeservice.ListVocabulariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListVocabulariesPages(input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool) error {
	return c.ListVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabulariesPagesWithContext same as ListVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabulariesPagesWithContext(ctx aws.Context, input *ListVocabulariesInput, fn func(*ListVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListVocabularyFilters = "ListVocabularyFilters"

// ListVocabularyFiltersRequest generates a "aws/request.Request" representing the
// client's request for the ListVocabularyFilters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListVocabularyFilters for more information on using the ListVocabularyFilters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListVocabularyFiltersRequest method.
//	req, resp := client.ListVocabularyFiltersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFiltersRequest(input *ListVocabularyFiltersInput) (req *request.Request, output *ListVocabularyFiltersOutput) {
	op := &request.Operation{
		Name:       opListVocabularyFilters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVocabularyFiltersInput{}
	}

	output = &ListVocabularyFiltersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListVocabularyFilters API operation for Amazon Transcribe Service.
//
// Provides a list of custom vocabulary filters that match the specified criteria.
// If no criteria are specified, all custom vocabularies are returned.
//
// To get detailed information about a specific custom vocabulary filter, use
// the operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation ListVocabularyFilters for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListVocabularyFilters
func (c *TranscribeService) ListVocabularyFilters(input *ListVocabularyFiltersInput) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	return out, req.Send()
}

// ListVocabularyFiltersWithContext is the same as ListVocabularyFilters with the addition of
// the ability to pass a context and additional request options.
//
// See ListVocabularyFilters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, opts ...request.Option) (*ListVocabularyFiltersOutput, error) {
	req, out := c.ListVocabularyFiltersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListVocabularyFiltersPages iterates over the pages of a ListVocabularyFilters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListVocabularyFilters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListVocabularyFilters operation.
//	pageNum := 0
//	err := client.ListVocabularyFiltersPages(params,
//	    func(page *transcribeservice.ListVocabularyFiltersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *TranscribeService) ListVocabularyFiltersPages(input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool) error {
	return c.ListVocabularyFiltersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListVocabularyFiltersPagesWithContext same as ListVocabularyFiltersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) ListVocabularyFiltersPagesWithContext(ctx aws.Context, input *ListVocabularyFiltersInput, fn func(*ListVocabularyFiltersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListVocabularyFiltersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListVocabularyFiltersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListVocabularyFiltersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartCallAnalyticsJob = "StartCallAnalyticsJob"

// StartCallAnalyticsJobRequest generates a "aws/request.Request" representing the
// client's request for the StartCallAnalyticsJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCallAnalyticsJob for more information on using the StartCallAnalyticsJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCallAnalyticsJobRequest method.
//	req, resp := client.StartCallAnalyticsJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob
func (c *TranscribeService) StartCallAnalyticsJobRequest(input *StartCallAnalyticsJobInput) (req *request.Request, output *StartCallAnalyticsJobOutput) {
	op := &request.Operation{
		Name:       opStartCallAnalyticsJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartCallAnalyticsJobInput{}
	}

	output = &StartCallAnalyticsJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCallAnalyticsJob API operation for Amazon Transcribe Service.
//
// Transcribes the audio from a customer service call and applies any additional
// Request Parameters you choose to include in your request.
//
// In addition to many standard transcription features, Call Analytics provides
// you with call characteristics, call summarization, speaker sentiment, and
// optional redaction of your text transcript and your audio file. You can also
// apply custom categories to flag specified conditions. To learn more about
// these features and insights, refer to Analyzing call center audio with Call
// Analytics (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
//
// If you want to apply categories to your Call Analytics job, you must create
// them before submitting your job request. Categories cannot be retroactively
// applied to a job. To create a new category, use the operation. To learn more
// about Call Analytics categories, see Creating categories for post-call transcriptions
// (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html)
// and Creating categories for real-time transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
//
// To make a StartCallAnalyticsJob request, you must first upload your media
// file into an Amazon S3 bucket; you can then specify the Amazon S3 location
// of the file using the Media parameter.
//
// Note that job queuing is enabled by default for Call Analytics jobs.
//
// You must include the following parameters in your StartCallAnalyticsJob request:
//
//   - region: The Amazon Web Services Region where you are making your request.
//     For a list of Amazon Web Services Regions supported with Amazon Transcribe,
//     refer to Amazon Transcribe endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
//
//   - CallAnalyticsJobName: A custom name that you create for your transcription
//     job that's unique within your Amazon Web Services account.
//
//   - DataAccessRoleArn: The Amazon Resource Name (ARN) of an IAM role that
//     has permissions to access the Amazon S3 bucket that contains your input
//     files.
//
//   - Media (MediaFileUri or RedactedMediaFileUri): The Amazon S3 location
//     of your media file.
//
// With Call Analytics, you can redact the audio contained in your media file
// by including RedactedMediaFileUri, instead of MediaFileUri, to specify the
// location of your input audio. If you choose to redact your audio, you can
// find your redacted media at the location specified in the RedactedMediaFileUri
// field of your response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartCallAnalyticsJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartCallAnalyticsJob
func (c *TranscribeService) StartCallAnalyticsJob(input *StartCallAnalyticsJobInput) (*StartCallAnalyticsJobOutput, error) {
	req, out := c.StartCallAnalyticsJobRequest(input)
	return out, req.Send()
}

// StartCallAnalyticsJobWithContext is the same as StartCallAnalyticsJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartCallAnalyticsJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartCallAnalyticsJobWithContext(ctx aws.Context, input *StartCallAnalyticsJobInput, opts ...request.Option) (*StartCallAnalyticsJobOutput, error) {
	req, out := c.StartCallAnalyticsJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMedicalTranscriptionJob = "StartMedicalTranscriptionJob"

// StartMedicalTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartMedicalTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMedicalTranscriptionJob for more information on using the StartMedicalTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartMedicalTranscriptionJobRequest method.
//	req, resp := client.StartMedicalTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJobRequest(input *StartMedicalTranscriptionJobInput) (req *request.Request, output *StartMedicalTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartMedicalTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMedicalTranscriptionJobInput{}
	}

	output = &StartMedicalTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMedicalTranscriptionJob API operation for Amazon Transcribe Service.
//
// Transcribes the audio from a medical dictation or conversation and applies
// any additional Request Parameters you choose to include in your request.
//
// In addition to many standard transcription features, Amazon Transcribe Medical
// provides you with a robust medical vocabulary and, optionally, content identification,
// which adds flags to personal health information (PHI). To learn more about
// these features, refer to How Amazon Transcribe Medical works (https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html).
//
// To make a StartMedicalTranscriptionJob request, you must first upload your
// media file into an Amazon S3 bucket; you can then specify the S3 location
// of the file using the Media parameter.
//
// You must include the following parameters in your StartMedicalTranscriptionJob
// request:
//
//   - region: The Amazon Web Services Region where you are making your request.
//     For a list of Amazon Web Services Regions supported with Amazon Transcribe,
//     refer to Amazon Transcribe endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
//
//   - MedicalTranscriptionJobName: A custom name you create for your transcription
//     job that is unique within your Amazon Web Services account.
//
//   - Media (MediaFileUri): The Amazon S3 location of your media file.
//
//   - LanguageCode: This must be en-US.
//
//   - OutputBucketName: The Amazon S3 bucket where you want your transcript
//     stored. If you want your output stored in a sub-folder of this bucket,
//     you must also include OutputKey.
//
//   - Specialty: This must be PRIMARYCARE.
//
//   - Type: Choose whether your audio is a conversation or a dictation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartMedicalTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartMedicalTranscriptionJob
func (c *TranscribeService) StartMedicalTranscriptionJob(input *StartMedicalTranscriptionJobInput) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartMedicalTranscriptionJobWithContext is the same as StartMedicalTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartMedicalTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartMedicalTranscriptionJobWithContext(ctx aws.Context, input *StartMedicalTranscriptionJobInput, opts ...request.Option) (*StartMedicalTranscriptionJobOutput, error) {
	req, out := c.StartMedicalTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTranscriptionJob = "StartTranscriptionJob"

// StartTranscriptionJobRequest generates a "aws/request.Request" representing the
// client's request for the StartTranscriptionJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTranscriptionJob for more information on using the StartTranscriptionJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTranscriptionJobRequest method.
//	req, resp := client.StartTranscriptionJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJobRequest(input *StartTranscriptionJobInput) (req *request.Request, output *StartTranscriptionJobOutput) {
	op := &request.Operation{
		Name:       opStartTranscriptionJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartTranscriptionJobInput{}
	}

	output = &StartTranscriptionJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTranscriptionJob API operation for Amazon Transcribe Service.
//
// Transcribes the audio from a media file and applies any additional Request
// Parameters you choose to include in your request.
//
// To make a StartTranscriptionJob request, you must first upload your media
// file into an Amazon S3 bucket; you can then specify the Amazon S3 location
// of the file using the Media parameter.
//
// You must include the following parameters in your StartTranscriptionJob request:
//
//   - region: The Amazon Web Services Region where you are making your request.
//     For a list of Amazon Web Services Regions supported with Amazon Transcribe,
//     refer to Amazon Transcribe endpoints and quotas (https://docs.aws.amazon.com/general/latest/gr/transcribe.html).
//
//   - TranscriptionJobName: A custom name you create for your transcription
//     job that is unique within your Amazon Web Services account.
//
//   - Media (MediaFileUri): The Amazon S3 location of your media file.
//
//   - One of LanguageCode, IdentifyLanguage, or IdentifyMultipleLanguages:
//     If you know the language of your media file, specify it using the LanguageCode
//     parameter; you can find all valid language codes in the Supported languages
//     (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
//     table. If you don't know the languages spoken in your media, use either
//     IdentifyLanguage or IdentifyMultipleLanguages and let Amazon Transcribe
//     identify the languages for you.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation StartTranscriptionJob for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/StartTranscriptionJob
func (c *TranscribeService) StartTranscriptionJob(input *StartTranscriptionJobInput) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	return out, req.Send()
}

// StartTranscriptionJobWithContext is the same as StartTranscriptionJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartTranscriptionJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) StartTranscriptionJobWithContext(ctx aws.Context, input *StartTranscriptionJobInput, opts ...request.Option) (*StartTranscriptionJobOutput, error) {
	req, out := c.StartTranscriptionJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource
func (c *TranscribeService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Transcribe Service.
//
// Adds one or more custom tags, each in the form of a key:value pair, to the
// specified resource.
//
// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/TagResource
func (c *TranscribeService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource
func (c *TranscribeService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Transcribe Service.
//
// Removes the specified tags from the specified Amazon Transcribe resource.
//
// If you include UntagResource in your request, you must also include ResourceArn
// and TagKeys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UntagResource
func (c *TranscribeService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCallAnalyticsCategory = "UpdateCallAnalyticsCategory"

// UpdateCallAnalyticsCategoryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCallAnalyticsCategory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCallAnalyticsCategory for more information on using the UpdateCallAnalyticsCategory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCallAnalyticsCategoryRequest method.
//	req, resp := client.UpdateCallAnalyticsCategoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory
func (c *TranscribeService) UpdateCallAnalyticsCategoryRequest(input *UpdateCallAnalyticsCategoryInput) (req *request.Request, output *UpdateCallAnalyticsCategoryOutput) {
	op := &request.Operation{
		Name:       opUpdateCallAnalyticsCategory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCallAnalyticsCategoryInput{}
	}

	output = &UpdateCallAnalyticsCategoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCallAnalyticsCategory API operation for Amazon Transcribe Service.
//
// Updates the specified Call Analytics category with new rules. Note that the
// UpdateCallAnalyticsCategory operation overwrites all existing rules contained
// in the specified category. You cannot append additional rules onto an existing
// category.
//
// To create a new category, see .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateCallAnalyticsCategory for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateCallAnalyticsCategory
func (c *TranscribeService) UpdateCallAnalyticsCategory(input *UpdateCallAnalyticsCategoryInput) (*UpdateCallAnalyticsCategoryOutput, error) {
	req, out := c.UpdateCallAnalyticsCategoryRequest(input)
	return out, req.Send()
}

// UpdateCallAnalyticsCategoryWithContext is the same as UpdateCallAnalyticsCategory with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCallAnalyticsCategory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateCallAnalyticsCategoryWithContext(ctx aws.Context, input *UpdateCallAnalyticsCategoryInput, opts ...request.Option) (*UpdateCallAnalyticsCategoryOutput, error) {
	req, out := c.UpdateCallAnalyticsCategoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMedicalVocabulary = "UpdateMedicalVocabulary"

// UpdateMedicalVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMedicalVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMedicalVocabulary for more information on using the UpdateMedicalVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMedicalVocabularyRequest method.
//	req, resp := client.UpdateMedicalVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabularyRequest(input *UpdateMedicalVocabularyInput) (req *request.Request, output *UpdateMedicalVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateMedicalVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMedicalVocabularyInput{}
	}

	output = &UpdateMedicalVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMedicalVocabulary API operation for Amazon Transcribe Service.
//
// Updates an existing custom medical vocabulary with new values. This operation
// overwrites all existing information with your new values; you cannot append
// new terms onto an existing custom vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateMedicalVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateMedicalVocabulary
func (c *TranscribeService) UpdateMedicalVocabulary(input *UpdateMedicalVocabularyInput) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	return out, req.Send()
}

// UpdateMedicalVocabularyWithContext is the same as UpdateMedicalVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMedicalVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateMedicalVocabularyWithContext(ctx aws.Context, input *UpdateMedicalVocabularyInput, opts ...request.Option) (*UpdateMedicalVocabularyOutput, error) {
	req, out := c.UpdateMedicalVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabulary = "UpdateVocabulary"

// UpdateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabulary for more information on using the UpdateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVocabularyRequest method.
//	req, resp := client.UpdateVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabularyRequest(input *UpdateVocabularyInput) (req *request.Request, output *UpdateVocabularyOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyInput{}
	}

	output = &UpdateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabulary API operation for Amazon Transcribe Service.
//
// Updates an existing custom vocabulary with new values. This operation overwrites
// all existing information with your new values; you cannot append new terms
// onto an existing custom vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
//   - ConflictException
//     A resource already exists with this name. Resource names must be unique within
//     an Amazon Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabulary
func (c *TranscribeService) UpdateVocabulary(input *UpdateVocabularyInput) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	return out, req.Send()
}

// UpdateVocabularyWithContext is the same as UpdateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyWithContext(ctx aws.Context, input *UpdateVocabularyInput, opts ...request.Option) (*UpdateVocabularyOutput, error) {
	req, out := c.UpdateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVocabularyFilter = "UpdateVocabularyFilter"

// UpdateVocabularyFilterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVocabularyFilter operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVocabularyFilter for more information on using the UpdateVocabularyFilter
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateVocabularyFilterRequest method.
//	req, resp := client.UpdateVocabularyFilterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilterRequest(input *UpdateVocabularyFilterInput) (req *request.Request, output *UpdateVocabularyFilterOutput) {
	op := &request.Operation{
		Name:       opUpdateVocabularyFilter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVocabularyFilterInput{}
	}

	output = &UpdateVocabularyFilterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVocabularyFilter API operation for Amazon Transcribe Service.
//
// Updates an existing custom vocabulary filter with a new list of words. The
// new list you provide overwrites all previous entries; you cannot append new
// terms onto an existing custom vocabulary filter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Transcribe Service's
// API operation UpdateVocabularyFilter for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     Your request didn't pass one or more validation tests. This can occur when
//     the entity you're trying to delete doesn't exist or if it's in a non-terminal
//     state (such as IN PROGRESS). See the exception message field for more information.
//
//   - LimitExceededException
//     You've either sent too many requests or your input file is too long. Wait
//     before retrying your request, or use a smaller file and try your request
//     again.
//
//   - InternalFailureException
//     There was an internal error. Check the error message, correct the issue,
//     and try your request again.
//
//   - NotFoundException
//     We can't find the requested resource. Check that the specified name is correct
//     and try your request again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/UpdateVocabularyFilter
func (c *TranscribeService) UpdateVocabularyFilter(input *UpdateVocabularyFilterInput) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	return out, req.Send()
}

// UpdateVocabularyFilterWithContext is the same as UpdateVocabularyFilter with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVocabularyFilter for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *TranscribeService) UpdateVocabularyFilterWithContext(ctx aws.Context, input *UpdateVocabularyFilterInput, opts ...request.Option) (*UpdateVocabularyFilterOutput, error) {
	req, out := c.UpdateVocabularyFilterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A time range, in milliseconds, between two points in your media file.
//
// You can use StartTime and EndTime to search a custom segment. For example,
// setting StartTime to 10000 and EndTime to 50000 only searches for your specified
// criteria in the audio contained between the 10,000 millisecond mark and the
// 50,000 millisecond mark of your media file. You must use StartTime and EndTime
// as a set; that is, if you include one, you must include both.
//
// You can use also First to search from the start of the audio until the time
// that you specify, or Last to search from the time that you specify until
// the end of the audio. For example, setting First to 50000 only searches for
// your specified criteria in the audio contained between the start of the media
// file to the 50,000 millisecond mark. You can use First and Last independently
// of each other.
//
// If you prefer to use percentage instead of milliseconds, see .
type AbsoluteTimeRange struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds, when Amazon Transcribe stops searching for the
	// specified criteria in your audio. If you include EndTime in your request,
	// you must also include StartTime.
	EndTime *int64 `type:"long"`

	// The time, in milliseconds, from the start of your media file until the specified
	// value. Amazon Transcribe searches for your specified criteria in this time
	// segment.
	First *int64 `type:"long"`

	// The time, in milliseconds, from the specified value until the end of your
	// media file. Amazon Transcribe searches for your specified criteria in this
	// time segment.
	Last *int64 `type:"long"`

	// The time, in milliseconds, when Amazon Transcribe starts searching for the
	// specified criteria in your audio. If you include StartTime in your request,
	// you must also include EndTime.
	StartTime *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbsoluteTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AbsoluteTimeRange) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *AbsoluteTimeRange) SetEndTime(v int64) *AbsoluteTimeRange {
	s.EndTime = &v
	return s
}

// SetFirst sets the First field's value.
func (s *AbsoluteTimeRange) SetFirst(v int64) *AbsoluteTimeRange {
	s.First = &v
	return s
}

// SetLast sets the Last field's value.
func (s *AbsoluteTimeRange) SetLast(v int64) *AbsoluteTimeRange {
	s.Last = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AbsoluteTimeRange) SetStartTime(v int64) *AbsoluteTimeRange {
	s.StartTime = &v
	return s
}

// Your request didn't pass one or more validation tests. This can occur when
// the entity you're trying to delete doesn't exist or if it's in a non-terminal
// state (such as IN PROGRESS). See the exception message field for more information.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides detailed information about a Call Analytics job.
//
// To view the job's status, refer to CallAnalyticsJobStatus. If the status
// is COMPLETED, the job is finished. You can find your completed transcript
// at the URI specified in TranscriptFileUri. If the status is FAILED, FailureReason
// provides details on why your transcription job failed.
//
// If you enabled personally identifiable information (PII) redaction, the redacted
// transcript appears at the location specified in RedactedTranscriptFileUri.
//
// If you chose to redact the audio in your media file, you can find your redacted
// media file at the location specified in the RedactedMediaFileUri field of
// your response.
type CallAnalyticsJob struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics job. Job names are case sensitive and must
	// be unique within an Amazon Web Services account.
	CallAnalyticsJobName *string `min:"1" type:"string"`

	// Provides the status of the specified Call Analytics job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri (or RedactedTranscriptFileUri,
	// if you requested transcript redaction). If the status is FAILED, FailureReason
	// provides details on why your transcription job failed.
	CallAnalyticsJobStatus *string `type:"string" enum:"CallAnalyticsJobStatus"`

	// Indicates which speaker is on which channel.
	ChannelDefinitions []*ChannelDefinition `min:"2" type:"list"`

	// The date and time the specified Call Analytics job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// The date and time the specified Call Analytics job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) you included in your request.
	DataAccessRoleArn *string `min:"20" type:"string"`

	// If CallAnalyticsJobStatus is FAILED, FailureReason contains information about
	// why the Call Analytics job request failed.
	//
	// The FailureReason field contains one of the following values:
	//
	//    * Unsupported media format. The media format specified in MediaFormat
	//    isn't valid. Refer to MediaFormat for a list of supported formats.
	//
	//    * The media format provided does not match the detected media format.
	//    The media format specified in MediaFormat doesn't match the format of
	//    the input file. Check the media format of your media file and correct
	//    the specified value.
	//
	//    * Invalid sample rate for audio file. The sample rate specified in MediaSampleRateHertz
	//    isn't valid. The sample rate must be between 8,000 and 48,000 hertz.
	//
	//    * The sample rate provided does not match the detected sample rate. The
	//    sample rate specified in MediaSampleRateHertz doesn't match the sample
	//    rate detected in your input media file. Check the sample rate of your
	//    media file and correct the specified value.
	//
	//    * Invalid file size: file size too large. The size of your media file
	//    is larger than what Amazon Transcribe can process. For more information,
	//    refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	//
	//    * Invalid number of channels: number of channels too large. Your audio
	//    contains more channels than Amazon Transcribe is able to process. For
	//    more information, refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	FailureReason *string `type:"string"`

	// The confidence score associated with the language identified in your media
	// file.
	//
	// Confidence scores are values between 0 and 1; a larger value indicates a
	// higher probability that the identified language correctly matches the language
	// spoken in your media.
	IdentifiedLanguageScore *float64 `type:"float"`

	// The language code used to create your Call Analytics job. For a list of supported
	// languages and their associated language codes, refer to the Supported languages
	// (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// If you don't know the language spoken in your media file, you can omit this
	// field and let Amazon Transcribe automatically identify the language of your
	// media. To improve the accuracy of language identification, you can include
	// several language codes and Amazon Transcribe chooses the closest match for
	// your transcription.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Provides the Amazon S3 location of the media file you used in your Call Analytics
	// request.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in hertz, of the audio track in your input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Provides information on any additional settings that were included in your
	// request. Additional settings include content redaction and language identification
	// settings.
	Settings *CallAnalyticsJobSettings `type:"structure"`

	// The date and time the specified Call Analytics job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`

	// Provides you with the Amazon S3 URI you can use to access your transcript.
	Transcript *Transcript `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJob) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *CallAnalyticsJob) SetCallAnalyticsJobName(v string) *CallAnalyticsJob {
	s.CallAnalyticsJobName = &v
	return s
}

// SetCallAnalyticsJobStatus sets the CallAnalyticsJobStatus field's value.
func (s *CallAnalyticsJob) SetCallAnalyticsJobStatus(v string) *CallAnalyticsJob {
	s.CallAnalyticsJobStatus = &v
	return s
}

// SetChannelDefinitions sets the ChannelDefinitions field's value.
func (s *CallAnalyticsJob) SetChannelDefinitions(v []*ChannelDefinition) *CallAnalyticsJob {
	s.ChannelDefinitions = v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *CallAnalyticsJob) SetCompletionTime(v time.Time) *CallAnalyticsJob {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CallAnalyticsJob) SetCreationTime(v time.Time) *CallAnalyticsJob {
	s.CreationTime = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CallAnalyticsJob) SetDataAccessRoleArn(v string) *CallAnalyticsJob {
	s.DataAccessRoleArn = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CallAnalyticsJob) SetFailureReason(v string) *CallAnalyticsJob {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *CallAnalyticsJob) SetIdentifiedLanguageScore(v float64) *CallAnalyticsJob {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CallAnalyticsJob) SetLanguageCode(v string) *CallAnalyticsJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *CallAnalyticsJob) SetMedia(v *Media) *CallAnalyticsJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *CallAnalyticsJob) SetMediaFormat(v string) *CallAnalyticsJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *CallAnalyticsJob) SetMediaSampleRateHertz(v int64) *CallAnalyticsJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *CallAnalyticsJob) SetSettings(v *CallAnalyticsJobSettings) *CallAnalyticsJob {
	s.Settings = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CallAnalyticsJob) SetStartTime(v time.Time) *CallAnalyticsJob {
	s.StartTime = &v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *CallAnalyticsJob) SetTranscript(v *Transcript) *CallAnalyticsJob {
	s.Transcript = v
	return s
}

// Provides additional optional settings for your request, including content
// redaction, automatic language identification; allows you to apply custom
// language models, custom vocabulary filters, and custom vocabularies.
type CallAnalyticsJobSettings struct {
	_ struct{} `type:"structure"`

	// Makes it possible to redact or flag specified personally identifiable information
	// (PII) in your transcript. If you use ContentRedaction, you must also include
	// the sub-parameters: PiiEntityTypes, RedactionOutput, and RedactionType.
	ContentRedaction *ContentRedaction `type:"structure"`

	// If using automatic language identification in your request and you want to
	// apply a custom language model, a custom vocabulary, or a custom vocabulary
	// filter, include LanguageIdSettings with the relevant sub-parameters (VocabularyName,
	// LanguageModelName, and VocabularyFilterName).
	//
	// LanguageIdSettings supports two to five language codes. Each language code
	// you include can have an associated custom language model, custom vocabulary,
	// and custom vocabulary filter. The language codes that you specify must match
	// the languages of the associated custom language models, custom vocabularies,
	// and custom vocabulary filters.
	//
	// It's recommended that you include LanguageOptions when using LanguageIdSettings
	// to ensure that the correct language dialect is identified. For example, if
	// you specify a custom vocabulary that is in en-US but Amazon Transcribe determines
	// that the language spoken in your media is en-AU, your custom vocabulary is
	// not applied to your transcription. If you include LanguageOptions and include
	// en-US as the only English language dialect, your custom vocabulary is applied
	// to your transcription.
	//
	// If you want to include a custom language model, custom vocabulary, or custom
	// vocabulary filter with your request but do not want to use automatic language
	// identification, use instead the parameter with the LanguageModelName, VocabularyName,
	// or VocabularyFilterName sub-parameters.
	//
	// For a list of languages supported with Call Analytics, refer to Supported
	// languages and language-specific features (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// The name of the custom language model you want to use when processing your
	// Call Analytics job. Note that custom language model names are case sensitive.
	//
	// The language of the specified custom language model must match the language
	// code that you specify in your transcription request. If the languages don't
	// match, the custom language model isn't applied. There are no errors or warnings
	// associated with a language mismatch.
	LanguageModelName *string `min:"1" type:"string"`

	// You can specify two or more language codes that represent the languages you
	// think may be present in your media. Including more than five is not recommended.
	// If you're unsure what languages are present, do not include this parameter.
	//
	// Including language options can improve the accuracy of language identification.
	//
	// For a list of languages supported with Call Analytics, refer to the Supported
	// languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// To transcribe speech in Modern Standard Arabic (ar-SA), your media file must
	// be encoded at a sample rate of 16,000 Hz or higher.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// Specify how you want your custom vocabulary filter applied to your transcript.
	//
	// To replace words with ***, choose mask.
	//
	// To delete words, choose remove.
	//
	// To flag words without changing them, choose tag.
	VocabularyFilterMethod *string `type:"string" enum:"VocabularyFilterMethod"`

	// The name of the custom vocabulary filter you want to include in your Call
	// Analytics transcription request. Custom vocabulary filter names are case
	// sensitive.
	//
	// Note that if you include VocabularyFilterName in your request, you must also
	// include VocabularyFilterMethod.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of the custom vocabulary you want to include in your Call Analytics
	// transcription request. Custom vocabulary names are case sensitive.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CallAnalyticsJobSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CallAnalyticsJobSettings"}
	if s.LanguageIdSettings != nil && len(s.LanguageIdSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageIdSettings", 1))
	}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.LanguageOptions != nil && len(s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.ContentRedaction != nil {
		if err := s.ContentRedaction.Validate(); err != nil {
			invalidParams.AddNested("ContentRedaction", err.(request.ErrInvalidParams))
		}
	}
	if s.LanguageIdSettings != nil {
		for i, v := range s.LanguageIdSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LanguageIdSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *CallAnalyticsJobSettings) SetContentRedaction(v *ContentRedaction) *CallAnalyticsJobSettings {
	s.ContentRedaction = v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *CallAnalyticsJobSettings) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *CallAnalyticsJobSettings {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *CallAnalyticsJobSettings) SetLanguageModelName(v string) *CallAnalyticsJobSettings {
	s.LanguageModelName = &v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *CallAnalyticsJobSettings) SetLanguageOptions(v []*string) *CallAnalyticsJobSettings {
	s.LanguageOptions = v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyFilterMethod(v string) *CallAnalyticsJobSettings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyFilterName(v string) *CallAnalyticsJobSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CallAnalyticsJobSettings) SetVocabularyName(v string) *CallAnalyticsJobSettings {
	s.VocabularyName = &v
	return s
}

// Provides detailed information about a specific Call Analytics job.
type CallAnalyticsJobSummary struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics job. Job names are case sensitive and must
	// be unique within an Amazon Web Services account.
	CallAnalyticsJobName *string `min:"1" type:"string"`

	// Provides the status of your Call Analytics job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri (or RedactedTranscriptFileUri,
	// if you requested transcript redaction). If the status is FAILED, FailureReason
	// provides details on why your transcription job failed.
	CallAnalyticsJobStatus *string `type:"string" enum:"CallAnalyticsJobStatus"`

	// The date and time the specified Call Analytics job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// The date and time the specified Call Analytics job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// If CallAnalyticsJobStatus is FAILED, FailureReason contains information about
	// why the Call Analytics job failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code used to create your Call Analytics transcription.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time your Call Analytics job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CallAnalyticsJobSummary) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *CallAnalyticsJobSummary) SetCallAnalyticsJobName(v string) *CallAnalyticsJobSummary {
	s.CallAnalyticsJobName = &v
	return s
}

// SetCallAnalyticsJobStatus sets the CallAnalyticsJobStatus field's value.
func (s *CallAnalyticsJobSummary) SetCallAnalyticsJobStatus(v string) *CallAnalyticsJobSummary {
	s.CallAnalyticsJobStatus = &v
	return s
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *CallAnalyticsJobSummary) SetCompletionTime(v time.Time) *CallAnalyticsJobSummary {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CallAnalyticsJobSummary) SetCreationTime(v time.Time) *CallAnalyticsJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CallAnalyticsJobSummary) SetFailureReason(v string) *CallAnalyticsJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CallAnalyticsJobSummary) SetLanguageCode(v string) *CallAnalyticsJobSummary {
	s.LanguageCode = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CallAnalyticsJobSummary) SetStartTime(v time.Time) *CallAnalyticsJobSummary {
	s.StartTime = &v
	return s
}

// Provides you with the properties of the Call Analytics category you specified
// in your request. This includes the list of rules that define the specified
// category.
type CategoryProperties struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics category. Category names are case sensitive
	// and must be unique within an Amazon Web Services account.
	CategoryName *string `min:"1" type:"string"`

	// The date and time the specified Call Analytics category was created.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	CreateTime *time.Time `type:"timestamp"`

	// The input type associated with the specified category. POST_CALL refers to
	// a category that is applied to batch transcriptions; REAL_TIME refers to a
	// category that is applied to streaming transcriptions.
	InputType *string `type:"string" enum:"InputType"`

	// The date and time the specified Call Analytics category was last updated.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-05T12:45:32.691000-07:00 represents 12:45 PM UTC-7 on May 5, 2022.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The rules used to define a Call Analytics category. Each category can have
	// between 1 and 20 rules.
	Rules []*Rule `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CategoryProperties) GoString() string {
	return s.String()
}

// SetCategoryName sets the CategoryName field's value.
func (s *CategoryProperties) SetCategoryName(v string) *CategoryProperties {
	s.CategoryName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *CategoryProperties) SetCreateTime(v time.Time) *CategoryProperties {
	s.CreateTime = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *CategoryProperties) SetInputType(v string) *CategoryProperties {
	s.InputType = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *CategoryProperties) SetLastUpdateTime(v time.Time) *CategoryProperties {
	s.LastUpdateTime = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CategoryProperties) SetRules(v []*Rule) *CategoryProperties {
	s.Rules = v
	return s
}

// Makes it possible to specify which speaker is on which channel. For example,
// if your agent is the first participant to speak, you would set ChannelId
// to 0 (to indicate the first channel) and ParticipantRole to AGENT (to indicate
// that it's the agent speaking).
type ChannelDefinition struct {
	_ struct{} `type:"structure"`

	// Specify the audio channel you want to define.
	ChannelId *int64 `type:"integer"`

	// Specify the speaker you want to define. Omitting this parameter is equivalent
	// to specifying both participants.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChannelDefinition) GoString() string {
	return s.String()
}

// SetChannelId sets the ChannelId field's value.
func (s *ChannelDefinition) SetChannelId(v int64) *ChannelDefinition {
	s.ChannelId = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *ChannelDefinition) SetParticipantRole(v string) *ChannelDefinition {
	s.ParticipantRole = &v
	return s
}

// A resource already exists with this name. Resource names must be unique within
// an Amazon Web Services account.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Makes it possible to redact or flag specified personally identifiable information
// (PII) in your transcript. If you use ContentRedaction, you must also include
// the sub-parameters: PiiEntityTypes, RedactionOutput, and RedactionType.
type ContentRedaction struct {
	_ struct{} `type:"structure"`

	// Specify which types of personally identifiable information (PII) you want
	// to redact in your transcript. You can include as many types as you'd like,
	// or you can select ALL.
	PiiEntityTypes []*string `type:"list" enum:"PiiEntityType"`

	// Specify if you want only a redacted transcript, or if you want a redacted
	// and an unredacted transcript.
	//
	// When you choose redacted Amazon Transcribe creates only a redacted transcript.
	//
	// When you choose redacted_and_unredacted Amazon Transcribe creates a redacted
	// and an unredacted transcript (as two separate files).
	//
	// RedactionOutput is a required field
	RedactionOutput *string `type:"string" required:"true" enum:"RedactionOutput"`

	// Specify the category of information you want to redact; PII (personally identifiable
	// information) is the only valid value. You can use PiiEntityTypes to choose
	// which types of PII you want to redact.
	//
	// RedactionType is a required field
	RedactionType *string `type:"string" required:"true" enum:"RedactionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRedaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContentRedaction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContentRedaction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContentRedaction"}
	if s.RedactionOutput == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionOutput"))
	}
	if s.RedactionType == nil {
		invalidParams.Add(request.NewErrParamRequired("RedactionType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPiiEntityTypes sets the PiiEntityTypes field's value.
func (s *ContentRedaction) SetPiiEntityTypes(v []*string) *ContentRedaction {
	s.PiiEntityTypes = v
	return s
}

// SetRedactionOutput sets the RedactionOutput field's value.
func (s *ContentRedaction) SetRedactionOutput(v string) *ContentRedaction {
	s.RedactionOutput = &v
	return s
}

// SetRedactionType sets the RedactionType field's value.
func (s *ContentRedaction) SetRedactionType(v string) *ContentRedaction {
	s.RedactionType = &v
	return s
}

type CreateCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// A unique name, chosen by you, for your Call Analytics category. It's helpful
	// to use a detailed naming system that will make sense to you in the future.
	// For example, it's better to use sentiment-positive-last30seconds for a category
	// over a generic name like test-category.
	//
	// Category names are case sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`

	// Choose whether you want to create a real-time or a post-call category for
	// your Call Analytics transcription.
	//
	// Specifying POST_CALL assigns your category to post-call transcriptions; categories
	// with this input type cannot be applied to streaming (real-time) transcriptions.
	//
	// Specifying REAL_TIME assigns your category to streaming transcriptions; categories
	// with this input type cannot be applied to post-call transcriptions.
	//
	// If you do not include InputType, your category is created as a post-call
	// category by default.
	InputType *string `type:"string" enum:"InputType"`

	// Rules define a Call Analytics category. When creating a new category, you
	// must create between 1 and 20 rules for that category. For each rule, you
	// specify a filter you want applied to the attributes of a call. For example,
	// you can choose a sentiment filter that detects if a customer's sentiment
	// was positive during the last 30 seconds of the call.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *CreateCallAnalyticsCategoryInput) SetCategoryName(v string) *CreateCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *CreateCallAnalyticsCategoryInput) SetInputType(v string) *CreateCallAnalyticsCategoryInput {
	s.InputType = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *CreateCallAnalyticsCategoryInput) SetRules(v []*Rule) *CreateCallAnalyticsCategoryInput {
	s.Rules = v
	return s
}

type CreateCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// Provides you with the properties of your new category, including its associated
	// rules.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *CreateCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *CreateCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type CreateLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model, used to create
	// your custom language model. Amazon Transcribe offers two options for base
	// models: Wideband and Narrowband.
	//
	// If the audio you want to transcribe has a sample rate of 16,000 Hz or greater,
	// choose WideBand. To transcribe audio with a sample rate less than 16,000
	// Hz, choose NarrowBand.
	//
	// BaseModelName is a required field
	BaseModelName *string `type:"string" required:"true" enum:"BaseModelName"`

	// Contains the Amazon S3 location of the training data you want to use to create
	// a new custom language model, and permissions to access this location.
	//
	// When using InputDataConfig, you must include these sub-parameters: S3Uri,
	// which is the Amazon S3 location of your training data, and DataAccessRoleArn,
	// which is the Amazon Resource Name (ARN) of the role that has permission to
	// access your specified Amazon S3 location. You can optionally include TuningDataS3Uri,
	// which is the Amazon S3 location of your tuning data. If you specify different
	// Amazon S3 locations for training and tuning data, the ARN you use must have
	// permissions to access both locations.
	//
	// InputDataConfig is a required field
	InputDataConfig *InputDataConfig `type:"structure" required:"true"`

	// The language code that represents the language of your model. Each custom
	// language model must contain terms in only one language, and the language
	// you select for your custom language model must match the language of your
	// training and tuning data.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table. Note that US English (en-US) is the only language supported with Amazon
	// Transcribe Medical.
	//
	// A custom language model can only be used to transcribe files in the same
	// language as the model. For example, if you create a custom language model
	// using US English (en-US), you can only apply this model to files that contain
	// English audio.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"CLMLanguageCode"`

	// A unique name, chosen by you, for your custom language model.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new custom language
	// model with the same name as an existing custom language model, you get a
	// ConflictException error.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new custom language model at the time you create this new model.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLanguageModelInput"}
	if s.BaseModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("BaseModelName"))
	}
	if s.InputDataConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputDataConfig"))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelInput) SetBaseModelName(v string) *CreateLanguageModelInput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelInput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelInput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelInput) SetLanguageCode(v string) *CreateLanguageModelInput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelInput) SetModelName(v string) *CreateLanguageModelInput {
	s.ModelName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLanguageModelInput) SetTags(v []*Tag) *CreateLanguageModelInput {
	s.Tags = v
	return s
}

type CreateLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model, you specified
	// when creating your custom language model.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// Lists your data access role ARN (Amazon Resource Name) and the Amazon S3
	// locations you provided for your training (S3Uri) and tuning (TuningDataS3Uri)
	// data.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code you selected for your custom language model.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The name of your custom language model.
	ModelName *string `min:"1" type:"string"`

	// The status of your custom language model. When the status displays as COMPLETED,
	// your model is ready to use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLanguageModelOutput) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *CreateLanguageModelOutput) SetBaseModelName(v string) *CreateLanguageModelOutput {
	s.BaseModelName = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *CreateLanguageModelOutput) SetInputDataConfig(v *InputDataConfig) *CreateLanguageModelOutput {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateLanguageModelOutput) SetLanguageCode(v string) *CreateLanguageModelOutput {
	s.LanguageCode = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *CreateLanguageModelOutput) SetModelName(v string) *CreateLanguageModelOutput {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *CreateLanguageModelOutput) SetModelStatus(v string) *CreateLanguageModelOutput {
	s.ModelStatus = &v
	return s
}

type CreateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code that represents the language of the entries in your custom
	// vocabulary. US English (en-US) is the only language supported with Amazon
	// Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new custom medical vocabulary at the time you create this new custom vocabulary.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon S3 location (URI) of the text file that contains your custom medical
	// vocabulary. The URI must be in the same Amazon Web Services Region as the
	// resource you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt
	//
	// VocabularyFileUri is a required field
	VocabularyFileUri *string `min:"1" type:"string" required:"true"`

	// A unique name, chosen by you, for your new custom medical vocabulary.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new custom medical
	// vocabulary with the same name as an existing custom medical vocabulary, you
	// get a ConflictException error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFileUri == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFileUri"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyInput) SetLanguageCode(v string) *CreateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateMedicalVocabularyInput) SetTags(v []*Tag) *CreateMedicalVocabularyInput {
	s.Tags = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyFileUri(v string) *CreateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyInput) SetVocabularyName(v string) *CreateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If VocabularyState is FAILED, FailureReason contains information about why
	// the medical transcription job request failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code you selected for your custom medical vocabulary. US English
	// (en-US) is the only language supported with Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time you created your custom medical vocabulary.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name you chose for your custom medical vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom medical vocabulary. If the state is READY,
	// you can use the custom vocabulary in a StartMedicalTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateMedicalVocabularyOutput) SetFailureReason(v string) *CreateMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateMedicalVocabularyOutput) SetLanguageCode(v string) *CreateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyName(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateMedicalVocabularyOutput) SetVocabularyState(v string) *CreateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type CreateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files (in this case, your custom
	// vocabulary filter). If the role that you specify doesn’t have the appropriate
	// permissions to access the specified Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The language code that represents the language of the entries in your vocabulary
	// filter. Each custom vocabulary filter must contain terms in only one language.
	//
	// A custom vocabulary filter can only be used to transcribe files in the same
	// language as the filter. For example, if you create a custom vocabulary filter
	// using US English (en-US), you can only apply this filter to files that contain
	// English audio.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new custom vocabulary filter at the time you create this new vocabulary filter.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon S3 location of the text file that contains your custom vocabulary
	// filter terms. The URI must be located in the same Amazon Web Services Region
	// as the resource you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt
	//
	// Note that if you include VocabularyFilterFileUri in your request, you cannot
	// use Words; you must choose one or the other.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// A unique name, chosen by you, for your new custom vocabulary filter.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new custom vocabulary
	// filter with the same name as an existing custom vocabulary filter, you get
	// a ConflictException error.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// Use this parameter if you want to create your custom vocabulary filter by
	// including all desired terms, as comma-separated values, within your request.
	// The other option for creating your vocabulary filter is to save your entries
	// in a text file and upload them to an Amazon S3 bucket, then specify the location
	// of your file using the VocabularyFilterFileUri parameter.
	//
	// Note that if you include Words in your request, you cannot use VocabularyFilterFileUri;
	// you must choose one or the other.
	//
	// Each language has a character set that contains all allowed characters for
	// that specific language. If you use unsupported characters, your custom vocabulary
	// filter request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
	// to get the character set for your language.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyFilterInput"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateVocabularyFilterInput) SetDataAccessRoleArn(v string) *CreateVocabularyFilterInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterInput) SetLanguageCode(v string) *CreateVocabularyFilterInput {
	s.LanguageCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVocabularyFilterInput) SetTags(v []*Tag) *CreateVocabularyFilterInput {
	s.Tags = v
	return s
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterInput) SetVocabularyFilterName(v string) *CreateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *CreateVocabularyFilterInput) SetWords(v []*string) *CreateVocabularyFilterInput {
	s.Words = v
	return s
}

type CreateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code you selected for your custom vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time you created your custom vocabulary filter.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name you chose for your custom vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyFilterOutput) SetLanguageCode(v string) *CreateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *CreateVocabularyFilterOutput) SetVocabularyFilterName(v string) *CreateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type CreateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files (in this case, your custom
	// vocabulary). If the role that you specify doesn’t have the appropriate
	// permissions to access the specified Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The language code that represents the language of the entries in your custom
	// vocabulary. Each custom vocabulary must contain terms in only one language.
	//
	// A custom vocabulary can only be used to transcribe files in the same language
	// as the custom vocabulary. For example, if you create a custom vocabulary
	// using US English (en-US), you can only apply this custom vocabulary to files
	// that contain English audio.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Use this parameter if you want to create your custom vocabulary by including
	// all desired terms, as comma-separated values, within your request. The other
	// option for creating your custom vocabulary is to save your entries in a text
	// file and upload them to an Amazon S3 bucket, then specify the location of
	// your file using the VocabularyFileUri parameter.
	//
	// Note that if you include Phrases in your request, you cannot use VocabularyFileUri;
	// you must choose one or the other.
	//
	// Each language has a character set that contains all allowed characters for
	// that specific language. If you use unsupported characters, your custom vocabulary
	// filter request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
	// to get the character set for your language.
	Phrases []*string `type:"list"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new custom vocabulary at the time you create this new custom vocabulary.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// The Amazon S3 location of the text file that contains your custom vocabulary.
	// The URI must be located in the same Amazon Web Services Region as the resource
	// you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt
	//
	// Note that if you include VocabularyFileUri in your request, you cannot use
	// the Phrases flag; you must choose one or the other.
	VocabularyFileUri *string `min:"1" type:"string"`

	// A unique name, chosen by you, for your new custom vocabulary.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new custom vocabulary
	// with the same name as an existing custom vocabulary, you get a ConflictException
	// error.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyInput"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *CreateVocabularyInput) SetDataAccessRoleArn(v string) *CreateVocabularyInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyInput) SetLanguageCode(v string) *CreateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *CreateVocabularyInput) SetPhrases(v []*string) *CreateVocabularyInput {
	s.Phrases = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVocabularyInput) SetTags(v []*Tag) *CreateVocabularyInput {
	s.Tags = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *CreateVocabularyInput) SetVocabularyFileUri(v string) *CreateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyInput) SetVocabularyName(v string) *CreateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// If VocabularyState is FAILED, FailureReason contains information about why
	// the custom vocabulary request failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code you selected for your custom vocabulary.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time you created your custom vocabulary.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name you chose for your custom vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary. If the state is READY, you
	// can use the custom vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyOutput) GoString() string {
	return s.String()
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateVocabularyOutput) SetFailureReason(v string) *CreateVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyOutput) SetLanguageCode(v string) *CreateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreateVocabularyOutput) SetLastModifiedTime(v time.Time) *CreateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyOutput) SetVocabularyName(v string) *CreateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *CreateVocabularyOutput) SetVocabularyState(v string) *CreateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type DeleteCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics category you want to delete. Category names
	// are case sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *DeleteCallAnalyticsCategoryInput) SetCategoryName(v string) *DeleteCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

type DeleteCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

type DeleteCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics job you want to delete. Job names are case
	// sensitive.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *DeleteCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *DeleteCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

type DeleteCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

type DeleteLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you want to delete. Model names are
	// case sensitive.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteLanguageModelInput) SetModelName(v string) *DeleteLanguageModelInput {
	s.ModelName = &v
	return s
}

type DeleteLanguageModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLanguageModelOutput) GoString() string {
	return s.String()
}

type DeleteMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job you want to delete. Job names are
	// case sensitive.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *DeleteMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *DeleteMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type DeleteMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom medical vocabulary you want to delete. Custom medical
	// vocabulary names are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteMedicalVocabularyInput) SetVocabularyName(v string) *DeleteMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMedicalVocabularyOutput) GoString() string {
	return s.String()
}

type DeleteTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transcription job you want to delete. Job names are case
	// sensitive.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *DeleteTranscriptionJobInput) SetTranscriptionJobName(v string) *DeleteTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type DeleteTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTranscriptionJobOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom vocabulary filter you want to delete. Custom vocabulary
	// filter names are case sensitive.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *DeleteVocabularyFilterInput) SetVocabularyFilterName(v string) *DeleteVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type DeleteVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyFilterOutput) GoString() string {
	return s.String()
}

type DeleteVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom vocabulary you want to delete. Custom vocabulary names
	// are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *DeleteVocabularyInput) SetVocabularyName(v string) *DeleteVocabularyInput {
	s.VocabularyName = &v
	return s
}

type DeleteVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVocabularyOutput) GoString() string {
	return s.String()
}

type DescribeLanguageModelInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you want information about. Model names
	// are case sensitive.
	//
	// ModelName is a required field
	ModelName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLanguageModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLanguageModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DescribeLanguageModelInput) SetModelName(v string) *DescribeLanguageModelInput {
	s.ModelName = &v
	return s
}

type DescribeLanguageModelOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about the specified custom language model.
	//
	// This parameter also shows if the base language model you used to create your
	// custom language model has been updated. If Amazon Transcribe has updated
	// the base model, you can create a new custom language model using the updated
	// base model.
	//
	// If you tried to create a new custom language model and the request wasn't
	// successful, you can use this DescribeLanguageModel to help identify the reason
	// for this failure.
	LanguageModel *LanguageModel `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeLanguageModelOutput) GoString() string {
	return s.String()
}

// SetLanguageModel sets the LanguageModel field's value.
func (s *DescribeLanguageModelOutput) SetLanguageModel(v *LanguageModel) *DescribeLanguageModelOutput {
	s.LanguageModel = v
	return s
}

type GetCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics category you want information about. Category
	// names are case sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *GetCallAnalyticsCategoryInput) SetCategoryName(v string) *GetCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

type GetCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// Provides you with the properties of the Call Analytics category you specified
	// in your GetCallAnalyticsCategory request.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *GetCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *GetCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type GetCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics job you want information about. Job names
	// are case sensitive.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *GetCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *GetCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

type GetCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the specified Call Analytics job, including
	// job status and, if applicable, failure reason.
	CallAnalyticsJob *CallAnalyticsJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJob sets the CallAnalyticsJob field's value.
func (s *GetCallAnalyticsJobOutput) SetCallAnalyticsJob(v *CallAnalyticsJob) *GetCallAnalyticsJobOutput {
	s.CallAnalyticsJob = v
	return s
}

type GetMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the medical transcription job you want information about. Job
	// names are case sensitive.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalTranscriptionJobInput"}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *GetMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *GetMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

type GetMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the specified medical transcription job,
	// including job status and, if applicable, failure reason.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *GetMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *GetMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type GetMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom medical vocabulary you want information about. Custom
	// medical vocabulary names are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMedicalVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyInput) SetVocabularyName(v string) *GetMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the specified custom medical vocabulary is stored;
	// use this URI to view or download the custom vocabulary.
	DownloadUri *string `min:"1" type:"string"`

	// If VocabularyState is FAILED, FailureReason contains information about why
	// the custom medical vocabulary request failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code you selected for your custom medical vocabulary. US English
	// (en-US) is the only language supported with Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom medical vocabulary was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the custom medical vocabulary you requested information about.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom medical vocabulary. If the state is READY,
	// you can use the custom vocabulary in a StartMedicalTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetMedicalVocabularyOutput) SetDownloadUri(v string) *GetMedicalVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetMedicalVocabularyOutput) SetFailureReason(v string) *GetMedicalVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetMedicalVocabularyOutput) SetLanguageCode(v string) *GetMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *GetMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyName(v string) *GetMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetMedicalVocabularyOutput) SetVocabularyState(v string) *GetMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type GetTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the transcription job you want information about. Job names are
	// case sensitive.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTranscriptionJobInput"}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *GetTranscriptionJobInput) SetTranscriptionJobName(v string) *GetTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type GetTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the specified transcription job, including
	// job status and, if applicable, failure reason.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *GetTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *GetTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

type GetVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom vocabulary filter you want information about. Custom
	// vocabulary filter names are case sensitive.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyFilterInput"}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterInput) SetVocabularyFilterName(v string) *GetVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location where the custom vocabulary filter is stored; use
	// this URI to view or download the custom vocabulary filter.
	DownloadUri *string `min:"1" type:"string"`

	// The language code you selected for your custom vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary filter was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the custom vocabulary filter you requested information about.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyFilterOutput) SetDownloadUri(v string) *GetVocabularyFilterOutput {
	s.DownloadUri = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyFilterOutput) SetLanguageCode(v string) *GetVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *GetVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *GetVocabularyFilterOutput) SetVocabularyFilterName(v string) *GetVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type GetVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The name of the custom vocabulary you want information about. Custom vocabulary
	// names are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVocabularyInput"}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyInput) SetVocabularyName(v string) *GetVocabularyInput {
	s.VocabularyName = &v
	return s
}

type GetVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The S3 location where the custom vocabulary is stored; use this URI to view
	// or download the custom vocabulary.
	DownloadUri *string `min:"1" type:"string"`

	// If VocabularyState is FAILED, FailureReason contains information about why
	// the custom vocabulary request failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code you selected for your custom vocabulary.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the custom vocabulary you requested information about.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary. If the state is READY, you
	// can use the custom vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVocabularyOutput) GoString() string {
	return s.String()
}

// SetDownloadUri sets the DownloadUri field's value.
func (s *GetVocabularyOutput) SetDownloadUri(v string) *GetVocabularyOutput {
	s.DownloadUri = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *GetVocabularyOutput) SetFailureReason(v string) *GetVocabularyOutput {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *GetVocabularyOutput) SetLanguageCode(v string) *GetVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *GetVocabularyOutput) SetLastModifiedTime(v time.Time) *GetVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *GetVocabularyOutput) SetVocabularyName(v string) *GetVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *GetVocabularyOutput) SetVocabularyState(v string) *GetVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// Contains the Amazon S3 location of the training data you want to use to create
// a new custom language model, and permissions to access this location.
//
// When using InputDataConfig, you must include these sub-parameters: S3Uri
// and DataAccessRoleArn. You can optionally include TuningDataS3Uri.
type InputDataConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files. If the role that you
	// specify doesn’t have the appropriate permissions to access the specified
	// Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon S3 location (URI) of the text files you want to use to train your
	// custom language model.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-model-training-data/
	//
	// S3Uri is a required field
	S3Uri *string `min:"1" type:"string" required:"true"`

	// The Amazon S3 location (URI) of the text files you want to use to tune your
	// custom language model.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/
	TuningDataS3Uri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputDataConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputDataConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InputDataConfig"}
	if s.DataAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}
	if s.TuningDataS3Uri != nil && len(*s.TuningDataS3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TuningDataS3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *InputDataConfig) SetDataAccessRoleArn(v string) *InputDataConfig {
	s.DataAccessRoleArn = &v
	return s
}

// SetS3Uri sets the S3Uri field's value.
func (s *InputDataConfig) SetS3Uri(v string) *InputDataConfig {
	s.S3Uri = &v
	return s
}

// SetTuningDataS3Uri sets the TuningDataS3Uri field's value.
func (s *InputDataConfig) SetTuningDataS3Uri(v string) *InputDataConfig {
	s.TuningDataS3Uri = &v
	return s
}

// There was an internal error. Check the error message, correct the issue,
// and try your request again.
type InternalFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalFailureException) GoString() string {
	return s.String()
}

func newErrorInternalFailureException(v protocol.ResponseMetadata) error {
	return &InternalFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalFailureException) Code() string {
	return "InternalFailureException"
}

// Message returns the exception's message.
func (s *InternalFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalFailureException) OrigErr() error {
	return nil
}

func (s *InternalFailureException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Flag the presence or absence of interruptions in your Call Analytics transcription
// output.
//
// Rules using InterruptionFilter are designed to match:
//
//   - Instances where an agent interrupts a customer
//
//   - Instances where a customer interrupts an agent
//
//   - Either participant interrupting the other
//
//   - A lack of interruptions
//
// See Rule criteria for post-call categories (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch)
// for usage examples.
type InterruptionFilter struct {
	_ struct{} `type:"structure"`

	// Makes it possible to specify a time range (in milliseconds) in your audio,
	// during which you want to search for an interruption. See for more detail.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to flag speech that does not contain interruptions. Set to FALSE
	// to flag speech that contains interruptions.
	Negate *bool `type:"boolean"`

	// Specify the interrupter that you want to flag. Omitting this parameter is
	// equivalent to specifying both participants.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// Makes it possible to specify a time range (in percentage) in your media file,
	// during which you want to search for an interruption. See for more detail.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// Specify the duration of the interruptions in milliseconds. For example, you
	// can flag speech that contains more than 10,000 milliseconds of interruptions.
	Threshold *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterruptionFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InterruptionFilter) GoString() string {
	return s.String()
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *InterruptionFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *InterruptionFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *InterruptionFilter) SetNegate(v bool) *InterruptionFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *InterruptionFilter) SetParticipantRole(v string) *InterruptionFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *InterruptionFilter) SetRelativeTimeRange(v *RelativeTimeRange) *InterruptionFilter {
	s.RelativeTimeRange = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *InterruptionFilter) SetThreshold(v int64) *InterruptionFilter {
	s.Threshold = &v
	return s
}

// Makes it possible to control how your transcription job is processed. Currently,
// the only JobExecutionSettings modification you can choose is enabling job
// queueing using the AllowDeferredExecution sub-parameter.
//
// If you include JobExecutionSettings in your request, you must also include
// the sub-parameters: AllowDeferredExecution and DataAccessRoleArn.
type JobExecutionSettings struct {
	_ struct{} `type:"structure"`

	// Makes it possible to enable job queuing when your concurrent request limit
	// is exceeded. When AllowDeferredExecution is set to true, transcription job
	// requests are placed in a queue until the number of jobs falls below the concurrent
	// request limit. If AllowDeferredExecution is set to false and the number of
	// transcription job requests exceed the concurrent request limit, you get a
	// LimitExceededException error.
	//
	// If you include AllowDeferredExecution in your request, you must also include
	// DataAccessRoleArn.
	AllowDeferredExecution *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files. If the role that you
	// specify doesn’t have the appropriate permissions to access the specified
	// Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin. For more information,
	// see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	//
	// Note that if you include DataAccessRoleArn in your request, you must also
	// include AllowDeferredExecution.
	DataAccessRoleArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobExecutionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobExecutionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobExecutionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobExecutionSettings"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowDeferredExecution sets the AllowDeferredExecution field's value.
func (s *JobExecutionSettings) SetAllowDeferredExecution(v bool) *JobExecutionSettings {
	s.AllowDeferredExecution = &v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *JobExecutionSettings) SetDataAccessRoleArn(v string) *JobExecutionSettings {
	s.DataAccessRoleArn = &v
	return s
}

// Provides information on the speech contained in a discreet utterance when
// multi-language identification is enabled in your request. This utterance
// represents a block of speech consisting of one language, preceded or followed
// by a block of speech in a different language.
type LanguageCodeItem struct {
	_ struct{} `type:"structure"`

	// Provides the total time, in seconds, each identified language is spoken in
	// your media.
	DurationInSeconds *float64 `type:"float"`

	// Provides the language code for each language identified in your media.
	LanguageCode *string `type:"string" enum:"LanguageCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageCodeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageCodeItem) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *LanguageCodeItem) SetDurationInSeconds(v float64) *LanguageCodeItem {
	s.DurationInSeconds = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LanguageCodeItem) SetLanguageCode(v string) *LanguageCodeItem {
	s.LanguageCode = &v
	return s
}

// If using automatic language identification in your request and you want to
// apply a custom language model, a custom vocabulary, or a custom vocabulary
// filter, include LanguageIdSettings with the relevant sub-parameters (VocabularyName,
// LanguageModelName, and VocabularyFilterName). Note that multi-language identification
// (IdentifyMultipleLanguages) doesn't support custom language models.
//
// LanguageIdSettings supports two to five language codes. Each language code
// you include can have an associated custom language model, custom vocabulary,
// and custom vocabulary filter. The language codes that you specify must match
// the languages of the associated custom language models, custom vocabularies,
// and custom vocabulary filters.
//
// It's recommended that you include LanguageOptions when using LanguageIdSettings
// to ensure that the correct language dialect is identified. For example, if
// you specify a custom vocabulary that is in en-US but Amazon Transcribe determines
// that the language spoken in your media is en-AU, your custom vocabulary is
// not applied to your transcription. If you include LanguageOptions and include
// en-US as the only English language dialect, your custom vocabulary is applied
// to your transcription.
//
// If you want to include a custom language model with your request but do not
// want to use automatic language identification, use instead the parameter
// with the LanguageModelName sub-parameter. If you want to include a custom
// vocabulary or a custom vocabulary filter (or both) with your request but
// do not want to use automatic language identification, use instead the parameter
// with the VocabularyName or VocabularyFilterName (or both) sub-parameter.
type LanguageIdSettings struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you want to use when processing your
	// transcription job. Note that custom language model names are case sensitive.
	//
	// The language of the specified custom language model must match the language
	// code that you specify in your transcription request. If the languages don't
	// match, the custom language model isn't applied. There are no errors or warnings
	// associated with a language mismatch.
	LanguageModelName *string `min:"1" type:"string"`

	// The name of the custom vocabulary filter you want to use when processing
	// your transcription job. Custom vocabulary filter names are case sensitive.
	//
	// The language of the specified custom vocabulary filter must match the language
	// code that you specify in your transcription request. If the languages don't
	// match, the custom vocabulary filter isn't applied. There are no errors or
	// warnings associated with a language mismatch.
	//
	// Note that if you include VocabularyFilterName in your request, you must also
	// include VocabularyFilterMethod.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of the custom vocabulary you want to use when processing your transcription
	// job. Custom vocabulary names are case sensitive.
	//
	// The language of the specified custom vocabulary must match the language code
	// that you specify in your transcription request. If the languages don't match,
	// the custom vocabulary isn't applied. There are no errors or warnings associated
	// with a language mismatch.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageIdSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageIdSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LanguageIdSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LanguageIdSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *LanguageIdSettings) SetLanguageModelName(v string) *LanguageIdSettings {
	s.LanguageModelName = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *LanguageIdSettings) SetVocabularyFilterName(v string) *LanguageIdSettings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *LanguageIdSettings) SetVocabularyName(v string) *LanguageIdSettings {
	s.VocabularyName = &v
	return s
}

// Provides information about a custom language model, including:
//
//   - The base model name
//
//   - When the model was created
//
//   - The location of the files used to train the model
//
//   - When the model was last modified
//
//   - The name you chose for the model
//
//   - The model's language
//
//   - The model's processing state
//
//   - Any available upgrades for the base model
type LanguageModel struct {
	_ struct{} `type:"structure"`

	// The Amazon Transcribe standard language model, or base model, used to create
	// your custom language model.
	BaseModelName *string `type:"string" enum:"BaseModelName"`

	// The date and time the specified custom language model was created.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	CreateTime *time.Time `type:"timestamp"`

	// If ModelStatus is FAILED, FailureReason contains information about why the
	// custom language model request failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The Amazon S3 location of the input files used to train and tune your custom
	// language model, in addition to the data access role ARN (Amazon Resource
	// Name) that has permissions to access these data.
	InputDataConfig *InputDataConfig `type:"structure"`

	// The language code used to create your custom language model. Each custom
	// language model must contain terms in only one language, and the language
	// you select for your custom language model must match the language of your
	// training and tuning data.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table. Note that U.S. English (en-US) is the only language supported with
	// Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"CLMLanguageCode"`

	// The date and time the specified custom language model was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// A unique name, chosen by you, for your custom language model.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account.
	ModelName *string `min:"1" type:"string"`

	// The status of the specified custom language model. When the status displays
	// as COMPLETED the model is ready for use.
	ModelStatus *string `type:"string" enum:"ModelStatus"`

	// Shows if a more current base model is available for use with the specified
	// custom language model.
	//
	// If false, your custom language model is using the most up-to-date base model.
	//
	// If true, there is a newer base model available than the one your language
	// model is using.
	//
	// Note that to update a base model, you must recreate the custom language model
	// using the new base model. Base model upgrades for existing custom language
	// models are not supported.
	UpgradeAvailability *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageModel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LanguageModel) GoString() string {
	return s.String()
}

// SetBaseModelName sets the BaseModelName field's value.
func (s *LanguageModel) SetBaseModelName(v string) *LanguageModel {
	s.BaseModelName = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *LanguageModel) SetCreateTime(v time.Time) *LanguageModel {
	s.CreateTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *LanguageModel) SetFailureReason(v string) *LanguageModel {
	s.FailureReason = &v
	return s
}

// SetInputDataConfig sets the InputDataConfig field's value.
func (s *LanguageModel) SetInputDataConfig(v *InputDataConfig) *LanguageModel {
	s.InputDataConfig = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *LanguageModel) SetLanguageCode(v string) *LanguageModel {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *LanguageModel) SetLastModifiedTime(v time.Time) *LanguageModel {
	s.LastModifiedTime = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *LanguageModel) SetModelName(v string) *LanguageModel {
	s.ModelName = &v
	return s
}

// SetModelStatus sets the ModelStatus field's value.
func (s *LanguageModel) SetModelStatus(v string) *LanguageModel {
	s.ModelStatus = &v
	return s
}

// SetUpgradeAvailability sets the UpgradeAvailability field's value.
func (s *LanguageModel) SetUpgradeAvailability(v bool) *LanguageModel {
	s.UpgradeAvailability = &v
	return s
}

// You've either sent too many requests or your input file is too long. Wait
// before retrying your request, or use a smaller file and try your request
// again.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCallAnalyticsCategoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of Call Analytics categories to return in each page of
	// results. If there are fewer results than the value that you specify, only
	// the actual results are returned. If you don't specify a value, a default
	// of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If your ListCallAnalyticsCategories request returns more results than can
	// be displayed, NextToken is displayed in the response with an associated string.
	// To get the next page of results, copy this string and repeat your request,
	// including NextToken with the value of the copied string. Repeat as needed
	// to view all your results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCallAnalyticsCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCallAnalyticsCategoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCallAnalyticsCategoriesInput) SetMaxResults(v int64) *ListCallAnalyticsCategoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsCategoriesInput) SetNextToken(v string) *ListCallAnalyticsCategoriesInput {
	s.NextToken = &v
	return s
}

type ListCallAnalyticsCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about your Call Analytics categories, including
	// all the rules associated with each category.
	Categories []*CategoryProperties `type:"list"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsCategoriesOutput) GoString() string {
	return s.String()
}

// SetCategories sets the Categories field's value.
func (s *ListCallAnalyticsCategoriesOutput) SetCategories(v []*CategoryProperties) *ListCallAnalyticsCategoriesOutput {
	s.Categories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsCategoriesOutput) SetNextToken(v string) *ListCallAnalyticsCategoriesOutput {
	s.NextToken = &v
	return s
}

type ListCallAnalyticsJobsInput struct {
	_ struct{} `type:"structure"`

	// Returns only the Call Analytics jobs that contain the specified string. The
	// search is not case sensitive.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of Call Analytics jobs to return in each page of results.
	// If there are fewer results than the value that you specify, only the actual
	// results are returned. If you don't specify a value, a default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If your ListCallAnalyticsJobs request returns more results than can be displayed,
	// NextToken is displayed in the response with an associated string. To get
	// the next page of results, copy this string and repeat your request, including
	// NextToken with the value of the copied string. Repeat as needed to view all
	// your results.
	NextToken *string `type:"string"`

	// Returns only Call Analytics jobs with the specified status. Jobs are ordered
	// by creation date, with the newest job first. If you don't include Status,
	// all Call Analytics jobs are returned.
	Status *string `type:"string" enum:"CallAnalyticsJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCallAnalyticsJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCallAnalyticsJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListCallAnalyticsJobsInput) SetJobNameContains(v string) *ListCallAnalyticsJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCallAnalyticsJobsInput) SetMaxResults(v int64) *ListCallAnalyticsJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsJobsInput) SetNextToken(v string) *ListCallAnalyticsJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCallAnalyticsJobsInput) SetStatus(v string) *ListCallAnalyticsJobsInput {
	s.Status = &v
	return s
}

type ListCallAnalyticsJobsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a summary of information about each result.
	CallAnalyticsJobSummaries []*CallAnalyticsJobSummary `type:"list"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Lists all Call Analytics jobs that have the status specified in your request.
	// Jobs are ordered by creation date, with the newest job first.
	Status *string `type:"string" enum:"CallAnalyticsJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCallAnalyticsJobsOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJobSummaries sets the CallAnalyticsJobSummaries field's value.
func (s *ListCallAnalyticsJobsOutput) SetCallAnalyticsJobSummaries(v []*CallAnalyticsJobSummary) *ListCallAnalyticsJobsOutput {
	s.CallAnalyticsJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCallAnalyticsJobsOutput) SetNextToken(v string) *ListCallAnalyticsJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListCallAnalyticsJobsOutput) SetStatus(v string) *ListCallAnalyticsJobsOutput {
	s.Status = &v
	return s
}

type ListLanguageModelsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom language models to return in each page of results.
	// If there are fewer results than the value that you specify, only the actual
	// results are returned. If you don't specify a value, a default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns only the custom language models that contain the specified string.
	// The search is not case sensitive.
	NameContains *string `min:"1" type:"string"`

	// If your ListLanguageModels request returns more results than can be displayed,
	// NextToken is displayed in the response with an associated string. To get
	// the next page of results, copy this string and repeat your request, including
	// NextToken with the value of the copied string. Repeat as needed to view all
	// your results.
	NextToken *string `type:"string"`

	// Returns only custom language models with the specified status. Language models
	// are ordered by creation date, with the newest model first. If you don't include
	// StatusEquals, all custom language models are returned.
	StatusEquals *string `type:"string" enum:"ModelStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLanguageModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLanguageModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLanguageModelsInput) SetMaxResults(v int64) *ListLanguageModelsInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListLanguageModelsInput) SetNameContains(v string) *ListLanguageModelsInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsInput) SetNextToken(v string) *ListLanguageModelsInput {
	s.NextToken = &v
	return s
}

// SetStatusEquals sets the StatusEquals field's value.
func (s *ListLanguageModelsInput) SetStatusEquals(v string) *ListLanguageModelsInput {
	s.StatusEquals = &v
	return s
}

type ListLanguageModelsOutput struct {
	_ struct{} `type:"structure"`

	// Provides information about the custom language models that match the criteria
	// specified in your request.
	Models []*LanguageModel `type:"list"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLanguageModelsOutput) GoString() string {
	return s.String()
}

// SetModels sets the Models field's value.
func (s *ListLanguageModelsOutput) SetModels(v []*LanguageModel) *ListLanguageModelsOutput {
	s.Models = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLanguageModelsOutput) SetNextToken(v string) *ListLanguageModelsOutput {
	s.NextToken = &v
	return s
}

type ListMedicalTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// Returns only the medical transcription jobs that contain the specified string.
	// The search is not case sensitive.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of medical transcription jobs to return in each page of
	// results. If there are fewer results than the value that you specify, only
	// the actual results are returned. If you don't specify a value, a default
	// of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If your ListMedicalTranscriptionJobs request returns more results than can
	// be displayed, NextToken is displayed in the response with an associated string.
	// To get the next page of results, copy this string and repeat your request,
	// including NextToken with the value of the copied string. Repeat as needed
	// to view all your results.
	NextToken *string `type:"string"`

	// Returns only medical transcription jobs with the specified status. Jobs are
	// ordered by creation date, with the newest job first. If you don't include
	// Status, all medical transcription jobs are returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListMedicalTranscriptionJobsInput) SetJobNameContains(v string) *ListMedicalTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalTranscriptionJobsInput) SetMaxResults(v int64) *ListMedicalTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsInput) SetNextToken(v string) *ListMedicalTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsInput) SetStatus(v string) *ListMedicalTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListMedicalTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// Provides a summary of information about each result.
	MedicalTranscriptionJobSummaries []*MedicalTranscriptionJobSummary `type:"list"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Lists all medical transcription jobs that have the status specified in your
	// request. Jobs are ordered by creation date, with the newest job first.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJobSummaries sets the MedicalTranscriptionJobSummaries field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetMedicalTranscriptionJobSummaries(v []*MedicalTranscriptionJobSummary) *ListMedicalTranscriptionJobsOutput {
	s.MedicalTranscriptionJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetNextToken(v string) *ListMedicalTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalTranscriptionJobsOutput) SetStatus(v string) *ListMedicalTranscriptionJobsOutput {
	s.Status = &v
	return s
}

type ListMedicalVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom medical vocabularies to return in each page
	// of results. If there are fewer results than the value that you specify, only
	// the actual results are returned. If you don't specify a value, a default
	// of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns only the custom medical vocabularies that contain the specified string.
	// The search is not case sensitive.
	NameContains *string `min:"1" type:"string"`

	// If your ListMedicalVocabularies request returns more results than can be
	// displayed, NextToken is displayed in the response with an associated string.
	// To get the next page of results, copy this string and repeat your request,
	// including NextToken with the value of the copied string. Repeat as needed
	// to view all your results.
	NextToken *string `type:"string"`

	// Returns only custom medical vocabularies with the specified state. Custom
	// vocabularies are ordered by creation date, with the newest vocabulary first.
	// If you don't include StateEquals, all custom medical vocabularies are returned.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMedicalVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMedicalVocabulariesInput) SetMaxResults(v int64) *ListMedicalVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListMedicalVocabulariesInput) SetNameContains(v string) *ListMedicalVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesInput) SetNextToken(v string) *ListMedicalVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListMedicalVocabulariesInput) SetStateEquals(v string) *ListMedicalVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListMedicalVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Lists all custom medical vocabularies that have the status specified in your
	// request. Custom vocabularies are ordered by creation date, with the newest
	// vocabulary first.
	Status *string `type:"string" enum:"VocabularyState"`

	// Provides information about the custom medical vocabularies that match the
	// criteria specified in your request.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMedicalVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListMedicalVocabulariesOutput) SetNextToken(v string) *ListMedicalVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListMedicalVocabulariesOutput) SetStatus(v string) *ListMedicalVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListMedicalVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListMedicalVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// Returns a list of all tags associated with the specified Amazon Resource
	// Name (ARN). ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id.
	//
	// For example, arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name.
	//
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) specified in your request.
	ResourceArn *string `min:"1" type:"string"`

	// Lists all tags associated with the given transcription job, vocabulary, model,
	// or resource.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceOutput) SetResourceArn(v string) *ListTagsForResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// Returns only the transcription jobs that contain the specified string. The
	// search is not case sensitive.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of transcription jobs to return in each page of results.
	// If there are fewer results than the value that you specify, only the actual
	// results are returned. If you don't specify a value, a default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// If your ListTranscriptionJobs request returns more results than can be displayed,
	// NextToken is displayed in the response with an associated string. To get
	// the next page of results, copy this string and repeat your request, including
	// NextToken with the value of the copied string. Repeat as needed to view all
	// your results.
	NextToken *string `type:"string"`

	// Returns only transcription jobs with the specified status. Jobs are ordered
	// by creation date, with the newest job first. If you don't include Status,
	// all transcription jobs are returned.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTranscriptionJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobNameContains sets the JobNameContains field's value.
func (s *ListTranscriptionJobsInput) SetJobNameContains(v string) *ListTranscriptionJobsInput {
	s.JobNameContains = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTranscriptionJobsInput) SetMaxResults(v int64) *ListTranscriptionJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsInput) SetNextToken(v string) *ListTranscriptionJobsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsInput) SetStatus(v string) *ListTranscriptionJobsInput {
	s.Status = &v
	return s
}

type ListTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Lists all transcription jobs that have the status specified in your request.
	// Jobs are ordered by creation date, with the newest job first.
	Status *string `type:"string" enum:"TranscriptionJobStatus"`

	// Provides a summary of information about each result.
	TranscriptionJobSummaries []*TranscriptionJobSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTranscriptionJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTranscriptionJobsOutput) SetNextToken(v string) *ListTranscriptionJobsOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListTranscriptionJobsOutput) SetStatus(v string) *ListTranscriptionJobsOutput {
	s.Status = &v
	return s
}

// SetTranscriptionJobSummaries sets the TranscriptionJobSummaries field's value.
func (s *ListTranscriptionJobsOutput) SetTranscriptionJobSummaries(v []*TranscriptionJobSummary) *ListTranscriptionJobsOutput {
	s.TranscriptionJobSummaries = v
	return s
}

type ListVocabulariesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom vocabularies to return in each page of results.
	// If there are fewer results than the value that you specify, only the actual
	// results are returned. If you don't specify a value, a default of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns only the custom vocabularies that contain the specified string. The
	// search is not case sensitive.
	NameContains *string `min:"1" type:"string"`

	// If your ListVocabularies request returns more results than can be displayed,
	// NextToken is displayed in the response with an associated string. To get
	// the next page of results, copy this string and repeat your request, including
	// NextToken with the value of the copied string. Repeat as needed to view all
	// your results.
	NextToken *string `type:"string"`

	// Returns only custom vocabularies with the specified state. Vocabularies are
	// ordered by creation date, with the newest vocabulary first. If you don't
	// include StateEquals, all custom medical vocabularies are returned.
	StateEquals *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabulariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabulariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabulariesInput) SetMaxResults(v int64) *ListVocabulariesInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabulariesInput) SetNameContains(v string) *ListVocabulariesInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesInput) SetNextToken(v string) *ListVocabulariesInput {
	s.NextToken = &v
	return s
}

// SetStateEquals sets the StateEquals field's value.
func (s *ListVocabulariesInput) SetStateEquals(v string) *ListVocabulariesInput {
	s.StateEquals = &v
	return s
}

type ListVocabulariesOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Lists all custom vocabularies that have the status specified in your request.
	// Vocabularies are ordered by creation date, with the newest vocabulary first.
	Status *string `type:"string" enum:"VocabularyState"`

	// Provides information about the custom vocabularies that match the criteria
	// specified in your request.
	Vocabularies []*VocabularyInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabulariesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabulariesOutput) SetNextToken(v string) *ListVocabulariesOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListVocabulariesOutput) SetStatus(v string) *ListVocabulariesOutput {
	s.Status = &v
	return s
}

// SetVocabularies sets the Vocabularies field's value.
func (s *ListVocabulariesOutput) SetVocabularies(v []*VocabularyInfo) *ListVocabulariesOutput {
	s.Vocabularies = v
	return s
}

type ListVocabularyFiltersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of custom vocabulary filters to return in each page of
	// results. If there are fewer results than the value that you specify, only
	// the actual results are returned. If you don't specify a value, a default
	// of 5 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// Returns only the custom vocabulary filters that contain the specified string.
	// The search is not case sensitive.
	NameContains *string `min:"1" type:"string"`

	// If your ListVocabularyFilters request returns more results than can be displayed,
	// NextToken is displayed in the response with an associated string. To get
	// the next page of results, copy this string and repeat your request, including
	// NextToken with the value of the copied string. Repeat as needed to view all
	// your results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVocabularyFiltersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListVocabularyFiltersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NameContains != nil && len(*s.NameContains) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NameContains", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListVocabularyFiltersInput) SetMaxResults(v int64) *ListVocabularyFiltersInput {
	s.MaxResults = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListVocabularyFiltersInput) SetNameContains(v string) *ListVocabularyFiltersInput {
	s.NameContains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersInput) SetNextToken(v string) *ListVocabularyFiltersInput {
	s.NextToken = &v
	return s
}

type ListVocabularyFiltersOutput struct {
	_ struct{} `type:"structure"`

	// If NextToken is present in your response, it indicates that not all results
	// are displayed. To view the next set of results, copy the string associated
	// with the NextToken parameter in your results output, then run your request
	// again including NextToken with the value of the copied string. Repeat as
	// needed to view all your results.
	NextToken *string `type:"string"`

	// Provides information about the custom vocabulary filters that match the criteria
	// specified in your request.
	VocabularyFilters []*VocabularyFilterInfo `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListVocabularyFiltersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListVocabularyFiltersOutput) SetNextToken(v string) *ListVocabularyFiltersOutput {
	s.NextToken = &v
	return s
}

// SetVocabularyFilters sets the VocabularyFilters field's value.
func (s *ListVocabularyFiltersOutput) SetVocabularyFilters(v []*VocabularyFilterInfo) *ListVocabularyFiltersOutput {
	s.VocabularyFilters = v
	return s
}

// Describes the Amazon S3 location of the media file you want to use in your
// request.
//
// For information on supported media formats, refer to the MediaFormat (https://docs.aws.amazon.com/APIReference/API_StartTranscriptionJob.html#transcribe-StartTranscriptionJob-request-MediaFormat)
// parameter or the Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio)
// section in the Amazon S3 Developer Guide.
type Media struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of the media file you want to transcribe. For example:
	//
	//    * s3://DOC-EXAMPLE-BUCKET/my-media-file.flac
	//
	//    * s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac
	//
	// Note that the Amazon S3 bucket that contains your input media must be located
	// in the same Amazon Web Services Region where you're making your transcription
	// request.
	MediaFileUri *string `min:"1" type:"string"`

	// The Amazon S3 location of the media file you want to redact. For example:
	//
	//    * s3://DOC-EXAMPLE-BUCKET/my-media-file.flac
	//
	//    * s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac
	//
	// Note that the Amazon S3 bucket that contains your input media must be located
	// in the same Amazon Web Services Region where you're making your transcription
	// request.
	//
	// RedactedMediaFileUri produces a redacted audio file in addition to a redacted
	// transcript. It is only supported for Call Analytics (StartCallAnalyticsJob)
	// transcription requests.
	RedactedMediaFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Media) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Media) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Media) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Media"}
	if s.MediaFileUri != nil && len(*s.MediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MediaFileUri", 1))
	}
	if s.RedactedMediaFileUri != nil && len(*s.RedactedMediaFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedactedMediaFileUri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMediaFileUri sets the MediaFileUri field's value.
func (s *Media) SetMediaFileUri(v string) *Media {
	s.MediaFileUri = &v
	return s
}

// SetRedactedMediaFileUri sets the RedactedMediaFileUri field's value.
func (s *Media) SetRedactedMediaFileUri(v string) *Media {
	s.RedactedMediaFileUri = &v
	return s
}

// Provides you with the Amazon S3 URI you can use to access your transcript.
type MedicalTranscript struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of your transcript. You can use this URI to access
	// or download your transcript.
	//
	// Note that this is the Amazon S3 location you specified in your request using
	// the OutputBucketName parameter.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscript) GoString() string {
	return s.String()
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *MedicalTranscript) SetTranscriptFileUri(v string) *MedicalTranscript {
	s.TranscriptFileUri = &v
	return s
}

// Provides detailed information about a medical transcription job.
//
// To view the status of the specified medical transcription job, check the
// TranscriptionJobStatus field. If the status is COMPLETED, the job is finished
// and you can find the results at the location specified in TranscriptFileUri.
// If the status is FAILED, FailureReason provides details on why your transcription
// job failed.
type MedicalTranscriptionJob struct {
	_ struct{} `type:"structure"`

	// The date and time the specified medical transcription job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// Indicates whether content identification was enabled for your transcription
	// request.
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// The date and time the specified medical transcription job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// If TranscriptionJobStatus is FAILED, FailureReason contains information about
	// why the transcription job request failed.
	//
	// The FailureReason field contains one of the following values:
	//
	//    * Unsupported media format. The media format specified in MediaFormat
	//    isn't valid. Refer to MediaFormat for a list of supported formats.
	//
	//    * The media format provided does not match the detected media format.
	//    The media format specified in MediaFormat doesn't match the format of
	//    the input file. Check the media format of your media file and correct
	//    the specified value.
	//
	//    * Invalid sample rate for audio file. The sample rate specified in MediaSampleRateHertz
	//    isn't valid. The sample rate must be between 16,000 and 48,000 hertz.
	//
	//    * The sample rate provided does not match the detected sample rate. The
	//    sample rate specified in MediaSampleRateHertz doesn't match the sample
	//    rate detected in your input media file. Check the sample rate of your
	//    media file and correct the specified value.
	//
	//    * Invalid file size: file size too large. The size of your media file
	//    is larger than what Amazon Transcribe can process. For more information,
	//    refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	//
	//    * Invalid number of channels: number of channels too large. Your audio
	//    contains more channels than Amazon Transcribe is able to process. For
	//    more information, refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	FailureReason *string `type:"string"`

	// The language code used to create your medical transcription job. US English
	// (en-US) is the only supported language for medical transcriptions.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// Describes the Amazon S3 location of the media file you want to use in your
	// request.
	//
	// For information on supported media formats, refer to the MediaFormat (https://docs.aws.amazon.com/APIReference/API_StartTranscriptionJob.html#transcribe-StartTranscriptionJob-request-MediaFormat)
	// parameter or the Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio)
	// section in the Amazon S3 Developer Guide.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in hertz, of the audio track in your input media file.
	MediaSampleRateHertz *int64 `min:"16000" type:"integer"`

	// The name of the medical transcription job. Job names are case sensitive and
	// must be unique within an Amazon Web Services account.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Provides information on any additional settings that were included in your
	// request. Additional settings include channel identification, alternative
	// transcriptions, speaker partitioning, custom vocabularies, and custom vocabulary
	// filters.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// Describes the medical specialty represented in your media.
	Specialty *string `type:"string" enum:"Specialty"`

	// The date and time the specified medical transcription job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`

	// The tags, each in the form of a key:value pair, assigned to the specified
	// medical transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// Provides you with the Amazon S3 URI you can use to access your transcript.
	Transcript *MedicalTranscript `type:"structure"`

	// Provides the status of the specified medical transcription job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri. If the status is FAILED,
	// FailureReason provides details on why your transcription job failed.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// Indicates whether the input media is a dictation or a conversation, as specified
	// in the StartMedicalTranscriptionJob request.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJob) SetCompletionTime(v time.Time) *MedicalTranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *MedicalTranscriptionJob) SetContentIdentificationType(v string) *MedicalTranscriptionJob {
	s.ContentIdentificationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJob) SetCreationTime(v time.Time) *MedicalTranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJob) SetFailureReason(v string) *MedicalTranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJob) SetLanguageCode(v string) *MedicalTranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *MedicalTranscriptionJob) SetMedia(v *Media) *MedicalTranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *MedicalTranscriptionJob) SetMediaFormat(v string) *MedicalTranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *MedicalTranscriptionJob) SetMediaSampleRateHertz(v int64) *MedicalTranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJob) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJob {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *MedicalTranscriptionJob) SetSettings(v *MedicalTranscriptionSetting) *MedicalTranscriptionJob {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJob) SetSpecialty(v string) *MedicalTranscriptionJob {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJob) SetStartTime(v time.Time) *MedicalTranscriptionJob {
	s.StartTime = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *MedicalTranscriptionJob) SetTags(v []*Tag) *MedicalTranscriptionJob {
	s.Tags = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *MedicalTranscriptionJob) SetTranscript(v *MedicalTranscript) *MedicalTranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJob) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJob) SetType(v string) *MedicalTranscriptionJob {
	s.Type = &v
	return s
}

// Provides detailed information about a specific medical transcription job.
type MedicalTranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the specified medical transcription job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// Labels all personal health information (PHI) identified in your transcript.
	// For more information, see Identifying personal health information (PHI) in
	// a transcription (https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// The date and time the specified medical transcription job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// If TranscriptionJobStatus is FAILED, FailureReason contains information about
	// why the transcription job failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The language code used to create your medical transcription. US English (en-US)
	// is the only supported language for medical transcriptions.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The name of the medical transcription job. Job names are case sensitive and
	// must be unique within an Amazon Web Services account.
	MedicalTranscriptionJobName *string `min:"1" type:"string"`

	// Indicates where the specified medical transcription output is stored.
	//
	// If the value is CUSTOMER_BUCKET, the location is the Amazon S3 bucket you
	// specified using the OutputBucketName parameter in your request. If you also
	// included OutputKey in your request, your output is located in the path you
	// specified in your request.
	//
	// If the value is SERVICE_BUCKET, the location is a service-managed Amazon
	// S3 bucket. To access a transcript stored in a service-managed bucket, use
	// the URI shown in the TranscriptFileUri field.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// Provides the medical specialty represented in your media.
	Specialty *string `type:"string" enum:"Specialty"`

	// The date and time your medical transcription job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`

	// Provides the status of your medical transcription job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri. If the status is FAILED,
	// FailureReason provides details on why your transcription job failed.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`

	// Indicates whether the input media is a dictation or a conversation, as specified
	// in the StartMedicalTranscriptionJob request.
	Type *string `type:"string" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCompletionTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *MedicalTranscriptionJobSummary) SetContentIdentificationType(v string) *MedicalTranscriptionJobSummary {
	s.ContentIdentificationType = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *MedicalTranscriptionJobSummary) SetCreationTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *MedicalTranscriptionJobSummary) SetFailureReason(v string) *MedicalTranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *MedicalTranscriptionJobSummary) SetLanguageCode(v string) *MedicalTranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *MedicalTranscriptionJobSummary) SetMedicalTranscriptionJobName(v string) *MedicalTranscriptionJobSummary {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *MedicalTranscriptionJobSummary) SetOutputLocationType(v string) *MedicalTranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *MedicalTranscriptionJobSummary) SetSpecialty(v string) *MedicalTranscriptionJobSummary {
	s.Specialty = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *MedicalTranscriptionJobSummary) SetStartTime(v time.Time) *MedicalTranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *MedicalTranscriptionJobSummary) SetTranscriptionJobStatus(v string) *MedicalTranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

// SetType sets the Type field's value.
func (s *MedicalTranscriptionJobSummary) SetType(v string) *MedicalTranscriptionJobSummary {
	s.Type = &v
	return s
}

// Allows additional optional settings in your request, including channel identification,
// alternative transcriptions, and speaker partitioning. You can use that to
// apply custom vocabularies to your medical transcription job.
type MedicalTranscriptionSetting struct {
	_ struct{} `type:"structure"`

	// Enables channel identification in multi-channel audio.
	//
	// Channel identification transcribes the audio on each channel independently,
	// then appends the output for each channel into one transcript.
	//
	// If you have multi-channel audio and do not enable channel identification,
	// your audio is transcribed in a continuous manner and your transcript does
	// not separate the speech by channel.
	//
	// You can't include both ShowSpeakerLabels and ChannelIdentification in the
	// same request. Including both parameters returns a BadRequestException.
	//
	// For more information, see Transcribing multi-channel audio (https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
	ChannelIdentification *bool `type:"boolean"`

	// Indicate the maximum number of alternative transcriptions you want Amazon
	// Transcribe Medical to include in your transcript.
	//
	// If you select a number greater than the number of alternative transcriptions
	// generated by Amazon Transcribe Medical, only the actual number of alternative
	// transcriptions are included.
	//
	// If you include MaxAlternatives in your request, you must also include ShowAlternatives
	// with a value of true.
	//
	// For more information, see Alternative transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// Specify the maximum number of speakers you want to partition in your media.
	//
	// Note that if your media contains more speakers than the specified number,
	// multiple speakers are treated as a single speaker.
	//
	// If you specify the MaxSpeakerLabels field, you must set the ShowSpeakerLabels
	// field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// To include alternative transcriptions within your transcription output, include
	// ShowAlternatives in your transcription request.
	//
	// If you include ShowAlternatives, you must also include MaxAlternatives, which
	// is the maximum number of alternative transcriptions you want Amazon Transcribe
	// Medical to generate.
	//
	// For more information, see Alternative transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
	ShowAlternatives *bool `type:"boolean"`

	// Enables speaker partitioning (diarization) in your transcription output.
	// Speaker partitioning labels the speech from individual speakers in your media
	// file.
	//
	// If you enable ShowSpeakerLabels in your request, you must also include MaxSpeakerLabels.
	//
	// You can't include ShowSpeakerLabels and ChannelIdentification in the same
	// request. Including both parameters returns a BadRequestException.
	//
	// For more information, see Partitioning speakers (diarization) (https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
	ShowSpeakerLabels *bool `type:"boolean"`

	// The name of the custom vocabulary you want to use when processing your medical
	// transcription job. Custom vocabulary names are case sensitive.
	//
	// The language of the specified custom vocabulary must match the language code
	// that you specify in your transcription request. If the languages don't match,
	// the custom vocabulary isn't applied. There are no errors or warnings associated
	// with a language mismatch. US English (en-US) is the only valid language for
	// Amazon Transcribe Medical.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MedicalTranscriptionSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MedicalTranscriptionSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MedicalTranscriptionSetting"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *MedicalTranscriptionSetting) SetChannelIdentification(v bool) *MedicalTranscriptionSetting {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetMaxAlternatives(v int64) *MedicalTranscriptionSetting {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetMaxSpeakerLabels(v int64) *MedicalTranscriptionSetting {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *MedicalTranscriptionSetting) SetShowAlternatives(v bool) *MedicalTranscriptionSetting {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *MedicalTranscriptionSetting) SetShowSpeakerLabels(v bool) *MedicalTranscriptionSetting {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *MedicalTranscriptionSetting) SetVocabularyName(v string) *MedicalTranscriptionSetting {
	s.VocabularyName = &v
	return s
}

// Provides the name of the custom language model that was included in the specified
// transcription job.
//
// Only use ModelSettings with the LanguageModelName sub-parameter if you're
// not using automatic language identification (). If using LanguageIdSettings
// in your request, this parameter contains a LanguageModelName sub-parameter.
type ModelSettings struct {
	_ struct{} `type:"structure"`

	// The name of the custom language model you want to use when processing your
	// transcription job. Note that custom language model names are case sensitive.
	//
	// The language of the specified custom language model must match the language
	// code that you specify in your transcription request. If the languages don't
	// match, the custom language model isn't applied. There are no errors or warnings
	// associated with a language mismatch.
	LanguageModelName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModelSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModelSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModelSettings"}
	if s.LanguageModelName != nil && len(*s.LanguageModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageModelName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageModelName sets the LanguageModelName field's value.
func (s *ModelSettings) SetLanguageModelName(v string) *ModelSettings {
	s.LanguageModelName = &v
	return s
}

// Flag the presence or absence of periods of silence in your Call Analytics
// transcription output.
//
// Rules using NonTalkTimeFilter are designed to match:
//
//   - The presence of silence at specified periods throughout the call
//
//   - The presence of speech at specified periods throughout the call
//
// See Rule criteria for post-call categories (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch)
// for usage examples.
type NonTalkTimeFilter struct {
	_ struct{} `type:"structure"`

	// Makes it possible to specify a time range (in milliseconds) in your audio,
	// during which you want to search for a period of silence. See for more detail.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to flag periods of speech. Set to FALSE to flag periods of silence
	Negate *bool `type:"boolean"`

	// Makes it possible to specify a time range (in percentage) in your media file,
	// during which you want to search for a period of silence. See for more detail.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// Specify the duration, in milliseconds, of the period of silence that you
	// want to flag. For example, you can flag a silent period that lasts 30,000
	// milliseconds.
	Threshold *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NonTalkTimeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NonTalkTimeFilter) GoString() string {
	return s.String()
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *NonTalkTimeFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *NonTalkTimeFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *NonTalkTimeFilter) SetNegate(v bool) *NonTalkTimeFilter {
	s.Negate = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *NonTalkTimeFilter) SetRelativeTimeRange(v *RelativeTimeRange) *NonTalkTimeFilter {
	s.RelativeTimeRange = v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *NonTalkTimeFilter) SetThreshold(v int64) *NonTalkTimeFilter {
	s.Threshold = &v
	return s
}

// We can't find the requested resource. Check that the specified name is correct
// and try your request again.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A time range, in percentage, between two points in your media file.
//
// You can use StartPercentage and EndPercentage to search a custom segment.
// For example, setting StartPercentage to 10 and EndPercentage to 50 only searches
// for your specified criteria in the audio contained between the 10 percent
// mark and the 50 percent mark of your media file.
//
// You can use also First to search from the start of the media file until the
// time that you specify. Or use Last to search from the time that you specify
// until the end of the media file. For example, setting First to 10 only searches
// for your specified criteria in the audio contained in the first 10 percent
// of the media file.
//
// If you prefer to use milliseconds instead of percentage, see .
type RelativeTimeRange struct {
	_ struct{} `type:"structure"`

	// The time, in percentage, when Amazon Transcribe stops searching for the specified
	// criteria in your media file. If you include EndPercentage in your request,
	// you must also include StartPercentage.
	EndPercentage *int64 `type:"integer"`

	// The time, in percentage, from the start of your media file until the specified
	// value. Amazon Transcribe searches for your specified criteria in this time
	// segment.
	First *int64 `type:"integer"`

	// The time, in percentage, from the specified value until the end of your media
	// file. Amazon Transcribe searches for your specified criteria in this time
	// segment.
	Last *int64 `type:"integer"`

	// The time, in percentage, when Amazon Transcribe starts searching for the
	// specified criteria in your media file. If you include StartPercentage in
	// your request, you must also include EndPercentage.
	StartPercentage *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelativeTimeRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelativeTimeRange) GoString() string {
	return s.String()
}

// SetEndPercentage sets the EndPercentage field's value.
func (s *RelativeTimeRange) SetEndPercentage(v int64) *RelativeTimeRange {
	s.EndPercentage = &v
	return s
}

// SetFirst sets the First field's value.
func (s *RelativeTimeRange) SetFirst(v int64) *RelativeTimeRange {
	s.First = &v
	return s
}

// SetLast sets the Last field's value.
func (s *RelativeTimeRange) SetLast(v int64) *RelativeTimeRange {
	s.Last = &v
	return s
}

// SetStartPercentage sets the StartPercentage field's value.
func (s *RelativeTimeRange) SetStartPercentage(v int64) *RelativeTimeRange {
	s.StartPercentage = &v
	return s
}

// A rule is a set of criteria that you can specify to flag an attribute in
// your Call Analytics output. Rules define a Call Analytics category.
//
// Rules can include these parameters: , , , and .
//
// To learn more about Call Analytics rules and categories, see Creating categories
// for post-call transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html)
// and Creating categories for real-time transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html).
//
// To learn more about Call Analytics, see Analyzing call center audio with
// Call Analytics (https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html).
type Rule struct {
	_ struct{} `type:"structure"`

	// Flag the presence or absence of interruptions in your Call Analytics transcription
	// output. Refer to for more detail.
	InterruptionFilter *InterruptionFilter `type:"structure"`

	// Flag the presence or absence of periods of silence in your Call Analytics
	// transcription output. Refer to for more detail.
	NonTalkTimeFilter *NonTalkTimeFilter `type:"structure"`

	// Flag the presence or absence of specific sentiments in your Call Analytics
	// transcription output. Refer to for more detail.
	SentimentFilter *SentimentFilter `type:"structure"`

	// Flag the presence or absence of specific words or phrases in your Call Analytics
	// transcription output. Refer to for more detail.
	TranscriptFilter *TranscriptFilter `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Rule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Rule"}
	if s.SentimentFilter != nil {
		if err := s.SentimentFilter.Validate(); err != nil {
			invalidParams.AddNested("SentimentFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TranscriptFilter != nil {
		if err := s.TranscriptFilter.Validate(); err != nil {
			invalidParams.AddNested("TranscriptFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInterruptionFilter sets the InterruptionFilter field's value.
func (s *Rule) SetInterruptionFilter(v *InterruptionFilter) *Rule {
	s.InterruptionFilter = v
	return s
}

// SetNonTalkTimeFilter sets the NonTalkTimeFilter field's value.
func (s *Rule) SetNonTalkTimeFilter(v *NonTalkTimeFilter) *Rule {
	s.NonTalkTimeFilter = v
	return s
}

// SetSentimentFilter sets the SentimentFilter field's value.
func (s *Rule) SetSentimentFilter(v *SentimentFilter) *Rule {
	s.SentimentFilter = v
	return s
}

// SetTranscriptFilter sets the TranscriptFilter field's value.
func (s *Rule) SetTranscriptFilter(v *TranscriptFilter) *Rule {
	s.TranscriptFilter = v
	return s
}

// Flag the presence or absence of specific sentiments detected in your Call
// Analytics transcription output.
//
// Rules using SentimentFilter are designed to match:
//
//   - The presence or absence of a positive sentiment felt by the customer,
//     agent, or both at specified points in the call
//
//   - The presence or absence of a negative sentiment felt by the customer,
//     agent, or both at specified points in the call
//
//   - The presence or absence of a neutral sentiment felt by the customer,
//     agent, or both at specified points in the call
//
//   - The presence or absence of a mixed sentiment felt by the customer, the
//     agent, or both at specified points in the call
//
// See Rule criteria for post-call categories (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch)
// for usage examples.
type SentimentFilter struct {
	_ struct{} `type:"structure"`

	// Makes it possible to specify a time range (in milliseconds) in your audio,
	// during which you want to search for the specified sentiments. See for more
	// detail.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to flag the sentiments that you didn't include in your request.
	// Set to FALSE to flag the sentiments that you specified in your request.
	Negate *bool `type:"boolean"`

	// Specify the participant that you want to flag. Omitting this parameter is
	// equivalent to specifying both participants.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// Makes it possible to specify a time range (in percentage) in your media file,
	// during which you want to search for the specified sentiments. See for more
	// detail.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// Specify the sentiments that you want to flag.
	//
	// Sentiments is a required field
	Sentiments []*string `min:"1" type:"list" required:"true" enum:"SentimentValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SentimentFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SentimentFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SentimentFilter"}
	if s.Sentiments == nil {
		invalidParams.Add(request.NewErrParamRequired("Sentiments"))
	}
	if s.Sentiments != nil && len(s.Sentiments) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sentiments", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *SentimentFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *SentimentFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *SentimentFilter) SetNegate(v bool) *SentimentFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *SentimentFilter) SetParticipantRole(v string) *SentimentFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *SentimentFilter) SetRelativeTimeRange(v *RelativeTimeRange) *SentimentFilter {
	s.RelativeTimeRange = v
	return s
}

// SetSentiments sets the Sentiments field's value.
func (s *SentimentFilter) SetSentiments(v []*string) *SentimentFilter {
	s.Sentiments = v
	return s
}

// Allows additional optional settings in your request, including channel identification,
// alternative transcriptions, and speaker partitioning. You can use that to
// apply custom vocabularies to your transcription job.
type Settings struct {
	_ struct{} `type:"structure"`

	// Enables channel identification in multi-channel audio.
	//
	// Channel identification transcribes the audio on each channel independently,
	// then appends the output for each channel into one transcript.
	//
	// You can't include both ShowSpeakerLabels and ChannelIdentification in the
	// same request. Including both parameters returns a BadRequestException.
	//
	// For more information, see Transcribing multi-channel audio (https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html).
	ChannelIdentification *bool `type:"boolean"`

	// Indicate the maximum number of alternative transcriptions you want Amazon
	// Transcribe to include in your transcript.
	//
	// If you select a number greater than the number of alternative transcriptions
	// generated by Amazon Transcribe, only the actual number of alternative transcriptions
	// are included.
	//
	// If you include MaxAlternatives in your request, you must also include ShowAlternatives
	// with a value of true.
	//
	// For more information, see Alternative transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
	MaxAlternatives *int64 `min:"2" type:"integer"`

	// Specify the maximum number of speakers you want to partition in your media.
	//
	// Note that if your media contains more speakers than the specified number,
	// multiple speakers are treated as a single speaker.
	//
	// If you specify the MaxSpeakerLabels field, you must set the ShowSpeakerLabels
	// field to true.
	MaxSpeakerLabels *int64 `min:"2" type:"integer"`

	// To include alternative transcriptions within your transcription output, include
	// ShowAlternatives in your transcription request.
	//
	// If you have multi-channel audio and do not enable channel identification,
	// your audio is transcribed in a continuous manner and your transcript does
	// not separate the speech by channel.
	//
	// If you include ShowAlternatives, you must also include MaxAlternatives, which
	// is the maximum number of alternative transcriptions you want Amazon Transcribe
	// to generate.
	//
	// For more information, see Alternative transcriptions (https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html).
	ShowAlternatives *bool `type:"boolean"`

	// Enables speaker partitioning (diarization) in your transcription output.
	// Speaker partitioning labels the speech from individual speakers in your media
	// file.
	//
	// If you enable ShowSpeakerLabels in your request, you must also include MaxSpeakerLabels.
	//
	// You can't include both ShowSpeakerLabels and ChannelIdentification in the
	// same request. Including both parameters returns a BadRequestException.
	//
	// For more information, see Partitioning speakers (diarization) (https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html).
	ShowSpeakerLabels *bool `type:"boolean"`

	// Specify how you want your custom vocabulary filter applied to your transcript.
	//
	// To replace words with ***, choose mask.
	//
	// To delete words, choose remove.
	//
	// To flag words without changing them, choose tag.
	VocabularyFilterMethod *string `type:"string" enum:"VocabularyFilterMethod"`

	// The name of the custom vocabulary filter you want to use in your transcription
	// job request. This name is case sensitive, cannot contain spaces, and must
	// be unique within an Amazon Web Services account.
	//
	// Note that if you include VocabularyFilterName in your request, you must also
	// include VocabularyFilterMethod.
	VocabularyFilterName *string `min:"1" type:"string"`

	// The name of the custom vocabulary you want to use in your transcription job
	// request. This name is case sensitive, cannot contain spaces, and must be
	// unique within an Amazon Web Services account.
	VocabularyName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Settings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Settings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Settings"}
	if s.MaxAlternatives != nil && *s.MaxAlternatives < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxAlternatives", 2))
	}
	if s.MaxSpeakerLabels != nil && *s.MaxSpeakerLabels < 2 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSpeakerLabels", 2))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannelIdentification sets the ChannelIdentification field's value.
func (s *Settings) SetChannelIdentification(v bool) *Settings {
	s.ChannelIdentification = &v
	return s
}

// SetMaxAlternatives sets the MaxAlternatives field's value.
func (s *Settings) SetMaxAlternatives(v int64) *Settings {
	s.MaxAlternatives = &v
	return s
}

// SetMaxSpeakerLabels sets the MaxSpeakerLabels field's value.
func (s *Settings) SetMaxSpeakerLabels(v int64) *Settings {
	s.MaxSpeakerLabels = &v
	return s
}

// SetShowAlternatives sets the ShowAlternatives field's value.
func (s *Settings) SetShowAlternatives(v bool) *Settings {
	s.ShowAlternatives = &v
	return s
}

// SetShowSpeakerLabels sets the ShowSpeakerLabels field's value.
func (s *Settings) SetShowSpeakerLabels(v bool) *Settings {
	s.ShowSpeakerLabels = &v
	return s
}

// SetVocabularyFilterMethod sets the VocabularyFilterMethod field's value.
func (s *Settings) SetVocabularyFilterMethod(v string) *Settings {
	s.VocabularyFilterMethod = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *Settings) SetVocabularyFilterName(v string) *Settings {
	s.VocabularyFilterName = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *Settings) SetVocabularyName(v string) *Settings {
	s.VocabularyName = &v
	return s
}

type StartCallAnalyticsJobInput struct {
	_ struct{} `type:"structure"`

	// A unique name, chosen by you, for your Call Analytics job.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new job with the same
	// name as an existing job, you get a ConflictException error.
	//
	// CallAnalyticsJobName is a required field
	CallAnalyticsJobName *string `min:"1" type:"string" required:"true"`

	// Makes it possible to specify which speaker is on which channel. For example,
	// if your agent is the first participant to speak, you would set ChannelId
	// to 0 (to indicate the first channel) and ParticipantRole to AGENT (to indicate
	// that it's the agent speaking).
	ChannelDefinitions []*ChannelDefinition `min:"2" type:"list"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files. If the role that you
	// specify doesn’t have the appropriate permissions to access the specified
	// Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// Describes the Amazon S3 location of the media file you want to use in your
	// Call Analytics request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// The KMS key you want to use to encrypt your Call Analytics output.
	//
	// If using a key located in the current Amazon Web Services account, you can
	// specify your KMS key in one of four ways:
	//
	// Use the KMS key ID itself. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use an alias for the KMS key ID. For example, alias/ExampleAlias.
	//
	// Use the Amazon Resource Name (ARN) for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If using a key located in a different Amazon Web Services account than the
	// current Amazon Web Services account, you can specify your KMS key in one
	// of two ways:
	//
	// Use the ARN for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If you don't specify an encryption key, your output is encrypted with the
	// default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location using the OutputLocation parameter.
	//
	// Note that the role making the request must have permission to use the specified
	// KMS key.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// The Amazon S3 location where you want your Call Analytics transcription output
	// stored. You can use any of the following formats to specify the output location:
	//
	// s3://DOC-EXAMPLE-BUCKET
	//
	// s3://DOC-EXAMPLE-BUCKET/my-output-folder/
	//
	// s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json
	//
	// Unless you specify a file name (option 3), the name of your output file has
	// a default value that matches the name you specified for your transcription
	// job using the CallAnalyticsJobName parameter.
	//
	// You can specify a KMS key to encrypt your output using the OutputEncryptionKMSKeyId
	// parameter. If you don't specify a KMS key, Amazon Transcribe uses the default
	// Amazon S3 key for server-side encryption.
	//
	// If you don't specify OutputLocation, your transcript is placed in a service-managed
	// Amazon S3 bucket and you are provided with a URI to access your transcript.
	OutputLocation *string `min:"1" type:"string"`

	// Specify additional optional settings in your request, including content redaction;
	// allows you to apply custom language models, vocabulary filters, and custom
	// vocabularies to your Call Analytics job.
	Settings *CallAnalyticsJobSettings `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCallAnalyticsJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCallAnalyticsJobInput"}
	if s.CallAnalyticsJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("CallAnalyticsJobName"))
	}
	if s.CallAnalyticsJobName != nil && len(*s.CallAnalyticsJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CallAnalyticsJobName", 1))
	}
	if s.ChannelDefinitions != nil && len(s.ChannelDefinitions) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("ChannelDefinitions", 2))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputLocation != nil && len(*s.OutputLocation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputLocation", 1))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCallAnalyticsJobName sets the CallAnalyticsJobName field's value.
func (s *StartCallAnalyticsJobInput) SetCallAnalyticsJobName(v string) *StartCallAnalyticsJobInput {
	s.CallAnalyticsJobName = &v
	return s
}

// SetChannelDefinitions sets the ChannelDefinitions field's value.
func (s *StartCallAnalyticsJobInput) SetChannelDefinitions(v []*ChannelDefinition) *StartCallAnalyticsJobInput {
	s.ChannelDefinitions = v
	return s
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *StartCallAnalyticsJobInput) SetDataAccessRoleArn(v string) *StartCallAnalyticsJobInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartCallAnalyticsJobInput) SetMedia(v *Media) *StartCallAnalyticsJobInput {
	s.Media = v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartCallAnalyticsJobInput) SetOutputEncryptionKMSKeyId(v string) *StartCallAnalyticsJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *StartCallAnalyticsJobInput) SetOutputLocation(v string) *StartCallAnalyticsJobInput {
	s.OutputLocation = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartCallAnalyticsJobInput) SetSettings(v *CallAnalyticsJobSettings) *StartCallAnalyticsJobInput {
	s.Settings = v
	return s
}

type StartCallAnalyticsJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the current Call Analytics job, including
	// job status and, if applicable, failure reason.
	CallAnalyticsJob *CallAnalyticsJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCallAnalyticsJobOutput) GoString() string {
	return s.String()
}

// SetCallAnalyticsJob sets the CallAnalyticsJob field's value.
func (s *StartCallAnalyticsJobOutput) SetCallAnalyticsJob(v *CallAnalyticsJob) *StartCallAnalyticsJobOutput {
	s.CallAnalyticsJob = v
	return s
}

type StartMedicalTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// Labels all personal health information (PHI) identified in your transcript.
	// For more information, see Identifying personal health information (PHI) in
	// a transcription (https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html).
	ContentIdentificationType *string `type:"string" enum:"MedicalContentIdentificationType"`

	// A map of plain text, non-secret key:value pairs, known as encryption context
	// pairs, that provide an added layer of security for your data. For more information,
	// see KMS encryption context (https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context)
	// and Asymmetric keys in KMS (https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
	KMSEncryptionContext map[string]*string `min:"1" type:"map"`

	// The language code that represents the language spoken in the input media
	// file. US English (en-US) is the only valid value for medical transcription
	// jobs. Any other value you enter for language code results in a BadRequestException
	// error.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Describes the Amazon S3 location of the media file you want to use in your
	// request.
	//
	// For information on supported media formats, refer to the MediaFormat (https://docs.aws.amazon.com/APIReference/API_StartTranscriptionJob.html#transcribe-StartTranscriptionJob-request-MediaFormat)
	// parameter or the Media formats (https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio)
	// section in the Amazon S3 Developer Guide.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// Specify the format of your input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in hertz, of the audio track in your input media file.
	//
	// If you don't specify the media sample rate, Amazon Transcribe Medical determines
	// it for you. If you specify the sample rate, it must match the rate detected
	// by Amazon Transcribe Medical; if there's a mismatch between the value that
	// you specify and the value detected, your job fails. Therefore, in most cases,
	// it's advised to omit MediaSampleRateHertz and let Amazon Transcribe Medical
	// determine the sample rate.
	MediaSampleRateHertz *int64 `min:"16000" type:"integer"`

	// A unique name, chosen by you, for your medical transcription job. The name
	// that you specify is also used as the default name of your transcription output
	// file. If you want to specify a different name for your transcription output,
	// use the OutputKey parameter.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new job with the same
	// name as an existing job, you get a ConflictException error.
	//
	// MedicalTranscriptionJobName is a required field
	MedicalTranscriptionJobName *string `min:"1" type:"string" required:"true"`

	// The name of the Amazon S3 bucket where you want your medical transcription
	// output stored. Do not include the S3:// prefix of the specified bucket.
	//
	// If you want your output to go to a sub-folder of this bucket, specify it
	// using the OutputKey parameter; OutputBucketName only accepts the name of
	// a bucket.
	//
	// For example, if you want your output stored in S3://DOC-EXAMPLE-BUCKET, set
	// OutputBucketName to DOC-EXAMPLE-BUCKET. However, if you want your output
	// stored in S3://DOC-EXAMPLE-BUCKET/test-files/, set OutputBucketName to DOC-EXAMPLE-BUCKET
	// and OutputKey to test-files/.
	//
	// Note that Amazon Transcribe must have permission to use the specified location.
	// You can change Amazon S3 permissions using the Amazon Web Services Management
	// Console (https://console.aws.amazon.com/s3). See also Permissions Required
	// for IAM User Roles (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// OutputBucketName is a required field
	OutputBucketName *string `type:"string" required:"true"`

	// The KMS key you want to use to encrypt your medical transcription output.
	//
	// If using a key located in the current Amazon Web Services account, you can
	// specify your KMS key in one of four ways:
	//
	// Use the KMS key ID itself. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use an alias for the KMS key ID. For example, alias/ExampleAlias.
	//
	// Use the Amazon Resource Name (ARN) for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If using a key located in a different Amazon Web Services account than the
	// current Amazon Web Services account, you can specify your KMS key in one
	// of two ways:
	//
	// Use the ARN for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If you don't specify an encryption key, your output is encrypted with the
	// default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location using the OutputLocation parameter.
	//
	// Note that the role making the request must have permission to use the specified
	// KMS key.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// Use in combination with OutputBucketName to specify the output location of
	// your transcript and, optionally, a unique name for your output file. The
	// default name for your transcription output is the same as the name you specified
	// for your medical transcription job (MedicalTranscriptionJobName).
	//
	// Here are some examples of how you can use OutputKey:
	//
	//    * If you specify 'DOC-EXAMPLE-BUCKET' as the OutputBucketName and 'my-transcript.json'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/my-transcript.json.
	//
	//    * If you specify 'my-first-transcription' as the MedicalTranscriptionJobName,
	//    'DOC-EXAMPLE-BUCKET' as the OutputBucketName, and 'my-transcript' as the
	//    OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json.
	//
	//    * If you specify 'DOC-EXAMPLE-BUCKET' as the OutputBucketName and 'test-files/my-transcript.json'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json.
	//
	//    * If you specify 'my-first-transcription' as the MedicalTranscriptionJobName,
	//    'DOC-EXAMPLE-BUCKET' as the OutputBucketName, and 'test-files/my-transcript'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json.
	//
	// If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist,
	// one is created for you.
	OutputKey *string `min:"1" type:"string"`

	// Specify additional optional settings in your request, including channel identification,
	// alternative transcriptions, and speaker partitioning. You can use that to
	// apply custom vocabularies to your transcription job.
	Settings *MedicalTranscriptionSetting `type:"structure"`

	// Specify the predominant medical specialty represented in your media. For
	// batch transcriptions, PRIMARYCARE is the only valid value. If you require
	// additional specialties, refer to .
	//
	// Specialty is a required field
	Specialty *string `type:"string" required:"true" enum:"Specialty"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new medical transcription job at the time you start this new job.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// Specify whether your input media contains only one person (DICTATION) or
	// contains a conversation between two people (CONVERSATION).
	//
	// For example, DICTATION could be used for a medical professional wanting to
	// transcribe voice memos; CONVERSATION could be used for transcribing the doctor-patient
	// dialogue during the patient's office visit.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"Type"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMedicalTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMedicalTranscriptionJobInput"}
	if s.KMSEncryptionContext != nil && len(s.KMSEncryptionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSEncryptionContext", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 16000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 16000))
	}
	if s.MedicalTranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("MedicalTranscriptionJobName"))
	}
	if s.MedicalTranscriptionJobName != nil && len(*s.MedicalTranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MedicalTranscriptionJobName", 1))
	}
	if s.OutputBucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputBucketName"))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.Specialty == nil {
		invalidParams.Add(request.NewErrParamRequired("Specialty"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentIdentificationType sets the ContentIdentificationType field's value.
func (s *StartMedicalTranscriptionJobInput) SetContentIdentificationType(v string) *StartMedicalTranscriptionJobInput {
	s.ContentIdentificationType = &v
	return s
}

// SetKMSEncryptionContext sets the KMSEncryptionContext field's value.
func (s *StartMedicalTranscriptionJobInput) SetKMSEncryptionContext(v map[string]*string) *StartMedicalTranscriptionJobInput {
	s.KMSEncryptionContext = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartMedicalTranscriptionJobInput) SetLanguageCode(v string) *StartMedicalTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedia(v *Media) *StartMedicalTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaFormat(v string) *StartMedicalTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartMedicalTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartMedicalTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetMedicalTranscriptionJobName sets the MedicalTranscriptionJobName field's value.
func (s *StartMedicalTranscriptionJobInput) SetMedicalTranscriptionJobName(v string) *StartMedicalTranscriptionJobInput {
	s.MedicalTranscriptionJobName = &v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputBucketName(v string) *StartMedicalTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartMedicalTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartMedicalTranscriptionJobInput) SetOutputKey(v string) *StartMedicalTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartMedicalTranscriptionJobInput) SetSettings(v *MedicalTranscriptionSetting) *StartMedicalTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetSpecialty sets the Specialty field's value.
func (s *StartMedicalTranscriptionJobInput) SetSpecialty(v string) *StartMedicalTranscriptionJobInput {
	s.Specialty = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartMedicalTranscriptionJobInput) SetTags(v []*Tag) *StartMedicalTranscriptionJobInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *StartMedicalTranscriptionJobInput) SetType(v string) *StartMedicalTranscriptionJobInput {
	s.Type = &v
	return s
}

type StartMedicalTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the current medical transcription job,
	// including job status and, if applicable, failure reason.
	MedicalTranscriptionJob *MedicalTranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartMedicalTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetMedicalTranscriptionJob sets the MedicalTranscriptionJob field's value.
func (s *StartMedicalTranscriptionJobOutput) SetMedicalTranscriptionJob(v *MedicalTranscriptionJob) *StartMedicalTranscriptionJobOutput {
	s.MedicalTranscriptionJob = v
	return s
}

type StartTranscriptionJobInput struct {
	_ struct{} `type:"structure"`

	// Makes it possible to redact or flag specified personally identifiable information
	// (PII) in your transcript. If you use ContentRedaction, you must also include
	// the sub-parameters: PiiEntityTypes, RedactionOutput, and RedactionType.
	ContentRedaction *ContentRedaction `type:"structure"`

	// Enables automatic language identification in your transcription job request.
	// Use this parameter if your media file contains only one language. If your
	// media contains multiple languages, use IdentifyMultipleLanguages instead.
	//
	// If you include IdentifyLanguage, you can optionally include a list of language
	// codes, using LanguageOptions, that you think may be present in your media
	// file. Including LanguageOptions restricts IdentifyLanguage to only the language
	// options that you specify, which can improve transcription accuracy.
	//
	// If you want to apply a custom language model, a custom vocabulary, or a custom
	// vocabulary filter to your automatic language identification request, include
	// LanguageIdSettings with the relevant sub-parameters (VocabularyName, LanguageModelName,
	// and VocabularyFilterName). If you include LanguageIdSettings, also include
	// LanguageOptions.
	//
	// Note that you must include one of LanguageCode, IdentifyLanguage, or IdentifyMultipleLanguages
	// in your request. If you include more than one of these parameters, your transcription
	// job fails.
	IdentifyLanguage *bool `type:"boolean"`

	// Enables automatic multi-language identification in your transcription job
	// request. Use this parameter if your media file contains more than one language.
	// If your media contains only one language, use IdentifyLanguage instead.
	//
	// If you include IdentifyMultipleLanguages, you can optionally include a list
	// of language codes, using LanguageOptions, that you think may be present in
	// your media file. Including LanguageOptions restricts IdentifyLanguage to
	// only the language options that you specify, which can improve transcription
	// accuracy.
	//
	// If you want to apply a custom vocabulary or a custom vocabulary filter to
	// your automatic language identification request, include LanguageIdSettings
	// with the relevant sub-parameters (VocabularyName and VocabularyFilterName).
	// If you include LanguageIdSettings, also include LanguageOptions.
	//
	// Note that you must include one of LanguageCode, IdentifyLanguage, or IdentifyMultipleLanguages
	// in your request. If you include more than one of these parameters, your transcription
	// job fails.
	IdentifyMultipleLanguages *bool `type:"boolean"`

	// Makes it possible to control how your transcription job is processed. Currently,
	// the only JobExecutionSettings modification you can choose is enabling job
	// queueing using the AllowDeferredExecution sub-parameter.
	//
	// If you include JobExecutionSettings in your request, you must also include
	// the sub-parameters: AllowDeferredExecution and DataAccessRoleArn.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// A map of plain text, non-secret key:value pairs, known as encryption context
	// pairs, that provide an added layer of security for your data. For more information,
	// see KMS encryption context (https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context)
	// and Asymmetric keys in KMS (https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html).
	KMSEncryptionContext map[string]*string `min:"1" type:"map"`

	// The language code that represents the language spoken in the input media
	// file.
	//
	// If you're unsure of the language spoken in your media file, consider using
	// IdentifyLanguage or IdentifyMultipleLanguages to enable automatic language
	// identification.
	//
	// Note that you must include one of LanguageCode, IdentifyLanguage, or IdentifyMultipleLanguages
	// in your request. If you include more than one of these parameters, your transcription
	// job fails.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// To transcribe speech in Modern Standard Arabic (ar-SA), your media file must
	// be encoded at a sample rate of 16,000 Hz or higher.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// If using automatic language identification in your request and you want to
	// apply a custom language model, a custom vocabulary, or a custom vocabulary
	// filter, include LanguageIdSettings with the relevant sub-parameters (VocabularyName,
	// LanguageModelName, and VocabularyFilterName). Note that multi-language identification
	// (IdentifyMultipleLanguages) doesn't support custom language models.
	//
	// LanguageIdSettings supports two to five language codes. Each language code
	// you include can have an associated custom language model, custom vocabulary,
	// and custom vocabulary filter. The language codes that you specify must match
	// the languages of the associated custom language models, custom vocabularies,
	// and custom vocabulary filters.
	//
	// It's recommended that you include LanguageOptions when using LanguageIdSettings
	// to ensure that the correct language dialect is identified. For example, if
	// you specify a custom vocabulary that is in en-US but Amazon Transcribe determines
	// that the language spoken in your media is en-AU, your custom vocabulary is
	// not applied to your transcription. If you include LanguageOptions and include
	// en-US as the only English language dialect, your custom vocabulary is applied
	// to your transcription.
	//
	// If you want to include a custom language model with your request but do not
	// want to use automatic language identification, use instead the parameter
	// with the LanguageModelName sub-parameter. If you want to include a custom
	// vocabulary or a custom vocabulary filter (or both) with your request but
	// do not want to use automatic language identification, use instead the parameter
	// with the VocabularyName or VocabularyFilterName (or both) sub-parameter.
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// You can specify two or more language codes that represent the languages you
	// think may be present in your media. Including more than five is not recommended.
	// If you're unsure what languages are present, do not include this parameter.
	//
	// If you include LanguageOptions in your request, you must also include IdentifyLanguage.
	//
	// For more information, refer to Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html).
	//
	// To transcribe speech in Modern Standard Arabic (ar-SA), your media file must
	// be encoded at a sample rate of 16,000 Hz or higher.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// Describes the Amazon S3 location of the media file you want to use in your
	// request.
	//
	// Media is a required field
	Media *Media `type:"structure" required:"true"`

	// Specify the format of your input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in hertz, of the audio track in your input media file.
	//
	// If you don't specify the media sample rate, Amazon Transcribe determines
	// it for you. If you specify the sample rate, it must match the rate detected
	// by Amazon Transcribe. If there's a mismatch between the value that you specify
	// and the value detected, your job fails. In most cases, you can omit MediaSampleRateHertz
	// and let Amazon Transcribe determine the sample rate.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Specify the custom language model you want to include with your transcription
	// job. If you include ModelSettings in your request, you must include the LanguageModelName
	// sub-parameter.
	//
	// For more information, see Custom language models (https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html).
	ModelSettings *ModelSettings `type:"structure"`

	// The name of the Amazon S3 bucket where you want your transcription output
	// stored. Do not include the S3:// prefix of the specified bucket.
	//
	// If you want your output to go to a sub-folder of this bucket, specify it
	// using the OutputKey parameter; OutputBucketName only accepts the name of
	// a bucket.
	//
	// For example, if you want your output stored in S3://DOC-EXAMPLE-BUCKET, set
	// OutputBucketName to DOC-EXAMPLE-BUCKET. However, if you want your output
	// stored in S3://DOC-EXAMPLE-BUCKET/test-files/, set OutputBucketName to DOC-EXAMPLE-BUCKET
	// and OutputKey to test-files/.
	//
	// Note that Amazon Transcribe must have permission to use the specified location.
	// You can change Amazon S3 permissions using the Amazon Web Services Management
	// Console (https://console.aws.amazon.com/s3). See also Permissions Required
	// for IAM User Roles (https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user).
	//
	// If you don't specify OutputBucketName, your transcript is placed in a service-managed
	// Amazon S3 bucket and you are provided with a URI to access your transcript.
	OutputBucketName *string `type:"string"`

	// The KMS key you want to use to encrypt your transcription output.
	//
	// If using a key located in the current Amazon Web Services account, you can
	// specify your KMS key in one of four ways:
	//
	// Use the KMS key ID itself. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use an alias for the KMS key ID. For example, alias/ExampleAlias.
	//
	// Use the Amazon Resource Name (ARN) for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If using a key located in a different Amazon Web Services account than the
	// current Amazon Web Services account, you can specify your KMS key in one
	// of two ways:
	//
	// Use the ARN for the KMS key ID. For example, arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	// Use the ARN for the KMS key alias. For example, arn:aws:kms:region:account-ID:alias/ExampleAlias.
	//
	// If you don't specify an encryption key, your output is encrypted with the
	// default Amazon S3 key (SSE-S3).
	//
	// If you specify a KMS key to encrypt your output, you must also specify an
	// output location using the OutputLocation parameter.
	//
	// Note that the role making the request must have permission to use the specified
	// KMS key.
	OutputEncryptionKMSKeyId *string `min:"1" type:"string"`

	// Use in combination with OutputBucketName to specify the output location of
	// your transcript and, optionally, a unique name for your output file. The
	// default name for your transcription output is the same as the name you specified
	// for your transcription job (TranscriptionJobName).
	//
	// Here are some examples of how you can use OutputKey:
	//
	//    * If you specify 'DOC-EXAMPLE-BUCKET' as the OutputBucketName and 'my-transcript.json'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/my-transcript.json.
	//
	//    * If you specify 'my-first-transcription' as the TranscriptionJobName,
	//    'DOC-EXAMPLE-BUCKET' as the OutputBucketName, and 'my-transcript' as the
	//    OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json.
	//
	//    * If you specify 'DOC-EXAMPLE-BUCKET' as the OutputBucketName and 'test-files/my-transcript.json'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json.
	//
	//    * If you specify 'my-first-transcription' as the TranscriptionJobName,
	//    'DOC-EXAMPLE-BUCKET' as the OutputBucketName, and 'test-files/my-transcript'
	//    as the OutputKey, your transcription output path is s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json.
	//
	// If you specify the name of an Amazon S3 bucket sub-folder that doesn't exist,
	// one is created for you.
	OutputKey *string `min:"1" type:"string"`

	// Specify additional optional settings in your request, including channel identification,
	// alternative transcriptions, speaker partitioning. You can use that to apply
	// custom vocabularies and vocabulary filters.
	//
	// If you want to include a custom vocabulary or a custom vocabulary filter
	// (or both) with your request but do not want to use automatic language identification,
	// use Settings with the VocabularyName or VocabularyFilterName (or both) sub-parameter.
	//
	// If you're using automatic language identification with your request and want
	// to include a custom language model, a custom vocabulary, or a custom vocabulary
	// filter, use instead the parameter with the LanguageModelName, VocabularyName
	// or VocabularyFilterName sub-parameters.
	Settings *Settings `type:"structure"`

	// Produces subtitle files for your input media. You can specify WebVTT (*.vtt)
	// and SubRip (*.srt) formats.
	Subtitles *Subtitles `type:"structure"`

	// Adds one or more custom tags, each in the form of a key:value pair, to a
	// new transcription job at the time you start this new job.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	Tags []*Tag `min:"1" type:"list"`

	// Enables toxic speech detection in your transcript. If you include ToxicityDetection
	// in your request, you must also include ToxicityCategories.
	//
	// For information on the types of toxic speech Amazon Transcribe can detect,
	// see Detecting toxic speech (https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html).
	ToxicityDetection []*ToxicityDetectionSettings `min:"1" type:"list"`

	// A unique name, chosen by you, for your transcription job. The name that you
	// specify is also used as the default name of your transcription output file.
	// If you want to specify a different name for your transcription output, use
	// the OutputKey parameter.
	//
	// This name is case sensitive, cannot contain spaces, and must be unique within
	// an Amazon Web Services account. If you try to create a new job with the same
	// name as an existing job, you get a ConflictException error.
	//
	// TranscriptionJobName is a required field
	TranscriptionJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartTranscriptionJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartTranscriptionJobInput"}
	if s.KMSEncryptionContext != nil && len(s.KMSEncryptionContext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSEncryptionContext", 1))
	}
	if s.LanguageIdSettings != nil && len(s.LanguageIdSettings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageIdSettings", 1))
	}
	if s.LanguageOptions != nil && len(s.LanguageOptions) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageOptions", 1))
	}
	if s.Media == nil {
		invalidParams.Add(request.NewErrParamRequired("Media"))
	}
	if s.MediaSampleRateHertz != nil && *s.MediaSampleRateHertz < 8000 {
		invalidParams.Add(request.NewErrParamMinValue("MediaSampleRateHertz", 8000))
	}
	if s.OutputEncryptionKMSKeyId != nil && len(*s.OutputEncryptionKMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputEncryptionKMSKeyId", 1))
	}
	if s.OutputKey != nil && len(*s.OutputKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutputKey", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ToxicityDetection != nil && len(s.ToxicityDetection) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ToxicityDetection", 1))
	}
	if s.TranscriptionJobName == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptionJobName"))
	}
	if s.TranscriptionJobName != nil && len(*s.TranscriptionJobName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TranscriptionJobName", 1))
	}
	if s.ContentRedaction != nil {
		if err := s.ContentRedaction.Validate(); err != nil {
			invalidParams.AddNested("ContentRedaction", err.(request.ErrInvalidParams))
		}
	}
	if s.JobExecutionSettings != nil {
		if err := s.JobExecutionSettings.Validate(); err != nil {
			invalidParams.AddNested("JobExecutionSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.LanguageIdSettings != nil {
		for i, v := range s.LanguageIdSettings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "LanguageIdSettings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Media != nil {
		if err := s.Media.Validate(); err != nil {
			invalidParams.AddNested("Media", err.(request.ErrInvalidParams))
		}
	}
	if s.ModelSettings != nil {
		if err := s.ModelSettings.Validate(); err != nil {
			invalidParams.AddNested("ModelSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.Settings != nil {
		if err := s.Settings.Validate(); err != nil {
			invalidParams.AddNested("Settings", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ToxicityDetection != nil {
		for i, v := range s.ToxicityDetection {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ToxicityDetection", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *StartTranscriptionJobInput) SetContentRedaction(v *ContentRedaction) *StartTranscriptionJobInput {
	s.ContentRedaction = v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *StartTranscriptionJobInput) SetIdentifyLanguage(v bool) *StartTranscriptionJobInput {
	s.IdentifyLanguage = &v
	return s
}

// SetIdentifyMultipleLanguages sets the IdentifyMultipleLanguages field's value.
func (s *StartTranscriptionJobInput) SetIdentifyMultipleLanguages(v bool) *StartTranscriptionJobInput {
	s.IdentifyMultipleLanguages = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *StartTranscriptionJobInput) SetJobExecutionSettings(v *JobExecutionSettings) *StartTranscriptionJobInput {
	s.JobExecutionSettings = v
	return s
}

// SetKMSEncryptionContext sets the KMSEncryptionContext field's value.
func (s *StartTranscriptionJobInput) SetKMSEncryptionContext(v map[string]*string) *StartTranscriptionJobInput {
	s.KMSEncryptionContext = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *StartTranscriptionJobInput) SetLanguageCode(v string) *StartTranscriptionJobInput {
	s.LanguageCode = &v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *StartTranscriptionJobInput) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *StartTranscriptionJobInput {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *StartTranscriptionJobInput) SetLanguageOptions(v []*string) *StartTranscriptionJobInput {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *StartTranscriptionJobInput) SetMedia(v *Media) *StartTranscriptionJobInput {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *StartTranscriptionJobInput) SetMediaFormat(v string) *StartTranscriptionJobInput {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *StartTranscriptionJobInput) SetMediaSampleRateHertz(v int64) *StartTranscriptionJobInput {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *StartTranscriptionJobInput) SetModelSettings(v *ModelSettings) *StartTranscriptionJobInput {
	s.ModelSettings = v
	return s
}

// SetOutputBucketName sets the OutputBucketName field's value.
func (s *StartTranscriptionJobInput) SetOutputBucketName(v string) *StartTranscriptionJobInput {
	s.OutputBucketName = &v
	return s
}

// SetOutputEncryptionKMSKeyId sets the OutputEncryptionKMSKeyId field's value.
func (s *StartTranscriptionJobInput) SetOutputEncryptionKMSKeyId(v string) *StartTranscriptionJobInput {
	s.OutputEncryptionKMSKeyId = &v
	return s
}

// SetOutputKey sets the OutputKey field's value.
func (s *StartTranscriptionJobInput) SetOutputKey(v string) *StartTranscriptionJobInput {
	s.OutputKey = &v
	return s
}

// SetSettings sets the Settings field's value.
func (s *StartTranscriptionJobInput) SetSettings(v *Settings) *StartTranscriptionJobInput {
	s.Settings = v
	return s
}

// SetSubtitles sets the Subtitles field's value.
func (s *StartTranscriptionJobInput) SetSubtitles(v *Subtitles) *StartTranscriptionJobInput {
	s.Subtitles = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartTranscriptionJobInput) SetTags(v []*Tag) *StartTranscriptionJobInput {
	s.Tags = v
	return s
}

// SetToxicityDetection sets the ToxicityDetection field's value.
func (s *StartTranscriptionJobInput) SetToxicityDetection(v []*ToxicityDetectionSettings) *StartTranscriptionJobInput {
	s.ToxicityDetection = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *StartTranscriptionJobInput) SetTranscriptionJobName(v string) *StartTranscriptionJobInput {
	s.TranscriptionJobName = &v
	return s
}

type StartTranscriptionJobOutput struct {
	_ struct{} `type:"structure"`

	// Provides detailed information about the current transcription job, including
	// job status and, if applicable, failure reason.
	TranscriptionJob *TranscriptionJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartTranscriptionJobOutput) GoString() string {
	return s.String()
}

// SetTranscriptionJob sets the TranscriptionJob field's value.
func (s *StartTranscriptionJobOutput) SetTranscriptionJob(v *TranscriptionJob) *StartTranscriptionJobOutput {
	s.TranscriptionJob = v
	return s
}

// Generate subtitles for your media file with your transcription request.
//
// You can choose a start index of 0 or 1, and you can specify either WebVTT
// or SubRip (or both) as your output format.
//
// Note that your subtitle files are placed in the same location as your transcription
// output.
type Subtitles struct {
	_ struct{} `type:"structure"`

	// Specify the output format for your subtitle file; if you select both WebVTT
	// (vtt) and SubRip (srt) formats, two output files are generated.
	Formats []*string `type:"list" enum:"SubtitleFormat"`

	// Specify the starting value that is assigned to the first subtitle segment.
	//
	// The default start index for Amazon Transcribe is 0, which differs from the
	// more widely used standard of 1. If you're uncertain which value to use, we
	// recommend choosing 1, as this may improve compatibility with other services.
	OutputStartIndex *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subtitles) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Subtitles) GoString() string {
	return s.String()
}

// SetFormats sets the Formats field's value.
func (s *Subtitles) SetFormats(v []*string) *Subtitles {
	s.Formats = v
	return s
}

// SetOutputStartIndex sets the OutputStartIndex field's value.
func (s *Subtitles) SetOutputStartIndex(v int64) *Subtitles {
	s.OutputStartIndex = &v
	return s
}

// Provides information about your subtitle file, including format, start index,
// and Amazon S3 location.
type SubtitlesOutput_ struct {
	_ struct{} `type:"structure"`

	// Provides the format of your subtitle files. If your request included both
	// WebVTT (vtt) and SubRip (srt) formats, both formats are shown.
	Formats []*string `type:"list" enum:"SubtitleFormat"`

	// Provides the start index value for your subtitle files. If you did not specify
	// a value in your request, the default value of 0 is used.
	OutputStartIndex *int64 `type:"integer"`

	// The Amazon S3 location of your transcript. You can use this URI to access
	// or download your subtitle file. Your subtitle file is stored in the same
	// location as your transcript. If you specified both WebVTT and SubRip subtitle
	// formats, two URIs are provided.
	//
	// If you included OutputBucketName in your transcription job request, this
	// is the URI of that bucket. If you also included OutputKey in your request,
	// your output is located in the path you specified in your request.
	//
	// If you didn't include OutputBucketName in your transcription job request,
	// your subtitle file is stored in a service-managed bucket, and TranscriptFileUri
	// provides you with a temporary URI you can use for secure access to your subtitle
	// file.
	//
	// Temporary URIs for service-managed Amazon S3 buckets are only valid for 15
	// minutes. If you get an AccesDenied error, you can get a new temporary URI
	// by running a GetTranscriptionJob or ListTranscriptionJob request.
	SubtitleFileUris []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubtitlesOutput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SubtitlesOutput_) GoString() string {
	return s.String()
}

// SetFormats sets the Formats field's value.
func (s *SubtitlesOutput_) SetFormats(v []*string) *SubtitlesOutput_ {
	s.Formats = v
	return s
}

// SetOutputStartIndex sets the OutputStartIndex field's value.
func (s *SubtitlesOutput_) SetOutputStartIndex(v int64) *SubtitlesOutput_ {
	s.OutputStartIndex = &v
	return s
}

// SetSubtitleFileUris sets the SubtitleFileUris field's value.
func (s *SubtitlesOutput_) SetSubtitleFileUris(v []*string) *SubtitlesOutput_ {
	s.SubtitleFileUris = v
	return s
}

// Adds metadata, in the form of a key:value pair, to the specified resource.
//
// For example, you could add the tag Department:Sales to a resource to indicate
// that it pertains to your organization's sales department. You can also use
// tags for tag-based access control.
//
// To learn more about tagging, see Tagging resources (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
type Tag struct {
	_ struct{} `type:"structure"`

	// The first part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag Department:Sales, the key is 'Department'.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The second part of a key:value pair that forms a tag associated with a given
	// resource. For example, in the tag Department:Sales, the value is 'Sales'.
	//
	// Note that you can set the value of a tag to an empty string, but you can't
	// set the value of a tag to null. Omitting the tag value is the same as using
	// an empty string.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource you want to tag. ARNs have
	// the format arn:partition:service:region:account-id:resource-type/resource-id.
	//
	// For example, arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name.
	//
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Adds one or more custom tags, each in the form of a key:value pair, to the
	// specified resource.
	//
	// To learn more about using tags with Amazon Transcribe, refer to Tagging resources
	// (https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html).
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains ToxicityCategories, which is a required parameter if you want to
// enable toxicity detection (ToxicityDetection) in your transcription request.
type ToxicityDetectionSettings struct {
	_ struct{} `type:"structure"`

	// If you include ToxicityDetection in your transcription request, you must
	// also include ToxicityCategories. The only accepted value for this parameter
	// is ALL.
	//
	// ToxicityCategories is a required field
	ToxicityCategories []*string `min:"1" type:"list" required:"true" enum:"ToxicityCategory"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ToxicityDetectionSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ToxicityDetectionSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ToxicityDetectionSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ToxicityDetectionSettings"}
	if s.ToxicityCategories == nil {
		invalidParams.Add(request.NewErrParamRequired("ToxicityCategories"))
	}
	if s.ToxicityCategories != nil && len(s.ToxicityCategories) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ToxicityCategories", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetToxicityCategories sets the ToxicityCategories field's value.
func (s *ToxicityDetectionSettings) SetToxicityCategories(v []*string) *ToxicityDetectionSettings {
	s.ToxicityCategories = v
	return s
}

// Provides you with the Amazon S3 URI you can use to access your transcript.
type Transcript struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location of your redacted transcript. You can use this URI
	// to access or download your transcript.
	//
	// If you included OutputBucketName in your transcription job request, this
	// is the URI of that bucket. If you also included OutputKey in your request,
	// your output is located in the path you specified in your request.
	//
	// If you didn't include OutputBucketName in your transcription job request,
	// your transcript is stored in a service-managed bucket, and RedactedTranscriptFileUri
	// provides you with a temporary URI you can use for secure access to your transcript.
	//
	// Temporary URIs for service-managed Amazon S3 buckets are only valid for 15
	// minutes. If you get an AccesDenied error, you can get a new temporary URI
	// by running a GetTranscriptionJob or ListTranscriptionJob request.
	RedactedTranscriptFileUri *string `min:"1" type:"string"`

	// The Amazon S3 location of your transcript. You can use this URI to access
	// or download your transcript.
	//
	// If you included OutputBucketName in your transcription job request, this
	// is the URI of that bucket. If you also included OutputKey in your request,
	// your output is located in the path you specified in your request.
	//
	// If you didn't include OutputBucketName in your transcription job request,
	// your transcript is stored in a service-managed bucket, and TranscriptFileUri
	// provides you with a temporary URI you can use for secure access to your transcript.
	//
	// Temporary URIs for service-managed Amazon S3 buckets are only valid for 15
	// minutes. If you get an AccesDenied error, you can get a new temporary URI
	// by running a GetTranscriptionJob or ListTranscriptionJob request.
	TranscriptFileUri *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transcript) GoString() string {
	return s.String()
}

// SetRedactedTranscriptFileUri sets the RedactedTranscriptFileUri field's value.
func (s *Transcript) SetRedactedTranscriptFileUri(v string) *Transcript {
	s.RedactedTranscriptFileUri = &v
	return s
}

// SetTranscriptFileUri sets the TranscriptFileUri field's value.
func (s *Transcript) SetTranscriptFileUri(v string) *Transcript {
	s.TranscriptFileUri = &v
	return s
}

// Flag the presence or absence of specific words or phrases detected in your
// Call Analytics transcription output.
//
// Rules using TranscriptFilter are designed to match:
//
//   - Custom words or phrases spoken by the agent, the customer, or both
//
//   - Custom words or phrases not spoken by the agent, the customer, or either
//
//   - Custom words or phrases that occur at a specific time frame
//
// See Rule criteria for post-call categories (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch)
// and Rule criteria for streaming categories (https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html#tca-rules-stream)
// for usage examples.
type TranscriptFilter struct {
	_ struct{} `type:"structure"`

	// Makes it possible to specify a time range (in milliseconds) in your audio,
	// during which you want to search for the specified key words or phrases. See
	// for more detail.
	AbsoluteTimeRange *AbsoluteTimeRange `type:"structure"`

	// Set to TRUE to flag the absence of the phrase that you specified in your
	// request. Set to FALSE to flag the presence of the phrase that you specified
	// in your request.
	Negate *bool `type:"boolean"`

	// Specify the participant that you want to flag. Omitting this parameter is
	// equivalent to specifying both participants.
	ParticipantRole *string `type:"string" enum:"ParticipantRole"`

	// Makes it possible to specify a time range (in percentage) in your media file,
	// during which you want to search for the specified key words or phrases. See
	// for more detail.
	RelativeTimeRange *RelativeTimeRange `type:"structure"`

	// Specify the phrases that you want to flag.
	//
	// Targets is a required field
	Targets []*string `min:"1" type:"list" required:"true"`

	// Flag the presence or absence of an exact match to the phrases that you specify.
	// For example, if you specify the phrase "speak to a manager" as your Targets
	// value, only that exact phrase is flagged.
	//
	// Note that semantic matching is not supported. For example, if your customer
	// says "speak to the manager", instead of "speak to a manager", your content
	// is not flagged.
	//
	// TranscriptFilterType is a required field
	TranscriptFilterType *string `type:"string" required:"true" enum:"TranscriptFilterType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TranscriptFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TranscriptFilter"}
	if s.Targets == nil {
		invalidParams.Add(request.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil && len(s.Targets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Targets", 1))
	}
	if s.TranscriptFilterType == nil {
		invalidParams.Add(request.NewErrParamRequired("TranscriptFilterType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAbsoluteTimeRange sets the AbsoluteTimeRange field's value.
func (s *TranscriptFilter) SetAbsoluteTimeRange(v *AbsoluteTimeRange) *TranscriptFilter {
	s.AbsoluteTimeRange = v
	return s
}

// SetNegate sets the Negate field's value.
func (s *TranscriptFilter) SetNegate(v bool) *TranscriptFilter {
	s.Negate = &v
	return s
}

// SetParticipantRole sets the ParticipantRole field's value.
func (s *TranscriptFilter) SetParticipantRole(v string) *TranscriptFilter {
	s.ParticipantRole = &v
	return s
}

// SetRelativeTimeRange sets the RelativeTimeRange field's value.
func (s *TranscriptFilter) SetRelativeTimeRange(v *RelativeTimeRange) *TranscriptFilter {
	s.RelativeTimeRange = v
	return s
}

// SetTargets sets the Targets field's value.
func (s *TranscriptFilter) SetTargets(v []*string) *TranscriptFilter {
	s.Targets = v
	return s
}

// SetTranscriptFilterType sets the TranscriptFilterType field's value.
func (s *TranscriptFilter) SetTranscriptFilterType(v string) *TranscriptFilter {
	s.TranscriptFilterType = &v
	return s
}

// Provides detailed information about a transcription job.
//
// To view the status of the specified transcription job, check the TranscriptionJobStatus
// field. If the status is COMPLETED, the job is finished and you can find the
// results at the location specified in TranscriptFileUri. If the status is
// FAILED, FailureReason provides details on why your transcription job failed.
//
// If you enabled content redaction, the redacted transcript can be found at
// the location specified in RedactedTranscriptFileUri.
type TranscriptionJob struct {
	_ struct{} `type:"structure"`

	// The date and time the specified transcription job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// Indicates whether redaction was enabled in your transcript.
	ContentRedaction *ContentRedaction `type:"structure"`

	// The date and time the specified transcription job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// If TranscriptionJobStatus is FAILED, FailureReason contains information about
	// why the transcription job request failed.
	//
	// The FailureReason field contains one of the following values:
	//
	//    * Unsupported media format. The media format specified in MediaFormat
	//    isn't valid. Refer to MediaFormat for a list of supported formats.
	//
	//    * The media format provided does not match the detected media format.
	//    The media format specified in MediaFormat doesn't match the format of
	//    the input file. Check the media format of your media file and correct
	//    the specified value.
	//
	//    * Invalid sample rate for audio file. The sample rate specified in MediaSampleRateHertz
	//    isn't valid. The sample rate must be between 8,000 and 48,000 hertz.
	//
	//    * The sample rate provided does not match the detected sample rate. The
	//    sample rate specified in MediaSampleRateHertz doesn't match the sample
	//    rate detected in your input media file. Check the sample rate of your
	//    media file and correct the specified value.
	//
	//    * Invalid file size: file size too large. The size of your media file
	//    is larger than what Amazon Transcribe can process. For more information,
	//    refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	//
	//    * Invalid number of channels: number of channels too large. Your audio
	//    contains more channels than Amazon Transcribe is able to process. For
	//    more information, refer to Guidelines and quotas (https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits).
	FailureReason *string `type:"string"`

	// The confidence score associated with the language identified in your media
	// file.
	//
	// Confidence scores are values between 0 and 1; a larger value indicates a
	// higher probability that the identified language correctly matches the language
	// spoken in your media.
	IdentifiedLanguageScore *float64 `type:"float"`

	// Indicates whether automatic language identification was enabled (TRUE) for
	// the specified transcription job.
	IdentifyLanguage *bool `type:"boolean"`

	// Indicates whether automatic multi-language identification was enabled (TRUE)
	// for the specified transcription job.
	IdentifyMultipleLanguages *bool `type:"boolean"`

	// Provides information about how your transcription job was processed. This
	// parameter shows if your request was queued and what data access role was
	// used.
	JobExecutionSettings *JobExecutionSettings `type:"structure"`

	// The language code used to create your transcription job. This parameter is
	// used with single-language identification. For multi-language identification
	// requests, refer to the plural version of this parameter, LanguageCodes.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The language codes used to create your transcription job. This parameter
	// is used with multi-language identification. For single-language identification
	// requests, refer to the singular version of this parameter, LanguageCode.
	LanguageCodes []*LanguageCodeItem `type:"list"`

	// Provides the name and language of all custom language models, custom vocabularies,
	// and custom vocabulary filters that you included in your request.
	LanguageIdSettings map[string]*LanguageIdSettings `min:"1" type:"map"`

	// Provides the language codes you specified in your request.
	LanguageOptions []*string `min:"1" type:"list" enum:"LanguageCode"`

	// Provides the Amazon S3 location of the media file you used in your request.
	Media *Media `type:"structure"`

	// The format of the input media file.
	MediaFormat *string `type:"string" enum:"MediaFormat"`

	// The sample rate, in hertz, of the audio track in your input media file.
	MediaSampleRateHertz *int64 `min:"8000" type:"integer"`

	// Provides information on the custom language model you included in your request.
	ModelSettings *ModelSettings `type:"structure"`

	// Provides information on any additional settings that were included in your
	// request. Additional settings include channel identification, alternative
	// transcriptions, speaker partitioning, custom vocabularies, and custom vocabulary
	// filters.
	Settings *Settings `type:"structure"`

	// The date and time the specified transcription job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`

	// Indicates whether subtitles were generated with your transcription.
	Subtitles *SubtitlesOutput_ `type:"structure"`

	// The tags, each in the form of a key:value pair, assigned to the specified
	// transcription job.
	Tags []*Tag `min:"1" type:"list"`

	// Provides information about the toxicity detection settings applied to your
	// transcription.
	ToxicityDetection []*ToxicityDetectionSettings `min:"1" type:"list"`

	// Provides you with the Amazon S3 URI you can use to access your transcript.
	Transcript *Transcript `type:"structure"`

	// The name of the transcription job. Job names are case sensitive and must
	// be unique within an Amazon Web Services account.
	TranscriptionJobName *string `min:"1" type:"string"`

	// Provides the status of the specified transcription job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri (or RedactedTranscriptFileUri,
	// if you requested transcript redaction). If the status is FAILED, FailureReason
	// provides details on why your transcription job failed.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJob) SetCompletionTime(v time.Time) *TranscriptionJob {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJob) SetContentRedaction(v *ContentRedaction) *TranscriptionJob {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJob) SetCreationTime(v time.Time) *TranscriptionJob {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJob) SetFailureReason(v string) *TranscriptionJob {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJob) SetIdentifiedLanguageScore(v float64) *TranscriptionJob {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJob) SetIdentifyLanguage(v bool) *TranscriptionJob {
	s.IdentifyLanguage = &v
	return s
}

// SetIdentifyMultipleLanguages sets the IdentifyMultipleLanguages field's value.
func (s *TranscriptionJob) SetIdentifyMultipleLanguages(v bool) *TranscriptionJob {
	s.IdentifyMultipleLanguages = &v
	return s
}

// SetJobExecutionSettings sets the JobExecutionSettings field's value.
func (s *TranscriptionJob) SetJobExecutionSettings(v *JobExecutionSettings) *TranscriptionJob {
	s.JobExecutionSettings = v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJob) SetLanguageCode(v string) *TranscriptionJob {
	s.LanguageCode = &v
	return s
}

// SetLanguageCodes sets the LanguageCodes field's value.
func (s *TranscriptionJob) SetLanguageCodes(v []*LanguageCodeItem) *TranscriptionJob {
	s.LanguageCodes = v
	return s
}

// SetLanguageIdSettings sets the LanguageIdSettings field's value.
func (s *TranscriptionJob) SetLanguageIdSettings(v map[string]*LanguageIdSettings) *TranscriptionJob {
	s.LanguageIdSettings = v
	return s
}

// SetLanguageOptions sets the LanguageOptions field's value.
func (s *TranscriptionJob) SetLanguageOptions(v []*string) *TranscriptionJob {
	s.LanguageOptions = v
	return s
}

// SetMedia sets the Media field's value.
func (s *TranscriptionJob) SetMedia(v *Media) *TranscriptionJob {
	s.Media = v
	return s
}

// SetMediaFormat sets the MediaFormat field's value.
func (s *TranscriptionJob) SetMediaFormat(v string) *TranscriptionJob {
	s.MediaFormat = &v
	return s
}

// SetMediaSampleRateHertz sets the MediaSampleRateHertz field's value.
func (s *TranscriptionJob) SetMediaSampleRateHertz(v int64) *TranscriptionJob {
	s.MediaSampleRateHertz = &v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJob) SetModelSettings(v *ModelSettings) *TranscriptionJob {
	s.ModelSettings = v
	return s
}

// SetSettings sets the Settings field's value.
func (s *TranscriptionJob) SetSettings(v *Settings) *TranscriptionJob {
	s.Settings = v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJob) SetStartTime(v time.Time) *TranscriptionJob {
	s.StartTime = &v
	return s
}

// SetSubtitles sets the Subtitles field's value.
func (s *TranscriptionJob) SetSubtitles(v *SubtitlesOutput_) *TranscriptionJob {
	s.Subtitles = v
	return s
}

// SetTags sets the Tags field's value.
func (s *TranscriptionJob) SetTags(v []*Tag) *TranscriptionJob {
	s.Tags = v
	return s
}

// SetToxicityDetection sets the ToxicityDetection field's value.
func (s *TranscriptionJob) SetToxicityDetection(v []*ToxicityDetectionSettings) *TranscriptionJob {
	s.ToxicityDetection = v
	return s
}

// SetTranscript sets the Transcript field's value.
func (s *TranscriptionJob) SetTranscript(v *Transcript) *TranscriptionJob {
	s.Transcript = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJob) SetTranscriptionJobName(v string) *TranscriptionJob {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJob) SetTranscriptionJobStatus(v string) *TranscriptionJob {
	s.TranscriptionJobStatus = &v
	return s
}

// Provides detailed information about a specific transcription job.
type TranscriptionJobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the specified transcription job finished processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:33:13.922000-07:00 represents a transcription job that started
	// processing at 12:33 PM UTC-7 on May 4, 2022.
	CompletionTime *time.Time `type:"timestamp"`

	// The content redaction settings of the transcription job.
	ContentRedaction *ContentRedaction `type:"structure"`

	// The date and time the specified transcription job request was made.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	CreationTime *time.Time `type:"timestamp"`

	// If TranscriptionJobStatus is FAILED, FailureReason contains information about
	// why the transcription job failed. See also: Common Errors (https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html).
	FailureReason *string `type:"string"`

	// The confidence score associated with the language identified in your media
	// file.
	//
	// Confidence scores are values between 0 and 1; a larger value indicates a
	// higher probability that the identified language correctly matches the language
	// spoken in your media.
	IdentifiedLanguageScore *float64 `type:"float"`

	// Indicates whether automatic language identification was enabled (TRUE) for
	// the specified transcription job.
	IdentifyLanguage *bool `type:"boolean"`

	// Indicates whether automatic multi-language identification was enabled (TRUE)
	// for the specified transcription job.
	IdentifyMultipleLanguages *bool `type:"boolean"`

	// The language code used to create your transcription.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The language codes used to create your transcription job. This parameter
	// is used with multi-language identification. For single-language identification,
	// the singular version of this parameter, LanguageCode, is present.
	LanguageCodes []*LanguageCodeItem `type:"list"`

	// Provides the name of the custom language model that was included in the specified
	// transcription job.
	//
	// Only use ModelSettings with the LanguageModelName sub-parameter if you're
	// not using automatic language identification (). If using LanguageIdSettings
	// in your request, this parameter contains a LanguageModelName sub-parameter.
	ModelSettings *ModelSettings `type:"structure"`

	// Indicates where the specified transcription output is stored.
	//
	// If the value is CUSTOMER_BUCKET, the location is the Amazon S3 bucket you
	// specified using the OutputBucketName parameter in your request. If you also
	// included OutputKey in your request, your output is located in the path you
	// specified in your request.
	//
	// If the value is SERVICE_BUCKET, the location is a service-managed Amazon
	// S3 bucket. To access a transcript stored in a service-managed bucket, use
	// the URI shown in the TranscriptFileUri or RedactedTranscriptFileUri field.
	OutputLocationType *string `type:"string" enum:"OutputLocationType"`

	// The date and time your transcription job began processing.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.789000-07:00 represents a transcription job that started
	// processing at 12:32 PM UTC-7 on May 4, 2022.
	StartTime *time.Time `type:"timestamp"`

	// Indicates whether toxicity detection was enabled for the specified transcription
	// job.
	ToxicityDetection []*ToxicityDetectionSettings `min:"1" type:"list"`

	// The name of the transcription job. Job names are case sensitive and must
	// be unique within an Amazon Web Services account.
	TranscriptionJobName *string `min:"1" type:"string"`

	// Provides the status of your transcription job.
	//
	// If the status is COMPLETED, the job is finished and you can find the results
	// at the location specified in TranscriptFileUri (or RedactedTranscriptFileUri,
	// if you requested transcript redaction). If the status is FAILED, FailureReason
	// provides details on why your transcription job failed.
	TranscriptionJobStatus *string `type:"string" enum:"TranscriptionJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TranscriptionJobSummary) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *TranscriptionJobSummary) SetCompletionTime(v time.Time) *TranscriptionJobSummary {
	s.CompletionTime = &v
	return s
}

// SetContentRedaction sets the ContentRedaction field's value.
func (s *TranscriptionJobSummary) SetContentRedaction(v *ContentRedaction) *TranscriptionJobSummary {
	s.ContentRedaction = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *TranscriptionJobSummary) SetCreationTime(v time.Time) *TranscriptionJobSummary {
	s.CreationTime = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *TranscriptionJobSummary) SetFailureReason(v string) *TranscriptionJobSummary {
	s.FailureReason = &v
	return s
}

// SetIdentifiedLanguageScore sets the IdentifiedLanguageScore field's value.
func (s *TranscriptionJobSummary) SetIdentifiedLanguageScore(v float64) *TranscriptionJobSummary {
	s.IdentifiedLanguageScore = &v
	return s
}

// SetIdentifyLanguage sets the IdentifyLanguage field's value.
func (s *TranscriptionJobSummary) SetIdentifyLanguage(v bool) *TranscriptionJobSummary {
	s.IdentifyLanguage = &v
	return s
}

// SetIdentifyMultipleLanguages sets the IdentifyMultipleLanguages field's value.
func (s *TranscriptionJobSummary) SetIdentifyMultipleLanguages(v bool) *TranscriptionJobSummary {
	s.IdentifyMultipleLanguages = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *TranscriptionJobSummary) SetLanguageCode(v string) *TranscriptionJobSummary {
	s.LanguageCode = &v
	return s
}

// SetLanguageCodes sets the LanguageCodes field's value.
func (s *TranscriptionJobSummary) SetLanguageCodes(v []*LanguageCodeItem) *TranscriptionJobSummary {
	s.LanguageCodes = v
	return s
}

// SetModelSettings sets the ModelSettings field's value.
func (s *TranscriptionJobSummary) SetModelSettings(v *ModelSettings) *TranscriptionJobSummary {
	s.ModelSettings = v
	return s
}

// SetOutputLocationType sets the OutputLocationType field's value.
func (s *TranscriptionJobSummary) SetOutputLocationType(v string) *TranscriptionJobSummary {
	s.OutputLocationType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TranscriptionJobSummary) SetStartTime(v time.Time) *TranscriptionJobSummary {
	s.StartTime = &v
	return s
}

// SetToxicityDetection sets the ToxicityDetection field's value.
func (s *TranscriptionJobSummary) SetToxicityDetection(v []*ToxicityDetectionSettings) *TranscriptionJobSummary {
	s.ToxicityDetection = v
	return s
}

// SetTranscriptionJobName sets the TranscriptionJobName field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobName(v string) *TranscriptionJobSummary {
	s.TranscriptionJobName = &v
	return s
}

// SetTranscriptionJobStatus sets the TranscriptionJobStatus field's value.
func (s *TranscriptionJobSummary) SetTranscriptionJobStatus(v string) *TranscriptionJobSummary {
	s.TranscriptionJobStatus = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want
	// to remove tags from. ARNs have the format arn:partition:service:region:account-id:resource-type/resource-id.
	//
	// For example, arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name.
	//
	// Valid values for resource-type are: transcription-job, medical-transcription-job,
	// vocabulary, medical-vocabulary, vocabulary-filter, and language-model.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// Removes the specified tag keys from the specified Amazon Transcribe resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCallAnalyticsCategoryInput struct {
	_ struct{} `type:"structure"`

	// The name of the Call Analytics category you want to update. Category names
	// are case sensitive.
	//
	// CategoryName is a required field
	CategoryName *string `min:"1" type:"string" required:"true"`

	// Choose whether you want to update a real-time or a post-call category. The
	// input type you specify must match the input type specified when the category
	// was created. For example, if you created a category with the POST_CALL input
	// type, you must use POST_CALL as the input type when updating this category.
	InputType *string `type:"string" enum:"InputType"`

	// The rules used for the updated Call Analytics category. The rules you provide
	// in this field replace the ones that are currently being used in the specified
	// category.
	//
	// Rules is a required field
	Rules []*Rule `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCallAnalyticsCategoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCallAnalyticsCategoryInput"}
	if s.CategoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("CategoryName"))
	}
	if s.CategoryName != nil && len(*s.CategoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CategoryName", 1))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil && len(s.Rules) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Rules", 1))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCategoryName sets the CategoryName field's value.
func (s *UpdateCallAnalyticsCategoryInput) SetCategoryName(v string) *UpdateCallAnalyticsCategoryInput {
	s.CategoryName = &v
	return s
}

// SetInputType sets the InputType field's value.
func (s *UpdateCallAnalyticsCategoryInput) SetInputType(v string) *UpdateCallAnalyticsCategoryInput {
	s.InputType = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UpdateCallAnalyticsCategoryInput) SetRules(v []*Rule) *UpdateCallAnalyticsCategoryInput {
	s.Rules = v
	return s
}

type UpdateCallAnalyticsCategoryOutput struct {
	_ struct{} `type:"structure"`

	// Provides you with the properties of the Call Analytics category you specified
	// in your UpdateCallAnalyticsCategory request.
	CategoryProperties *CategoryProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCallAnalyticsCategoryOutput) GoString() string {
	return s.String()
}

// SetCategoryProperties sets the CategoryProperties field's value.
func (s *UpdateCallAnalyticsCategoryOutput) SetCategoryProperties(v *CategoryProperties) *UpdateCallAnalyticsCategoryOutput {
	s.CategoryProperties = v
	return s
}

type UpdateMedicalVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The language code that represents the language of the entries in the custom
	// vocabulary you want to update. US English (en-US) is the only language supported
	// with Amazon Transcribe Medical.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// The Amazon S3 location of the text file that contains your custom medical
	// vocabulary. The URI must be located in the same Amazon Web Services Region
	// as the resource you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt
	//
	// VocabularyFileUri is a required field
	VocabularyFileUri *string `min:"1" type:"string" required:"true"`

	// The name of the custom medical vocabulary you want to update. Custom medical
	// vocabulary names are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMedicalVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMedicalVocabularyInput"}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFileUri"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyInput) SetLanguageCode(v string) *UpdateMedicalVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyFileUri(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyInput) SetVocabularyName(v string) *UpdateMedicalVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateMedicalVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code you selected for your custom medical vocabulary. US English
	// (en-US) is the only language supported with Amazon Transcribe Medical.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom medical vocabulary was last updated.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated custom medical vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom medical vocabulary. If the state is READY,
	// you can use the custom vocabulary in a StartMedicalTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMedicalVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateMedicalVocabularyOutput) SetLanguageCode(v string) *UpdateMedicalVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateMedicalVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateMedicalVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyName(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateMedicalVocabularyOutput) SetVocabularyState(v string) *UpdateMedicalVocabularyOutput {
	s.VocabularyState = &v
	return s
}

type UpdateVocabularyFilterInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files (in this case, your custom
	// vocabulary filter). If the role that you specify doesn’t have the appropriate
	// permissions to access the specified Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The Amazon S3 location of the text file that contains your custom vocabulary
	// filter terms. The URI must be located in the same Amazon Web Services Region
	// as the resource you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt
	//
	// Note that if you include VocabularyFilterFileUri in your request, you cannot
	// use Words; you must choose one or the other.
	VocabularyFilterFileUri *string `min:"1" type:"string"`

	// The name of the custom vocabulary filter you want to update. Custom vocabulary
	// filter names are case sensitive.
	//
	// VocabularyFilterName is a required field
	VocabularyFilterName *string `min:"1" type:"string" required:"true"`

	// Use this parameter if you want to update your custom vocabulary filter by
	// including all desired terms, as comma-separated values, within your request.
	// The other option for updating your vocabulary filter is to save your entries
	// in a text file and upload them to an Amazon S3 bucket, then specify the location
	// of your file using the VocabularyFilterFileUri parameter.
	//
	// Note that if you include Words in your request, you cannot use VocabularyFilterFileUri;
	// you must choose one or the other.
	//
	// Each language has a character set that contains all allowed characters for
	// that specific language. If you use unsupported characters, your custom vocabulary
	// filter request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
	// to get the character set for your language.
	Words []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyFilterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyFilterInput"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.VocabularyFilterFileUri != nil && len(*s.VocabularyFilterFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterFileUri", 1))
	}
	if s.VocabularyFilterName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyFilterName"))
	}
	if s.VocabularyFilterName != nil && len(*s.VocabularyFilterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFilterName", 1))
	}
	if s.Words != nil && len(s.Words) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Words", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *UpdateVocabularyFilterInput) SetDataAccessRoleArn(v string) *UpdateVocabularyFilterInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetVocabularyFilterFileUri sets the VocabularyFilterFileUri field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterFileUri(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterFileUri = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterInput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterInput {
	s.VocabularyFilterName = &v
	return s
}

// SetWords sets the Words field's value.
func (s *UpdateVocabularyFilterInput) SetWords(v []*string) *UpdateVocabularyFilterInput {
	s.Words = v
	return s
}

type UpdateVocabularyFilterOutput struct {
	_ struct{} `type:"structure"`

	// The language code you selected for your custom vocabulary filter.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary filter was last updated.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated custom vocabulary filter.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyFilterOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyFilterOutput) SetLanguageCode(v string) *UpdateVocabularyFilterOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyFilterOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyFilterOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *UpdateVocabularyFilterOutput) SetVocabularyFilterName(v string) *UpdateVocabularyFilterOutput {
	s.VocabularyFilterName = &v
	return s
}

type UpdateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that has permissions to access
	// the Amazon S3 bucket that contains your input files (in this case, your custom
	// vocabulary). If the role that you specify doesn’t have the appropriate
	// permissions to access the specified Amazon S3 location, your request fails.
	//
	// IAM role ARNs have the format arn:partition:iam::account:role/role-name-with-path.
	// For example: arn:aws:iam::111122223333:role/Admin.
	//
	// For more information, see IAM ARNs (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns).
	DataAccessRoleArn *string `min:"20" type:"string"`

	// The language code that represents the language of the entries in the custom
	// vocabulary you want to update. Each custom vocabulary must contain terms
	// in only one language.
	//
	// A custom vocabulary can only be used to transcribe files in the same language
	// as the custom vocabulary. For example, if you create a custom vocabulary
	// using US English (en-US), you can only apply this custom vocabulary to files
	// that contain English audio.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"LanguageCode"`

	// Use this parameter if you want to update your custom vocabulary by including
	// all desired terms, as comma-separated values, within your request. The other
	// option for updating your custom vocabulary is to save your entries in a text
	// file and upload them to an Amazon S3 bucket, then specify the location of
	// your file using the VocabularyFileUri parameter.
	//
	// Note that if you include Phrases in your request, you cannot use VocabularyFileUri;
	// you must choose one or the other.
	//
	// Each language has a character set that contains all allowed characters for
	// that specific language. If you use unsupported characters, your custom vocabulary
	// filter request fails. Refer to Character Sets for Custom Vocabularies (https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html)
	// to get the character set for your language.
	Phrases []*string `type:"list"`

	// The Amazon S3 location of the text file that contains your custom vocabulary.
	// The URI must be located in the same Amazon Web Services Region as the resource
	// you're calling.
	//
	// Here's an example URI path: s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt
	//
	// Note that if you include VocabularyFileUri in your request, you cannot use
	// the Phrases flag; you must choose one or the other.
	VocabularyFileUri *string `min:"1" type:"string"`

	// The name of the custom vocabulary you want to update. Custom vocabulary names
	// are case sensitive.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVocabularyInput"}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DataAccessRoleArn", 20))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.VocabularyFileUri != nil && len(*s.VocabularyFileUri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyFileUri", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAccessRoleArn sets the DataAccessRoleArn field's value.
func (s *UpdateVocabularyInput) SetDataAccessRoleArn(v string) *UpdateVocabularyInput {
	s.DataAccessRoleArn = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyInput) SetLanguageCode(v string) *UpdateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetPhrases sets the Phrases field's value.
func (s *UpdateVocabularyInput) SetPhrases(v []*string) *UpdateVocabularyInput {
	s.Phrases = v
	return s
}

// SetVocabularyFileUri sets the VocabularyFileUri field's value.
func (s *UpdateVocabularyInput) SetVocabularyFileUri(v string) *UpdateVocabularyInput {
	s.VocabularyFileUri = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyInput) SetVocabularyName(v string) *UpdateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type UpdateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The language code you selected for your custom vocabulary.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary was last updated.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the updated custom vocabulary.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary. If the state is READY, you
	// can use the custom vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateVocabularyOutput) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *UpdateVocabularyOutput) SetLanguageCode(v string) *UpdateVocabularyOutput {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdateVocabularyOutput) SetLastModifiedTime(v time.Time) *UpdateVocabularyOutput {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *UpdateVocabularyOutput) SetVocabularyName(v string) *UpdateVocabularyOutput {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *UpdateVocabularyOutput) SetVocabularyState(v string) *UpdateVocabularyOutput {
	s.VocabularyState = &v
	return s
}

// Provides information about a custom vocabulary filter, including the language
// of the filter, when it was last modified, and its name.
type VocabularyFilterInfo struct {
	_ struct{} `type:"structure"`

	// The language code that represents the language of the entries in your vocabulary
	// filter. Each custom vocabulary filter must contain terms in only one language.
	//
	// A custom vocabulary filter can only be used to transcribe files in the same
	// language as the filter. For example, if you create a custom vocabulary filter
	// using US English (en-US), you can only apply this filter to files that contain
	// English audio.
	//
	// For a list of supported languages and their associated language codes, refer
	// to the Supported languages (https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html)
	// table.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary filter was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// A unique name, chosen by you, for your custom vocabulary filter. This name
	// is case sensitive, cannot contain spaces, and must be unique within an Amazon
	// Web Services account.
	VocabularyFilterName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyFilterInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyFilterInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyFilterInfo) SetLanguageCode(v string) *VocabularyFilterInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyFilterInfo) SetLastModifiedTime(v time.Time) *VocabularyFilterInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyFilterName sets the VocabularyFilterName field's value.
func (s *VocabularyFilterInfo) SetVocabularyFilterName(v string) *VocabularyFilterInfo {
	s.VocabularyFilterName = &v
	return s
}

// Provides information about a custom vocabulary, including the language of
// the custom vocabulary, when it was last modified, its name, and the processing
// state.
type VocabularyInfo struct {
	_ struct{} `type:"structure"`

	// The language code used to create your custom vocabulary. Each custom vocabulary
	// must contain terms in only one language.
	//
	// A custom vocabulary can only be used to transcribe files in the same language
	// as the custom vocabulary. For example, if you create a custom vocabulary
	// using US English (en-US), you can only apply this custom vocabulary to files
	// that contain English audio.
	LanguageCode *string `type:"string" enum:"LanguageCode"`

	// The date and time the specified custom vocabulary was last modified.
	//
	// Timestamps are in the format YYYY-MM-DD'T'HH:MM:SS.SSSSSS-UTC. For example,
	// 2022-05-04T12:32:58.761000-07:00 represents 12:32 PM UTC-7 on May 4, 2022.
	LastModifiedTime *time.Time `type:"timestamp"`

	// A unique name, chosen by you, for your custom vocabulary. This name is case
	// sensitive, cannot contain spaces, and must be unique within an Amazon Web
	// Services account.
	VocabularyName *string `min:"1" type:"string"`

	// The processing state of your custom vocabulary. If the state is READY, you
	// can use the custom vocabulary in a StartTranscriptionJob request.
	VocabularyState *string `type:"string" enum:"VocabularyState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VocabularyInfo) GoString() string {
	return s.String()
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *VocabularyInfo) SetLanguageCode(v string) *VocabularyInfo {
	s.LanguageCode = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *VocabularyInfo) SetLastModifiedTime(v time.Time) *VocabularyInfo {
	s.LastModifiedTime = &v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *VocabularyInfo) SetVocabularyName(v string) *VocabularyInfo {
	s.VocabularyName = &v
	return s
}

// SetVocabularyState sets the VocabularyState field's value.
func (s *VocabularyInfo) SetVocabularyState(v string) *VocabularyInfo {
	s.VocabularyState = &v
	return s
}

const (
	// BaseModelNameNarrowBand is a BaseModelName enum value
	BaseModelNameNarrowBand = "NarrowBand"

	// BaseModelNameWideBand is a BaseModelName enum value
	BaseModelNameWideBand = "WideBand"
)

// BaseModelName_Values returns all elements of the BaseModelName enum
func BaseModelName_Values() []string {
	return []string{
		BaseModelNameNarrowBand,
		BaseModelNameWideBand,
	}
}

const (
	// CLMLanguageCodeEnUs is a CLMLanguageCode enum value
	CLMLanguageCodeEnUs = "en-US"

	// CLMLanguageCodeHiIn is a CLMLanguageCode enum value
	CLMLanguageCodeHiIn = "hi-IN"

	// CLMLanguageCodeEsUs is a CLMLanguageCode enum value
	CLMLanguageCodeEsUs = "es-US"

	// CLMLanguageCodeEnGb is a CLMLanguageCode enum value
	CLMLanguageCodeEnGb = "en-GB"

	// CLMLanguageCodeEnAu is a CLMLanguageCode enum value
	CLMLanguageCodeEnAu = "en-AU"

	// CLMLanguageCodeDeDe is a CLMLanguageCode enum value
	CLMLanguageCodeDeDe = "de-DE"

	// CLMLanguageCodeJaJp is a CLMLanguageCode enum value
	CLMLanguageCodeJaJp = "ja-JP"
)

// CLMLanguageCode_Values returns all elements of the CLMLanguageCode enum
func CLMLanguageCode_Values() []string {
	return []string{
		CLMLanguageCodeEnUs,
		CLMLanguageCodeHiIn,
		CLMLanguageCodeEsUs,
		CLMLanguageCodeEnGb,
		CLMLanguageCodeEnAu,
		CLMLanguageCodeDeDe,
		CLMLanguageCodeJaJp,
	}
}

const (
	// CallAnalyticsJobStatusQueued is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusQueued = "QUEUED"

	// CallAnalyticsJobStatusInProgress is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusInProgress = "IN_PROGRESS"

	// CallAnalyticsJobStatusFailed is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusFailed = "FAILED"

	// CallAnalyticsJobStatusCompleted is a CallAnalyticsJobStatus enum value
	CallAnalyticsJobStatusCompleted = "COMPLETED"
)

// CallAnalyticsJobStatus_Values returns all elements of the CallAnalyticsJobStatus enum
func CallAnalyticsJobStatus_Values() []string {
	return []string{
		CallAnalyticsJobStatusQueued,
		CallAnalyticsJobStatusInProgress,
		CallAnalyticsJobStatusFailed,
		CallAnalyticsJobStatusCompleted,
	}
}

const (
	// InputTypeRealTime is a InputType enum value
	InputTypeRealTime = "REAL_TIME"

	// InputTypePostCall is a InputType enum value
	InputTypePostCall = "POST_CALL"
)

// InputType_Values returns all elements of the InputType enum
func InputType_Values() []string {
	return []string{
		InputTypeRealTime,
		InputTypePostCall,
	}
}

const (
	// LanguageCodeAfZa is a LanguageCode enum value
	LanguageCodeAfZa = "af-ZA"

	// LanguageCodeArAe is a LanguageCode enum value
	LanguageCodeArAe = "ar-AE"

	// LanguageCodeArSa is a LanguageCode enum value
	LanguageCodeArSa = "ar-SA"

	// LanguageCodeDaDk is a LanguageCode enum value
	LanguageCodeDaDk = "da-DK"

	// LanguageCodeDeCh is a LanguageCode enum value
	LanguageCodeDeCh = "de-CH"

	// LanguageCodeDeDe is a LanguageCode enum value
	LanguageCodeDeDe = "de-DE"

	// LanguageCodeEnAb is a LanguageCode enum value
	LanguageCodeEnAb = "en-AB"

	// LanguageCodeEnAu is a LanguageCode enum value
	LanguageCodeEnAu = "en-AU"

	// LanguageCodeEnGb is a LanguageCode enum value
	LanguageCodeEnGb = "en-GB"

	// LanguageCodeEnIe is a LanguageCode enum value
	LanguageCodeEnIe = "en-IE"

	// LanguageCodeEnIn is a LanguageCode enum value
	LanguageCodeEnIn = "en-IN"

	// LanguageCodeEnUs is a LanguageCode enum value
	LanguageCodeEnUs = "en-US"

	// LanguageCodeEnWl is a LanguageCode enum value
	LanguageCodeEnWl = "en-WL"

	// LanguageCodeEsEs is a LanguageCode enum value
	LanguageCodeEsEs = "es-ES"

	// LanguageCodeEsUs is a LanguageCode enum value
	LanguageCodeEsUs = "es-US"

	// LanguageCodeFaIr is a LanguageCode enum value
	LanguageCodeFaIr = "fa-IR"

	// LanguageCodeFrCa is a LanguageCode enum value
	LanguageCodeFrCa = "fr-CA"

	// LanguageCodeFrFr is a LanguageCode enum value
	LanguageCodeFrFr = "fr-FR"

	// LanguageCodeHeIl is a LanguageCode enum value
	LanguageCodeHeIl = "he-IL"

	// LanguageCodeHiIn is a LanguageCode enum value
	LanguageCodeHiIn = "hi-IN"

	// LanguageCodeIdId is a LanguageCode enum value
	LanguageCodeIdId = "id-ID"

	// LanguageCodeItIt is a LanguageCode enum value
	LanguageCodeItIt = "it-IT"

	// LanguageCodeJaJp is a LanguageCode enum value
	LanguageCodeJaJp = "ja-JP"

	// LanguageCodeKoKr is a LanguageCode enum value
	LanguageCodeKoKr = "ko-KR"

	// LanguageCodeMsMy is a LanguageCode enum value
	LanguageCodeMsMy = "ms-MY"

	// LanguageCodeNlNl is a LanguageCode enum value
	LanguageCodeNlNl = "nl-NL"

	// LanguageCodePtBr is a LanguageCode enum value
	LanguageCodePtBr = "pt-BR"

	// LanguageCodePtPt is a LanguageCode enum value
	LanguageCodePtPt = "pt-PT"

	// LanguageCodeRuRu is a LanguageCode enum value
	LanguageCodeRuRu = "ru-RU"

	// LanguageCodeTaIn is a LanguageCode enum value
	LanguageCodeTaIn = "ta-IN"

	// LanguageCodeTeIn is a LanguageCode enum value
	LanguageCodeTeIn = "te-IN"

	// LanguageCodeTrTr is a LanguageCode enum value
	LanguageCodeTrTr = "tr-TR"

	// LanguageCodeZhCn is a LanguageCode enum value
	LanguageCodeZhCn = "zh-CN"

	// LanguageCodeZhTw is a LanguageCode enum value
	LanguageCodeZhTw = "zh-TW"

	// LanguageCodeThTh is a LanguageCode enum value
	LanguageCodeThTh = "th-TH"

	// LanguageCodeEnZa is a LanguageCode enum value
	LanguageCodeEnZa = "en-ZA"

	// LanguageCodeEnNz is a LanguageCode enum value
	LanguageCodeEnNz = "en-NZ"

	// LanguageCodeViVn is a LanguageCode enum value
	LanguageCodeViVn = "vi-VN"

	// LanguageCodeSvSe is a LanguageCode enum value
	LanguageCodeSvSe = "sv-SE"
)

// LanguageCode_Values returns all elements of the LanguageCode enum
func LanguageCode_Values() []string {
	return []string{
		LanguageCodeAfZa,
		LanguageCodeArAe,
		LanguageCodeArSa,
		LanguageCodeDaDk,
		LanguageCodeDeCh,
		LanguageCodeDeDe,
		LanguageCodeEnAb,
		LanguageCodeEnAu,
		LanguageCodeEnGb,
		LanguageCodeEnIe,
		LanguageCodeEnIn,
		LanguageCodeEnUs,
		LanguageCodeEnWl,
		LanguageCodeEsEs,
		LanguageCodeEsUs,
		LanguageCodeFaIr,
		LanguageCodeFrCa,
		LanguageCodeFrFr,
		LanguageCodeHeIl,
		LanguageCodeHiIn,
		LanguageCodeIdId,
		LanguageCodeItIt,
		LanguageCodeJaJp,
		LanguageCodeKoKr,
		LanguageCodeMsMy,
		LanguageCodeNlNl,
		LanguageCodePtBr,
		LanguageCodePtPt,
		LanguageCodeRuRu,
		LanguageCodeTaIn,
		LanguageCodeTeIn,
		LanguageCodeTrTr,
		LanguageCodeZhCn,
		LanguageCodeZhTw,
		LanguageCodeThTh,
		LanguageCodeEnZa,
		LanguageCodeEnNz,
		LanguageCodeViVn,
		LanguageCodeSvSe,
	}
}

const (
	// MediaFormatMp3 is a MediaFormat enum value
	MediaFormatMp3 = "mp3"

	// MediaFormatMp4 is a MediaFormat enum value
	MediaFormatMp4 = "mp4"

	// MediaFormatWav is a MediaFormat enum value
	MediaFormatWav = "wav"

	// MediaFormatFlac is a MediaFormat enum value
	MediaFormatFlac = "flac"

	// MediaFormatOgg is a MediaFormat enum value
	MediaFormatOgg = "ogg"

	// MediaFormatAmr is a MediaFormat enum value
	MediaFormatAmr = "amr"

	// MediaFormatWebm is a MediaFormat enum value
	MediaFormatWebm = "webm"
)

// MediaFormat_Values returns all elements of the MediaFormat enum
func MediaFormat_Values() []string {
	return []string{
		MediaFormatMp3,
		MediaFormatMp4,
		MediaFormatWav,
		MediaFormatFlac,
		MediaFormatOgg,
		MediaFormatAmr,
		MediaFormatWebm,
	}
}

const (
	// MedicalContentIdentificationTypePhi is a MedicalContentIdentificationType enum value
	MedicalContentIdentificationTypePhi = "PHI"
)

// MedicalContentIdentificationType_Values returns all elements of the MedicalContentIdentificationType enum
func MedicalContentIdentificationType_Values() []string {
	return []string{
		MedicalContentIdentificationTypePhi,
	}
}

const (
	// ModelStatusInProgress is a ModelStatus enum value
	ModelStatusInProgress = "IN_PROGRESS"

	// ModelStatusFailed is a ModelStatus enum value
	ModelStatusFailed = "FAILED"

	// ModelStatusCompleted is a ModelStatus enum value
	ModelStatusCompleted = "COMPLETED"
)

// ModelStatus_Values returns all elements of the ModelStatus enum
func ModelStatus_Values() []string {
	return []string{
		ModelStatusInProgress,
		ModelStatusFailed,
		ModelStatusCompleted,
	}
}

const (
	// OutputLocationTypeCustomerBucket is a OutputLocationType enum value
	OutputLocationTypeCustomerBucket = "CUSTOMER_BUCKET"

	// OutputLocationTypeServiceBucket is a OutputLocationType enum value
	OutputLocationTypeServiceBucket = "SERVICE_BUCKET"
)

// OutputLocationType_Values returns all elements of the OutputLocationType enum
func OutputLocationType_Values() []string {
	return []string{
		OutputLocationTypeCustomerBucket,
		OutputLocationTypeServiceBucket,
	}
}

const (
	// ParticipantRoleAgent is a ParticipantRole enum value
	ParticipantRoleAgent = "AGENT"

	// ParticipantRoleCustomer is a ParticipantRole enum value
	ParticipantRoleCustomer = "CUSTOMER"
)

// ParticipantRole_Values returns all elements of the ParticipantRole enum
func ParticipantRole_Values() []string {
	return []string{
		ParticipantRoleAgent,
		ParticipantRoleCustomer,
	}
}

const (
	// PiiEntityTypeBankAccountNumber is a PiiEntityType enum value
	PiiEntityTypeBankAccountNumber = "BANK_ACCOUNT_NUMBER"

	// PiiEntityTypeBankRouting is a PiiEntityType enum value
	PiiEntityTypeBankRouting = "BANK_ROUTING"

	// PiiEntityTypeCreditDebitNumber is a PiiEntityType enum value
	PiiEntityTypeCreditDebitNumber = "CREDIT_DEBIT_NUMBER"

	// PiiEntityTypeCreditDebitCvv is a PiiEntityType enum value
	PiiEntityTypeCreditDebitCvv = "CREDIT_DEBIT_CVV"

	// PiiEntityTypeCreditDebitExpiry is a PiiEntityType enum value
	PiiEntityTypeCreditDebitExpiry = "CREDIT_DEBIT_EXPIRY"

	// PiiEntityTypePin is a PiiEntityType enum value
	PiiEntityTypePin = "PIN"

	// PiiEntityTypeEmail is a PiiEntityType enum value
	PiiEntityTypeEmail = "EMAIL"

	// PiiEntityTypeAddress is a PiiEntityType enum value
	PiiEntityTypeAddress = "ADDRESS"

	// PiiEntityTypeName is a PiiEntityType enum value
	PiiEntityTypeName = "NAME"

	// PiiEntityTypePhone is a PiiEntityType enum value
	PiiEntityTypePhone = "PHONE"

	// PiiEntityTypeSsn is a PiiEntityType enum value
	PiiEntityTypeSsn = "SSN"

	// PiiEntityTypeAll is a PiiEntityType enum value
	PiiEntityTypeAll = "ALL"
)

// PiiEntityType_Values returns all elements of the PiiEntityType enum
func PiiEntityType_Values() []string {
	return []string{
		PiiEntityTypeBankAccountNumber,
		PiiEntityTypeBankRouting,
		PiiEntityTypeCreditDebitNumber,
		PiiEntityTypeCreditDebitCvv,
		PiiEntityTypeCreditDebitExpiry,
		PiiEntityTypePin,
		PiiEntityTypeEmail,
		PiiEntityTypeAddress,
		PiiEntityTypeName,
		PiiEntityTypePhone,
		PiiEntityTypeSsn,
		PiiEntityTypeAll,
	}
}

const (
	// RedactionOutputRedacted is a RedactionOutput enum value
	RedactionOutputRedacted = "redacted"

	// RedactionOutputRedactedAndUnredacted is a RedactionOutput enum value
	RedactionOutputRedactedAndUnredacted = "redacted_and_unredacted"
)

// RedactionOutput_Values returns all elements of the RedactionOutput enum
func RedactionOutput_Values() []string {
	return []string{
		RedactionOutputRedacted,
		RedactionOutputRedactedAndUnredacted,
	}
}

const (
	// RedactionTypePii is a RedactionType enum value
	RedactionTypePii = "PII"
)

// RedactionType_Values returns all elements of the RedactionType enum
func RedactionType_Values() []string {
	return []string{
		RedactionTypePii,
	}
}

const (
	// SentimentValuePositive is a SentimentValue enum value
	SentimentValuePositive = "POSITIVE"

	// SentimentValueNegative is a SentimentValue enum value
	SentimentValueNegative = "NEGATIVE"

	// SentimentValueNeutral is a SentimentValue enum value
	SentimentValueNeutral = "NEUTRAL"

	// SentimentValueMixed is a SentimentValue enum value
	SentimentValueMixed = "MIXED"
)

// SentimentValue_Values returns all elements of the SentimentValue enum
func SentimentValue_Values() []string {
	return []string{
		SentimentValuePositive,
		SentimentValueNegative,
		SentimentValueNeutral,
		SentimentValueMixed,
	}
}

const (
	// SpecialtyPrimarycare is a Specialty enum value
	SpecialtyPrimarycare = "PRIMARYCARE"
)

// Specialty_Values returns all elements of the Specialty enum
func Specialty_Values() []string {
	return []string{
		SpecialtyPrimarycare,
	}
}

const (
	// SubtitleFormatVtt is a SubtitleFormat enum value
	SubtitleFormatVtt = "vtt"

	// SubtitleFormatSrt is a SubtitleFormat enum value
	SubtitleFormatSrt = "srt"
)

// SubtitleFormat_Values returns all elements of the SubtitleFormat enum
func SubtitleFormat_Values() []string {
	return []string{
		SubtitleFormatVtt,
		SubtitleFormatSrt,
	}
}

const (
	// ToxicityCategoryAll is a ToxicityCategory enum value
	ToxicityCategoryAll = "ALL"
)

// ToxicityCategory_Values returns all elements of the ToxicityCategory enum
func ToxicityCategory_Values() []string {
	return []string{
		ToxicityCategoryAll,
	}
}

const (
	// TranscriptFilterTypeExact is a TranscriptFilterType enum value
	TranscriptFilterTypeExact = "EXACT"
)

// TranscriptFilterType_Values returns all elements of the TranscriptFilterType enum
func TranscriptFilterType_Values() []string {
	return []string{
		TranscriptFilterTypeExact,
	}
}

const (
	// TranscriptionJobStatusQueued is a TranscriptionJobStatus enum value
	TranscriptionJobStatusQueued = "QUEUED"

	// TranscriptionJobStatusInProgress is a TranscriptionJobStatus enum value
	TranscriptionJobStatusInProgress = "IN_PROGRESS"

	// TranscriptionJobStatusFailed is a TranscriptionJobStatus enum value
	TranscriptionJobStatusFailed = "FAILED"

	// TranscriptionJobStatusCompleted is a TranscriptionJobStatus enum value
	TranscriptionJobStatusCompleted = "COMPLETED"
)

// TranscriptionJobStatus_Values returns all elements of the TranscriptionJobStatus enum
func TranscriptionJobStatus_Values() []string {
	return []string{
		TranscriptionJobStatusQueued,
		TranscriptionJobStatusInProgress,
		TranscriptionJobStatusFailed,
		TranscriptionJobStatusCompleted,
	}
}

const (
	// TypeConversation is a Type enum value
	TypeConversation = "CONVERSATION"

	// TypeDictation is a Type enum value
	TypeDictation = "DICTATION"
)

// Type_Values returns all elements of the Type enum
func Type_Values() []string {
	return []string{
		TypeConversation,
		TypeDictation,
	}
}

const (
	// VocabularyFilterMethodRemove is a VocabularyFilterMethod enum value
	VocabularyFilterMethodRemove = "remove"

	// VocabularyFilterMethodMask is a VocabularyFilterMethod enum value
	VocabularyFilterMethodMask = "mask"

	// VocabularyFilterMethodTag is a VocabularyFilterMethod enum value
	VocabularyFilterMethodTag = "tag"
)

// VocabularyFilterMethod_Values returns all elements of the VocabularyFilterMethod enum
func VocabularyFilterMethod_Values() []string {
	return []string{
		VocabularyFilterMethodRemove,
		VocabularyFilterMethodMask,
		VocabularyFilterMethodTag,
	}
}

const (
	// VocabularyStatePending is a VocabularyState enum value
	VocabularyStatePending = "PENDING"

	// VocabularyStateReady is a VocabularyState enum value
	VocabularyStateReady = "READY"

	// VocabularyStateFailed is a VocabularyState enum value
	VocabularyStateFailed = "FAILED"
)

// VocabularyState_Values returns all elements of the VocabularyState enum
func VocabularyState_Values() []string {
	return []string{
		VocabularyStatePending,
		VocabularyStateReady,
		VocabularyStateFailed,
	}
}
