// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceDeleteApplicationTemplate3Reader is a Reader for the WaypointServiceDeleteApplicationTemplate3 structure.
type WaypointServiceDeleteApplicationTemplate3Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteApplicationTemplate3Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteApplicationTemplate3OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteApplicationTemplate3Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteApplicationTemplate3OK creates a WaypointServiceDeleteApplicationTemplate3OK with default headers values
func NewWaypointServiceDeleteApplicationTemplate3OK() *WaypointServiceDeleteApplicationTemplate3OK {
	return &WaypointServiceDeleteApplicationTemplate3OK{}
}

/*
WaypointServiceDeleteApplicationTemplate3OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteApplicationTemplate3OK struct {
	Payload models.HashicorpCloudWaypointDeleteApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service delete application template3 o k response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplate3OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete application template3 o k response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplate3OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete application template3 o k response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplate3OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete application template3 o k response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplate3OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete application template3 o k response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplate3OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete application template3 o k response
func (o *WaypointServiceDeleteApplicationTemplate3OK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteApplicationTemplate3OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] waypointServiceDeleteApplicationTemplate3OK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate3OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] waypointServiceDeleteApplicationTemplate3OK %s", 200, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate3OK) GetPayload() models.HashicorpCloudWaypointDeleteApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplate3OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteApplicationTemplate3Default creates a WaypointServiceDeleteApplicationTemplate3Default with default headers values
func NewWaypointServiceDeleteApplicationTemplate3Default(code int) *WaypointServiceDeleteApplicationTemplate3Default {
	return &WaypointServiceDeleteApplicationTemplate3Default{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteApplicationTemplate3Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteApplicationTemplate3Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete application template3 default response has a 2xx status code
func (o *WaypointServiceDeleteApplicationTemplate3Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete application template3 default response has a 3xx status code
func (o *WaypointServiceDeleteApplicationTemplate3Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete application template3 default response has a 4xx status code
func (o *WaypointServiceDeleteApplicationTemplate3Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete application template3 default response has a 5xx status code
func (o *WaypointServiceDeleteApplicationTemplate3Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete application template3 default response a status code equal to that given
func (o *WaypointServiceDeleteApplicationTemplate3Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete application template3 default response
func (o *WaypointServiceDeleteApplicationTemplate3Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteApplicationTemplate3Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] WaypointService_DeleteApplicationTemplate3 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate3Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2023-08-18/namespace/{namespace.id}/templates/{application_template.id}][%d] WaypointService_DeleteApplicationTemplate3 default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteApplicationTemplate3Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteApplicationTemplate3Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
