// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewCreateAppParams creates a new CreateAppParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateAppParams() *CreateAppParams {
	return &CreateAppParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateAppParamsWithTimeout creates a new CreateAppParams object
// with the ability to set a timeout on a request.
func NewCreateAppParamsWithTimeout(timeout time.Duration) *CreateAppParams {
	return &CreateAppParams{
		timeout: timeout,
	}
}

// NewCreateAppParamsWithContext creates a new CreateAppParams object
// with the ability to set a context for a request.
func NewCreateAppParamsWithContext(ctx context.Context) *CreateAppParams {
	return &CreateAppParams{
		Context: ctx,
	}
}

// NewCreateAppParamsWithHTTPClient creates a new CreateAppParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateAppParamsWithHTTPClient(client *http.Client) *CreateAppParams {
	return &CreateAppParams{
		HTTPClient: client,
	}
}

/*
CreateAppParams contains all the parameters to send to the API endpoint

	for the create app operation.

	Typically these are written to a http.Request.
*/
type CreateAppParams struct {

	// Body.
	Body CreateAppBody

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAppParams) WithDefaults() *CreateAppParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAppParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create app params
func (o *CreateAppParams) WithTimeout(timeout time.Duration) *CreateAppParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create app params
func (o *CreateAppParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create app params
func (o *CreateAppParams) WithContext(ctx context.Context) *CreateAppParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create app params
func (o *CreateAppParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create app params
func (o *CreateAppParams) WithHTTPClient(client *http.Client) *CreateAppParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create app params
func (o *CreateAppParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create app params
func (o *CreateAppParams) WithBody(body CreateAppBody) *CreateAppParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create app params
func (o *CreateAppParams) SetBody(body CreateAppBody) {
	o.Body = body
}

// WithLocationOrganizationID adds the locationOrganizationID to the create app params
func (o *CreateAppParams) WithLocationOrganizationID(locationOrganizationID string) *CreateAppParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the create app params
func (o *CreateAppParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the create app params
func (o *CreateAppParams) WithLocationProjectID(locationProjectID string) *CreateAppParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the create app params
func (o *CreateAppParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateAppParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if err := r.SetBodyParam(o.Body); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
