// Code generated by go-swagger; DO NOT EDIT.

package integration_connection_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetIntegrationConnectionByIDParams creates a new GetIntegrationConnectionByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetIntegrationConnectionByIDParams() *GetIntegrationConnectionByIDParams {
	return &GetIntegrationConnectionByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetIntegrationConnectionByIDParamsWithTimeout creates a new GetIntegrationConnectionByIDParams object
// with the ability to set a timeout on a request.
func NewGetIntegrationConnectionByIDParamsWithTimeout(timeout time.Duration) *GetIntegrationConnectionByIDParams {
	return &GetIntegrationConnectionByIDParams{
		timeout: timeout,
	}
}

// NewGetIntegrationConnectionByIDParamsWithContext creates a new GetIntegrationConnectionByIDParams object
// with the ability to set a context for a request.
func NewGetIntegrationConnectionByIDParamsWithContext(ctx context.Context) *GetIntegrationConnectionByIDParams {
	return &GetIntegrationConnectionByIDParams{
		Context: ctx,
	}
}

// NewGetIntegrationConnectionByIDParamsWithHTTPClient creates a new GetIntegrationConnectionByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetIntegrationConnectionByIDParamsWithHTTPClient(client *http.Client) *GetIntegrationConnectionByIDParams {
	return &GetIntegrationConnectionByIDParams{
		HTTPClient: client,
	}
}

/*
GetIntegrationConnectionByIDParams contains all the parameters to send to the API endpoint

	for the get integration connection by ID operation.

	Typically these are written to a http.Request.
*/
type GetIntegrationConnectionByIDParams struct {

	/* ID.

	   ID is the identifier of the integration connection to retrieve.
	*/
	ID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID *string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get integration connection by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIntegrationConnectionByIDParams) WithDefaults() *GetIntegrationConnectionByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get integration connection by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIntegrationConnectionByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithTimeout(timeout time.Duration) *GetIntegrationConnectionByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithContext(ctx context.Context) *GetIntegrationConnectionByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithHTTPClient(client *http.Client) *GetIntegrationConnectionByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithID adds the id to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithID(id string) *GetIntegrationConnectionByIDParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetID(id string) {
	o.ID = id
}

// WithLocationOrganizationID adds the locationOrganizationID to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithLocationOrganizationID(locationOrganizationID *string) *GetIntegrationConnectionByIDParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetLocationOrganizationID(locationOrganizationID *string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithLocationProjectID(locationProjectID string) *GetIntegrationConnectionByIDParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithLocationRegionProvider(locationRegionProvider *string) *GetIntegrationConnectionByIDParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) WithLocationRegionRegion(locationRegionRegion *string) *GetIntegrationConnectionByIDParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get integration connection by ID params
func (o *GetIntegrationConnectionByIDParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetIntegrationConnectionByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	if o.LocationOrganizationID != nil {

		// query param location.organization_id
		var qrLocationOrganizationID string

		if o.LocationOrganizationID != nil {
			qrLocationOrganizationID = *o.LocationOrganizationID
		}
		qLocationOrganizationID := qrLocationOrganizationID
		if qLocationOrganizationID != "" {

			if err := r.SetQueryParam("location.organization_id", qLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
