// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330DatadogProvider DatadogProvider represents the necessary information to configure a datadog destination.
//
// swagger:model log_service_20210330DatadogProvider
type LogService20210330DatadogProvider struct {

	// authorization represents the authorization information sent with each request when streaming to the datadog endpoint.
	Authorization *LogService20210330Authorization `json:"authorization,omitempty"`

	// endpoint represents the datadog endpoint to which to stream logs.
	Endpoint string `json:"endpoint,omitempty"`
}

// Validate validates this log service 20210330 datadog provider
func (m *LogService20210330DatadogProvider) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAuthorization(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330DatadogProvider) validateAuthorization(formats strfmt.Registry) error {
	if swag.IsZero(m.Authorization) { // not required
		return nil
	}

	if m.Authorization != nil {
		if err := m.Authorization.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authorization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("authorization")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 datadog provider based on the context it is used
func (m *LogService20210330DatadogProvider) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAuthorization(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330DatadogProvider) contextValidateAuthorization(ctx context.Context, formats strfmt.Registry) error {

	if m.Authorization != nil {

		if swag.IsZero(m.Authorization) { // not required
			return nil
		}

		if err := m.Authorization.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("authorization")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("authorization")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330DatadogProvider) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330DatadogProvider) UnmarshalBinary(b []byte) error {
	var res LogService20210330DatadogProvider
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
