// Code generated by go-swagger; DO NOT EDIT.

package profile_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProfileServiceSendVerificationEmailReader is a Reader for the ProfileServiceSendVerificationEmail structure.
type ProfileServiceSendVerificationEmailReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProfileServiceSendVerificationEmailReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProfileServiceSendVerificationEmailOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProfileServiceSendVerificationEmailDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProfileServiceSendVerificationEmailOK creates a ProfileServiceSendVerificationEmailOK with default headers values
func NewProfileServiceSendVerificationEmailOK() *ProfileServiceSendVerificationEmailOK {
	return &ProfileServiceSendVerificationEmailOK{}
}

/*
ProfileServiceSendVerificationEmailOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProfileServiceSendVerificationEmailOK struct {
	Payload models.HashicorpCloudIamSendVerificationEmailResponse
}

// IsSuccess returns true when this profile service send verification email o k response has a 2xx status code
func (o *ProfileServiceSendVerificationEmailOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this profile service send verification email o k response has a 3xx status code
func (o *ProfileServiceSendVerificationEmailOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this profile service send verification email o k response has a 4xx status code
func (o *ProfileServiceSendVerificationEmailOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this profile service send verification email o k response has a 5xx status code
func (o *ProfileServiceSendVerificationEmailOK) IsServerError() bool {
	return false
}

// IsCode returns true when this profile service send verification email o k response a status code equal to that given
func (o *ProfileServiceSendVerificationEmailOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the profile service send verification email o k response
func (o *ProfileServiceSendVerificationEmailOK) Code() int {
	return 200
}

func (o *ProfileServiceSendVerificationEmailOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/send-verification-email][%d] profileServiceSendVerificationEmailOK %s", 200, payload)
}

func (o *ProfileServiceSendVerificationEmailOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/send-verification-email][%d] profileServiceSendVerificationEmailOK %s", 200, payload)
}

func (o *ProfileServiceSendVerificationEmailOK) GetPayload() models.HashicorpCloudIamSendVerificationEmailResponse {
	return o.Payload
}

func (o *ProfileServiceSendVerificationEmailOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProfileServiceSendVerificationEmailDefault creates a ProfileServiceSendVerificationEmailDefault with default headers values
func NewProfileServiceSendVerificationEmailDefault(code int) *ProfileServiceSendVerificationEmailDefault {
	return &ProfileServiceSendVerificationEmailDefault{
		_statusCode: code,
	}
}

/*
ProfileServiceSendVerificationEmailDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProfileServiceSendVerificationEmailDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this profile service send verification email default response has a 2xx status code
func (o *ProfileServiceSendVerificationEmailDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this profile service send verification email default response has a 3xx status code
func (o *ProfileServiceSendVerificationEmailDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this profile service send verification email default response has a 4xx status code
func (o *ProfileServiceSendVerificationEmailDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this profile service send verification email default response has a 5xx status code
func (o *ProfileServiceSendVerificationEmailDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this profile service send verification email default response a status code equal to that given
func (o *ProfileServiceSendVerificationEmailDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the profile service send verification email default response
func (o *ProfileServiceSendVerificationEmailDefault) Code() int {
	return o._statusCode
}

func (o *ProfileServiceSendVerificationEmailDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/send-verification-email][%d] ProfileService_SendVerificationEmail default %s", o._statusCode, payload)
}

func (o *ProfileServiceSendVerificationEmailDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /iam/2019-12-10/me/send-verification-email][%d] ProfileService_SendVerificationEmail default %s", o._statusCode, payload)
}

func (o *ProfileServiceSendVerificationEmailDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProfileServiceSendVerificationEmailDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
