// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
)

// NewBoundaryServiceUpdateApplyParams creates a new BoundaryServiceUpdateApplyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBoundaryServiceUpdateApplyParams() *BoundaryServiceUpdateApplyParams {
	return &BoundaryServiceUpdateApplyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBoundaryServiceUpdateApplyParamsWithTimeout creates a new BoundaryServiceUpdateApplyParams object
// with the ability to set a timeout on a request.
func NewBoundaryServiceUpdateApplyParamsWithTimeout(timeout time.Duration) *BoundaryServiceUpdateApplyParams {
	return &BoundaryServiceUpdateApplyParams{
		timeout: timeout,
	}
}

// NewBoundaryServiceUpdateApplyParamsWithContext creates a new BoundaryServiceUpdateApplyParams object
// with the ability to set a context for a request.
func NewBoundaryServiceUpdateApplyParamsWithContext(ctx context.Context) *BoundaryServiceUpdateApplyParams {
	return &BoundaryServiceUpdateApplyParams{
		Context: ctx,
	}
}

// NewBoundaryServiceUpdateApplyParamsWithHTTPClient creates a new BoundaryServiceUpdateApplyParams object
// with the ability to set a custom HTTPClient for a request.
func NewBoundaryServiceUpdateApplyParamsWithHTTPClient(client *http.Client) *BoundaryServiceUpdateApplyParams {
	return &BoundaryServiceUpdateApplyParams{
		HTTPClient: client,
	}
}

/*
BoundaryServiceUpdateApplyParams contains all the parameters to send to the API endpoint

	for the boundary service update apply operation.

	Typically these are written to a http.Request.
*/
type BoundaryServiceUpdateApplyParams struct {

	// Body.
	Body *models.HashicorpCloudBoundary20211221UpdateApplyRequest

	/* ClusterID.

	   cluster_id is the id of the cluster set by user on creation.
	*/
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the boundary service update apply params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceUpdateApplyParams) WithDefaults() *BoundaryServiceUpdateApplyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the boundary service update apply params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BoundaryServiceUpdateApplyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithTimeout(timeout time.Duration) *BoundaryServiceUpdateApplyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithContext(ctx context.Context) *BoundaryServiceUpdateApplyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithHTTPClient(client *http.Client) *BoundaryServiceUpdateApplyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithBody(body *models.HashicorpCloudBoundary20211221UpdateApplyRequest) *BoundaryServiceUpdateApplyParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetBody(body *models.HashicorpCloudBoundary20211221UpdateApplyRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithClusterID(clusterID string) *BoundaryServiceUpdateApplyParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithLocationOrganizationID(locationOrganizationID string) *BoundaryServiceUpdateApplyParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) WithLocationProjectID(locationProjectID string) *BoundaryServiceUpdateApplyParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the boundary service update apply params
func (o *BoundaryServiceUpdateApplyParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *BoundaryServiceUpdateApplyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
