// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package clouddms

import (
	"context"
	"fmt"
	"math"
	"net/url"
	"time"

	clouddmspb "cloud.google.com/go/clouddms/apiv1/clouddmspb"
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newDataMigrationClientHook clientHook

// DataMigrationCallOptions contains the retry settings for each method of DataMigrationClient.
type DataMigrationCallOptions struct {
	ListMigrationJobs                    []gax.CallOption
	GetMigrationJob                      []gax.CallOption
	CreateMigrationJob                   []gax.CallOption
	UpdateMigrationJob                   []gax.CallOption
	DeleteMigrationJob                   []gax.CallOption
	StartMigrationJob                    []gax.CallOption
	StopMigrationJob                     []gax.CallOption
	ResumeMigrationJob                   []gax.CallOption
	PromoteMigrationJob                  []gax.CallOption
	VerifyMigrationJob                   []gax.CallOption
	RestartMigrationJob                  []gax.CallOption
	GenerateSshScript                    []gax.CallOption
	GenerateTcpProxyScript               []gax.CallOption
	ListConnectionProfiles               []gax.CallOption
	GetConnectionProfile                 []gax.CallOption
	CreateConnectionProfile              []gax.CallOption
	UpdateConnectionProfile              []gax.CallOption
	DeleteConnectionProfile              []gax.CallOption
	CreatePrivateConnection              []gax.CallOption
	GetPrivateConnection                 []gax.CallOption
	ListPrivateConnections               []gax.CallOption
	DeletePrivateConnection              []gax.CallOption
	GetConversionWorkspace               []gax.CallOption
	ListConversionWorkspaces             []gax.CallOption
	CreateConversionWorkspace            []gax.CallOption
	UpdateConversionWorkspace            []gax.CallOption
	DeleteConversionWorkspace            []gax.CallOption
	CreateMappingRule                    []gax.CallOption
	DeleteMappingRule                    []gax.CallOption
	ListMappingRules                     []gax.CallOption
	GetMappingRule                       []gax.CallOption
	SeedConversionWorkspace              []gax.CallOption
	ImportMappingRules                   []gax.CallOption
	ConvertConversionWorkspace           []gax.CallOption
	CommitConversionWorkspace            []gax.CallOption
	RollbackConversionWorkspace          []gax.CallOption
	ApplyConversionWorkspace             []gax.CallOption
	DescribeDatabaseEntities             []gax.CallOption
	SearchBackgroundJobs                 []gax.CallOption
	DescribeConversionWorkspaceRevisions []gax.CallOption
	FetchStaticIps                       []gax.CallOption
	GetLocation                          []gax.CallOption
	ListLocations                        []gax.CallOption
	GetIamPolicy                         []gax.CallOption
	SetIamPolicy                         []gax.CallOption
	TestIamPermissions                   []gax.CallOption
	CancelOperation                      []gax.CallOption
	DeleteOperation                      []gax.CallOption
	GetOperation                         []gax.CallOption
	ListOperations                       []gax.CallOption
}

func defaultDataMigrationGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("datamigration.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("datamigration.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("datamigration.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://datamigration.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultDataMigrationCallOptions() *DataMigrationCallOptions {
	return &DataMigrationCallOptions{
		ListMigrationJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResumeMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		PromoteMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		VerifyMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RestartMigrationJob: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GenerateSshScript: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GenerateTcpProxyScript: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListConnectionProfiles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetConnectionProfile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateConnectionProfile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateConnectionProfile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteConnectionProfile: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreatePrivateConnection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetPrivateConnection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListPrivateConnections: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeletePrivateConnection: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ListConversionWorkspaces: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateMappingRule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteMappingRule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListMappingRules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetMappingRule: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		SeedConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ImportMappingRules: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ConvertConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CommitConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RollbackConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ApplyConversionWorkspace: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DescribeDatabaseEntities: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SearchBackgroundJobs: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DescribeConversionWorkspaceRevisions: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		FetchStaticIps: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations:     []gax.CallOption{},
	}
}

// internalDataMigrationClient is an interface that defines the methods available from Database Migration API.
type internalDataMigrationClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListMigrationJobs(context.Context, *clouddmspb.ListMigrationJobsRequest, ...gax.CallOption) *MigrationJobIterator
	GetMigrationJob(context.Context, *clouddmspb.GetMigrationJobRequest, ...gax.CallOption) (*clouddmspb.MigrationJob, error)
	CreateMigrationJob(context.Context, *clouddmspb.CreateMigrationJobRequest, ...gax.CallOption) (*CreateMigrationJobOperation, error)
	CreateMigrationJobOperation(name string) *CreateMigrationJobOperation
	UpdateMigrationJob(context.Context, *clouddmspb.UpdateMigrationJobRequest, ...gax.CallOption) (*UpdateMigrationJobOperation, error)
	UpdateMigrationJobOperation(name string) *UpdateMigrationJobOperation
	DeleteMigrationJob(context.Context, *clouddmspb.DeleteMigrationJobRequest, ...gax.CallOption) (*DeleteMigrationJobOperation, error)
	DeleteMigrationJobOperation(name string) *DeleteMigrationJobOperation
	StartMigrationJob(context.Context, *clouddmspb.StartMigrationJobRequest, ...gax.CallOption) (*StartMigrationJobOperation, error)
	StartMigrationJobOperation(name string) *StartMigrationJobOperation
	StopMigrationJob(context.Context, *clouddmspb.StopMigrationJobRequest, ...gax.CallOption) (*StopMigrationJobOperation, error)
	StopMigrationJobOperation(name string) *StopMigrationJobOperation
	ResumeMigrationJob(context.Context, *clouddmspb.ResumeMigrationJobRequest, ...gax.CallOption) (*ResumeMigrationJobOperation, error)
	ResumeMigrationJobOperation(name string) *ResumeMigrationJobOperation
	PromoteMigrationJob(context.Context, *clouddmspb.PromoteMigrationJobRequest, ...gax.CallOption) (*PromoteMigrationJobOperation, error)
	PromoteMigrationJobOperation(name string) *PromoteMigrationJobOperation
	VerifyMigrationJob(context.Context, *clouddmspb.VerifyMigrationJobRequest, ...gax.CallOption) (*VerifyMigrationJobOperation, error)
	VerifyMigrationJobOperation(name string) *VerifyMigrationJobOperation
	RestartMigrationJob(context.Context, *clouddmspb.RestartMigrationJobRequest, ...gax.CallOption) (*RestartMigrationJobOperation, error)
	RestartMigrationJobOperation(name string) *RestartMigrationJobOperation
	GenerateSshScript(context.Context, *clouddmspb.GenerateSshScriptRequest, ...gax.CallOption) (*clouddmspb.SshScript, error)
	GenerateTcpProxyScript(context.Context, *clouddmspb.GenerateTcpProxyScriptRequest, ...gax.CallOption) (*clouddmspb.TcpProxyScript, error)
	ListConnectionProfiles(context.Context, *clouddmspb.ListConnectionProfilesRequest, ...gax.CallOption) *ConnectionProfileIterator
	GetConnectionProfile(context.Context, *clouddmspb.GetConnectionProfileRequest, ...gax.CallOption) (*clouddmspb.ConnectionProfile, error)
	CreateConnectionProfile(context.Context, *clouddmspb.CreateConnectionProfileRequest, ...gax.CallOption) (*CreateConnectionProfileOperation, error)
	CreateConnectionProfileOperation(name string) *CreateConnectionProfileOperation
	UpdateConnectionProfile(context.Context, *clouddmspb.UpdateConnectionProfileRequest, ...gax.CallOption) (*UpdateConnectionProfileOperation, error)
	UpdateConnectionProfileOperation(name string) *UpdateConnectionProfileOperation
	DeleteConnectionProfile(context.Context, *clouddmspb.DeleteConnectionProfileRequest, ...gax.CallOption) (*DeleteConnectionProfileOperation, error)
	DeleteConnectionProfileOperation(name string) *DeleteConnectionProfileOperation
	CreatePrivateConnection(context.Context, *clouddmspb.CreatePrivateConnectionRequest, ...gax.CallOption) (*CreatePrivateConnectionOperation, error)
	CreatePrivateConnectionOperation(name string) *CreatePrivateConnectionOperation
	GetPrivateConnection(context.Context, *clouddmspb.GetPrivateConnectionRequest, ...gax.CallOption) (*clouddmspb.PrivateConnection, error)
	ListPrivateConnections(context.Context, *clouddmspb.ListPrivateConnectionsRequest, ...gax.CallOption) *PrivateConnectionIterator
	DeletePrivateConnection(context.Context, *clouddmspb.DeletePrivateConnectionRequest, ...gax.CallOption) (*DeletePrivateConnectionOperation, error)
	DeletePrivateConnectionOperation(name string) *DeletePrivateConnectionOperation
	GetConversionWorkspace(context.Context, *clouddmspb.GetConversionWorkspaceRequest, ...gax.CallOption) (*clouddmspb.ConversionWorkspace, error)
	ListConversionWorkspaces(context.Context, *clouddmspb.ListConversionWorkspacesRequest, ...gax.CallOption) *ConversionWorkspaceIterator
	CreateConversionWorkspace(context.Context, *clouddmspb.CreateConversionWorkspaceRequest, ...gax.CallOption) (*CreateConversionWorkspaceOperation, error)
	CreateConversionWorkspaceOperation(name string) *CreateConversionWorkspaceOperation
	UpdateConversionWorkspace(context.Context, *clouddmspb.UpdateConversionWorkspaceRequest, ...gax.CallOption) (*UpdateConversionWorkspaceOperation, error)
	UpdateConversionWorkspaceOperation(name string) *UpdateConversionWorkspaceOperation
	DeleteConversionWorkspace(context.Context, *clouddmspb.DeleteConversionWorkspaceRequest, ...gax.CallOption) (*DeleteConversionWorkspaceOperation, error)
	DeleteConversionWorkspaceOperation(name string) *DeleteConversionWorkspaceOperation
	CreateMappingRule(context.Context, *clouddmspb.CreateMappingRuleRequest, ...gax.CallOption) (*clouddmspb.MappingRule, error)
	DeleteMappingRule(context.Context, *clouddmspb.DeleteMappingRuleRequest, ...gax.CallOption) error
	ListMappingRules(context.Context, *clouddmspb.ListMappingRulesRequest, ...gax.CallOption) *MappingRuleIterator
	GetMappingRule(context.Context, *clouddmspb.GetMappingRuleRequest, ...gax.CallOption) (*clouddmspb.MappingRule, error)
	SeedConversionWorkspace(context.Context, *clouddmspb.SeedConversionWorkspaceRequest, ...gax.CallOption) (*SeedConversionWorkspaceOperation, error)
	SeedConversionWorkspaceOperation(name string) *SeedConversionWorkspaceOperation
	ImportMappingRules(context.Context, *clouddmspb.ImportMappingRulesRequest, ...gax.CallOption) (*ImportMappingRulesOperation, error)
	ImportMappingRulesOperation(name string) *ImportMappingRulesOperation
	ConvertConversionWorkspace(context.Context, *clouddmspb.ConvertConversionWorkspaceRequest, ...gax.CallOption) (*ConvertConversionWorkspaceOperation, error)
	ConvertConversionWorkspaceOperation(name string) *ConvertConversionWorkspaceOperation
	CommitConversionWorkspace(context.Context, *clouddmspb.CommitConversionWorkspaceRequest, ...gax.CallOption) (*CommitConversionWorkspaceOperation, error)
	CommitConversionWorkspaceOperation(name string) *CommitConversionWorkspaceOperation
	RollbackConversionWorkspace(context.Context, *clouddmspb.RollbackConversionWorkspaceRequest, ...gax.CallOption) (*RollbackConversionWorkspaceOperation, error)
	RollbackConversionWorkspaceOperation(name string) *RollbackConversionWorkspaceOperation
	ApplyConversionWorkspace(context.Context, *clouddmspb.ApplyConversionWorkspaceRequest, ...gax.CallOption) (*ApplyConversionWorkspaceOperation, error)
	ApplyConversionWorkspaceOperation(name string) *ApplyConversionWorkspaceOperation
	DescribeDatabaseEntities(context.Context, *clouddmspb.DescribeDatabaseEntitiesRequest, ...gax.CallOption) *DatabaseEntityIterator
	SearchBackgroundJobs(context.Context, *clouddmspb.SearchBackgroundJobsRequest, ...gax.CallOption) (*clouddmspb.SearchBackgroundJobsResponse, error)
	DescribeConversionWorkspaceRevisions(context.Context, *clouddmspb.DescribeConversionWorkspaceRevisionsRequest, ...gax.CallOption) (*clouddmspb.DescribeConversionWorkspaceRevisionsResponse, error)
	FetchStaticIps(context.Context, *clouddmspb.FetchStaticIpsRequest, ...gax.CallOption) *StringIterator
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// DataMigrationClient is a client for interacting with Database Migration API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Database Migration service
type DataMigrationClient struct {
	// The internal transport-dependent client.
	internalClient internalDataMigrationClient

	// The call options for this service.
	CallOptions *DataMigrationCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *DataMigrationClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *DataMigrationClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *DataMigrationClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListMigrationJobs lists migration jobs in a given project and location.
func (c *DataMigrationClient) ListMigrationJobs(ctx context.Context, req *clouddmspb.ListMigrationJobsRequest, opts ...gax.CallOption) *MigrationJobIterator {
	return c.internalClient.ListMigrationJobs(ctx, req, opts...)
}

// GetMigrationJob gets details of a single migration job.
func (c *DataMigrationClient) GetMigrationJob(ctx context.Context, req *clouddmspb.GetMigrationJobRequest, opts ...gax.CallOption) (*clouddmspb.MigrationJob, error) {
	return c.internalClient.GetMigrationJob(ctx, req, opts...)
}

// CreateMigrationJob creates a new migration job in a given project and location.
func (c *DataMigrationClient) CreateMigrationJob(ctx context.Context, req *clouddmspb.CreateMigrationJobRequest, opts ...gax.CallOption) (*CreateMigrationJobOperation, error) {
	return c.internalClient.CreateMigrationJob(ctx, req, opts...)
}

// CreateMigrationJobOperation returns a new CreateMigrationJobOperation from a given name.
// The name must be that of a previously created CreateMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) CreateMigrationJobOperation(name string) *CreateMigrationJobOperation {
	return c.internalClient.CreateMigrationJobOperation(name)
}

// UpdateMigrationJob updates the parameters of a single migration job.
func (c *DataMigrationClient) UpdateMigrationJob(ctx context.Context, req *clouddmspb.UpdateMigrationJobRequest, opts ...gax.CallOption) (*UpdateMigrationJobOperation, error) {
	return c.internalClient.UpdateMigrationJob(ctx, req, opts...)
}

// UpdateMigrationJobOperation returns a new UpdateMigrationJobOperation from a given name.
// The name must be that of a previously created UpdateMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) UpdateMigrationJobOperation(name string) *UpdateMigrationJobOperation {
	return c.internalClient.UpdateMigrationJobOperation(name)
}

// DeleteMigrationJob deletes a single migration job.
func (c *DataMigrationClient) DeleteMigrationJob(ctx context.Context, req *clouddmspb.DeleteMigrationJobRequest, opts ...gax.CallOption) (*DeleteMigrationJobOperation, error) {
	return c.internalClient.DeleteMigrationJob(ctx, req, opts...)
}

// DeleteMigrationJobOperation returns a new DeleteMigrationJobOperation from a given name.
// The name must be that of a previously created DeleteMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) DeleteMigrationJobOperation(name string) *DeleteMigrationJobOperation {
	return c.internalClient.DeleteMigrationJobOperation(name)
}

// StartMigrationJob start an already created migration job.
func (c *DataMigrationClient) StartMigrationJob(ctx context.Context, req *clouddmspb.StartMigrationJobRequest, opts ...gax.CallOption) (*StartMigrationJobOperation, error) {
	return c.internalClient.StartMigrationJob(ctx, req, opts...)
}

// StartMigrationJobOperation returns a new StartMigrationJobOperation from a given name.
// The name must be that of a previously created StartMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) StartMigrationJobOperation(name string) *StartMigrationJobOperation {
	return c.internalClient.StartMigrationJobOperation(name)
}

// StopMigrationJob stops a running migration job.
func (c *DataMigrationClient) StopMigrationJob(ctx context.Context, req *clouddmspb.StopMigrationJobRequest, opts ...gax.CallOption) (*StopMigrationJobOperation, error) {
	return c.internalClient.StopMigrationJob(ctx, req, opts...)
}

// StopMigrationJobOperation returns a new StopMigrationJobOperation from a given name.
// The name must be that of a previously created StopMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) StopMigrationJobOperation(name string) *StopMigrationJobOperation {
	return c.internalClient.StopMigrationJobOperation(name)
}

// ResumeMigrationJob resume a migration job that is currently stopped and is resumable (was
// stopped during CDC phase).
func (c *DataMigrationClient) ResumeMigrationJob(ctx context.Context, req *clouddmspb.ResumeMigrationJobRequest, opts ...gax.CallOption) (*ResumeMigrationJobOperation, error) {
	return c.internalClient.ResumeMigrationJob(ctx, req, opts...)
}

// ResumeMigrationJobOperation returns a new ResumeMigrationJobOperation from a given name.
// The name must be that of a previously created ResumeMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) ResumeMigrationJobOperation(name string) *ResumeMigrationJobOperation {
	return c.internalClient.ResumeMigrationJobOperation(name)
}

// PromoteMigrationJob promote a migration job, stopping replication to the destination and
// promoting the destination to be a standalone database.
func (c *DataMigrationClient) PromoteMigrationJob(ctx context.Context, req *clouddmspb.PromoteMigrationJobRequest, opts ...gax.CallOption) (*PromoteMigrationJobOperation, error) {
	return c.internalClient.PromoteMigrationJob(ctx, req, opts...)
}

// PromoteMigrationJobOperation returns a new PromoteMigrationJobOperation from a given name.
// The name must be that of a previously created PromoteMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) PromoteMigrationJobOperation(name string) *PromoteMigrationJobOperation {
	return c.internalClient.PromoteMigrationJobOperation(name)
}

// VerifyMigrationJob verify a migration job, making sure the destination can reach the source
// and that all configuration and prerequisites are met.
func (c *DataMigrationClient) VerifyMigrationJob(ctx context.Context, req *clouddmspb.VerifyMigrationJobRequest, opts ...gax.CallOption) (*VerifyMigrationJobOperation, error) {
	return c.internalClient.VerifyMigrationJob(ctx, req, opts...)
}

// VerifyMigrationJobOperation returns a new VerifyMigrationJobOperation from a given name.
// The name must be that of a previously created VerifyMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) VerifyMigrationJobOperation(name string) *VerifyMigrationJobOperation {
	return c.internalClient.VerifyMigrationJobOperation(name)
}

// RestartMigrationJob restart a stopped or failed migration job, resetting the destination
// instance to its original state and starting the migration process from
// scratch.
func (c *DataMigrationClient) RestartMigrationJob(ctx context.Context, req *clouddmspb.RestartMigrationJobRequest, opts ...gax.CallOption) (*RestartMigrationJobOperation, error) {
	return c.internalClient.RestartMigrationJob(ctx, req, opts...)
}

// RestartMigrationJobOperation returns a new RestartMigrationJobOperation from a given name.
// The name must be that of a previously created RestartMigrationJobOperation, possibly from a different process.
func (c *DataMigrationClient) RestartMigrationJobOperation(name string) *RestartMigrationJobOperation {
	return c.internalClient.RestartMigrationJobOperation(name)
}

// GenerateSshScript generate a SSH configuration script to configure the reverse SSH
// connectivity.
func (c *DataMigrationClient) GenerateSshScript(ctx context.Context, req *clouddmspb.GenerateSshScriptRequest, opts ...gax.CallOption) (*clouddmspb.SshScript, error) {
	return c.internalClient.GenerateSshScript(ctx, req, opts...)
}

// GenerateTcpProxyScript generate a TCP Proxy configuration script to configure a cloud-hosted VM
// running a TCP Proxy.
func (c *DataMigrationClient) GenerateTcpProxyScript(ctx context.Context, req *clouddmspb.GenerateTcpProxyScriptRequest, opts ...gax.CallOption) (*clouddmspb.TcpProxyScript, error) {
	return c.internalClient.GenerateTcpProxyScript(ctx, req, opts...)
}

// ListConnectionProfiles retrieves a list of all connection profiles in a given project and
// location.
func (c *DataMigrationClient) ListConnectionProfiles(ctx context.Context, req *clouddmspb.ListConnectionProfilesRequest, opts ...gax.CallOption) *ConnectionProfileIterator {
	return c.internalClient.ListConnectionProfiles(ctx, req, opts...)
}

// GetConnectionProfile gets details of a single connection profile.
func (c *DataMigrationClient) GetConnectionProfile(ctx context.Context, req *clouddmspb.GetConnectionProfileRequest, opts ...gax.CallOption) (*clouddmspb.ConnectionProfile, error) {
	return c.internalClient.GetConnectionProfile(ctx, req, opts...)
}

// CreateConnectionProfile creates a new connection profile in a given project and location.
func (c *DataMigrationClient) CreateConnectionProfile(ctx context.Context, req *clouddmspb.CreateConnectionProfileRequest, opts ...gax.CallOption) (*CreateConnectionProfileOperation, error) {
	return c.internalClient.CreateConnectionProfile(ctx, req, opts...)
}

// CreateConnectionProfileOperation returns a new CreateConnectionProfileOperation from a given name.
// The name must be that of a previously created CreateConnectionProfileOperation, possibly from a different process.
func (c *DataMigrationClient) CreateConnectionProfileOperation(name string) *CreateConnectionProfileOperation {
	return c.internalClient.CreateConnectionProfileOperation(name)
}

// UpdateConnectionProfile update the configuration of a single connection profile.
func (c *DataMigrationClient) UpdateConnectionProfile(ctx context.Context, req *clouddmspb.UpdateConnectionProfileRequest, opts ...gax.CallOption) (*UpdateConnectionProfileOperation, error) {
	return c.internalClient.UpdateConnectionProfile(ctx, req, opts...)
}

// UpdateConnectionProfileOperation returns a new UpdateConnectionProfileOperation from a given name.
// The name must be that of a previously created UpdateConnectionProfileOperation, possibly from a different process.
func (c *DataMigrationClient) UpdateConnectionProfileOperation(name string) *UpdateConnectionProfileOperation {
	return c.internalClient.UpdateConnectionProfileOperation(name)
}

// DeleteConnectionProfile deletes a single Database Migration Service connection profile.
// A connection profile can only be deleted if it is not in use by any
// active migration jobs.
func (c *DataMigrationClient) DeleteConnectionProfile(ctx context.Context, req *clouddmspb.DeleteConnectionProfileRequest, opts ...gax.CallOption) (*DeleteConnectionProfileOperation, error) {
	return c.internalClient.DeleteConnectionProfile(ctx, req, opts...)
}

// DeleteConnectionProfileOperation returns a new DeleteConnectionProfileOperation from a given name.
// The name must be that of a previously created DeleteConnectionProfileOperation, possibly from a different process.
func (c *DataMigrationClient) DeleteConnectionProfileOperation(name string) *DeleteConnectionProfileOperation {
	return c.internalClient.DeleteConnectionProfileOperation(name)
}

// CreatePrivateConnection creates a new private connection in a given project and location.
func (c *DataMigrationClient) CreatePrivateConnection(ctx context.Context, req *clouddmspb.CreatePrivateConnectionRequest, opts ...gax.CallOption) (*CreatePrivateConnectionOperation, error) {
	return c.internalClient.CreatePrivateConnection(ctx, req, opts...)
}

// CreatePrivateConnectionOperation returns a new CreatePrivateConnectionOperation from a given name.
// The name must be that of a previously created CreatePrivateConnectionOperation, possibly from a different process.
func (c *DataMigrationClient) CreatePrivateConnectionOperation(name string) *CreatePrivateConnectionOperation {
	return c.internalClient.CreatePrivateConnectionOperation(name)
}

// GetPrivateConnection gets details of a single private connection.
func (c *DataMigrationClient) GetPrivateConnection(ctx context.Context, req *clouddmspb.GetPrivateConnectionRequest, opts ...gax.CallOption) (*clouddmspb.PrivateConnection, error) {
	return c.internalClient.GetPrivateConnection(ctx, req, opts...)
}

// ListPrivateConnections retrieves a list of private connections in a given project and location.
func (c *DataMigrationClient) ListPrivateConnections(ctx context.Context, req *clouddmspb.ListPrivateConnectionsRequest, opts ...gax.CallOption) *PrivateConnectionIterator {
	return c.internalClient.ListPrivateConnections(ctx, req, opts...)
}

// DeletePrivateConnection deletes a single Database Migration Service private connection.
func (c *DataMigrationClient) DeletePrivateConnection(ctx context.Context, req *clouddmspb.DeletePrivateConnectionRequest, opts ...gax.CallOption) (*DeletePrivateConnectionOperation, error) {
	return c.internalClient.DeletePrivateConnection(ctx, req, opts...)
}

// DeletePrivateConnectionOperation returns a new DeletePrivateConnectionOperation from a given name.
// The name must be that of a previously created DeletePrivateConnectionOperation, possibly from a different process.
func (c *DataMigrationClient) DeletePrivateConnectionOperation(name string) *DeletePrivateConnectionOperation {
	return c.internalClient.DeletePrivateConnectionOperation(name)
}

// GetConversionWorkspace gets details of a single conversion workspace.
func (c *DataMigrationClient) GetConversionWorkspace(ctx context.Context, req *clouddmspb.GetConversionWorkspaceRequest, opts ...gax.CallOption) (*clouddmspb.ConversionWorkspace, error) {
	return c.internalClient.GetConversionWorkspace(ctx, req, opts...)
}

// ListConversionWorkspaces lists conversion workspaces in a given project and location.
func (c *DataMigrationClient) ListConversionWorkspaces(ctx context.Context, req *clouddmspb.ListConversionWorkspacesRequest, opts ...gax.CallOption) *ConversionWorkspaceIterator {
	return c.internalClient.ListConversionWorkspaces(ctx, req, opts...)
}

// CreateConversionWorkspace creates a new conversion workspace in a given project and location.
func (c *DataMigrationClient) CreateConversionWorkspace(ctx context.Context, req *clouddmspb.CreateConversionWorkspaceRequest, opts ...gax.CallOption) (*CreateConversionWorkspaceOperation, error) {
	return c.internalClient.CreateConversionWorkspace(ctx, req, opts...)
}

// CreateConversionWorkspaceOperation returns a new CreateConversionWorkspaceOperation from a given name.
// The name must be that of a previously created CreateConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) CreateConversionWorkspaceOperation(name string) *CreateConversionWorkspaceOperation {
	return c.internalClient.CreateConversionWorkspaceOperation(name)
}

// UpdateConversionWorkspace updates the parameters of a single conversion workspace.
func (c *DataMigrationClient) UpdateConversionWorkspace(ctx context.Context, req *clouddmspb.UpdateConversionWorkspaceRequest, opts ...gax.CallOption) (*UpdateConversionWorkspaceOperation, error) {
	return c.internalClient.UpdateConversionWorkspace(ctx, req, opts...)
}

// UpdateConversionWorkspaceOperation returns a new UpdateConversionWorkspaceOperation from a given name.
// The name must be that of a previously created UpdateConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) UpdateConversionWorkspaceOperation(name string) *UpdateConversionWorkspaceOperation {
	return c.internalClient.UpdateConversionWorkspaceOperation(name)
}

// DeleteConversionWorkspace deletes a single conversion workspace.
func (c *DataMigrationClient) DeleteConversionWorkspace(ctx context.Context, req *clouddmspb.DeleteConversionWorkspaceRequest, opts ...gax.CallOption) (*DeleteConversionWorkspaceOperation, error) {
	return c.internalClient.DeleteConversionWorkspace(ctx, req, opts...)
}

// DeleteConversionWorkspaceOperation returns a new DeleteConversionWorkspaceOperation from a given name.
// The name must be that of a previously created DeleteConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) DeleteConversionWorkspaceOperation(name string) *DeleteConversionWorkspaceOperation {
	return c.internalClient.DeleteConversionWorkspaceOperation(name)
}

// CreateMappingRule creates a new mapping rule for a given conversion workspace.
func (c *DataMigrationClient) CreateMappingRule(ctx context.Context, req *clouddmspb.CreateMappingRuleRequest, opts ...gax.CallOption) (*clouddmspb.MappingRule, error) {
	return c.internalClient.CreateMappingRule(ctx, req, opts...)
}

// DeleteMappingRule deletes a single mapping rule.
func (c *DataMigrationClient) DeleteMappingRule(ctx context.Context, req *clouddmspb.DeleteMappingRuleRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteMappingRule(ctx, req, opts...)
}

// ListMappingRules lists the mapping rules for a specific conversion workspace.
func (c *DataMigrationClient) ListMappingRules(ctx context.Context, req *clouddmspb.ListMappingRulesRequest, opts ...gax.CallOption) *MappingRuleIterator {
	return c.internalClient.ListMappingRules(ctx, req, opts...)
}

// GetMappingRule gets the details of a mapping rule.
func (c *DataMigrationClient) GetMappingRule(ctx context.Context, req *clouddmspb.GetMappingRuleRequest, opts ...gax.CallOption) (*clouddmspb.MappingRule, error) {
	return c.internalClient.GetMappingRule(ctx, req, opts...)
}

// SeedConversionWorkspace imports a snapshot of the source database into the
// conversion workspace.
func (c *DataMigrationClient) SeedConversionWorkspace(ctx context.Context, req *clouddmspb.SeedConversionWorkspaceRequest, opts ...gax.CallOption) (*SeedConversionWorkspaceOperation, error) {
	return c.internalClient.SeedConversionWorkspace(ctx, req, opts...)
}

// SeedConversionWorkspaceOperation returns a new SeedConversionWorkspaceOperation from a given name.
// The name must be that of a previously created SeedConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) SeedConversionWorkspaceOperation(name string) *SeedConversionWorkspaceOperation {
	return c.internalClient.SeedConversionWorkspaceOperation(name)
}

// ImportMappingRules imports the mapping rules for a given conversion workspace.
// Supports various formats of external rules files.
func (c *DataMigrationClient) ImportMappingRules(ctx context.Context, req *clouddmspb.ImportMappingRulesRequest, opts ...gax.CallOption) (*ImportMappingRulesOperation, error) {
	return c.internalClient.ImportMappingRules(ctx, req, opts...)
}

// ImportMappingRulesOperation returns a new ImportMappingRulesOperation from a given name.
// The name must be that of a previously created ImportMappingRulesOperation, possibly from a different process.
func (c *DataMigrationClient) ImportMappingRulesOperation(name string) *ImportMappingRulesOperation {
	return c.internalClient.ImportMappingRulesOperation(name)
}

// ConvertConversionWorkspace creates a draft tree schema for the destination database.
func (c *DataMigrationClient) ConvertConversionWorkspace(ctx context.Context, req *clouddmspb.ConvertConversionWorkspaceRequest, opts ...gax.CallOption) (*ConvertConversionWorkspaceOperation, error) {
	return c.internalClient.ConvertConversionWorkspace(ctx, req, opts...)
}

// ConvertConversionWorkspaceOperation returns a new ConvertConversionWorkspaceOperation from a given name.
// The name must be that of a previously created ConvertConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) ConvertConversionWorkspaceOperation(name string) *ConvertConversionWorkspaceOperation {
	return c.internalClient.ConvertConversionWorkspaceOperation(name)
}

// CommitConversionWorkspace marks all the data in the conversion workspace as committed.
func (c *DataMigrationClient) CommitConversionWorkspace(ctx context.Context, req *clouddmspb.CommitConversionWorkspaceRequest, opts ...gax.CallOption) (*CommitConversionWorkspaceOperation, error) {
	return c.internalClient.CommitConversionWorkspace(ctx, req, opts...)
}

// CommitConversionWorkspaceOperation returns a new CommitConversionWorkspaceOperation from a given name.
// The name must be that of a previously created CommitConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) CommitConversionWorkspaceOperation(name string) *CommitConversionWorkspaceOperation {
	return c.internalClient.CommitConversionWorkspaceOperation(name)
}

// RollbackConversionWorkspace rolls back a conversion workspace to the last committed snapshot.
func (c *DataMigrationClient) RollbackConversionWorkspace(ctx context.Context, req *clouddmspb.RollbackConversionWorkspaceRequest, opts ...gax.CallOption) (*RollbackConversionWorkspaceOperation, error) {
	return c.internalClient.RollbackConversionWorkspace(ctx, req, opts...)
}

// RollbackConversionWorkspaceOperation returns a new RollbackConversionWorkspaceOperation from a given name.
// The name must be that of a previously created RollbackConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) RollbackConversionWorkspaceOperation(name string) *RollbackConversionWorkspaceOperation {
	return c.internalClient.RollbackConversionWorkspaceOperation(name)
}

// ApplyConversionWorkspace applies draft tree onto a specific destination database.
func (c *DataMigrationClient) ApplyConversionWorkspace(ctx context.Context, req *clouddmspb.ApplyConversionWorkspaceRequest, opts ...gax.CallOption) (*ApplyConversionWorkspaceOperation, error) {
	return c.internalClient.ApplyConversionWorkspace(ctx, req, opts...)
}

// ApplyConversionWorkspaceOperation returns a new ApplyConversionWorkspaceOperation from a given name.
// The name must be that of a previously created ApplyConversionWorkspaceOperation, possibly from a different process.
func (c *DataMigrationClient) ApplyConversionWorkspaceOperation(name string) *ApplyConversionWorkspaceOperation {
	return c.internalClient.ApplyConversionWorkspaceOperation(name)
}

// DescribeDatabaseEntities describes the database entities tree for a specific conversion workspace
// and a specific tree type.
//
// Database entities are not resources like conversion workspaces or mapping
// rules, and they can’t be created, updated or deleted. Instead, they are
// simple data objects describing the structure of the client database.
func (c *DataMigrationClient) DescribeDatabaseEntities(ctx context.Context, req *clouddmspb.DescribeDatabaseEntitiesRequest, opts ...gax.CallOption) *DatabaseEntityIterator {
	return c.internalClient.DescribeDatabaseEntities(ctx, req, opts...)
}

// SearchBackgroundJobs searches/lists the background jobs for a specific
// conversion workspace.
//
// The background jobs are not resources like conversion workspaces or
// mapping rules, and they can’t be created, updated or deleted.
// Instead, they are a way to expose the data plane jobs log.
func (c *DataMigrationClient) SearchBackgroundJobs(ctx context.Context, req *clouddmspb.SearchBackgroundJobsRequest, opts ...gax.CallOption) (*clouddmspb.SearchBackgroundJobsResponse, error) {
	return c.internalClient.SearchBackgroundJobs(ctx, req, opts...)
}

// DescribeConversionWorkspaceRevisions retrieves a list of committed revisions of a specific conversion
// workspace.
func (c *DataMigrationClient) DescribeConversionWorkspaceRevisions(ctx context.Context, req *clouddmspb.DescribeConversionWorkspaceRevisionsRequest, opts ...gax.CallOption) (*clouddmspb.DescribeConversionWorkspaceRevisionsResponse, error) {
	return c.internalClient.DescribeConversionWorkspaceRevisions(ctx, req, opts...)
}

// FetchStaticIps fetches a set of static IP addresses that need to be allowlisted by the
// customer when using the static-IP connectivity method.
func (c *DataMigrationClient) FetchStaticIps(ctx context.Context, req *clouddmspb.FetchStaticIpsRequest, opts ...gax.CallOption) *StringIterator {
	return c.internalClient.FetchStaticIps(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *DataMigrationClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *DataMigrationClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *DataMigrationClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *DataMigrationClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *DataMigrationClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *DataMigrationClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *DataMigrationClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *DataMigrationClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *DataMigrationClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// dataMigrationGRPCClient is a client for interacting with Database Migration API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type dataMigrationGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing DataMigrationClient
	CallOptions **DataMigrationCallOptions

	// The gRPC API client.
	dataMigrationClient clouddmspb.DataMigrationServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string
}

// NewDataMigrationClient creates a new data migration service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Database Migration service
func NewDataMigrationClient(ctx context.Context, opts ...option.ClientOption) (*DataMigrationClient, error) {
	clientOpts := defaultDataMigrationGRPCClientOptions()
	if newDataMigrationClientHook != nil {
		hookOpts, err := newDataMigrationClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := DataMigrationClient{CallOptions: defaultDataMigrationCallOptions()}

	c := &dataMigrationGRPCClient{
		connPool:            connPool,
		dataMigrationClient: clouddmspb.NewDataMigrationServiceClient(connPool),
		CallOptions:         &client.CallOptions,
		operationsClient:    longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:     iampb.NewIAMPolicyClient(connPool),
		locationsClient:     locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *dataMigrationGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *dataMigrationGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{"x-goog-api-client", gax.XGoogHeader(kv...)}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *dataMigrationGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *dataMigrationGRPCClient) ListMigrationJobs(ctx context.Context, req *clouddmspb.ListMigrationJobsRequest, opts ...gax.CallOption) *MigrationJobIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMigrationJobs[0:len((*c.CallOptions).ListMigrationJobs):len((*c.CallOptions).ListMigrationJobs)], opts...)
	it := &MigrationJobIterator{}
	req = proto.Clone(req).(*clouddmspb.ListMigrationJobsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.MigrationJob, string, error) {
		resp := &clouddmspb.ListMigrationJobsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.ListMigrationJobs(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMigrationJobs(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) GetMigrationJob(ctx context.Context, req *clouddmspb.GetMigrationJobRequest, opts ...gax.CallOption) (*clouddmspb.MigrationJob, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMigrationJob[0:len((*c.CallOptions).GetMigrationJob):len((*c.CallOptions).GetMigrationJob)], opts...)
	var resp *clouddmspb.MigrationJob
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GetMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) CreateMigrationJob(ctx context.Context, req *clouddmspb.CreateMigrationJobRequest, opts ...gax.CallOption) (*CreateMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMigrationJob[0:len((*c.CallOptions).CreateMigrationJob):len((*c.CallOptions).CreateMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CreateMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) UpdateMigrationJob(ctx context.Context, req *clouddmspb.UpdateMigrationJobRequest, opts ...gax.CallOption) (*UpdateMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migration_job.name", url.QueryEscape(req.GetMigrationJob().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateMigrationJob[0:len((*c.CallOptions).UpdateMigrationJob):len((*c.CallOptions).UpdateMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.UpdateMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) DeleteMigrationJob(ctx context.Context, req *clouddmspb.DeleteMigrationJobRequest, opts ...gax.CallOption) (*DeleteMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMigrationJob[0:len((*c.CallOptions).DeleteMigrationJob):len((*c.CallOptions).DeleteMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.DeleteMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) StartMigrationJob(ctx context.Context, req *clouddmspb.StartMigrationJobRequest, opts ...gax.CallOption) (*StartMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartMigrationJob[0:len((*c.CallOptions).StartMigrationJob):len((*c.CallOptions).StartMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.StartMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) StopMigrationJob(ctx context.Context, req *clouddmspb.StopMigrationJobRequest, opts ...gax.CallOption) (*StopMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopMigrationJob[0:len((*c.CallOptions).StopMigrationJob):len((*c.CallOptions).StopMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.StopMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) ResumeMigrationJob(ctx context.Context, req *clouddmspb.ResumeMigrationJobRequest, opts ...gax.CallOption) (*ResumeMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResumeMigrationJob[0:len((*c.CallOptions).ResumeMigrationJob):len((*c.CallOptions).ResumeMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.ResumeMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResumeMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) PromoteMigrationJob(ctx context.Context, req *clouddmspb.PromoteMigrationJobRequest, opts ...gax.CallOption) (*PromoteMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).PromoteMigrationJob[0:len((*c.CallOptions).PromoteMigrationJob):len((*c.CallOptions).PromoteMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.PromoteMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &PromoteMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) VerifyMigrationJob(ctx context.Context, req *clouddmspb.VerifyMigrationJobRequest, opts ...gax.CallOption) (*VerifyMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).VerifyMigrationJob[0:len((*c.CallOptions).VerifyMigrationJob):len((*c.CallOptions).VerifyMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.VerifyMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &VerifyMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) RestartMigrationJob(ctx context.Context, req *clouddmspb.RestartMigrationJobRequest, opts ...gax.CallOption) (*RestartMigrationJobOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RestartMigrationJob[0:len((*c.CallOptions).RestartMigrationJob):len((*c.CallOptions).RestartMigrationJob)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.RestartMigrationJob(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RestartMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) GenerateSshScript(ctx context.Context, req *clouddmspb.GenerateSshScriptRequest, opts ...gax.CallOption) (*clouddmspb.SshScript, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migration_job", url.QueryEscape(req.GetMigrationJob()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateSshScript[0:len((*c.CallOptions).GenerateSshScript):len((*c.CallOptions).GenerateSshScript)], opts...)
	var resp *clouddmspb.SshScript
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GenerateSshScript(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) GenerateTcpProxyScript(ctx context.Context, req *clouddmspb.GenerateTcpProxyScriptRequest, opts ...gax.CallOption) (*clouddmspb.TcpProxyScript, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "migration_job", url.QueryEscape(req.GetMigrationJob()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GenerateTcpProxyScript[0:len((*c.CallOptions).GenerateTcpProxyScript):len((*c.CallOptions).GenerateTcpProxyScript)], opts...)
	var resp *clouddmspb.TcpProxyScript
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GenerateTcpProxyScript(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) ListConnectionProfiles(ctx context.Context, req *clouddmspb.ListConnectionProfilesRequest, opts ...gax.CallOption) *ConnectionProfileIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListConnectionProfiles[0:len((*c.CallOptions).ListConnectionProfiles):len((*c.CallOptions).ListConnectionProfiles)], opts...)
	it := &ConnectionProfileIterator{}
	req = proto.Clone(req).(*clouddmspb.ListConnectionProfilesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.ConnectionProfile, string, error) {
		resp := &clouddmspb.ListConnectionProfilesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.ListConnectionProfiles(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetConnectionProfiles(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) GetConnectionProfile(ctx context.Context, req *clouddmspb.GetConnectionProfileRequest, opts ...gax.CallOption) (*clouddmspb.ConnectionProfile, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetConnectionProfile[0:len((*c.CallOptions).GetConnectionProfile):len((*c.CallOptions).GetConnectionProfile)], opts...)
	var resp *clouddmspb.ConnectionProfile
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GetConnectionProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) CreateConnectionProfile(ctx context.Context, req *clouddmspb.CreateConnectionProfileRequest, opts ...gax.CallOption) (*CreateConnectionProfileOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateConnectionProfile[0:len((*c.CallOptions).CreateConnectionProfile):len((*c.CallOptions).CreateConnectionProfile)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CreateConnectionProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) UpdateConnectionProfile(ctx context.Context, req *clouddmspb.UpdateConnectionProfileRequest, opts ...gax.CallOption) (*UpdateConnectionProfileOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "connection_profile.name", url.QueryEscape(req.GetConnectionProfile().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateConnectionProfile[0:len((*c.CallOptions).UpdateConnectionProfile):len((*c.CallOptions).UpdateConnectionProfile)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.UpdateConnectionProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) DeleteConnectionProfile(ctx context.Context, req *clouddmspb.DeleteConnectionProfileRequest, opts ...gax.CallOption) (*DeleteConnectionProfileOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteConnectionProfile[0:len((*c.CallOptions).DeleteConnectionProfile):len((*c.CallOptions).DeleteConnectionProfile)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.DeleteConnectionProfile(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) CreatePrivateConnection(ctx context.Context, req *clouddmspb.CreatePrivateConnectionRequest, opts ...gax.CallOption) (*CreatePrivateConnectionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreatePrivateConnection[0:len((*c.CallOptions).CreatePrivateConnection):len((*c.CallOptions).CreatePrivateConnection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CreatePrivateConnection(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreatePrivateConnectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) GetPrivateConnection(ctx context.Context, req *clouddmspb.GetPrivateConnectionRequest, opts ...gax.CallOption) (*clouddmspb.PrivateConnection, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPrivateConnection[0:len((*c.CallOptions).GetPrivateConnection):len((*c.CallOptions).GetPrivateConnection)], opts...)
	var resp *clouddmspb.PrivateConnection
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GetPrivateConnection(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) ListPrivateConnections(ctx context.Context, req *clouddmspb.ListPrivateConnectionsRequest, opts ...gax.CallOption) *PrivateConnectionIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPrivateConnections[0:len((*c.CallOptions).ListPrivateConnections):len((*c.CallOptions).ListPrivateConnections)], opts...)
	it := &PrivateConnectionIterator{}
	req = proto.Clone(req).(*clouddmspb.ListPrivateConnectionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.PrivateConnection, string, error) {
		resp := &clouddmspb.ListPrivateConnectionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.ListPrivateConnections(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPrivateConnections(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) DeletePrivateConnection(ctx context.Context, req *clouddmspb.DeletePrivateConnectionRequest, opts ...gax.CallOption) (*DeletePrivateConnectionOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeletePrivateConnection[0:len((*c.CallOptions).DeletePrivateConnection):len((*c.CallOptions).DeletePrivateConnection)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.DeletePrivateConnection(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeletePrivateConnectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) GetConversionWorkspace(ctx context.Context, req *clouddmspb.GetConversionWorkspaceRequest, opts ...gax.CallOption) (*clouddmspb.ConversionWorkspace, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetConversionWorkspace[0:len((*c.CallOptions).GetConversionWorkspace):len((*c.CallOptions).GetConversionWorkspace)], opts...)
	var resp *clouddmspb.ConversionWorkspace
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GetConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) ListConversionWorkspaces(ctx context.Context, req *clouddmspb.ListConversionWorkspacesRequest, opts ...gax.CallOption) *ConversionWorkspaceIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListConversionWorkspaces[0:len((*c.CallOptions).ListConversionWorkspaces):len((*c.CallOptions).ListConversionWorkspaces)], opts...)
	it := &ConversionWorkspaceIterator{}
	req = proto.Clone(req).(*clouddmspb.ListConversionWorkspacesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.ConversionWorkspace, string, error) {
		resp := &clouddmspb.ListConversionWorkspacesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.ListConversionWorkspaces(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetConversionWorkspaces(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) CreateConversionWorkspace(ctx context.Context, req *clouddmspb.CreateConversionWorkspaceRequest, opts ...gax.CallOption) (*CreateConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateConversionWorkspace[0:len((*c.CallOptions).CreateConversionWorkspace):len((*c.CallOptions).CreateConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CreateConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) UpdateConversionWorkspace(ctx context.Context, req *clouddmspb.UpdateConversionWorkspaceRequest, opts ...gax.CallOption) (*UpdateConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "conversion_workspace.name", url.QueryEscape(req.GetConversionWorkspace().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateConversionWorkspace[0:len((*c.CallOptions).UpdateConversionWorkspace):len((*c.CallOptions).UpdateConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.UpdateConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) DeleteConversionWorkspace(ctx context.Context, req *clouddmspb.DeleteConversionWorkspaceRequest, opts ...gax.CallOption) (*DeleteConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteConversionWorkspace[0:len((*c.CallOptions).DeleteConversionWorkspace):len((*c.CallOptions).DeleteConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.DeleteConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) CreateMappingRule(ctx context.Context, req *clouddmspb.CreateMappingRuleRequest, opts ...gax.CallOption) (*clouddmspb.MappingRule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateMappingRule[0:len((*c.CallOptions).CreateMappingRule):len((*c.CallOptions).CreateMappingRule)], opts...)
	var resp *clouddmspb.MappingRule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CreateMappingRule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) DeleteMappingRule(ctx context.Context, req *clouddmspb.DeleteMappingRuleRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteMappingRule[0:len((*c.CallOptions).DeleteMappingRule):len((*c.CallOptions).DeleteMappingRule)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.dataMigrationClient.DeleteMappingRule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *dataMigrationGRPCClient) ListMappingRules(ctx context.Context, req *clouddmspb.ListMappingRulesRequest, opts ...gax.CallOption) *MappingRuleIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListMappingRules[0:len((*c.CallOptions).ListMappingRules):len((*c.CallOptions).ListMappingRules)], opts...)
	it := &MappingRuleIterator{}
	req = proto.Clone(req).(*clouddmspb.ListMappingRulesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.MappingRule, string, error) {
		resp := &clouddmspb.ListMappingRulesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.ListMappingRules(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetMappingRules(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) GetMappingRule(ctx context.Context, req *clouddmspb.GetMappingRuleRequest, opts ...gax.CallOption) (*clouddmspb.MappingRule, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetMappingRule[0:len((*c.CallOptions).GetMappingRule):len((*c.CallOptions).GetMappingRule)], opts...)
	var resp *clouddmspb.MappingRule
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.GetMappingRule(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) SeedConversionWorkspace(ctx context.Context, req *clouddmspb.SeedConversionWorkspaceRequest, opts ...gax.CallOption) (*SeedConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SeedConversionWorkspace[0:len((*c.CallOptions).SeedConversionWorkspace):len((*c.CallOptions).SeedConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.SeedConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SeedConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) ImportMappingRules(ctx context.Context, req *clouddmspb.ImportMappingRulesRequest, opts ...gax.CallOption) (*ImportMappingRulesOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ImportMappingRules[0:len((*c.CallOptions).ImportMappingRules):len((*c.CallOptions).ImportMappingRules)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.ImportMappingRules(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ImportMappingRulesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) ConvertConversionWorkspace(ctx context.Context, req *clouddmspb.ConvertConversionWorkspaceRequest, opts ...gax.CallOption) (*ConvertConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ConvertConversionWorkspace[0:len((*c.CallOptions).ConvertConversionWorkspace):len((*c.CallOptions).ConvertConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.ConvertConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ConvertConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) CommitConversionWorkspace(ctx context.Context, req *clouddmspb.CommitConversionWorkspaceRequest, opts ...gax.CallOption) (*CommitConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CommitConversionWorkspace[0:len((*c.CallOptions).CommitConversionWorkspace):len((*c.CallOptions).CommitConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.CommitConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CommitConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) RollbackConversionWorkspace(ctx context.Context, req *clouddmspb.RollbackConversionWorkspaceRequest, opts ...gax.CallOption) (*RollbackConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RollbackConversionWorkspace[0:len((*c.CallOptions).RollbackConversionWorkspace):len((*c.CallOptions).RollbackConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.RollbackConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &RollbackConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) ApplyConversionWorkspace(ctx context.Context, req *clouddmspb.ApplyConversionWorkspaceRequest, opts ...gax.CallOption) (*ApplyConversionWorkspaceOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ApplyConversionWorkspace[0:len((*c.CallOptions).ApplyConversionWorkspace):len((*c.CallOptions).ApplyConversionWorkspace)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.ApplyConversionWorkspace(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ApplyConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *dataMigrationGRPCClient) DescribeDatabaseEntities(ctx context.Context, req *clouddmspb.DescribeDatabaseEntitiesRequest, opts ...gax.CallOption) *DatabaseEntityIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "conversion_workspace", url.QueryEscape(req.GetConversionWorkspace()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DescribeDatabaseEntities[0:len((*c.CallOptions).DescribeDatabaseEntities):len((*c.CallOptions).DescribeDatabaseEntities)], opts...)
	it := &DatabaseEntityIterator{}
	req = proto.Clone(req).(*clouddmspb.DescribeDatabaseEntitiesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*clouddmspb.DatabaseEntity, string, error) {
		resp := &clouddmspb.DescribeDatabaseEntitiesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.DescribeDatabaseEntities(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDatabaseEntities(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) SearchBackgroundJobs(ctx context.Context, req *clouddmspb.SearchBackgroundJobsRequest, opts ...gax.CallOption) (*clouddmspb.SearchBackgroundJobsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "conversion_workspace", url.QueryEscape(req.GetConversionWorkspace()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchBackgroundJobs[0:len((*c.CallOptions).SearchBackgroundJobs):len((*c.CallOptions).SearchBackgroundJobs)], opts...)
	var resp *clouddmspb.SearchBackgroundJobsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.SearchBackgroundJobs(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) DescribeConversionWorkspaceRevisions(ctx context.Context, req *clouddmspb.DescribeConversionWorkspaceRevisionsRequest, opts ...gax.CallOption) (*clouddmspb.DescribeConversionWorkspaceRevisionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "conversion_workspace", url.QueryEscape(req.GetConversionWorkspace()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DescribeConversionWorkspaceRevisions[0:len((*c.CallOptions).DescribeConversionWorkspaceRevisions):len((*c.CallOptions).DescribeConversionWorkspaceRevisions)], opts...)
	var resp *clouddmspb.DescribeConversionWorkspaceRevisionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.dataMigrationClient.DescribeConversionWorkspaceRevisions(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) FetchStaticIps(ctx context.Context, req *clouddmspb.FetchStaticIpsRequest, opts ...gax.CallOption) *StringIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).FetchStaticIps[0:len((*c.CallOptions).FetchStaticIps):len((*c.CallOptions).FetchStaticIps)], opts...)
	it := &StringIterator{}
	req = proto.Clone(req).(*clouddmspb.FetchStaticIpsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]string, string, error) {
		resp := &clouddmspb.FetchStaticIpsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.dataMigrationClient.FetchStaticIps(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetStaticIps(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.locationsClient.GetLocation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.locationsClient.ListLocations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *dataMigrationGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.GetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.SetIamPolicy(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.iamPolicyClient.TestIamPermissions(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.CancelOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *dataMigrationGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.operationsClient.DeleteOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

func (c *dataMigrationGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.operationsClient.GetOperation(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *dataMigrationGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.operationsClient.ListOperations(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ApplyConversionWorkspaceOperation returns a new ApplyConversionWorkspaceOperation from a given name.
// The name must be that of a previously created ApplyConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) ApplyConversionWorkspaceOperation(name string) *ApplyConversionWorkspaceOperation {
	return &ApplyConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CommitConversionWorkspaceOperation returns a new CommitConversionWorkspaceOperation from a given name.
// The name must be that of a previously created CommitConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) CommitConversionWorkspaceOperation(name string) *CommitConversionWorkspaceOperation {
	return &CommitConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ConvertConversionWorkspaceOperation returns a new ConvertConversionWorkspaceOperation from a given name.
// The name must be that of a previously created ConvertConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) ConvertConversionWorkspaceOperation(name string) *ConvertConversionWorkspaceOperation {
	return &ConvertConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateConnectionProfileOperation returns a new CreateConnectionProfileOperation from a given name.
// The name must be that of a previously created CreateConnectionProfileOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) CreateConnectionProfileOperation(name string) *CreateConnectionProfileOperation {
	return &CreateConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateConversionWorkspaceOperation returns a new CreateConversionWorkspaceOperation from a given name.
// The name must be that of a previously created CreateConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) CreateConversionWorkspaceOperation(name string) *CreateConversionWorkspaceOperation {
	return &CreateConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateMigrationJobOperation returns a new CreateMigrationJobOperation from a given name.
// The name must be that of a previously created CreateMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) CreateMigrationJobOperation(name string) *CreateMigrationJobOperation {
	return &CreateMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreatePrivateConnectionOperation returns a new CreatePrivateConnectionOperation from a given name.
// The name must be that of a previously created CreatePrivateConnectionOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) CreatePrivateConnectionOperation(name string) *CreatePrivateConnectionOperation {
	return &CreatePrivateConnectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteConnectionProfileOperation returns a new DeleteConnectionProfileOperation from a given name.
// The name must be that of a previously created DeleteConnectionProfileOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) DeleteConnectionProfileOperation(name string) *DeleteConnectionProfileOperation {
	return &DeleteConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteConversionWorkspaceOperation returns a new DeleteConversionWorkspaceOperation from a given name.
// The name must be that of a previously created DeleteConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) DeleteConversionWorkspaceOperation(name string) *DeleteConversionWorkspaceOperation {
	return &DeleteConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteMigrationJobOperation returns a new DeleteMigrationJobOperation from a given name.
// The name must be that of a previously created DeleteMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) DeleteMigrationJobOperation(name string) *DeleteMigrationJobOperation {
	return &DeleteMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeletePrivateConnectionOperation returns a new DeletePrivateConnectionOperation from a given name.
// The name must be that of a previously created DeletePrivateConnectionOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) DeletePrivateConnectionOperation(name string) *DeletePrivateConnectionOperation {
	return &DeletePrivateConnectionOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ImportMappingRulesOperation returns a new ImportMappingRulesOperation from a given name.
// The name must be that of a previously created ImportMappingRulesOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) ImportMappingRulesOperation(name string) *ImportMappingRulesOperation {
	return &ImportMappingRulesOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// PromoteMigrationJobOperation returns a new PromoteMigrationJobOperation from a given name.
// The name must be that of a previously created PromoteMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) PromoteMigrationJobOperation(name string) *PromoteMigrationJobOperation {
	return &PromoteMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RestartMigrationJobOperation returns a new RestartMigrationJobOperation from a given name.
// The name must be that of a previously created RestartMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) RestartMigrationJobOperation(name string) *RestartMigrationJobOperation {
	return &RestartMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResumeMigrationJobOperation returns a new ResumeMigrationJobOperation from a given name.
// The name must be that of a previously created ResumeMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) ResumeMigrationJobOperation(name string) *ResumeMigrationJobOperation {
	return &ResumeMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// RollbackConversionWorkspaceOperation returns a new RollbackConversionWorkspaceOperation from a given name.
// The name must be that of a previously created RollbackConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) RollbackConversionWorkspaceOperation(name string) *RollbackConversionWorkspaceOperation {
	return &RollbackConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SeedConversionWorkspaceOperation returns a new SeedConversionWorkspaceOperation from a given name.
// The name must be that of a previously created SeedConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) SeedConversionWorkspaceOperation(name string) *SeedConversionWorkspaceOperation {
	return &SeedConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartMigrationJobOperation returns a new StartMigrationJobOperation from a given name.
// The name must be that of a previously created StartMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) StartMigrationJobOperation(name string) *StartMigrationJobOperation {
	return &StartMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopMigrationJobOperation returns a new StopMigrationJobOperation from a given name.
// The name must be that of a previously created StopMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) StopMigrationJobOperation(name string) *StopMigrationJobOperation {
	return &StopMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateConnectionProfileOperation returns a new UpdateConnectionProfileOperation from a given name.
// The name must be that of a previously created UpdateConnectionProfileOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) UpdateConnectionProfileOperation(name string) *UpdateConnectionProfileOperation {
	return &UpdateConnectionProfileOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateConversionWorkspaceOperation returns a new UpdateConversionWorkspaceOperation from a given name.
// The name must be that of a previously created UpdateConversionWorkspaceOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) UpdateConversionWorkspaceOperation(name string) *UpdateConversionWorkspaceOperation {
	return &UpdateConversionWorkspaceOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateMigrationJobOperation returns a new UpdateMigrationJobOperation from a given name.
// The name must be that of a previously created UpdateMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) UpdateMigrationJobOperation(name string) *UpdateMigrationJobOperation {
	return &UpdateMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// VerifyMigrationJobOperation returns a new VerifyMigrationJobOperation from a given name.
// The name must be that of a previously created VerifyMigrationJobOperation, possibly from a different process.
func (c *dataMigrationGRPCClient) VerifyMigrationJobOperation(name string) *VerifyMigrationJobOperation {
	return &VerifyMigrationJobOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
