/*
 * Copyright (C) 2025, Stephan Mueller <smueller@chronox.de>
 *
 * License: see LICENSE file in root directory
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, ALL OF
 * WHICH ARE HEREBY DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF NOT ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#include "gfmul_neon.h"
#include "ext_headers_arm.h"

void gfmul_init_armv8_impl(uint64_t *Htable, const uint64_t Xi[2]);
void gfmul_armv8_impl(uint64_t Xi[2], const uint64_t *Htable);

void gfmul_init_armv8(uint64_t *Htable, const uint64_t Xi[2])
{
	LC_NEON_ENABLE;
	gfmul_init_armv8_impl(Htable, Xi);
	LC_NEON_DISABLE;
}

void gfmul_armv8(uint64_t Xi[2], const uint64_t *Htable)
{
	LC_NEON_ENABLE;
	gfmul_armv8_impl(Xi, Htable);
	LC_NEON_DISABLE;
}
