var relearn_searchindex = [
  {
    "breadcrumb": "Lego \u003e Usage \u003e CLI",
    "content": "These examples assume you have lego installed. You can get a pre-built binary from the releases page.\nThe web server examples require that the lego binary has permission to bind to ports 80 and 443. If your environment does not allow you to bind to these ports, please read Running without root privileges and Port Usage.\nUnless otherwise instructed with the --path command line flag, lego will look for a directory named .lego in the current working directory. If you run cd /dir/a \u0026\u0026 lego ... run, lego will create a directory /dir/a/.lego where it will save account registration and certificate files into. If you later try to renew a certificate with cd /dir/b \u0026\u0026 lego ... renew, lego will likely produce an error.",
    "description": "Read this first to clarify some assumptions made by the following guides.",
    "tags": [],
    "title": "General Instructions",
    "uri": "/lego/usage/cli/general-instructions/index.html"
  },
  {
    "breadcrumb": "Lego",
    "content": "Binaries To get the binary just download the latest release for your OS/Arch from the release page and put the binary somewhere convenient. lego does not assume anything about the location you run it from.\nFrom Docker docker run goacme/lego -h From package managers ArchLinux (official):\npacman -S lego ArchLinux (AUR) (official):\nyay -S lego-bin Snap (official):\nsudo snap install lego Note: The snap can only write to the /var/snap/lego/common/.lego directory.\nFreeBSD (Ports) (unofficial):\npkg install lego Gentoo (unofficial):\nYou can enable GURU repository and then:\nemerge app-crypt/lego Homebrew (unofficial):\nbrew install lego or\npkg install lego OpenBSD (Ports) (unofficial):\npkg_add lego From sources Requirements:\ngo1.22+. environment variable: GO111MODULE=on To install the latest version from sources, just run:\ngo install github.com/go-acme/lego/v4/cmd/lego@latest or\ngit clone git@github.com:go-acme/lego.git cd lego make # tests + doc + build make build # only build",
    "description": "Binaries To get the binary just download the latest release for your OS/Arch from the release page and put the binary somewhere convenient. lego does not assume anything about the location you run it from.\nFrom Docker docker run goacme/lego -h From package managers ArchLinux (official):\npacman -S lego ArchLinux (AUR) (official):\nyay -S lego-bin Snap (official):\nsudo snap install lego Note: The snap can only write to the /var/snap/lego/common/.lego directory.",
    "tags": [],
    "title": "Installation",
    "uri": "/lego/installation/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage \u003e CLI",
    "content": "This guide explains various ways to obtain a new certificate.\nUsing the built-in web server Open a terminal, and execute the following command (insert your own email address and domain):\nlego --email=\"you@example.com\" --domains=\"example.com\" --http run You will find your certificate in the .lego folder of the current working directory:\n$ ls -1 ./.lego/certificates example.com.crt example.com.issuer.crt example.com.json example.com.key [maybe more files for different domains...] where\nexample.com.crt is the server certificate (including the CA certificate), example.com.key is the private key needed for the server certificate, example.com.issuer.crt is the CA certificate, and example.com.json contains some JSON encoded meta information. For each domain, you will have a set of these four files. For wildcard certificates (*.example.com), the filenames will look like _.example.com.crt.\nThe .crt and .key files are PEM-encoded x509 certificates and private keys. If you’re looking for a cert.pem and privkey.pem, you can just use example.com.crt and example.com.key.\nUsing a DNS provider If you can’t or don’t want to start a web server, you need to use a DNS provider. lego comes with support for many providers, and you need to pick the one where your domain’s DNS settings are set up. Typically, this is the registrar where you bought the domain, but in some cases this can be another third-party provider.\nFor this example, let’s assume you have set up Gandi for your domain.\nExecute this command:\nGANDI_API_KEY=xxx \\ lego --email \"you@example.com\" --dns gandi --domains \"example.org\" --domains \"*.example.org\" run For a zone that has multiple SOAs This can often be found where your DNS provider has a zone entry for an internal network (i.e. a corporate network, or home LAN) as well as the public internet. In this case, point lego at an external authoritative server for the zone using the additional parameter --dns.resolvers.\nGANDI_API_KEY=xxx \\ lego --email \"you@example.com\" --dns gandi --dns.resolvers 9.9.9.9:53 --domains \"example.org\" --domains \"*.example.org\" run More information about resolvers.\nUsing a custom certificate signing request (CSR) The first step in the process of obtaining certificates involves creating a signing request. This CSR bundles various information, including the domain name(s) and a public key. By default, lego will hide this step from you, but if you already have a CSR, you can easily reuse it:\nlego --email=\"you@example.com\" --http --csr=\"/path/to/csr.pem\" run lego will infer the domains to be validated based on the contents of the CSR, so make sure the CSR’s Common Name and optional SubjectAltNames are set correctly.\nUsing an existing, running web server If you have an existing server running on port 80, the --http option also requires the --http.webroot option. This just writes the http-01 challenge token to the given directory in the folder .well-known/acme-challenge and does not start a server.\nThe given directory should be publicly served as / on the domain(s) for the validation to complete.\nIf the given directory is not publicly served you will have to support rewriting the request to the directory;\nYou could also implement a rewrite to rewrite .well-known/acme-challenge to the given directory .well-known/acme-challenge.\nYou should be able to run an existing webserver on port 80 and have lego write the token file with the HTTP-01 challenge key authorization to \u003cwebroot dir\u003e/.well-known/acme-challenge/ by running something like:\nlego --accept-tos --email you@example.com --http --http.webroot /path/to/webroot --domains example.com run Running a script afterward You can easily hook into the certificate-obtaining process by providing the path to a script:\nlego --email=\"you@example.com\" --domains=\"example.com\" --http run --run-hook=\"./myscript.sh\" Some information is provided through environment variables:\nLEGO_ACCOUNT_EMAIL: the email of the account. LEGO_CERT_DOMAIN: the main domain of the certificate. LEGO_CERT_PATH: the path of the certificate. LEGO_CERT_KEY_PATH: the path of the certificate key. LEGO_CERT_PEM_PATH: (only with --pem) the path to the PEM certificate. LEGO_CERT_PFX_PATH: (only with --pfx) the path to the PFX certificate. Use case A typical use case is distribute the certificate for other services and reload them if necessary. Since PEM-formatted TLS certificates are understood by many programs, it is relatively simple to use certificates for more than a web server.\nThis example script installs the new certificate for a mail server, and reloads it. Beware: this is just a starting point, error checking is omitted for brevity.\n#!/bin/bash # copy certificates to a directory controlled by Postfix postfix_cert_dir=\"/etc/postfix/certificates\" # our Postfix server only handles mail for @example.com domain if [ \"$LEGO_CERT_DOMAIN\" = \"example.com\" ]; then install -u postfix -g postfix -m 0644 \"$LEGO_CERT_PATH\" \"$postfix_cert_dir\" install -u postfix -g postfix -m 0640 \"$LEGO_CERT_KEY_PATH\" \"$postfix_cert_dir\" systemctl reload postfix@-service fi",
    "description": "This guide explains various ways to obtain a new certificate.",
    "tags": [],
    "title": "Obtain a Certificate",
    "uri": "/lego/usage/cli/obtain-a-certificate/index.html"
  },
  {
    "breadcrumb": "Lego",
    "content": "CLILego can be use as a CLI.\nLibraryLego can be used as a Go Library.",
    "description": "CLILego can be use as a CLI.\nLibraryLego can be used as a Go Library.",
    "tags": [],
    "title": "Usage",
    "uri": "/lego/usage/index.html"
  },
  {
    "breadcrumb": "Lego",
    "content": "Important lego is an independent, free, and open-source project, if you value it, consider supporting it! ❤️\nThis project is not owned by a company. I’m not an employee of a company.\nI don’t have gifted domains/accounts from DNS companies.\nI’ve been maintaining it for about 10 years.\nConfiguration and Credentials Credentials and DNS configuration for DNS providers must be passed through environment variables.\nEnvironment Variables: Value The environment variables can reference a value.\nHere is an example bash command using the Cloudflare DNS provider:\n$ CLOUDFLARE_EMAIL=you@example.com \\ CLOUDFLARE_API_KEY=b9841238feb177a84330febba8a83208921177bffe733 \\ lego --dns cloudflare --domains www.example.com --email you@example.com run Environment Variables: File The environment variables can reference a path to file.\nIn this case the name of environment variable must be suffixed by _FILE.\nNote The file must contain only the value.\nHere is an example bash command using the CloudFlare DNS provider:\n$ cat /the/path/to/my/key b9841238feb177a84330febba8a83208921177bffe733 $ cat /the/path/to/my/email you@example.com $ CLOUDFLARE_EMAIL_FILE=/the/path/to/my/email \\ CLOUDFLARE_API_KEY_FILE=/the/path/to/my/key \\ lego --dns cloudflare --domains www.example.com --email you@example.com run DNS Providers Provider name CLI flag name Required lego version 35.com/三五互联 Website com35 v4.31.0 Active24 Website active24 v4.23.0 Akamai EdgeDNS Website edgedns v3.9.0 Alibaba Cloud DNS Website alidns v1.1.0 AlibabaCloud ESA Website aliesa v4.29.0 all-inkl Website allinkl v4.5.0 Alwaysdata Website alwaysdata v4.31.0 Amazon Lightsail Website lightsail v0.5.0 Amazon Route 53 Website route53 v0.3.0 Anexia CloudDNS Website anexia v4.28.0 ArvanCloud Website arvancloud v3.8.0 Aurora DNS Website auroradns v0.4.0 Autodns Website autodns v3.2.0 Axelname Website axelname v4.23.0 Azion Website azion v4.24.0 Azure (deprecated) Website azure v0.4.0 Azure DNS Website azuredns v4.13.0 Baidu Cloud Website baiducloud v4.23.0 Beget.com Website beget v4.27.0 Binary Lane Website binarylane v4.26.0 Bindman Website bindman v2.6.0 Bluecat Website bluecat v0.5.0 BookMyName Website bookmyname v4.23.0 Brandit (deprecated) Website brandit v4.11.0 Bunny Website bunny v4.11.0 Checkdomain Website checkdomain v3.3.0 Civo Website civo v4.9.0 Cloud.ru Website cloudru v4.14.0 CloudDNS Website clouddns v3.6.0 Cloudflare Website cloudflare v0.3.0 ClouDNS Website cloudns v2.3.0 CloudXNS (Deprecated) Website cloudxns v0.5.0 ConoHa v2 Website conoha v1.2.0 ConoHa v3 Website conohav3 v4.24.0 Constellix Website constellix v3.4.0 Core-Networks Website corenetworks v4.20.0 CPanel/WHM Website cpanel v4.16.0 Derak Cloud Website derak v4.12.0 deSEC.io Website desec v3.7.0 Designate DNSaaS for Openstack Website designate v2.2.0 Digital Ocean Website digitalocean v0.3.0 DirectAdmin Website directadmin v4.18.0 DNS Made Easy Website dnsmadeeasy v0.4.0 dnsHome.de Website dnshomede v4.10.0 DNSimple Website dnsimple v0.3.0 DNSPod (deprecated) Website dnspod v0.4.0 Domain Offensive (do.de) Website dode v2.4.0 Domeneshop Website domeneshop v4.3.0 DreamHost Website dreamhost v1.1.0 Duck DNS Website duckdns v0.5.0 Dyn Website dyn v0.3.0 DynDnsFree.de Website dyndnsfree v4.23.0 Dynu Website dynu v3.5.0 EasyDNS Website easydns v2.6.0 EdgeCenter Website edgecenter v4.29.0 Efficient IP Website efficientip v4.13.0 Epik Website epik v4.5.0 Exoscale Website exoscale v0.4.0 External program Website exec v0.5.0 F5 XC Website f5xc v4.23.0 freemyip.com Website freemyip v4.5.0 G-Core Website gcore v4.5.0 Gandi Website gandi v0.3.0 Gandi Live DNS (v5) Website gandiv5 v0.5.0 Gigahost.no Website gigahostno v4.29.0 Glesys Website glesys v0.5.0 Go Daddy Website godaddy v0.5.0 Google Cloud Website gcloud v0.3.0 Google Domains Website googledomains v4.11.0 Gravity Website gravity v4.30.0 Hetzner Website hetzner v3.7.0 Hosting.de Website hostingde v1.1.0 Hosting.nl Website hostingnl v4.30.0 Hostinger Website hostinger v4.27.0 Hosttech Website hosttech v4.5.0 HTTP request Website httpreq v2.0.0 http.net Website httpnet v4.15.0 Huawei Cloud Website huaweicloud v4.19 Hurricane Electric DNS Website hurricane v4.3.0 HyperOne Website hyperone v3.9.0 IBM Cloud (SoftLayer) Website ibmcloud v4.5.0 IIJ DNS Platform Service Website iijdpf v4.7.0 Infoblox Website infoblox v4.4.0 Infomaniak Website infomaniak v4.1.0 Internet Initiative Japan Website iij v1.1.0 Internet.bs Website internetbs v4.5.0 INWX Website inwx v2.0.0 Ionos Website ionos v4.2.0 Ionos Cloud Website ionoscloud v4.30.0 IPv64 Website ipv64 v4.13.0 ISPConfig 3 Website ispconfig v4.31.0 ISPConfig 3 - Dynamic DNS (DDNS) Module Website ispconfigddns v4.31.0 iwantmyname (Deprecated) Website iwantmyname v4.7.0 JD Cloud Website jdcloud v4.31.0 Joker Website joker v2.6.0 Joohoi's ACME-DNS Website acme-dns v1.1.0 KeyHelp Website keyhelp v4.26.0 Liara Website liara v4.10.0 Lima-City Website limacity v4.18.0 Linode (v4) Website linode v1.1.0 Liquid Web Website liquidweb v3.1.0 Loopia Website loopia v4.2.0 LuaDNS Website luadns v3.7.0 Mail-in-a-Box Website mailinabox v4.16.0 ManageEngine CloudDNS Website manageengine v4.21.0 Manual manual v0.3.0 Metaname Website metaname v4.13.0 Metaregistrar Website metaregistrar v4.23.0 mijn.host Website mijnhost v4.18.0 Mittwald Website mittwald v1.48.0 myaddr.{tools,dev,io} Website myaddr v4.22.0 MyDNS.jp Website mydnsjp v1.2.0 MythicBeasts Website mythicbeasts v0.3.7 Name.com Website namedotcom v0.5.0 Namecheap Website namecheap v0.3.0 Namesilo Website namesilo v2.7.0 NearlyFreeSpeech.NET Website nearlyfreespeech v4.8.0 Neodigit Website neodigit v4.30.0 Netcup Website netcup v1.1.0 Netlify Website netlify v3.7.0 Nicmanager Website nicmanager v4.5.0 NIFCloud Website nifcloud v1.1.0 Njalla Website njalla v4.3.0 Nodion Website nodion v4.11.0 NS1 Website ns1 v0.4.0 Octenium Website octenium v4.27.0 Open Telekom Cloud Website otc v0.4.1 Oracle Cloud Website oraclecloud v2.3.0 OVH Website ovh v0.4.0 plesk.com Website plesk v4.11.0 Porkbun Website porkbun v4.4.0 PowerDNS Website pdns v0.4.0 Rackspace Website rackspace v0.4.0 Rain Yun/雨云 Website rainyun v4.21.0 RcodeZero Website rcodezero v4.13 reg.ru Website regru v3.5.0 Regfish Website regfish v4.20.0 RFC2136 Website rfc2136 v0.3.0 RimuHosting Website rimuhosting v0.3.5 RU CENTER Website nicru v4.24.0 Sakura Cloud Website sakuracloud v1.1.0 Scaleway Website scaleway v3.4.0 Selectel Website selectel v1.2.0 Selectel v2 Website selectelv2 v4.17.0 SelfHost.(de|eu) Website selfhostde v4.19.0 Servercow Website servercow v3.4.0 Shellrent Website shellrent v4.16.0 Simply.com Website simply v4.4.0 Sonic Website sonic v4.4.0 Spaceship Website spaceship v4.22.0 Stackpath Website stackpath v1.1.0 Syse Website syse v4.30.0 Technitium Website technitium v4.20.0 Tencent Cloud DNS Website tencentcloud v4.6.0 Tencent EdgeOne Website edgeone v4.26.0 Timeweb Cloud Website timewebcloud v4.20.0 TransIP Website transip v2.0.0 UKFast SafeDNS Website safedns v4.6.0 Ultradns Website ultradns v4.10.0 United-Domains Website uniteddomains v4.29.0 Variomedia Website variomedia v4.8.0 VegaDNS Website vegadns v1.1.0 Vercel Website vercel v4.7.0 Versio.[nl|eu|uk] Website versio v2.7.0 VinylDNS Website vinyldns v4.4.0 Virtualname Website virtualname v4.30.0 VK Cloud Website vkcloud v4.9.0 Volcano Engine/火山引擎 Website volcengine v4.19.0 Vscale Website vscale v2.0.0 Vultr Website vultr v0.3.1 webnames.ca Website webnamesca v4.28.0 webnames.ru Website webnames v4.15.0 Websupport Website websupport v4.10.0 WEDOS Website wedos v4.4.0 West.cn/西部数码 Website westcn v4.21.0 Yandex 360 Website yandex360 v4.14.0 Yandex Cloud Website yandexcloud v4.9.0 Yandex PDD Website yandex v3.7.0 Zone.ee Website zoneee v2.1.0 ZoneEdit Website zoneedit v4.25.0 Zonomi Website zonomi v3.5.0",
    "description": "Important lego is an independent, free, and open-source project, if you value it, consider supporting it! ❤️\nThis project is not owned by a company. I’m not an employee of a company.\nI don’t have gifted domains/accounts from DNS companies.\nI’ve been maintaining it for about 10 years.\nConfiguration and Credentials Credentials and DNS configuration for DNS providers must be passed through environment variables.",
    "tags": [],
    "title": "DNS Providers",
    "uri": "/lego/dns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage \u003e CLI",
    "content": "This guide describes how to renew existing certificates.\nCertificates issues by Let’s Encrypt are valid for a period of 90 days. To avoid certificate errors, you need to ensure that you renew your certificate before it expires.\nIn order to renew a certificate, follow the general instructions laid out under Obtain a Certificate, and replace lego ... run with lego ... renew. Note that the renew sub-command supports a slightly different set of some command line flags.\nUsing the built-in web server By default, and following best practices, a certificate is only renewed if its expiry date is less than 30 days in the future.\nlego --email=\"you@example.com\" --domains=\"example.com\" --http renew If the certificate needs to renewed earlier, you can specify the number of remaining days:\nlego --email=\"you@example.com\" --domains=\"example.com\" --http renew --days 45 Using a DNS provider If you can’t or don’t want to start a web server, you need to use a DNS provider. lego comes with support for many providers, and you need to pick the one where your domain’s DNS settings are set up. Typically, this is the registrar where you bought the domain, but in some cases this can be another third-party provider.\nFor this example, let’s assume you have set up CloudFlare for your domain.\nExecute this command:\nCLOUDFLARE_EMAIL=\"you@example.com\" \\ CLOUDFLARE_API_KEY=\"yourprivatecloudflareapikey\" \\ lego --email \"you@example.com\" --dns cloudflare --domains \"example.org\" renew Running a script afterward You can easily hook into the certificate-obtaining process by providing the path to a script. The hook is executed only when the certificates are effectively renewed.\nlego --email=\"you@example.com\" --domains=\"example.com\" --http renew --renew-hook=\"./myscript.sh\" Some information is provided through environment variables:\nLEGO_ACCOUNT_EMAIL: the email of the account. LEGO_CERT_DOMAIN: the main domain of the certificate. LEGO_CERT_PATH: the path of the certificate. LEGO_CERT_KEY_PATH: the path of the certificate key. LEGO_CERT_PEM_PATH: (only with --pem) the path to the PEM certificate. LEGO_CERT_PFX_PATH: (only with --pfx) the path to the PFX certificate. See Obtain a Certificate → Use case for an example script.\nAutomatic renewal It is tempting to create a cron job (or systemd timer) to automatically renew all you certificates.\nWhen doing so, please note that some cron defaults will cause measurable load on the ACME provider’s infrastructure. Notably @daily jobs run at midnight.\nTo both counteract load spikes (caused by all lego users) and reduce subsequent renewal failures, we were asked to implement a small random delay for non-interactive renewals.1 Since v4.8.0, lego will pause for up to 8 minutes to help spread the load.\nYou can help further, by adjusting your crontab entry, like so:\n# avoid: #@daily /usr/bin/lego ... renew #@midnight /usr/bin/lego ... renew #0 0 * * * /usr/bin/lego ... renew # instead, use a randomly chosen time: 35 3 * * * /usr/bin/lego ... renew If you use systemd timers, consider doing something similar, and/or introduce a RandomizedDelaySec:\n[Unit] Description=Renew certificates [Timer] Persistent=true # avoid: #OnCalendar=*-*-* 00:00:00 #OnCalendar=daily # instead, use a randomly chosen time: OnCalendar=*-*-* 3:35 # add extra delay, here up to 1 hour: RandomizedDelaySec=1h [Install] WantedBy=timers.target See GitHub issue #1656 for an excellent problem description. ↩︎",
    "description": "This guide describes how to renew existing certificates.",
    "tags": [],
    "title": "Renew a Certificate",
    "uri": "/lego/usage/cli/renew-a-certificate/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage \u003e CLI",
    "content": "Usage ​ lego help lego help run lego help renew lego help revoke lego help list lego dnshelp NAME: lego - Let's Encrypt client written in Go USAGE: lego [global options] command [command options] COMMANDS: run Register an account, then create and install a certificate revoke Revoke a certificate renew Renew a certificate dnshelp Shows additional help for the '--dns' global option list Display certificates and accounts information. help, h Shows a list of commands or help for one command GLOBAL OPTIONS: --domains value, -d value [ --domains value, -d value ] Add a domain to the process. Can be specified multiple times. --server value, -s value CA hostname (and optionally :port). The server certificate must be trusted in order to avoid further modifications to the client. (default: \"https://acme-v02.api.letsencrypt.org/directory\") [$LEGO_SERVER] --accept-tos, -a By setting this flag to true you indicate that you accept the current Let's Encrypt terms of service. (default: false) --email value, -m value Email used for registration and recovery contact. [$LEGO_EMAIL] --disable-cn Disable the use of the common name in the CSR. (default: false) --csr value, -c value Certificate signing request filename, if an external CSR is to be used. --eab Use External Account Binding for account registration. Requires --kid and --hmac. (default: false) [$LEGO_EAB] --kid value Key identifier from External CA. Used for External Account Binding. [$LEGO_EAB_KID] --hmac value MAC key from External CA. Should be in Base64 URL Encoding without padding format. Used for External Account Binding. [$LEGO_EAB_HMAC] --key-type value, -k value Key type to use for private keys. Supported: rsa2048, rsa3072, rsa4096, rsa8192, ec256, ec384. (default: \"ec256\") --filename value (deprecated) Filename of the generated certificate. --path value Directory to use for storing the data. (default: \"./.lego\") [$LEGO_PATH] --http Use the HTTP-01 challenge to solve challenges. Can be mixed with other types of challenges. (default: false) --http.port value Set the port and interface to use for HTTP-01 based challenges to listen on. Supported: interface:port or :port. (default: \":80\") --http.delay value Delay between the starts of the HTTP server (use for HTTP-01 based challenges) and the validation of the challenge. (default: 0s) --http.proxy-header value Validate against this HTTP header when solving HTTP-01 based challenges behind a reverse proxy. (default: \"Host\") --http.webroot value Set the webroot folder to use for HTTP-01 based challenges to write directly to the .well-known/acme-challenge file. This disables the built-in server and expects the given directory to be publicly served with access to .well-known/acme-challenge --http.memcached-host value [ --http.memcached-host value ] Set the memcached host(s) to use for HTTP-01 based challenges. Challenges will be written to all specified hosts. --http.s3-bucket value Set the S3 bucket name to use for HTTP-01 based challenges. Challenges will be written to the S3 bucket. --tls Use the TLS-ALPN-01 challenge to solve challenges. Can be mixed with other types of challenges. (default: false) --tls.port value Set the port and interface to use for TLS-ALPN-01 based challenges to listen on. Supported: interface:port or :port. (default: \":443\") --tls.delay value Delay between the start of the TLS listener (use for TLSALPN-01 based challenges) and the validation of the challenge. (default: 0s) --dns value Solve a DNS-01 challenge using the specified provider. Can be mixed with other types of challenges. Run 'lego dnshelp' for help on usage. --dns.disable-cp (deprecated) use dns.propagation-disable-ans instead. (default: false) --dns.propagation-disable-ans By setting this flag to true, disables the need to await propagation of the TXT record to all authoritative name servers. (default: false) --dns.propagation-rns By setting this flag to true, use all the recursive nameservers to check the propagation of the TXT record. (default: false) --dns.propagation-wait value By setting this flag, disables all the propagation checks of the TXT record and uses a wait duration instead. (default: 0s) --dns.resolvers value [ --dns.resolvers value ] Set the resolvers to use for performing (recursive) CNAME resolving and apex domain determination. For DNS-01 challenge verification, the authoritative DNS server is queried directly. Supported: host:port. The default is to use the system resolvers, or Google's DNS resolvers if the system's cannot be determined. --http-timeout value Set the HTTP timeout value to a specific value in seconds. (default: 0) --tls-skip-verify Skip the TLS verification of the ACME server. (default: false) --dns-timeout value Set the DNS timeout value to a specific value in seconds. Used only when performing authoritative name server queries. (default: 10) --pem Generate an additional .pem (base64) file by concatenating the .key and .crt files together. (default: false) --pfx Generate an additional .pfx (PKCS#12) file by concatenating the .key and .crt and issuer .crt files together. (default: false) [$LEGO_PFX] --pfx.pass value The password used to encrypt the .pfx (PCKS#12) file. (default: \"changeit\") [$LEGO_PFX_PASSWORD] --pfx.format value The encoding format to use when encrypting the .pfx (PCKS#12) file. Supported: RC2, DES, SHA256. (default: \"RC2\") [$LEGO_PFX_FORMAT] --cert.timeout value Set the certificate timeout value to a specific value in seconds. Only used when obtaining certificates. (default: 30) --overall-request-limit value ACME overall requests limit. (default: 18) --user-agent value Add to the user-agent sent to the CA to identify an application embedding lego-cli --help, -h show help NAME: lego run - Register an account, then create and install a certificate USAGE: lego run [command options] OPTIONS: --no-bundle Do not create a certificate bundle by adding the issuers certificate to the new certificate. (default: false) --must-staple Include the OCSP must staple TLS extension in the CSR and generated certificate. Only works if the CSR is generated by lego. (default: false) --not-before value Set the notBefore field in the certificate (RFC3339 format) --not-after value Set the notAfter field in the certificate (RFC3339 format) --private-key value Path to private key (in PEM encoding) for the certificate. By default, the private key is generated. --preferred-chain value If the CA offers multiple certificate chains, prefer the chain with an issuer matching this Subject Common Name. If no match, the default offered chain will be used. --profile value If the CA offers multiple certificate profiles (draft-ietf-acme-profiles), choose this one. --always-deactivate-authorizations value Force the authorizations to be relinquished even if the certificate request was successful. --run-hook value Define a hook. The hook is executed when the certificates are effectively created. --run-hook-timeout value Define the timeout for the hook execution. (default: 2m0s) --help, -h show help NAME: lego renew - Renew a certificate USAGE: lego renew [command options] OPTIONS: --days value The number of days left on a certificate to renew it. (default: 30) --dynamic Compute dynamically, based on the lifetime of the certificate(s), when to renew: use 1/3rd of the lifetime left, or 1/2 of the lifetime for short-lived certificates). This supersedes --days and will be the default behavior in Lego v5. (default: false) --ari-disable Do not use the renewalInfo endpoint (RFC9773) to check if a certificate should be renewed. (default: false) --ari-wait-to-renew-duration value The maximum duration you're willing to sleep for a renewal time returned by the renewalInfo endpoint. (default: 0s) --reuse-key Used to indicate you want to reuse your current private key for the new certificate. (default: false) --no-bundle Do not create a certificate bundle by adding the issuers certificate to the new certificate. (default: false) --must-staple Include the OCSP must staple TLS extension in the CSR and generated certificate. Only works if the CSR is generated by lego. (default: false) --not-before value Set the notBefore field in the certificate (RFC3339 format) --not-after value Set the notAfter field in the certificate (RFC3339 format) --preferred-chain value If the CA offers multiple certificate chains, prefer the chain with an issuer matching this Subject Common Name. If no match, the default offered chain will be used. --profile value If the CA offers multiple certificate profiles (draft-ietf-acme-profiles), choose this one. --always-deactivate-authorizations value Force the authorizations to be relinquished even if the certificate request was successful. --renew-hook value Define a hook. The hook is executed only when the certificates are effectively renewed. --renew-hook-timeout value Define the timeout for the hook execution. (default: 2m0s) --no-random-sleep Do not add a random sleep before the renewal. We do not recommend using this flag if you are doing your renewals in an automated way. (default: false) --force-cert-domains Check and ensure that the cert's domain list matches those passed in the domains argument. (default: false) --help, -h show help NAME: lego revoke - Revoke a certificate USAGE: lego revoke [command options] OPTIONS: --keep, -k Keep the certificates after the revocation instead of archiving them. (default: false) --reason value Identifies the reason for the certificate revocation. See https://www.rfc-editor.org/rfc/rfc5280.html#section-5.3.1. Valid values are: 0 (unspecified), 1 (keyCompromise), 2 (cACompromise), 3 (affiliationChanged), 4 (superseded), 5 (cessationOfOperation), 6 (certificateHold), 8 (removeFromCRL), 9 (privilegeWithdrawn), or 10 (aACompromise). (default: 0) --help, -h show help NAME: lego list - Display certificates and accounts information. USAGE: lego list [command options] OPTIONS: --accounts, -a Display accounts. (default: false) --names, -n Display certificate common names only. (default: false) --help, -h show help Credentials for DNS providers must be passed through environment variables. To display the documentation for a specific DNS provider, run: $ lego dnshelp -c code Supported DNS providers: acme-dns, active24, alidns, aliesa, allinkl, alwaysdata, anexia, arvancloud, auroradns, autodns, axelname, azion, azure, azuredns, baiducloud, beget, binarylane, bindman, bluecat, bookmyname, brandit, bunny, checkdomain, civo, clouddns, cloudflare, cloudns, cloudru, cloudxns, com35, conoha, conohav3, constellix, corenetworks, cpanel, derak, desec, designate, digitalocean, directadmin, dnshomede, dnsimple, dnsmadeeasy, dnspod, dode, domeneshop, dreamhost, duckdns, dyn, dyndnsfree, dynu, easydns, edgecenter, edgedns, edgeone, efficientip, epik, exec, exoscale, f5xc, freemyip, gandi, gandiv5, gcloud, gcore, gigahostno, glesys, godaddy, googledomains, gravity, hetzner, hostingde, hostinger, hostingnl, hosttech, httpnet, httpreq, huaweicloud, hurricane, hyperone, ibmcloud, iij, iijdpf, infoblox, infomaniak, internetbs, inwx, ionos, ionoscloud, ipv64, ispconfig, ispconfigddns, iwantmyname, jdcloud, joker, keyhelp, liara, lightsail, limacity, linode, liquidweb, loopia, luadns, mailinabox, manageengine, manual, metaname, metaregistrar, mijnhost, mittwald, myaddr, mydnsjp, mythicbeasts, namecheap, namedotcom, namesilo, nearlyfreespeech, neodigit, netcup, netlify, nicmanager, nicru, nifcloud, njalla, nodion, ns1, octenium, oraclecloud, otc, ovh, pdns, plesk, porkbun, rackspace, rainyun, rcodezero, regfish, regru, rfc2136, rimuhosting, route53, safedns, sakuracloud, scaleway, selectel, selectelv2, selfhostde, servercow, shellrent, simply, sonic, spaceship, stackpath, syse, technitium, tencentcloud, timewebcloud, transip, ultradns, uniteddomains, variomedia, vegadns, vercel, versio, vinyldns, virtualname, vkcloud, volcengine, vscale, vultr, webnames, webnamesca, websupport, wedos, westcn, yandex, yandex360, yandexcloud, zoneedit, zoneee, zonomi More information: https://go-acme.github.io/lego/dns When using the standard --path option, all certificates and account configurations are saved to a folder .lego in the current working directory.\nLet’s Encrypt ACME server lego defaults to communicating with the production Let’s Encrypt ACME server. If you’d like to test something without issuing real certificates, consider using the staging endpoint instead:\nlego --server=https://acme-staging-v02.api.letsencrypt.org/directory … Running without root privileges The CLI does not require root permissions but needs to bind to port 80 and 443 for certain challenges. To run the CLI without sudo, you have four options:\nUse setcap 'cap_net_bind_service=+ep' /path/to/lego (Linux only) Pass the --http.port or/and the --tls.port option and specify a custom port to bind to. In this case you have to forward port 80/443 to these custom ports (see Port Usage). Pass the --http.webroot option and specify the path to your webroot folder. In this case the challenge will be written in a file in .well-known/acme-challenge/ inside your webroot. Pass the --dns option and specify a DNS provider. Port Usage By default, lego assumes it is able to bind to ports 80 and 443 to solve challenges. If this is not possible in your environment, you can use the --http.port and --tls.port options to instruct lego to listen on that interface:port for any incoming challenges.\nIf you are using either of these options, make sure you setup a proxy to redirect traffic to the chosen ports.\nHTTP Port: All plaintext HTTP requests to port 80 which begin with a request path of /.well-known/acme-challenge/ for the HTTP challenge1.\nTLS Port: All TLS handshakes on port 443 for the TLS-ALPN challenge.\nThis traffic redirection is only needed as long as lego solves challenges. As soon as you have received your certificates you can deactivate the forwarding.\nDNS Resolvers and Challenge Verification When using a DNS challenge provider (via --dns \u003cname\u003e), Lego tries to ensure the ACME challenge token is properly setup before instructing the ACME provider to perform the validation.\nThis involves a few DNS queries to different servers:\nDetermining the DNS zone and resolving CNAMEs.\nThe DNS zone for a given domain is determined by the SOA record, which contains the authoritative name server for the domain and all its subdomains. For simple domains like example.com, this is usually example.com itself. For other domains (like fra.eu.cdn.example.com), this can get complicated, as cdn.example.com may be delegated to the CDN provider, which means for cdn.example.com must exist a different SOA record.\nTo find the correct zone, Lego requests the SOA record for each DNS label (starting on the leaf domain, i.e. the left-most DNS label). If there is no SOA record, Lego requests the SOA record of the parent label, then for its parent, etc., until it reaches the apex domain2. Should any DNS label on the way be a CNAME, it is resolved as per usual.\nIn the default configuration, Lego uses the system name servers for this, and falls back to Google’s DNS servers, should they be absent.\nVerifying the challenge token.\nThe _acme-challenge.\u003cyourdomain\u003e TXT record must be correctly installed. Lego verifies this by directly querying the authoritative name server for this record (as detected in the previous step).\nStrictly speaking, this verification step is not necessary, but helps to protect your ACME account. Remember that some ACME providers impose a rate limit on certain actions (at the time of writing, Let’s Encrypt allows 300 new certificate orders per account per 3 hours).\nThere are also situations, where this verification step doesn’t work as expected:\nA “split DNS” setup gives different answers to clients on the internal network (Lego) vs. on the public internet (Let’s Encrypt). With “hidden master” setups, Lego may be able to directly talk to the primary DNS server, while the _acme-challenge record might not have fully propagated to the (public) secondary servers, yet. The effect is the same: Lego determined the challenge token to be installed correctly, while Let’s Encrypt has a different view, and rejects the certificate order.\nIn these cases, you can instruct Lego to use a different DNS resolver, using the --dns.resolvers flag. You should prefer one on the public internet, otherwise you might be susceptible to the same problem.\nOther options LEGO_CA_CERTIFICATES The environment variable LEGO_CA_CERTIFICATES allows to specify the path to PEM-encoded CA certificates that can be used to authenticate an ACME server with an HTTPS certificate not issued by a CA in the system-wide trusted root list.\nMultiple file paths can be added by using : (unix) or ; (Windows) as a separator.\nExample:\n# On Unix system LEGO_CA_CERTIFICATES=/foo/cert1.pem:/foo/cert2.pem LEGO_CA_SYSTEM_CERT_POOL The environment variable LEGO_CA_SYSTEM_CERT_POOL can be used to define if the certificates pool must use a copy of the system cert pool.\nExample:\nLEGO_CA_SYSTEM_CERT_POOL=true LEGO_CA_SERVER_NAME The environment variable LEGO_CA_SERVER_NAME allows to specify the CA server name used to authenticate an ACME server with an HTTPS certificate not issued by a CA in the system-wide trusted root list.\nExample:\nLEGO_CA_SERVER_NAME=foo LEGO_DISABLE_CNAME_SUPPORT By default, lego follows CNAME, the environment variable LEGO_DISABLE_CNAME_SUPPORT allows to disable this support.\nExample:\nLEGO_DISABLE_CNAME_SUPPORT=false LEGO_DEBUG_CLIENT_VERBOSE_ERROR The environment variable LEGO_DEBUG_CLIENT_VERBOSE_ERROR allows to enrich error messages from some of the DNS clients.\nExample:\nLEGO_DEBUG_CLIENT_VERBOSE_ERROR=true LEGO_DEBUG_DNS_API_HTTP_CLIENT ⚠️ WARNING: This will expose credentials in the log output! ⚠️\nDo not run this in production environments, or if you can’t be sure that logs aren’t accessed by third parties or tools (like log collectors).\nYou have been warned. Here be dragons.\nThe environment variable LEGO_DEBUG_DNS_API_HTTP_CLIENT allows debugging the DNS API interaction. It will dump the full request and response to the log output.\nSome DNS providers don’t support this option.\nExample:\nLEGO_DEBUG_DNS_API_HTTP_CLIENT=true LEGO_DEBUG_ACME_HTTP_CLIENT The environment variable LEGO_DEBUG_ACME_HTTP_CLIENT allows debug the calls to the ACME server.\nExample:\nLEGO_DEBUG_ACME_HTTP_CLIENT=true You must ensure that incoming validation requests contains the correct value for the HTTP Host header. If you operate lego behind a non-transparent reverse proxy (such as Apache or NGINX), you might need to alter the header field using --http.proxy-header X-Forwarded-Host. ↩︎\nThe apex domain is the domain you have registered with your domain registrar. For gTLDs (.com, .fyi) this is the 2nd level domain, but for ccTLDs, this can either be the 2nd level (.de) or 3rd level domain (.co.uk). ↩︎",
    "description": "This page describes various command line options.",
    "tags": [],
    "title": "Options",
    "uri": "/lego/usage/cli/options/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for 35.com/三五互联.\nCode: com35 Since: v4.31.0 Here is an example bash command using the 35.com/三五互联 provider:\nCOM35_USERNAME=\"xxx\" \\ COM35_PASSWORD=\"yyy\" \\ lego --dns com35 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description COM35_PASSWORD API password COM35_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description COM35_HTTP_TIMEOUT API request timeout in seconds (Default: 30) COM35_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) COM35_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) COM35_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for 35.com/三五互联.",
    "tags": [],
    "title": "35.com/三五互联",
    "uri": "/lego/dns/com35/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Active24.\nCode: active24 Since: v4.23.0 Here is an example bash command using the Active24 provider:\nACTIVE24_API_KEY=\"xxx\" \\ ACTIVE24_SECRET=\"yyy\" \\ lego --dns active24 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ACTIVE24_API_KEY API key ACTIVE24_SECRET Secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ACTIVE24_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ACTIVE24_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ACTIVE24_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ACTIVE24_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Active24.",
    "tags": [],
    "title": "Active24",
    "uri": "/lego/dns/active24/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Akamai edgedns supersedes FastDNS; implementing a DNS provider for solving the DNS-01 challenge using Akamai EdgeDNS\nCode: edgedns Since: v3.9.0 Here is an example bash command using the Akamai EdgeDNS provider:\nAKAMAI_CLIENT_SECRET=abcdefghijklmnopqrstuvwxyz1234567890ABCDEFG= \\ AKAMAI_CLIENT_TOKEN=akab-mnbvcxzlkjhgfdsapoiuytrewq1234567 \\ AKAMAI_HOST=akab-aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.luna.akamaiapis.net \\ AKAMAI_ACCESS_TOKEN=akab-1234567890qwerty-asdfghjklzxcvtnu \\ lego --dns edgedns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AKAMAI_ACCESS_TOKEN Access token, managed by the Akamai EdgeGrid client AKAMAI_CLIENT_SECRET Client secret, managed by the Akamai EdgeGrid client AKAMAI_CLIENT_TOKEN Client token, managed by the Akamai EdgeGrid client AKAMAI_EDGERC Path to the .edgerc file, managed by the Akamai EdgeGrid client AKAMAI_EDGERC_SECTION Configuration section, managed by the Akamai EdgeGrid client AKAMAI_HOST API host, managed by the Akamai EdgeGrid client The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AKAMAI_ACCOUNT_SWITCH_KEY Target account ID when the DNS zone and credentials belong to different accounts AKAMAI_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 15) AKAMAI_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 180) AKAMAI_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAkamai’s credentials are automatically detected in the following locations and prioritized in the following order:\nSection-specific environment variables (where {SECTION} is specified using AKAMAI_EDGERC_SECTION): AKAMAI_{SECTION}_HOST AKAMAI_{SECTION}_ACCESS_TOKEN AKAMAI_{SECTION}_CLIENT_TOKEN AKAMAI_{SECTION}_CLIENT_SECRET If AKAMAI_EDGERC_SECTION is not defined or is set to default, environment variables: AKAMAI_HOST AKAMAI_ACCESS_TOKEN AKAMAI_CLIENT_TOKEN AKAMAI_CLIENT_SECRET .edgerc file located at AKAMAI_EDGERC defaults to ~/.edgerc, sections can be specified using AKAMAI_EDGERC_SECTION Default environment variables: AKAMAI_HOST AKAMAI_ACCESS_TOKEN AKAMAI_CLIENT_TOKEN AKAMAI_CLIENT_SECRET See also:\nSetting up Akamai credentials .edgerc Format API Client Authentication Config from Env Manage many accounts More information API documentation Go client",
    "description": "Akamai edgedns supersedes FastDNS; implementing a DNS provider for solving the DNS-01 challenge using Akamai EdgeDNS",
    "tags": [],
    "title": "Akamai EdgeDNS",
    "uri": "/lego/dns/edgedns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Alibaba Cloud DNS.\nCode: alidns Since: v1.1.0 Here is an example bash command using the Alibaba Cloud DNS provider:\n# Setup using instance RAM role ALICLOUD_RAM_ROLE=lego \\ lego --dns alidns -d '*.example.com' -d example.com run # Or, using credentials ALICLOUD_ACCESS_KEY=abcdefghijklmnopqrstuvwx \\ ALICLOUD_SECRET_KEY=your-secret-key \\ ALICLOUD_SECURITY_TOKEN=your-sts-token \\ lego --dns alidns - -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ALICLOUD_ACCESS_KEY Access key ID ALICLOUD_RAM_ROLE Your instance RAM role (https://www.alibabacloud.com/help/en/ecs/user-guide/attach-an-instance-ram-role-to-an-ecs-instance) ALICLOUD_SECRET_KEY Access Key secret ALICLOUD_SECURITY_TOKEN STS Security Token (optional) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ALICLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 10) ALICLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ALICLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ALICLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Alibaba Cloud DNS.",
    "tags": [],
    "title": "Alibaba Cloud DNS",
    "uri": "/lego/dns/alidns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for AlibabaCloud ESA.\nCode: aliesa Since: v4.29.0 Here is an example bash command using the AlibabaCloud ESA provider:\n# Setup using instance RAM role ALIESA_RAM_ROLE=lego \\ lego --dns aliesa -d '*.example.com' -d example.com run # Or, using credentials ALIESA_ACCESS_KEY=abcdefghijklmnopqrstuvwx \\ ALIESA_SECRET_KEY=your-secret-key \\ ALIESA_SECURITY_TOKEN=your-sts-token \\ lego --dns aliesa - -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ALIESA_ACCESS_KEY Access key ID ALIESA_RAM_ROLE Your instance RAM role (https://www.alibabacloud.com/help/en/ecs/user-guide/attach-an-instance-ram-role-to-an-ecs-instance) ALIESA_SECRET_KEY Access Key secret ALIESA_SECURITY_TOKEN STS Security Token (optional) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ALIESA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ALIESA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ALIESA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ALIESA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for AlibabaCloud ESA.",
    "tags": [],
    "title": "AlibabaCloud ESA",
    "uri": "/lego/dns/aliesa/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for all-inkl.\nCode: allinkl Since: v4.5.0 Here is an example bash command using the all-inkl provider:\nALL_INKL_LOGIN=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ ALL_INKL_PASSWORD=yyyyyyyyyyyyyyyyyyyyyyyyyy \\ lego --dns allinkl -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ALL_INKL_LOGIN KAS login ALL_INKL_PASSWORD KAS password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ALL_INKL_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ALL_INKL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ALL_INKL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for all-inkl.",
    "tags": [],
    "title": "all-inkl",
    "uri": "/lego/dns/allinkl/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Alwaysdata.\nCode: alwaysdata Since: v4.31.0 Here is an example bash command using the Alwaysdata provider:\nALWAYSDATA_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns alwaysdata -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ALWAYSDATA_API_KEY API Key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ALWAYSDATA_ACCOUNT Account name ALWAYSDATA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ALWAYSDATA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ALWAYSDATA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ALWAYSDATA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Alwaysdata.",
    "tags": [],
    "title": "Alwaysdata",
    "uri": "/lego/dns/alwaysdata/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Amazon Lightsail.\nCode: lightsail Since: v0.5.0 Note Please contribute by adding a CLI example.\nCredentials Environment Variable Name Description AWS_ACCESS_KEY_ID Managed by the AWS client. Access key ID (AWS_ACCESS_KEY_ID_FILE is not supported, use AWS_SHARED_CREDENTIALS_FILE instead) AWS_SECRET_ACCESS_KEY Managed by the AWS client. Secret access key (AWS_SECRET_ACCESS_KEY_FILE is not supported, use AWS_SHARED_CREDENTIALS_FILE instead) DNS_ZONE Domain name of the DNS zone The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AWS_SHARED_CREDENTIALS_FILE Managed by the AWS client. Shared credentials file. LIGHTSAIL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) LIGHTSAIL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription AWS Credentials are automatically detected in the following locations and prioritized in the following order:\nEnvironment variables: AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, [AWS_SESSION_TOKEN] Shared credentials file (defaults to ~/.aws/credentials, profiles can be specified using AWS_PROFILE) Amazon EC2 IAM role AWS region is not required to set as the Lightsail DNS zone is in global (us-east-1) region.\nPolicy The following AWS IAM policy document describes the minimum permissions required for lego to complete the DNS challenge.\n{ \"Version\": \"2012-10-17\", \"Statement\": [ { \"Effect\": \"Allow\", \"Action\": [ \"lightsail:DeleteDomainEntry\", \"lightsail:CreateDomainEntry\" ], \"Resource\": \"\u003cLightsail DNS zone ARN\u003e\" } ] } Replace the Resource value with your Lightsail DNS zone ARN. You can retrieve the ARN using aws cli by running aws lightsail get-domains --region us-east-1 (Lightsail web console does not show the ARN, unfortunately). It should be in the format of arn:aws:lightsail:global:\u003cACCOUNT ID\u003e:Domain/\u003cDOMAIN ID\u003e. You also need to replace the region in the ARN to us-east-1 (instead of global).\nAlternatively, you can also set the Resource to * (wildcard), which allow to access all domain, but this is not recommended.\nMore information Go client",
    "description": "Configuration for Amazon Lightsail.",
    "tags": [],
    "title": "Amazon Lightsail",
    "uri": "/lego/dns/lightsail/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Amazon Route 53.\nCode: route53 Since: v0.3.0 Here is an example bash command using the Amazon Route 53 provider:\nAWS_ACCESS_KEY_ID=your_key_id \\ AWS_SECRET_ACCESS_KEY=your_secret_access_key \\ AWS_REGION=aws-region \\ AWS_HOSTED_ZONE_ID=your_hosted_zone_id \\ lego --dns route53 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AWS_ACCESS_KEY_ID Managed by the AWS client. Access key ID (AWS_ACCESS_KEY_ID_FILE is not supported, use AWS_SHARED_CREDENTIALS_FILE instead) AWS_ASSUME_ROLE_ARN Managed by the AWS Role ARN (AWS_ASSUME_ROLE_ARN_FILE is not supported) AWS_EXTERNAL_ID Managed by STS AssumeRole API operation (AWS_EXTERNAL_ID_FILE is not supported) AWS_HOSTED_ZONE_ID Override the hosted zone ID. AWS_PROFILE Managed by the AWS client (AWS_PROFILE_FILE is not supported) AWS_REGION Managed by the AWS client (AWS_REGION_FILE is not supported) AWS_SDK_LOAD_CONFIG Managed by the AWS client. Retrieve the region from the CLI config file (AWS_SDK_LOAD_CONFIG_FILE is not supported) AWS_SECRET_ACCESS_KEY Managed by the AWS client. Secret access key (AWS_SECRET_ACCESS_KEY_FILE is not supported, use AWS_SHARED_CREDENTIALS_FILE instead) AWS_WAIT_FOR_RECORD_SETS_CHANGED Wait for changes to be INSYNC (it can be unstable) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AWS_MAX_RETRIES The number of maximum returns the service will use to make an individual API request AWS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) AWS_PRIVATE_ZONE Set to true to use private zones only (default: use public zones only) AWS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) AWS_SHARED_CREDENTIALS_FILE Managed by the AWS client. Shared credentials file. AWS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 10) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription AWS Credentials are automatically detected in the following locations and prioritized in the following order:\nEnvironment variables: AWS_ACCESS_KEY_ID, AWS_SECRET_ACCESS_KEY, [AWS_SESSION_TOKEN] Shared credentials file (defaults to ~/.aws/credentials, profiles can be specified using AWS_PROFILE) Amazon EC2 IAM role The AWS Region is automatically detected in the following locations and prioritized in the following order:\nEnvironment variables: AWS_REGION Shared configuration file if AWS_SDK_LOAD_CONFIG is set (defaults to ~/.aws/config, profiles can be specified using AWS_PROFILE) If AWS_HOSTED_ZONE_ID is not set, Lego tries to determine the correct public hosted zone via the FQDN.\nSee also:\nsessions Setting AWS Credentials Setting AWS Region IAM Policy Examples Broad privileges for testing purposes The following IAM policy document grants access to the required APIs needed by lego to complete the DNS challenge. A word of caution: These permissions grant write access to any DNS record in any hosted zone, so it is recommended to narrow them down as much as possible if you are using this policy in production.\n{ \"Version\": \"2012-10-17\", \"Statement\": [ { \"Effect\": \"Allow\", \"Action\": [ \"route53:GetChange\", \"route53:ChangeResourceRecordSets\", \"route53:ListResourceRecordSets\" ], \"Resource\": [ \"arn:aws:route53:::hostedzone/*\", \"arn:aws:route53:::change/*\" ] }, { \"Effect\": \"Allow\", \"Action\": \"route53:ListHostedZonesByName\", \"Resource\": \"*\" } ] } Least privilege policy for production purposes The following AWS IAM policy document describes the least privilege permissions required for lego to complete the DNS challenge. Write access is limited to a specified hosted zone’s DNS TXT records with a key of _acme-challenge.example.com. Replace Z11111112222222333333 with your hosted zone ID and example.com with your domain name to use this policy.\n{ \"Version\": \"2012-10-17\", \"Statement\": [ { \"Effect\": \"Allow\", \"Action\": \"route53:GetChange\", \"Resource\": \"arn:aws:route53:::change/*\" }, { \"Effect\": \"Allow\", \"Action\": \"route53:ListHostedZonesByName\", \"Resource\": \"*\" }, { \"Effect\": \"Allow\", \"Action\": [ \"route53:ListResourceRecordSets\" ], \"Resource\": [ \"arn:aws:route53:::hostedzone/Z11111112222222333333\" ] }, { \"Effect\": \"Allow\", \"Action\": [ \"route53:ChangeResourceRecordSets\" ], \"Resource\": [ \"arn:aws:route53:::hostedzone/Z11111112222222333333\" ], \"Condition\": { \"ForAllValues:StringEquals\": { \"route53:ChangeResourceRecordSetsNormalizedRecordNames\": [ \"_acme-challenge.example.com\" ], \"route53:ChangeResourceRecordSetsRecordTypes\": [ \"TXT\" ] } } } ] } More information API documentation Go client",
    "description": "Configuration for Amazon Route 53.",
    "tags": [],
    "title": "Amazon Route 53",
    "uri": "/lego/dns/route53/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Anexia CloudDNS.\nCode: anexia Since: v4.28.0 Here is an example bash command using the Anexia CloudDNS provider:\nANEXIA_TOKEN=xxx \\ lego --dns anexia -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ANEXIA_TOKEN API token for Anexia Engine The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ANEXIA_API_URL API endpoint URL (default: https://engine.anexia-it.com) ANEXIA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ANEXIA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ANEXIA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) ANEXIA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription You need to create an API token in the Anexia Engine.\nThe token must have permissions to manage DNS zones and records.\nMore information API documentation",
    "description": "Configuration for Anexia CloudDNS.",
    "tags": [],
    "title": "Anexia CloudDNS",
    "uri": "/lego/dns/anexia/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ArvanCloud.\nCode: arvancloud Since: v3.8.0 Here is an example bash command using the ArvanCloud provider:\nARVANCLOUD_API_KEY=\"Apikey xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx\" \\ lego --dns arvancloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ARVANCLOUD_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ARVANCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ARVANCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ARVANCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) ARVANCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ArvanCloud.",
    "tags": [],
    "title": "ArvanCloud",
    "uri": "/lego/dns/arvancloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Aurora DNS.\nCode: auroradns Since: v0.4.0 Here is an example bash command using the Aurora DNS provider:\nAURORA_API_KEY=xxxxx \\ AURORA_SECRET=yyyyyy \\ lego --dns auroradns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AURORA_API_KEY API key or username to used AURORA_SECRET Secret password to be used The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AURORA_ENDPOINT API endpoint URL AURORA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AURORA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) AURORA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Aurora DNS.",
    "tags": [],
    "title": "Aurora DNS",
    "uri": "/lego/dns/auroradns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Autodns.\nCode: autodns Since: v3.2.0 Here is an example bash command using the Autodns provider:\nAUTODNS_API_USER=username \\ AUTODNS_API_PASSWORD=supersecretpassword \\ lego --dns autodns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AUTODNS_API_PASSWORD User Password AUTODNS_API_USER Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AUTODNS_CONTEXT API context (4 for production, 1 for testing. Defaults to 4) AUTODNS_ENDPOINT API endpoint URL, defaults to https://api.autodns.com/v1/ AUTODNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) AUTODNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AUTODNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) AUTODNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Autodns.",
    "tags": [],
    "title": "Autodns",
    "uri": "/lego/dns/autodns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Axelname.\nCode: axelname Since: v4.23.0 Here is an example bash command using the Axelname provider:\nAXELNAME_NICKNAME=\"yyy\" \\ AXELNAME_TOKEN=\"xxx\" \\ lego --dns axelname -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AXELNAME_NICKNAME Account nickname AXELNAME_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AXELNAME_HTTP_TIMEOUT API request timeout in seconds (Default: 30) AXELNAME_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AXELNAME_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) AXELNAME_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Axelname.",
    "tags": [],
    "title": "Axelname",
    "uri": "/lego/dns/axelname/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Azion.\nCode: azion Since: v4.24.0 Here is an example bash command using the Azion provider:\nAZION_PERSONAL_TOKEN=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns azion -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AZION_PERSONAL_TOKEN Your Azion personal token. The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AZION_HTTP_TIMEOUT API request timeout in seconds (Default: 30) AZION_PAGE_SIZE The page size for the API request (Default: 50) AZION_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AZION_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) AZION_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Azion.",
    "tags": [],
    "title": "Azion",
    "uri": "/lego/dns/azion/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Azure (deprecated).\nCode: azure Since: v0.4.0 Note Please contribute by adding a CLI example.\nCredentials Environment Variable Name Description AZURE_CLIENT_ID Client ID AZURE_CLIENT_SECRET Client secret AZURE_ENVIRONMENT Azure environment, one of: public, usgovernment, german, and china AZURE_RESOURCE_GROUP Resource group AZURE_SUBSCRIPTION_ID Subscription ID AZURE_TENANT_ID Tenant ID instance metadata service If the credentials are not set via the environment, then it will attempt to get a bearer token via the instance metadata service. The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AZURE_METADATA_ENDPOINT Metadata Service endpoint URL AZURE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AZURE_PRIVATE_ZONE Set to true to use Azure Private DNS Zones and not public AZURE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) AZURE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) AZURE_ZONE_NAME Zone name to use inside Azure DNS service to add the TXT record in The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Azure (deprecated).",
    "tags": [],
    "title": "Azure (deprecated)",
    "uri": "/lego/dns/azure/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Azure DNS.\nCode: azuredns Since: v4.13.0 Here is an example bash command using the Azure DNS provider:\n### Using client secret AZURE_CLIENT_ID=\u003cyour service principal client ID\u003e \\ AZURE_TENANT_ID=\u003cyour service principal tenant ID\u003e \\ AZURE_CLIENT_SECRET=\u003cyour service principal client secret\u003e \\ lego --dns azuredns -d '*.example.com' -d example.com run ### Using client certificate AZURE_CLIENT_ID=\u003cyour service principal client ID\u003e \\ AZURE_TENANT_ID=\u003cyour service principal tenant ID\u003e \\ AZURE_CLIENT_CERTIFICATE_PATH=\u003cyour service principal certificate path\u003e \\ lego --dns azuredns -d '*.example.com' -d example.com run ### Using Azure CLI az login \\ lego --dns azuredns -d '*.example.com' -d example.com run ### Using Managed Identity (Azure VM) AZURE_TENANT_ID=\u003cyour service principal tenant ID\u003e \\ AZURE_RESOURCE_GROUP=\u003cyour target zone resource group name\u003e \\ lego --dns azuredns -d '*.example.com' -d example.com run ### Using Managed Identity (Azure Arc) AZURE_TENANT_ID=\u003cyour service principal tenant ID\u003e \\ IMDS_ENDPOINT=http://localhost:40342 \\ IDENTITY_ENDPOINT=http://localhost:40342/metadata/identity/oauth2/token \\ lego --dns azuredns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description AZURE_CLIENT_CERTIFICATE_PATH Client certificate path AZURE_CLIENT_ID Client ID AZURE_CLIENT_SECRET Client secret AZURE_TENANT_ID Tenant ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description AZURE_AUTH_METHOD Specify which authentication method to use AZURE_AUTH_MSI_TIMEOUT Managed Identity timeout duration AZURE_ENVIRONMENT Azure environment, one of: public, usgovernment, and china AZURE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) AZURE_PRIVATE_ZONE Set to true to use Azure Private DNS Zones and not public AZURE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) AZURE_RESOURCE_GROUP DNS zone resource group AZURE_SERVICEDISCOVERY_FILTER Advanced ServiceDiscovery filter using Kusto query condition AZURE_SUBSCRIPTION_ID DNS zone subscription ID AZURE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) AZURE_ZONE_NAME Zone name to use inside Azure DNS service to add the TXT record in The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription Several authentication methods can be used to authenticate against Azure DNS API.\nDefault Azure Credentials (default option) Default Azure Credentials automatically detects in the following locations and prioritized in the following order:\nEnvironment variables for client secret: AZURE_CLIENT_ID, AZURE_TENANT_ID, AZURE_CLIENT_SECRET Environment variables for client certificate: AZURE_CLIENT_ID, AZURE_TENANT_ID, AZURE_CLIENT_CERTIFICATE_PATH Workload identity for resources hosted in Azure environment (see below) Shared credentials (defaults to ~/.azure folder), used by Azure CLI Link:\nAzure Authentication Environment variables Service Discovery Lego automatically finds all visible Azure (private) DNS zones using Azure ResourceGraph query. This can be limited by specifying environment variable AZURE_SUBSCRIPTION_ID and/or AZURE_RESOURCE_GROUP which limits the DNS zones to only a subscription or to one resourceGroup.\nAdditionally environment variable AZURE_SERVICEDISCOVERY_FILTER can be used to filter DNS zones with an addition Kusto filter eg:\nresources | where type =~ \"microsoft.network/dnszones\" | ${AZURE_SERVICEDISCOVERY_FILTER} | project subscriptionId, resourceGroup, name Client secret The Azure Credentials can be configured using the following environment variables:\nAZURE_CLIENT_ID = “Client ID” AZURE_CLIENT_SECRET = “Client secret” AZURE_TENANT_ID = “Tenant ID” This authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to env.\nClient certificate The Azure Credentials can be configured using the following environment variables:\nAZURE_CLIENT_ID = “Client ID” AZURE_CLIENT_CERTIFICATE_PATH = “Client certificate path” AZURE_TENANT_ID = “Tenant ID” This authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to env.\nWorkload identity Workload identity allows workloads running Azure Kubernetes Services (AKS) clusters to authenticate as an Azure AD application identity using federated credentials.\nThis must be configured in kubernetes workload deployment in one hand and on the Azure AD application registration in the other hand.\nHere is a summary of the steps to follow to use it :\ncreate a ServiceAccount resource, add following annotations to reference the targeted Azure AD application registration : azure.workload.identity/client-id and azure.workload.identity/tenant-id. on the Deployment resource you must reference the previous ServiceAccount and add the following label : azure.workload.identity/use: \"true\". create a federated credentials of type Kubernetes accessing Azure resources, add the cluster issuer URL and add the namespace and name of your kubernetes service account. Link :\nAzure AD Workload identity This authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to wli.\nAzure Managed Identity Azure Managed Identity (with Azure workload) The Azure Managed Identity service allows linking Azure AD identities to Azure resources, without needing to manually manage client IDs and secrets.\nWorkloads with a Managed Identity can manage their own certificates, with permissions on specific domain names set using IAM assignments. For this to work, the Managed Identity requires the Reader role on the target DNS Zone, and the DNS Zone Contributor on the relevant _acme-challenge TXT records.\nFor example, to allow a Managed Identity to create a certificate for “fw01.lab.example.com”, using Azure CLI:\nexport AZURE_SUBSCRIPTION_ID=\"00000000-0000-0000-0000-000000000000\" export AZURE_RESOURCE_GROUP=\"rg1\" export SERVICE_PRINCIPAL_ID=\"00000000-0000-0000-0000-000000000000\" export AZURE_DNS_ZONE=\"lab.example.com\" export AZ_HOSTNAME=\"fw01\" export AZ_RECORD_SET=\"_acme-challenge.${AZ_HOSTNAME}\" az role assignment create \\ --assignee \"${SERVICE_PRINCIPAL_ID}\" \\ --role \"Reader\" \\ --scope \"/subscriptions/${AZURE_SUBSCRIPTION_ID}/resourceGroups/${AZURE_RESOURCE_GROUP}/providers/Microsoft.Network/dnszones/${AZURE_DNS_ZONE}\" az role assignment create \\ --assignee \"${SERVICE_PRINCIPAL_ID}\" \\ --role \"DNS Zone Contributor\" \\ --scope \"/subscriptions/${AZURE_SUBSCRIPTION_ID}/resourceGroups/${AZURE_RESOURCE_GROUP}/providers/Microsoft.Network/dnszones/${AZURE_DNS_ZONE}/TXT/${AZ_RECORD_SET}\" A timeout wrapper is configured for this authentication method. The duration can be configured by setting the AZURE_AUTH_MSI_TIMEOUT. The default timeout is 2 seconds. This authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to msi.\nAzure Managed Identity (with Azure Arc) The Azure Arc agent provides the ability to use a Managed Identity on resources hosted outside of Azure (such as on-prem virtual machines, or VMs in another cloud provider).\nWhile the upstream azidentity SDK will try to automatically identify and use the Azure Arc metadata service, if you get azuredns: DefaultAzureCredential: failed to acquire a token. error messages, you may need to set the environment variables:\nIMDS_ENDPOINT=http://localhost:40342 IDENTITY_ENDPOINT=http://localhost:40342/metadata/identity/oauth2/token A timeout wrapper is configured for this authentication method. The duration can be configured by setting the AZURE_AUTH_MSI_TIMEOUT. The default timeout is 2 seconds. This authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to msi.\nAzure CLI The Azure CLI is a command-line tool provided by Microsoft to interact with Azure resources. It provides an easy way to authenticate by simply running az login command. The generated token will be cached by default in the ~/.azure folder.\nThis authentication method can be specifically used by setting the AZURE_AUTH_METHOD environment variable to cli.\nOpen ID Connect Open ID Connect is a mechanism that establish a trust relationship between a running environment and the Azure AD identity provider. It can be enabled by setting the AZURE_AUTH_METHOD environment variable to oidc.\nAzure DevOps Pipelines It can be enabled by setting the AZURE_AUTH_METHOD environment variable to pipeline.\nMore information API documentation Go client",
    "description": "Configuration for Azure DNS.",
    "tags": [],
    "title": "Azure DNS",
    "uri": "/lego/dns/azuredns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Baidu Cloud.\nCode: baiducloud Since: v4.23.0 Here is an example bash command using the Baidu Cloud provider:\nBAIDUCLOUD_ACCESS_KEY_ID=\"xxx\" \\ BAIDUCLOUD_SECRET_ACCESS_KEY=\"yyy\" \\ lego --dns baiducloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BAIDUCLOUD_ACCESS_KEY_ID Access key BAIDUCLOUD_SECRET_ACCESS_KEY Secret access key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BAIDUCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BAIDUCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) BAIDUCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Baidu Cloud.",
    "tags": [],
    "title": "Baidu Cloud",
    "uri": "/lego/dns/baiducloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Beget.com.\nCode: beget Since: v4.27.0 Here is an example bash command using the Beget.com provider:\nBEGET_USERNAME=xxxxxx \\ BEGET_PASSWORD=yyyyyy \\ lego --dns beget -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BEGET_PASSWORD API password BEGET_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BEGET_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BEGET_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 30) BEGET_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) BEGET_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Beget.com.",
    "tags": [],
    "title": "Beget.com",
    "uri": "/lego/dns/beget/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Binary Lane.\nCode: binarylane Since: v4.26.0 Here is an example bash command using the Binary Lane provider:\nBINARYLANE_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns binarylane -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BINARYLANE_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BINARYLANE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BINARYLANE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BINARYLANE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) BINARYLANE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Binary Lane.",
    "tags": [],
    "title": "Binary Lane",
    "uri": "/lego/dns/binarylane/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Bindman.\nCode: bindman Since: v2.6.0 Here is an example bash command using the Bindman provider:\nBINDMAN_MANAGER_ADDRESS=\u003cyour bindman manager address\u003e \\ lego --dns bindman -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BINDMAN_MANAGER_ADDRESS The server URL, should have scheme, hostname, and port (if required) of the Bindman-DNS Manager server The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BINDMAN_HTTP_TIMEOUT API request timeout in seconds (Default: 60) BINDMAN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BINDMAN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Bindman.",
    "tags": [],
    "title": "Bindman",
    "uri": "/lego/dns/bindman/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Bluecat.\nCode: bluecat Since: v0.5.0 Here is an example bash command using the Bluecat provider:\nBLUECAT_PASSWORD=mypassword \\ BLUECAT_DNS_VIEW=myview \\ BLUECAT_USER_NAME=myusername \\ BLUECAT_CONFIG_NAME=myconfig \\ BLUECAT_SERVER_URL=https://bam.example.com \\ BLUECAT_TTL=30 \\ lego --dns bluecat -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BLUECAT_CONFIG_NAME Configuration name BLUECAT_DNS_VIEW External DNS View Name BLUECAT_PASSWORD API password BLUECAT_SERVER_URL The server URL, should have scheme, hostname, and port (if required) of the authoritative Bluecat BAM serve BLUECAT_USER_NAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BLUECAT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BLUECAT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BLUECAT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) BLUECAT_SKIP_DEPLOY Skip deployements BLUECAT_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Bluecat.",
    "tags": [],
    "title": "Bluecat",
    "uri": "/lego/dns/bluecat/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for BookMyName.\nCode: bookmyname Since: v4.23.0 Here is an example bash command using the BookMyName provider:\nBOOKMYNAME_USERNAME=\"xxx\" \\ BOOKMYNAME_PASSWORD=\"yyy\" \\ lego --dns bookmyname -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BOOKMYNAME_PASSWORD Password BOOKMYNAME_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BOOKMYNAME_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BOOKMYNAME_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BOOKMYNAME_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) BOOKMYNAME_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for BookMyName.",
    "tags": [],
    "title": "BookMyName",
    "uri": "/lego/dns/bookmyname/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Brandit has been acquired by Abion. Abion has a different API.\nIf you are a Brandit/Albion user, you can try the PR https://github.com/go-acme/lego/pull/2112.\nCode: brandit Since: v4.11.0 Here is an example bash command using the Brandit (deprecated) provider:\nBRANDIT_API_KEY=xxxxxxxxxxxxxxxxxxxxx \\ BRANDIT_API_USERNAME=yyyyyyyyyyyyyyyyyyyy \\ lego --dns brandit -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BRANDIT_API_KEY The API key BRANDIT_API_USERNAME The API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BRANDIT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BRANDIT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BRANDIT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) BRANDIT_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Brandit has been acquired by Abion. Abion has a different API.\nIf you are a Brandit/Albion user, you can try the PR https://github.com/go-acme/lego/pull/2112.",
    "tags": [],
    "title": "Brandit (deprecated)",
    "uri": "/lego/dns/brandit/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Bunny.\nCode: bunny Since: v4.11.0 Here is an example bash command using the Bunny provider:\nBUNNY_API_KEY=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxxxxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx \\ lego --dns bunny -d '*.example.com' -d example.com run Credentials Environment Variable Name Description BUNNY_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description BUNNY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) BUNNY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) BUNNY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) BUNNY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Bunny.",
    "tags": [],
    "title": "Bunny",
    "uri": "/lego/dns/bunny/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Checkdomain.\nCode: checkdomain Since: v3.3.0 Here is an example bash command using the Checkdomain provider:\nCHECKDOMAIN_TOKEN=yoursecrettoken \\ lego --dns checkdomain -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CHECKDOMAIN_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CHECKDOMAIN_ENDPOINT API endpoint URL, defaults to https://api.checkdomain.de CHECKDOMAIN_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CHECKDOMAIN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 300) CHECKDOMAIN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 7) CHECKDOMAIN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Checkdomain.",
    "tags": [],
    "title": "Checkdomain",
    "uri": "/lego/dns/checkdomain/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Civo.\nCode: civo Since: v4.9.0 Here is an example bash command using the Civo provider:\nCIVO_TOKEN=xxxxxx \\ lego --dns civo -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CIVO_TOKEN Authentication token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CIVO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 30) CIVO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) CIVO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Civo.",
    "tags": [],
    "title": "Civo",
    "uri": "/lego/dns/civo/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage",
    "content": "Lego can be use as a CLI.\nGeneral InstructionsRead this first to clarify some assumptions made by the following guides.\nObtain a CertificateThis guide explains various ways to obtain a new certificate.\nRenew a CertificateThis guide describes how to renew existing certificates.\nOptionsThis page describes various command line options.",
    "description": "Lego can be use as a CLI.",
    "tags": [],
    "title": "CLI",
    "uri": "/lego/usage/cli/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Cloud.ru.\nCode: cloudru Since: v4.14.0 Here is an example bash command using the Cloud.ru provider:\nCLOUDRU_SERVICE_INSTANCE_ID=ppp \\ CLOUDRU_KEY_ID=xxx \\ CLOUDRU_SECRET=yyy \\ lego --dns cloudru -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CLOUDRU_KEY_ID Key ID (login) CLOUDRU_SECRET Key Secret CLOUDRU_SERVICE_INSTANCE_ID Service Instance ID (parentId) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CLOUDRU_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CLOUDRU_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) CLOUDRU_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) CLOUDRU_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 120) CLOUDRU_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Cloud.ru.",
    "tags": [],
    "title": "Cloud.ru",
    "uri": "/lego/dns/cloudru/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for CloudDNS.\nCode: clouddns Since: v3.6.0 Here is an example bash command using the CloudDNS provider:\nCLOUDDNS_CLIENT_ID=bLsdFAks23429841238feb177a572aX \\ CLOUDDNS_EMAIL=you@example.com \\ CLOUDDNS_PASSWORD=b9841238feb177a84330f \\ lego --dns clouddns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CLOUDDNS_CLIENT_ID Client ID CLOUDDNS_EMAIL Account email CLOUDDNS_PASSWORD Account password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CLOUDDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CLOUDDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) CLOUDDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) CLOUDDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for CloudDNS.",
    "tags": [],
    "title": "CloudDNS",
    "uri": "/lego/dns/clouddns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Cloudflare.\nCode: cloudflare Since: v0.3.0 Here is an example bash command using the Cloudflare provider:\nCLOUDFLARE_EMAIL=you@example.com \\ CLOUDFLARE_API_KEY=b9841238feb177a84330febba8a83208921177bffe733 \\ lego --dns cloudflare -d '*.example.com' -d example.com run # or CLOUDFLARE_DNS_API_TOKEN=1234567890abcdefghijklmnopqrstuvwxyz \\ lego --dns cloudflare -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CF_API_EMAIL Account email CF_API_KEY API key CF_DNS_API_TOKEN API token with DNS:Edit permission (since v3.1.0) CF_ZONE_API_TOKEN API token with Zone:Read permission (since v3.1.0) CLOUDFLARE_API_KEY Alias to CF_API_KEY CLOUDFLARE_DNS_API_TOKEN Alias to CF_DNS_API_TOKEN CLOUDFLARE_EMAIL Alias to CF_API_EMAIL CLOUDFLARE_ZONE_API_TOKEN Alias to CF_ZONE_API_TOKEN The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CLOUDFLARE_BASE_URL API base URL (Default: https://api.cloudflare.com/client/v4) CLOUDFLARE_HTTP_TIMEOUT API request timeout in seconds (Default: ) CLOUDFLARE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) CLOUDFLARE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) CLOUDFLARE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription You may use CF_API_EMAIL and CF_API_KEY to authenticate, or CF_DNS_API_TOKEN, or CF_DNS_API_TOKEN and CF_ZONE_API_TOKEN.\nAPI keys If using API keys (CF_API_EMAIL and CF_API_KEY), the Global API Key needs to be used, not the Origin CA Key.\nPlease be aware, that this in principle allows Lego to read and change everything related to this account.\nAPI tokens With API tokens (CF_DNS_API_TOKEN, and optionally CF_ZONE_API_TOKEN), very specific access can be granted to your resources at Cloudflare. See this Cloudflare announcement for details.\nThe main resources Lego cares for are the DNS entries for your Zones. It also needs to resolve a domain name to an internal Zone ID in order to manipulate DNS entries.\nHence, you should create an API token with the following permissions:\nZone / Zone / Read Zone / DNS / Edit You also need to scope the access to all your domains for this to work. Then pass the API token as CF_DNS_API_TOKEN to Lego.\nAlternatively, if you prefer a more strict set of privileges, you can split the access tokens:\nCreate one with Zone / Zone / Read permissions and scope it to all your zones or just the individual zone you need to edit. This is needed to resolve domain names to Zone IDs and can be shared among multiple Lego installations. Pass this API token as CF_ZONE_API_TOKEN to Lego. Create another API token with Zone / DNS / Edit permissions and set the scope to the domains you want to manage with a single Lego installation. Pass this token as CF_DNS_API_TOKEN to Lego. Repeat the previous step for each host you want to run Lego on. It is possible to use the same api token for both variables if it is given Zone:Read and DNS:Edit permission for the zone. This “paranoid” setup is mainly interesting for users who manage many zones/domains with a single Cloudflare account. It follows the principle of least privilege and limits the possible damage, should one of the hosts become compromised.\nMore information API documentation Go client",
    "description": "Configuration for Cloudflare.",
    "tags": [],
    "title": "Cloudflare",
    "uri": "/lego/dns/cloudflare/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ClouDNS.\nCode: cloudns Since: v2.3.0 Here is an example bash command using the ClouDNS provider:\nCLOUDNS_AUTH_ID=xxxx \\ CLOUDNS_AUTH_PASSWORD=yyyy \\ lego --dns cloudns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CLOUDNS_AUTH_ID The API user ID CLOUDNS_AUTH_PASSWORD The password for API user ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CLOUDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CLOUDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) CLOUDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 180) CLOUDNS_SUB_AUTH_ID The API sub user ID CLOUDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ClouDNS.",
    "tags": [],
    "title": "ClouDNS",
    "uri": "/lego/dns/cloudns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "The CloudXNS DNS provider has shut down.\nCode: cloudxns Since: v0.5.0 Here is an example bash command using the CloudXNS (Deprecated) provider:\nCLOUDXNS_API_KEY=xxxx \\ CLOUDXNS_SECRET_KEY=yyyy \\ lego --dns cloudxns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CLOUDXNS_API_KEY The API key CLOUDXNS_SECRET_KEY The API secret key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CLOUDXNS_HTTP_TIMEOUT API request timeout in seconds (Default: ) CLOUDXNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: ) CLOUDXNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: ) CLOUDXNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: ) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.",
    "description": "The CloudXNS DNS provider has shut down.",
    "tags": [],
    "title": "CloudXNS (Deprecated)",
    "uri": "/lego/dns/cloudxns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ConoHa v2.\nCode: conoha Since: v1.2.0 Here is an example bash command using the ConoHa v2 provider:\nCONOHA_TENANT_ID=487727e3921d44e3bfe7ebb337bf085e \\ CONOHA_API_USERNAME=xxxx \\ CONOHA_API_PASSWORD=yyyy \\ lego --dns conoha -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CONOHA_API_PASSWORD The API password CONOHA_API_USERNAME The API username CONOHA_TENANT_ID Tenant ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CONOHA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CONOHA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) CONOHA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) CONOHA_REGION The region (Default: tyo1) CONOHA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ConoHa v2.",
    "tags": [],
    "title": "ConoHa v2",
    "uri": "/lego/dns/conoha/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ConoHa v3.\nCode: conohav3 Since: v4.24.0 Here is an example bash command using the ConoHa v3 provider:\nCONOHAV3_TENANT_ID=487727e3921d44e3bfe7ebb337bf085e \\ CONOHAV3_API_USER_ID=xxxx \\ CONOHAV3_API_PASSWORD=yyyy \\ lego --dns conohav3 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CONOHAV3_API_PASSWORD The API password CONOHAV3_API_USER_ID The API user ID CONOHAV3_TENANT_ID Tenant ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CONOHAV3_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CONOHAV3_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) CONOHAV3_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) CONOHAV3_REGION The region (Default: c3j1) CONOHAV3_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ConoHa v3.",
    "tags": [],
    "title": "ConoHa v3",
    "uri": "/lego/dns/conohav3/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Constellix.\nCode: constellix Since: v3.4.0 Here is an example bash command using the Constellix provider:\nCONSTELLIX_API_KEY=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx \\ CONSTELLIX_SECRET_KEY=xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx \\ lego --dns constellix -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CONSTELLIX_API_KEY User API key CONSTELLIX_SECRET_KEY User secret key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CONSTELLIX_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CONSTELLIX_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) CONSTELLIX_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) CONSTELLIX_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Constellix.",
    "tags": [],
    "title": "Constellix",
    "uri": "/lego/dns/constellix/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Core-Networks.\nCode: corenetworks Since: v4.20.0 Here is an example bash command using the Core-Networks provider:\nCORENETWORKS_LOGIN=\"xxxx\" \\ CORENETWORKS_PASSWORD=\"yyyy\" \\ lego --dns corenetworks -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CORENETWORKS_LOGIN The username of the API account CORENETWORKS_PASSWORD The password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CORENETWORKS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CORENETWORKS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) CORENETWORKS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) CORENETWORKS_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) CORENETWORKS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Core-Networks.",
    "tags": [],
    "title": "Core-Networks",
    "uri": "/lego/dns/corenetworks/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for CPanel/WHM.\nCode: cpanel Since: v4.16.0 Here is an example bash command using the CPanel/WHM provider:\n### CPANEL (default) CPANEL_USERNAME=\"yyyy\" \\ CPANEL_TOKEN=\"xxxx\" \\ CPANEL_BASE_URL=\"https://example.com:2083\" \\ lego --dns cpanel -d '*.example.com' -d example.com run ## WHM CPANEL_MODE=whm \\ CPANEL_USERNAME=\"yyyy\" \\ CPANEL_TOKEN=\"xxxx\" \\ CPANEL_BASE_URL=\"https://example.com:2087\" \\ lego --dns cpanel -d '*.example.com' -d example.com run Credentials Environment Variable Name Description CPANEL_BASE_URL API server URL CPANEL_TOKEN API token CPANEL_USERNAME username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description CPANEL_HTTP_TIMEOUT API request timeout in seconds (Default: 30) CPANEL_MODE use cpanel API or WHM API (Default: cpanel) CPANEL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) CPANEL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) CPANEL_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information",
    "description": "Configuration for CPanel/WHM.",
    "tags": [],
    "title": "CPanel/WHM",
    "uri": "/lego/dns/cpanel/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Derak Cloud.\nCode: derak Since: v4.12.0 Here is an example bash command using the Derak Cloud provider:\nDERAK_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns derak -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DERAK_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DERAK_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DERAK_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) DERAK_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) DERAK_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) DERAK_WEBSITE_ID Force the zone/website ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.",
    "description": "Configuration for Derak Cloud.",
    "tags": [],
    "title": "Derak Cloud",
    "uri": "/lego/dns/derak/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for deSEC.io.\nCode: desec Since: v3.7.0 Here is an example bash command using the deSEC.io provider:\nDESEC_TOKEN=x-xxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns desec -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DESEC_TOKEN Domain token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DESEC_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DESEC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) DESEC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) DESEC_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for deSEC.io.",
    "tags": [],
    "title": "deSEC.io",
    "uri": "/lego/dns/desec/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Designate DNSaaS for Openstack.\nCode: designate Since: v2.2.0 Here is an example bash command using the Designate DNSaaS for Openstack provider:\n# With a `clouds.yaml` OS_CLOUD=my_openstack \\ lego --dns designate -d '*.example.com' -d example.com run # or OS_AUTH_URL=https://openstack.example.org \\ OS_REGION_NAME=RegionOne \\ OS_PROJECT_ID=23d4522a987d4ab529f722a007c27846 OS_USERNAME=myuser \\ OS_PASSWORD=passw0rd \\ lego --dns designate -d '*.example.com' -d example.com run # or OS_AUTH_URL=https://openstack.example.org \\ OS_REGION_NAME=RegionOne \\ OS_AUTH_TYPE=v3applicationcredential \\ OS_APPLICATION_CREDENTIAL_ID=imn74uq0or7dyzz20dwo1ytls4me8dry \\ OS_APPLICATION_CREDENTIAL_SECRET=68FuSPSdQqkFQYH5X1OoriEIJOwyLtQ8QSqXZOc9XxFK1A9tzZT6He2PfPw0OMja \\ lego --dns designate -d '*.example.com' -d example.com run Credentials Environment Variable Name Description OS_APPLICATION_CREDENTIAL_ID Application credential ID OS_APPLICATION_CREDENTIAL_NAME Application credential name OS_APPLICATION_CREDENTIAL_SECRET Application credential secret OS_AUTH_URL Identity endpoint URL OS_PASSWORD Password OS_PROJECT_NAME Project name OS_REGION_NAME Region name OS_USERNAME Username OS_USER_ID User ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DESIGNATE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) DESIGNATE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) DESIGNATE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 10) DESIGNATE_ZONE_NAME The zone name to use in the OpenStack Project to manage TXT records. OS_PROJECT_ID Project ID OS_TENANT_NAME Tenant name (deprecated see OS_PROJECT_NAME and OS_PROJECT_ID) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription There are three main ways of authenticating with Designate:\nThe first one is by using the OS_CLOUD environment variable and a clouds.yaml file. The second one is using your username and password, via the OS_USERNAME, OS_PASSWORD and OS_PROJECT_NAME environment variables. The third one is by using an application credential, via the OS_APPLICATION_CREDENTIAL_* and OS_USER_ID environment variables. For the username/password and application methods, the OS_AUTH_URL and OS_REGION_NAME environment variables are required.\nFor more information, you can read about the different methods of authentication with OpenStack in the Keystone’s documentation and the gophercloud documentation:\nKeystone username/password Keystone application credentials Public cloud providers with support for Designate:\nFuga Cloud More information API documentation Go client",
    "description": "Configuration for Designate DNSaaS for Openstack.",
    "tags": [],
    "title": "Designate DNSaaS for Openstack",
    "uri": "/lego/dns/designate/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Digital Ocean.\nCode: digitalocean Since: v0.3.0 Here is an example bash command using the Digital Ocean provider:\nDO_AUTH_TOKEN=xxxxxx \\ lego --dns digitalocean -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DO_AUTH_TOKEN Authentication token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DO_API_URL The URL of the API DO_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) DO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 30) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Digital Ocean.",
    "tags": [],
    "title": "Digital Ocean",
    "uri": "/lego/dns/digitalocean/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for DirectAdmin.\nCode: directadmin Since: v4.18.0 Here is an example bash command using the DirectAdmin provider:\nDIRECTADMIN_API_URL=\"http://example.com:2222\" \\ DIRECTADMIN_USERNAME=xxxx \\ DIRECTADMIN_PASSWORD=yyy \\ lego --dns directadmin -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DIRECTADMIN_API_URL URL of the API DIRECTADMIN_PASSWORD API password DIRECTADMIN_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DIRECTADMIN_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DIRECTADMIN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) DIRECTADMIN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DIRECTADMIN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 30) DIRECTADMIN_ZONE_NAME Zone name used to add the TXT record The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for DirectAdmin.",
    "tags": [],
    "title": "DirectAdmin",
    "uri": "/lego/dns/directadmin/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for DNS Made Easy.\nCode: dnsmadeeasy Since: v0.4.0 Here is an example bash command using the DNS Made Easy provider:\nDNSMADEEASY_API_KEY=xxxxxx \\ DNSMADEEASY_API_SECRET=yyyyy \\ lego --dns dnsmadeeasy -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DNSMADEEASY_API_KEY The API key DNSMADEEASY_API_SECRET The API Secret key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DNSMADEEASY_HTTP_TIMEOUT API request timeout in seconds (Default: 10) DNSMADEEASY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DNSMADEEASY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DNSMADEEASY_SANDBOX Activate the sandbox (boolean) DNSMADEEASY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for DNS Made Easy.",
    "tags": [],
    "title": "DNS Made Easy",
    "uri": "/lego/dns/dnsmadeeasy/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for dnsHome.de.\nCode: dnshomede Since: v4.10.0 Here is an example bash command using the dnsHome.de provider:\nDNSHOMEDE_CREDENTIALS=example.org:password \\ lego --dns dnshomede -d '*.example.com' -d example.com run DNSHOMEDE_CREDENTIALS=my.example.org:password1,demo.example.org:password2 \\ lego --dns dnshomede -d my.example.org -d demo.example.org Credentials Environment Variable Name Description DNSHOMEDE_CREDENTIALS Comma-separated list of domain:password credential pairs The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DNSHOMEDE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DNSHOMEDE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 1200) DNSHOMEDE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 2) DNSHOMEDE_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.",
    "description": "Configuration for dnsHome.de.",
    "tags": [],
    "title": "dnsHome.de",
    "uri": "/lego/dns/dnshomede/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for DNSimple.\nCode: dnsimple Since: v0.3.0 Here is an example bash command using the DNSimple provider:\nDNSIMPLE_OAUTH_TOKEN=1234567890abcdefghijklmnopqrstuvwxyz \\ lego --dns dnsimple -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DNSIMPLE_OAUTH_TOKEN OAuth token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DNSIMPLE_BASE_URL API endpoint URL DNSIMPLE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DNSIMPLE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DNSIMPLE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription DNSIMPLE_BASE_URL is optional and must be set to production (https://api.dnsimple.com). if DNSIMPLE_BASE_URL is not defined or empty, the production URL is used by default.\nWhile you can manage DNS records in the DNSimple Sandbox environment, DNS records will not resolve, and you will not be able to satisfy the ACME DNS challenge.\nTo authenticate you need to provide a valid API token. HTTP Basic Authentication is intentionally not supported.\nAPI tokens You can generate a new API token from your account page. Only Account API tokens are supported, if you try to use a User API token you will receive an error message.\nMore information API documentation Go client",
    "description": "Configuration for DNSimple.",
    "tags": [],
    "title": "DNSimple",
    "uri": "/lego/dns/dnsimple/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Use the Tencent Cloud provider instead.\nCode: dnspod Since: v0.4.0 Here is an example bash command using the DNSPod (deprecated) provider:\nDNSPOD_API_KEY=xxxxxx \\ lego --dns dnspod -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DNSPOD_API_KEY The user token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DNSPOD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DNSPOD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DNSPOD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DNSPOD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Use the Tencent Cloud provider instead.",
    "tags": [],
    "title": "DNSPod (deprecated)",
    "uri": "/lego/dns/dnspod/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Domain Offensive (do.de).\nCode: dode Since: v2.4.0 Here is an example bash command using the Domain Offensive (do.de) provider:\nDODE_TOKEN=xxxxxx \\ lego --dns dode -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DODE_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DODE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DODE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DODE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DODE_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Domain Offensive (do.de).",
    "tags": [],
    "title": "Domain Offensive (do.de)",
    "uri": "/lego/dns/dode/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Domeneshop.\nCode: domeneshop Since: v4.3.0 Here is an example bash command using the Domeneshop provider:\nDOMENESHOP_API_TOKEN=\u003ctoken\u003e \\ DOMENESHOP_API_SECRET=\u003csecret\u003e \\ lego --dns domeneshop -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DOMENESHOP_API_SECRET API secret DOMENESHOP_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DOMENESHOP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DOMENESHOP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) DOMENESHOP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAPI credentials Visit the following page for information on how to create API credentials with Domeneshop:\nhttps://api.domeneshop.no/docs/#section/Authentication\nMore information API documentation",
    "description": "Configuration for Domeneshop.",
    "tags": [],
    "title": "Domeneshop",
    "uri": "/lego/dns/domeneshop/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for DreamHost.\nCode: dreamhost Since: v1.1.0 Here is an example bash command using the DreamHost provider:\nDREAMHOST_API_KEY=\"YOURAPIKEY\" \\ lego --dns dreamhost -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DREAMHOST_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DREAMHOST_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DREAMHOST_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 60) DREAMHOST_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for DreamHost.",
    "tags": [],
    "title": "DreamHost",
    "uri": "/lego/dns/dreamhost/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Duck DNS.\nCode: duckdns Since: v0.5.0 Here is an example bash command using the Duck DNS provider:\nDUCKDNS_TOKEN=xxxxxx \\ lego --dns duckdns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DUCKDNS_TOKEN Account token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DUCKDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DUCKDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DUCKDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DUCKDNS_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Duck DNS.",
    "tags": [],
    "title": "Duck DNS",
    "uri": "/lego/dns/duckdns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Dyn.\nCode: dyn Since: v0.3.0 Here is an example bash command using the Dyn provider:\nDYN_CUSTOMER_NAME=xxxxxx \\ DYN_USER_NAME=yyyyy \\ DYN_PASSWORD=zzzz \\ lego --dns dyn -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DYN_CUSTOMER_NAME Customer name DYN_PASSWORD Password DYN_USER_NAME User name The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DYN_HTTP_TIMEOUT API request timeout in seconds (Default: 10) DYN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DYN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) DYN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Dyn.",
    "tags": [],
    "title": "Dyn",
    "uri": "/lego/dns/dyn/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for DynDnsFree.de.\nCode: dyndnsfree Since: v4.23.0 Here is an example bash command using the DynDnsFree.de provider:\nDYNDNSFREE_USERNAME=\"xxx\" \\ DYNDNSFREE_PASSWORD=\"yyy\" \\ lego --dns dyndnsfree -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DYNDNSFREE_PASSWORD Password DYNDNSFREE_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DYNDNSFREE_HTTP_TIMEOUT Request timeout in seconds (Default: 30) DYNDNSFREE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) DYNDNSFREE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for DynDnsFree.de.",
    "tags": [],
    "title": "DynDnsFree.de",
    "uri": "/lego/dns/dyndnsfree/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Dynu.\nCode: dynu Since: v3.5.0 Here is an example bash command using the Dynu provider:\nDYNU_API_KEY=1234567890abcdefghijklmnopqrstuvwxyz \\ lego --dns dynu -d '*.example.com' -d example.com run Credentials Environment Variable Name Description DYNU_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description DYNU_HTTP_TIMEOUT API request timeout in seconds (Default: 30) DYNU_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) DYNU_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 180) DYNU_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Dynu.",
    "tags": [],
    "title": "Dynu",
    "uri": "/lego/dns/dynu/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for EasyDNS.\nCode: easydns Since: v2.6.0 Here is an example bash command using the EasyDNS provider:\nEASYDNS_TOKEN=xxx \\ EASYDNS_KEY=yyy \\ lego --dns easydns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EASYDNS_KEY API Key EASYDNS_TOKEN API Token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EASYDNS_ENDPOINT The endpoint URL of the API Server EASYDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) EASYDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) EASYDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) EASYDNS_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) EASYDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nTo test with the sandbox environment set EASYDNS_ENDPOINT=https://sandbox.rest.easydns.net\nMore information API documentation",
    "description": "Configuration for EasyDNS.",
    "tags": [],
    "title": "EasyDNS",
    "uri": "/lego/dns/easydns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for EdgeCenter.\nCode: edgecenter Since: v4.29.0 Here is an example bash command using the EdgeCenter provider:\nEDGECENTER_PERMANENT_API_TOKEN=xxxxx \\ lego --dns edgecenter -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EDGECENTER_PERMANENT_API_TOKEN Permanent API token (https://edgecenter.ru/blog/permanent-api-token-explained/) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EDGECENTER_HTTP_TIMEOUT API request timeout in seconds (Default: 10) EDGECENTER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) EDGECENTER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 360) EDGECENTER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for EdgeCenter.",
    "tags": [],
    "title": "EdgeCenter",
    "uri": "/lego/dns/edgecenter/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Efficient IP.\nCode: efficientip Since: v4.13.0 Here is an example bash command using the Efficient IP provider:\nEFFICIENTIP_USERNAME=\"user\" \\ EFFICIENTIP_PASSWORD=\"secret\" \\ EFFICIENTIP_HOSTNAME=\"ipam.example.org\" \\ EFFICIENTIP_DNS_NAME=\"dns.smart\" \\ lego --dns efficientip -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EFFICIENTIP_DNS_NAME DNS name (ex: dns.smart) EFFICIENTIP_HOSTNAME Hostname (ex: foo.example.com) EFFICIENTIP_PASSWORD Password EFFICIENTIP_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EFFICIENTIP_HTTP_TIMEOUT API request timeout in seconds (Default: 10) EFFICIENTIP_INSECURE_SKIP_VERIFY Whether or not to verify EfficientIP API certificate EFFICIENTIP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) EFFICIENTIP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) EFFICIENTIP_VIEW_NAME View name (ex: external) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.",
    "description": "Configuration for Efficient IP.",
    "tags": [],
    "title": "Efficient IP",
    "uri": "/lego/dns/efficientip/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Epik.\nCode: epik Since: v4.5.0 Here is an example bash command using the Epik provider:\nEPIK_SIGNATURE=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns epik -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EPIK_SIGNATURE Epik API signature (https://registrar.epik.com/account/api-settings/) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EPIK_HTTP_TIMEOUT API request timeout in seconds (Default: 30) EPIK_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) EPIK_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) EPIK_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Epik.",
    "tags": [],
    "title": "Epik",
    "uri": "/lego/dns/epik/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage \u003e CLI",
    "content": "Note Heads up! We’ve restructured the content a bit.\nYou’ll find the content now at one of these pages:\nGuide: How to obtain a certificate Using the built-in web server Using a DNS provider Using a custom certificate signing request (CSR) Using an existing, running web server Running a script afterward Use case Guide: How to renew a certificate Using the built-in web server Using a DNS provider Running a script afterward Automatic renewal Reference: Command line options Usage Let’s Encrypt ACME server Running without root privileges Port Usage",
    "description": "Note Heads up! We’ve restructured the content a bit.\nYou’ll find the content now at one of these pages:\nGuide: How to obtain a certificate Using the built-in web server Using a DNS provider Using a custom certificate signing request (CSR) Using an existing, running web server Running a script afterward Use case Guide: How to renew a certificate Using the built-in web server Using a DNS provider Running a script afterward Automatic renewal Reference: Command line options Usage Let’s Encrypt ACME server Running without root privileges Port Usage",
    "tags": [],
    "title": "Examples",
    "uri": "/lego/usage/cli/examples/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Exoscale.\nCode: exoscale Since: v0.4.0 Here is an example bash command using the Exoscale provider:\nEXOSCALE_API_KEY=abcdefghijklmnopqrstuvwx \\ EXOSCALE_API_SECRET=xxxxxxx \\ lego --dns exoscale -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EXOSCALE_API_KEY API key EXOSCALE_API_SECRET API secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EXOSCALE_ENDPOINT API endpoint URL EXOSCALE_HTTP_TIMEOUT API request timeout in seconds (Default: 60) EXOSCALE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) EXOSCALE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) EXOSCALE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Exoscale.",
    "tags": [],
    "title": "Exoscale",
    "uri": "/lego/dns/exoscale/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Solving the DNS-01 challenge using an external program.\nCode: exec Since: v0.5.0 Here is an example bash command using the External program provider:\nEXEC_PATH=/the/path/to/myscript.sh \\ lego --dns exec -d '*.example.com' -d example.com run Base Configuration Environment Variable Name Description EXEC_MODE RAW, none EXEC_PATH The path of the the external program. Additional Configuration Environment Variable Name Description EXEC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 3). EXEC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60). EXEC_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60). Description The file name of the external program is specified in the environment variable EXEC_PATH.\nWhen it is run by lego, three command-line parameters are passed to it: The action (“present” or “cleanup”), the fully-qualified domain name and the value for the record.\nFor example, requesting a certificate for the domain ‘my.example.org’ can be achieved by calling lego as follows:\nEXEC_PATH=./update-dns.sh \\ lego --dns exec --d my.example.org run It will then call the program ‘./update-dns.sh’ with like this:\n./update-dns.sh \"present\" \"_acme-challenge.my.example.org.\" \"MsijOYZxqyjGnFGwhjrhfg-Xgbl5r68WPda0J9EgqqI\" The program then needs to make sure the record is inserted. When it returns an error via a non-zero exit code, lego aborts.\nWhen the record is to be removed again, the program is called with the first command-line parameter set to cleanup instead of present.\nIf you want to use the raw domain, token, and keyAuth values with your program, you can set EXEC_MODE=RAW:\nEXEC_MODE=RAW \\ EXEC_PATH=./update-dns.sh \\ lego --dns exec -d my.example.org run It will then call the program ./update-dns.sh like this:\n./update-dns.sh \"present\" \"--\" \"my.example.org.\" \"some-token\" \"KxAy-J3NwUmg9ZQuM-gP_Mq1nStaYSaP9tYQs5_-YsE.ksT-qywTd8058G-SHHWA3RAN72Pr0yWtPYmmY5UBpQ8\" Commands Note The -- is because the token MAY start with a -, and the called program may try and interpret a - as indicating a flag. In the case of urfave, which is commonly used, you can use the -- delimiter to specify the start of positional arguments, and handle such a string safely.\nPresent Mode Command default myprogram present \u003cFQDN\u003e \u003crecord\u003e RAW myprogram present -- \u003cdomain\u003e \u003ctoken\u003e \u003ckey_auth\u003e Cleanup Mode Command default myprogram cleanup \u003cFQDN\u003e \u003crecord\u003e RAW myprogram cleanup -- \u003cdomain\u003e \u003ctoken\u003e \u003ckey_auth\u003e",
    "description": "Solving the DNS-01 challenge using an external program.",
    "tags": [],
    "title": "External program",
    "uri": "/lego/dns/exec/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for F5 XC.\nCode: f5xc Since: v4.23.0 Here is an example bash command using the F5 XC provider:\nF5XC_API_TOKEN=\"xxx\" \\ F5XC_TENANT_NAME=\"yyy\" \\ F5XC_GROUP_NAME=\"zzz\" \\ lego --dns f5xc -d '*.example.com' -d example.com run Credentials Environment Variable Name Description F5XC_API_TOKEN API token F5XC_GROUP_NAME Group name F5XC_TENANT_NAME XC Tenant shortname The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description F5XC_HTTP_TIMEOUT API request timeout in seconds (Default: 30) F5XC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) F5XC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) F5XC_SERVER Server domain (Default: console.ves.volterra.io) F5XC_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for F5 XC.",
    "tags": [],
    "title": "F5 XC",
    "uri": "/lego/dns/f5xc/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for freemyip.com.\nCode: freemyip Since: v4.5.0 Here is an example bash command using the freemyip.com provider:\nFREEMYIP_TOKEN=xxxxxx \\ lego --dns freemyip -d '*.example.com' -d example.com run Credentials Environment Variable Name Description FREEMYIP_TOKEN Account token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description FREEMYIP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) FREEMYIP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) FREEMYIP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) FREEMYIP_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) FREEMYIP_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for freemyip.com.",
    "tags": [],
    "title": "freemyip.com",
    "uri": "/lego/dns/freemyip/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for G-Core.\nCode: gcore Since: v4.5.0 Here is an example bash command using the G-Core provider:\nGCORE_PERMANENT_API_TOKEN=xxxxx \\ lego --dns gcore -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GCORE_PERMANENT_API_TOKEN Permanent API token (https://gcore.com/blog/permanent-api-token-explained/) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GCORE_HTTP_TIMEOUT API request timeout in seconds (Default: 10) GCORE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) GCORE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 360) GCORE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for G-Core.",
    "tags": [],
    "title": "G-Core",
    "uri": "/lego/dns/gcore/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Gandi.\nCode: gandi Since: v0.3.0 Here is an example bash command using the Gandi provider:\nGANDI_API_KEY=abcdefghijklmnopqrstuvwx \\ lego --dns gandi -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GANDI_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GANDI_HTTP_TIMEOUT API request timeout in seconds (Default: 60) GANDI_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 60) GANDI_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 2400) GANDI_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Gandi.",
    "tags": [],
    "title": "Gandi",
    "uri": "/lego/dns/gandi/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Gandi Live DNS (v5).\nCode: gandiv5 Since: v0.5.0 Here is an example bash command using the Gandi Live DNS (v5) provider:\nGANDIV5_PERSONAL_ACCESS_TOKEN=abcdefghijklmnopqrstuvwx \\ lego --dns gandiv5 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GANDIV5_API_KEY API key (Deprecated) GANDIV5_PERSONAL_ACCESS_TOKEN Personal Access Token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GANDIV5_HTTP_TIMEOUT API request timeout in seconds (Default: 10) GANDIV5_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) GANDIV5_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 1200) GANDIV5_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Gandi Live DNS (v5).",
    "tags": [],
    "title": "Gandi Live DNS (v5)",
    "uri": "/lego/dns/gandiv5/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Gigahost.no.\nCode: gigahostno Since: v4.29.0 Here is an example bash command using the Gigahost.no provider:\nGIGAHOSTNO_USERNAME=\"xxxxxxxxxxxxxxxxxxxxx\" \\ GIGAHOSTNO_PASSWORD=\"yyyyyyyyyyyyyyyyyyyyy\" \\ lego --dns gigahostno -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GIGAHOSTNO_PASSWORD Password GIGAHOSTNO_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GIGAHOSTNO_HTTP_TIMEOUT API request timeout in seconds (Default: 30) GIGAHOSTNO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) GIGAHOSTNO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) GIGAHOSTNO_SECRET TOTP secret GIGAHOSTNO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Gigahost.no.",
    "tags": [],
    "title": "Gigahost.no",
    "uri": "/lego/dns/gigahostno/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Glesys.\nCode: glesys Since: v0.5.0 Here is an example bash command using the Glesys provider:\nGLESYS_API_USER=xxxxx \\ GLESYS_API_KEY=yyyyy \\ lego --dns glesys -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GLESYS_API_KEY API key GLESYS_API_USER API user The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GLESYS_HTTP_TIMEOUT API request timeout in seconds (Default: 10) GLESYS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) GLESYS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 1200) GLESYS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Glesys.",
    "tags": [],
    "title": "Glesys",
    "uri": "/lego/dns/glesys/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Go Daddy.\nCode: godaddy Since: v0.5.0 Here is an example bash command using the Go Daddy provider:\nGODADDY_API_KEY=xxxxxxxx \\ GODADDY_API_SECRET=yyyyyyyy \\ lego --dns godaddy -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GODADDY_API_KEY API key GODADDY_API_SECRET API secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GODADDY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) GODADDY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) GODADDY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) GODADDY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nGoDaddy has recently (2024-04) updated the account requirements to access parts of their production Domains API:\nAvailability API: Limited to accounts with 50 or more domains. Management and DNS APIs: Limited to accounts with 10 or more domains and/or an active Discount Domain Club plan. https://community.letsencrypt.org/t/getting-unauthorized-url-error-while-trying-to-get-cert-for-subdomains/217329/12\nMore information API documentation",
    "description": "Configuration for Go Daddy.",
    "tags": [],
    "title": "Go Daddy",
    "uri": "/lego/dns/godaddy/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Google Cloud.\nCode: gcloud Since: v0.3.0 Here is an example bash command using the Google Cloud provider:\n# Using a service account file GCE_PROJECT=\"gc-project-id\" \\ GCE_SERVICE_ACCOUNT_FILE=\"/path/to/svc/account/file.json\" \\ lego --dns gcloud -d '*.example.com' -d example.com run # Using default credentials with impersonation GCE_PROJECT=\"gc-project-id\" \\ GCE_IMPERSONATE_SERVICE_ACCOUNT=\"target-sa@gc-project-id.iam.gserviceaccount.com\" \\ lego --dns gcloud -d '*.example.com' -d example.com run # Using service account key with impersonation GCE_PROJECT=\"gc-project-id\" \\ GCE_SERVICE_ACCOUNT_FILE=\"/path/to/svc/account/file.json\" \\ GCE_IMPERSONATE_SERVICE_ACCOUNT=\"target-sa@gc-project-id.iam.gserviceaccount.com\" \\ lego --dns gcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description Application Default Credentials Documentation GCE_PROJECT Project name (by default, the project name is auto-detected by using the metadata service) GCE_SERVICE_ACCOUNT Account GCE_SERVICE_ACCOUNT_FILE Account file path The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GCE_ALLOW_PRIVATE_ZONE Allows requested domain to be in private DNS zone, works only with a private ACME server (by default: false) GCE_IMPERSONATE_SERVICE_ACCOUNT Service account email to impersonate GCE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) GCE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 180) GCE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) GCE_ZONE_ID Allows to skip the automatic detection of the zone The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nSupports service account impersonation to access Google Cloud DNS resources across different projects or with restricted permissions.\nWhen using impersonation, the source service account must have:\nThe “Service Account Token Creator” role on the source service account The “https://www.googleapis.com/auth/cloud-platform\" scope More information API documentation Go client",
    "description": "Configuration for Google Cloud.",
    "tags": [],
    "title": "Google Cloud",
    "uri": "/lego/dns/gcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "The Google Domains DNS provider has shut down.\nCode: googledomains Since: v4.11.0 Here is an example bash command using the Google Domains provider:\nGOOGLE_DOMAINS_ACCESS_TOKEN=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns googledomains -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GOOGLE_DOMAINS_ACCESS_TOKEN Access token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GOOGLE_DOMAINS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) GOOGLE_DOMAINS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) GOOGLE_DOMAINS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information Go client",
    "description": "The Google Domains DNS provider has shut down.",
    "tags": [],
    "title": "Google Domains",
    "uri": "/lego/dns/googledomains/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Gravity.\nCode: gravity Since: v4.30.0 Here is an example bash command using the Gravity provider:\nGRAVITY_SERVER_URL=\"https://example.org:1234\" \\ GRAVITY_USERNAME=\"xxxxxxxxxxxxxxxxxxxxx\" \\ GRAVITY_PASSWORD=\"yyyyyyyyyyyyyyyyyyyyy\" \\ lego --dns gravity -d '*.example.com' -d example.com run Credentials Environment Variable Name Description GRAVITY_PASSWORD Password GRAVITY_SERVER_URL URL of the server GRAVITY_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description GRAVITY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) GRAVITY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) GRAVITY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) GRAVITY_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 1) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Gravity.",
    "tags": [],
    "title": "Gravity",
    "uri": "/lego/dns/gravity/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hetzner.\nCode: hetzner Since: v3.7.0 Here is an example bash command using the Hetzner provider:\nHETZNER_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns hetzner -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HETZNER_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HETZNER_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HETZNER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HETZNER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) HETZNER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Hetzner.",
    "tags": [],
    "title": "Hetzner",
    "uri": "/lego/dns/hetzner/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hosting.de.\nCode: hostingde Since: v1.1.0 Here is an example bash command using the Hosting.de provider:\nHOSTINGDE_API_KEY=xxxxxxxx \\ lego --dns hostingde -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HOSTINGDE_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HOSTINGDE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HOSTINGDE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HOSTINGDE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) HOSTINGDE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) HOSTINGDE_ZONE_NAME Zone name in ACE format The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Hosting.de.",
    "tags": [],
    "title": "Hosting.de",
    "uri": "/lego/dns/hostingde/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hosting.nl.\nCode: hostingnl Since: v4.30.0 Here is an example bash command using the Hosting.nl provider:\nHOSTINGNL_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns hostingnl -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HOSTINGNL_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HOSTINGNL_HTTP_TIMEOUT API request timeout in seconds (Default: 10) HOSTINGNL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HOSTINGNL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) HOSTINGNL_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Hosting.nl.",
    "tags": [],
    "title": "Hosting.nl",
    "uri": "/lego/dns/hostingnl/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hostinger.\nCode: hostinger Since: v4.27.0 Here is an example bash command using the Hostinger provider:\nHOSTINGER_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns hostinger -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HOSTINGER_API_TOKEN API Token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HOSTINGER_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HOSTINGER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HOSTINGER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) HOSTINGER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Hostinger.",
    "tags": [],
    "title": "Hostinger",
    "uri": "/lego/dns/hostinger/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hosttech.\nCode: hosttech Since: v4.5.0 Here is an example bash command using the Hosttech provider:\nHOSTTECH_API_KEY=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns hosttech -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HOSTTECH_API_KEY API login HOSTTECH_PASSWORD API password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HOSTTECH_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HOSTTECH_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HOSTTECH_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) HOSTTECH_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Hosttech.",
    "tags": [],
    "title": "Hosttech",
    "uri": "/lego/dns/hosttech/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for HTTP request.\nCode: httpreq Since: v2.0.0 Here is an example bash command using the HTTP request provider:\nHTTPREQ_ENDPOINT=http://my.server.com:9090 \\ lego --dns httpreq -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HTTPREQ_ENDPOINT The URL of the server HTTPREQ_MODE RAW, none The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HTTPREQ_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HTTPREQ_PASSWORD Basic authentication password HTTPREQ_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HTTPREQ_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) HTTPREQ_USERNAME Basic authentication username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription The server must provide:\nPOST /present POST /cleanup The URL of the server must be defined by HTTPREQ_ENDPOINT.\nMode There are 2 modes (HTTPREQ_MODE):\ndefault mode: { \"fqdn\": \"_acme-challenge.domain.\", \"value\": \"LHDhK3oGRvkiefQnx7OOczTY5Tic_xZ6HcMOc_gmtoM\" } RAW { \"domain\": \"domain\", \"token\": \"token\", \"keyAuth\": \"key\" } Authentication Basic authentication (optional) can be set with some environment variables:\nHTTPREQ_USERNAME and HTTPREQ_PASSWORD both values must be set, otherwise basic authentication is not defined.",
    "description": "Configuration for HTTP request.",
    "tags": [],
    "title": "HTTP request",
    "uri": "/lego/dns/httpreq/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for http.net.\nCode: httpnet Since: v4.15.0 Here is an example bash command using the http.net provider:\nHTTPNET_API_KEY=xxxxxxxx \\ lego --dns httpnet -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HTTPNET_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HTTPNET_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HTTPNET_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HTTPNET_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) HTTPNET_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) HTTPNET_ZONE_NAME Zone name in ACE format The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for http.net.",
    "tags": [],
    "title": "http.net",
    "uri": "/lego/dns/httpnet/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Huawei Cloud.\nCode: huaweicloud Since: v4.19 Here is an example bash command using the Huawei Cloud provider:\nHUAWEICLOUD_ACCESS_KEY_ID=your-access-key-id \\ HUAWEICLOUD_SECRET_ACCESS_KEY=your-secret-access-key \\ HUAWEICLOUD_REGION=cn-south-1 \\ lego --dns huaweicloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description HUAWEICLOUD_ACCESS_KEY_ID Access key ID HUAWEICLOUD_REGION Region HUAWEICLOUD_SECRET_ACCESS_KEY Access Key secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HUAWEICLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HUAWEICLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HUAWEICLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) HUAWEICLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Huawei Cloud.",
    "tags": [],
    "title": "Huawei Cloud",
    "uri": "/lego/dns/huaweicloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Hurricane Electric DNS.\nCode: hurricane Since: v4.3.0 Here is an example bash command using the Hurricane Electric DNS provider:\nHURRICANE_TOKENS=example.org:token \\ lego --dns hurricane -d '*.example.com' -d example.com run HURRICANE_TOKENS=my.example.org:token1,demo.example.org:token2 \\ lego --dns hurricane -d my.example.org -d demo.example.org Credentials Environment Variable Name Description HURRICANE_TOKENS TXT record names and tokens The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description HURRICANE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HURRICANE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) HURRICANE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation (Default: 300) HURRICANE_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nBefore using lego to request a certificate for a given domain or wildcard (such as my.example.org or *.my.example.org), create a TXT record named _acme-challenge.my.example.org, and enable dynamic updates on it. Generate a token for each URL with Hurricane Electric’s UI, and copy it down. Stick to alphanumeric tokens for greatest reliability.\nTo authenticate with the Hurricane Electric API, add each record name/token pair you want to update to the HURRICANE_TOKENS environment variable, as shown in the examples. Record names (without the _acme-challenge. component) and their tokens are separated with colons, while the credential pairs are concatenated into a comma-separated list, like so:\nHURRICANE_TOKENS=my.example.org:token1,demo.example.org:token2 If you are issuing both a wildcard certificate and a standard certificate for a given subdomain, you should not have repeat entries for that name, as both will use the same credential.\nHURRICANE_TOKENS=example.org:token More information API documentation",
    "description": "Configuration for Hurricane Electric DNS.",
    "tags": [],
    "title": "Hurricane Electric DNS",
    "uri": "/lego/dns/hurricane/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for HyperOne.\nCode: hyperone Since: v3.9.0 Here is an example bash command using the HyperOne provider:\nlego --dns hyperone -d '*.example.com' -d example.com run Additional Configuration Environment Variable Name Description HYPERONE_API_URL Allows to pass custom API Endpoint to be used in the challenge (default https://api.hyperone.com/v2) HYPERONE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) HYPERONE_LOCATION_ID Specifies location (region) to be used in API calls. (default pl-waw-1) HYPERONE_PASSPORT_LOCATION Allows to pass custom passport file location (default ~/.h1/passport.json) HYPERONE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 60) HYPERONE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 2) HYPERONE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription Default configuration does not require any additional environment variables, just a passport file in ~/.h1/passport.json location.\nGenerating passport file using H1 CLI To use this application you have to generate passport file for sa:\nh1 iam project sa credential generate --name my-passport --project \u003cproject ID\u003e --sa \u003csa ID\u003e --passport-output-file ~/.h1/passport.json Required permissions The application requires following permissions:\ndns/zone/list dns/zone.recordset/list dns/zone.recordset/create dns/zone.recordset/delete dns/zone.record/create dns/zone.record/list dns/zone.record/delete All required permissions are available via platform role tool.lego.\nMore information API documentation",
    "description": "Configuration for HyperOne.",
    "tags": [],
    "title": "HyperOne",
    "uri": "/lego/dns/hyperone/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for IBM Cloud (SoftLayer).\nCode: ibmcloud Since: v4.5.0 Here is an example bash command using the IBM Cloud (SoftLayer) provider:\nSOFTLAYER_USERNAME=xxxxx \\ SOFTLAYER_API_KEY=yyyyy \\ lego --dns ibmcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SOFTLAYER_API_KEY Classic Infrastructure API key SOFTLAYER_USERNAME Username (IBM Cloud is {accountID}_{emailAddress}) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SOFTLAYER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SOFTLAYER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SOFTLAYER_TIMEOUT API request timeout in seconds (Default: 30) SOFTLAYER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for IBM Cloud (SoftLayer).",
    "tags": [],
    "title": "IBM Cloud (SoftLayer)",
    "uri": "/lego/dns/ibmcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for IIJ DNS Platform Service.\nCode: iijdpf Since: v4.7.0 Here is an example bash command using the IIJ DNS Platform Service provider:\nIIJ_DPF_API_TOKEN=xxxxxxxx \\ IIJ_DPF_DPM_SERVICE_CODE=yyyyyy \\ lego --dns iijdpf -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IIJ_DPF_API_TOKEN API token IIJ_DPF_DPM_SERVICE_CODE IIJ Managed DNS Service’s service code The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IIJ_DPF_API_ENDPOINT API endpoint URL, defaults to https://api.dns-platform.jp/dpf/v1 IIJ_DPF_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) IIJ_DPF_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 660) IIJ_DPF_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for IIJ DNS Platform Service.",
    "tags": [],
    "title": "IIJ DNS Platform Service",
    "uri": "/lego/dns/iijdpf/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Infoblox.\nCode: infoblox Since: v4.4.0 Here is an example bash command using the Infoblox provider:\nINFOBLOX_USERNAME=api-user-529 \\ INFOBLOX_PASSWORD=b9841238feb177a84330febba8a83208921177bffe733 \\ INFOBLOX_HOST=infoblox.example.org lego --dns infoblox -d '*.example.com' -d example.com run Credentials Environment Variable Name Description INFOBLOX_HOST Host URI INFOBLOX_PASSWORD Account Password INFOBLOX_USERNAME Account Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description INFOBLOX_CA_CERTIFICATE The path to the CA certificate (PEM encoded) INFOBLOX_DNS_VIEW The view for the TXT records (Default: External) INFOBLOX_HTTP_TIMEOUT API request timeout in seconds (Default: 30) INFOBLOX_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) INFOBLOX_PORT The port for the infoblox grid manager (Default: 443) INFOBLOX_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) INFOBLOX_SSL_VERIFY Whether or not to verify the TLS certificate (Default: true) INFOBLOX_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) INFOBLOX_WAPI_VERSION The version of WAPI being used (Default: 2.11) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nWhen creating an API’s user ensure it has the proper permissions for the view you are working with.\nMore information API documentation Go client",
    "description": "Configuration for Infoblox.",
    "tags": [],
    "title": "Infoblox",
    "uri": "/lego/dns/infoblox/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Infomaniak.\nCode: infomaniak Since: v4.1.0 Here is an example bash command using the Infomaniak provider:\nINFOMANIAK_ACCESS_TOKEN=1234567898765432 \\ lego --dns infomaniak -d '*.example.com' -d example.com run Credentials Environment Variable Name Description INFOMANIAK_ACCESS_TOKEN Access token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description INFOMANIAK_ENDPOINT https://api.infomaniak.com INFOMANIAK_HTTP_TIMEOUT API request timeout in seconds (Default: 30) INFOMANIAK_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) INFOMANIAK_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) INFOMANIAK_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAccess token Access token can be created at the url https://manager.infomaniak.com/v3/infomaniak-api. You will need domain scope.\nMore information API documentation",
    "description": "Configuration for Infomaniak.",
    "tags": [],
    "title": "Infomaniak",
    "uri": "/lego/dns/infomaniak/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Internet Initiative Japan.\nCode: iij Since: v1.1.0 Here is an example bash command using the Internet Initiative Japan provider:\nIIJ_API_ACCESS_KEY=xxxxxxxx \\ IIJ_API_SECRET_KEY=yyyyyy \\ IIJ_DO_SERVICE_CODE=zzzzzz \\ lego --dns iij -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IIJ_API_ACCESS_KEY API access key IIJ_API_SECRET_KEY API secret key IIJ_DO_SERVICE_CODE DO service code The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IIJ_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) IIJ_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 240) IIJ_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Internet Initiative Japan.",
    "tags": [],
    "title": "Internet Initiative Japan",
    "uri": "/lego/dns/iij/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Internet.bs.\nCode: internetbs Since: v4.5.0 Here is an example bash command using the Internet.bs provider:\nINTERNET_BS_API_KEY=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ INTERNET_BS_PASSWORD=yyyyyyyyyyyyyyyyyyyyyyyyyy \\ lego --dns internetbs -d '*.example.com' -d example.com run Credentials Environment Variable Name Description INTERNET_BS_API_KEY API key INTERNET_BS_PASSWORD API password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description INTERNET_BS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) INTERNET_BS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) INTERNET_BS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) INTERNET_BS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Internet.bs.",
    "tags": [],
    "title": "Internet.bs",
    "uri": "/lego/dns/internetbs/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for INWX.\nCode: inwx Since: v2.0.0 Here is an example bash command using the INWX provider:\nINWX_USERNAME=xxxxxxxxxx \\ INWX_PASSWORD=yyyyyyyyyy \\ lego --dns inwx -d '*.example.com' -d example.com run # 2FA INWX_USERNAME=xxxxxxxxxx \\ INWX_PASSWORD=yyyyyyyyyy \\ INWX_SHARED_SECRET=zzzzzzzzzz \\ lego --dns inwx -d '*.example.com' -d example.com run Credentials Environment Variable Name Description INWX_PASSWORD Password INWX_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description INWX_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) INWX_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 360) INWX_SANDBOX Activate the sandbox (boolean) INWX_SHARED_SECRET shared secret related to 2FA INWX_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for INWX.",
    "tags": [],
    "title": "INWX",
    "uri": "/lego/dns/inwx/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Ionos.\nCode: ionos Since: v4.2.0 Here is an example bash command using the Ionos provider:\nIONOS_API_KEY=xxxxxxxx \\ lego --dns ionos -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IONOS_API_KEY API key \u003cprefix\u003e.\u003csecret\u003e https://developer.hosting.ionos.com/docs/getstarted The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IONOS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) IONOS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) IONOS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 900) IONOS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Ionos.",
    "tags": [],
    "title": "Ionos",
    "uri": "/lego/dns/ionos/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Ionos Cloud.\nCode: ionoscloud Since: v4.30.0 Here is an example bash command using the Ionos Cloud provider:\nIONOSCLOUD_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns ionoscloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IONOSCLOUD_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IONOSCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) IONOSCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) IONOSCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) IONOSCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Ionos Cloud.",
    "tags": [],
    "title": "Ionos Cloud",
    "uri": "/lego/dns/ionoscloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for IPv64.\nCode: ipv64 Since: v4.13.0 Here is an example bash command using the IPv64 provider:\nIPV64_API_KEY=xxxxxx \\ lego --dns ipv64 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IPV64_API_KEY Account API Key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IPV64_HTTP_TIMEOUT API request timeout in seconds (Default: 30) IPV64_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) IPV64_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for IPv64.",
    "tags": [],
    "title": "IPv64",
    "uri": "/lego/dns/ipv64/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ISPConfig 3.\nCode: ispconfig Since: v4.31.0 Here is an example bash command using the ISPConfig 3 provider:\nISPCONFIG_SERVER_URL=\"https://example.com:8080/remote/json.php\" \\ ISPCONFIG_USERNAME=\"xxx\" \\ ISPCONFIG_PASSWORD=\"yyy\" \\ lego --dns ispconfig -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ISPCONFIG_PASSWORD Password ISPCONFIG_SERVER_URL Server URL ISPCONFIG_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ISPCONFIG_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ISPCONFIG_INSECURE_SKIP_VERIFY Whether to verify the API certificate ISPCONFIG_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ISPCONFIG_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ISPCONFIG_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ISPConfig 3.",
    "tags": [],
    "title": "ISPConfig 3",
    "uri": "/lego/dns/ispconfig/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ISPConfig 3 - Dynamic DNS (DDNS) Module.\nCode: ispconfigddns Since: v4.31.0 Here is an example bash command using the ISPConfig 3 - Dynamic DNS (DDNS) Module provider:\nISPCONFIG_DDNS_SERVER_URL=\"https://panel.example.com:8080\" \\ ISPCONFIG_DDNS_TOKEN=xxxxxx \\ lego --dns ispconfigddns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ISPCONFIG_DDNS_SERVER_URL API server URL (ex: https://panel.example.com:8080) ISPCONFIG_DDNS_TOKEN DDNS API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ISPCONFIG_DDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ISPCONFIG_DDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ISPCONFIG_DDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ISPCONFIG_DDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nISPConfig DNS provider supports leveraging the ISPConfig 3 Dynamic DNS (DDNS) Module.\nRequires the DDNS module described at https://www.ispconfig.org/ispconfig/download/\nSee https://www.howtoforge.com/community/threads/ispconfig-3-danymic-dns-ddns-module.87967/ for additional details.\nMore information API documentation",
    "description": "Configuration for ISPConfig 3 - Dynamic DNS (DDNS) Module.",
    "tags": [],
    "title": "ISPConfig 3 - Dynamic DNS (DDNS) Module",
    "uri": "/lego/dns/ispconfigddns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "The iwantmyname API has shut down.\nhttps://github.com/go-acme/lego/issues/2563\nCode: iwantmyname Since: v4.7.0 Here is an example bash command using the iwantmyname (Deprecated) provider:\nIWANTMYNAME_USERNAME=xxxxxxxx \\ IWANTMYNAME_PASSWORD=xxxxxxxx \\ lego --dns iwantmyname -d '*.example.com' -d example.com run Credentials Environment Variable Name Description IWANTMYNAME_PASSWORD API password IWANTMYNAME_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description IWANTMYNAME_HTTP_TIMEOUT API request timeout in seconds (Default: 30) IWANTMYNAME_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) IWANTMYNAME_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) IWANTMYNAME_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "The iwantmyname API has shut down.\nhttps://github.com/go-acme/lego/issues/2563",
    "tags": [],
    "title": "iwantmyname (Deprecated)",
    "uri": "/lego/dns/iwantmyname/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for JD Cloud.\nCode: jdcloud Since: v4.31.0 Here is an example bash command using the JD Cloud provider:\nJDCLOUD_ACCESS_KEY_ID=\"xxx\" \\ JDCLOUD_ACCESS_KEY_SECRET=\"yyy\" \\ lego --dns jdcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description JDCLOUD_ACCESS_KEY_ID Access key ID JDCLOUD_ACCESS_KEY_SECRET Access key secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description JDCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) JDCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) JDCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) JDCLOUD_REGION_ID Region ID (Default: cn-north-1) JDCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for JD Cloud.",
    "tags": [],
    "title": "JD Cloud",
    "uri": "/lego/dns/jdcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Joker.\nCode: joker Since: v2.6.0 Here is an example bash command using the Joker provider:\n# SVC JOKER_API_MODE=SVC \\ JOKER_USERNAME=\u003cyour email\u003e \\ JOKER_PASSWORD=\u003cyour password\u003e \\ lego --dns joker -d '*.example.com' -d example.com run # DMAPI JOKER_API_MODE=DMAPI \\ JOKER_USERNAME=\u003cyour email\u003e \\ JOKER_PASSWORD=\u003cyour password\u003e \\ lego --dns joker -d '*.example.com' -d example.com run ## or JOKER_API_MODE=DMAPI \\ JOKER_API_KEY=\u003cyour API key\u003e \\ lego --dns joker -d '*.example.com' -d example.com run Credentials Environment Variable Name Description JOKER_API_KEY API key (only with DMAPI mode) JOKER_API_MODE ‘DMAPI’ or ‘SVC’. DMAPI is for resellers accounts. (Default: DMAPI) JOKER_PASSWORD Joker.com password JOKER_USERNAME Joker.com username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description JOKER_HTTP_TIMEOUT API request timeout in seconds (Default: 60) JOKER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) JOKER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) JOKER_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60), only with ‘SVC’ mode JOKER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nSVC mode In the SVC mode, username and passsword are not your email and account passwords, but those displayed in Joker.com domain dashboard when enabling Dynamic DNS.\nAs per Joker.com documentation:\nplease log in at Joker.com, visit ‘My Domains’, find the domain you want to add Let’s Encrypt certificate for, and chose “DNS” in the menu\non the top right, you will find the setting for ‘Dynamic DNS’. If not already active, please activate it. It will not affect any other already existing DNS records of this domain.\nplease take a note of the credentials which are now shown as ‘Dynamic DNS Authentication’, consisting of a ‘username’ and a ‘password’.\nthis is all you have to do here - and only once per domain.\nMore information API documentation",
    "description": "Configuration for Joker.",
    "tags": [],
    "title": "Joker",
    "uri": "/lego/dns/joker/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Joohoi’s ACME-DNS.\nCode: acme-dns Since: v1.1.0 Here is an example bash command using the Joohoi’s ACME-DNS provider:\nACME_DNS_API_BASE=http://10.0.0.8:4443 \\ ACME_DNS_STORAGE_PATH=/root/.lego-acme-dns-accounts.json \\ lego --dns \"acme-dns\" -d '*.example.com' -d example.com run # or ACME_DNS_API_BASE=http://10.0.0.8:4443 \\ ACME_DNS_STORAGE_BASE_URL=http://10.10.10.10:80 \\ lego --dns \"acme-dns\" -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ACME_DNS_API_BASE The ACME-DNS API address ACME_DNS_STORAGE_BASE_URL The ACME-DNS JSON account data server. ACME_DNS_STORAGE_PATH The ACME-DNS JSON account data file. A per-domain account will be registered/persisted to this file and used for TXT updates. The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ACME_DNS_ALLOWLIST Source networks using CIDR notation (multiple values should be separated with a comma). The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Joohoi’s ACME-DNS.",
    "tags": [],
    "title": "Joohoi's ACME-DNS",
    "uri": "/lego/dns/acme-dns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for KeyHelp.\nCode: keyhelp Since: v4.26.0 Here is an example bash command using the KeyHelp provider:\nKEYHELP_BASE_URL=\"https://keyhelp.example.com\" \\ KEYHELP_API_KEY=\"xxx\" \\ lego --dns keyhelp -d '*.example.com' -d example.com run Credentials Environment Variable Name Description KEYHELP_API_KEY API key KEYHELP_BASE_URL Server URL The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description KEYHELP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) KEYHELP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) KEYHELP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) KEYHELP_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for KeyHelp.",
    "tags": [],
    "title": "KeyHelp",
    "uri": "/lego/dns/keyhelp/index.html"
  },
  {
    "breadcrumb": "",
    "content": "Let’s Encrypt client and ACME library written in Go.\nImportant lego is an independent, free, and open-source project, if you value it, consider supporting it! ❤️\nThis project is not owned by a company. I’m not an employee of a company.\nI don’t have gifted domains/accounts from DNS companies.\nI’ve been maintaining it for about 10 years.\nFeatures ACME v2 RFC 8555 Support RFC 8737: TLS Application‑Layer Protocol Negotiation (ALPN) Challenge Extension Support RFC 8738: issues certificates for IP addresses Support RFC 9773: Renewal Information (ARI) Extension Support draft-ietf-acme-profiles-00: Profiles Extension Comes with about 180 DNS providers Register with CA Obtain certificates, both from scratch or with an existing CSR Renew certificates Revoke certificates Robust implementation of ACME challenges: HTTP (http-01) DNS (dns-01) TLS (tls-alpn-01) SAN certificate support CNAME support by default Custom challenge solvers Certificate bundling OCSP helper function",
    "description": "Let’s Encrypt client and ACME library written in Go.\nImportant lego is an independent, free, and open-source project, if you value it, consider supporting it! ❤️\nThis project is not owned by a company. I’m not an employee of a company.\nI don’t have gifted domains/accounts from DNS companies.\nI’ve been maintaining it for about 10 years.\nFeatures ACME v2 RFC 8555 Support RFC 8737: TLS Application‑Layer Protocol Negotiation (ALPN) Challenge Extension Support RFC 8738: issues certificates for IP addresses Support RFC 9773: Renewal Information (ARI) Extension Support draft-ietf-acme-profiles-00: Profiles Extension Comes with about 180 DNS providers Register with CA Obtain certificates, both from scratch or with an existing CSR Renew certificates Revoke certificates Robust implementation of ACME challenges: HTTP (http-01) DNS (dns-01) TLS (tls-alpn-01) SAN certificate support CNAME support by default Custom challenge solvers Certificate bundling OCSP helper function",
    "tags": [],
    "title": "Lego",
    "uri": "/lego/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Liara.\nCode: liara Since: v4.10.0 Here is an example bash command using the Liara provider:\nLIARA_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns liara -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LIARA_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LIARA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) LIARA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) LIARA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) LIARA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Liara.",
    "tags": [],
    "title": "Liara",
    "uri": "/lego/dns/liara/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage",
    "content": "Lego can be used as a Go Library.\nGoDoc The GoDoc can be found here: Go Reference.\nUsage A valid, but bare-bones example use of the acme package:\npackage main import ( \"crypto\" \"crypto/ecdsa\" \"crypto/elliptic\" \"crypto/rand\" \"fmt\" \"log\" \"github.com/go-acme/lego/v4/certcrypto\" \"github.com/go-acme/lego/v4/certificate\" \"github.com/go-acme/lego/v4/challenge/http01\" \"github.com/go-acme/lego/v4/challenge/tlsalpn01\" \"github.com/go-acme/lego/v4/lego\" \"github.com/go-acme/lego/v4/registration\" ) // You'll need a user or account type that implements acme.User type MyUser struct { Email string Registration *registration.Resource key crypto.PrivateKey } func (u *MyUser) GetEmail() string { return u.Email } func (u MyUser) GetRegistration() *registration.Resource { return u.Registration } func (u *MyUser) GetPrivateKey() crypto.PrivateKey { return u.key } func main() { // Create a user. New accounts need an email and private key to start. privateKey, err := ecdsa.GenerateKey(elliptic.P256(), rand.Reader) if err != nil { log.Fatal(err) } myUser := MyUser{ Email: \"you@yours.com\", key: privateKey, } config := lego.NewConfig(\u0026myUser) // This CA URL is configured for a local dev instance of Boulder running in Docker in a VM. config.CADirURL = \"http://192.168.99.100:4000/directory\" config.Certificate.KeyType = certcrypto.RSA2048 // A client facilitates communication with the CA server. client, err := lego.NewClient(config) if err != nil { log.Fatal(err) } // We specify an HTTP port of 5002 and an TLS port of 5001 on all interfaces // because we aren't running as root and can't bind a listener to port 80 and 443 // (used later when we attempt to pass challenges). Keep in mind that you still // need to proxy challenge traffic to port 5002 and 5001. err = client.Challenge.SetHTTP01Provider(http01.NewProviderServer(\"\", \"5002\")) if err != nil { log.Fatal(err) } err = client.Challenge.SetTLSALPN01Provider(tlsalpn01.NewProviderServer(\"\", \"5001\")) if err != nil { log.Fatal(err) } // New users will need to register reg, err := client.Registration.Register(registration.RegisterOptions{TermsOfServiceAgreed: true}) if err != nil { log.Fatal(err) } myUser.Registration = reg request := certificate.ObtainRequest{ Domains: []string{\"mydomain.com\"}, Bundle: true, } certificates, err := client.Certificate.Obtain(request) if err != nil { log.Fatal(err) } // Each certificate comes back with the cert bytes, the bytes of the client's // private key, and a certificate URL. SAVE THESE TO DISK. fmt.Printf(\"%#v\\n\", certificates) // ... all done. }",
    "description": "Lego can be used as a Go Library.",
    "tags": [],
    "title": "Library",
    "uri": "/lego/usage/library/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Lima-City.\nCode: limacity Since: v4.18.0 Here is an example bash command using the Lima-City provider:\nLIMACITY_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns limacity -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LIMACITY_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LIMACITY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) LIMACITY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 80) LIMACITY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 480) LIMACITY_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 90) LIMACITY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Lima-City.",
    "tags": [],
    "title": "Lima-City",
    "uri": "/lego/dns/limacity/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Linode (v4).\nCode: linode Since: v1.1.0 Here is an example bash command using the Linode (v4) provider:\nLINODE_TOKEN=xxxxx \\ lego --dns linode -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LINODE_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LINODE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) LINODE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 15) LINODE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) LINODE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Linode (v4).",
    "tags": [],
    "title": "Linode (v4)",
    "uri": "/lego/dns/linode/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Liquid Web.\nCode: liquidweb Since: v3.1.0 Here is an example bash command using the Liquid Web provider:\nLWAPI_USERNAME=someuser \\ LWAPI_PASSWORD=somepass \\ lego --dns liquidweb -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LWAPI_PASSWORD Liquid Web API Password LWAPI_USERNAME Liquid Web API Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LWAPI_HTTP_TIMEOUT API request timeout in seconds (Default: 60) LWAPI_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) LWAPI_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) LWAPI_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) LWAPI_URL Liquid Web API endpoint LWAPI_ZONE DNS Zone The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Liquid Web.",
    "tags": [],
    "title": "Liquid Web",
    "uri": "/lego/dns/liquidweb/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Loopia.\nCode: loopia Since: v4.2.0 Here is an example bash command using the Loopia provider:\nLOOPIA_API_USER=xxxxxxxx \\ LOOPIA_API_PASSWORD=yyyyyyyy \\ lego --dns loopia -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LOOPIA_API_PASSWORD API password LOOPIA_API_USER API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LOOPIA_API_URL API endpoint. Ex: https://api.loopia.se/RPCSERV or https://api.loopia.rs/RPCSERV LOOPIA_HTTP_TIMEOUT API request timeout in seconds (Default: 60) LOOPIA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2400) LOOPIA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) LOOPIA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAPI user You can generate a new API user from your account page.\nIt needs to have the following permissions:\naddZoneRecord getZoneRecords removeZoneRecord removeSubdomain More information API documentation",
    "description": "Configuration for Loopia.",
    "tags": [],
    "title": "Loopia",
    "uri": "/lego/dns/loopia/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for LuaDNS.\nCode: luadns Since: v3.7.0 Here is an example bash command using the LuaDNS provider:\nLUADNS_API_USERNAME=youremail \\ LUADNS_API_TOKEN=xxxxxxxx \\ lego --dns luadns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description LUADNS_API_TOKEN API token LUADNS_API_USERNAME Username (your email) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description LUADNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) LUADNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) LUADNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) LUADNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for LuaDNS.",
    "tags": [],
    "title": "LuaDNS",
    "uri": "/lego/dns/luadns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Mail-in-a-Box.\nCode: mailinabox Since: v4.16.0 Here is an example bash command using the Mail-in-a-Box provider:\nMAILINABOX_EMAIL=user@example.com \\ MAILINABOX_PASSWORD=yyyy \\ MAILINABOX_BASE_URL=https://box.example.com \\ lego --dns mailinabox -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MAILINABOX_BASE_URL Base API URL (ex: https://box.example.com) MAILINABOX_EMAIL User email MAILINABOX_PASSWORD User password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MAILINABOX_HTTP_TIMEOUT API request timeout in seconds (Default: 30) MAILINABOX_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) MAILINABOX_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Mail-in-a-Box.",
    "tags": [],
    "title": "Mail-in-a-Box",
    "uri": "/lego/dns/mailinabox/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ManageEngine CloudDNS.\nCode: manageengine Since: v4.21.0 Here is an example bash command using the ManageEngine CloudDNS provider:\nMANAGEENGINE_CLIENT_ID=\"xxx\" \\ MANAGEENGINE_CLIENT_SECRET=\"yyy\" \\ lego --dns manageengine -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MANAGEENGINE_CLIENT_ID Client ID MANAGEENGINE_CLIENT_SECRET Client Secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MANAGEENGINE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) MANAGEENGINE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) MANAGEENGINE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ManageEngine CloudDNS.",
    "tags": [],
    "title": "ManageEngine CloudDNS",
    "uri": "/lego/dns/manageengine/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Solving the DNS-01 challenge using CLI prompt.\nCode: manual Since: v0.3.0 Here is an example bash command using the Manual provider:\nlego --dns manual -d '*.example.com' -d example.com run Example To start using the CLI prompt “provider”, start lego with --dns manual:\n$ lego --dns manual -d example.com run What follows are a few log print-outs, interspersed with some prompts, asking for you to do perform some actions:\nNo key found for account you@example.com. Generating a P256 key. Saved key to ./.lego/accounts/acme-v02.api.letsencrypt.org/you@example.com/keys/you@example.com.key Please review the TOS at https://letsencrypt.org/documents/LE-SA-v1.2-November-15-2017.pdf Do you accept the TOS? Y/n If you accept the linked Terms of Service, hit Enter.\n[INFO] acme: Registering account for you@example.com !!!! HEADS UP !!!! Your account credentials have been saved in your Let's Encrypt configuration directory at \"./.lego/accounts\". You should make a secure backup of this folder now. This configuration directory will also contain certificates and private keys obtained from Let's Encrypt so making regular backups of this folder is ideal. [INFO] [example.com] acme: Obtaining bundled SAN certificate [INFO] [example.com] AuthURL: https://acme-v02.api.letsencrypt.org/acme/authz-v3/2345678901 [INFO] [example.com] acme: Could not find solver for: tls-alpn-01 [INFO] [example.com] acme: Could not find solver for: http-01 [INFO] [example.com] acme: use dns-01 solver [INFO] [example.com] acme: Preparing to solve DNS-01 lego: Please create the following TXT record in your example.com. zone: _acme-challenge.example.com. 120 IN TXT \"hX0dPkG6Gfs9hUvBAchQclkyyoEKbShbpvJ9mY5q2JQ\" lego: Press 'Enter' when you are done Do as instructed, and create the TXT records, and hit Enter.\n[INFO] [example.com] acme: Trying to solve DNS-01 [INFO] [example.com] acme: Checking DNS record propagation using [192.168.8.1:53] [INFO] Wait for propagation [timeout: 1m0s, interval: 2s] [INFO] [example.com] acme: Waiting for DNS record propagation. [INFO] [example.com] The server validated our request [INFO] [example.com] acme: Cleaning DNS-01 challenge lego: You can now remove this TXT record from your example.com. zone: _acme-challenge.example.com. 120 IN TXT \"hX0dPkG6Gfs9hUvBAchQclkyyoEKbShbpvJ9mY5q2JQ\" [INFO] [example.com] acme: Validations succeeded; requesting certificates [INFO] [example.com] Server responded with a certificate. As mentioned, you can now remove the TXT record again.",
    "description": "Solving the DNS-01 challenge using CLI prompt.",
    "tags": [],
    "title": "Manual",
    "uri": "/lego/dns/manual/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Metaname.\nCode: metaname Since: v4.13.0 Here is an example bash command using the Metaname provider:\nMETANAME_ACCOUNT_REFERENCE=xxxx \\ METANAME_API_KEY=yyyyyyy \\ lego --dns metaname -d '*.example.com' -d example.com run Credentials Environment Variable Name Description METANAME_ACCOUNT_REFERENCE The four-digit reference of a Metaname account METANAME_API_KEY API Key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description METANAME_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) METANAME_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) METANAME_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Metaname.",
    "tags": [],
    "title": "Metaname",
    "uri": "/lego/dns/metaname/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Metaregistrar.\nCode: metaregistrar Since: v4.23.0 Here is an example bash command using the Metaregistrar provider:\nMETAREGISTRAR_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns metaregistrar -d '*.example.com' -d example.com run Credentials Environment Variable Name Description METAREGISTRAR_API_TOKEN The API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description METAREGISTRAR_HTTP_TIMEOUT API request timeout in seconds (Default: 30) METAREGISTRAR_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) METAREGISTRAR_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) METAREGISTRAR_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Metaregistrar.",
    "tags": [],
    "title": "Metaregistrar",
    "uri": "/lego/dns/metaregistrar/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for mijn.host.\nCode: mijnhost Since: v4.18.0 Here is an example bash command using the mijn.host provider:\nMIJNHOST_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns mijnhost -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MIJNHOST_API_KEY The API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MIJNHOST_HTTP_TIMEOUT API request timeout in seconds (Default: 30) MIJNHOST_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) MIJNHOST_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) MIJNHOST_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) MIJNHOST_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for mijn.host.",
    "tags": [],
    "title": "mijn.host",
    "uri": "/lego/dns/mijnhost/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Mittwald.\nCode: mittwald Since: v1.48.0 Here is an example bash command using the Mittwald provider:\nMITTWALD_TOKEN=my-token \\ lego --dns mittwald -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MITTWALD_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MITTWALD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) MITTWALD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) MITTWALD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) MITTWALD_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 120) MITTWALD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Mittwald.",
    "tags": [],
    "title": "Mittwald",
    "uri": "/lego/dns/mittwald/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for myaddr.{tools,dev,io}.\nCode: myaddr Since: v4.22.0 Here is an example bash command using the myaddr.{tools,dev,io} provider:\nMYADDR_PRIVATE_KEYS_MAPPING=\"example:123,test:456\" \\ lego --dns myaddr -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MYADDR_PRIVATE_KEYS_MAPPING Mapping between subdomains and private keys. The format is: \u003csubdomain1\u003e:\u003cprivate_key1\u003e,\u003csubdomain2\u003e:\u003cprivate_key2\u003e,\u003csubdomain3\u003e:\u003cprivate_key3\u003e The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MYADDR_HTTP_TIMEOUT API request timeout in seconds (Default: 30) MYADDR_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) MYADDR_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) MYADDR_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 2) MYADDR_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for myaddr.{tools,dev,io}.",
    "tags": [],
    "title": "myaddr.{tools,dev,io}",
    "uri": "/lego/dns/myaddr/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for MyDNS.jp.\nCode: mydnsjp Since: v1.2.0 Here is an example bash command using the MyDNS.jp provider:\nMYDNSJP_MASTER_ID=xxxxx \\ MYDNSJP_PASSWORD=xxxxx \\ lego --dns mydnsjp -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MYDNSJP_MASTER_ID Master ID MYDNSJP_PASSWORD Password The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MYDNSJP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) MYDNSJP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) MYDNSJP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for MyDNS.jp.",
    "tags": [],
    "title": "MyDNS.jp",
    "uri": "/lego/dns/mydnsjp/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for MythicBeasts.\nCode: mythicbeasts Since: v0.3.7 Here is an example bash command using the MythicBeasts provider:\nMYTHICBEASTS_USERNAME=myuser \\ MYTHICBEASTS_PASSWORD=mypass \\ lego --dns mythicbeasts -d '*.example.com' -d example.com run Credentials Environment Variable Name Description MYTHICBEASTS_PASSWORD Password MYTHICBEASTS_USERNAME User name The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description MYTHICBEASTS_API_ENDPOINT The endpoint for the API (must implement v2) MYTHICBEASTS_AUTH_API_ENDPOINT The endpoint for Mythic Beasts’ Authentication MYTHICBEASTS_HTTP_TIMEOUT API request timeout in seconds (Default: 10) MYTHICBEASTS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) MYTHICBEASTS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) MYTHICBEASTS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nIf you are using specific API keys, then the username is the API ID for your API key, and the password is the API secret.\nYour API key name is not needed to operate lego.\nMore information API documentation",
    "description": "Configuration for MythicBeasts.",
    "tags": [],
    "title": "MythicBeasts",
    "uri": "/lego/dns/mythicbeasts/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Name.com.\nCode: namedotcom Since: v0.5.0 Here is an example bash command using the Name.com provider:\nNAMECOM_USERNAME=foo.bar \\ NAMECOM_API_TOKEN=a379a6f6eeafb9a55e378c118034e2751e682fab \\ lego --dns namedotcom -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NAMECOM_API_TOKEN API token NAMECOM_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NAMECOM_HTTP_TIMEOUT API request timeout in seconds (Default: 10) NAMECOM_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 20) NAMECOM_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 900) NAMECOM_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Name.com.",
    "tags": [],
    "title": "Name.com",
    "uri": "/lego/dns/namedotcom/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Namecheap.\nTo enable API access on the Namecheap production environment, some opaque requirements must be met. More information in the section Enabling API Access of the Namecheap documentation. (2020-08: Account balance of $50+, 20+ domains in your account, or purchases totaling $50+ within the last 2 years.)\nCode: namecheap Since: v0.3.0 Here is an example bash command using the Namecheap provider:\nNAMECHEAP_API_USER=user \\ NAMECHEAP_API_KEY=key \\ lego --dns namecheap -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NAMECHEAP_API_KEY API key NAMECHEAP_API_USER API user The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NAMECHEAP_HTTP_TIMEOUT API request timeout in seconds (Default: 60) NAMECHEAP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 15) NAMECHEAP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 3600) NAMECHEAP_SANDBOX Activate the sandbox (boolean) NAMECHEAP_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Namecheap.\nTo enable API access on the Namecheap production environment, some opaque requirements must be met. More information in the section Enabling API Access of the Namecheap documentation. (2020-08: Account balance of $50+, 20+ domains in your account, or purchases totaling $50+ within the last 2 years.)",
    "tags": [],
    "title": "Namecheap",
    "uri": "/lego/dns/namecheap/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Namesilo.\nCode: namesilo Since: v2.7.0 Here is an example bash command using the Namesilo provider:\nNAMESILO_API_KEY=b9841238feb177a84330febba8a83208921177bffe733 \\ lego --dns namesilo -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NAMESILO_API_KEY Client ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NAMESILO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NAMESILO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60), it is better to set larger than 15 minutes NAMESILO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600), should be in [3600, 2592000] The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Namesilo.",
    "tags": [],
    "title": "Namesilo",
    "uri": "/lego/dns/namesilo/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for NearlyFreeSpeech.NET.\nCode: nearlyfreespeech Since: v4.8.0 Here is an example bash command using the NearlyFreeSpeech.NET provider:\nNEARLYFREESPEECH_API_KEY=xxxxxx \\ NEARLYFREESPEECH_LOGIN=xxxx \\ lego --dns nearlyfreespeech -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NEARLYFREESPEECH_API_KEY API Key for API requests NEARLYFREESPEECH_LOGIN Username for API requests The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NEARLYFREESPEECH_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NEARLYFREESPEECH_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NEARLYFREESPEECH_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) NEARLYFREESPEECH_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) NEARLYFREESPEECH_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for NearlyFreeSpeech.NET.",
    "tags": [],
    "title": "NearlyFreeSpeech.NET",
    "uri": "/lego/dns/nearlyfreespeech/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Neodigit.\nCode: neodigit Since: v4.30.0 Here is an example bash command using the Neodigit provider:\nNEODIGIT_TOKEN=xxxxxx \\ lego --dns neodigit -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NEODIGIT_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NEODIGIT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NEODIGIT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) NEODIGIT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) NEODIGIT_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Neodigit.",
    "tags": [],
    "title": "Neodigit",
    "uri": "/lego/dns/neodigit/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Netcup.\nCode: netcup Since: v1.1.0 Here is an example bash command using the Netcup provider:\nNETCUP_CUSTOMER_NUMBER=xxxx \\ NETCUP_API_KEY=yyyy \\ NETCUP_API_PASSWORD=zzzz \\ lego --dns netcup -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NETCUP_API_KEY API key NETCUP_API_PASSWORD API password NETCUP_CUSTOMER_NUMBER Customer number The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NETCUP_HTTP_TIMEOUT API request timeout in seconds (Default: 10) NETCUP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 30) NETCUP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 900) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Netcup.",
    "tags": [],
    "title": "Netcup",
    "uri": "/lego/dns/netcup/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Netlify.\nCode: netlify Since: v3.7.0 Here is an example bash command using the Netlify provider:\nNETLIFY_TOKEN=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns netlify -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NETLIFY_TOKEN Token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NETLIFY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NETLIFY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NETLIFY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) NETLIFY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Netlify.",
    "tags": [],
    "title": "Netlify",
    "uri": "/lego/dns/netlify/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Nicmanager.\nCode: nicmanager Since: v4.5.0 Here is an example bash command using the Nicmanager provider:\n## Login using email NICMANAGER_API_EMAIL = \"you@example.com\" \\ NICMANAGER_API_PASSWORD = \"password\" \\ # Optionally, if your account has TOTP enabled, set the secret here NICMANAGER_API_OTP = \"long-secret\" \\ lego --dns nicmanager -d '*.example.com' -d example.com run ## Login using account name + username NICMANAGER_API_LOGIN = \"myaccount\" \\ NICMANAGER_API_USERNAME = \"myuser\" \\ NICMANAGER_API_PASSWORD = \"password\" \\ # Optionally, if your account has TOTP enabled, set the secret here NICMANAGER_API_OTP = \"long-secret\" \\ lego --dns nicmanager -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NICMANAGER_API_EMAIL Email-based login NICMANAGER_API_LOGIN Login, used for Username-based login NICMANAGER_API_PASSWORD Password, always required NICMANAGER_API_USERNAME Username, used for Username-based login The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NICMANAGER_API_MODE mode: ‘anycast’ or ‘zones’ (for FreeDNS) (default: ‘anycast’) NICMANAGER_API_OTP TOTP Secret (optional) NICMANAGER_HTTP_TIMEOUT API request timeout in seconds (Default: 10) NICMANAGER_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NICMANAGER_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) NICMANAGER_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 900) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription You can log in using your account name + username or using your email address. Optionally, if TOTP is configured for your account, set NICMANAGER_API_OTP.\nMore information API documentation",
    "description": "Configuration for Nicmanager.",
    "tags": [],
    "title": "Nicmanager",
    "uri": "/lego/dns/nicmanager/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for NIFCloud.\nCode: nifcloud Since: v1.1.0 Here is an example bash command using the NIFCloud provider:\nNIFCLOUD_ACCESS_KEY_ID=xxxx \\ NIFCLOUD_SECRET_ACCESS_KEY=yyyy \\ lego --dns nifcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NIFCLOUD_ACCESS_KEY_ID Access key NIFCLOUD_SECRET_ACCESS_KEY Secret access key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NIFCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NIFCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NIFCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) NIFCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for NIFCloud.",
    "tags": [],
    "title": "NIFCloud",
    "uri": "/lego/dns/nifcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Njalla.\nCode: njalla Since: v4.3.0 Here is an example bash command using the Njalla provider:\nNJALLA_TOKEN=xxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns njalla -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NJALLA_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NJALLA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NJALLA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NJALLA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) NJALLA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Njalla.",
    "tags": [],
    "title": "Njalla",
    "uri": "/lego/dns/njalla/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Nodion.\nCode: nodion Since: v4.11.0 Here is an example bash command using the Nodion provider:\nNODION_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns nodion -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NODION_API_TOKEN The API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NODION_HTTP_TIMEOUT API request timeout in seconds (Default: 30) NODION_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NODION_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) NODION_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Nodion.",
    "tags": [],
    "title": "Nodion",
    "uri": "/lego/dns/nodion/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for NS1.\nCode: ns1 Since: v0.4.0 Here is an example bash command using the NS1 provider:\nNS1_API_KEY=xxxx \\ lego --dns ns1 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NS1_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NS1_HTTP_TIMEOUT API request timeout in seconds (Default: 10) NS1_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) NS1_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) NS1_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for NS1.",
    "tags": [],
    "title": "NS1",
    "uri": "/lego/dns/ns1/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Octenium.\nCode: octenium Since: v4.27.0 Here is an example bash command using the Octenium provider:\nOCTENIUM_API_KEY=\"xxx\" \\ lego --dns octenium -d '*.example.com' -d example.com run Credentials Environment Variable Name Description OCTENIUM_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description OCTENIUM_HTTP_TIMEOUT API request timeout in seconds (Default: 30) OCTENIUM_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) OCTENIUM_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) OCTENIUM_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Octenium.",
    "tags": [],
    "title": "Octenium",
    "uri": "/lego/dns/octenium/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Open Telekom Cloud.\nCode: otc Since: v0.4.1 Here is an example bash command using the Open Telekom Cloud provider:\nOTC_DOMAIN_NAME=domain_name \\ OTC_USER_NAME=user_name \\ OTC_PASSWORD=password \\ OTC_PROJECT_NAME=project_name \\ lego --dns otc -d '*.example.com' -d example.com run Credentials Environment Variable Name Description OTC_DOMAIN_NAME Domain name OTC_PASSWORD Password OTC_PROJECT_NAME Project name OTC_USER_NAME User name The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description OTC_HTTP_TIMEOUT API request timeout in seconds (Default: 10) OTC_IDENTITY_ENDPOINT Identity endpoint URL (default: https://iam.eu-de.otc.t-systems.com:443/v3/auth/tokens) OTC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) OTC_PRIVATE_ZONE Set to true to use private zones only (default: use public zones only) OTC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) OTC_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) OTC_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Open Telekom Cloud.",
    "tags": [],
    "title": "Open Telekom Cloud",
    "uri": "/lego/dns/otc/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Oracle Cloud.\nCode: oraclecloud Since: v2.3.0 Here is an example bash command using the Oracle Cloud provider:\n# Using API Key authentication: OCI_PRIVATE_KEY_PATH=\"~/.oci/oci_api_key.pem\" \\ OCI_PRIVATE_KEY_PASSWORD=\"secret\" \\ OCI_TENANCY_OCID=\"ocid1.tenancy.oc1..secret\" \\ OCI_USER_OCID=\"ocid1.user.oc1..secret\" \\ OCI_FINGERPRINT=\"00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00\" \\ OCI_REGION=\"us-phoenix-1\" \\ OCI_COMPARTMENT_OCID=\"ocid1.tenancy.oc1..secret\" \\ lego --dns oraclecloud -d '*.example.com' -d example.com run # Using Instance Principal authentication (when running on OCI compute instances): # https://docs.oracle.com/en-us/iaas/Content/Identity/Tasks/callingservicesfrominstances.htm OCI_AUTH_TYPE=\"instance_principal\" \\ OCI_COMPARTMENT_OCID=\"ocid1.tenancy.oc1..secret\" \\ lego --dns oraclecloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description OCI_COMPARTMENT_OCID Compartment OCID OCI_FINGERPRINT Public key fingerprint (ignored if OCI_AUTH_TYPE=instance_principal) OCI_PRIVATE_KEY_PASSWORD Private key password (ignored if OCI_AUTH_TYPE=instance_principal) OCI_PRIVATE_KEY_PATH Private key file (ignored if OCI_AUTH_TYPE=instance_principal) OCI_REGION Region (it can be empty if OCI_AUTH_TYPE=instance_principal). OCI_TENANCY_OCID Tenancy OCID (ignored if OCI_AUTH_TYPE=instance_principal) OCI_USER_OCID User OCID (ignored if OCI_AUTH_TYPE=instance_principal) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description OCI_AUTH_TYPE Authorization type. Possible values: ‘instance_principal’, ’’ (Default: ‘’) OCI_HTTP_TIMEOUT API request timeout in seconds (Default: 60) OCI_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) OCI_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) OCI_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) TF_VAR_fingerprint Alias on OCI_FINGERPRINT TF_VAR_private_key_path Alias on OCI_PRIVATE_KEY_PATH TF_VAR_region Alias on OCI_REGION TF_VAR_tenancy_ocid Alias on OCI_TENANCY_OCID TF_VAR_user_ocid Alias on OCI_USER_OCID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Oracle Cloud.",
    "tags": [],
    "title": "Oracle Cloud",
    "uri": "/lego/dns/oraclecloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for OVH.\nCode: ovh Since: v0.4.0 Here is an example bash command using the OVH provider:\n# Application Key authentication: OVH_APPLICATION_KEY=1234567898765432 \\ OVH_APPLICATION_SECRET=b9841238feb177a84330febba8a832089 \\ OVH_CONSUMER_KEY=256vfsd347245sdfg \\ OVH_ENDPOINT=ovh-eu \\ lego --dns ovh -d '*.example.com' -d example.com run # Or Access Token: OVH_ACCESS_TOKEN=xxx \\ OVH_ENDPOINT=ovh-eu \\ lego --dns ovh -d '*.example.com' -d example.com run # Or OAuth2: OVH_CLIENT_ID=yyy \\ OVH_CLIENT_SECRET=xxx \\ OVH_ENDPOINT=ovh-eu \\ lego --dns ovh -d '*.example.com' -d example.com run Credentials Environment Variable Name Description OVH_ACCESS_TOKEN Access token OVH_APPLICATION_KEY Application key (Application Key authentication) OVH_APPLICATION_SECRET Application secret (Application Key authentication) OVH_CLIENT_ID Client ID (OAuth2) OVH_CLIENT_SECRET Client secret (OAuth2) OVH_CONSUMER_KEY Consumer key (Application Key authentication) OVH_ENDPOINT Endpoint URL (ovh-eu or ovh-ca) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description OVH_HTTP_TIMEOUT API request timeout in seconds (Default: 180) OVH_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) OVH_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) OVH_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nApplication Key and Secret Application key and secret can be created by following the OVH guide.\nWhen requesting the consumer key, the following configuration can be used to define access rights:\n{ \"accessRules\": [ { \"method\": \"POST\", \"path\": \"/domain/zone/*\" }, { \"method\": \"DELETE\", \"path\": \"/domain/zone/*\" } ] } OAuth2 Client Credentials Another method for authentication is by using OAuth2 client credentials.\nAn IAM policy and service account can be created by following the OVH guide.\nFollowing IAM policies need to be authorized for the affected domain:\ndnsZone:apiovh:record/create dnsZone:apiovh:record/delete dnsZone:apiovh:refresh Important Note Both authentication methods cannot be used at the same time.\nMore information API documentation Go client",
    "description": "Configuration for OVH.",
    "tags": [],
    "title": "OVH",
    "uri": "/lego/dns/ovh/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for plesk.com.\nCode: plesk Since: v4.11.0 Here is an example bash command using the plesk.com provider:\nPLESK_SERVER_BASE_URL=\"https://plesk.myserver.com:8443\" \\ PLESK_USERNAME=xxxxxx \\ PLESK_PASSWORD=yyyyyy \\ lego --dns plesk -d '*.example.com' -d example.com run Credentials Environment Variable Name Description PLESK_PASSWORD API password PLESK_SERVER_BASE_URL Base URL of the server (ex: https://plesk.myserver.com:8443) PLESK_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description PLESK_HTTP_TIMEOUT API request timeout in seconds (Default: 30) PLESK_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) PLESK_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) PLESK_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for plesk.com.",
    "tags": [],
    "title": "plesk.com",
    "uri": "/lego/dns/plesk/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Porkbun.\nCode: porkbun Since: v4.4.0 Here is an example bash command using the Porkbun provider:\nPORKBUN_SECRET_API_KEY=xxxxxx \\ PORKBUN_API_KEY=yyyyyy \\ lego --dns porkbun -d '*.example.com' -d example.com run Credentials Environment Variable Name Description PORKBUN_API_KEY API key PORKBUN_SECRET_API_KEY secret API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description PORKBUN_HTTP_TIMEOUT API request timeout in seconds (Default: 30) PORKBUN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) PORKBUN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) PORKBUN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Porkbun.",
    "tags": [],
    "title": "Porkbun",
    "uri": "/lego/dns/porkbun/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for PowerDNS.\nCode: pdns Since: v0.4.0 Here is an example bash command using the PowerDNS provider:\nPDNS_API_URL=http://pdns-server:80/ \\ PDNS_API_KEY=xxxx \\ lego --dns pdns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description PDNS_API_KEY API key PDNS_API_URL API URL The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description PDNS_API_VERSION Skip API version autodetection and use the provided version number. PDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) PDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) PDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) PDNS_SERVER_NAME Name of the server in the URL, ’localhost’ by default PDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nInformation Tested and confirmed to work with PowerDNS authoritative server 3.4.8 and 4.0.1. Refer to PowerDNS documentation instructions on how to enable the built-in API interface.\nPowerDNS Notes:\nPowerDNS API does not currently support SSL, therefore you should take care to ensure that traffic between lego and the PowerDNS API is over a trusted network, VPN etc. In order to have the SOA serial automatically increment each time the _acme-challenge record is added/modified via the API, set SOA-EDIT-API to INCEPTION-INCREMENT for the zone in the domainmetadata table Some PowerDNS servers doesn’t have root API endpoints enabled and API version autodetection will not work. In that case version number can be defined using PDNS_API_VERSION. More information API documentation",
    "description": "Configuration for PowerDNS.",
    "tags": [],
    "title": "PowerDNS",
    "uri": "/lego/dns/pdns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Rackspace.\nCode: rackspace Since: v0.4.0 Here is an example bash command using the Rackspace provider:\nRACKSPACE_USER=xxxx \\ RACKSPACE_API_KEY=yyyy \\ lego --dns rackspace -d '*.example.com' -d example.com run Credentials Environment Variable Name Description RACKSPACE_API_KEY API key RACKSPACE_USER API user The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description RACKSPACE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) RACKSPACE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 3) RACKSPACE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) RACKSPACE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Rackspace.",
    "tags": [],
    "title": "Rackspace",
    "uri": "/lego/dns/rackspace/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Rain Yun/雨云.\nCode: rainyun Since: v4.21.0 Here is an example bash command using the Rain Yun/雨云 provider:\nRAINYUN_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns rainyun -d '*.example.com' -d example.com run Credentials Environment Variable Name Description RAINYUN_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description RAINYUN_HTTP_TIMEOUT API request timeout in seconds (Default: 30) RAINYUN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) RAINYUN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) RAINYUN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Rain Yun/雨云.",
    "tags": [],
    "title": "Rain Yun/雨云",
    "uri": "/lego/dns/rainyun/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for RcodeZero.\nCode: rcodezero Since: v4.13 Here is an example bash command using the RcodeZero provider:\nRCODEZERO_API_TOKEN=\u003cmytoken\u003e \\ lego --dns rcodezero -d '*.example.com' -d example.com run Credentials Environment Variable Name Description RCODEZERO_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description RCODEZERO_HTTP_TIMEOUT API request timeout in seconds (Default: 30) RCODEZERO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) RCODEZERO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 240) RCODEZERO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nDescription Generate your API Token via https://my.rcodezero.at with the ACME permissions. These are special tokens with limited access for ACME requests only.\nRcodeZero is an Anycast Network so the distribution of the DNS01-Challenge can take up to 2 minutes.\nMore information API documentation",
    "description": "Configuration for RcodeZero.",
    "tags": [],
    "title": "RcodeZero",
    "uri": "/lego/dns/rcodezero/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for reg.ru.\nCode: regru Since: v3.5.0 Here is an example bash command using the reg.ru provider:\nREGRU_USERNAME=xxxxxx \\ REGRU_PASSWORD=yyyyyy \\ lego --dns regru -d '*.example.com' -d example.com run Credentials Environment Variable Name Description REGRU_PASSWORD API password REGRU_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description REGRU_HTTP_TIMEOUT API request timeout in seconds (Default: 30) REGRU_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) REGRU_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) REGRU_TLS_CERT authentication certificate REGRU_TLS_KEY authentication private key REGRU_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for reg.ru.",
    "tags": [],
    "title": "reg.ru",
    "uri": "/lego/dns/regru/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Regfish.\nCode: regfish Since: v4.20.0 Here is an example bash command using the Regfish provider:\nREGFISH_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns regfish -d '*.example.com' -d example.com run Credentials Environment Variable Name Description REGFISH_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description REGFISH_HTTP_TIMEOUT API request timeout in seconds (Default: 30) REGFISH_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) REGFISH_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) REGFISH_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Regfish.",
    "tags": [],
    "title": "Regfish",
    "uri": "/lego/dns/regfish/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for RFC2136.\nCode: rfc2136 Since: v0.3.0 Here is an example bash command using the RFC2136 provider:\nRFC2136_NAMESERVER=127.0.0.1 \\ RFC2136_TSIG_KEY=example.com \\ RFC2136_TSIG_ALGORITHM=hmac-sha256. \\ RFC2136_TSIG_SECRET=YWJjZGVmZGdoaWprbG1ub3BxcnN0dXZ3eHl6MTIzNDU= \\ lego --dns rfc2136 -d '*.example.com' -d example.com run ## --- keyname=example.com; keyfile=example.com.key; tsig-keygen $keyname \u003e $keyfile RFC2136_NAMESERVER=127.0.0.1 \\ RFC2136_TSIG_FILE=\"$keyfile\" \\ lego --dns rfc2136 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description RFC2136_NAMESERVER Network address in the form “host” or “host:port” RFC2136_TSIG_ALGORITHM TSIG algorithm. See miekg/dns#tsig.go for supported values. To disable TSIG authentication, leave the RFC2136_TSIG_KEY or RFC2136_TSIG_SECRET variables unset. RFC2136_TSIG_KEY Name of the secret key as defined in DNS server configuration. To disable TSIG authentication, leave the RFC2136_TSIG_KEY variable unset. RFC2136_TSIG_SECRET Secret key payload. To disable TSIG authentication, leave the RFC2136_TSIG_SECRET variable unset. The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description RFC2136_DNS_TIMEOUT API request timeout in seconds (Default: 10) RFC2136_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) RFC2136_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) RFC2136_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) RFC2136_TSIG_FILE Path to a key file generated by tsig-keygen RFC2136_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for RFC2136.",
    "tags": [],
    "title": "RFC2136",
    "uri": "/lego/dns/rfc2136/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for RimuHosting.\nCode: rimuhosting Since: v0.3.5 Here is an example bash command using the RimuHosting provider:\nRIMUHOSTING_API_KEY=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns rimuhosting -d '*.example.com' -d example.com run Credentials Environment Variable Name Description RIMUHOSTING_API_KEY User API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description RIMUHOSTING_HTTP_TIMEOUT API request timeout in seconds (Default: 30) RIMUHOSTING_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) RIMUHOSTING_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) RIMUHOSTING_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for RimuHosting.",
    "tags": [],
    "title": "RimuHosting",
    "uri": "/lego/dns/rimuhosting/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for RU CENTER.\nCode: nicru Since: v4.24.0 Here is an example bash command using the RU CENTER provider:\nNICRU_USER=\"\u003cyour_user\u003e\" \\ NICRU_PASSWORD=\"\u003cyour_password\u003e\" \\ NICRU_SERVICE_ID=\"\u003cservice_id\u003e\" \\ NICRU_SECRET=\"\u003cservice_secret\u003e\" \\ lego --dns nicru -d '*.example.com' -d example.com run Credentials Environment Variable Name Description NICRU_PASSWORD Password for an account in RU CENTER NICRU_SECRET Secret for application in DNS-hosting RU CENTER NICRU_SERVICE_ID Service ID for application in DNS-hosting RU CENTER NICRU_SERVICE_NAME Service Name for DNS-hosting RU CENTER NICRU_USER Agreement for an account in RU CENTER The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description NICRU_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 60) NICRU_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) NICRU_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 30) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nCredential information You can find information about service ID and secret https://www.nic.ru/manager/oauth.cgi?step=oauth.app_list\nENV Variable Parameter from page Example NICRU_USER Username (Number of agreement) NNNNNNN/NIC-D NICRU_PASSWORD Password account NICRU_SERVICE_ID Application ID hex-based, len 32 NICRU_SECRET Identity endpoint string len 91 More information API documentation",
    "description": "Configuration for RU CENTER.",
    "tags": [],
    "title": "RU CENTER",
    "uri": "/lego/dns/nicru/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Sakura Cloud.\nCode: sakuracloud Since: v1.1.0 Here is an example bash command using the Sakura Cloud provider:\nSAKURACLOUD_ACCESS_TOKEN=xxxxx \\ SAKURACLOUD_ACCESS_TOKEN_SECRET=yyyyy \\ lego --dns sakuracloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SAKURACLOUD_ACCESS_TOKEN Access token SAKURACLOUD_ACCESS_TOKEN_SECRET Access token secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SAKURACLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 10) SAKURACLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SAKURACLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SAKURACLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Sakura Cloud.",
    "tags": [],
    "title": "Sakura Cloud",
    "uri": "/lego/dns/sakuracloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Scaleway.\nCode: scaleway Since: v3.4.0 Here is an example bash command using the Scaleway provider:\nSCW_SECRET_KEY=xxxxxxx-xxxxx-xxxx-xxx-xxxxxx \\ lego --dns scaleway -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SCW_PROJECT_ID Project to use (optional) SCW_SECRET_KEY Secret key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SCW_ACCESS_KEY Access key SCW_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SCW_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) SCW_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) SCW_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Scaleway.",
    "tags": [],
    "title": "Scaleway",
    "uri": "/lego/dns/scaleway/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Selectel.\nCode: selectel Since: v1.2.0 Here is an example bash command using the Selectel provider:\nSELECTEL_API_TOKEN=xxxxx \\ lego --dns selectel -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SELECTEL_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SELECTEL_BASE_URL API endpoint URL SELECTEL_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SELECTEL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SELECTEL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) SELECTEL_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Selectel.",
    "tags": [],
    "title": "Selectel",
    "uri": "/lego/dns/selectel/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Selectel v2.\nCode: selectelv2 Since: v4.17.0 Here is an example bash command using the Selectel v2 provider:\nSELECTELV2_USERNAME=trex \\ SELECTELV2_PASSWORD=xxxxx \\ SELECTELV2_ACCOUNT_ID=1234567 \\ SELECTELV2_PROJECT_ID=111a11111aaa11aa1a11aaa11111aa1a \\ lego --dns selectelv2 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SELECTELV2_ACCOUNT_ID Selectel account ID (INT) SELECTELV2_PASSWORD Openstack username’s password SELECTELV2_PROJECT_ID Cloud project ID (UUID) SELECTELV2_USERNAME Openstack username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SELECTELV2_AUTH_REGION Location for auth endpoint like ResellAPI or Keystone (default: ‘ru-1’) SELECTELV2_AUTH_URL Identity endpoint (defaul: ‘https://cloud.api.selcloud.ru/identity/v3/') SELECTELV2_BASE_URL API endpoint URL SELECTELV2_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SELECTELV2_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) SELECTELV2_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) SELECTELV2_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) SELECTELV2_USER_DOMAIN_NAME To specify the domain name (account ID) where the user is located. (default: SELECTELV2_ACCOUNT_ID) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Selectel v2.",
    "tags": [],
    "title": "Selectel v2",
    "uri": "/lego/dns/selectelv2/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for SelfHost.(de|eu).\nCode: selfhostde Since: v4.19.0 Here is an example bash command using the SelfHost.(de|eu) provider:\nSELFHOSTDE_USERNAME=xxx \\ SELFHOSTDE_PASSWORD=yyy \\ SELFHOSTDE_RECORDS_MAPPING=my.example.com:123 \\ lego --dns selfhostde -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SELFHOSTDE_PASSWORD Password SELFHOSTDE_RECORDS_MAPPING Record IDs mapping with domains (ex: example.com:123:456,example.org:789,foo.example.com:147) SELFHOSTDE_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SELFHOSTDE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SELFHOSTDE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 30) SELFHOSTDE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 240) SELFHOSTDE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nSelfHost.de doesn’t have an API to create or delete TXT records, there is only an “unofficial” and undocumented endpoint to update an existing TXT record.\nSo, before using lego to request a certificate for a given domain or wildcard (such as my.example.org or *.my.example.org), you must create:\none TXT record named _acme-challenge.my.example.org if you are not using wildcard for this domain. two TXT records named _acme-challenge.my.example.org if you are using wildcard for this domain. After that you must edit the TXT record(s) to get the ID(s).\nYou then must prepare the SELFHOSTDE_RECORDS_MAPPING environment variable with the following format:\n\u003cdomain_A\u003e:\u003crecord_id_A1\u003e:\u003crecord_id_A2\u003e,\u003cdomain_B\u003e:\u003crecord_id_B1\u003e:\u003crecord_id_B2\u003e,\u003cdomain_C\u003e:\u003crecord_id_C1\u003e:\u003crecord_id_C2\u003e where each group of domain + record ID(s) is separated with a comma (,), and the domain and record ID(s) are separated with a colon (:).\nFor example, if you want to create or renew a certificate for my.example.org, *.my.example.org, and other.example.org, you would need:\ntwo separate records for _acme-challenge.my.example.org and another separate record for _acme-challenge.other.example.org The resulting environment variable would then be: SELFHOSTDE_RECORDS_MAPPING=my.example.com:123:456,other.example.com:789",
    "description": "Configuration for SelfHost.(de|eu).",
    "tags": [],
    "title": "SelfHost.(de|eu)",
    "uri": "/lego/dns/selfhostde/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Servercow.\nCode: servercow Since: v3.4.0 Here is an example bash command using the Servercow provider:\nSERVERCOW_USERNAME=xxxxxxxx \\ SERVERCOW_PASSWORD=xxxxxxxx \\ lego --dns servercow -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SERVERCOW_PASSWORD API password SERVERCOW_USERNAME API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SERVERCOW_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SERVERCOW_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SERVERCOW_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SERVERCOW_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Servercow.",
    "tags": [],
    "title": "Servercow",
    "uri": "/lego/dns/servercow/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Shellrent.\nCode: shellrent Since: v4.16.0 Here is an example bash command using the Shellrent provider:\nSHELLRENT_USERNAME=xxxx \\ SHELLRENT_TOKEN=yyyy \\ lego --dns shellrent -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SHELLRENT_TOKEN Token SHELLRENT_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SHELLRENT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SHELLRENT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) SHELLRENT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) SHELLRENT_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Shellrent.",
    "tags": [],
    "title": "Shellrent",
    "uri": "/lego/dns/shellrent/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Simply.com.\nCode: simply Since: v4.4.0 Here is an example bash command using the Simply.com provider:\nSIMPLY_ACCOUNT_NAME=xxxxxx \\ SIMPLY_API_KEY=yyyyyy \\ lego --dns simply -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SIMPLY_ACCOUNT_NAME Account name SIMPLY_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SIMPLY_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SIMPLY_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) SIMPLY_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) SIMPLY_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Simply.com.",
    "tags": [],
    "title": "Simply.com",
    "uri": "/lego/dns/simply/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Sonic.\nCode: sonic Since: v4.4.0 Here is an example bash command using the Sonic provider:\nSONIC_USER_ID=12345 \\ SONIC_API_KEY=4d6fbf2f9ab0fa11697470918d37625851fc0c51 \\ lego --dns sonic -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SONIC_API_KEY API Key SONIC_USER_ID User ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SONIC_HTTP_TIMEOUT API request timeout in seconds (Default: 10) SONIC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SONIC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SONIC_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) SONIC_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAPI keys The API keys must be generated by calling the dyndns/api_key endpoint.\nExample:\n$ curl -X POST -H \"Content-Type: application/json\" --data '{\"username\":\"notarealuser\",\"password\":\"notarealpassword\",\"hostname\":\"example.com\"}' https://public-api.sonic.net/dyndns/api_key {\"userid\":\"12345\",\"apikey\":\"4d6fbf2f9ab0fa11697470918d37625851fc0c51\",\"result\":200,\"message\":\"OK\"} See https://public-api.sonic.net/dyndns/#requesting_an_api_key for additional details.\nThis userid and apikey combo allow modifications to any DNS entries connected to the managed domain (hostname).\nHostname should be the toplevel domain managed e.g. example.com not www.example.com.\nMore information API documentation",
    "description": "Configuration for Sonic.",
    "tags": [],
    "title": "Sonic",
    "uri": "/lego/dns/sonic/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Spaceship.\nCode: spaceship Since: v4.22.0 Here is an example bash command using the Spaceship provider:\nSPACESHIP_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ SPACESHIP_API_SECRET=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns spaceship -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SPACESHIP_API_KEY API key SPACESHIP_API_SECRET API secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SPACESHIP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SPACESHIP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SPACESHIP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SPACESHIP_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Spaceship.",
    "tags": [],
    "title": "Spaceship",
    "uri": "/lego/dns/spaceship/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Stackpath.\nCode: stackpath Since: v1.1.0 Here is an example bash command using the Stackpath provider:\nSTACKPATH_CLIENT_ID=xxxxx \\ STACKPATH_CLIENT_SECRET=yyyyy \\ STACKPATH_STACK_ID=zzzzz \\ lego --dns stackpath -d '*.example.com' -d example.com run Credentials Environment Variable Name Description STACKPATH_CLIENT_ID Client ID STACKPATH_CLIENT_SECRET Client secret STACKPATH_STACK_ID Stack ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description STACKPATH_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) STACKPATH_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) STACKPATH_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Stackpath.",
    "tags": [],
    "title": "Stackpath",
    "uri": "/lego/dns/stackpath/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Syse.\nCode: syse Since: v4.30.0 Here is an example bash command using the Syse provider:\nSYSE_CREDENTIALS=example.com:password \\ lego --dns syse -d '*.example.com' -d example.com run SYSE_CREDENTIALS=example.org:password1,example.com:password2 \\ lego --dns syse -d '*.example.org' -d example.org -d '*.example.com' -d example.com Credentials Environment Variable Name Description SYSE_CREDENTIALS Comma-separated list of zone:password credential pairs The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SYSE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SYSE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) SYSE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 1200) SYSE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Syse.",
    "tags": [],
    "title": "Syse",
    "uri": "/lego/dns/syse/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Technitium.\nCode: technitium Since: v4.20.0 Here is an example bash command using the Technitium provider:\nTECHNITIUM_SERVER_BASE_URL=\"https://localhost:5380\" \\ TECHNITIUM_API_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns technitium -d '*.example.com' -d example.com run Credentials Environment Variable Name Description TECHNITIUM_API_TOKEN API token TECHNITIUM_SERVER_BASE_URL Server base URL The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description TECHNITIUM_HTTP_TIMEOUT API request timeout in seconds (Default: 30) TECHNITIUM_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) TECHNITIUM_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) TECHNITIUM_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nTechnitium DNS Server supports Dynamic Updates (RFC2136) for primary zones, so you can also use the RFC2136 provider.\nRFC2136 provider is much better compared to the HTTP API option from security perspective. Technitium recommends to use it in production over the HTTP API.\nMore information API documentation",
    "description": "Configuration for Technitium.",
    "tags": [],
    "title": "Technitium",
    "uri": "/lego/dns/technitium/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Tencent Cloud DNS.\nCode: tencentcloud Since: v4.6.0 Here is an example bash command using the Tencent Cloud DNS provider:\nTENCENTCLOUD_SECRET_ID=abcdefghijklmnopqrstuvwx \\ TENCENTCLOUD_SECRET_KEY=your-secret-key \\ lego --dns tencentcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description TENCENTCLOUD_SECRET_ID Access key ID TENCENTCLOUD_SECRET_KEY Access Key secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description TENCENTCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 30) TENCENTCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) TENCENTCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) TENCENTCLOUD_REGION Region TENCENTCLOUD_SESSION_TOKEN Access Key token TENCENTCLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Tencent Cloud DNS.",
    "tags": [],
    "title": "Tencent Cloud DNS",
    "uri": "/lego/dns/tencentcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Tencent EdgeOne.\nCode: edgeone Since: v4.26.0 Here is an example bash command using the Tencent EdgeOne provider:\nEDGEONE_SECRET_ID=abcdefghijklmnopqrstuvwx \\ EDGEONE_SECRET_KEY=your-secret-key \\ lego --dns edgeone -d '*.example.com' -d example.com run Credentials Environment Variable Name Description EDGEONE_SECRET_ID Access key ID EDGEONE_SECRET_KEY Access Key secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description EDGEONE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) EDGEONE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 30) EDGEONE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 1200) EDGEONE_REGION Region EDGEONE_SESSION_TOKEN Access Key token EDGEONE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) EDGEONE_ZONES_MAPPING Mapping between DNS zones and site IDs. (ex: ’example.org:id1,example.com:id2') The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Tencent EdgeOne.",
    "tags": [],
    "title": "Tencent EdgeOne",
    "uri": "/lego/dns/edgeone/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Timeweb Cloud.\nCode: timewebcloud Since: v4.20.0 Here is an example bash command using the Timeweb Cloud provider:\nTIMEWEBCLOUD_AUTH_TOKEN=xxxxxx \\ lego --dns timewebcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description TIMEWEBCLOUD_AUTH_TOKEN Authentication token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description TIMEWEBCLOUD_HTTP_TIMEOUT API request timeout in seconds (Default: 10) TIMEWEBCLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) TIMEWEBCLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Timeweb Cloud.",
    "tags": [],
    "title": "Timeweb Cloud",
    "uri": "/lego/dns/timewebcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for TransIP.\nCode: transip Since: v2.0.0 Here is an example bash command using the TransIP provider:\nTRANSIP_ACCOUNT_NAME = \"Account name\" \\ TRANSIP_PRIVATE_KEY_PATH = \"transip.key\" \\ lego --dns transip -d '*.example.com' -d example.com run Credentials Environment Variable Name Description TRANSIP_ACCOUNT_NAME Account name TRANSIP_PRIVATE_KEY_PATH Private key path The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description TRANSIP_HTTP_TIMEOUT API request timeout in seconds (Default: 30) TRANSIP_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) TRANSIP_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) TRANSIP_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 10) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for TransIP.",
    "tags": [],
    "title": "TransIP",
    "uri": "/lego/dns/transip/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for UKFast SafeDNS.\nCode: safedns Since: v4.6.0 Here is an example bash command using the UKFast SafeDNS provider:\nSAFEDNS_AUTH_TOKEN=xxxxxx \\ lego --dns safedns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description SAFEDNS_AUTH_TOKEN Authentication token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description SAFEDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) SAFEDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) SAFEDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) SAFEDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for UKFast SafeDNS.",
    "tags": [],
    "title": "UKFast SafeDNS",
    "uri": "/lego/dns/safedns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Ultradns.\nCode: ultradns Since: v4.10.0 Here is an example bash command using the Ultradns provider:\nULTRADNS_USERNAME=username \\ ULTRADNS_PASSWORD=password \\ lego --dns ultradns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ULTRADNS_PASSWORD API Password ULTRADNS_USERNAME API Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ULTRADNS_ENDPOINT API endpoint URL, defaults to https://api.ultradns.com/ ULTRADNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) ULTRADNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) ULTRADNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Ultradns.",
    "tags": [],
    "title": "Ultradns",
    "uri": "/lego/dns/ultradns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for United-Domains.\nCode: uniteddomains Since: v4.29.0 Here is an example bash command using the United-Domains provider:\nUNITEDDOMAINS_API_KEY=xxxxxxxx \\ lego --dns uniteddomains -d '*.example.com' -d example.com run Credentials Environment Variable Name Description UNITEDDOMAINS_API_KEY API key \u003cprefix\u003e.\u003csecret\u003e https://www.united-domains.de/help/faq-article/getting-started-with-the-united-domains-dns-api/ The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description UNITEDDOMAINS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) UNITEDDOMAINS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) UNITEDDOMAINS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 900) UNITEDDOMAINS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for United-Domains.",
    "tags": [],
    "title": "United-Domains",
    "uri": "/lego/dns/uniteddomains/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Variomedia.\nCode: variomedia Since: v4.8.0 Here is an example bash command using the Variomedia provider:\nVARIOMEDIA_API_TOKEN=xxxx \\ lego --dns variomedia -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VARIOMEDIA_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VARIOMEDIA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VARIOMEDIA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) VARIOMEDIA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) VARIOMEDIA_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) VARIOMEDIA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Variomedia.",
    "tags": [],
    "title": "Variomedia",
    "uri": "/lego/dns/variomedia/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for VegaDNS.\nCode: vegadns Since: v1.1.0 Note Please contribute by adding a CLI example.\nCredentials Environment Variable Name Description SECRET_VEGADNS_KEY API key SECRET_VEGADNS_SECRET API secret VEGADNS_URL API endpoint URL The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VEGADNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 60) VEGADNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 720) VEGADNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 10) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for VegaDNS.",
    "tags": [],
    "title": "VegaDNS",
    "uri": "/lego/dns/vegadns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Vercel.\nCode: vercel Since: v4.7.0 Here is an example bash command using the Vercel provider:\nVERCEL_API_TOKEN=xxxxxx \\ lego --dns vercel -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VERCEL_API_TOKEN Authentication token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VERCEL_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VERCEL_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) VERCEL_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) VERCEL_TEAM_ID Team ID (ex: team_xxxxxxxxxxxxxxxxxxxxxxxx) VERCEL_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Vercel.",
    "tags": [],
    "title": "Vercel",
    "uri": "/lego/dns/vercel/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Versio.[nl|eu|uk].\nCode: versio Since: v2.7.0 Here is an example bash command using the Versio.[nl|eu|uk] provider:\nVERSIO_USERNAME=\u003cyour login\u003e \\ VERSIO_PASSWORD=\u003cyour password\u003e \\ lego --dns versio -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VERSIO_PASSWORD Basic authentication password VERSIO_USERNAME Basic authentication username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VERSIO_ENDPOINT The endpoint URL of the API Server VERSIO_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VERSIO_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) VERSIO_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) VERSIO_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) VERSIO_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nTo test with the sandbox environment set VERSIO_ENDPOINT=https://www.versio.nl/testapi/v1/\nMore information API documentation",
    "description": "Configuration for Versio.[nl|eu|uk].",
    "tags": [],
    "title": "Versio.[nl|eu|uk]",
    "uri": "/lego/dns/versio/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for VinylDNS.\nCode: vinyldns Since: v4.4.0 Here is an example bash command using the VinylDNS provider:\nVINYLDNS_ACCESS_KEY=xxxxxx \\ VINYLDNS_SECRET_KEY=yyyyy \\ VINYLDNS_HOST=https://api.vinyldns.example.org:9443 \\ lego --dns vinyldns -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VINYLDNS_ACCESS_KEY The VinylDNS API key VINYLDNS_HOST The VinylDNS API URL VINYLDNS_SECRET_KEY The VinylDNS API Secret key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VINYLDNS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VINYLDNS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 4) VINYLDNS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) VINYLDNS_QUOTE_VALUE Adds quotes around the TXT record value (Default: false) VINYLDNS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 30) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nThe vinyldns integration makes use of dotted hostnames to ease permission management. Users are required to have DELETE ACL level or zone admin permissions on the VinylDNS zone containing the target host.\nMore information API documentation Go client",
    "description": "Configuration for VinylDNS.",
    "tags": [],
    "title": "VinylDNS",
    "uri": "/lego/dns/vinyldns/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Virtualname.\nCode: virtualname Since: v4.30.0 Here is an example bash command using the Virtualname provider:\nVIRTUALNAME_TOKEN=xxxxxx \\ lego --dns virtualname -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VIRTUALNAME_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VIRTUALNAME_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VIRTUALNAME_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) VIRTUALNAME_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) VIRTUALNAME_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Virtualname.",
    "tags": [],
    "title": "Virtualname",
    "uri": "/lego/dns/virtualname/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for VK Cloud.\nCode: vkcloud Since: v4.9.0 Here is an example bash command using the VK Cloud provider:\nVK_CLOUD_PROJECT_ID=\"\u003cyour_project_id\u003e\" \\ VK_CLOUD_USERNAME=\"\u003cyour_email\u003e\" \\ VK_CLOUD_PASSWORD=\"\u003cyour_password\u003e\" \\ lego --dns vkcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VK_CLOUD_PASSWORD Password for VK Cloud account VK_CLOUD_PROJECT_ID String ID of project in VK Cloud VK_CLOUD_USERNAME Email of VK Cloud account The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VK_CLOUD_DNS_ENDPOINT URL of DNS API. Defaults to https://mcs.mail.ru/public-dns but can be changed for usage with private clouds VK_CLOUD_DOMAIN_NAME Openstack users domain name. Defaults to users but can be changed for usage with private clouds VK_CLOUD_IDENTITY_ENDPOINT URL of OpenStack Auth API, Defaults to https://infra.mail.ru:35357/v3/ but can be changed for usage with private clouds VK_CLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) VK_CLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) VK_CLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nCredential information You can find all required and additional information on “Project/Keys” page of your cloud.\nENV Variable Parameter from page VK_CLOUD_PROJECT_ID Project ID VK_CLOUD_USERNAME Username VK_CLOUD_DOMAIN_NAME User Domain Name VK_CLOUD_IDENTITY_ENDPOINT Identity endpoint More information API documentation",
    "description": "Configuration for VK Cloud.",
    "tags": [],
    "title": "VK Cloud",
    "uri": "/lego/dns/vkcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Volcano Engine/火山引擎.\nCode: volcengine Since: v4.19.0 Here is an example bash command using the Volcano Engine/火山引擎 provider:\nVOLC_ACCESSKEY=xxx \\ VOLC_SECRETKEY=yyy \\ lego --dns volcengine -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VOLC_ACCESSKEY Access Key ID (AK) VOLC_SECRETKEY Secret Access Key (SK) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VOLC_HOST API host VOLC_HTTP_TIMEOUT API request timeout in seconds (Default: 15) VOLC_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) VOLC_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 240) VOLC_REGION Region VOLC_SCHEME API scheme VOLC_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Volcano Engine/火山引擎.",
    "tags": [],
    "title": "Volcano Engine/火山引擎",
    "uri": "/lego/dns/volcengine/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Vscale.\nCode: vscale Since: v2.0.0 Here is an example bash command using the Vscale provider:\nVSCALE_API_TOKEN=xxxxx \\ lego --dns vscale -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VSCALE_API_TOKEN API token The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VSCALE_BASE_URL API endpoint URL VSCALE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VSCALE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) VSCALE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) VSCALE_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Vscale.",
    "tags": [],
    "title": "Vscale",
    "uri": "/lego/dns/vscale/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Vultr.\nCode: vultr Since: v0.3.1 Here is an example bash command using the Vultr provider:\nVULTR_API_KEY=xxxxx \\ lego --dns vultr -d '*.example.com' -d example.com run Credentials Environment Variable Name Description VULTR_API_KEY API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description VULTR_HTTP_TIMEOUT API request timeout in seconds (Default: 30) VULTR_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) VULTR_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) VULTR_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation Go client",
    "description": "Configuration for Vultr.",
    "tags": [],
    "title": "Vultr",
    "uri": "/lego/dns/vultr/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for webnames.ca.\nCode: webnamesca Since: v4.28.0 Here is an example bash command using the webnames.ca provider:\nWEBNAMESCA_API_USER=\"xxx\" \\ WEBNAMESCA_API_KEY=\"yyy\" \\ lego --dns webnamesca -d '*.example.com' -d example.com run Credentials Environment Variable Name Description WEBNAMESCA_API_KEY API key WEBNAMESCA_API_USER API username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description WEBNAMESCA_HTTP_TIMEOUT API request timeout in seconds (Default: 30) WEBNAMESCA_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) WEBNAMESCA_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) WEBNAMESCA_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 120) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for webnames.ca.",
    "tags": [],
    "title": "webnames.ca",
    "uri": "/lego/dns/webnamesca/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for webnames.ru.\nCode: webnames Since: v4.15.0 Here is an example bash command using the webnames.ru provider:\nWEBNAMESRU_API_KEY=xxxxxx \\ lego --dns webnamesru -d '*.example.com' -d example.com run Credentials Environment Variable Name Description WEBNAMESRU_API_KEY Domain API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description WEBNAMESRU_HTTP_TIMEOUT API request timeout in seconds (Default: 30) WEBNAMESRU_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) WEBNAMESRU_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAPI Key To obtain the key, you need to change the DNS server to *.nameself.com: Personal account / My domains and services / Select the required domain / DNS servers\nThe API key can be found: Personal account / My domains and services / Select the required domain / Zone management / acme.sh or certbot settings\nMore information API documentation",
    "description": "Configuration for webnames.ru.",
    "tags": [],
    "title": "webnames.ru",
    "uri": "/lego/dns/webnames/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Websupport.\nCode: websupport Since: v4.10.0 Here is an example bash command using the Websupport provider:\nWEBSUPPORT_API_KEY=\"xxxxxxxxxxxxxxxxxxxxx\" \\ WEBSUPPORT_SECRET=\"yyyyyyyyyyyyyyyyyyyyy\" \\ lego --dns websupport -d '*.example.com' -d example.com run Credentials Environment Variable Name Description WEBSUPPORT_API_KEY API key WEBSUPPORT_SECRET API secret The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description WEBSUPPORT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) WEBSUPPORT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) WEBSUPPORT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) WEBSUPPORT_SEQUENCE_INTERVAL Time between sequential requests in seconds (Default: 60) WEBSUPPORT_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Websupport.",
    "tags": [],
    "title": "Websupport",
    "uri": "/lego/dns/websupport/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for WEDOS.\nCode: wedos Since: v4.4.0 Here is an example bash command using the WEDOS provider:\nWEDOS_USERNAME=xxxxxxxx \\ WEDOS_WAPI_PASSWORD=xxxxxxxx \\ lego --dns wedos -d '*.example.com' -d example.com run Credentials Environment Variable Name Description WEDOS_USERNAME Username is the same as for the admin account WEDOS_WAPI_PASSWORD Password needs to be generated and IP allowed in the admin interface The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description WEDOS_HTTP_TIMEOUT API request timeout in seconds (Default: 30) WEDOS_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) WEDOS_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 600) WEDOS_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for WEDOS.",
    "tags": [],
    "title": "WEDOS",
    "uri": "/lego/dns/wedos/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for West.cn/西部数码.\nCode: westcn Since: v4.21.0 Here is an example bash command using the West.cn/西部数码 provider:\nWESTCN_USERNAME=\"xxx\" \\ WESTCN_PASSWORD=\"yyy\" \\ lego --dns westcn -d '*.example.com' -d example.com run Credentials Environment Variable Name Description WESTCN_PASSWORD API password WESTCN_USERNAME Username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description WESTCN_HTTP_TIMEOUT API request timeout in seconds (Default: 30) WESTCN_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 10) WESTCN_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 120) WESTCN_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for West.cn/西部数码.",
    "tags": [],
    "title": "West.cn/西部数码",
    "uri": "/lego/dns/westcn/index.html"
  },
  {
    "breadcrumb": "Lego \u003e Usage \u003e Library",
    "content": "Lego can solve multiple ACME challenge types out of the box, but sometimes you have custom requirements.\nFor example, you may want to write a solver for the DNS-01 challenge that works with a different DNS provider (lego already supports CloudFlare, AWS, DigitalOcean, and others).\nThe DNS-01 challenge is advantageous when other challenge types are impossible. For example, the HTTP-01 challenge doesn’t work well behind a load balancer or CDN and the TLS-ALPN-01 challenge breaks behind TLS termination.\nBut even if using HTTP-01 or TLS-ALPN-01 challenges, you may have specific needs that lego does not consider by default.\nYou can write something called a challenge.Provider that implements this interface:\ntype Provider interface { Present(domain, token, keyAuth string) error CleanUp(domain, token, keyAuth string) error } This provides the means to solve a challenge. First you present a token to the ACME server in a way defined by the challenge type you’re solving for, then you “clean up” after the challenge finishes.\nWriting a challenge.Provider Pretend we want to write our own DNS-01 challenge provider (other challenge types have different requirements but the same principles apply).\nThis will let us prove ownership of domain names parked at a new, imaginary DNS service called BestDNS without having to start our own HTTP server. BestDNS has an API that, given an authentication token, allows us to manipulate DNS records.\nThis simplistic example has only one field to store the auth token, but in reality you may need to keep more state.\ntype DNSProviderBestDNS struct { apiAuthToken string } We should provide a constructor that returns a pointer to the struct. This is important in case we need to maintain state in the struct.\nfunc NewDNSProviderBestDNS(apiAuthToken string) (*DNSProviderBestDNS, error) { return \u0026DNSProviderBestDNS{apiAuthToken: apiAuthToken}, nil } Now we need to implement the interface. We’ll start with the Present method. You’ll be passed the domain name for which you’re proving ownership, a token, and a keyAuth string. How your provider uses token and keyAuth, or if you even use them at all, depends on the challenge type. For DNS-01, we’ll just use domain and keyAuth.\nfunc (d *DNSProviderBestDNS) Present(domain, token, keyAuth string) error { info := dns01.GetChallengeInfo(domain, keyAuth) // make API request to set a TXT record on fqdn with value and TTL return nil } After calling dns01.GetChallengeInfo(domain, keyAuth), we now have the information we need to make our API request and set the TXT record:\nFQDN is the fully qualified domain name on which to set the TXT record. EffectiveFQDN is the fully qualified domain name after the CNAMEs resolutions on which to set the TXT record. Value is the record’s value to set on the record. So then you make an API request to the DNS service according to their docs. Once the TXT record is set on the domain, you may return and the challenge will proceed.\nThe ACME server will then verify that you did what it required you to do, and once it is finished, lego will call your CleanUp method. In our case, we want to remove the TXT record we just created.\nfunc (d *DNSProviderBestDNS) CleanUp(domain, token, keyAuth string) error { // clean up any state you created in Present, like removing the TXT record } In our case, we’d just make another API request to have the DNS record deleted; no need to keep it and clutter the zone file.\nUsing your new challenge.Provider To use your new challenge provider, call client.Challenge.SetDNS01Provider to tell lego, “For this challenge, use this provider”. In our case:\nbestDNS, err := NewDNSProviderBestDNS(\"my-auth-token\") if err != nil { return err } client.Challenge.SetDNS01Provider(bestDNS) Then, when this client tries to solve the DNS-01 challenge, it will use our new provider, which sets TXT records on a domain name hosted by BestDNS.\nThat’s really all there is to it. Go make awesome things!",
    "description": "Lego can solve multiple ACME challenge types out of the box, but sometimes you have custom requirements.",
    "tags": [],
    "title": "Writing a Challenge Solver",
    "uri": "/lego/usage/library/writing-a-challenge-solver/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Yandex 360.\nCode: yandex360 Since: v4.14.0 Here is an example bash command using the Yandex 360 provider:\nYANDEX360_OAUTH_TOKEN=\u003cyour OAuth Token\u003e \\ YANDEX360_ORG_ID=\u003cyour organization ID\u003e \\ lego --dns yandex360 -d '*.example.com' -d example.com run Credentials Environment Variable Name Description YANDEX360_OAUTH_TOKEN The OAuth Token YANDEX360_ORG_ID The organization ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description YANDEX360_HTTP_TIMEOUT API request timeout in seconds (Default: 30) YANDEX360_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) YANDEX360_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) YANDEX360_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 21600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Yandex 360.",
    "tags": [],
    "title": "Yandex 360",
    "uri": "/lego/dns/yandex360/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Yandex Cloud.\nCode: yandexcloud Since: v4.9.0 Here is an example bash command using the Yandex Cloud provider:\nYANDEX_CLOUD_IAM_TOKEN=\u003cbase64_IAM_token\u003e \\ YANDEX_CLOUD_FOLDER_ID=\u003cfolder/project_id\u003e \\ lego --dns yandexcloud -d '*.example.com' -d example.com run # --- YANDEX_CLOUD_IAM_TOKEN=$(echo '{ \\ \"id\": \"\u003cstring id\u003e\", \\ \"service_account_id\": \"\u003cstring id\u003e\", \\ \"created_at\": \"\u003cdatetime\u003e\", \\ \"key_algorithm\": \"RSA_2048\", \\ \"public_key\": \"-----BEGIN PUBLIC KEY-----\u003crsa public key\u003e-----END PUBLIC KEY-----\", \\ \"private_key\": \"-----BEGIN PRIVATE KEY-----\u003crsa private key\u003e-----END PRIVATE KEY-----\" \\ }' | base64) \\ YANDEX_CLOUD_FOLDER_ID=\u003cyandex cloud folder(project) id\u003e \\ lego --dns yandexcloud -d '*.example.com' -d example.com run Credentials Environment Variable Name Description YANDEX_CLOUD_FOLDER_ID The string id of folder (aka project) in Yandex Cloud YANDEX_CLOUD_IAM_TOKEN The base64 encoded json which contains information about iam token of service account with dns.admin permissions The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description YANDEX_CLOUD_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) YANDEX_CLOUD_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) YANDEX_CLOUD_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nIAM Token The simplest way to retrieve IAM access token is usage of yc-cli, follow docs to get it\nyc iam key create --service-account-name my-robot --output key.json cat key.json | base64 More information API documentation",
    "description": "Configuration for Yandex Cloud.",
    "tags": [],
    "title": "Yandex Cloud",
    "uri": "/lego/dns/yandexcloud/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Yandex PDD.\nCode: yandex Since: v3.7.0 Here is an example bash command using the Yandex PDD provider:\nYANDEX_PDD_TOKEN=\u003cyour PDD Token\u003e \\ lego --dns yandex -d '*.example.com' -d example.com run Credentials Environment Variable Name Description YANDEX_PDD_TOKEN Basic authentication username The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description YANDEX_HTTP_TIMEOUT API request timeout in seconds (Default: 30) YANDEX_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) YANDEX_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) YANDEX_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 21600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Yandex PDD.",
    "tags": [],
    "title": "Yandex PDD",
    "uri": "/lego/dns/yandex/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Zone.ee.\nCode: zoneee Since: v2.1.0 Here is an example bash command using the Zone.ee provider:\nZONEEE_API_USER=xxxxx \\ ZONEEE_API_KEY=yyyyy \\ lego --dns zoneee -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ZONEEE_API_KEY API key ZONEEE_API_USER API user The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ZONEEE_ENDPOINT API endpoint URL ZONEEE_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ZONEEE_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 5) ZONEEE_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 300) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Zone.ee.",
    "tags": [],
    "title": "Zone.ee",
    "uri": "/lego/dns/zoneee/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for ZoneEdit.\nCode: zoneedit Since: v4.25.0 Here is an example bash command using the ZoneEdit provider:\nZONEEDIT_USER=\"xxxxxxxxxxxxxxxxxxxxx\" \\ ZONEEDIT_AUTH_TOKEN=\"xxxxxxxxxxxxxxxxxxxxx\" \\ lego --dns zoneedit -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ZONEEDIT_AUTH_TOKEN Authentication token ZONEEDIT_USER User ID The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ZONEEDIT_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ZONEEDIT_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ZONEEDIT_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for ZoneEdit.",
    "tags": [],
    "title": "ZoneEdit",
    "uri": "/lego/dns/zoneedit/index.html"
  },
  {
    "breadcrumb": "Lego \u003e DNS Providers",
    "content": "Configuration for Zonomi.\nCode: zonomi Since: v3.5.0 Here is an example bash command using the Zonomi provider:\nZONOMI_API_KEY=xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx \\ lego --dns zonomi -d '*.example.com' -d example.com run Credentials Environment Variable Name Description ZONOMI_API_KEY User API key The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nAdditional Configuration Environment Variable Name Description ZONOMI_HTTP_TIMEOUT API request timeout in seconds (Default: 30) ZONOMI_POLLING_INTERVAL Time between DNS propagation check in seconds (Default: 2) ZONOMI_PROPAGATION_TIMEOUT Maximum waiting time for DNS propagation in seconds (Default: 60) ZONOMI_TTL The TTL of the TXT record used for the DNS challenge in seconds (Default: 3600) The environment variable names can be suffixed by _FILE to reference a file instead of a value. More information here.\nMore information API documentation",
    "description": "Configuration for Zonomi.",
    "tags": [],
    "title": "Zonomi",
    "uri": "/lego/dns/zonomi/index.html"
  },
  {
    "breadcrumb": "Lego",
    "content": "",
    "description": "",
    "tags": [],
    "title": "Categories",
    "uri": "/lego/categories/index.html"
  },
  {
    "breadcrumb": "Lego",
    "content": "",
    "description": "",
    "tags": [],
    "title": "Tags",
    "uri": "/lego/tags/index.html"
  }
]
