import json
import yaml
from yaml import CSafeLoader
from yaml import SafeLoader
from yaml.loader import SafeLoader as NewSafeLoader


def test_yaml_load():
    ystr = yaml.dump({"a": 1, "b": 2, "c": 3})
    y = yaml.load(ystr)
    yaml.dump(y)
    try:
        y = yaml.load(ystr, Loader=yaml.CSafeLoader)
    except AttributeError:
        # CSafeLoader only exists if you build yaml with LibYAML
        y = yaml.load(ystr, Loader=yaml.SafeLoader)


def test_json_load():
    # no issue should be found
    j = json.load("{}")


yaml.load("{}", Loader=yaml.Loader)

# no issue should be found
yaml.load("{}", SafeLoader)
yaml.load("{}", yaml.SafeLoader)
yaml.load("{}", CSafeLoader)
yaml.load("{}", yaml.CSafeLoader)
yaml.load("{}", yaml.cyaml.CSafeLoader)
yaml.load("{}", NewSafeLoader)
yaml.load("{}", Loader=SafeLoader)
yaml.load("{}", Loader=yaml.SafeLoader)
yaml.load("{}", Loader=CSafeLoader)
yaml.load("{}", Loader=yaml.CSafeLoader)
yaml.load("{}", Loader=yaml.cyaml.CSafeLoader)
yaml.load("{}", Loader=NewSafeLoader)

# no issue should be found (preview mode only)
yaml.load("{}", Loader=yaml.BaseLoader)
yaml.load("{}", Loader=yaml.CBaseLoader)
yaml.load("{}", yaml.BaseLoader)
yaml.load("{}", yaml.CBaseLoader)
from yaml import BaseLoader
yaml.load("{}", Loader=BaseLoader)
from yaml.loader import BaseLoader as BL
yaml.load("{}", Loader=BL)
from yaml.cyaml import CBaseLoader
yaml.load("{}", Loader=CBaseLoader)
