// Code generated by "./generator ./system/org.deepin.dde.inputdevices1"; DO NOT EDIT.

// SPDX-FileCopyrightText: 2018 - 2023 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later
package inputdevices1

import (
	"errors"
	"fmt"
	"unsafe"

	"github.com/godbus/dbus/v5"
	"github.com/linuxdeepin/go-lib/dbusutil"
	"github.com/linuxdeepin/go-lib/dbusutil/proxy"
)

type InputDevices interface {
	inputDevices // interface org.deepin.dde.InputDevices1
	proxy.Object
}

type objectInputDevices struct {
	interfaceInputDevices // interface org.deepin.dde.InputDevices1
	proxy.ImplObject
}

func NewInputDevices(conn *dbus.Conn) InputDevices {
	obj := new(objectInputDevices)
	obj.ImplObject.Init_(conn, "org.deepin.dde.InputDevices1", "/org/deepin/dde/InputDevices1")
	return obj
}

type inputDevices interface {
	ConnectTouchscreenAdded(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	ConnectTouchscreenRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error)
	Touchscreens() proxy.PropObjectPathArray
}

type interfaceInputDevices struct{}

func (v *interfaceInputDevices) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceInputDevices) GetInterfaceName_() string {
	return "org.deepin.dde.InputDevices1"
}

// signal TouchscreenAdded

func (v *interfaceInputDevices) ConnectTouchscreenAdded(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchscreenAdded", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchscreenAdded",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// signal TouchscreenRemoved

func (v *interfaceInputDevices) ConnectTouchscreenRemoved(cb func(path dbus.ObjectPath)) (dbusutil.SignalHandlerId, error) {
	if cb == nil {
		return 0, errors.New("nil callback")
	}
	obj := v.GetObject_()
	rule := fmt.Sprintf(
		"type='signal',interface='%s',member='%s',path='%s',sender='%s'",
		v.GetInterfaceName_(), "TouchscreenRemoved", obj.Path_(), obj.ServiceName_())

	sigRule := &dbusutil.SignalRule{
		Path: obj.Path_(),
		Name: v.GetInterfaceName_() + ".TouchscreenRemoved",
	}
	handlerFunc := func(sig *dbus.Signal) {
		var path dbus.ObjectPath
		err := dbus.Store(sig.Body, &path)
		if err == nil {
			cb(path)
		}
	}

	return obj.ConnectSignal_(rule, sigRule, handlerFunc)
}

// property Touchscreens ao

func (v *interfaceInputDevices) Touchscreens() proxy.PropObjectPathArray {
	return &proxy.ImplPropObjectPathArray{
		Impl: v,
		Name: "Touchscreens",
	}
}

type Touchscreen interface {
	touchscreen // interface org.deepin.dde.InputDevices1.Touchscreen
	proxy.Object
}

type objectTouchscreen struct {
	interfaceTouchscreen // interface org.deepin.dde.InputDevices1.Touchscreen
	proxy.ImplObject
}

func NewTouchscreen(conn *dbus.Conn, path dbus.ObjectPath) (Touchscreen, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectTouchscreen)
	obj.ImplObject.Init_(conn, "org.deepin.dde.InputDevices1", path)
	return obj, nil
}

type touchscreen interface {
	DevNode() proxy.PropString
	BusType() proxy.PropString
	UUID() proxy.PropString
	Phys() proxy.PropString
	OutputName() proxy.PropString
	Width() proxy.PropDouble
	Height() proxy.PropDouble
	Name() proxy.PropString
	Serial() proxy.PropString
}

type interfaceTouchscreen struct{}

func (v *interfaceTouchscreen) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceTouchscreen) GetInterfaceName_() string {
	return "org.deepin.dde.InputDevices1.Touchscreen"
}

// property DevNode s

func (v *interfaceTouchscreen) DevNode() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "DevNode",
	}
}

// property BusType s

func (v *interfaceTouchscreen) BusType() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "BusType",
	}
}

// property UUID s

func (v *interfaceTouchscreen) UUID() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "UUID",
	}
}

// property Phys s

func (v *interfaceTouchscreen) Phys() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Phys",
	}
}

// property OutputName s

func (v *interfaceTouchscreen) OutputName() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "OutputName",
	}
}

// property Width d

func (v *interfaceTouchscreen) Width() proxy.PropDouble {
	return &proxy.ImplPropDouble{
		Impl: v,
		Name: "Width",
	}
}

// property Height d

func (v *interfaceTouchscreen) Height() proxy.PropDouble {
	return &proxy.ImplPropDouble{
		Impl: v,
		Name: "Height",
	}
}

// property Name s

func (v *interfaceTouchscreen) Name() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Name",
	}
}

// property Serial s

func (v *interfaceTouchscreen) Serial() proxy.PropString {
	return &proxy.ImplPropString{
		Impl: v,
		Name: "Serial",
	}
}

type Touchpad interface {
	touchpad // interface org.deepin.dde.InputDevices1.Touchpad
	proxy.Object
}

type objectTouchpad struct {
	interfaceTouchpad // interface org.deepin.dde.InputDevices1.Touchpad
	proxy.ImplObject
}

func NewTouchpad(conn *dbus.Conn, path dbus.ObjectPath) (Touchpad, error) {
	if !path.IsValid() {
		return nil, errors.New("path is invalid")
	}
	obj := new(objectTouchpad)
	obj.ImplObject.Init_(conn, "org.deepin.dde.InputDevices1", path)
	return obj, nil
}

type touchpad interface {
	GoSetTouchpadEnable(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call
	SetTouchpadEnable(flags dbus.Flags, enabled bool) error
	IsExist() proxy.PropBool
	Enable() proxy.PropBool
}

type interfaceTouchpad struct{}

func (v *interfaceTouchpad) GetObject_() *proxy.ImplObject {
	return (*proxy.ImplObject)(unsafe.Pointer(v))
}

func (*interfaceTouchpad) GetInterfaceName_() string {
	return "org.deepin.dde.InputDevices1.Touchpad"
}

// method SetTouchpadEnable

func (v *interfaceTouchpad) GoSetTouchpadEnable(flags dbus.Flags, ch chan *dbus.Call, enabled bool) *dbus.Call {
	return v.GetObject_().Go_(v.GetInterfaceName_()+".SetTouchpadEnable", flags, ch, enabled)
}

func (v *interfaceTouchpad) SetTouchpadEnable(flags dbus.Flags, enabled bool) error {
	return (<-v.GoSetTouchpadEnable(flags, make(chan *dbus.Call, 1), enabled).Done).Err
}

// property isExist b

func (v *interfaceTouchpad) IsExist() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "isExist",
	}
}

// property Enable b

func (v *interfaceTouchpad) Enable() proxy.PropBool {
	return &proxy.ImplPropBool{
		Impl: v,
		Name: "Enable",
	}
}
